/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.vc.VcResultCollection;
import com.kingdee.eas.base.vc.VcResultFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.AccountTypeEnum;
import com.kingdee.eas.fi.cas.BankBalanceCondition;
import com.kingdee.eas.fi.cas.BankStatementCollection;
import com.kingdee.eas.fi.cas.BankStatementFactory;
import com.kingdee.eas.fi.cas.BankStatementInfo;
import com.kingdee.eas.fi.cas.BankStmtBookReportInfo;
import com.kingdee.eas.fi.cas.CashCommonException;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.IBankStatement;
import com.kingdee.eas.fi.cas.IJournal;
import com.kingdee.eas.fi.cas.IJournalBalance;
import com.kingdee.eas.fi.cas.JournalBalanceCollection;
import com.kingdee.eas.fi.cas.JournalBalanceFactory;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.OutstandingCondition;
import com.kingdee.eas.fi.cas.app.AbstractBankBalanceAdjustmentControllerBean;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class BankBalanceAdjustmentControllerBean
extends AbstractBankBalanceAdjustmentControllerBean {
    private Logger logger = Logger.getLogger(BankBalanceAdjustmentControllerBean.class);

    @Override
    protected IObjectCollection _getUnmatchedBankJournalCollection(Context ctx, IObjectPK companyPK, IObjectPK bankPK, IObjectPK currencyPK, IObjectPK periodPK) throws BOSException, EASBizException {
        PeriodInfo periodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo(periodPK);
        Date endDate = new Date(periodInfo.getEndDate().getTime());
        EntityViewInfo view = this.getUnmatchedEntityView(ctx, companyPK, bankPK, currencyPK, null, endDate, false, true);
        view.getSelector().add(new SelectorItemInfo("settlementType.name"));
        view.getSelector().add(new SelectorItemInfo("voucherType.name"));
        JournalCollection journals = null;
        IJournal iJournal = JournalFactory.getLocalInstance(ctx);
        journals = iJournal.getJournalCollection(view);
        return journals;
    }

    @Override
    protected IObjectCollection _getUnmatchedBankStatementCollection(Context ctx, IObjectPK companyPK, IObjectPK bankPK, IObjectPK currencyPK, IObjectPK periodPK) throws BOSException, EASBizException {
        PeriodInfo periodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo(periodPK);
        Date endDate = new Date(periodInfo.getEndDate().getTime());
        EntityViewInfo view = this.getUnmatchedEntityView(ctx, companyPK, bankPK, currencyPK, null, endDate, false, true);
        view.getSelector().add(new SelectorItemInfo("settleType.name"));
        view.getSelector().add(new SelectorItemInfo("settleNumber"));
        BankStatementCollection stmts = null;
        IBankStatement iStmt = BankStatementFactory.getLocalInstance(ctx);
        stmts = iStmt.getBankStatementCollection(view);
        return stmts;
    }

    private EntityViewInfo getUnmatchedEntityView(Context ctx, IObjectPK companyPK, IObjectPK bankPK, IObjectPK currencyPK, java.util.Date fromDate, java.util.Date endDate, boolean fOnlyAmt, boolean isNeedShare) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        AccountBankInfo info = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo(bankPK);
        HashSet<String> bankSet = new HashSet<String>();
        bankSet.add(bankPK.toString());
        HashSet<String> companySet = new HashSet<String>();
        companySet.add(companyPK.toString());
        if (CashHelper.isShareBalanceOfAcctCompany(ctx, info, companyPK.toString()) && isNeedShare) {
            EntityViewInfo view2 = new EntityViewInfo();
            FilterInfo filter2 = new FilterInfo();
            filter2.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)info.getBankAccountNumber(), CompareType.EQUALS));
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("company.id"));
            selector.add(new SelectorItemInfo("company.name"));
            selector.add(new SelectorItemInfo("company.number"));
            view2.setSelector(selector);
            view2.setFilter(filter2);
            AccountBankCollection acctColl = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view2);
            for (int i = 0; i < acctColl.size(); ++i) {
                AccountBankInfo tmp = acctColl.get(i);
                bankSet.add(tmp.getId().toString());
                companySet.add(tmp.getCompany().getId().toString());
            }
        }
        items.add(new FilterItemInfo("company.id", companySet, CompareType.INCLUDE));
        items.add(new FilterItemInfo("accountBank.id", bankSet, CompareType.INCLUDE));
        items.add(new FilterItemInfo("currency.id", (Object)currencyPK.toString()));
        if (fromDate != null) {
            items.add(new FilterItemInfo("createDate", (Object)fromDate, CompareType.GREATER_EQUALS));
        }
        items.add(new FilterItemInfo("createDate", (Object)endDate, CompareType.LESS_EQUALS));
        items.add(new FilterItemInfo("verifyStatus", (Object)"0"));
        if (fromDate != null) {
            Set idSet = this.getInResult(ctx, fromDate, endDate, bankSet);
            if (idSet != null & idSet.size() > 0) {
                items.add(new FilterItemInfo("verifyStatus", (Object)"0", CompareType.NOTEQUALS));
                items.add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
                filter.setMaskString("#0 and #1 and #2 and #3 and #4 and (#5 or (#6 and #7))");
            } else {
                filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5");
            }
        } else {
            boolean CS125 = false;
            CS125 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS125", companyPK);
            if (!CS125) {
                items.add(new FilterItemInfo("verifyStatus", (Object)"0", CompareType.NOTEQUALS));
                items.add(new FilterItemInfo("relatedBizDate", (Object)endDate, CompareType.GREATER));
                filter.setMaskString("#0 and #1 and #2 and #3 and (#4 or (#5 and #6))");
            } else {
                filter.setMaskString("#0 and #1 and #2 and #3 and #4");
            }
        }
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("isDebit"));
        view.getSelector().add(new SelectorItemInfo("description"));
        view.getSelector().add(new SelectorItemInfo("company.id"));
        view.getSelector().add(new SelectorItemInfo("company.name"));
        view.getSelector().add(new SelectorItemInfo("company.number"));
        view.getSelector().add(new SelectorItemInfo("debitAmount"));
        view.getSelector().add(new SelectorItemInfo("creditAmount"));
        view.getSelector().add("*");
        if (!fOnlyAmt) {
            view.getSelector().add(new SelectorItemInfo("createDate"));
            view.getSorter().add(new SorterItemInfo("createDate"));
        }
        return view;
    }

    @Override
    protected IObjectCollection _getUnreachedEntprCollection(Context ctx, IObjectPK companyPK, IObjectPK bankPK, IObjectPK currencyPK, IObjectPK periodPK) throws BOSException, EASBizException {
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (IObjectPK)companyPK);
        Date startDate = new Date(startPeriod.getBeginDate().getTime());
        EntityViewInfo view = this.getUnreachedEntityView(companyPK, bankPK, currencyPK, startDate, false);
        view.getSelector().add(new SelectorItemInfo("settleType.name"));
        view.getSorter().add(new SorterItemInfo("settleNumber"));
        BankStatementCollection stmts = null;
        IBankStatement iStmt = BankStatementFactory.getLocalInstance(ctx);
        stmts = iStmt.getBankStatementCollection(view);
        return stmts;
    }

    private EntityViewInfo getUnreachedEntityView(IObjectPK companyPK, IObjectPK bankPK, IObjectPK currencyPK, Date endDate, boolean fOnlyAmt) {
        return this.getUnreachedEntityView(companyPK, bankPK, currencyPK, endDate, fOnlyAmt, false);
    }

    private EntityViewInfo getUnreachedEntityView(IObjectPK companyPK, IObjectPK bankPK, IObjectPK currencyPK, Date endDate, boolean fOnlyAmt, boolean isInited) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("company.id", (Object)companyPK.toString()));
        items.add(new FilterItemInfo("accountBank.id", (Object)bankPK.toString()));
        items.add(new FilterItemInfo("currency.id", (Object)currencyPK.toString()));
        items.add(new FilterItemInfo("createDate", (Object)endDate, CompareType.LESS));
        if (!isInited) {
            items.add(new FilterItemInfo("verifyStatus", (Object)"0"));
        }
        if (fOnlyAmt) {
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("isDebit"));
            view.getSelector().add(new SelectorItemInfo("debitAmount"));
            view.getSelector().add(new SelectorItemInfo("creditAmount"));
            view.getSelector().add(new SelectorItemInfo("settlementType.name"));
            view.getSelector().add(new SelectorItemInfo("settleType.name"));
            view.getSelector().add(new SelectorItemInfo("*"));
        } else {
            view.getSelector().add(new SelectorItemInfo("createDate"));
            view.getSelector().add(new SelectorItemInfo("description"));
            view.getSelector().add(new SelectorItemInfo("debitAmount"));
            view.getSelector().add(new SelectorItemInfo("creditAmount"));
            view.getSelector().add(new SelectorItemInfo("settlementType.name"));
            view.getSelector().add(new SelectorItemInfo("settleType.name"));
            view.getSelector().add(new SelectorItemInfo("*"));
            view.getSorter().add(new SorterItemInfo("createDate"));
        }
        view.setFilter(filter);
        return view;
    }

    @Override
    protected IObjectCollection _getUnreachedBankCollection(Context ctx, IObjectPK companyPK, IObjectPK bankPK, IObjectPK currencyPK, IObjectPK periodPK) throws BOSException, EASBizException {
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (IObjectPK)companyPK);
        Date startDate = new Date(startPeriod.getBeginDate().getTime());
        EntityViewInfo view = this.getUnreachedEntityView(companyPK, bankPK, currencyPK, startDate, false);
        view.getSelector().add(new SelectorItemInfo("settlementType.name"));
        view.getSelector().add(new SelectorItemInfo("voucherType.name"));
        view.getSorter().add(new SorterItemInfo("voucherNumber"));
        JournalCollection journals = null;
        IJournal iJournal = JournalFactory.getLocalInstance(ctx);
        journals = iJournal.getJournalCollection(view);
        return journals;
    }

    @Override
    protected IObjectCollection _getOutstandingBankJournalCollection(Context ctx, OutstandingCondition condition) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectCollection _getOutstandingBankStatementCollection(Context ctx, OutstandingCondition condition) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected BankStmtBookReportInfo _getBalanceReport(Context ctx, BankBalanceCondition condition) throws BOSException, EASBizException {
        this.checkBalanceCondition(condition);
        if (condition.isIsForInit()) {
            return this.getInitReport(ctx, condition);
        }
        return this.getRuntimeReport(ctx, condition);
    }

    private BankStmtBookReportInfo getRuntimeReport(Context ctx, BankBalanceCondition condition) throws BOSException, EASBizException {
        BankStmtBookReportInfo rptInfo = new BankStmtBookReportInfo();
        BigDecimal stmtAmt = SysConstant.BIGZERO;
        BigDecimal bookAmt = SysConstant.BIGZERO;
        BigDecimal stmtDebit = SysConstant.BIGZERO;
        BigDecimal stmtCredit = SysConstant.BIGZERO;
        BigDecimal bookDebit = SysConstant.BIGZERO;
        BigDecimal bookCredit = SysConstant.BIGZERO;
        ObjectUuidPK companyPK = new ObjectUuidPK(condition.getCompanyInfo().getId());
        ObjectUuidPK bankPK = new ObjectUuidPK(condition.getBankId());
        ObjectUuidPK currencyPK = new ObjectUuidPK(condition.getCurrencyId());
        java.util.Date endDate = null;
        java.util.Date fromDate = null;
        if (condition.getPeriodId() == null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(condition.getFromDate());
            cal.set(cal.get(1), cal.get(2) - 1, 1);
            fromDate = cal.getTime();
            endDate = condition.getEndDate();
        } else {
            ObjectUuidPK periodPK = new ObjectUuidPK(condition.getPeriodId());
            PeriodInfo periodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)periodPK);
            endDate = new Date(periodInfo.getEndDate().getTime());
        }
        boolean fDetail = condition.isIsDetail();
        stmtAmt = this.getPeriodEndBalance(ctx, condition, AccountTypeEnum.ACCTSTATEMENT);
        bookAmt = this.getPeriodEndBalance(ctx, condition, AccountTypeEnum.BANKACCOUNT);
        this.logger.info((Object)("EndBlanace: journal = " + bookAmt + ", stmt = " + stmtAmt));
        EntityViewInfo view = this.getUnmatchedEntityView(ctx, (IObjectPK)companyPK, (IObjectPK)bankPK, (IObjectPK)currencyPK, fromDate, endDate, !fDetail, true);
        EntityViewInfo stmtView = (EntityViewInfo)view.clone();
        stmtView.getSelector().add(new SelectorItemInfo("settleNumber"));
        stmtView.getSelector().add(new SelectorItemInfo("settleType.name"));
        stmtView.getSorter().add(new SorterItemInfo("settleNumber"));
        IBankStatement iStmt = BankStatementFactory.getLocalInstance(ctx);
        BankStatementCollection stmts = iStmt.getBankStatementCollection(stmtView);
        if (stmts != null && !stmts.isEmpty()) {
            BankStatementInfo stmtInfo = null;
            int k = stmts.size();
            for (int j = 0; j < k; ++j) {
                stmtInfo = stmts.get(j);
                if (stmtInfo.isIsDebit()) {
                    if (stmtInfo.getDebitAmount() == null) continue;
                    stmtDebit = stmtDebit.add(stmtInfo.getDebitAmount());
                    continue;
                }
                if (stmtInfo.getCreditAmount() == null) continue;
                stmtCredit = stmtCredit.add(stmtInfo.getCreditAmount());
            }
            stmtInfo = null;
        }
        EntityViewInfo jnlView = (EntityViewInfo)view.clone();
        jnlView.getSelector().add(new SelectorItemInfo("settlementNumber"));
        jnlView.getSelector().add(new SelectorItemInfo("settlementType.name"));
        jnlView.getSelector().add(new SelectorItemInfo("voucherNumber"));
        jnlView.getSelector().add(new SelectorItemInfo("voucherType.name"));
        jnlView.getSorter().add(new SorterItemInfo("voucherNumber"));
        IJournal iJournal = JournalFactory.getLocalInstance(ctx);
        JournalCollection journals = iJournal.getJournalCollection(jnlView);
        if (journals != null && !journals.isEmpty()) {
            JournalInfo journalInfo = null;
            int k = journals.size();
            for (int j = 0; j < k; ++j) {
                journalInfo = journals.get(j);
                if (journalInfo.isIsDebit()) {
                    bookDebit = bookDebit.add(journalInfo.getDebitAmount());
                    continue;
                }
                bookCredit = bookCredit.add(journalInfo.getCreditAmount());
            }
            journalInfo = null;
        }
        rptInfo.setBankBookAmt(bookAmt);
        rptInfo.setBankStmtAmt(stmtAmt);
        rptInfo.setBankGotAmt(stmtCredit);
        rptInfo.setBankPayedAmt(stmtDebit);
        rptInfo.setEntprGotAmt(bookDebit);
        rptInfo.setEntprPayedAmt(bookCredit);
        rptInfo.setBanks((IObjectCollection)journals);
        rptInfo.setEntprs((IObjectCollection)stmts);
        return rptInfo;
    }

    private BigDecimal getPeriodEndBalance(Context ctx, BankBalanceCondition condition, AccountTypeEnum type) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection cn;
        BigDecimal credit;
        BigDecimal debit;
        BigDecimal amt;
        block24: {
            AccountBankCollection coll;
            FilterInfo filter;
            SelectorItemCollection selector;
            EntityViewInfo view;
            long endlong = 0L;
            if (condition.getPeriodId() == null) {
                endlong = condition.getEndDate().getTime();
            } else {
                ObjectUuidPK periodPK = new ObjectUuidPK(condition.getPeriodId());
                PeriodInfo periodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)periodPK);
                endlong = periodInfo.getEndDate().getTime();
            }
            Timestamp endstamp = new Timestamp(endlong);
            amt = this.getInitAmt(ctx, condition, type);
            debit = SysConstant.BIGZERO;
            credit = SysConstant.BIGZERO;
            CompanyOrgUnitInfo company = condition.getCompanyInfo();
            AccountBankInfo bankInfo = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(condition.getBankId()));
            String sql = null;
            if (type.getValue() == 3) {
                if (bankInfo.getShareType().getValue() != 0) {
                    view = new EntityViewInfo();
                    selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("id"));
                    selector.add(new SelectorItemInfo("company.id"));
                    view.setSelector(selector);
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)bankInfo.getBankAccountNumber(), CompareType.EQUALS));
                    view.setFilter(filter);
                    coll = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
                    StringBuffer companyString = new StringBuffer();
                    StringBuffer bankString = new StringBuffer();
                    for (int i = 0; i < coll.size(); ++i) {
                        AccountBankInfo tmp = coll.get(i);
                        if (i == 0) {
                            bankString.append("'" + tmp.getId().toString() + "'");
                            companyString.append("'" + tmp.getCompany().getId().toString() + "'");
                            continue;
                        }
                        bankString.append(",'" + tmp.getId().toString() + "'");
                        companyString.append(",'" + tmp.getCompany().getId().toString() + "'");
                    }
                    sql = "select sum(FDebitAmount) Fdebit, sum(FCreditAmount) FCredit from  t_cas_bankstatement where FCompanyId in (" + companyString.toString() + ") and FAccountBankId in ( " + bankString.toString() + ") and FCurrencyId = ? and FPeriodId IS NOT NULL and FCreateDate <= ?";
                } else {
                    sql = "select sum(FDebitAmount) Fdebit, sum(FCreditAmount) FCredit from  t_cas_bankstatement where FCompanyId = ? and FAccountBankId = ? and FCurrencyId = ? and FPeriodId IS NOT NULL and FCreateDate <= ?";
                    company = bankInfo.getCompany();
                }
            } else if (type.getValue() == 2) {
                if (bankInfo.getShareType().getValue() != 0) {
                    view = new EntityViewInfo();
                    selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("id"));
                    selector.add(new SelectorItemInfo("company.id"));
                    view.setSelector(selector);
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)bankInfo.getBankAccountNumber(), CompareType.EQUALS));
                    view.setFilter(filter);
                    coll = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
                    StringBuffer companyString = new StringBuffer();
                    StringBuffer bankString = new StringBuffer();
                    for (int i = 0; i < coll.size(); ++i) {
                        AccountBankInfo tmp = coll.get(i);
                        if (i == 0) {
                            bankString.append("'" + tmp.getId().toString() + "'");
                            companyString.append("'" + tmp.getCompany().getId().toString() + "'");
                            continue;
                        }
                        bankString.append(",'" + tmp.getId().toString() + "'");
                        companyString.append(",'" + tmp.getCompany().getId().toString() + "'");
                    }
                    sql = "select sum(FDebitAmount) Fdebit, sum(FCreditAmount) FCredit from  t_cas_Journal where FType = 2 and FCompanyId in (" + companyString.toString() + ") and  FAccountBankID in (" + bankString.toString() + ") and FCurrencyId = ?  and FPeriodId IS NOT NULL and FCreateDate <= ?";
                } else {
                    sql = "select sum(FDebitAmount) Fdebit, sum(FCreditAmount) FCredit from  t_cas_Journal where FType = 2 and FCompanyId = ? and  FAccountBankID = ? and FCurrencyId = ?  and FPeriodId IS NOT NULL and FCreateDate <= ?";
                }
            }
            cn = null;
            pstmt = null;
            rs = null;
            try {
                cn = this.getConnection(ctx);
                pstmt = cn.prepareStatement(sql);
                if (bankInfo.getShareType().getValue() != 0) {
                    pstmt.setString(1, condition.getCurrencyId());
                    pstmt.setTimestamp(2, endstamp);
                } else {
                    pstmt.setString(1, company.getId().toString());
                    pstmt.setString(2, condition.getBankId());
                    pstmt.setString(3, condition.getCurrencyId());
                    pstmt.setTimestamp(4, endstamp);
                }
                rs = pstmt.executeQuery();
                if (!rs.next()) break block24;
                if (rs.getBigDecimal(1) != null) {
                    debit = rs.getBigDecimal(1);
                }
                if (rs.getBigDecimal(2) != null) {
                    credit = rs.getBigDecimal(2);
                }
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pstmt, (Connection)cn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)cn);
        if (type.getValue() == 3) {
            amt = amt.add(credit).subtract(debit);
        } else if (type.getValue() == 2) {
            amt = amt.add(debit).subtract(credit);
        }
        return amt;
    }

    private BankStmtBookReportInfo getInitReport(Context ctx, BankBalanceCondition condition) throws BOSException, EASBizException {
        BankStmtBookReportInfo rptInfo = new BankStmtBookReportInfo();
        BigDecimal stmtAmt = SysConstant.BIGZERO;
        BigDecimal bookAmt = SysConstant.BIGZERO;
        BigDecimal stmtDebit = SysConstant.BIGZERO;
        BigDecimal stmtCredit = SysConstant.BIGZERO;
        BigDecimal bookDebit = SysConstant.BIGZERO;
        BigDecimal bookCredit = SysConstant.BIGZERO;
        ObjectUuidPK companyPK = new ObjectUuidPK(condition.getCompanyInfo().getId());
        ObjectUuidPK bankPK = new ObjectUuidPK(condition.getBankId());
        ObjectUuidPK currencyPK = new ObjectUuidPK(condition.getCurrencyId());
        ObjectUuidPK periodPK = new ObjectUuidPK(condition.getPeriodId());
        PeriodInfo periodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)periodPK);
        Date beginDate = new Date(periodInfo.getBeginDate().getTime());
        boolean fDetail = condition.isIsDetail();
        stmtAmt = this.getInitAmt(ctx, condition, AccountTypeEnum.ACCTSTATEMENT);
        bookAmt = this.getInitAmt(ctx, condition, AccountTypeEnum.BANKACCOUNT);
        EntityViewInfo view = this.getUnreachedEntityView((IObjectPK)companyPK, (IObjectPK)bankPK, (IObjectPK)currencyPK, beginDate, !fDetail, true);
        IBankStatement iStmt = BankStatementFactory.getLocalInstance(ctx);
        BankStatementCollection stmts = iStmt.getBankStatementCollection(view);
        if (stmts != null && !stmts.isEmpty()) {
            BankStatementInfo stmtInfo = null;
            int k = stmts.size();
            for (int j = 0; j < k; ++j) {
                stmtInfo = stmts.get(j);
                stmtDebit = stmtDebit.add(stmtInfo.getDebitAmount());
                stmtCredit = stmtCredit.add(stmtInfo.getCreditAmount());
            }
        }
        view.getSelector().add(new SelectorItemInfo("settlementType.name"));
        view.getSelector().add(new SelectorItemInfo("voucherType.name"));
        IJournal iJournal = JournalFactory.getLocalInstance(ctx);
        JournalCollection journals = iJournal.getJournalCollection(view);
        if (journals != null && !journals.isEmpty()) {
            JournalInfo journalInfo = null;
            int k = journals.size();
            for (int j = 0; j < k; ++j) {
                journalInfo = journals.get(j);
                bookDebit = bookDebit.add(journalInfo.getDebitAmount());
                bookCredit = bookCredit.add(journalInfo.getCreditAmount());
            }
        }
        rptInfo.setBankBookAmt(bookAmt);
        rptInfo.setBankStmtAmt(stmtAmt);
        rptInfo.setBankGotAmt(stmtCredit);
        rptInfo.setBankPayedAmt(stmtDebit);
        rptInfo.setEntprGotAmt(bookDebit);
        rptInfo.setEntprPayedAmt(bookCredit);
        rptInfo.setBanks((IObjectCollection)journals);
        rptInfo.setEntprs((IObjectCollection)stmts);
        return rptInfo;
    }

    private BigDecimal getInitAmt(Context ctx, BankBalanceCondition condition, AccountTypeEnum type) throws BOSException, EASBizException {
        BigDecimal amt = SysConstant.BIGZERO;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("isInit", (Object)"1"));
        AccountBankInfo bankInfo = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(condition.getBankId()));
        if (type.getValue() == 2 || type.getValue() == 3) {
            if (bankInfo.getShareType().getValue() == 1) {
                EntityViewInfo shareView = new EntityViewInfo();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("company.id"));
                shareView.setSelector(selector);
                FilterInfo sharedFilter = new FilterInfo();
                sharedFilter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)bankInfo.getBankAccountNumber(), CompareType.EQUALS));
                shareView.setFilter(sharedFilter);
                AccountBankCollection coll = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(shareView);
                HashSet<String> companySet = new HashSet<String>();
                HashSet<String> bankSet = new HashSet<String>();
                for (int i = 0; i < coll.size(); ++i) {
                    AccountBankInfo tmp = coll.get(i);
                    companySet.add(tmp.getCompany().getId().toString());
                    bankSet.add(tmp.getId().toString());
                }
                items.add(new FilterItemInfo("company.id", companySet, CompareType.INCLUDE));
                items.add(new FilterItemInfo("accountBank.id", bankSet, CompareType.INCLUDE));
            } else {
                items.add(new FilterItemInfo("company.id", (Object)condition.getCompanyInfo().getId().toString()));
                items.add(new FilterItemInfo("accountBank.id", (Object)condition.getBankId()));
            }
        } else {
            items.add(new FilterItemInfo("company.id", (Object)bankInfo.getCompany().getId().toString()));
            items.add(new FilterItemInfo("accountBank.id", (Object)condition.getBankId()));
        }
        items.add(new FilterItemInfo("currency.id", (Object)condition.getCurrencyId()));
        items.add(new FilterItemInfo("type", (Object)String.valueOf(type.getValue())));
        view.getSelector().add(new SelectorItemInfo("monthStartAmt"));
        IJournalBalance iBalance = JournalBalanceFactory.getLocalInstance(ctx);
        JournalBalanceCollection balances = iBalance.getJournalBalanceCollection(view);
        if (balances != null && balances.size() > 0) {
            for (int i = 0; i < balances.size(); ++i) {
                amt = i == 0 ? ((amt = balances.get(0).getMonthStartAmt()) == null ? SysConstant.BIGZERO : amt) : amt.add(balances.get(i).getMonthStartAmt());
            }
        }
        this.logger.info((Object)((Object)((Object)type) + " Init Amt:" + amt));
        return amt;
    }

    private void checkBalanceCondition(BankBalanceCondition condition) throws EASBizException {
        if (condition.getCompanyInfo() == null || StringUtils.isEmpty((String)condition.getCompanyInfo().getId().toString())) {
            throw new CashCommonException(CashCommonException.NULL_COMPANY);
        }
        if (StringUtils.isEmpty((String)condition.getBankId())) {
            throw new CashCommonException(CashCommonException.NULL_BANK);
        }
        if (StringUtils.isEmpty((String)condition.getCurrencyId())) {
            throw new CashCommonException(CashCommonException.NULL_CURRENCY);
        }
        if (StringUtils.isEmpty((String)condition.getPeriodId()) && condition.getEndDate() == null) {
            throw new CashCommonException(CashCommonException.NULL_PERIOD);
        }
    }

    private Set getInResult(Context ctx, java.util.Date fromDate, java.util.Date endDate, Set AccountBankIdSet) throws BOSException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(endDate);
        cal.set(cal.get(1), cal.get(2), cal.get(5), 23, 59, 59);
        java.util.Date utilEndDate = cal.getTime();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("accountBank.id", (Object)AccountBankIdSet, CompareType.INCLUDE));
        items.add(new FilterItemInfo("createTime", (Object)utilEndDate, CompareType.GREATER));
        items.add(new FilterItemInfo("createDate", (Object)fromDate, CompareType.GREATER_EQUALS));
        items.add(new FilterItemInfo("createDate", (Object)endDate, CompareType.LESS_EQUALS));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("bizObjectId"));
        view.setFilter(filter);
        view.setSelector(selector);
        HashSet<String> IdSet = new HashSet<String>();
        VcResultCollection coll = VcResultFactory.getLocalInstance((Context)ctx).getVcResultCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            IdSet.add(coll.get(i).getBizObjectId().toString());
        }
        return IdSet;
    }
}

