/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.app.AbstractBankBalanceAdjustmentUIFacadeControllerBean;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.IContextHelper;
import com.kingdee.eas.fm.common.util.FetchParamHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class BankBalanceAdjustmentUIFacadeControllerBean
extends AbstractBankBalanceAdjustmentUIFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.BankBalanceAdjustmentUIFacadeControllerBean");

    @Override
    protected Map _fetchData(Context ctx, Map paramMap) throws BOSException, EASBizException {
        CompanyOrgUnitInfo currenctCompany = this.getCurrencyCompany(ctx, paramMap);
        this.getCS018Value(ctx, paramMap, currenctCompany);
        this.getCompany(ctx, paramMap, currenctCompany);
        this.getStartPeriod(ctx, paramMap);
        this.getCurrentPeriod(ctx, paramMap);
        this.getAccountBank(ctx, paramMap);
        this.getCurrency(ctx, paramMap);
        PeriodInfo currentPeriod = (PeriodInfo)paramMap.get("currPeriodInfo");
        FetchParamHelper fph = new FetchParamHelper(ctx);
        fph.setCurrentCompany((CompanyOrgUnitInfo)paramMap.get("companyInfo"));
        if (!EmptyUtil.isEmpty((CoreBaseInfo)currentPeriod)) {
            paramMap.put("acctTableDefault", fph.getAcctTableId(ctx, currentPeriod.getBeginDate(), (Date)currentPeriod.getEndDate()));
        }
        return paramMap;
    }

    private void getCurrency(Context ctx, Map paramMap) throws BOSException, EASBizException {
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyCollection currencyCollection = iCurrency.getCurrencyCollection(true);
        paramMap.put("currencyCollection", currencyCollection);
    }

    private void getCompany(Context ctx, Map paramMap, CompanyOrgUnitInfo currenctCompany) throws BOSException, EASBizException {
        if (paramMap.get("paramCompanyID") == null) {
            paramMap.put("companyInfo", currenctCompany);
        } else {
            paramMap.put("companyInfo", CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(paramMap.get("paramCompanyID").toString())));
        }
    }

    private void getCS018Value(Context ctx, Map paramMap, CompanyOrgUnitInfo currenctCompany) {
        int type = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("CS018", (IObjectPK)new ObjectUuidPK(currenctCompany.getId()));
        paramMap.put("CS018", new Integer(type));
    }

    private CompanyOrgUnitInfo getCurrencyCompany(Context ctx, Map paramMap) {
        CompanyOrgUnitInfo currenctCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        paramMap.put("currentCompany", currenctCompany);
        return currenctCompany;
    }

    private void getStartPeriod(Context ctx, Map paramMap) throws BOSException, EASBizException {
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)paramMap.get("companyInfo")));
        paramMap.put("startPeriod", startPeriod);
    }

    private void getCurrentPeriod(Context ctx, Map paramMap) throws BOSException, EASBizException {
        PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)paramMap.get("companyInfo")));
        paramMap.put("currPeriodInfo", currPeriodInfo);
    }

    private void getAccountBank(Context ctx, Map paramMap) throws BOSException, EASBizException {
        IContextHelper ctxHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK userPK = new ObjectUuidPK(ctxHelper.getCurrentUser().getId());
        ObjectUuidPK orgPK = new ObjectUuidPK(ctxHelper.getCurrentCompany().getId());
        IPermissionServiceProvider provider = PermissionServiceProviderFactory.getLocalInstance((Context)ctx);
        String rule = provider.getPermissionRule((IObjectPK)userPK, (IObjectPK)orgPK, "bd_assistant_accountBank_view");
        EntityViewInfo evi = new EntityViewInfo();
        try {
            if (rule != null) {
                evi = new EntityViewInfo(rule);
            }
        }
        catch (ParserException e) {
            logger.error((Object)e);
            evi = new EntityViewInfo();
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("*");
        selector.add("number");
        selector.add("name");
        selector.add("bankAccountNumber");
        selector.add("account.id");
        selector.add("account.number");
        selector.add("account.name");
        FilterInfo fi = new FilterInfo();
        if ((CompanyOrgUnitInfo)paramMap.get("companyInfo") != null) {
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)((CompanyOrgUnitInfo)paramMap.get("companyInfo")).getId().toString()));
        }
        fi.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        fi.getFilterItems().add(new FilterItemInfo("isBank", (Object)FMConstants.TRUE));
        fi.getFilterItems().add(new FilterItemInfo("shareType", (Object)0, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        if (!paramMap.containsKey("currentCompany")) {
            this.getCurrencyCompany(ctx, paramMap);
        }
        if (evi.getFilter() != null) {
            evi.getFilter().mergeFilter(fi, "and");
        } else {
            evi.setFilter(fi);
        }
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.getSorter().add(new SorterItemInfo("number"));
        AccountBankCollection acctBankCol = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(evi);
        paramMap.put("acctBankCol", acctBankCol);
    }

    @Override
    protected Map _fetchDataFilterUIInit(Context ctx, Map paramMap) throws BOSException, EASBizException {
        return paramMap;
    }

    @Override
    protected Map _fetchDataFilterUIVerify(Context ctx, Map verifyMap) throws BOSException, EASBizException {
        this.getAcctTableID(ctx, verifyMap);
        return verifyMap;
    }

    private void getAcctTableID(Context ctx, Map verifyMap) throws BOSException, EASBizException {
        FetchParamHelper fph = new FetchParamHelper(ctx);
        int beginYear = (Integer)verifyMap.get("beginYear");
        int beginPeriod = (Integer)verifyMap.get("beginMonth");
        int endYear = (Integer)verifyMap.get("endYear");
        int endPeriod = (Integer)verifyMap.get("endMonth");
        String acctTableID = fph.getAcctTableId(ctx, beginYear, beginPeriod, endYear, endPeriod);
        verifyMap.put("acctTableId", acctTableID);
    }
}

