/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BankBalanceAdjustmentFactory;
import com.kingdee.eas.fi.cas.BankBalanceAdjustmentUIFacadeFactory;
import com.kingdee.eas.fi.cas.BankBalanceCondition;
import com.kingdee.eas.fi.cas.BankStmtBookReportInfo;
import com.kingdee.eas.fi.cas.IBankBalanceAdjustment;
import com.kingdee.eas.fi.cas.app.AbstractBankBalanceAdjustmentWebFacadeControllerBean;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.utils.JournalWebUtil;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BankBalanceAdjustmentWebFacadeControllerBean
extends AbstractBankBalanceAdjustmentWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.BankBalanceAdjustmentWebFacadeControllerBean");
    public static final String CS018 = "CS018";

    @Override
    protected Map _getListPageInitData(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        HashMap<String, Object> data = new HashMap<String, Object>();
        try {
            this.doArrangeDefaultFIUnit_Currency(ctx, data, currentCompany);
            data.put("currancyColl", this._welcomepage_getCurrancyCollByOrg(ctx, currentCompany));
        }
        catch (EASBizException e) {
            e.printStackTrace();
            data.put("error", 1);
            data.put("msg", e.getMessage());
        }
        catch (BOSException e) {
            e.printStackTrace();
            data.put("error", 1);
            data.put("msg", e.getMessage());
        }
        return data;
    }

    @Override
    protected Map _getCurrencyOfpayBankAccount(Context ctx, String payBankAccountID) throws BOSException, EASBizException {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        HashMap<String, Object> changeContext = new HashMap<String, Object>();
        if (payBankAccountID == null) {
            return changeContext;
        }
        try {
            IAccountBank iAccountBank = AccountBankFactory.getLocalInstance((Context)ctx);
            SelectorItemCollection selectColl = new SelectorItemCollection();
            selectColl.add(new SelectorItemInfo("*"));
            selectColl.add(new SelectorItemInfo("currency.*"));
            AccountBankInfo accountBankInfo = iAccountBank.getAccountBankInfo((IObjectPK)new ObjectUuidPK(payBankAccountID), selectColl);
            CurrencyInfo currency = null;
            if (!EmptyUtil.isEmpty((CoreBaseInfo)accountBankInfo)) {
                if (accountBankInfo.isIsByCurrency()) {
                    currency = accountBankInfo.getCurrency();
                    changeContext.put("currencyEnable", "false");
                    CurrencyCollection currencyColl = new CurrencyCollection();
                    if (currency != null && currency.getId() != null && currency.getName() == null) {
                        currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId()));
                    }
                    currencyColl.add(currency);
                    changeContext.put("currancyColl", currencyColl);
                } else {
                    if (currentCompany == null) {
                        throw new Exception(CASWebUtil.getResource(ctx, "LoginOrgUnitIsNull"));
                    }
                    currency = currentCompany.getBaseCurrency();
                    changeContext.put("currencyEnable", "true");
                    changeContext.put("currancyColl", this._welcomepage_getCurrancyCollByOrg(ctx, currentCompany));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            changeContext.put("error", 1);
            changeContext.put("msg", e.getMessage());
        }
        return changeContext;
    }

    @Override
    protected Map _getBalanceAdjustData(Context ctx, String companyId, String accountBankId, String currencyId, String periodId) throws BOSException, EASBizException {
        HashMap<String, Object> model = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)companyId) || StringUtils.isEmpty((String)accountBankId) || StringUtils.isEmpty((String)currencyId) || StringUtils.isEmpty((String)periodId)) {
            model.put("error", 1);
            model.put("msg", "parameter is null.");
            return model;
        }
        BankBalanceCondition condition = null;
        Map paramMap = null;
        try {
            paramMap = this.initBaseData(ctx, companyId, accountBankId, currencyId, periodId);
            if (condition == null) {
                condition = new BankBalanceCondition();
            }
            CompanyOrgUnitInfo tmpCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            condition.setCompanyInfo(tmpCompany);
            condition.setIsForInit(true);
            condition.setBankId(accountBankId);
            condition.setCurrencyId(currencyId);
            condition.setPeriodId(periodId);
            IBankBalanceAdjustment iAdjustment = BankBalanceAdjustmentFactory.getLocalInstance(ctx);
            BankStmtBookReportInfo rptInfo = iAdjustment.getBalanceReport(condition);
            model.put("accountBank", paramMap.get("accountBank"));
            model.put("currencyInfo", paramMap.get("currencyInfo"));
            model.put("periodInfo", paramMap.get("periodInfo"));
            model.put(CS018, paramMap.get(CS018));
            model.put("rptInfo", rptInfo);
            model.put("entBalance", rptInfo.getBankBookAmt().doubleValue() + rptInfo.getBankGotAmt().doubleValue() - rptInfo.getBankPayedAmt().doubleValue());
            model.put("bankBalance", rptInfo.getBankStmtAmt().doubleValue() + rptInfo.getEntprGotAmt().doubleValue() - rptInfo.getEntprPayedAmt().doubleValue());
        }
        catch (EASBizException e2) {
            e2.printStackTrace();
            model.put("error", 1);
            model.put("msg", e2.getMessage());
        }
        catch (BOSException e2) {
            e2.printStackTrace();
            model.put("error", 1);
            model.put("msg", e2.getMessage());
        }
        return model;
    }

    @Override
    protected Map _getBalanceAdjustDetails(Context ctx, String companyId, String accounBankId, String currencyId, String periodId) throws BOSException, EASBizException {
        HashMap<String, Object> modelEnt = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)companyId) || StringUtils.isEmpty((String)accounBankId) || StringUtils.isEmpty((String)currencyId) || StringUtils.isEmpty((String)periodId)) {
            return modelEnt;
        }
        IObjectCollection bankUnreachedColl = null;
        IObjectCollection entprUnreachedColl = null;
        BankBalanceCondition condition = new BankBalanceCondition();
        CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
        companyInfo.setId(BOSUuid.read((String)companyId));
        condition.setCompanyInfo(companyInfo);
        condition.setBankId(accounBankId);
        condition.setCurrencyId(currencyId);
        condition.setPeriodId(periodId);
        condition.setIsForInit(true);
        condition.setIsDetail(true);
        try {
            IBankBalanceAdjustment iAdjustment = BankBalanceAdjustmentFactory.getLocalInstance(ctx);
            BankStmtBookReportInfo rptInfo = iAdjustment.getBalanceReport(condition);
            CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
            modelEnt.put("precision", currencyInfo.getPrecision());
            bankUnreachedColl = rptInfo.getBanks();
            entprUnreachedColl = rptInfo.getEntprs();
            modelEnt.put("bankUnreachedColl", bankUnreachedColl);
            modelEnt.put("entprUnreachedColl", entprUnreachedColl);
        }
        catch (BOSException e) {
            e.printStackTrace();
            modelEnt.put("error", 1);
            modelEnt.put("msg", e.getMessage());
        }
        catch (EASBizException e) {
            e.printStackTrace();
            modelEnt.put("error", 1);
            modelEnt.put("msg", e.getMessage());
        }
        return modelEnt;
    }

    @Override
    protected Map _getBalanceAdjustDataByScheme(Context ctx, String companyId, String acountBankId, String currencyId, String periodId) throws BOSException, EASBizException {
        HashMap<String, Object> model = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)companyId) || StringUtils.isEmpty((String)acountBankId) || StringUtils.isEmpty((String)currencyId) || StringUtils.isEmpty((String)periodId)) {
            model.put("error", 1);
            model.put("msg", "parameter is null.");
            return model;
        }
        BankBalanceCondition condition = new BankBalanceCondition();
        Map paramMap = null;
        try {
            paramMap = this.initBaseData(ctx, companyId, acountBankId, currencyId, periodId);
            CompanyOrgUnitInfo tmpCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            condition.setCompanyInfo(tmpCompany);
            condition.setIsForInit(false);
            condition.setBankId(acountBankId);
            condition.setCurrencyId(currencyId);
            condition.setPeriodId(periodId);
            IBankBalanceAdjustment iAdjustment = BankBalanceAdjustmentFactory.getLocalInstance(ctx);
            BankStmtBookReportInfo rptInfo = iAdjustment.getBalanceReport(condition);
            model.put("accountBank", paramMap.get("accountBank"));
            model.put("currencyInfo", paramMap.get("currencyInfo"));
            model.put("periodInfo", paramMap.get("periodInfo"));
            model.put(CS018, paramMap.get(CS018));
            model.put("rptInfo", rptInfo);
            model.put("entBalance", rptInfo.getBankBookAmt().doubleValue() + rptInfo.getBankGotAmt().doubleValue() - rptInfo.getBankPayedAmt().doubleValue());
            model.put("bankBalance", rptInfo.getBankStmtAmt().doubleValue() + rptInfo.getEntprGotAmt().doubleValue() - rptInfo.getEntprPayedAmt().doubleValue());
        }
        catch (EASBizException e2) {
            e2.printStackTrace();
            model.put("error", 1);
            model.put("msg", e2.getMessage());
        }
        catch (BOSException e2) {
            e2.printStackTrace();
            model.put("error", 1);
            model.put("msg", e2.getMessage());
        }
        return model;
    }

    @Override
    protected Map _getBalanceAdjustDetailsByScheme(Context ctx, String companyId, String accountBankId, String currencyId, String periodId) throws BOSException, EASBizException {
        HashMap<String, Object> modelEnt = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)companyId) || StringUtils.isEmpty((String)accountBankId) || StringUtils.isEmpty((String)currencyId) || StringUtils.isEmpty((String)periodId)) {
            return modelEnt;
        }
        IObjectCollection bankUnreachedColl = null;
        IObjectCollection entprUnreachedColl = null;
        ObjectUuidPK companyPK = new ObjectUuidPK(companyId);
        ObjectUuidPK bankPK = new ObjectUuidPK(accountBankId);
        ObjectUuidPK periodPK = new ObjectUuidPK(periodId);
        ObjectUuidPK currencyPK = new ObjectUuidPK(currencyId);
        try {
            CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
            modelEnt.put("precision", currencyInfo.getPrecision());
            IBankBalanceAdjustment iAdjustment = BankBalanceAdjustmentFactory.getLocalInstance(ctx);
            bankUnreachedColl = iAdjustment.getUnmatchedBankJournalCollection((IObjectPK)companyPK, (IObjectPK)bankPK, (IObjectPK)currencyPK, (IObjectPK)periodPK);
            entprUnreachedColl = iAdjustment.getUnmatchedBankStatementCollection((IObjectPK)companyPK, (IObjectPK)bankPK, (IObjectPK)currencyPK, (IObjectPK)periodPK);
            modelEnt.put("bankUnreachedColl", bankUnreachedColl);
            modelEnt.put("entprUnreachedColl", entprUnreachedColl);
        }
        catch (BOSException e) {
            e.printStackTrace();
            modelEnt.put("error", 1);
            modelEnt.put("msg", e.getMessage());
        }
        catch (EASBizException e) {
            e.printStackTrace();
            modelEnt.put("error", 1);
            modelEnt.put("msg", e.getMessage());
        }
        return modelEnt;
    }

    private Map initBaseData(Context ctx, String companyId, String bankId, String currencyId, String periodId) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("account.name"));
        sic.add(new SelectorItemInfo("account.number"));
        sic.add(new SelectorItemInfo("account.acctName"));
        sic.add(new SelectorItemInfo("account.bankAccountNumber"));
        AccountBankInfo accountBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(bankId), sic);
        accountBank.setName(accountBank.getName() + " " + accountBank.getBankAccountNumber());
        accountBank.getAccount().setName(accountBank.getAccount().toString());
        CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
        PeriodInfo periodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(periodId));
        Map<String, CurrencyInfo> paramMap = new HashMap<String, Object>();
        paramMap.put("paramCompanyID", (CurrencyInfo)companyId);
        paramMap.put(CS018, (CurrencyInfo)new Integer(-1));
        paramMap = BankBalanceAdjustmentUIFacadeFactory.getLocalInstance(ctx).fetchData(paramMap);
        paramMap.put("accountBank", (CurrencyInfo)accountBank);
        paramMap.put("currencyInfo", currencyInfo);
        paramMap.put("periodInfo", (CurrencyInfo)periodInfo);
        return paramMap;
    }

    protected CompanyOrgUnitInfo doArrangeDefaultFIUnit_Currency(Context ctx, Map rstDataMap, CompanyOrgUnitInfo curCompany) throws BOSException, EASBizException {
        IPermission iPermisson;
        boolean flag;
        CompanyOrgUnitInfo selCompany = curCompany;
        AccountBankCollection acctBankColl = null;
        UserInfo curUser = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        selCompany = curCompany.isIsBizUnit() ? ((flag = (iPermisson = PermissionFactory.getLocalInstance((Context)ctx)).hasFunctionPermission((IObjectPK)new ObjectUuidPK(curUser.getId().toString()), (IObjectPK)new ObjectUuidPK(curCompany.getId().toString()), "cas_bankVcCheck_01view")) ? curCompany : this.getCompanyOrgUnitInfoByUserPermisson(ctx)) : this.getCompanyOrgUnitInfoByUserPermisson(ctx);
        if (selCompany != null && selCompany.isIsBizUnit()) {
            String strCompanyId = selCompany.getId().toString();
            acctBankColl = CASWebHelper.getAccountBankCollection(ctx, strCompanyId, true);
        }
        rstDataMap.put("defaultFIUnit", selCompany);
        rstDataMap.put("acctBankColl", acctBankColl);
        return selCompany;
    }

    private CurrencyCollection _welcomepage_getCurrancyCollByOrg(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        CtrlUnitInfo curCUInfo = company.getCU();
        if (curCUInfo == null || curCUInfo.getId() == null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("CU.id"));
            selector.add(new SelectorItemInfo("CU.number"));
            selector.add(new SelectorItemInfo("CU.name"));
            ObjectUuidPK orgUnitPK = new ObjectUuidPK(company.getId());
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)orgUnitPK, selector);
            curCUInfo = company.getCU();
        }
        String curCUID = curCUInfo.getId().toString();
        String currencyOql = "where CU.id = '" + curCUID + "'";
        CurrencyCollection currencyAllColl = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(currencyOql);
        CurrencyCollection currencyColl = new CurrencyCollection();
        for (int idx = currencyAllColl.size(); idx > 0; --idx) {
            try {
                JournalWebUtil.getExchange(ctx, company, currencyAllColl.get(idx), null, null);
                currencyColl.add(currencyAllColl.get(idx));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return currencyColl;
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitInfoByUserPermisson(Context ctx) throws EASBizException, BOSException {
        CompanyOrgUnitCollection companyColl = FMHelper.getUserOrgRangesWithRangeOfStart((Context)ctx, (String)"cas_bankVcCheck_01view", (boolean)false, (boolean)false, (boolean)false);
        if (companyColl.size() > 0) {
            return companyColl.get(0);
        }
        return null;
    }
}

