/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AbstractFMDataImport;
import com.kingdee.eas.fi.cas.IJournal;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.app.RecAndPayDataImportUtil2;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;

public class BankJournalDataImport
extends AbstractFMDataImport {
    String resourcePath = "com.kingdee.eas.fi.cas.JournalResource";
    private int lineNumber = 0;

    @Override
    protected ICoreBase _getController(Context ctx) throws BOSException, EASBizException {
        return JournalFactory.getLocalInstance(ctx);
    }

    @Override
    protected String getTemplateNumber() {
        return "BankJournal";
    }

    @Override
    protected CoreBaseInfo _transmit(Hashtable hsData, Context ctx) throws EASBizException, BOSException {
        JournalInfo journal = new JournalInfo();
        ObjectUuidPK ipk = null;
        this.prepareImport(ctx, (IObjectValue)journal, hsData);
        CompanyOrgUnitInfo company = null;
        Object companyData = this.getData(hsData, "company");
        if (companyData != null && companyData.toString().trim().length() > 0) {
            company = RecAndPayDataImportUtil2.getCompanyByNumber(ctx, (String)companyData);
        }
        if (company == null) {
            company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        }
        PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString()), (IObjectPK)new ObjectUuidPK(company.getId().toString()), "cas_bankbook_02addNew");
        PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString()), (IObjectPK)new ObjectUuidPK(company.getId().toString()), "cas_bankbook_07import");
        journal.setLineNo(this.lineNumber++);
        if (journal.getAccountBank() == null) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"accountBankNullOrNotExist", (Locale)ctx.getLocale()));
        }
        if (journal.getCurrency() == null) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"currencyException", (Locale)ctx.getLocale()));
        }
        if (journal.getCreateDate() == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"52_BankJournalDataImport", (Locale)ctx.getLocale()));
        }
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        Date createDate = journal.getCreateDate();
        if (createDate.before(periodInfo.getBeginDate())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"53_BankJournalDataImport", (Locale)ctx.getLocale()));
        }
        BigDecimal zero = FMConstants.ZERO;
        if (journal.getDebitAmount() == null) {
            journal.setDebitAmount(FMConstants.ZERO);
        }
        if (journal.getCreditAmount() == null) {
            journal.setCreditAmount(FMConstants.ZERO);
        }
        if (zero.compareTo(journal.getDebitAmount()) != 0 && zero.compareTo(journal.getCreditAmount()) != 0) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"debitCreditException", (Locale)ctx.getLocale()));
        }
        if (zero.compareTo(journal.getDebitAmount()) == 0 && zero.compareTo(journal.getCreditAmount()) == 0) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"debitCreditException2", (Locale)ctx.getLocale()));
        }
        Object data = this.getData(hsData, "accountBank");
        AccountBankInfo accountBank = this.getAccountBank(ctx, data, company.getId().toString());
        if (!accountBank.getCompany().getId().toString().equals(company.getId().toString())) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"accountNotCurCompany", (Locale)ctx.getLocale()));
        }
        if (accountBank.isIsClosed()) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"accountBankHasCancel", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "currency");
        CurrencyInfo curInfo = this.getCurrency(ctx, data);
        ICurrency cur = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyInfo accountCur = null;
        if (accountBank.isIsByCurrency() && !curInfo.equals((Object)(accountCur = (CurrencyInfo)cur.getValue((IObjectPK)(ipk = new ObjectUuidPK(accountBank.getCurrency().getId())))))) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"currencyNotDefault", (Locale)ctx.getLocale()));
        }
        BigDecimal debitAmount = journal.getDebitAmount();
        if ((debitAmount = debitAmount.setScale(curInfo.getPrecision(), 4)).compareTo(journal.getDebitAmount()) != 0) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"DebitAmountPrecisionError", (Locale)ctx.getLocale()));
        }
        BigDecimal creditAmount = journal.getCreditAmount();
        if ((creditAmount = creditAmount.setScale(curInfo.getPrecision(), 4)).compareTo(journal.getCreditAmount()) != 0) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"CreditAmountPrecisionError", (Locale)ctx.getLocale()));
        }
        journal.setCashier(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        journal.setSource(JournalSourceEnum.BYIMPORT);
        journal.setAccountBank(accountBank);
        journal.setCompany(accountBank.getCompany());
        journal.setAccountView(accountBank.getAccount());
        data = this.getData(hsData, "description");
        if (data != null && data.toString().trim().length() > 0) {
            if (data.toString().length() > 255) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"54_BankJournalDataImport", (Locale)ctx.getLocale()) + 255);
            }
            journal.setDescription(data.toString());
        }
        return journal;
    }

    @Override
    protected void _submit(CoreBaseInfo info, Context ctx) throws BOSException, EASBizException {
        IJournal j = (IJournal)this._getController(ctx);
        j.importFromDS((JournalInfo)info);
    }

    protected AccountBankInfo getAccountBank(Context ctx, Object data, String company) throws BOSException {
        if (data == null || data.toString().trim().length() == 0) {
            return null;
        }
        String number = data.toString().trim();
        IAccountBank acb = AccountBankFactory.getLocalInstance((Context)ctx);
        AccountBankCollection coll = acb.getAccountBankCollection("select * where number ='" + number + "' and company='" + company + "'");
        if (coll == null || coll.size() == 0) {
            String msgStr = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASHandResource", (String)"accountBankIsNot", (Locale)ctx.getLocale()), data);
            throw new BOSException(msgStr);
        }
        return coll.get(0);
    }
}

