/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountRefContrastCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.IAccountRefContrast;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.app.AbstractBankJournalFetchParamFacadeControllerBean;
import com.kingdee.eas.fi.cas.utils.FMHelper;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.IContextHelper;
import com.kingdee.eas.fm.common.util.FetchParamHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class BankJournalFetchParamFacadeControllerBean
extends AbstractBankJournalFetchParamFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.BankJournalFetchParamFacadeControllerBean");
    private CompanyOrgUnitInfo company;

    @Override
    protected Map _fetchParam(Context ctx, Map paramMap) throws BOSException, EASBizException {
        FetchParamHelper fph = new FetchParamHelper(ctx);
        this.company = fph.getCurrentComapny();
        CompanyOrgUnitCollection companyColl = new CompanyOrgUnitCollection();
        try {
            if (!FMHelper.checkCurrentCompany(ctx, this.company, "cas_bankbook_01view")) {
                companyColl = FMHelper.getUserOrgRangesWithRangeWhereStartPeriod(ctx, "cas_bankbook_01view");
                if (companyColl != null && companyColl.size() > 0) {
                    this.company = companyColl.get(0);
                }
            } else {
                companyColl.add(this.company);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        paramMap.put("UserOrgRanges", companyColl);
        paramMap.put("currentCompany", this.company);
        fph.setCurrentCompany(this.company);
        paramMap.put("companyId", this.company.getId().toString());
        paramMap.put("currentPeriod", fph.getCurrentPeriod());
        paramMap.put("currencyCollection", fph.getCurrenyCol());
        paramMap.put("bookType", Integer.valueOf(fph.getParamValue_StringType("CS001")));
        paramMap.put("CS003", fph.getParamValue_StringType("CS003"));
        paramMap.put("startPeriod", fph.getStartPeriod());
        AccountBankCollection acctBankCol = this.getAccountbankColl(ctx);
        paramMap.put("accountBanks", acctBankCol);
        paramMap.put("isStart", SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.company));
        boolean isShowLocalCurrency = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS003", (IObjectPK)new ObjectUuidPK(this.company.getId()));
        paramMap.put("isShowLocalCurrency", isShowLocalCurrency);
        if (this.company.getAccountTable() == null) {
            throw new FMException(FMException.HASNOACCTTABLE, new Object[]{this.company.getName()});
        }
        AccountTableInfo acctTable = AccountTableFactory.getLocalInstance((Context)ctx).getAccountTableInfo((IObjectPK)new ObjectUuidPK(this.company.getAccountTable().getId()));
        paramMap.put("acctTable", acctTable);
        String queryName = (String)paramMap.get("mainQueryPK");
        String uiClassName = (String)paramMap.get("uiClassName");
        paramMap.put("DefaultSolution", QuerySolutionFacadeFactory.getLocalInstance((Context)ctx).getDefaultSolution(uiClassName, queryName));
        return paramMap;
    }

    private AccountBankCollection getAccountbankColl(Context ctx) throws BOSException, EASBizException {
        IContextHelper ctxHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK userPK = new ObjectUuidPK(ctxHelper.getCurrentUser().getId());
        ObjectUuidPK orgPK = new ObjectUuidPK(ctxHelper.getCurrentCompany().getId());
        IPermissionServiceProvider provider = PermissionServiceProviderFactory.getLocalInstance((Context)ctx);
        String rule = provider.getPermissionRule((IObjectPK)userPK, (IObjectPK)orgPK, "bd_assistant_accountBank_view");
        EntityViewInfo evi = new EntityViewInfo();
        try {
            if (rule != null) {
                evi = new EntityViewInfo(rule);
            }
        }
        catch (ParserException e) {
            logger.error((Object)e);
            evi = new EntityViewInfo();
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("*");
        selector.add("number");
        selector.add("name");
        selector.add("bankAccountNumber");
        selector.add("account.id");
        selector.add("account.number");
        selector.add("account.name");
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.company.getId().toString()));
        fi.getFilterItems().add(new FilterItemInfo("isBank", (Object)FMConstants.TRUE));
        if (evi.getFilter() != null) {
            evi.getFilter().mergeFilter(fi, "and");
        } else {
            evi.setFilter(fi);
        }
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.getSorter().add(new SorterItemInfo("number"));
        AccountBankCollection acctBankCol = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(evi);
        for (int i = 0; i < acctBankCol.size(); ++i) {
            acctBankCol.get(i).setDisplayFormat("$number$ - $name$");
        }
        return acctBankCol;
    }

    @Override
    protected Map _fetchParamForFilterUI(Context ctx, Map paramMap) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _fetchParamForFilterUIVerify(Context ctx, Map verifyMap) throws BOSException, EASBizException {
        FetchParamHelper fph = new FetchParamHelper(ctx);
        this.company = verifyMap.containsKey("company") && !EmptyUtil.isEmpty((Object)verifyMap.containsKey("company")) ? (CompanyOrgUnitInfo)verifyMap.get("company") : fph.getCurrentComapny();
        verifyMap.put("actualAcctTableId", this.getActualAcctTableId(ctx, verifyMap));
        return verifyMap;
    }

    private String getActualAcctTableId(Context ctx, Map verifyMap) throws BOSException, EASBizException {
        String actualAcctTableId = "";
        int beginYear = (Integer)verifyMap.get("beginYear");
        int beginPeriod = (Integer)verifyMap.get("beginPeriod");
        int endYear = (Integer)verifyMap.get("endYear");
        int endPeriod = (Integer)verifyMap.get("endPeriod");
        Date beginDate = (Date)verifyMap.get("dateFrom");
        Date endDate = (Date)verifyMap.get("dateTo");
        actualAcctTableId = (Boolean)verifyMap.get("btnByPeriod") != false ? this.getActualAcctTable(ctx, this.company, beginYear, beginPeriod, endYear, endPeriod) : this.getActualAcctTable(ctx, this.company, beginDate, endDate);
        PeriodCollection col = PeriodUtils.getPeriodc((Context)ctx, (int)beginYear, (int)beginPeriod, (CompanyOrgUnitInfo)this.company);
        if (col.size() > 0) {
            verifyMap.put("beginPeriodParam", col.get(0));
        }
        if ((col = PeriodUtils.getPeriodc((Context)ctx, (int)endYear, (int)endPeriod, (CompanyOrgUnitInfo)this.company)).size() > 0) {
            verifyMap.put("endPeriodParam", col.get(0));
        }
        return actualAcctTableId;
    }

    private String getActualAcctTable(Context ctx, CompanyOrgUnitInfo company, int beginYear, int beginPeriod, int endYear, int endPeriod) throws EASBizException, BOSException {
        PeriodInfo beginPeriodInfo = this.getPeriodInfo(ctx, beginYear, beginPeriod, company);
        PeriodInfo endPeriodInfo = this.getPeriodInfo(ctx, endYear, endPeriod, company);
        if (EmptyUtil.isEmpty((Object)beginPeriod) || EmptyUtil.isEmpty((CoreBaseInfo)endPeriodInfo)) {
            throw new CasException(CasException.STARTPERIODNULL);
        }
        return this.getActualAcctTable(ctx, company, beginPeriodInfo.getBeginDate(), endPeriodInfo.getEndDate());
    }

    private String getActualAcctTable(Context ctx, CompanyOrgUnitInfo companyInfo, Date beginDate, Date endDate) throws BOSException, EASBizException {
        String cuId = companyInfo.getCU().getId().toString();
        AccountRefContrastCollection coll = this.getStrideAcctRefContrastColl(ctx, cuId, beginDate, endDate);
        if (coll == null || coll.isEmpty()) {
            PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)endDate, (CompanyOrgUnitInfo)companyInfo);
            if (period == null) {
                throw new CasException(CasException.PERIODERROR, new Object[]{DateHelper.DateToString((Date)endDate)});
            }
            int yearNumber = period.getPeriodYear();
            int monthNumber = period.getPeriodNumber();
            try {
                AccountTableInfo tbl = companyInfo.getAccountTable();
                String currTableId = AccountTools.getCurrentAcctTable((Context)ctx, (String)cuId, (String)tbl.getId().toString(), (int)yearNumber, (int)monthNumber);
                return currTableId;
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                throw new FMException(FMException.HASCOMPANYADJUSTACCT);
            }
        }
        return null;
    }

    private AccountRefContrastCollection getStrideAcctRefContrastColl(Context ctx, String cuId, Date beginDate, Date endDate) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cuId));
        filter.getFilterItems().add(new FilterItemInfo("enabledPeriod.endDate", (Object)DateTimeUtils.truncateDate((Date)beginDate), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("enabledPeriod.endDate", (Object)DateTimeUtils.truncateDate((Date)endDate), CompareType.LESS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IAccountRefContrast acctContrast = AccountRefContrastFactory.getLocalInstance((Context)ctx);
        AccountRefContrastCollection coll = acctContrast.getAccountRefContrastCollection(evi);
        return coll;
    }

    private PeriodInfo getPeriodInfo(Context ctx, int periodYear, int periodNumber, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        PeriodInfo info = null;
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodNumber), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            info = periodc.get(0);
        }
        return info;
    }
}

