/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.CasWebParamFacadeFactory;
import com.kingdee.eas.fi.cas.CashDataSourceEnum;
import com.kingdee.eas.fi.cas.ICasWebParamFacade;
import com.kingdee.eas.fi.cas.IJournal;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fi.cas.app.AbstractBankJournalWebFacadeControllerBean;
import com.kingdee.eas.fi.cas.utils.BankJournalWebUtil;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.utils.JournalWebUtil;
import com.kingdee.eas.fi.cas.web.param.BankJournalWebFilterParam;
import com.kingdee.eas.fi.cas.web.param.BsfBatchProcessResult;
import com.kingdee.eas.fi.cas.web.param.DeleteBankJouranlParam;
import com.kingdee.eas.fi.cas.web.param.FetchAccTableParam;
import com.kingdee.eas.fi.cas.web.param.QueryTable;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.SettleFacadeFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BankJournalWebFacadeControllerBean
extends AbstractBankJournalWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.BankJournalWebFacadeControllerBean");

    @Override
    protected Object _saveFromJsonStr(Context ctx, String jsonStr) throws BOSException, EASBizException {
        JournalInfo info = null;
        info = (JournalInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonStr, JournalInfo.class);
        if (info.getId() == null) {
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        }
        JournalFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
        if (info.isIsDebit()) {
            info.setCreditAmount(null);
        } else {
            info.setDebitAmount(null);
        }
        return info;
    }

    @Override
    protected Object _saveFromJsonListStr(Context ctx, String jsonListStr) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected String _deleteFromIdStr(Context ctx, String idStr) throws BOSException, EASBizException {
        if (idStr != null) {
            ObjectUuidPK objPk = new ObjectUuidPK(idStr);
            JournalInfo info = null;
            try {
                info = JournalFactory.getLocalInstance(ctx).getJournalInfo((IObjectPK)objPk);
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
            if (info != null) {
                JournalFactory.getLocalInstance(ctx).delete((IObjectPK)objPk);
            }
        }
        return idStr;
    }

    @Override
    protected Object _updateFromJsonStr(Context ctx, String jsonStr) throws BOSException, EASBizException {
        JournalInfo info = null;
        JournalInfo existObj = null;
        info = (JournalInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonStr, JournalInfo.class);
        if (info != null && info.getId() != null) {
            JournalWebUtil.verifyRate(ctx, info);
            try {
                existObj = JournalFactory.getLocalInstance(ctx).getJournalInfo((IObjectPK)new ObjectUuidPK(info.getId()));
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
            if (existObj != null) {
                JournalFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
                if (info.isIsDebit()) {
                    info.setCreditAmount(null);
                } else {
                    info.setDebitAmount(null);
                }
            }
        }
        return info;
    }

    @Override
    protected JournalInfo _getJournalInfoById(Context ctx, String idStr) throws BOSException, EASBizException {
        JournalInfo info = null;
        if (idStr != null) {
            try {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("company.id"));
                sic.add(new SelectorItemInfo("company.name"));
                sic.add(new SelectorItemInfo("company.number"));
                sic.add(new SelectorItemInfo("company.CU.id"));
                sic.add(new SelectorItemInfo("company.CU.name"));
                sic.add(new SelectorItemInfo("company.CU.number"));
                sic.add(new SelectorItemInfo("company.baseCurrency.id"));
                sic.add(new SelectorItemInfo("company.baseCurrency.name"));
                sic.add(new SelectorItemInfo("company.baseCurrency.number"));
                sic.add(new SelectorItemInfo("company.accountTable.id"));
                sic.add(new SelectorItemInfo("company.accountTable.name"));
                sic.add(new SelectorItemInfo("company.accountTable.number"));
                sic.add(new SelectorItemInfo("accountBank.id"));
                sic.add(new SelectorItemInfo("accountBank.name"));
                sic.add(new SelectorItemInfo("accountBank.number"));
                sic.add(new SelectorItemInfo("accountBank.isClosed"));
                sic.add(new SelectorItemInfo("accountBank.isByCurrency"));
                sic.add(new SelectorItemInfo("accountBank.currency.id"));
                sic.add(new SelectorItemInfo("accountBank.currency.name"));
                sic.add(new SelectorItemInfo("accountBank.currency.number"));
                sic.add(new SelectorItemInfo("accountBank.currency.precision"));
                sic.add(new SelectorItemInfo("currency.id"));
                sic.add(new SelectorItemInfo("currency.name"));
                sic.add(new SelectorItemInfo("currency.number"));
                sic.add(new SelectorItemInfo("currency.precision"));
                sic.add(new SelectorItemInfo("oppAccountView.id"));
                sic.add(new SelectorItemInfo("oppAccountView.name"));
                sic.add(new SelectorItemInfo("oppAccountView.number"));
                sic.add(new SelectorItemInfo("voucherType.id"));
                sic.add(new SelectorItemInfo("voucherType.name"));
                sic.add(new SelectorItemInfo("voucherType.number"));
                sic.add(new SelectorItemInfo("settlementType.id"));
                sic.add(new SelectorItemInfo("settlementType.name"));
                sic.add(new SelectorItemInfo("settlementType.number"));
                sic.add(new SelectorItemInfo("accountView.id"));
                sic.add(new SelectorItemInfo("accountView.name"));
                sic.add(new SelectorItemInfo("accountView.number"));
                sic.add(new SelectorItemInfo("accountView.isCFreeze"));
                sic.add(new SelectorItemInfo("accountView.isGFreeze"));
                sic.add(new SelectorItemInfo("period.*"));
                info = JournalFactory.getLocalInstance(ctx).getJournalInfo((IObjectPK)new ObjectUuidPK(idStr), sic);
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
        }
        return info;
    }

    @Override
    protected QueryTable _getBankJouranlList(Context ctx, BankJournalWebFilterParam filterParam) throws BOSException, EASBizException {
        filterParam.setDataSourceType(CashDataSourceEnum.B);
        QueryTable queryTable = new QueryTable();
        try {
            String toDateStr;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String fromDateStr = filterParam.getFromDateStr();
            if (fromDateStr != null) {
                filterParam.setFromDate(simpleDateFormat.parse(fromDateStr));
            }
            if ((toDateStr = filterParam.getToDateStr()) != null) {
                filterParam.setToDate(simpleDateFormat.parse(toDateStr));
            }
            BankJournalWebUtil.fetchJournalData(ctx, filterParam, queryTable);
        }
        catch (Exception e) {
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
            throw new BOSException(e.getMessage());
        }
        return queryTable;
    }

    @Override
    protected void _deleteJournalById(Context ctx, String idStr) throws BOSException, EASBizException {
    }

    @Override
    protected void _deleteJournalByParam(Context ctx, DeleteBankJouranlParam param) throws BOSException, EASBizException {
        if (param != null && param.getId() != null) {
            JournalSourceEnum source = JournalSourceEnum.getEnum((int)param.getSource());
            if (source == JournalSourceEnum.BYBILL || source == JournalSourceEnum.BYVOUCHER) {
                throw new BOSException(EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CheckoutResource", (String)"BillOrVoucherBook", (Locale)ctx.getLocale()));
            }
            PeriodInfo currPeriodInfo = BankJournalWebUtil.getCurrentPeriod(ctx, SystemEnum.CASHMANAGEMENT, param.getCompanyId());
            int currYear = currPeriodInfo.getPeriodYear();
            int currPeriodNumber = currPeriodInfo.getPeriodNumber();
            Integer year = param.getPeriodYear();
            Integer period = param.getPeriodNumber();
            if (year < currYear || year == currYear && period < currPeriodNumber) {
                throw new BOSException(EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CheckoutResource", (String)"CheckOut_No_Delete", (Locale)ctx.getLocale()));
            }
            JournalWebUtil.isReferenced(ctx, param.getId());
            JournalFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(param.getId()));
        }
    }

    @Override
    protected JournalInfo _createBankJournalInfo(Context ctx, String companyId, String accountBankId) throws BOSException, EASBizException {
        JournalInfo journal = null;
        journal = new JournalInfo();
        journal.setId(BOSUuid.create((BOSObjectType)journal.getBOSType()));
        journal.setHasEffected(true);
        AccountBankInfo newAccountBankInfo = null;
        AccountBankInfo accountBankInfo = null;
        CurrencyInfo localCurrency = null;
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String strDate = sdf.format(date);
        try {
            date = sdf.parse(strDate);
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        IAccountBank iAccountBank = AccountBankFactory.getLocalInstance((Context)ctx);
        newAccountBankInfo = iAccountBank.getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountBankId));
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        localCurrency = company.getBaseCurrency();
        PeriodInfo period = BankJournalWebUtil.getCurrentPeriod(ctx, SystemEnum.CASHMANAGEMENT, company);
        if (date.before(period.getBeginDate())) {
            date = period.getBeginDate();
        }
        if (date.after(period.getEndDate())) {
            date = period.getEndDate();
        }
        journal.setBizDate(date);
        journal.setCreateDate(date);
        journal.setPeriod(period);
        UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserByID(ctx.getCaller());
        journal.setCashier(user);
        journal.setVerifyStatus(VerifyScopeEnum.NOVA);
        journal.setSource(JournalSourceEnum.BYHAND);
        journal.setType(JournalTypeEnum.BANK);
        journal.setCompany(company);
        journal.setAccountBank(accountBankInfo);
        if (newAccountBankInfo != null && newAccountBankInfo.isIsByCurrency()) {
            journal.setCurrency(newAccountBankInfo.getCurrency());
        } else {
            journal.setCurrency(localCurrency);
        }
        return journal;
    }

    @Override
    protected Map _getBankJournalUIDefaultValue(Context ctx) throws BOSException, EASBizException {
        HashMap<String, Object> defaultValueMap = new HashMap<String, Object>();
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        IPermission permission = PermissionFactory.getRemoteInstance();
        boolean hasPermission = permission.hasFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)new ObjectUuidPK(companyInfo.getId()), "cas_bankbook_01view");
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (!hasPermission) {
            CompanyOrgUnitCollection fiOrgColls = CASWebHelper.getAuthorizedOrgCollection(ctx, "cas_bankbook_01view", false);
            for (int i = 0; i < fiOrgColls.size(); ++i) {
                startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)fiOrgColls.get(i));
                if (startPeriod == null) continue;
                companyInfo = fiOrgColls.get(i);
                break;
            }
        }
        AccountBankInfo accountBankInfo = null;
        EntityViewInfo accountBankEntity = new EntityViewInfo();
        FilterInfo accountBankFilter = new FilterInfo();
        accountBankEntity.setFilter(accountBankFilter);
        accountBankFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId().toString(), CompareType.EQUALS));
        accountBankFilter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0), CompareType.EQUALS));
        accountBankFilter.getFilterItems().add(new FilterItemInfo("isBank", (Object)new Integer(1), CompareType.EQUALS));
        accountBankEntity.getSorter().add(new SorterItemInfo("number"));
        SelectorItemCollection accountBankSic = new SelectorItemCollection();
        accountBankSic.add(new SelectorItemInfo("*"));
        accountBankSic.add(new SelectorItemInfo("currency.*"));
        accountBankSic.add(new SelectorItemInfo("company.*"));
        accountBankSic.add(new SelectorItemInfo("account.*"));
        accountBankSic.add(new SelectorItemInfo("bank.id"));
        accountBankSic.add(new SelectorItemInfo("bank.name"));
        accountBankSic.add(new SelectorItemInfo("bank.number"));
        accountBankEntity.setSelector(accountBankSic);
        AccountBankCollection accountBankCol = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(accountBankEntity);
        PeriodInfo curPeriod = JournalWebUtil.getCurrentPeriod(ctx, companyInfo.getId().toString());
        PeriodCollection periodCol = BankJournalWebUtil.getPeriodc(ctx, companyInfo);
        boolean canMulUnionQuery = false;
        if (accountBankCol != null && accountBankCol.size() > 0 && curPeriod != null) {
            String accTableId = JournalWebUtil.getAccTableIdByPeriod(companyInfo.getId().toString(), null, curPeriod.getPeriodYear(), curPeriod.getPeriodNumber(), curPeriod.getPeriodYear(), curPeriod.getPeriodNumber());
            accountBankInfo = accountBankCol.get(0);
            accountBankInfo = JournalWebUtil.getJouranlBalanceAcctBank(ctx, accountBankInfo, curPeriod.getId().toString(), accTableId);
            ICasWebParamFacade facade = CasWebParamFacadeFactory.getLocalInstance(ctx);
            canMulUnionQuery = facade.chkCanMulUnionQuery(companyInfo.getId().toString(), accountBankInfo.getId().toString());
        }
        if (companyInfo != null && startPeriod != null) {
            defaultValueMap.put("DEFAULT_COMPANY", companyInfo);
            defaultValueMap.put("DEFAULT_ACCOUNTBANK", accountBankInfo);
            defaultValueMap.put("ACCOUNT_CAN_MULUNIONQUERY", canMulUnionQuery);
            defaultValueMap.put("DEFAULT_START_PERIOD", startPeriod);
        }
        if (curPeriod != null && periodCol != null) {
            defaultValueMap.put("DEFAULT_PERIOD", curPeriod);
            defaultValueMap.put("DEFAULT_PERIODS", periodCol);
        }
        defaultValueMap.put("VALID_COMPANYIDS", CASWebHelper.getAuthorizedOrgFilter_F7Special(ctx, "cas_bankbook_01view", false, "unit.id", null));
        return defaultValueMap;
    }

    @Override
    protected List _batchDeleteBankJournal(Context ctx, String[] journalIdList, String companyId) throws BOSException, EASBizException {
        ArrayList<BsfBatchProcessResult> resultList = null;
        if (journalIdList != null && journalIdList.length > 0) {
            resultList = new ArrayList<BsfBatchProcessResult>(journalIdList.length);
            for (String journalId : journalIdList) {
                BsfBatchProcessResult result = new BsfBatchProcessResult(journalId);
                resultList.add(result);
                try {
                    JournalInfo info = this.getJournalInfoById(ctx, journalId);
                    String id = info.getCompany().getId().toString();
                    CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
                    PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
                    result.setJournalInfo(info);
                    if (info.getSource() == JournalSourceEnum.BYBILL || info.getSource() == JournalSourceEnum.BYVOUCHER) {
                        result.setProcessResult(false);
                        result.getErrorInfo().setMsgSummary(EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.JournalResource", (String)"BillOrVoucherBook", (Locale)ctx.getLocale()));
                        continue;
                    }
                    int currYear = currPeriodInfo.getPeriodYear();
                    int currPeriodNumber = currPeriodInfo.getPeriodNumber();
                    Integer year = info.getPeriod().getPeriodYear();
                    Integer period = info.getPeriod().getPeriodNumber();
                    if (year < currYear || year == currYear && period < currPeriodNumber) {
                        result.setProcessResult(false);
                        result.getErrorInfo().setMsgSummary(EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.JournalResource", (String)"checkoutNoDelete", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (info.getTicketNumber() != null) {
                        result.setProcessResult(false);
                        result.getErrorInfo().setMsgSummary(EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.JournalResource", (String)"HASVC", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (!info.getVerifyStatus().equals((Object)VerifyScopeEnum.NOVA)) {
                        result.setProcessResult(false);
                        result.getErrorInfo().setMsgSummary(EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.JournalResource", (String)"HASVERIFY", (Locale)ctx.getLocale()));
                        continue;
                    }
                    JournalWebUtil.isReferenced(ctx, journalId);
                    JournalFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(info.getId()));
                    result.setProcessResult(true);
                }
                catch (Exception e) {
                    result.setProcessResult(false);
                    result.setException(e);
                    result.getErrorInfo().setMsgSummary(e.getMessage());
                }
            }
        }
        return resultList;
    }

    @Override
    protected List _registerVoucher(Context ctx, String[] journalIdList, String companyId) throws BOSException, EASBizException {
        ArrayList<BsfBatchProcessResult> resultList = null;
        if (journalIdList != null && journalIdList.length > 0) {
            resultList = new ArrayList<BsfBatchProcessResult>(journalIdList.length);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.Array2Set((String[])journalIdList), CompareType.INCLUDE));
            view.setFilter(filter);
            JournalCollection journals = JournalFactory.getLocalInstance(ctx).getJournalCollection(view);
            int count = 0;
            for (int i = 0; i < journals.size(); ++i) {
                JournalInfo journalInfo = journals.get(i);
                CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(journalInfo.getCompany().getId()));
                BsfBatchProcessResult result = new BsfBatchProcessResult(journalInfo.getId().toString());
                resultList.add(result);
                result.setJournalInfo(journalInfo);
                try {
                    Set<String> idSet;
                    if (!this._canRegisterVoucher(ctx, companyInfo.getId().toString())) {
                        result.setProcessResult(false);
                        result.getLogInfo().setMsgSummary(CASWebUtil.getResource(ctx, "279_BillRegister"));
                        continue;
                    }
                    JournalSourceEnum source = journalInfo.getSource();
                    if (source != JournalSourceEnum.BYBILL) {
                        result.setProcessResult(false);
                        result.getLogInfo().setMsgSummary(CASWebUtil.getResource(ctx, "428_NOT_GEN_BY_ORDER"));
                        continue;
                    }
                    String billId = null;
                    VoucherInfo voucherInfo = null;
                    int billType = journalInfo.getBillType().getValue();
                    String billNumber = journalInfo.getBillNumber();
                    String[] billNumArray = null;
                    billNumArray = billNumber.split(";");
                    if (billNumArray.length == 1) {
                        IJournal iEntry;
                        billId = journalInfo.getBillId();
                        if (BillTypeEnum.settleBatch.equals((Object)journalInfo.getBillType())) {
                            idSet = SettleFacadeFactory.getLocalInstance((Context)ctx).getSettlementIdbySettBatchID(billId);
                            count = BankJournalWebUtil.registerVoucherBatch(ctx, journalInfo, idSet, count, result);
                            continue;
                        }
                        voucherInfo = JournalWebUtil.getVoucherInfo(ctx, billId);
                        if (voucherInfo == null || voucherInfo.getBizStatus().getValue() == 0) {
                            result.setProcessResult(false);
                            if (voucherInfo == null) {
                                result.getLogInfo().setMsgSummary(CASWebUtil.getResource(ctx, "429_NOT_GEN_BY_ASS_ORDER"));
                            }
                            if (voucherInfo != null && voucherInfo.getBizStatus().getValue() == 0) {
                                result.getLogInfo().setMsgSummary(CASWebUtil.getResource(ctx, "430_NOT_SUBMIT_THE_ASS_ORDER"));
                            }
                            journalInfo.setVoucherId(null);
                            journalInfo.setVoucherNumber(null);
                            journalInfo.setVoucherType(null);
                            journalInfo.setOppAccountView(null);
                            iEntry = JournalFactory.getLocalInstance(ctx);
                            iEntry.registerVoucher((IObjectPK)new ObjectUuidPK(journalInfo.getId()), journalInfo);
                            continue;
                        }
                        journalInfo.setVoucherId(voucherInfo.getId().toString());
                        journalInfo.setVoucherNumber(voucherInfo.getNumber());
                        journalInfo.setVoucherType(voucherInfo.getVoucherType());
                        JournalWebUtil.setOppAccount(journalInfo, voucherInfo);
                        iEntry = JournalFactory.getLocalInstance(ctx);
                        iEntry.registerVoucher((IObjectPK)new ObjectUuidPK(journalInfo.getId()), journalInfo);
                        result.setProcessResult(true);
                        ++count;
                        continue;
                    }
                    idSet = new HashSet();
                    for (int j = 0; j < billNumArray.length; ++j) {
                        billId = JournalWebUtil.getBillIdByBillNumber(ctx, billNumArray[j], companyInfo, billType);
                        if (EmptyUtil.isEmpty((String)billId)) continue;
                        idSet.add(billId);
                    }
                    count = BankJournalWebUtil.registerVoucherBatch(ctx, journalInfo, idSet, count, result);
                    continue;
                }
                catch (Exception e) {
                    result.setProcessResult(false);
                    result.setException(e);
                    result.getErrorInfo().setMsgSummary(e.getMessage());
                }
            }
        }
        return resultList;
    }

    @Override
    protected boolean _canRegisterVoucher(Context ctx, String companyId) throws BOSException, EASBizException {
        return BankJournalWebUtil.canRegisterVoucher(ctx, companyId);
    }

    @Override
    protected AccountBankInfo _getAccBankHasAccView(Context ctx, FetchAccTableParam param, String accBankId) throws BOSException, EASBizException {
        return JournalWebUtil.getAccBankHasAccView(ctx, param, accBankId);
    }

    @Override
    protected Map _getBankJournalUIDefaultValue(Context ctx, String share) throws BOSException, EASBizException {
        Map<Object, Object> defaultValueMap = new HashMap();
        CompanyOrgUnitInfo companyInfo = null;
        PeriodInfo startPeriod = null;
        Object accountViewInfo = null;
        if (share.equals("1")) {
            defaultValueMap = this.getBankJournalUIDefaultValueByShare(ctx);
        } else {
            CompanyOrgUnitInfo curFIUnit = ContextUtil.getCurrentFIUnit((Context)ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("baseCurrency.*"));
            sic.add(new SelectorItemInfo("accountTable.id"));
            sic.add(new SelectorItemInfo("accountTable.name"));
            sic.add(new SelectorItemInfo("accountTable.number"));
            companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(curFIUnit.getId().toString()), sic);
            startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            AccountBankInfo accountBankInfo = null;
            EntityViewInfo accountBankEntity = new EntityViewInfo();
            FilterInfo accountBankFilter = new FilterInfo();
            accountBankEntity.setFilter(accountBankFilter);
            accountBankFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId().toString(), CompareType.EQUALS));
            accountBankFilter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0), CompareType.EQUALS));
            accountBankFilter.getFilterItems().add(new FilterItemInfo("isBank", (Object)new Integer(1), CompareType.EQUALS));
            accountBankEntity.getSorter().add(new SorterItemInfo("number"));
            SelectorItemCollection accountBankSic = new SelectorItemCollection();
            accountBankSic.add(new SelectorItemInfo("*"));
            accountBankSic.add(new SelectorItemInfo("currency.*"));
            accountBankSic.add(new SelectorItemInfo("company.*"));
            accountBankSic.add(new SelectorItemInfo("account.*"));
            accountBankSic.add(new SelectorItemInfo("bank.id"));
            accountBankSic.add(new SelectorItemInfo("bank.name"));
            accountBankSic.add(new SelectorItemInfo("bank.number"));
            accountBankEntity.setSelector(accountBankSic);
            AccountBankCollection accountBankCol = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(accountBankEntity);
            PeriodInfo curPeriod = JournalWebUtil.getCurrentPeriod(ctx, companyInfo.getId().toString());
            PeriodCollection periodCol = BankJournalWebUtil.getPeriodc(ctx, companyInfo);
            boolean canMulUnionQuery = false;
            if (accountBankCol != null && accountBankCol.size() > 0 && curPeriod != null) {
                String accTableId = JournalWebUtil.getAccTableIdByPeriod(companyInfo.getId().toString(), null, curPeriod.getPeriodYear(), curPeriod.getPeriodNumber(), curPeriod.getPeriodYear(), curPeriod.getPeriodNumber());
                accountBankInfo = accountBankCol.get(0);
                accountBankInfo = JournalWebUtil.getJouranlBalanceAcctBank(ctx, accountBankInfo, curPeriod.getId().toString(), accTableId);
                ICasWebParamFacade facade = CasWebParamFacadeFactory.getLocalInstance(ctx);
                canMulUnionQuery = facade.chkCanMulUnionQuery(companyInfo.getId().toString(), accountBankInfo.getId().toString());
            }
            if (companyInfo != null && startPeriod != null) {
                defaultValueMap.put("DEFAULT_COMPANY", companyInfo);
                defaultValueMap.put("DEFAULT_ACCOUNTBANK", accountBankInfo);
                defaultValueMap.put("ACCOUNT_CAN_MULUNIONQUERY", canMulUnionQuery);
                defaultValueMap.put("DEFAULT_START_PERIOD", startPeriod);
            }
            if (curPeriod != null && periodCol != null) {
                defaultValueMap.put("DEFAULT_PERIOD", curPeriod);
                defaultValueMap.put("DEFAULT_PERIODS", periodCol);
            }
        }
        return defaultValueMap;
    }

    private Map<String, Object> getBankJournalUIDefaultValueByShare(Context ctx) throws EASBizException, BOSException {
        HashMap<String, Object> defaultValueMap = new HashMap<String, Object>();
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        PeriodInfo startPeriod = null;
        CompanyOrgUnitCollection fiOrgColls = CASWebHelper.getAuthorizedOrgCollection(ctx, "cas_bankbook_01view", false);
        HashSet<String> idSet = new HashSet<String>();
        for (int idx = 0; idx < fiOrgColls.size(); ++idx) {
            CompanyOrgUnitInfo fiOrgUnit = fiOrgColls.get(idx);
            if (fiOrgUnit == null || fiOrgUnit.getId() == null) continue;
            idSet.add(fiOrgUnit.getId().toString());
        }
        ArrayList companyIdList = new ArrayList(idSet);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("baseCurrency.*"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("accountTable.name"));
        sic.add(new SelectorItemInfo("accountTable.number"));
        if (companyIdList != null && companyIdList.size() != 0 && companyIdList.contains(companyInfo.getId().toString())) {
            companyIdList.remove(companyInfo.getId().toString());
            companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId().toString()), sic);
            startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        }
        if (startPeriod == null && fiOrgColls != null && fiOrgColls.size() > 0) {
            for (int i = 0; i < fiOrgColls.size(); ++i) {
                companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(fiOrgColls.get(i).getId().toString()), sic);
                startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)fiOrgColls.get(i));
                if (startPeriod != null) break;
            }
        }
        AccountBankInfo accountBankInfo = null;
        EntityViewInfo accountBankEntity = new EntityViewInfo();
        FilterInfo accountBankFilter = new FilterInfo();
        accountBankEntity.setFilter(accountBankFilter);
        accountBankFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId().toString(), CompareType.EQUALS));
        accountBankFilter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0), CompareType.EQUALS));
        accountBankFilter.getFilterItems().add(new FilterItemInfo("isBank", (Object)new Integer(1), CompareType.EQUALS));
        accountBankEntity.getSorter().add(new SorterItemInfo("number"));
        SelectorItemCollection accountBankSic = new SelectorItemCollection();
        accountBankSic.add(new SelectorItemInfo("*"));
        accountBankSic.add(new SelectorItemInfo("currency.*"));
        accountBankSic.add(new SelectorItemInfo("company.*"));
        accountBankSic.add(new SelectorItemInfo("account.*"));
        accountBankSic.add(new SelectorItemInfo("bank.id"));
        accountBankSic.add(new SelectorItemInfo("bank.name"));
        accountBankSic.add(new SelectorItemInfo("bank.number"));
        accountBankEntity.setSelector(accountBankSic);
        AccountBankCollection accountBankCol = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(accountBankEntity);
        PeriodInfo curPeriod = JournalWebUtil.getCurrentPeriod(ctx, companyInfo.getId().toString());
        PeriodCollection periodCol = BankJournalWebUtil.getPeriodc(ctx, companyInfo);
        boolean canMulUnionQuery = false;
        if (accountBankCol != null && accountBankCol.size() > 0 && curPeriod != null) {
            String accTableId = JournalWebUtil.getAccTableIdByPeriod(companyInfo.getId().toString(), null, curPeriod.getPeriodYear(), curPeriod.getPeriodNumber(), curPeriod.getPeriodYear(), curPeriod.getPeriodNumber());
            accountBankInfo = accountBankCol.get(0);
            accountBankInfo = JournalWebUtil.getJouranlBalanceAcctBank(ctx, accountBankInfo, curPeriod.getId().toString(), accTableId);
            ICasWebParamFacade facade = CasWebParamFacadeFactory.getLocalInstance(ctx);
            canMulUnionQuery = facade.chkCanMulUnionQuery(companyInfo.getId().toString(), accountBankInfo.getId().toString());
        }
        if (companyInfo != null && startPeriod != null) {
            defaultValueMap.put("DEFAULT_COMPANY", companyInfo);
            defaultValueMap.put("DEFAULT_ACCOUNTBANK", accountBankInfo);
            defaultValueMap.put("ACCOUNT_CAN_MULUNIONQUERY", canMulUnionQuery);
            defaultValueMap.put("DEFAULT_START_PERIOD", startPeriod);
        }
        if (curPeriod != null && periodCol != null) {
            defaultValueMap.put("DEFAULT_PERIOD", curPeriod);
            defaultValueMap.put("DEFAULT_PERIODS", periodCol);
        }
        if (companyIdList != null && companyIdList.size() > 0) {
            defaultValueMap.put("VALID_COMPANYIDS", CASWebHelper.getAuthorizedOrgFilter_F7Special(ctx, "cas_bankbook_01view", false, "unit.id", null));
        }
        return defaultValueMap;
    }

    @Override
    protected boolean _isExistVoucher(Context ctx, String VoucherId) throws BOSException, EASBizException {
        String sql = "select * from T_CAS_JOURNAL where FBillId=?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{VoucherId});
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }
}

