/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountRefContrastCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.BSSourceEnum;
import com.kingdee.eas.fi.cas.BankStatementCollection;
import com.kingdee.eas.fi.cas.BankStatementException;
import com.kingdee.eas.fi.cas.BankStatementFactory;
import com.kingdee.eas.fi.cas.BankStatementInfo;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.CashCommonException;
import com.kingdee.eas.fi.cas.DownLoadBankParam;
import com.kingdee.eas.fi.cas.app.AbstractBankStatementControllerBean;
import com.kingdee.eas.fi.cas.app.BSBatchSubmitVerifyDelegate;
import com.kingdee.eas.fi.cas.app.TransToBankStateService;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.ITransDetail;
import com.kingdee.eas.fm.be.TransDetailCollection;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.be.TransDetailInfo;
import com.kingdee.eas.fm.be.TransDetailRecedEnum;
import com.kingdee.eas.fm.common.CheckUtils;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.common.util.AccountCurrencyVerifyUtil;
import com.kingdee.eas.fm.common.util.FetchParamHelper;
import com.kingdee.eas.fm.fs.ISettlementBill;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettlementBill;
import com.kingdee.eas.fm.fs.SettlementBillFactory;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerFactory;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class BankStatementControllerBean
extends AbstractBankStatementControllerBean {
    private Logger logger = Logger.getLogger(BankStatementControllerBean.class);
    private Map bankPeriodMap = new HashMap();

    @Override
    protected IObjectValue _getDateStartData(Context ctx, IObjectPK companyId, IObjectPK bankId, IObjectPK currencyId, Date beginDate, Date endDate, IObjectPK beginPeriodId, IObjectPK endPeriodId, IObjectPK accountId, IObjectPK accountTableId) throws BOSException, EASBizException {
        PeriodInfo endPeriod;
        IPeriod biz = PeriodFactory.getLocalInstance((Context)ctx);
        PeriodInfo beginPeriod = biz.getPeriodInfo(beginPeriodId);
        if (CheckUtils.existAll((Object[])new Object[]{beginPeriod, endPeriod = biz.getPeriodInfo(endPeriodId), accountTableId}) && beginPeriod.isIsAdjustPeriod() && !CheckUtils.same((Object)beginPeriod, (Object)endPeriod)) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)ConvertUtils.STR((Object)companyId)));
            filter.getFilterItems().add(new FilterItemInfo("enabledPeriod.id", (Object)ConvertUtils.STR((Object)beginPeriodId)));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            AccountRefContrastCollection coll = AccountRefContrastFactory.getLocalInstance((Context)ctx).getAccountRefContrastCollection(evi);
            AccountRefContrastInfo contrastInfo = null;
            boolean isBookAdjust = true;
            for (int i = 0; i < coll.size(); ++i) {
                contrastInfo = coll.get(i);
                if (contrastInfo.getRefType() == null || 1 == contrastInfo.getRefType().getValue() || 2 == contrastInfo.getRefType().getValue()) continue;
                isBookAdjust = false;
                break;
            }
            if (coll != null && coll.size() > 0 && isBookAdjust) {
                BankStatementInfo info = new BankStatementInfo();
                info.setDebitAmount(CasConstants.ZERO);
                info.setCreditAmount(CasConstants.ZERO);
                info.put("yeardebit", CasConstants.ZERO);
                info.put("yearcreadit", CasConstants.ZERO);
                info.put("balance", CasConstants.ZERO);
                return info;
            }
        }
        return this._getDateStartData(ctx, companyId, bankId, currencyId, beginDate, beginPeriodId, accountId);
    }

    @Override
    protected IObjectValue _getDateStartData(Context ctx, IObjectPK companyId, IObjectPK bankId, IObjectPK currencyId, Date startDate, IObjectPK periodId, IObjectPK accountId) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(bankId.toString());
        String sSQL = "SELECT FBANKACCOUNTID, FACCOUNTBANKID FROM T_BD_SHAREDACCT ";
        sSQL = sSQL + " LEFT JOIN T_BD_SHAREDACCTENTRIES ON T_BD_SHAREDACCT.FID = T_BD_SHAREDACCTENTRIES.FPARENTID ";
        sSQL = sSQL + " WHERE FBANKACCOUNTID = ? OR FACCOUNTBANKID = ? ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sSQL, (Object[])new String[]{bankId.toString(), bankId.toString()});
        try {
            while (rowSet.next()) {
                String id = rowSet.getString("FBANKACCOUNTID");
                idSet.add(id);
                id = rowSet.getString("FACCOUNTBANKID");
                idSet.add(id);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        PeriodInfo period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo(periodId);
        StringBuffer buf = new StringBuffer();
        buf.append("select fdebit,fcredit,fbalance ,forder from (");
        buf.append(" select sum(FDebitStartAmt) FDebit, sum(FCreditStartAmt) FCredit,");
        buf.append(" sum(FMonthStartAmt) FBalance ,0 as forder from t_cas_journalBalance where ");
        buf.append(" FType = 3 and FIsInit = 1 and");
        buf.append(" FAccountBankId in " + FMHelper.setTran2String(idSet) + " and FCurrencyId = ?");
        buf.append(" union all");
        buf.append(" select sum(FDebitAmount) FDebit, sum(FCreditAmount) FCredit,");
        buf.append(" 0 FBalance ,1 as forder from t_cas_bankstatement where FCompanyId = ?");
        buf.append(" and FAccountBankId = ? and FCurrencyId = ?");
        if (period.isIsAdjustPeriod()) {
            buf.append(" and FPeriodId IS NOT NULL and FCreateDate <= ?");
        } else {
            buf.append(" and FPeriodId IS NOT NULL and FCreateDate < ?");
        }
        buf.append(" ) b order by forder");
        String sql = buf.toString();
        BankStatementInfo info = new BankStatementInfo();
        BigDecimal debit = SysConstant.BIGZERO;
        BigDecimal credit = SysConstant.BIGZERO;
        BigDecimal balance = SysConstant.BIGZERO;
        BigDecimal tmpAmt = SysConstant.BIGZERO;
        Connection cn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            cn = this.getConnection(ctx);
            pstmt = cn.prepareStatement(sql);
            int index = 1;
            pstmt.setString(index++, currencyId.toString());
            pstmt.setString(index++, companyId.toString());
            pstmt.setString(index++, bankId.toString());
            pstmt.setString(index++, currencyId.toString());
            pstmt.setTimestamp(index++, new Timestamp(startDate.getTime()));
            rs = pstmt.executeQuery();
            boolean fInit = true;
            while (rs.next()) {
                tmpAmt = this.getBigDecimal(rs, 1);
                debit = debit.add(tmpAmt);
                if (!fInit) {
                    balance = balance.subtract(tmpAmt);
                }
                tmpAmt = this.getBigDecimal(rs, 2);
                credit = credit.add(tmpAmt);
                if (!fInit) {
                    balance = balance.add(tmpAmt);
                }
                if (fInit && rs.getBigDecimal(3) != null) {
                    balance = balance.add(rs.getBigDecimal(3));
                    this.logger.info((Object)("initAmt: " + balance));
                }
                fInit = false;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)cn);
        this.logger.info((Object)("debit:" + debit + " credit:" + credit + " balance:" + balance));
        info.setDebitAmount(debit);
        info.setCreditAmount(credit);
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(companyId);
        PeriodInfo sysst = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        if (sysst != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(startDate);
            int year = cal.get(1);
            if (sysst.getPeriodYear() == year) {
                info.put("yeardebit", debit);
                info.put("yearcreadit", credit);
            } else {
                StringBuffer buf2 = new StringBuffer();
                buf2.append(" select sum(FDebitAmount) FDebit, sum(FCreditAmount) FCredit ");
                buf2.append(" from t_cas_bankstatement where FCompanyId = ?");
                buf2.append(" and FAccountBankId = ? and FCurrencyId = ? and faccountviewid = ?");
                buf2.append(" and FPeriodId IS NOT NULL and FCreateDate <? and FCreateDate>=?");
                Object[] params = new Object[]{companyId.toString(), bankId.toString(), currencyId.toString(), accountId.toString(), new Timestamp(startDate.getTime()), new Timestamp(DateHelper.getFirstYearDate((Date)startDate).getTime())};
                IRowSet yearrs = DbUtil.executeQuery((Context)ctx, (String)buf2.toString(), (Object[])params);
                try {
                    if (yearrs.next()) {
                        info.put("yeardebit", this.getBigDecimal((ResultSet)yearrs, 1));
                        info.put("yearcreadit", this.getBigDecimal((ResultSet)yearrs, 2));
                    }
                }
                catch (ORMCoreException e) {
                    throw new BOSException((Throwable)e);
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        info.put("balance", balance);
        return info;
    }

    private BigDecimal getBigDecimal(ResultSet rs, int i) throws SQLException {
        BigDecimal tmpAmt = rs.getBigDecimal(i) != null ? rs.getBigDecimal(i) : SysConstant.BIGZERO;
        return tmpAmt;
    }

    private void validate(Context ctx, BankStatementInfo info) throws EASBizException, BOSException {
        if (info.getCompany() == null) {
            throw new CashCommonException(CashCommonException.NULL_COMPANY);
        }
        if (info.getCurrency() == null) {
            throw new CashCommonException(CashCommonException.NULL_CURRENCY);
        }
        if (info.getAccountBank() == null) {
            throw new CashCommonException(CashCommonException.NULL_BANK);
        }
        if (info.getDebitAmount() == null && info.getCreditAmount() == null) {
            throw new BankStatementException(BankStatementException.DEBIT_CREDIT_NULL);
        }
        Object sett = info.get("settleType");
        if (!(sett instanceof SettlementTypeInfo)) {
            info.setSettleType(null);
        }
        String number = info.getSettleNumber();
        if (FMHelper.isEmpty((String)number)) {
            info.setSettleNumber(null);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"createDate");
        AccountViewInfo accountView = info.getAccountView();
        if (accountView == null) {
            throw new CasException(CasException.ACCT_NULL);
        }
        accountView = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountView.getId()));
        if (!accountView.isIsBank() && !accountView.isIsCash()) {
            throw new CasException(CasException.ACCT_NOTCASBANK, new Object[]{accountView.getNumber()});
        }
        if (info.getDebitAmount() != null && info.getDebitAmount().signum() > 0) {
            info.setIsDebit(true);
            info.setCreditAmount(SysConstant.BIGZERO);
        } else if (info.getCreditAmount() != null && info.getCreditAmount().signum() < 0) {
            info.setIsDebit(false);
            info.setDebitAmount(SysConstant.BIGZERO);
        }
        if (info.getDebitAmount().signum() > 0 && info.getCreditAmount().signum() > 0) {
            throw new BankStatementException(BankStatementException.DEBIT_OR_CREDIT);
        }
        AccountCurrencyVerifyUtil.verifyAccountCurrency((Context)ctx, (String)info.getAccountView().getId().toString(), (String)info.getCurrency().getId().toString());
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BSBatchSubmitVerifyDelegate delegate = new BSBatchSubmitVerifyDelegate(ctx);
        delegate.validate((BankStatementInfo)model);
        super._submit(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BSBatchSubmitVerifyDelegate delegate = new BSBatchSubmitVerifyDelegate(ctx);
        delegate.validate((BankStatementInfo)model);
        return super._submit(ctx, model);
    }

    public void canUpdate(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("verifyStatus"));
        selectors.add(new SelectorItemInfo("source"));
        BankStatementInfo info = this.getBankStatementInfo(ctx, pk, selectors);
        if (info.getVerifyStatus().getValue() != 0) {
            throw new BankStatementException(BankStatementException.VERFIED_CANNOT_UPDATE_DELETE);
        }
    }

    private void isCanDeleteOrEdit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String sql = "select FVerifyStatus,FSource from t_cas_bankstatement where FID = ?";
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            pstmt = cn.prepareStatement(sql);
            pstmt.setString(1, pk.toString());
            rs = pstmt.executeQuery();
            if (rs.next() && (rs.getInt(1) != 0 || rs.getInt("FSource") == 2)) {
                throw new BankStatementException(BankStatementException.VERFIED_CANNOT_UPDATE_DELETE);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)cn);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("verifyStatus"));
        selectors.add(new SelectorItemInfo("*"));
        BankStatementInfo info = this.getBankStatementInfo(ctx, pk, selectors);
        if (info.getVerifyStatus().getValue() != 0) {
            throw new BankStatementException(BankStatementException.VERFIED_CANNOT_UPDATE_DELETE);
        }
        if (info.getSource() != null && !FMHelper.isEmpty((String)info.getSourceBillId())) {
            if (info.getSource() == BSSourceEnum.BYSTTML) {
                String sql = "update T_FS_SubsidiaryLedger set FIsDownLoad=0 where FID =? ";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getSourceBillId()});
            } else if (info.getSource() == BSSourceEnum.BE_IMPORT) {
                String sql = "update T_BE_TransDetail set FIsDownToBankState=0 where FID =? ";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getSourceBillId()});
            }
        }
        super._delete(ctx, pk);
    }

    @Override
    protected void _downLoadFSData(Context ctx, String companyId, String bankAcctId, String innerAcctId, Date beginDate, Date endDate, boolean isSettled) throws BOSException, EASBizException {
        SubsidiaryLedgerCollection subLedgerColl = this.getSubLedgerColl(ctx, innerAcctId, beginDate, endDate);
        HashSet<String> subLedgerIds = new HashSet<String>();
        for (int i = 0; i < subLedgerColl.size(); ++i) {
            subLedgerIds.add(subLedgerColl.get(i).getId().toString());
        }
        String lockSql = "update T_FS_SubsidiaryLedger set FID=FID where fid in" + FMHelper.setTran2String(subLedgerIds);
        DbUtil.execute((Context)ctx, (String)lockSql);
        SubsidiaryLedgerCollection subsidiaryLedgerCollection = this.getSubLedgerColl(ctx, innerAcctId, beginDate, endDate);
        if (subsidiaryLedgerCollection != null && subsidiaryLedgerCollection.size() > 0) {
            AccountBankInfo acctBankInfo = this.getAcctBankInfoById(ctx, bankAcctId);
            CompanyOrgUnitInfo company = this.getCompanyById(ctx, companyId);
            HashMap<Date, PeriodInfo> periodMap = new HashMap<Date, PeriodInfo>();
            int size = subsidiaryLedgerCollection.size();
            String[] ids = new String[size];
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < size; ++i) {
                PeriodInfo startPeriodInfo;
                SubsidiaryLedgerInfo subLedgerInfo = subsidiaryLedgerCollection.get(i);
                BOSUuid bosUuid = subLedgerInfo.getBillId();
                ids[i] = subLedgerInfo.getId().toString();
                String sql = "select count(fid) as count from T_CAS_BANKSTATEMENT where  FSOURCEBILLID= ?";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{ids[i]});
                int row = 0;
                try {
                    if (rs.next()) {
                        row = rs.getInt("count");
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)e);
                }
                if (row > 0) {
                    this.logger.error((Object)("\u5185\u90e8\u8d26\u6237\u660e\u7ec6\u8d26id\uff1a" + ids[i] + " \u5df2\u7ecf\u751f\u6210\u5bf9\u8d26\u5355\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u751f\u6210\u5bf9\u8d26\u5355"));
                    continue;
                }
                String payFullName = null;
                Date date = subLedgerInfo.getDate();
                PeriodInfo period = (PeriodInfo)periodMap.get(date);
                if (period == null) {
                    period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)date, (CompanyOrgUnitInfo)company);
                    periodMap.put(date, period);
                }
                if (period == null) {
                    this.logger.error((Object)("\u5185\u90e8\u8d26\u6237\u660e\u7ec6\u8d26\u751f\u6210\u7684\u5bf9\u8d26\u5355\u65e0\u671f\u95f4,ID\u4e3a:" + ids[i]));
                    continue;
                }
                if (this.bankPeriodMap.get(company.getId().toString()) == null) {
                    startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
                    this.bankPeriodMap.put(company.getId().toString(), startPeriodInfo);
                } else {
                    startPeriodInfo = (PeriodInfo)this.bankPeriodMap.get(company.getId().toString());
                }
                if (null == startPeriodInfo) {
                    this.logger.error((Object)("\u6ca1\u6709\u83b7\u53d6\u5230\u542f\u7528\u671f\u95f4,\u65e0\u6cd5\u751f\u6210,\u660e\u7ec6ID\u4e3a:" + subLedgerInfo.getId()));
                    continue;
                }
                if (date.before(startPeriodInfo.getBeginDate())) {
                    this.logger.error((Object)("\u5185\u90e8\u8d26\u6237\u660e\u7ec6\u8d26\u751f\u6210\u7684\u5bf9\u8d26\u5355\u4e1a\u52a1\u65e5\u671f\u5c0f\u4e8e\u5176\u5bf9\u5e94\u7ec4\u7ec7\u7684\u542f\u7528\u671f\u95f4\u5f00\u59cb\u65e5\u671f,\u65e0\u6cd5\u751f\u6210,\u660e\u7ec6ID\u4e3a:" + subLedgerInfo.getId()));
                    continue;
                }
                BankStatementInfo bankStatInfo = new BankStatementInfo();
                bankStatInfo.setAccountBank(acctBankInfo);
                bankStatInfo.setCurrency(subLedgerInfo.getCurrency());
                bankStatInfo.setSource(BSSourceEnum.BYSTTML);
                bankStatInfo.setSourceBillId(subLedgerInfo.getId().toString());
                bankStatInfo.setCompany(company);
                bankStatInfo.setSettleType(subLedgerInfo.getSettleType());
                bankStatInfo.setSettleNumber(subLedgerInfo.getSettleNumber());
                bankStatInfo.setCreateDate(date);
                bankStatInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                bankStatInfo.setLineNo(i);
                bankStatInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
                bankStatInfo.setPeriod(period);
                bankStatInfo.setDebitAmount(subLedgerInfo.getCreditAmount());
                bankStatInfo.setCreditAmount(subLedgerInfo.getDebitAmount());
                boolean isDebit = false;
                if (bankStatInfo.getDebitAmount() != null && bankStatInfo.getDebitAmount().signum() > 0) {
                    isDebit = true;
                }
                bankStatInfo.setIsDebit(isDebit);
                if (bosUuid.getType().equals((Object)new SettlementBill().getType())) {
                    ISettlementBill iSettleBill = SettlementBillFactory.getLocalInstance((Context)ctx);
                    SettlementBillInfo settlementBill = (SettlementBillInfo)iSettleBill.getValue((IObjectPK)new ObjectUuidPK(bosUuid.toString()));
                    SettBizTypeEnum settBizTypeEnum = settlementBill.getType();
                    if (settBizTypeEnum == SettBizTypeEnum.RECOUTSIDE || settBizTypeEnum == SettBizTypeEnum.PAYOUTSIDE) {
                        boolean hasCashier;
                        boolean bl = hasCashier = settlementBill.getCashier() != null;
                        if (!isSettled && !hasCashier) continue;
                    }
                    payFullName = settBizTypeEnum.equals((Object)SettBizTypeEnum.RECINSIDE) || settBizTypeEnum.equals((Object)SettBizTypeEnum.RECINSIDEDIF) || settBizTypeEnum.equals((Object)SettBizTypeEnum.PAYINSIDE) || settBizTypeEnum.equals((Object)SettBizTypeEnum.PAYINSIDEDIF) ? (bankStatInfo.getDebitAmount() != null && bankStatInfo.getDebitAmount().signum() != 0 ? settlementBill.getPayeeFullName() : settlementBill.getPayerFullName()) : (settBizTypeEnum.equals((Object)SettBizTypeEnum.RECOUTSIDE) ? settlementBill.getPayerFullName() : settlementBill.getPayeeFullName());
                }
                if (payFullName != null) {
                    bankStatInfo.setOppUnit(payFullName);
                }
                if (subLedgerInfo.getCpInnerAccount() != null) {
                    bankStatInfo.setOppAccountNumber(subLedgerInfo.getCpInnerAccount().getAcctNumber());
                } else if (isDebit) {
                    bankStatInfo.setOppAccountNumber(subLedgerInfo.getPayeeBankAcct());
                } else {
                    bankStatInfo.setOppAccountNumber(subLedgerInfo.getPayerBankAcct());
                }
                bankStatInfo.setDescription(subLedgerInfo.getDescription());
                bankStatInfo.setFpItem(subLedgerInfo.getFpitem());
                idSet.add(subLedgerInfo.getId().toString());
                AccountViewInfo accountViewInfo = this.getAccountViewInfo(ctx, bankStatInfo);
                if (!EmptyUtil.isEmpty((CoreBaseInfo)accountViewInfo)) {
                    bankStatInfo.setAccountView(accountViewInfo);
                } else {
                    bankStatInfo.setAccountView(acctBankInfo.getAccount());
                }
                this._addnew(ctx, (IObjectValue)bankStatInfo);
            }
            if (idSet.size() > 0) {
                this.setDownLoadFlag(ctx, idSet);
            }
        } else {
            throw new BankStatementException(BankStatementException.CHECKDOWNLOADFS);
        }
    }

    @Override
    protected int _downLoadFSData4Schedule(Context ctx, DownLoadBankParam param) throws BOSException, EASBizException {
        String bankAcctId = param.getBankAccount();
        String innerAcctId = param.getinnerAcct();
        String companyId = param.getCompany();
        Date beginDate = param.getBeginDate();
        Date endDate = param.getEndDate();
        SubsidiaryLedgerCollection subLedgerColl = this.getSubLedgerColl(ctx, innerAcctId, beginDate, endDate);
        HashSet<String> subLedgerIds = new HashSet<String>();
        for (int i = 0; i < subLedgerColl.size(); ++i) {
            subLedgerIds.add(subLedgerColl.get(i).getId().toString());
        }
        String lockSql = "update T_FS_SubsidiaryLedger set FID=FID where fid in" + FMHelper.setTran2String(subLedgerIds);
        DbUtil.execute((Context)ctx, (String)lockSql);
        SubsidiaryLedgerCollection subsidiaryLedgerCollection = this.getSubLedgerColl(ctx, innerAcctId, beginDate, endDate);
        int count = subsidiaryLedgerCollection.size();
        if (subsidiaryLedgerCollection != null && subsidiaryLedgerCollection.size() > 0) {
            AccountBankInfo acctBankInfo = this.getAcctBankInfoById(ctx, bankAcctId);
            CompanyOrgUnitInfo company = this.getCompanyById(ctx, companyId);
            HashMap<Date, PeriodInfo> periodMap = new HashMap<Date, PeriodInfo>();
            int size = subsidiaryLedgerCollection.size();
            String[] ids = new String[size];
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < size; ++i) {
                PeriodInfo startPeriodInfo;
                SubsidiaryLedgerInfo subLedgerInfo = subLedgerColl.get(i);
                ids[i] = subLedgerInfo.getId().toString();
                String sql = "select count(fid) as count from T_CAS_BANKSTATEMENT where  FSOURCEBILLID= ?";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{ids[i]});
                int row = 0;
                try {
                    if (rs.next()) {
                        row = rs.getInt("count");
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)e);
                }
                if (row > 0) {
                    this.logger.error((Object)("\u5185\u90e8\u8d26\u6237\u660e\u7ec6\u8d26id\uff1a" + ids[i] + " \u5df2\u7ecf\u751f\u6210\u5bf9\u8d26\u5355\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u751f\u6210\u5bf9\u8d26\u5355"));
                    continue;
                }
                BOSUuid bosUuid = subLedgerInfo.getBillId();
                String payFullName = null;
                Date date = subLedgerInfo.getDate();
                PeriodInfo period = (PeriodInfo)periodMap.get(date);
                if (period == null) {
                    period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)date, (CompanyOrgUnitInfo)company);
                    periodMap.put(date, period);
                }
                if (period == null) {
                    this.logger.error((Object)("\u5185\u90e8\u8d26\u6237\u660e\u7ec6\u8d26\u751f\u6210\u7684\u5bf9\u8d26\u5355\u65e0\u671f\u95f4,ID\u4e3a:" + ids[i]));
                    continue;
                }
                if (this.bankPeriodMap.get(company.getId().toString()) == null) {
                    startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
                    this.bankPeriodMap.put(company.getId().toString(), startPeriodInfo);
                } else {
                    startPeriodInfo = (PeriodInfo)this.bankPeriodMap.get(company.getId().toString());
                }
                if (null == startPeriodInfo) {
                    this.logger.error((Object)("\u6ca1\u6709\u83b7\u53d6\u5230\u542f\u7528\u671f\u95f4,\u65e0\u6cd5\u751f\u6210,\u660e\u7ec6ID\u4e3a:" + subLedgerInfo.getId()));
                    continue;
                }
                if (date.before(startPeriodInfo.getBeginDate())) {
                    this.logger.error((Object)("\u5185\u90e8\u8d26\u6237\u660e\u7ec6\u8d26\u751f\u6210\u7684\u5bf9\u8d26\u5355\u4e1a\u52a1\u65e5\u671f\u5c0f\u4e8e\u5176\u5bf9\u5e94\u7ec4\u7ec7\u7684\u542f\u7528\u671f\u95f4\u5f00\u59cb\u65e5\u671f,\u65e0\u6cd5\u751f\u6210,\u660e\u7ec6ID\u4e3a:" + subLedgerInfo.getId()));
                    continue;
                }
                BankStatementInfo bankStatInfo = new BankStatementInfo();
                bankStatInfo.setAccountBank(acctBankInfo);
                bankStatInfo.setCurrency(subLedgerInfo.getCurrency());
                bankStatInfo.setSource(BSSourceEnum.BYSTTML);
                bankStatInfo.setSourceBillId(subLedgerInfo.getId().toString());
                bankStatInfo.setCompany(company);
                bankStatInfo.setSettleType(subLedgerInfo.getSettleType());
                bankStatInfo.setSettleNumber(subLedgerInfo.getSettleNumber());
                bankStatInfo.setCreateDate(date);
                bankStatInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                bankStatInfo.setLineNo(i);
                bankStatInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
                bankStatInfo.setPeriod(period);
                bankStatInfo.setDebitAmount(subLedgerInfo.getCreditAmount());
                bankStatInfo.setCreditAmount(subLedgerInfo.getDebitAmount());
                boolean isDebit = false;
                if (bankStatInfo.getDebitAmount() != null && bankStatInfo.getDebitAmount().signum() > 0) {
                    isDebit = true;
                }
                bankStatInfo.setIsDebit(isDebit);
                if (bosUuid.getType().equals((Object)new SettlementBill().getType())) {
                    ISettlementBill iSettleBill = SettlementBillFactory.getLocalInstance((Context)ctx);
                    SettlementBillInfo settlementBill = (SettlementBillInfo)iSettleBill.getValue((IObjectPK)new ObjectUuidPK(bosUuid.toString()));
                    SettBizTypeEnum settBizTypeEnum = settlementBill.getType();
                    if (settBizTypeEnum == SettBizTypeEnum.RECOUTSIDE || settBizTypeEnum == SettBizTypeEnum.PAYOUTSIDE) {
                        boolean hasCashier;
                        boolean bl = hasCashier = settlementBill.getCashier() != null;
                        if (!hasCashier) continue;
                    }
                    payFullName = settBizTypeEnum.equals((Object)SettBizTypeEnum.RECINSIDE) || settBizTypeEnum.equals((Object)SettBizTypeEnum.RECINSIDEDIF) || settBizTypeEnum.equals((Object)SettBizTypeEnum.PAYINSIDE) || settBizTypeEnum.equals((Object)SettBizTypeEnum.PAYINSIDEDIF) ? (bankStatInfo.getDebitAmount() != null && bankStatInfo.getDebitAmount().signum() != 0 ? settlementBill.getPayeeFullName() : settlementBill.getPayerFullName()) : (settBizTypeEnum.equals((Object)SettBizTypeEnum.RECOUTSIDE) ? settlementBill.getPayerFullName() : settlementBill.getPayeeFullName());
                }
                if (payFullName != null) {
                    bankStatInfo.setOppUnit(payFullName);
                }
                if (subLedgerInfo.getCpInnerAccount() != null) {
                    bankStatInfo.setOppAccountNumber(subLedgerInfo.getCpInnerAccount().getAcctNumber());
                } else if (isDebit) {
                    bankStatInfo.setOppAccountNumber(subLedgerInfo.getPayeeBankAcct());
                } else {
                    bankStatInfo.setOppAccountNumber(subLedgerInfo.getPayerBankAcct());
                }
                bankStatInfo.setDescription(subLedgerInfo.getDescription());
                bankStatInfo.setFpItem(subLedgerInfo.getFpitem());
                idSet.add(subLedgerInfo.getId().toString());
                AccountViewInfo accountViewInfo = this.getAccountViewInfo(ctx, bankStatInfo);
                if (!EmptyUtil.isEmpty((CoreBaseInfo)accountViewInfo)) {
                    bankStatInfo.setAccountView(accountViewInfo);
                } else {
                    bankStatInfo.setAccountView(acctBankInfo.getAccount());
                }
                this._addnew(ctx, (IObjectValue)bankStatInfo);
            }
            if (idSet.size() > 0) {
                this.setDownLoadFlag(ctx, idSet);
            }
        } else {
            throw new BankStatementException(BankStatementException.CHECKDOWNLOADFS);
        }
        return count;
    }

    private void setDownLoadFlag(Context ctx, Set idSet) throws BOSException, EASBizException {
        String sql = "update T_FS_SubsidiaryLedger set FIsDownLoad=1 where  fid in" + FMHelper.setTran2String((Set)idSet);
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private SubsidiaryLedgerCollection getSubLedgerColl(Context ctx, String innerAcctId, Date beginDate, Date endDate) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filter = filterInfo.getFilterItems();
        filter.add(new FilterItemInfo("innerAccount.id", (Object)innerAcctId));
        filter.add(new FilterItemInfo("date", (Object)DateTimeUtils.truncateDate((Date)beginDate), CompareType.GREATER_EQUALS));
        filter.add(new FilterItemInfo("date", (Object)DateTimeUtils.truncateDate((Date)endDate), CompareType.LESS_EQUALS));
        filter.add(new FilterItemInfo("isDownLoad", (Object)Boolean.FALSE));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("cpInnerAccount.*"));
        return SubsidiaryLedgerFactory.getLocalInstance((Context)ctx).getSubsidiaryLedgerCollection(viewInfo);
    }

    private AccountBankInfo getAcctBankInfoById(Context ctx, String acctBankId) throws EASBizException, BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("bank.id");
        selector.add("bank.name");
        selector.add("bank.number");
        selector.add("account.id");
        selector.add("account.name");
        selector.add("account.number");
        FilterInfo fi = new FilterInfo();
        FilterItemCollection items = fi.getFilterItems();
        items.add(new FilterItemInfo("id", (Object)acctBankId));
        evi.setFilter(fi);
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        AccountBankCollection acctBankCol = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(evi);
        return acctBankCol == null ? null : acctBankCol.get(0);
    }

    @Override
    protected int _downloadBankState(Context ctx, DownLoadBankParam downLoadBankParam) throws BOSException, EASBizException {
        if (downLoadBankParam == null) {
            throw new BankStatementException(BankStatementException.NODOWNPARAM);
        }
        TransDetailCollection colls = this.getTransDetailColl(ctx, downLoadBankParam);
        HashSet<String> trandDetailIDs = new HashSet<String>();
        for (int i = 0; i < colls.size(); ++i) {
            trandDetailIDs.add(colls.get(i).getId().toString());
        }
        String sql = "update T_BE_TransDetail set FLASTUPDATETIME = ? where fid in" + FMHelper.setTran2String(trandDetailIDs);
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Timestamp(System.currentTimeMillis())});
        TransDetailCollection transDetailCollectionNew = this.getTransDetailColl(ctx, downLoadBankParam);
        HashSet<TransDetailInfo> allColSet = new HashSet<TransDetailInfo>();
        for (int index = 0; index < transDetailCollectionNew.size(); ++index) {
            allColSet.add(transDetailCollectionNew.get(index));
        }
        TransToBankStateService service = new TransToBankStateService();
        Object result = service.mutilThreadTrans(ctx, allColSet);
        if (result instanceof Integer) {
            return (Integer)result;
        }
        if (result instanceof Map) {
            String error = (String)((Map)result).get("err");
            throw new BEException(BEException.COMMON, new Object[]{error});
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int _recTrans(Context ctx, Set objSet) throws BOSException, EASBizException {
        HashSet flagTransDetailIDs = new HashSet();
        HashSet FakeTransDetailIDs = new HashSet();
        HashSet<String> noMutexTransDetailIDs = new HashSet<String>();
        this.getTransDetailIDs(objSet, flagTransDetailIDs, FakeTransDetailIDs);
        this.setTransDetailDownFlag(ctx, flagTransDetailIDs);
        this.deleteBankStatementReceivedToday(ctx, FakeTransDetailIDs);
        CoreBaseCollection bankStatementCollection = new CoreBaseCollection();
        HashSet<String> trandDetailIDs = new HashSet<String>();
        int i = 0;
        Iterator it = objSet.iterator();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ConcurrentHashMap<String, AccountViewInfo> acctMap = new ConcurrentHashMap<String, AccountViewInfo>();
        try {
            while (it.hasNext()) {
                boolean boolResult;
                TransDetailInfo transDetailInfo = (TransDetailInfo)it.next();
                String id = transDetailInfo.getId().toString();
                String sql = "select count(fid) as count from T_CAS_BANKSTATEMENT where  FSOURCEBILLID= ?";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{id});
                int row = 0;
                try {
                    if (rs.next()) {
                        row = rs.getInt("count");
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)e);
                }
                if (row > 0) {
                    this.logger.error((Object)("\u4ea4\u6613\u660e\u7ec6 id\uff1a" + id + " \u5df2\u7ecf\u751f\u6210\u5bf9\u8d26\u5355\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u751f\u6210\u5bf9\u8d26\u5355"));
                }
                if ((boolResult = iMutex.requestObjIDForUpdate(id)) && row == 0) {
                    AccountViewInfo accountViewInfo;
                    PeriodInfo startPeriodInfo;
                    Date bizDate = DateTimeUtils.truncateDate((Date)transDetailInfo.getBizTime());
                    if (this.bankPeriodMap.get(transDetailInfo.getCompany().getId().toString()) == null) {
                        startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)transDetailInfo.getCompany());
                        this.bankPeriodMap.put(transDetailInfo.getCompany().getId().toString(), startPeriodInfo);
                    } else {
                        startPeriodInfo = (PeriodInfo)this.bankPeriodMap.get(transDetailInfo.getCompany().getId().toString());
                    }
                    if (null == startPeriodInfo) {
                        noMutexTransDetailIDs.add(id);
                        this.logger.error((Object)("\u6ca1\u6709\u83b7\u53d6\u5230\u542f\u7528\u671f\u95f4,\u65e0\u6cd5\u751f\u6210,\u660e\u7ec6ID\u4e3a:" + transDetailInfo.getId()));
                        continue;
                    }
                    if (bizDate.before(startPeriodInfo.getBeginDate())) {
                        noMutexTransDetailIDs.add(id);
                        this.logger.error((Object)("\u4ea4\u6613\u660e\u7ec6\u751f\u6210\u7684\u5bf9\u8d26\u5355\u4e1a\u52a1\u65e5\u671f\u5c0f\u4e8e\u5176\u5bf9\u5e94\u7ec4\u7ec7\u7684\u542f\u7528\u671f\u95f4\u5f00\u59cb\u65e5\u671f,\u65e0\u6cd5\u751f\u6210,\u660e\u7ec6ID\u4e3a:" + transDetailInfo.getId()));
                        continue;
                    }
                    BankStatementInfo bankStatementInfo = this.createBankStateInfo(ctx, transDetailInfo);
                    String key = bankStatementInfo.getAccountBank().getId().toString() + bankStatementInfo.getCreateDate().toString();
                    if (acctMap.containsKey(key)) {
                        accountViewInfo = (AccountViewInfo)acctMap.get(key);
                        bankStatementInfo.setAccountView(accountViewInfo);
                    } else {
                        accountViewInfo = this.getAccountViewInfo(ctx, bankStatementInfo);
                        if (!EmptyUtil.isEmpty((CoreBaseInfo)accountViewInfo)) {
                            bankStatementInfo.setAccountView(accountViewInfo);
                            acctMap.put(key, accountViewInfo);
                        }
                    }
                    if (bankStatementInfo.getPeriod() == null) {
                        this.logger.error((Object)("\u4ea4\u6613\u660e\u7ec6\u751f\u6210\u7684\u5bf9\u8d26\u5355\u65e0\u671f\u95f4,\u660e\u7ec6ID\u4e3a:" + transDetailInfo.getId()));
                        noMutexTransDetailIDs.add(id);
                        continue;
                    }
                    bankStatementCollection.add((CoreBaseInfo)bankStatementInfo);
                    trandDetailIDs.add(id);
                    ++i;
                    continue;
                }
                this.logger.error((Object)("\u672a\u83b7\u53d6\u4ea4\u6613\u660e\u7ec6id\uff1a" + id + " \u7f51\u7edc\u4e92\u65a5\u9501\u6216\u8005\u5df2\u751f\u6210\u94f6\u884c\u5bf9\u8d26\u5355"));
                noMutexTransDetailIDs.add(id);
            }
            this.logger.error((Object)("\u751f\u6210\u94f6\u884c\u5bf9\u8d26\u5355\u7684\u4ea4\u6613\u660e\u7ec6\u7684ID\u96c6\u5408\uff1a" + trandDetailIDs));
            if (bankStatementCollection.size() > 0) {
                BankStatementFactory.getLocalInstance(ctx).addnewBatchData(bankStatementCollection);
            }
            if (noMutexTransDetailIDs.size() > 0) {
                this.setTransDetailDownFlagFalse(ctx, noMutexTransDetailIDs);
            }
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate(FMHelper.set2List(trandDetailIDs));
        }
        return bankStatementCollection.size();
    }

    private void deleteBankStatementReceivedToday(Context ctx, Set transDetailIDSet) throws BOSException, EASBizException {
        if (transDetailIDSet.size() > 0) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("source", (Object)new Integer(3)));
            filterInfo.getFilterItems().add(new FilterItemInfo("verifyStatus", (Object)new Integer(0)));
            filterInfo.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)transDetailIDSet, CompareType.INCLUDE));
            this.delete(ctx, filterInfo);
        }
    }

    private void setTransDetailDownFlag(Context ctx, Set trandDetailIDs) throws SQLDataException, BOSException {
        String sql = "update T_BE_TransDetail set FIsDownToBankState=1 where Fid in " + FMHelper.setTran2String((Set)trandDetailIDs);
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void setTransDetailDownFlagFalse(Context ctx, Set trandDetailIDs) throws SQLDataException, BOSException {
        String sql = "update T_BE_TransDetail set FIsDownToBankState=0 where Fid in " + FMHelper.setTran2String((Set)trandDetailIDs);
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private AccountViewInfo getAccountViewInfo(Context ctx, BankStatementInfo bankStatementInfo) throws BOSException, EASBizException {
        Date beginDate;
        Date endDate = beginDate = DateTimeUtils.truncateDate((Date)bankStatementInfo.getCreateDate());
        FetchParamHelper fph = new FetchParamHelper(ctx);
        String acctTableId = fph.getAcctTableId(ctx, beginDate, endDate, bankStatementInfo.getCompany().getId().toString());
        HashSet<String> idSet = new HashSet<String>();
        String accountBankId = bankStatementInfo.getAccountBank().getId().toString();
        idSet.add(accountBankId);
        AccountViewInfo accountViewInfo = null;
        try {
            Map map = FMHelper.getJBAcctBankAcctViewMap((Context)ctx, idSet, null, (String)acctTableId);
            accountViewInfo = (AccountViewInfo)map.get(accountBankId);
        }
        catch (Exception e) {
            this.logger.error((Object)"getAccountViewInfo:", (Throwable)e);
        }
        return accountViewInfo;
    }

    protected BankStatementInfo createBankStateInfo(Context ctx, TransDetailInfo transDetailInfo) throws EASBizException, BOSException {
        BankStatementInfo bankStatementInfo = new BankStatementInfo();
        UserInfo currentUser = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        bankStatementInfo.setCreator(currentUser);
        bankStatementInfo.setCompany(transDetailInfo.getCompany());
        bankStatementInfo.setAccountView(transDetailInfo.getBankAccount().getAccount());
        bankStatementInfo.setAccountBank(transDetailInfo.getBankAccount());
        bankStatementInfo.setCurrency(transDetailInfo.getCurrency());
        Date createDate = DateTimeUtils.truncateDate((Date)transDetailInfo.getBizTime());
        PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)createDate, (CompanyOrgUnitInfo)transDetailInfo.getCompany());
        bankStatementInfo.setPeriod(periodInfo);
        bankStatementInfo.setCreateDate(createDate);
        if (!EmptyUtil.isEmpty((String)transDetailInfo.getBusinessType())) {
            bankStatementInfo.setBusinessType(transDetailInfo.getBusinessType());
        }
        bankStatementInfo.setDescription(transDetailInfo.getDescription());
        bankStatementInfo.setSettleType(null);
        if (!EmptyUtil.isEmpty((String)transDetailInfo.getNumber())) {
            bankStatementInfo.setSettleNumber(transDetailInfo.getNumber());
        } else {
            bankStatementInfo.setSettleNumber(transDetailInfo.getTranPackageID());
        }
        BigDecimal debitAmount = transDetailInfo.getDebitAmount();
        BigDecimal creditAmount = transDetailInfo.getCreditAmount();
        if (debitAmount == null) {
            debitAmount = FMConstants.ZERO;
        }
        if (creditAmount == null) {
            creditAmount = FMConstants.ZERO;
        }
        bankStatementInfo.setDebitAmount(debitAmount);
        bankStatementInfo.setCreditAmount(creditAmount);
        if (debitAmount.compareTo(FMConstants.ZERO) != 0) {
            bankStatementInfo.setIsDebit(true);
        } else {
            bankStatementInfo.setIsDebit(false);
        }
        bankStatementInfo.setSequenceNumber(null);
        bankStatementInfo.setTradeNumber(null);
        bankStatementInfo.setCashier(null);
        bankStatementInfo.setVoucherNumber(transDetailInfo.getNumber());
        bankStatementInfo.setOppUnit(transDetailInfo.getOppUnit());
        bankStatementInfo.setOppAccountNumber(transDetailInfo.getOppBankNumber());
        bankStatementInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        bankStatementInfo.setSource(BSSourceEnum.BE_IMPORT);
        bankStatementInfo.setSourceBillId(transDetailInfo.getId().toString());
        bankStatementInfo.setLineNo(transDetailInfo.getLineNo());
        bankStatementInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        bankStatementInfo.setSortedID(transDetailInfo.getSortedID());
        String bankCheckFalg = transDetailInfo.getBankCheckFlag();
        if (null != bankCheckFalg && bankCheckFalg.length() > 0) {
            bankStatementInfo.setBankVouvherNo(bankCheckFalg);
        }
        bankStatementInfo.setTransdetailSource(transDetailInfo.getIsDataImport());
        return bankStatementInfo;
    }

    private TransDetailCollection getTransDetailColl(Context ctx, DownLoadBankParam downLoadBankParam) throws BOSException, BankStatementException {
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isDownToBankState", (Object)FMConstants.FALSE));
        if (!downLoadBankParam.isIsconDetailReced()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isReced", (Object)TransDetailRecedEnum.noNeedReced.getValue(), CompareType.NOTEQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)downLoadBankParam.getBankAccountIdSet(), CompareType.INCLUDE));
        Date beginDate = DateTimeUtils.truncateDate((Date)downLoadBankParam.getBeginDate());
        Date endDate = DateTimeUtils.truncateDate((Date)DateHelper.getNextDay((Date)downLoadBankParam.getEndDate()));
        filterInfo.getFilterItems().add(new FilterItemInfo("bizTime", (Object)beginDate, CompareType.GREATER_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("bizTime", (Object)endDate, CompareType.LESS));
        if (!downLoadBankParam.isIsconTransDownUp()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isTransUp", (Object)FMConstants.FALSE));
            filterInfo.getFilterItems().add(new FilterItemInfo("isTransDown", (Object)FMConstants.FALSE));
        }
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("bizTime"));
        sorter.add(new SorterItemInfo("sortedID"));
        entityView.setSorter(sorter);
        entityView.setFilter(filterInfo);
        entityView.getSelector().add(new SelectorItemInfo("*"));
        entityView.getSelector().add(new SelectorItemInfo("bankAccount.*"));
        ITransDetail transDetail = TransDetailFactory.getLocalInstance((Context)ctx);
        this.logger.error((Object)("\u4e0b\u8f7d\u5bf9\u8d26\u5355\u65f6\u5019\u7684\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u7684SQL\uff1a" + entityView.getFilter().toSql()));
        TransDetailCollection transDetailCollection = transDetail.getTransDetailCollection(entityView);
        if (transDetailCollection.size() <= 0) {
            throw new BankStatementException(BankStatementException.NOTRANSDETAILTODOWN);
        }
        return transDetailCollection;
    }

    private CompanyOrgUnitInfo getCompanyById(Context ctx, String strId) throws EASBizException, BOSException {
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo company = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(strId));
        return company;
    }

    @Override
    protected void _batchSumbit(Context ctx, BankStatementCollection bankStatementCol) throws BOSException, EASBizException {
        BSBatchSubmitVerifyDelegate delegate = new BSBatchSubmitVerifyDelegate(ctx);
        if (bankStatementCol != null && bankStatementCol.size() > 0) {
            for (int i = 0; i < bankStatementCol.size(); ++i) {
                delegate.validate(bankStatementCol.get(i));
                super.addnew(ctx, (CoreBaseInfo)bankStatementCol.get(i));
            }
        }
    }

    @Override
    protected void _batchDelete(Context ctx, Set bankStatementIDs) throws BOSException, EASBizException {
        if (bankStatementIDs != null && bankStatementIDs.size() > 0) {
            for (String id : bankStatementIDs) {
                super.delete(ctx, (IObjectPK)new ObjectUuidPK(id));
            }
        }
    }

    @Override
    protected BigDecimal _getRecentAmt(Context ctx, String bankId, String currencyId, String companyId, Date startDate) throws BOSException {
        StringBuffer buf = new StringBuffer();
        buf.append("select fdebit,fcredit,fbalance ,forder from (");
        buf.append(" select sum(FDebitStartAmt) FDebit, sum(FCreditStartAmt) FCredit,");
        buf.append(" sum(FMonthStartAmt) FBalance ,0 as forder from t_cas_journalBalance where ");
        buf.append(" FType = 3 and FIsInit = 1 and");
        buf.append(" FCompanyId = ? and FAccountBankId = ? and FCurrencyId = ?");
        buf.append(" union all");
        buf.append(" select sum(FDebitAmount) FDebit, sum(FCreditAmount) FCredit,");
        buf.append(" 0 FBalance ,1 as forder from t_cas_bankstatement where FCompanyId = ?");
        buf.append(" and FAccountBankId = ? and FCurrencyId = ?");
        buf.append(" and FPeriodId IS NOT NULL and FCreateDate < ?");
        buf.append(" ) b order by forder");
        String sql = buf.toString();
        BigDecimal debit = SysConstant.BIGZERO;
        BigDecimal credit = SysConstant.BIGZERO;
        BigDecimal balance = SysConstant.BIGZERO;
        BigDecimal tmpAmt = SysConstant.BIGZERO;
        Connection cn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            cn = this.getConnection(ctx);
            pstmt = cn.prepareStatement(sql);
            int index = 1;
            pstmt.setString(index++, companyId.toString());
            pstmt.setString(index++, bankId.toString());
            pstmt.setString(index++, currencyId.toString());
            pstmt.setString(index++, companyId.toString());
            pstmt.setString(index++, bankId.toString());
            pstmt.setString(index++, currencyId.toString());
            pstmt.setTimestamp(index++, new Timestamp(startDate.getTime()));
            rs = pstmt.executeQuery();
            boolean fInit = true;
            while (rs.next()) {
                tmpAmt = this.getBigDecimal(rs, 1);
                debit = debit.add(tmpAmt);
                if (!fInit) {
                    balance = balance.subtract(tmpAmt);
                }
                tmpAmt = this.getBigDecimal(rs, 2);
                credit = credit.add(tmpAmt);
                if (!fInit) {
                    balance = balance.add(tmpAmt);
                }
                if (fInit && rs.getBigDecimal(3) != null) {
                    balance = balance.add(rs.getBigDecimal(3));
                    this.logger.info((Object)("initAmt: " + balance));
                }
                fInit = false;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)cn);
        this.logger.info((Object)("debit:" + debit + " credit:" + credit + " balance:" + balance));
        return balance;
    }

    private void getTransDetailIDs(Set objSet, Set flagTransDetailIDs, Set FaketransDetailIDs) {
        for (TransDetailInfo info : objSet) {
            flagTransDetailIDs.add(info.getId().toString());
            if (!info.isIsFakeDetail()) continue;
            FaketransDetailIDs.add(info.getId().toString());
        }
    }
}

