/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SharedAcctInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AbstractFMDataImport;
import com.kingdee.eas.fi.cas.BSSourceEnum;
import com.kingdee.eas.fi.cas.BankStatementFactory;
import com.kingdee.eas.fi.cas.BankStatementInfo;
import com.kingdee.eas.fi.cas.app.RecAndPayDataImportUtil2;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.util.FetchParamHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

public class BankStatementDataImport
extends AbstractFMDataImport {
    String resourcePath = "com.kingdee.eas.fi.cas.BankStatementResource";
    private int lineNumber = 0;

    @Override
    protected ICoreBase _getController(Context ctx) throws BOSException, EASBizException {
        return BankStatementFactory.getLocalInstance(ctx);
    }

    @Override
    protected String getTemplateNumber() {
        return "BankStatement";
    }

    @Override
    protected CoreBaseInfo _transmit(Hashtable hsData, Context ctx) throws EASBizException, BOSException {
        PeriodInfo bankStatePeriod;
        PeriodInfo startPeriodInfo;
        BankStatementInfo bankStatement = new BankStatementInfo();
        this.prepareImport(ctx, (IObjectValue)bankStatement, hsData);
        bankStatement.setLineNo(this.lineNumber++);
        if (bankStatement.getAccountBank() == null) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"NoAccountToDown", (Locale)ctx.getLocale()));
        }
        if (bankStatement.getCompany() == null) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"NoCompanyToDown", (Locale)ctx.getLocale()));
        }
        if (bankStatement.getCurrency() == null) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"NoCurrencyToDown", (Locale)ctx.getLocale()));
        }
        if (bankStatement.getCreateDate() == null) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"NoCreateDateToDown", (Locale)ctx.getLocale()));
        }
        if (bankStatement.getCreateDate() != null) {
            Date createDate = bankStatement.getCreateDate();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String format = dateFormat.format(createDate);
            try {
                bankStatement.setCreateDate(dateFormat.parse(format));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        Object companyData = this.getData(hsData, "company");
        CompanyOrgUnitInfo company = RecAndPayDataImportUtil2.getCompanyByNumber(ctx, (String)companyData);
        PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString()), (IObjectPK)new ObjectUuidPK(company.getId().toString()), "cas_bankstatement_02addNew");
        PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString()), (IObjectPK)new ObjectUuidPK(company.getId().toString()), "cas_bankstatement_06import");
        AccountBankInfo accountBank = null;
        Object accountBankData = this.getData(hsData, "accountBank");
        AccountBankCollection accountBanks = this.getAccountbanks(ctx, accountBankData, company.getId().toString());
        for (int i = 0; i < accountBanks.size(); ++i) {
            AccountBankInfo accbank = accountBanks.get(i);
            boolean isshareAcctCompany = this.isShareBalanceOfAcctCompany(ctx, accbank, company.getId().toString());
            if (!isshareAcctCompany) continue;
            accountBank = accbank;
            break;
        }
        if (accountBank == null) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"NoIsShareAcctCompany", (Locale)ctx.getLocale()));
        }
        String param = ContextHelperFactory.getLocalInstance((Context)ctx).getStringParam("CS113", (IObjectPK)new ObjectUuidPK(company.getId()));
        if (param != null && param.toString().equals("1") && accountBank.isIsSetBankInterface()) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"notAllowBankInterface", (Locale)ctx.getLocale()));
        }
        if (!accountBank.getCompany().getId().toString().equals(company.getId().toString())) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"AccountNotMatchCompany", (Locale)ctx.getLocale()));
        }
        if (accountBank.isIsClosed()) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"AccountBankHasCancel", (Locale)ctx.getLocale()));
        }
        Object CurrencyData = this.getData(hsData, "currency");
        CurrencyInfo curInfo = this.getCurrency(ctx, CurrencyData);
        ICurrency cur = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyInfo accountCur = null;
        if (accountBank.isIsByCurrency() && !curInfo.equals((Object)(accountCur = (CurrencyInfo)cur.getValue((IObjectPK)new ObjectUuidPK(accountBank.getCurrency().getId()))))) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"AccountNotMatchCurrency", (Locale)ctx.getLocale()));
        }
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)bankStatement.getCompany());
        Date createDate = bankStatement.getCreateDate();
        if (createDate.before((startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company)).getBeginDate())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"CheckBeginDate", (Locale)ctx.getLocale()));
        }
        boolean CS046 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS046", (IObjectPK)new ObjectUuidPK(company.getId()));
        if (!CS046 && createDate.before(periodInfo.getBeginDate())) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"CreateDateNotLesserCurPeriod", (Locale)ctx.getLocale()));
        }
        bankStatement.setBizTime(new Timestamp(createDate.getTime()));
        if (createDate.after(periodInfo.getEndDate())) {
            bankStatement.setBizTime(new Timestamp(periodInfo.getEndDate().getTime()));
        }
        if ((bankStatePeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)createDate, (CompanyOrgUnitInfo)company)) == null) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"CreateDateNoPeriod", (Locale)ctx.getLocale()));
        }
        bankStatement.setPeriod(PeriodUtils.getPeriodInfo((Context)ctx, (Date)createDate, (CompanyOrgUnitInfo)company));
        BigDecimal zero = FMConstants.ZERO;
        if (bankStatement.getDebitAmount() == null || bankStatement.getDebitAmount().compareTo(zero) == 0) {
            bankStatement.setDebitAmount(zero);
            bankStatement.setIsDebit(false);
        }
        if (bankStatement.getCreditAmount() == null || bankStatement.getCreditAmount().compareTo(zero) == 0) {
            bankStatement.setCreditAmount(zero);
            bankStatement.setIsDebit(true);
        }
        if (zero.compareTo(bankStatement.getDebitAmount()) != 0 && zero.compareTo(bankStatement.getCreditAmount()) != 0) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"debitCreditException", (Locale)ctx.getLocale()));
        }
        if (zero.compareTo(bankStatement.getDebitAmount()) == 0 && zero.compareTo(bankStatement.getCreditAmount()) == 0) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"debitCreditException2", (Locale)ctx.getLocale()));
        }
        BigDecimal debitAmount = bankStatement.getDebitAmount();
        if ((debitAmount = debitAmount.setScale(curInfo.getPrecision(), 4)).compareTo(bankStatement.getDebitAmount()) != 0) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"DebitAmountPrecisionError", (Locale)ctx.getLocale()));
        }
        BigDecimal creditAmount = bankStatement.getCreditAmount();
        if ((creditAmount = creditAmount.setScale(curInfo.getPrecision(), 4)).compareTo(bankStatement.getCreditAmount()) != 0) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"CreditAmountPrecisionError", (Locale)ctx.getLocale()));
        }
        Object desData = this.getData(hsData, "description");
        if (desData != null && desData.toString().trim().length() > 0) {
            if (desData.toString().length() > 255) {
                throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"DescriptionNotBigger", (Locale)ctx.getLocale()) + 255);
            }
            bankStatement.setDescription(desData.toString());
        }
        bankStatement.setAccountBank(accountBank);
        bankStatement.setCompany(accountBank.getCompany());
        AccountViewInfo accountViewInfo = this.getAccountViewInfo(ctx, bankStatement);
        if (!EmptyUtil.isEmpty((CoreBaseInfo)accountViewInfo)) {
            bankStatement.setAccountView(accountViewInfo);
        } else {
            bankStatement.setAccountView(accountBank.getAccount());
        }
        bankStatement.setVerifyStatus(VerifyScopeEnum.NOVA);
        bankStatement.setSource(BSSourceEnum.MANUAL);
        return bankStatement;
    }

    private AccountViewInfo getAccountViewInfo(Context ctx, BankStatementInfo bankStatementInfo) throws BOSException, EASBizException {
        Date beginDate;
        Date endDate = beginDate = DateTimeUtils.truncateDate((Date)bankStatementInfo.getCreateDate());
        FetchParamHelper fph = new FetchParamHelper(ctx);
        String acctTableId = fph.getAcctTableId(ctx, beginDate, endDate, bankStatementInfo.getCompany().getId().toString());
        HashSet<String> idSet = new HashSet<String>();
        String accountBankId = bankStatementInfo.getAccountBank().getId().toString();
        idSet.add(accountBankId);
        AccountViewInfo accountViewInfo = null;
        try {
            Map map = FMHelper.getJBAcctBankAcctViewMap((Context)ctx, idSet, null, (String)acctTableId);
            accountViewInfo = (AccountViewInfo)map.get(accountBankId);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return accountViewInfo;
    }

    private AccountBankCollection getAccountbanks(Context ctx, Object data, String companyId) throws BOSException {
        String number = data.toString().trim();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        viewInfo.setFilter(filter);
        AccountBankCollection acctColl = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(viewInfo);
        if (acctColl == null || acctColl.size() == 0) {
            throw new BOSException(ResourceBase.getString((String)this.resourcePath, (String)"AccountNotExist", (Locale)ctx.getLocale()));
        }
        return acctColl;
    }

    private boolean isShareBalanceOfAcctCompany(Context ctx, AccountBankInfo accountbank, String companyId) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("company.*"));
        selector.add(new SelectorItemInfo("shareAcct.*"));
        selector.add(new SelectorItemInfo("shareType"));
        AccountBankInfo accBankInfo = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountbank.getId().toString()), selector);
        if (accBankInfo.getShareType().getValue() == 0) {
            return true;
        }
        SharedAcctInfo sharedAcctInfo = accBankInfo.getShareAcct();
        return sharedAcctInfo.getShareBalanceOfAcctCompany().getId().toString().equals(companyId);
    }

    @Override
    protected void _submit(CoreBaseInfo coreBaseInfo, Context ctx) throws BOSException, EASBizException {
        if (coreBaseInfo == null) {
            return;
        }
        this._getController(ctx).submit(coreBaseInfo);
    }
}

