/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.app.AbstractBankStatementUIFacadeControllerBean;
import com.kingdee.eas.fi.cas.utils.FMHelper;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.IContextHelper;
import com.kingdee.eas.fm.common.util.FetchParamHelper;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class BankStatementUIFacadeControllerBean
extends AbstractBankStatementUIFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.BankStatementUIFacadeControllerBean");
    private CompanyOrgUnitInfo company;

    @Override
    protected Map _fetchData(Context ctx, Map paramMap) throws BOSException, EASBizException {
        FetchParamHelper fph = new FetchParamHelper(ctx);
        this.company = fph.getCurrentComapny();
        this.company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.company.getId().toString()));
        CompanyOrgUnitCollection companyColl = new CompanyOrgUnitCollection();
        try {
            if (!FMHelper.checkCurrentCompany(ctx, this.company, "cas_bankbook_01view")) {
                companyColl = FMHelper.getUserOrgRangesWithRangeWhereStartPeriod(ctx, "cas_bankbook_01view");
                if (companyColl != null && companyColl.size() > 0) {
                    this.company = companyColl.get(0);
                }
            } else {
                companyColl.add(this.company);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        paramMap.put("UserOrgRanges", companyColl);
        fph.setCurrentCompany(this.company);
        paramMap.put("currentCompany", this.company);
        paramMap.put("currencyCollection", this.getCurrencyCollection(ctx));
        paramMap.put("startPeriod", fph.getStartPeriod());
        paramMap.put("currentPeriod", fph.getCurrentPeriod());
        paramMap.put("acctBankCol", this.getBankAccount(ctx));
        return paramMap;
    }

    private AccountBankCollection getBankAccount(Context ctx) throws BOSException, EASBizException {
        IContextHelper ctxHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK userPK = new ObjectUuidPK(ctxHelper.getCurrentUser().getId());
        ObjectUuidPK orgPK = new ObjectUuidPK(ctxHelper.getCurrentCompany().getId());
        IPermissionServiceProvider provider = PermissionServiceProviderFactory.getLocalInstance((Context)ctx);
        String rule = provider.getPermissionRule((IObjectPK)userPK, (IObjectPK)orgPK, "bd_assistant_accountBank_view");
        EntityViewInfo evi = new EntityViewInfo();
        try {
            if (rule != null) {
                evi = new EntityViewInfo(rule);
            }
        }
        catch (ParserException e) {
            logger.error((Object)e);
            evi = new EntityViewInfo();
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("*");
        selector.add("number");
        selector.add("name");
        selector.add("bankAccountNumber");
        selector.add("account.id");
        selector.add("account.number");
        selector.add("account.name");
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.company.getId().toString()));
        fi.getFilterItems().add(new FilterItemInfo("isBank", (Object)FMConstants.TRUE));
        if (evi.getFilter() != null) {
            evi.getFilter().mergeFilter(fi, "and");
        } else {
            evi.setFilter(fi);
        }
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.getSorter().add(new SorterItemInfo("number"));
        AccountBankCollection acctBankCol = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(evi);
        for (int i = 0; i < acctBankCol.size(); ++i) {
            acctBankCol.get(i).setDisplayFormat("$number$ - $name$");
        }
        return acctBankCol;
    }

    private Object getCurrencyCollection(Context ctx) throws BOSException, EASBizException {
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        return iCurrency.getCurrencyCollection(true);
    }

    @Override
    protected Map _fetchDateForVerify(Context ctx, Map paramMap) throws BOSException, EASBizException {
        FetchParamHelper fph = new FetchParamHelper(ctx);
        boolean byDate = (Boolean)paramMap.get("byDate");
        String actualAcctTableId = null;
        if (byDate) {
            Date beginDate = (Date)paramMap.get("beginDate");
            Date endDate = (Date)paramMap.get("endDate");
            actualAcctTableId = fph.getAcctTableId(ctx, beginDate, endDate);
        } else {
            int beginYear = (Integer)paramMap.get("beginYear");
            int beginMonth = (Integer)paramMap.get("beginMonth");
            int endYear = (Integer)paramMap.get("endYear");
            int endMonth = (Integer)paramMap.get("endMonth");
            actualAcctTableId = fph.getAcctTableId(ctx, beginYear, beginMonth, endYear, endMonth);
        }
        paramMap.put("actualAcctTableId", actualAcctTableId);
        return paramMap;
    }
}

