/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.workflow.exception.biz.WfBizException;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SharedAcctCollection;
import com.kingdee.eas.basedata.assistant.SharedAcctFactory;
import com.kingdee.eas.basedata.assistant.SharedAcctInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.BSSourceEnum;
import com.kingdee.eas.fi.cas.BankStatementCollection;
import com.kingdee.eas.fi.cas.BankStatementFactory;
import com.kingdee.eas.fi.cas.BankStatementInfo;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.IBankStatement;
import com.kingdee.eas.fi.cas.app.AbstractBankStatementWebFacadeControllerBean;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.BankJournalWebUtil;
import com.kingdee.eas.fi.cas.utils.BankStatementWebUtil;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.utils.JournalWebUtil;
import com.kingdee.eas.fi.cas.web.param.BankStatementWebFilterParam;
import com.kingdee.eas.fi.cas.web.param.BsfBatchProcessResult;
import com.kingdee.eas.fi.cas.web.param.FetchAccTableParam;
import com.kingdee.eas.fi.cas.web.param.QueryTable;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.EASCommonResource;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BankStatementWebFacadeControllerBean
extends AbstractBankStatementWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.BankStatementWebFacadeControllerBean");

    @Override
    protected Object _saveFromJsonStr(Context ctx, String jsonStr) throws BOSException, EASBizException {
        BankStatementInfo info = null;
        info = (BankStatementInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonStr, BankStatementInfo.class);
        if (info.getId() == null) {
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        }
        BankStatementFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
        return info;
    }

    @Override
    protected Object _saveFromJsonListStr(Context ctx, String jsonListStr) throws BOSException, EASBizException {
        HashMap<String, String> mapData = new HashMap<String, String>();
        try {
            HashMap modelMap = JSONUtils.convertJsonToObject((Context)ctx, (String)jsonListStr);
            BankStatementCollection bankStatementCollection = new BankStatementCollection();
            List journalListData = (List)modelMap.get("editGridData");
            for (int i = 0; i < journalListData.size(); ++i) {
                BankStatementInfo info = new BankStatementInfo();
                Map row = (Map)journalListData.get(i);
                String jsonStr = JSONUtils.convertObjectToJson((Context)ctx, (Object)row);
                info.setIsDebit((info = (BankStatementInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonStr, BankStatementInfo.class)).getDebitAmount() != null);
                bankStatementCollection.add(info);
            }
            if (bankStatementCollection.size() > 0) {
                BankStatementFactory.getLocalInstance(ctx).batchSumbit(bankStatementCollection);
            }
        }
        catch (EASBizException e1) {
            mapData.put("MsgStr", e1.getMessage());
            mapData.put("MsgDetail", e1.toString());
            e1.printStackTrace();
        }
        catch (BOSException e2) {
            mapData.put("MsgStr", e2.getMessage());
            mapData.put("MsgDetail", e2.toString());
            e2.printStackTrace();
        }
        return mapData;
    }

    @Override
    protected String _deleteFromIdStr(Context ctx, String idStr) throws BOSException, EASBizException {
        if (idStr != null) {
            ObjectUuidPK objPk = new ObjectUuidPK(idStr);
            BankStatementInfo info = null;
            try {
                info = BankStatementFactory.getLocalInstance(ctx).getBankStatementInfo((IObjectPK)objPk);
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
            if (info != null) {
                BankStatementFactory.getLocalInstance(ctx).delete((IObjectPK)objPk);
            }
        }
        return idStr;
    }

    @Override
    protected Object _updateFromJsonStr(Context ctx, String jsonStr) throws BOSException, EASBizException {
        BankStatementInfo info = null;
        BankStatementInfo existObj = null;
        info = (BankStatementInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonStr, BankStatementInfo.class);
        if (info != null && info.getId() != null) {
            try {
                existObj = BankStatementFactory.getLocalInstance(ctx).getBankStatementInfo((IObjectPK)new ObjectUuidPK(info.getId()));
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
            if (existObj != null) {
                BankStatementFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
            }
        }
        return info;
    }

    @Override
    protected BankStatementInfo _getBankStatementInfoById(Context ctx, String idStr) throws BOSException, EASBizException {
        BankStatementInfo info = null;
        if (idStr != null) {
            try {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("company.id"));
                sic.add(new SelectorItemInfo("company.name"));
                sic.add(new SelectorItemInfo("company.number"));
                sic.add(new SelectorItemInfo("company.baseCurrency.id"));
                sic.add(new SelectorItemInfo("company.baseCurrency.name"));
                sic.add(new SelectorItemInfo("company.baseCurrency.number"));
                sic.add(new SelectorItemInfo("accountBank.*"));
                sic.add(new SelectorItemInfo("accountBank.account.*"));
                sic.add(new SelectorItemInfo("currency.*"));
                sic.add(new SelectorItemInfo("settleType.id"));
                sic.add(new SelectorItemInfo("settleType.name"));
                sic.add(new SelectorItemInfo("settleType.number"));
                sic.add(new SelectorItemInfo("accountView.id"));
                sic.add(new SelectorItemInfo("accountView.name"));
                sic.add(new SelectorItemInfo("accountView.number"));
                sic.add(new SelectorItemInfo("period.*"));
                info = BankStatementFactory.getLocalInstance(ctx).getBankStatementInfo((IObjectPK)new ObjectUuidPK(idStr), sic);
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
        }
        return info;
    }

    @Override
    protected QueryTable _getBankStatementList(Context ctx, BankStatementWebFilterParam filterParam) throws BOSException, EASBizException {
        QueryTable queryTable = new QueryTable();
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String fromDateStr = filterParam.getFromDateStr();
            if (filterParam.getPeriodStartId() != null && !filterParam.isByDay()) {
                PeriodInfo periodStart = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(filterParam.getPeriodStartId()));
                fromDateStr = simpleDateFormat.format(periodStart.getBeginDate());
            }
            if (fromDateStr != null) {
                filterParam.setFromDate(simpleDateFormat.parse(fromDateStr));
                filterParam.setBeginYear(Integer.parseInt(fromDateStr.trim().substring(0, 4)));
                filterParam.setBeginMonth(Integer.parseInt(fromDateStr.trim().substring(5, 7)));
            }
            String toDateStr = filterParam.getToDateStr();
            if (filterParam.getPeriodEndId() != null && !filterParam.isByDay()) {
                PeriodInfo periodEnd = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(filterParam.getPeriodEndId()));
                toDateStr = simpleDateFormat.format(periodEnd.getEndDate());
            }
            if (toDateStr != null) {
                filterParam.setToDate(simpleDateFormat.parse(toDateStr));
                filterParam.setEndYear(Integer.parseInt(toDateStr.trim().substring(0, 4)));
                filterParam.setEndMonth(Integer.parseInt(toDateStr.trim().substring(5, 7)));
            }
            BankStatementWebUtil.getBankStatementlList(ctx, filterParam, queryTable);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
            throw new BOSException((Throwable)e);
        }
        return queryTable;
    }

    @Override
    protected void _deleteBankStatementById(Context ctx, String idStr) throws BOSException, EASBizException {
        if (idStr != null) {
            BankStatementInfo existObj = null;
            try {
                existObj = BankStatementFactory.getLocalInstance(ctx).getBankStatementInfo((IObjectPK)new ObjectUuidPK(idStr));
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
            if (existObj != null) {
                BankStatementFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(idStr));
            }
        }
    }

    @Override
    protected BankStatementInfo _createBankStatementInfo(Context ctx, String companyId, String accountBankId, String currencyId) throws BOSException, EASBizException {
        BankStatementInfo info = null;
        if (companyId != null && accountBankId != null && currencyId != null) {
            info = new BankStatementInfo();
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            info.setCompany(companyInfo);
            AccountBankInfo accountBankInfo = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountBankId));
            info.setAccountBank(accountBankInfo);
            AccountViewInfo acctInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountBankInfo.getAccount().getId()));
            info.setAccountView(acctInfo);
            info.setVerifyStatus(VerifyScopeEnum.NOVA);
            info.setSource(BSSourceEnum.MANUAL);
            info.setDebitAmount(SysConstant.BIGZERO);
            info.setCreditAmount(SysConstant.BIGZERO);
            CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
            info.setCurrency(currencyInfo);
        }
        return info;
    }

    @Override
    protected Map _getBankStateUIDefaultValue(Context ctx) throws BOSException, EASBizException {
        HashMap<String, Object> defaultValueMap = new HashMap<String, Object>();
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        CompanyOrgUnitInfo validCompanyInfo = null;
        PeriodInfo startPeriod = null;
        CompanyOrgUnitCollection fiOrgColls = CASWebHelper.getAuthorizedOrgCollection(ctx, "cas_bankstatement_01view", false);
        HashSet<String> idSet = new HashSet<String>();
        for (int idx = 0; idx < fiOrgColls.size(); ++idx) {
            CompanyOrgUnitInfo fiOrgUnit = fiOrgColls.get(idx);
            if (fiOrgUnit == null || fiOrgUnit.getId() == null) continue;
            idSet.add(fiOrgUnit.getId().toString());
        }
        ArrayList companyIdList = new ArrayList(idSet);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("baseCurrency.*"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("accountTable.name"));
        sic.add(new SelectorItemInfo("accountTable.number"));
        if (companyIdList != null && companyIdList.size() != 0 && companyIdList.contains(companyInfo.getId().toString())) {
            companyIdList.remove(companyInfo.getId().toString());
            companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId().toString()), sic);
            if (companyInfo.isIsBizUnit() && !companyInfo.isIsOUSealUp() && !companyInfo.isIsAssistantOrg()) {
                validCompanyInfo = companyInfo;
            }
            if (validCompanyInfo != null) {
                startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, validCompanyInfo);
            }
        }
        if (startPeriod == null && fiOrgColls != null && fiOrgColls.size() > 0) {
            for (int i = 0; i < fiOrgColls.size(); ++i) {
                companyInfo = fiOrgColls.get(i);
                startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)fiOrgColls.get(i));
                if (companyInfo.isIsBizUnit() && !companyInfo.isIsOUSealUp() && !companyInfo.isIsAssistantOrg()) {
                    validCompanyInfo = companyInfo;
                }
                if (validCompanyInfo != null) {
                    startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, validCompanyInfo);
                }
                if (startPeriod != null) break;
            }
        }
        PeriodInfo curPeriod = JournalWebUtil.getCurrentPeriod(ctx, companyInfo.getId().toString());
        PeriodCollection periodCol = BankJournalWebUtil.getPeriodc(ctx, companyInfo);
        FilterInfo getBankF7Include_Sql = null;
        AccountBankInfo accountBankInfo = null;
        List accountBankCol = null;
        if (companyInfo != null && (accountBankCol = this.getBankF7IncludeShared(ctx, companyInfo.getId().toString(), false)) != null && accountBankCol.size() > 0) {
            getBankF7Include_Sql = this.getBankF7Include_Sql(ctx, companyInfo.getId().toString(), false);
            accountBankInfo = (AccountBankInfo)accountBankCol.get(0);
        }
        AccountViewInfo accountViewInfo = null;
        CurrencyInfo currencyInfo = null;
        AccountBankCollection acctBankColl = null;
        if (accountBankInfo != null && curPeriod != null) {
            currencyInfo = accountBankInfo.isIsByCurrency() ? accountBankInfo.getCurrency() : companyInfo.getBaseCurrency();
            String acctTableId = JournalWebUtil.getAccTableIdByPeriod(companyInfo.getId().toString(), null, curPeriod.getPeriodYear(), curPeriod.getPeriodNumber(), curPeriod.getPeriodYear(), curPeriod.getPeriodNumber());
            acctBankColl = new AccountBankCollection();
            acctBankColl.add(accountBankInfo);
            acctBankColl = FMHelper.getJouranlBalanceAcctBank((Context)ctx, (AccountBankCollection)acctBankColl, null, (String)acctTableId);
            accountBankInfo = acctBankColl.get(0);
            accountViewInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountBankInfo.getAccount().getId().toString()));
        }
        if (acctBankColl != null && acctBankColl.size() > 0) {
            defaultValueMap.put("DEFAULT_ACCOUNTBANKLIST", getBankF7Include_Sql);
        }
        if (curPeriod != null && periodCol != null) {
            defaultValueMap.put("DEFAULT_PERIOD", curPeriod);
            defaultValueMap.put("DEFAULT_PERIODS", periodCol);
        }
        if (companyInfo != null && startPeriod != null) {
            defaultValueMap.put("DEFAULT_COMPANY", companyInfo);
            defaultValueMap.put("DEFAULT_START_PERIOD", startPeriod);
            defaultValueMap.put("DEFAULT_ACCOUNTBANK", accountBankInfo);
            defaultValueMap.put("DEFAULT_CURRENCY", currencyInfo);
            defaultValueMap.put("DEFAULT_ACCOUNTVIEW", accountViewInfo);
        }
        defaultValueMap.put("VALID_COMPANYIDS", CASWebHelper.getAuthorizedOrgFilter_F7Special(ctx, "cas_bankstatement_01view", false, "unit.id", null));
        return defaultValueMap;
    }

    @Override
    protected List _getBankF7IncludeShared(Context ctx, String companyId, boolean isClosed) throws BOSException, EASBizException {
        LinkedList<AccountBankInfo> accountBankF7List = null;
        if (companyId != null) {
            EntityViewInfo evi = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("*");
            selector.add(new SelectorItemInfo("currency.*"));
            selector.add(new SelectorItemInfo("company.*"));
            selector.add(new SelectorItemInfo("account.*"));
            selector.add(new SelectorItemInfo("property.id"));
            selector.add(new SelectorItemInfo("property.name"));
            selector.add(new SelectorItemInfo("property.number"));
            selector.add(new SelectorItemInfo("bank.id"));
            selector.add(new SelectorItemInfo("bank.name"));
            selector.add(new SelectorItemInfo("bank.number"));
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
            if (!isClosed) {
                fi.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
            }
            fi.getFilterItems().add(new FilterItemInfo("isBank", (Object)FMConstants.TRUE));
            fi.getFilterItems().add(new FilterItemInfo("shareType", (Object)0, CompareType.EQUALS));
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("shareBalanceOfAcctCompany.id", (Object)companyId, CompareType.EQUALS));
            view.setFilter(filter);
            SharedAcctCollection coll = SharedAcctFactory.getLocalInstance((Context)ctx).getSharedAcctCollection(view);
            HashSet<String> sharedAcctSet = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                SharedAcctInfo sharedAcct = coll.get(i);
                sharedAcctSet.add(sharedAcct.getBankAccount().getId().toString());
            }
            if (!EmptyUtil.isEmpty(sharedAcctSet)) {
                fi.getFilterItems().add(new FilterItemInfo("id", sharedAcctSet, CompareType.INCLUDE));
                if (isClosed) {
                    fi.setMaskString("((#0 and #1 and #2) or #3)");
                } else {
                    fi.setMaskString("((#0 and #1 and #2 and #3) or #4)");
                }
            }
            evi.setFilter(fi);
            evi.getSelector().addObjectCollection((IObjectCollection)selector);
            evi.getSorter().add(new SorterItemInfo("number"));
            AccountBankCollection acctBankCol = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(evi);
            if (acctBankCol != null) {
                Object[] object;
                accountBankF7List = new LinkedList<AccountBankInfo>();
                for (Object o : object = acctBankCol.toArray()) {
                    AccountBankInfo info = (AccountBankInfo)o;
                    accountBankF7List.add(info);
                }
            }
        }
        return accountBankF7List;
    }

    @Override
    protected FilterInfo _getBankF7Include_Sql(Context ctx, String companyId, boolean isClosed) throws BOSException, EASBizException {
        Object accountBankF7List = null;
        FilterInfo fi = new FilterInfo();
        if (companyId != null) {
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
            if (!isClosed) {
                fi.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
            }
            fi.getFilterItems().add(new FilterItemInfo("isBank", (Object)FMConstants.TRUE));
            fi.getFilterItems().add(new FilterItemInfo("shareType", (Object)0, CompareType.EQUALS));
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("shareBalanceOfAcctCompany.id", (Object)companyId, CompareType.EQUALS));
            view.setFilter(filter);
            SharedAcctCollection coll = SharedAcctFactory.getLocalInstance((Context)ctx).getSharedAcctCollection(view);
            HashSet<String> sharedAcctSet = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                SharedAcctInfo sharedAcct = coll.get(i);
                sharedAcctSet.add(sharedAcct.getBankAccount().getId().toString());
            }
            if (!EmptyUtil.isEmpty(sharedAcctSet)) {
                fi.getFilterItems().add(new FilterItemInfo("id", sharedAcctSet, CompareType.INCLUDE));
                if (isClosed) {
                    fi.setMaskString("((#0 and #1 and #2) or #3)");
                } else {
                    fi.setMaskString("((#0 and #1 and #2 and #3) or #4)");
                }
            }
        }
        return fi;
    }

    @Override
    protected List _getConvertedAcctBankList(Context ctx, String companyId, boolean isClosed, FetchAccTableParam fetchAccTableParam) throws BOSException, EASBizException {
        LinkedList<AccountBankInfo> targetAccBankList = null;
        if (companyId != null && fetchAccTableParam != null) {
            List orgAccBankList = this.getBankF7IncludeShared(ctx, companyId, isClosed);
            String acctTableId = JournalWebUtil.getDisplayAcctTable(ctx, fetchAccTableParam);
            AccountBankCollection acctBankCol = new AccountBankCollection();
            for (AccountBankInfo aAccBankInfo : orgAccBankList) {
                acctBankCol.add(aAccBankInfo);
            }
            if ((acctBankCol = FMHelper.getJouranlBalanceAcctBank((Context)ctx, (AccountBankCollection)acctBankCol, null, (String)acctTableId)) != null) {
                Object[] object;
                targetAccBankList = new LinkedList<AccountBankInfo>();
                for (Object o : object = acctBankCol.toArray()) {
                    AccountBankInfo info = (AccountBankInfo)o;
                    targetAccBankList.add(info);
                }
            }
        }
        return targetAccBankList;
    }

    @Override
    protected boolean _chkAddPreviousBill(Context ctx, String companyId) throws BOSException, EASBizException {
        return ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS046", (IObjectPK)new ObjectUuidPK(companyId));
    }

    @Override
    protected boolean _chkAllowRemove(Context ctx, String companyId) throws BOSException, EASBizException {
        return ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS080", (IObjectPK)new ObjectUuidPK(companyId));
    }

    @Override
    protected BigDecimal _getRecentAmt(Context ctx, String companyId, String accountBankId, String currencyId, Date startDate) throws BOSException, EASBizException {
        return BankStatementFactory.getLocalInstance(ctx).getRecentAmt(accountBankId, currencyId, companyId, startDate);
    }

    @Override
    protected List _batchDeleteBankState(Context ctx, String[] bankStateIdList, String companyId) throws BOSException, EASBizException {
        ArrayList<BsfBatchProcessResult> resultList = null;
        if (bankStateIdList != null && bankStateIdList.length > 0) {
            resultList = new ArrayList<BsfBatchProcessResult>(bankStateIdList.length);
            for (String bankStateId : bankStateIdList) {
                BsfBatchProcessResult result = new BsfBatchProcessResult(bankStateId);
                resultList.add(result);
                try {
                    BankStatementInfo info = this.getBankStatementInfoById(ctx, bankStateId);
                    CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
                    PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
                    result.setBankStatementInfo(info);
                    if (!info.getVerifyStatus().equals((Object)VerifyScopeEnum.NOVA)) {
                        result.setProcessResult(false);
                        result.getErrorInfo().setMsgSummary(EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"279_CashMgtInitJournalUI", (Locale)ctx.getLocale()));
                        continue;
                    }
                    Date createDate = info.getCreateDate();
                    boolean isAllowRemove = this.chkAllowRemove(ctx, company.getId().toString());
                    if (!isAllowRemove && DateHelper.dateDiff((Date)currPeriodInfo.getBeginDate(), (Date)createDate) < 0L) {
                        result.setProcessResult(false);
                        result.getErrorInfo().setMsgSummary(EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"267_BankStatementListUI", (Locale)ctx.getLocale()));
                        continue;
                    }
                    BankStatementFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(info.getId()));
                    result.setProcessResult(true);
                }
                catch (Exception e) {
                    result.setProcessResult(false);
                    result.setException(e);
                    result.getErrorInfo().setMsgSummary(e.getMessage());
                }
            }
        }
        return resultList;
    }

    @Override
    protected Map _getInitTableMap(Context ctx) throws BOSException, EASBizException {
        String resourcePath = "com.kingdee.eas.fi.cas.BankStatementResource";
        HashMap<String, String> tableMap = new HashMap<String, String>();
        tableMap.put(EASResource.getString((String)resourcePath, (String)"createDate", (Locale)ctx.getLocale()), "createDate");
        tableMap.put(EASResource.getString((String)resourcePath, (String)"summary", (Locale)ctx.getLocale()).replaceAll("\\*", ""), "description");
        tableMap.put(EASResource.getString((String)resourcePath, (String)"settlementType", (Locale)ctx.getLocale()).replaceAll("\\*", ""), "settleType");
        tableMap.put(EASResource.getString((String)resourcePath, (String)"settlementNumber", (Locale)ctx.getLocale()), "settleNumber");
        tableMap.put(EASResource.getString((String)resourcePath, (String)"amount", (Locale)ctx.getLocale()), "amount");
        tableMap.put(EASResource.getString((String)resourcePath, (String)"sequenceNumber", (Locale)ctx.getLocale()), "sequenceNumber");
        tableMap.put(EASResource.getString((String)resourcePath, (String)"cashier", (Locale)ctx.getLocale()), "cashier");
        tableMap.put(EASResource.getString((String)resourcePath, (String)"oppUnit", (Locale)ctx.getLocale()), "oppUnit");
        tableMap.put(EASResource.getString((String)resourcePath, (String)"oppAccountNumber", (Locale)ctx.getLocale()), "oppAccountNumber");
        tableMap.put(EASResource.getString((String)resourcePath, (String)"voucherNumber1", (Locale)ctx.getLocale()), "voucherNumber");
        tableMap.put(EASResource.getString((String)resourcePath, (String)"debitAmount", (Locale)ctx.getLocale()), "debitAmount");
        tableMap.put(EASResource.getString((String)resourcePath, (String)"creditAmount", (Locale)ctx.getLocale()), "creditAmount");
        tableMap.put(EASResource.getString((String)resourcePath, (String)"dc", (Locale)ctx.getLocale()), "dc");
        tableMap.put(EASResource.getString((String)resourcePath, (String)"tradeNumber", (Locale)ctx.getLocale()), "tradeNumber");
        tableMap.put(EASResource.getString((String)resourcePath, (String)"dataDCSplitFormat", (Locale)ctx.getLocale()), "dataDCSplitFormat");
        tableMap.put(EASResource.getString((String)resourcePath, (String)"dataDCSignFormat", (Locale)ctx.getLocale()), "dataDCSignFormat");
        tableMap.put(EASResource.getString((String)resourcePath, (String)"dataDCNoneFormat", (Locale)ctx.getLocale()), "dataDCNoneFormat");
        return tableMap;
    }

    @Override
    protected Map _batchSumbitBankStmts(Context ctx, BankStatementCollection bankStmts) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        BankStatementFactory.getLocalInstance(ctx).batchSumbit(bankStmts);
        return result;
    }

    @Override
    protected Map _batchDownLoadFSData(Context ctx, String[] bankAcctIds, Date beginDate, Date endDate, boolean isSettled) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = "";
        int success = bankAcctIds.length;
        for (int i = 0; i < bankAcctIds.length; ++i) {
            SelectorItemCollection select = new SelectorItemCollection();
            select.add("*");
            select.add("bank.*");
            AccountBankInfo info = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(bankAcctIds[i]), select);
            ArrayList<String> idList = new ArrayList<String>();
            idList.add(bankAcctIds[i]);
            CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
            try {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("baseCurrency.*"));
                sic.add(new SelectorItemInfo("accountTable.id"));
                sic.add(new SelectorItemInfo("accountTable.name"));
                sic.add(new SelectorItemInfo("accountTable.number"));
                companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), sic);
                PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
                if (startPeriod.getBeginDate().after(beginDate)) {
                    throw new CasWebException(CasWebException.CHECKBEGINDATE_071);
                }
                InnerAccountInfo innerAcctInfo = info.getInnerAcct();
                if (innerAcctInfo == null) {
                    throw new CasWebException(CasWebException.CHECKRELATEDINNERACCT_072);
                }
                IBankStatement iBankStat = BankStatementFactory.getLocalInstance(ctx);
                iBankStat.downLoadFSData(info.getCompany().getId().toString(), info.getId().toString(), innerAcctInfo.getId().toString(), beginDate, endDate, isSettled);
                continue;
            }
            catch (WfBizException sic) {
                continue;
            }
            catch (Exception e) {
                --success;
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "544_BANKSTATEMENT_DOWNLOADFSDATA_FAILED", new String[]{companyInfo.getName(), info.getBankAccountNumber() + info.getName(), e.getMessage()}));
            }
        }
        summary = success == bankAcctIds.length ? summary + CASWebUtil.getResource(ctx, "545_ALL_DOWNLOADFSDATA_SUCCESS") : summary + CASWebUtil.getResource(ctx, "546_DOWNLOADFSDATA_RESULT", new String[]{String.valueOf(success), String.valueOf(bankAcctIds.length - success)});
        result.setSummaryMsg(summary);
        result.put("success", success);
        return result;
    }
}

