/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.IJournal;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fi.cas.app.AbstractBankUnreachedWebFacadeControllerBean;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.utils.CashMgtInitFetchParam;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BankUnreachedWebFacadeControllerBean
extends AbstractBankUnreachedWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.BankUnreachedWebFacadeControllerBean");

    @Override
    protected Map _initPageData(Context ctx, String companyId, String accountBankId, String currencyId, String accountViewId) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        Date beginDate = null;
        PeriodInfo startPeriodInfo = null;
        try {
            Map param = CashMgtInitFetchParam.fetchParam(ctx, company);
            startPeriodInfo = (PeriodInfo)param.get("startPeriod");
            beginDate = startPeriodInfo.getBeginDate();
        }
        catch (EASBizException e1) {
            throw new RuntimeException(e1);
        }
        catch (BOSException e1) {
            throw new RuntimeException(e1);
        }
        EntityViewInfo viewInfo = this.getJournalQueryFilter(accountBankId, currencyId, accountViewId, companyId, beginDate);
        HashMap<String, Object> initData = new HashMap<String, Object>();
        JournalCollection journals = null;
        try {
            journals = JournalFactory.getLocalInstance(ctx).getJournalCollection(viewInfo);
            initData.put("journalsData", journals);
            AccountBankInfo acctBank = this.getAccountBankInfo(ctx, accountBankId);
            acctBank.setName(acctBank.getName() + " " + acctBank.getBankAccountNumber());
            initData.put("shareType", acctBank.getShareType().getValue());
            initData.put("bankAccount", acctBank);
            initData.put("accountView", acctBank.getAccount());
            String[] args = new String[]{String.valueOf(startPeriodInfo.getPeriodYear()), String.valueOf(startPeriodInfo.getPeriodNumber())};
            MessageFormat mf = new MessageFormat(EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period", (Locale)ctx.getLocale()));
            String startPeriod = mf.format(args);
            initData.put("startPeriod", startPeriod);
            CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
            initData.put("currency", currencyInfo);
            initData.put("firstDayOfPeriod", beginDate);
            initData.put("beforefirstDayOfPeriod", new Date(beginDate.getTime() - 86400000L));
            CompanyOrgUnitInfo companyInfo = this.getCompanyById(ctx, companyId);
            FilterInfo filter = VoucherTypeFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(companyInfo.getCU().getId()), "id", "adminCU.id");
            initData.put("companyCUId", filter.toString());
            initData.put("companyId", companyId);
            StringBuffer summaryInfo = new StringBuffer();
            summaryInfo.append(CASWebUtil.getResource(ctx, "150_LBL_COMPANY")).append(companyInfo.getName()).append("&nbsp;&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;");
            summaryInfo.append(CASWebUtil.getResource(ctx, "151_LBL_PERIOD")).append(startPeriod).append("&nbsp;&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;");
            summaryInfo.append(CASWebUtil.getResource(ctx, "152_LBL_ACCOUNTBANK")).append(acctBank.getName()).append("&nbsp;&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;");
            summaryInfo.append(CASWebUtil.getResource(ctx, "153_LBL_ACCOUNTVIEW")).append(acctBank.getAccount().toString()).append("&nbsp;&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;");
            summaryInfo.append(CASWebUtil.getResource(ctx, "154_LBL_CURRENCY")).append(currencyInfo.getName());
            initData.put("summaryInfo", summaryInfo.toString());
        }
        catch (BOSException e) {
            throw new RuntimeException(e);
        }
        catch (EASBizException e) {
            throw new RuntimeException(e);
        }
        catch (UuidException e) {
            throw new RuntimeException(e);
        }
        return initData;
    }

    private EntityViewInfo getJournalQueryFilter(String bankAccount, String currencyId, String accountViewId, String companyId, Date beginDate) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        FilterItemInfo createDateCond = new FilterItemInfo("createDate", (Object)beginDate, CompareType.LESS);
        FilterItemInfo accountViewCond = new FilterItemInfo("accountView.id", (Object)accountViewId);
        FilterItemInfo currencyCond = new FilterItemInfo("currency.id", (Object)currencyId);
        FilterItemInfo accountBankCond = new FilterItemInfo("accountBank.id", (Object)bankAccount);
        FilterItemInfo companyCond = new FilterItemInfo("company.id", (Object)companyId);
        fic.add(createDateCond);
        fic.add(accountViewCond);
        fic.add(currencyCond);
        fic.add(accountBankCond);
        fic.add(companyCond);
        viewInfo.setFilter(fi);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("createDate");
        selectors.add("description");
        selectors.add("settleType.id");
        selectors.add("settleType.name");
        selectors.add("settleNumber");
        selectors.add("debitAmount");
        selectors.add("creditAmount");
        selectors.add("verifyStatus");
        selectors.add("period");
        selectors.addObjectCollection((IObjectCollection)selectors);
        selectors.add("assisDate");
        selectors.add("settlementType.*");
        selectors.add("settlementNumber");
        selectors.add("voucherType.id");
        selectors.add("voucherType.name");
        selectors.add("voucherNumber");
        selectors.add("billType");
        selectors.add("billNumber");
        selectors.add("verifyStatus");
        viewInfo.setSelector(selectors);
        return viewInfo;
    }

    @Override
    protected Map _save(Context ctx, String changeData, String companyId, String accountBankId, String currencyId, String accountViewId) throws BOSException, EASBizException {
        HashMap modelMap = null;
        try {
            modelMap = JSONUtils.convertJsonToObject((Context)ctx, (String)changeData);
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        List modifiedRecord = (List)modelMap.get("modifiedRecord");
        List deleteRecord = (List)modelMap.get("deleteRecord");
        JournalCollection updateCollection = new JournalCollection();
        JournalCollection addCollection = new JournalCollection();
        for (int i = 0; i < modifiedRecord.size(); ++i) {
            Map rowData = (Map)modifiedRecord.get(i);
            JournalInfo journalInfo = this.convertJournalInfo(rowData);
            if (journalInfo.getId() == null) {
                journalInfo = this.initJournalDefaultInfo(journalInfo, accountBankId, currencyId, accountViewId, companyId);
                addCollection.add(journalInfo);
                continue;
            }
            updateCollection.add(journalInfo);
        }
        ArrayList<ObjectUuidPK> arrayPK = new ArrayList<ObjectUuidPK>();
        for (int i = 0; i < deleteRecord.size(); ++i) {
            Map rowData = (Map)deleteRecord.get(i);
            String id = (String)rowData.get("id");
            if (id == null || id.equals("")) continue;
            arrayPK.add(new ObjectUuidPK(id));
        }
        IObjectPK[] deletedArrayPK = new IObjectPK[arrayPK.size()];
        for (int i = 0; i < deletedArrayPK.length; ++i) {
            deletedArrayPK[i] = (IObjectPK)arrayPK.get(i);
        }
        try {
            IJournal journalMgr = JournalFactory.getLocalInstance(ctx);
            if (arrayPK.size() > 0) {
                journalMgr.deleteBatchData(deletedArrayPK);
            }
            if (addCollection.size() > 0) {
                journalMgr.addBatch((IObjectCollection)addCollection);
            }
            if (updateCollection.size() > 0) {
                for (int i = 0; i < updateCollection.size(); ++i) {
                    journalMgr.updatePartial((CoreBaseInfo)updateCollection.get(i), this.getSelectors());
                }
            }
        }
        catch (BOSException e) {
            throw new RuntimeException(e);
        }
        catch (EASBizException e) {
            throw new RuntimeException(e);
        }
        return new HashMap();
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("createDate");
        selectors.add("description");
        selectors.add("debitAmount");
        selectors.add("creditAmount");
        selectors.add("assisDate");
        selectors.add("shareType");
        selectors.add("settlementType");
        selectors.add("settlementNumber");
        selectors.add("voucherType");
        selectors.add("voucherNumber");
        selectors.add("billType");
        selectors.add("billNumber");
        return selectors;
    }

    private JournalInfo convertJournalInfo(Map rowData) {
        JournalInfo journal = new JournalInfo();
        if (((String)rowData.get("id")).length() > 10) {
            journal.setId(BOSUuid.read((String)rowData.get("id").toString()));
        } else {
            journal.setId(null);
        }
        if (rowData.get("createDate") != null && "" != rowData.get("createDate")) {
            journal.setCreateDate(this.dateFormat(rowData.get("createDate").toString()));
        }
        if (rowData.get("assisDate") != null && "" != rowData.get("assisDate")) {
            journal.setAssisDate(this.dateFormat(rowData.get("assisDate").toString()));
        }
        if (rowData.get("settlementType") != null && "" != rowData.get("settlementType")) {
            SettlementTypeInfo settleType = new SettlementTypeInfo();
            settleType.setId(BOSUuid.read((String)((String)((Map)rowData.get("settlementType")).get("id"))));
            journal.setSettlementType(settleType);
        }
        if (rowData.get("settlementNumber") != null && "" != rowData.get("settlementNumber")) {
            journal.setSettlementNumber((String)rowData.get("settlementNumber"));
        }
        if (rowData.get("voucherType") != null && "" != rowData.get("voucherType")) {
            VoucherTypeInfo voucherType = new VoucherTypeInfo();
            voucherType.setId(BOSUuid.read((String)((String)((Map)rowData.get("voucherType")).get("id"))));
            journal.setVoucherType(voucherType);
        }
        if (rowData.get("voucherNumber") != null && "" != rowData.get("voucherNumber")) {
            journal.setVoucherNumber((String)rowData.get("voucherNumber"));
        }
        if (rowData.get("billType") != null && "" != rowData.get("billType")) {
            BillTypeEnum billTypeEnum = BillTypeEnum.getEnum(Integer.valueOf((String)((Map)rowData.get("billType")).get("value")));
            journal.setBillType(billTypeEnum);
        }
        if (rowData.get("billNumber") != null && "" != rowData.get("billNumber")) {
            journal.setBillNumber((String)rowData.get("billNumber"));
        }
        if (rowData.get("debitAmount") != null && "" != rowData.get("debitAmount")) {
            journal.setDebitAmount(BigDecimal.valueOf(Double.valueOf(rowData.get("debitAmount").toString())));
        } else {
            journal.setDebitAmount(BigDecimal.ZERO);
        }
        if (rowData.get("creditAmount") != null && "" != rowData.get("creditAmount")) {
            journal.setCreditAmount(BigDecimal.valueOf(Double.valueOf(rowData.get("creditAmount").toString())));
        } else {
            journal.setCreditAmount(BigDecimal.ZERO);
        }
        if (rowData.get("description") != null && "" != rowData.get("description")) {
            journal.setDescription((String)rowData.get("description"));
        }
        return journal;
    }

    private JournalInfo initJournalDefaultInfo(JournalInfo journal, String bankAccountId, String currencyId, String accountViewId, String companyId) {
        if (null == journal.getBillType()) {
            journal.setBillType(BillTypeEnum.other);
        }
        if (journal.getDebitAmount().signum() > 0) {
            journal.setIsDebit(true);
        } else {
            journal.setIsDebit(false);
        }
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        journal.setCompany(company);
        CurrencyInfo currency = new CurrencyInfo();
        currency.setId(BOSUuid.read((String)currencyId));
        journal.setCurrency(currency);
        AccountBankInfo abInfo = new AccountBankInfo();
        abInfo.setId(BOSUuid.read((String)bankAccountId));
        journal.setAccountBank(abInfo);
        AccountViewInfo viewInfo = new AccountViewInfo();
        viewInfo.setId(BOSUuid.read((String)accountViewId));
        journal.setAccountView(viewInfo);
        journal.setType(JournalTypeEnum.BANK);
        journal.setVerifyStatus(VerifyScopeEnum.NOVA);
        journal.setSource(JournalSourceEnum.BYHAND);
        journal.setHasEffected(true);
        journal.setBizDate(journal.getAssisDate());
        return journal;
    }

    public CompanyOrgUnitInfo getCompanyById(Context ctx, String companyId) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = null;
        if (companyId != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("baseCurrency.*"));
            sic.add(new SelectorItemInfo("accountTable.id"));
            sic.add(new SelectorItemInfo("accountTable.name"));
            sic.add(new SelectorItemInfo("accountTable.number"));
            companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), sic);
        }
        return companyInfo;
    }

    private AccountBankInfo getAccountBankInfo(Context ctx, String bankAccountId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("account.name"));
        sic.add(new SelectorItemInfo("account.number"));
        sic.add(new SelectorItemInfo("account.acctName"));
        sic.add(new SelectorItemInfo("account.bankAccountNumber"));
        AccountBankInfo acctBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)bankAccountId)), sic);
        return acctBank;
    }

    private Date dateFormat(String dateString) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return dateFormat.parse(dateString);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }
}

