/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BankStatementCollection;
import com.kingdee.eas.fi.cas.BankStatementFactory;
import com.kingdee.eas.fi.cas.IBankStatement;
import com.kingdee.eas.fi.cas.IJournal;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.app.AbstractBankVcCheckFacadeControllerBean;
import com.kingdee.eas.fi.cas.app.BankVcMultiCompanyCheck;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class BankVcCheckFacadeControllerBean
extends AbstractBankVcCheckFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.BankVcCheckFacadeControllerBean");

    @Override
    protected IObjectCollection _getBankCheckCollection(Context ctx, String strCompanyId, String strBankAccountId, String strCurrencyId, Date beginDate, Date endDate) throws BOSException, EASBizException {
        IBankStatement iBankStat = BankStatementFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = this.getEntityViewInfo(strCompanyId, strBankAccountId, strCurrencyId, beginDate, endDate);
        BankStatementCollection bankStatColl = iBankStat.getBankStatementCollection(viewInfo);
        return bankStatColl;
    }

    @Override
    protected IObjectCollection _getJournalCollection(Context ctx, String strCompanyId, String strBankAccountId, String strCurrencyId, Date beginDate, Date endDate) throws BOSException, EASBizException {
        IJournal iJournal = JournalFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = this.getEntityViewInfo(strCompanyId, strBankAccountId, strCurrencyId, beginDate, endDate);
        JournalCollection journalColl = iJournal.getJournalCollection(viewInfo);
        return journalColl;
    }

    private EntityViewInfo getEntityViewInfo(String strCompanyId, String strBankAccountId, String strCurrencyId, Date beginDate, Date endDate) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection items = filterInfo.getFilterItems();
        if (strCompanyId != null) {
            items.add(new FilterItemInfo("company.id", (Object)strCompanyId));
        }
        if (strBankAccountId != null) {
            items.add(new FilterItemInfo("accountBank.id", (Object)strBankAccountId));
        }
        if (strCurrencyId != null) {
            items.add(new FilterItemInfo("currency.id", (Object)strCurrencyId));
        }
        if (beginDate != null) {
            items.add(new FilterItemInfo("createDate", (Object)beginDate, CompareType.GREATER_EQUALS));
        }
        if (endDate != null) {
            items.add(new FilterItemInfo("createDate", (Object)beginDate, CompareType.LESS_EQUALS));
        }
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    @Override
    protected IRowSet _getMultiOrgBankStatement(Context ctx, Map paramMap) throws BOSException, EASBizException {
        BankVcMultiCompanyCheck multiCompanyCheck = new BankVcMultiCompanyCheck();
        return multiCompanyCheck.getMultiOrgBankStatement(ctx, paramMap);
    }
}

