/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fi.cas.BankBalanceAdjustmentFactory;
import com.kingdee.eas.fi.cas.BankStatementInfo;
import com.kingdee.eas.fi.cas.BankStmtBookReportInfo;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.IBankBalanceAdjustment;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.app.AbstractBankVcCheckWebFacadeControllerBean;
import com.kingdee.eas.fi.cas.app.BankVcCheckWebHelper;
import com.kingdee.eas.fi.cas.utils.BankVCUtil;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.vo.BankVCAdjustmentFilterVO;
import com.kingdee.eas.fi.cas.vo.BankVCBatchRstVO;
import com.kingdee.eas.fi.cas.vo.BankVCBatchShowRowVO;
import com.kingdee.eas.fi.cas.vo.BankVCCancelVO;
import com.kingdee.eas.fi.cas.vo.BankVCDataVO;
import com.kingdee.eas.fi.cas.vo.BankVCFilterVO;
import com.kingdee.eas.fi.cas.vo.BankVCHistoryVO;
import com.kingdee.eas.fi.cas.vo.BankVCOutStandingFilterVO;
import com.kingdee.eas.fi.cas.vo.BankVCRstSubmitVO;
import com.kingdee.eas.fi.cas.vo.BankVCUserOptionVO;
import com.kingdee.eas.fi.cas.vo.BatchVCSettingVO;
import com.kingdee.eas.fi.cas.vo.BatchVcFilterVO;
import com.kingdee.eas.fi.cas.vo.BatchVcSubFilterVO;
import com.kingdee.eas.fm.common.IUserOption;
import com.kingdee.eas.fm.common.UserOptionCollection;
import com.kingdee.eas.fm.common.UserOptionFactory;
import com.kingdee.eas.fm.common.UserOptionInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class BankVcCheckWebFacadeControllerBean
extends AbstractBankVcCheckWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.BankVcCheckWebFacadeControllerBean");

    @Override
    protected Map _f7CompanyDataChange(Context ctx, String f7CompanyID) throws BOSException, EASBizException {
        HashMap<String, String> rstData = new HashMap<String, String>();
        if (StringUtil.isEmptyString((String)f7CompanyID)) {
            rstData.put("MsgStr", CASWebUtil.getResource(ctx, "InputOrgUnitIsNull"));
            return rstData;
        }
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(f7CompanyID));
        rstData.put("curCompanyForUnShare", (String)ContextUtil.getCurrentFIUnit((Context)ctx));
        if (!company.isIsBizUnit()) {
            rstData.put("MsgStr", CASWebUtil.getResource(ctx, "PelSelectedBizOrgUnit"));
            return rstData;
        }
        BankVcCheckWebHelper bankVCHelper = new BankVcCheckWebHelper(ctx);
        bankVCHelper.doArrangeCurrency_PeriodOfCompany(rstData, company, null);
        String strCompanyId = company.getId().toString();
        AccountBankCollection acctBankColls = CASWebHelper.getAccountBankCollection(ctx, strCompanyId, true);
        rstData.put("acctBankColl", (String)acctBankColls);
        bankVCHelper.doArrangeAutoCheckSetting(rstData, company);
        return rstData;
    }

    @Override
    protected Map _f7BankDataChange(Context ctx, String f7BankID) throws BOSException, EASBizException {
        HashMap<String, Object> rstData = new HashMap<String, Object>();
        if (StringUtil.isEmptyString((String)f7BankID)) {
            rstData.put("MsgStr", CASWebUtil.getResource(ctx, "InputAccountBankIsNull"));
            return rstData;
        }
        AccountBankInfo bankInfo = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(f7BankID));
        if (EmptyUtil.isEmpty((CoreBaseInfo)bankInfo)) {
            rstData.put("MsgStr", CASWebUtil.getResource(ctx, "InputAccountBankIsNull"));
            return rstData;
        }
        String compenyID = bankInfo.getCompany().getId().toString();
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(compenyID));
        CurrencyInfo currency = null;
        if (!EmptyUtil.isEmpty((CoreBaseInfo)bankInfo) && bankInfo.isIsByCurrency()) {
            currency = bankInfo.getCurrency();
            rstData.put("currencyDisable", "true");
        } else {
            currency = company.getBaseCurrency();
            rstData.put("currencyDisable", "false");
        }
        if (currency != null && currency.getId() != null && currency.getName() == null) {
            currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId()));
        }
        rstData.put("curAcctBank", bankInfo);
        rstData.put("currency", currency);
        rstData.put("isClosed", bankInfo.get("isclosed"));
        return rstData;
    }

    @Override
    protected Map _cBoxPeriodYearDataChange(Context ctx, String curCompanyID, String curPeriodYear) throws BOSException, EASBizException {
        HashMap<String, Object> rstData = new HashMap<String, Object>();
        if (StringUtil.isEmptyString((String)curCompanyID) || StringUtil.isEmptyString((String)curPeriodYear)) {
            rstData.put("MsgStr", CASWebUtil.getResource(ctx, "InputDataExption"));
            return rstData;
        }
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(curCompanyID));
        if (company == null) {
            rstData.put("MsgStr", CASWebUtil.getResource(ctx, "InputOrgUnitIsNull"));
            return rstData;
        }
        int periodYear = Integer.parseInt(curPeriodYear);
        BankVcCheckWebHelper bankVCHelper = new BankVcCheckWebHelper(ctx);
        rstData.put("curPeriodNumberEnum", bankVCHelper.doArrangePeriodNumber(company, periodYear));
        return rstData;
    }

    @Override
    protected Map _checkPermission(Context ctx, String companyID, String permissionItem) throws BOSException, EASBizException {
        HashMap rstData = new HashMap();
        BankVcCheckWebHelper bankVCHelper = new BankVcCheckWebHelper(ctx);
        bankVCHelper.checkBankVCFuncPermission(rstData, companyID, permissionItem);
        return rstData;
    }

    @Override
    protected Map _getAutoCheckPageInitData(Context ctx) throws BOSException, EASBizException {
        HashMap<String, String> context = new HashMap<String, String>();
        BankVcCheckWebHelper bankVCHelper = new BankVcCheckWebHelper(ctx);
        CompanyOrgUnitInfo defaultFIUnit = ContextUtil.getCurrentFIUnit((Context)ctx);
        CompanyOrgUnitInfo selCompany = bankVCHelper.doArrangeDefaultFIUnit_Currency(context, defaultFIUnit);
        String orgFilter = null;
        try {
            orgFilter = CASWebHelper.getAuthorizedOrgFilter(ctx, "cas_bankVcCheck_02contrast", false, "id");
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
            context.put("MsgStr", e1.getMessage());
            context.put("MsgDetail", e1.toString());
        }
        catch (BOSException e2) {
            e2.printStackTrace();
            context.put("MsgStr", e2.getMessage());
            context.put("MsgDetail", e2.toString());
        }
        if (orgFilter == null) {
            orgFilter = "id = ''";
        }
        context.put("OrgF7Filter", orgFilter);
        context.put("curDateStr", BankVCUtil.dateFormat.format(new Date()));
        if (selCompany == null) {
            context.put("MsgStr", CASWebUtil.getResource(ctx, "277_NO_BIZCOMPANY_PERMISSION"));
        } else {
            bankVCHelper.doArrangeCurrency_PeriodOfCompany(context, selCompany, null);
        }
        bankVCHelper.doArrangeAutoCheckSetting(context, selCompany);
        return context;
    }

    @Override
    protected Map _saveAutoCheckSetting(Context ctx, String jsonstr) throws BOSException, EASBizException {
        HashMap<String, String> rstData = new HashMap<String, String>();
        BankVCUserOptionVO dataVO = (BankVCUserOptionVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr, BankVCUserOptionVO.class);
        if (dataVO.getCompanyID() == null) {
            rstData.put("MsgStr", CASWebUtil.getResource(ctx, "InputOrgUnitIsNull"));
            return rstData;
        }
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(dataVO.getCompanyID()));
        if (company == null || company.getId() == null) {
            rstData.put("MsgStr", CASWebUtil.getResource(ctx, "InputOrgUnitIsNull"));
            return rstData;
        }
        try {
            rstData.put("defaultFIUnit", company.getId().toString());
            BankVcCheckWebHelper bankVCHelper = new BankVcCheckWebHelper(ctx);
            bankVCHelper.doSaveAutoCheckSetting(rstData, company, dataVO);
            rstData.put("MsgStr", CASWebUtil.getResource(ctx, "AutoVCConfigOK"));
            rstData.put("OPStatus", "success");
        }
        catch (EASBizException e1) {
            rstData.put("MsgStr", e1.getMessage());
            rstData.put("MsgDetail", e1.toString());
            e1.printStackTrace();
        }
        catch (BOSException e2) {
            rstData.put("MsgStr", e2.getMessage());
            rstData.put("MsgDetail", e2.toString());
            e2.printStackTrace();
        }
        return rstData;
    }

    @Override
    protected Map _doAutoVCCheck(Context ctx, String jsonstr) throws BOSException, EASBizException {
        HashMap<String, String> rstData = new HashMap<String, String>();
        BankVCFilterVO dataVO = (BankVCFilterVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr, BankVCFilterVO.class);
        if (dataVO == null) {
            rstData.put("MsgStr", CASWebUtil.getResource(ctx, "PleSelecedQueryFilter"));
            return rstData;
        }
        try {
            ICompanyOrgUnit iorg;
            BankVcCheckWebHelper bankVCHelper = new BankVcCheckWebHelper(ctx);
            bankVCHelper.checkBankVCFuncPermission(rstData, dataVO.getCompanyID(), "cas_bankVcCheck_02contrast");
            String msgStr = (String)rstData.get("MsgStr");
            if (!StringUtil.isEmptyString((String)msgStr)) {
                return rstData;
            }
            CompanyOrgUnitInfo company = bankVCHelper.doArrangeDefaultFIUnit_Currency(rstData, null);
            if (dataVO != null && dataVO.getCompanyID() != null && (iorg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx)).exists((IObjectPK)new ObjectUuidPK(dataVO.getCompanyID()))) {
                company = iorg.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(dataVO.getCompanyID()));
            }
            rstData.put("defaultFIUnit", company.getId().toString());
            bankVCHelper.getBankVCAutoCheckResult(rstData, dataVO, company, false, false);
            if (rstData.get("MsgStr") == null) {
                rstData.put("OPStatus", "success");
            }
        }
        catch (EASBizException e1) {
            rstData.put("MsgStr", e1.getMessage());
            rstData.put("MsgDetail", e1.toString());
            e1.printStackTrace();
        }
        catch (BOSException e2) {
            rstData.put("MsgStr", e2.getMessage());
            rstData.put("MsgDetail", e2.toString());
            e2.printStackTrace();
        }
        catch (SQLException e3) {
            rstData.put("MsgStr", e3.getMessage());
            rstData.put("MsgDetail", e3.toString());
            e3.printStackTrace();
        }
        return rstData;
    }

    @Override
    protected Map _submitAutoVCResult(Context ctx, String jsonstr) throws BOSException, EASBizException {
        HashMap<String, String> rstData = new HashMap<String, String>();
        BankVCRstSubmitVO dataVO = (BankVCRstSubmitVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr, BankVCRstSubmitVO.class);
        if (dataVO == null) {
            rstData.put("MsgStr", CASWebUtil.getResource(ctx, "PleSelecedQueryFilter"));
            return rstData;
        }
        try {
            ICompanyOrgUnit iorg;
            BankVcCheckWebHelper bankVCHelper = new BankVcCheckWebHelper(ctx);
            bankVCHelper.checkBankVCFuncPermission(rstData, dataVO.getCompanyID(), "cas_bankVcCheck_02contrast");
            String msgStr = (String)rstData.get("MsgStr");
            if (!StringUtil.isEmptyString((String)msgStr)) {
                return rstData;
            }
            CompanyOrgUnitInfo company = bankVCHelper.doArrangeDefaultFIUnit_Currency(rstData, null);
            if (dataVO != null && dataVO.getCompanyID() != null && (iorg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx)).exists((IObjectPK)new ObjectUuidPK(dataVO.getCompanyID()))) {
                company = iorg.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(dataVO.getCompanyID()));
            }
            if (dataVO.getVcAutoRstIds() == null || dataVO.getVcAutoRstIds().length == 0) {
                rstData.put("MsgStr", CASWebUtil.getResource(ctx, "PleSelecedVCResultRow"));
                return rstData;
            }
            bankVCHelper.submitAutoVCResultToDB(rstData, dataVO, company);
            if (rstData.get("MsgStr") == null) {
                bankVCHelper.getBankVCAutoCheckResult(rstData, dataVO.getVcAutoFilter(), company, false, false);
                rstData.put("MsgStr", CASWebUtil.getResource(ctx, "VCResultSubmitOK"));
                rstData.put("OPStatus", "success");
            }
        }
        catch (EASBizException e1) {
            rstData.put("MsgStr", e1.getMessage());
            rstData.put("MsgDetail", e1.toString());
            e1.printStackTrace();
        }
        catch (BOSException e2) {
            rstData.put("MsgStr", e2.getMessage());
            rstData.put("MsgDetail", e2.toString());
            e2.printStackTrace();
        }
        catch (SQLException e3) {
            rstData.put("MsgStr", e3.getMessage());
            rstData.put("MsgDetail", e3.toString());
            e3.printStackTrace();
        }
        return rstData;
    }

    @Override
    protected Map _getHandlerCheckPageInitData(Context ctx) throws BOSException, EASBizException {
        HashMap<String, String> context = new HashMap<String, String>();
        BankVcCheckWebHelper bankVCHelper = new BankVcCheckWebHelper(ctx);
        CompanyOrgUnitInfo defaultFIUnit = ContextUtil.getCurrentFIUnit((Context)ctx);
        CompanyOrgUnitInfo selCompany = bankVCHelper.doArrangeDefaultFIUnit_Currency(context, defaultFIUnit);
        String orgFilter = null;
        try {
            orgFilter = CASWebHelper.getAuthorizedOrgFilter_F7Special(ctx, "cas_bankVcCheck_02contrast", false, "unit.id", "tree.id");
        }
        catch (EASBizException e1) {
            context.put("MsgStr", e1.getMessage());
            context.put("MsgDetail", e1.toString());
        }
        catch (BOSException e2) {
            context.put("MsgStr", e2.getMessage());
            context.put("MsgDetail", e2.toString());
        }
        if (orgFilter == null) {
            orgFilter = "unit.id = ''";
        }
        context.put("OrgF7Filter", orgFilter);
        SimpleDateFormat dfm = new SimpleDateFormat("yyyy-MM-dd");
        context.put("curDateStr", dfm.format(new Date()));
        if (selCompany == null) {
            context.put("MsgStr", CASWebUtil.getResource(ctx, "277_NO_BIZCOMPANY_PERMISSION"));
        } else {
            bankVCHelper.doArrangeCurrency_PeriodOfCompany(context, selCompany, null);
        }
        return context;
    }

    @Override
    protected Map _getHandlerCheckQueryFilters(Context ctx, String jsonstr) throws BOSException, EASBizException {
        HashMap<String, Object> rstData = new HashMap<String, Object>();
        BankVCFilterVO filterVO = (BankVCFilterVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr, BankVCFilterVO.class);
        if (filterVO == null) {
            rstData.put("MsgStr", CASWebUtil.getResource(ctx, "InputDataExption"));
            return rstData;
        }
        try {
            BankVcCheckWebHelper bankVCHelper = new BankVcCheckWebHelper(ctx);
            bankVCHelper.doArrangeQueryFilters(rstData, filterVO);
            rstData.put("BankVCFilterVO", filterVO);
            if (filterVO.getReturnFilterDefValue() > 0) {
                bankVCHelper.doArrangeBankVCFilterVO(filterVO);
                String orgFilter = null;
                try {
                    orgFilter = CASWebHelper.getAuthorizedOrgFilter_F7Special(ctx, "cas_bankVcCheck_02contrast", false, "unit.id", "tree.id");
                }
                catch (EASBizException e1) {
                    rstData.put("MsgStr", e1.getMessage());
                    rstData.put("MsgDetail", e1.toString());
                }
                catch (BOSException e2) {
                    rstData.put("MsgStr", e2.getMessage());
                    rstData.put("MsgDetail", e2.toString());
                }
                if (orgFilter == null) {
                    orgFilter = "unit.id = ''";
                }
                rstData.put("OrgF7Filter", orgFilter);
                SimpleDateFormat dfm = new SimpleDateFormat("yyyy-MM-dd");
                rstData.put("curDateStr", dfm.format(new Date()));
                bankVCHelper.doArrangeCurrency_PeriodOfCompany(rstData, filterVO.getCompany(), filterVO.getAcctBank());
                if (filterVO.getCompany() != null) {
                    rstData.put("defaultFIUnit", filterVO.getCompany());
                }
                if (filterVO.getAcctBank() != null) {
                    rstData.put("curAcctBank", filterVO.getAcctBank());
                }
                if (filterVO.getPeriodID() != null) {
                    PeriodInfo curPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(filterVO.getPeriodID()));
                    rstData.put("curPeriod", curPeriod);
                    PeriodCollection periodColl = CASWebHelper.getPeriodColls(ctx, filterVO.getCompany());
                    rstData.put("periodColl", periodColl);
                }
                if (filterVO.getStartDate() != null) {
                    rstData.put("startDateStr", dfm.format(filterVO.getStartDate()));
                }
                if (filterVO.getEndDate() != null) {
                    rstData.put("eneDateStr", dfm.format(filterVO.getEndDate()));
                }
            }
            if (filterVO.getCurrency() != null) {
                rstData.put("currency", filterVO.getCurrency());
            }
            rstData.put("periodWay", filterVO.getPeriodWay());
        }
        catch (EASBizException e1) {
            rstData.put("MsgStr", e1.getMessage());
            rstData.put("MsgDetail", e1.toString());
            e1.printStackTrace();
        }
        catch (BOSException e2) {
            rstData.put("MsgStr", e2.getMessage());
            rstData.put("MsgDetail", e2.toString());
            e2.printStackTrace();
        }
        return rstData;
    }

    @Override
    protected Map _doSubmitHandlerVCResult(Context ctx, String jsonstr) throws BOSException, EASBizException {
        HashMap<String, String> rstData = new HashMap<String, String>();
        BankVCDataVO dataVO = (BankVCDataVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr, BankVCDataVO.class);
        if (dataVO == null) {
            rstData.put("MsgStr", CASWebUtil.getResource(ctx, "PleSelecedQueryFilter"));
            return rstData;
        }
        try {
            BankVcCheckWebHelper bankVCHelper = new BankVcCheckWebHelper(ctx);
            bankVCHelper.checkBankVCFuncPermission(rstData, dataVO.getCompanyID(), "cas_bankVcCheck_02contrast");
            String msgStr = (String)rstData.get("MsgStr");
            if (!StringUtil.isEmptyString((String)msgStr)) {
                return rstData;
            }
            if (dataVO.getVcBankRows() == null || dataVO.getVcBankRows().length <= 0 || dataVO.getVcJournalRows() == null || dataVO.getVcJournalRows().length <= 0) {
                rstData.put("MsgStr", CASWebHelper.getCASMsg(ctx, "SelectCheckoutMsg"));
                return rstData;
            }
            bankVCHelper.doActionSubmitVCResult(rstData, dataVO);
        }
        catch (EASBizException e1) {
            rstData.put("MsgStr", e1.getMessage());
            rstData.put("MsgDetail", e1.toString());
            e1.printStackTrace();
        }
        catch (BOSException e2) {
            rstData.put("MsgStr", e2.getMessage());
            rstData.put("MsgDetail", e2.toString());
            e2.printStackTrace();
        }
        return rstData;
    }

    @Override
    protected Map _getVCHistoryPageInitData(Context ctx) throws BOSException, EASBizException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        BankVcCheckWebHelper bankVCHelper = new BankVcCheckWebHelper(ctx);
        CompanyOrgUnitInfo defaultFIUnit = ContextUtil.getCurrentFIUnit((Context)ctx);
        CompanyOrgUnitInfo selCompany = bankVCHelper.doArrangeDefaultFIUnit_Currency(context, defaultFIUnit);
        context.put("defaultFIUnit", selCompany);
        String orgFilter = null;
        try {
            orgFilter = CASWebHelper.getAuthorizedOrgFilter_F7Special(ctx, "cas_bankVcCheck_02contrast", false, "unit.id", "tree.id");
        }
        catch (EASBizException e1) {
            context.put("MsgStr", e1.getMessage());
        }
        catch (BOSException e2) {
            context.put("MsgStr", e2.getMessage());
        }
        if (orgFilter == null) {
            orgFilter = "unit.id = ''";
        }
        context.put("OrgF7Filter", orgFilter);
        SimpleDateFormat dfm = new SimpleDateFormat("yyyy-MM-dd");
        context.put("curDateStr", dfm.format(new Date()));
        if (selCompany == null) {
            context.put("MsgStr", CASWebUtil.getResource(ctx, "277_NO_BIZCOMPANY_PERMISSION"));
        } else {
            bankVCHelper.doArrangeCurrency_PeriodOfCompany(context, selCompany, null);
        }
        return context;
    }

    @Override
    protected Map _getVCHistoryQueryDatasByFilter(Context ctx, String jsonstr) throws BOSException, EASBizException {
        HashMap<String, Object> rstData = new HashMap<String, Object>();
        BankVCFilterVO filterVO = (BankVCFilterVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr, BankVCFilterVO.class);
        if (filterVO == null) {
            rstData.put("MsgStr", CASWebUtil.getResource(ctx, "InputDataExption"));
            return rstData;
        }
        try {
            BankVcCheckWebHelper bankVCHelper = new BankVcCheckWebHelper(ctx);
            Map HistoryData = this._getHistoryData(ctx, jsonstr, null, 1, 10);
            rstData.put("bankBCHistorys", HistoryData.get("vcHistoryData"));
            bankVCHelper.getQueryVCHistoryDatasByFilter(rstData, filterVO);
            rstData.put("BankVCFilterVO", filterVO);
            bankVCHelper.doArrangeQueryFilters(rstData, filterVO);
            Date startDate = filterVO.getStartDate();
            Date endDate = filterVO.getEndDate();
            if (filterVO.getReturnFilterDefValue() > 0) {
                bankVCHelper.doArrangeBankVCFilterVO(filterVO);
                String orgFilter = null;
                try {
                    orgFilter = CASWebHelper.getAuthorizedOrgFilter_F7Special(ctx, "cas_bankVcCheck_02contrast", false, "unit.id", "tree.id");
                }
                catch (EASBizException e1) {
                    rstData.put("MsgStr", e1.getMessage());
                    rstData.put("MsgDetail", e1.toString());
                    e1.printStackTrace();
                }
                catch (BOSException e2) {
                    rstData.put("MsgStr", e2.getMessage());
                    rstData.put("MsgDetail", e2.toString());
                    e2.printStackTrace();
                }
                if (orgFilter == null) {
                    orgFilter = "unit.id = ''";
                }
                rstData.put("OrgF7Filter", orgFilter);
                SimpleDateFormat dfm = new SimpleDateFormat("yyyy-MM-dd");
                rstData.put("curDateStr", dfm.format(new Date()));
                bankVCHelper.doArrangeCurrency_PeriodOfCompany(rstData, filterVO.getCompany(), filterVO.getAcctBank());
                if (filterVO.getCompany() != null) {
                    rstData.put("defaultFIUnit", filterVO.getCompany());
                }
                if (filterVO.getAcctBank() != null) {
                    rstData.put("curAcctBank", filterVO.getAcctBank());
                }
                if (filterVO.getPeriodID() != null) {
                    PeriodInfo curPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(filterVO.getPeriodID()));
                    rstData.put("curPeriod", curPeriod);
                    if (startDate != null && endDate != null) {
                        rstData.put("startDateStr", dfm.format(startDate));
                        rstData.put("eneDateStr", dfm.format(endDate));
                        rstData.put("byDate", "1");
                    }
                    PeriodCollection periodColl = CASWebHelper.getPeriodColls(ctx, filterVO.getCompany());
                    rstData.put("periodColl", periodColl);
                }
            }
            if (filterVO.getCurrency() != null) {
                rstData.put("currency", filterVO.getCurrency());
            }
        }
        catch (EASBizException e1) {
            rstData.put("MsgStr", e1.getMessage());
            rstData.put("MsgDetail", e1.toString());
            e1.printStackTrace();
        }
        catch (BOSException e2) {
            rstData.put("MsgStr", e2.getMessage());
            rstData.put("MsgDetail", e2.toString());
            e2.printStackTrace();
        }
        catch (SQLException e3) {
            rstData.put("MsgStr", e3.getMessage());
            rstData.put("MsgDetail", e3.toString());
            e3.printStackTrace();
        }
        return rstData;
    }

    @Override
    protected Map _getHistoryData(Context ctx, String argJsonStr, String tableName, int page, int rows) throws BOSException {
        BankVCFilterVO filterVO = (BankVCFilterVO)JSONUtils.convertJsonToObject((Context)ctx, (String)argJsonStr, BankVCFilterVO.class);
        HashMap<String, Object> gridData = new HashMap<String, Object>();
        try {
            BankVcCheckWebHelper bankVCHelper = new BankVcCheckWebHelper(ctx);
            bankVCHelper.doArrangeBankVCFilterVO(filterVO);
            if (tableName == null) {
                String selectBankStatementSql = this.getSelectBankStatementSQL(filterVO);
                String selectJournalSql = this.getSelectjournalSQL(filterVO);
                String selectVcResultKeySql = "SELECT DISTINCT FCompanyId,  FGroup, FKey FROM T_VC_VCResult  WHERE FBizObjectId IN (" + selectBankStatementSql + " union all " + selectJournalSql + ") order by FKey";
                tableName = this.createVCHistoryTempTable(ctx);
                String insertTempDataSql = "INSERT INTO " + tableName + "(FOrgId,  FGroup, FKey) (" + selectVcResultKeySql + ")";
                Connection connection = null;
                PreparedStatement ps = null;
                try {
                    connection = this.getConnection(ctx);
                    ps = connection.prepareStatement(insertTempDataSql);
                    ps.execute();
                }
                catch (SQLException e) {
                    try {
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(ps, (Connection)connection);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)ps, (Connection)connection);
            }
            gridData.put("tableName", tableName);
            String keyCountSql = "SELECT COUNT(*) NUM FROM " + tableName;
            IRowSet keyCountRowSet = DbUtil.executeQuery((Context)ctx, (String)keyCountSql);
            keyCountRowSet.next();
            int num = keyCountRowSet.getInt("NUM");
            gridData.put("totalCount", num);
            if (num == 0) {
                gridData.put("vcHistoryData", new ArrayList());
            } else {
                String fid;
                BankStatementInfo info;
                String selectKeySql = "SELECT FOrgId, FKey FROM " + tableName;
                IRowSet keyRowSet = DbUtil.executeQuery((Context)ctx, (String)selectKeySql, (int)((page - 1) * rows), (int)rows);
                keyRowSet.next();
                StringBuffer selectVcResultSql = new StringBuffer("SELECT  \"VCRESULT\".FID, FVcverifyID, FGroup, FBizObjectFullName, FBizObjectId,FKey, \"VCRESULT\".FCreateTime,\"CREATOR\".FName_l2 AS \"CREATOR\"\r\n FROM T_VC_VCResult AS \"VCRESULT\" LEFT OUTER JOIN T_PM_User AS \"CREATOR\"\r\nON \"VCRESULT\".FCreatorID = \"CREATOR\".FID WHERE FKEY IN (''");
                keyRowSet.beforeFirst();
                while (keyRowSet.next()) {
                    selectVcResultSql.append(",'" + keyRowSet.getString("FKey") + "'");
                }
                selectVcResultSql.append(") order by FVcverifyID, FKey, FBizObjectFullName");
                IRowSet vcResultRowSet = DbUtil.executeQuery((Context)ctx, (String)selectVcResultSql.toString());
                HashMap<String, BankStatementInfo> bankMap = new HashMap<String, BankStatementInfo>();
                HashMap<String, BankStatementInfo> journalMap = new HashMap<String, BankStatementInfo>();
                StringBuffer sb = new StringBuffer(BankVCUtil.getBankStatSQL());
                sb.append(" ( '' ");
                while (vcResultRowSet.next()) {
                    if (!"com.kingdee.eas.fi.cas.app.BankStatement".equals(vcResultRowSet.getString("FBizObjectFullName"))) continue;
                    sb.append(", '");
                    sb.append(vcResultRowSet.getString("FBizObjectId"));
                    sb.append("'");
                }
                sb.append(" ) ");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                while (rs.next()) {
                    info = new BankStatementInfo();
                    fid = rs.getString("id");
                    info.setId(BOSUuid.read((String)fid));
                    info.setCreateDate(rs.getDate("createDate"));
                    info.setBizDate(rs.getDate("createDate"));
                    info.setSettleNumber(rs.getString("settleNumber"));
                    SettlementTypeInfo typeInfo = new SettlementTypeInfo();
                    typeInfo.setName(rs.getString("settleType.name"));
                    info.setSettleType(typeInfo);
                    info.setDescription(rs.getString("description"));
                    info.setDebitAmount(rs.getBigDecimal("debitAmount"));
                    info.setCreditAmount(rs.getBigDecimal("creditAmount"));
                    CompanyOrgUnitInfo com = new CompanyOrgUnitInfo();
                    com.setId(BOSUuid.read((String)rs.getString("COMPANY.ID")));
                    com.setName(rs.getString("COMPANY_NAME"));
                    info.setCompany(com);
                    info.setOppUnit(rs.getString("oppunit"));
                    bankMap.put(fid, info);
                }
                sb = new StringBuffer(BankVCUtil.getJournalSQL());
                sb.append(" ( '' ");
                vcResultRowSet.beforeFirst();
                while (vcResultRowSet.next()) {
                    if (!"com.kingdee.eas.fi.cas.app.Journal".equals(vcResultRowSet.getString("FBizObjectFullName"))) continue;
                    sb.append(", '");
                    sb.append(vcResultRowSet.getString("FBizObjectId"));
                    sb.append("'");
                }
                sb.append(" ) ");
                rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                while (rs.next()) {
                    info = new JournalInfo();
                    fid = rs.getString("id");
                    info.setId(BOSUuid.read((String)fid));
                    info.setCreateDate(rs.getDate("createDate"));
                    if (rs.getDate("bizDate") != null) {
                        info.setBizDate(rs.getDate("bizDate"));
                    }
                    info.setSettlementNumber(rs.getString("settlementNumber"));
                    SettlementTypeInfo settleTypeInfo = new SettlementTypeInfo();
                    settleTypeInfo.setName(rs.getString("settlementType.name"));
                    info.setSettlementType(settleTypeInfo);
                    info.setDescription(rs.getString("description"));
                    info.setVoucherNumber(rs.getString("voucherNumber"));
                    VoucherTypeInfo voucherTypeInfo = new VoucherTypeInfo();
                    voucherTypeInfo.setName(rs.getString("voucherType.name"));
                    info.setVoucherType(voucherTypeInfo);
                    info.setDebitAmount(rs.getBigDecimal("debitAmount"));
                    info.setCreditAmount(rs.getBigDecimal("creditAmount"));
                    CompanyOrgUnitInfo com = new CompanyOrgUnitInfo();
                    com.setId(BOSUuid.read((String)rs.getString("COMPANY.ID")));
                    com.setName(rs.getString("COMPANY_NAME"));
                    info.setCompany(com);
                    info.setOppUnit(rs.getString("OPPUNIT"));
                    info.setBillNumber(rs.getString("BILLNUMBER"));
                    if (rs.getString("BILLTYPE") != null) {
                        info.setBillType(BillTypeEnum.getEnum(rs.getInt("BILLTYPE")));
                    }
                    journalMap.put(fid, info);
                }
                ArrayList<BankVCHistoryVO> vcHistoryLists = new ArrayList<BankVCHistoryVO>();
                vcResultRowSet.beforeFirst();
                int group = 0;
                String lastKey = "";
                while (vcResultRowSet.next()) {
                    BankStatementInfo boInfo;
                    String vcResultId = vcResultRowSet.getString("FID");
                    String bizObjectFullName = vcResultRowSet.getString("FBizObjectFullName");
                    String bizObjectId = vcResultRowSet.getString("FBizObjectId");
                    String key = vcResultRowSet.getString("FKey");
                    java.sql.Date createTime = null;
                    String creator = null;
                    if (vcResultRowSet.getDate("fCreateTime") != null) {
                        createTime = vcResultRowSet.getDate("fCreateTime");
                    }
                    if (vcResultRowSet.getString("CREATOR") != null) {
                        creator = vcResultRowSet.getString("CREATOR");
                    }
                    if (!key.equals(lastKey)) {
                        ++group;
                        lastKey = key;
                    }
                    BankVCHistoryVO vcHistory = new BankVCHistoryVO();
                    vcHistory.setId(vcResultId);
                    vcHistory.setCreateTime(createTime);
                    vcHistory.setCreator(creator);
                    if (bizObjectFullName.endsWith("BankStatement")) {
                        boInfo = (BankStatementInfo)bankMap.get(bizObjectId);
                        if (boInfo == null) continue;
                        vcHistory.setRecordType("bankStatement");
                        vcHistory.setGroup(group + "");
                        vcHistory.setQuerySeq_No((page - 1) * rows + group);
                        vcHistory.setSelect(Boolean.FALSE);
                        vcHistory.setCompany(boInfo.getCompany().getName());
                        vcHistory.setRecord(CASWebHelper.getCASMsg(ctx, "com.kingdee.eas.fi.cas.CheckoutResource", "BankCheckRecord"));
                        vcHistory.setDate(boInfo.getCreateDate());
                        vcHistory.setBizDate(boInfo.getBizDate());
                        vcHistory.setSettNumber(boInfo.getSettleNumber());
                        vcHistory.setSettType(boInfo.getSettleType().getName());
                        vcHistory.setDescription(boInfo.getDescription());
                        vcHistory.setDebitAmount(boInfo.getDebitAmount());
                        vcHistory.setCreditAmount(boInfo.getCreditAmount());
                        vcHistory.setOppunit(boInfo.getOppUnit());
                    } else {
                        boInfo = (JournalInfo)journalMap.get(bizObjectId);
                        if (boInfo == null) continue;
                        vcHistory.setRecordType("bankJournal");
                        vcHistory.setGroup(group + "");
                        vcHistory.setQuerySeq_No((page - 1) * rows + group);
                        vcHistory.setSelect(Boolean.FALSE);
                        vcHistory.setRecord(CASWebHelper.getCASMsg(ctx, "com.kingdee.eas.fi.cas.CheckoutResource", "BankJournalRecord"));
                        vcHistory.setDate(boInfo.getCreateDate());
                        vcHistory.setBizDate(boInfo.getBizDate());
                        vcHistory.setCompany(boInfo.getCompany().getName());
                        vcHistory.setSettNumber(boInfo.getSettlementNumber());
                        vcHistory.setSettType(boInfo.getSettlementType().getName());
                        vcHistory.setDescription(boInfo.getDescription());
                        if (boInfo.getVoucherNumber() != null) {
                            vcHistory.setVoucherNumber(boInfo.getVoucherNumber());
                        }
                        if (boInfo.getVoucherType() != null) {
                            vcHistory.setVoucherType(boInfo.getVoucherType().getName());
                        }
                        vcHistory.setDebitAmount(boInfo.getDebitAmount());
                        vcHistory.setCreditAmount(boInfo.getCreditAmount());
                        if (boInfo.getBillNumber() != null) {
                            vcHistory.setBillNumber(boInfo.getBillNumber());
                        }
                        if (boInfo.getBillType() != null) {
                            vcHistory.setBillType(boInfo.getBillType().getAlias());
                        }
                        vcHistory.setOppunit(boInfo.getOppUnit());
                    }
                    vcHistoryLists.add(vcHistory);
                }
                gridData.put("vcHistoryData", vcHistoryLists);
            }
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return gridData;
    }

    private String createVCHistoryTempTable(Context ctx) throws BOSException {
        String tableName = "";
        try {
            ITableManagerFacade mang = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
            tableName = mang.getTableName("vcgrouplist");
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        StringBuffer sbCreate = new StringBuffer("create table ");
        sbCreate.append(tableName);
        sbCreate.append(" ( ");
        sbCreate.append("FOrgId varchar (44) NOT NULL, ");
        sbCreate.append("FGroup int NOT NULL, ");
        sbCreate.append("FKey varchar (44) NOT NULL ");
        sbCreate.append(")");
        Connection connection = null;
        PreparedStatement ps = null;
        String sql = sbCreate.toString();
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql);
            ps.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
        return tableName;
    }

    private String getSelectBankStatementSQL(BankVCFilterVO filterVO) {
        StringBuffer oqlA = new StringBuffer();
        oqlA.append("SELECT FID FROM T_CAS_BankStatement WHERE FcurrencyID = '");
        oqlA.append(filterVO.getCurrency().getId().toString());
        oqlA.append("' AND FAccountBankID = '");
        oqlA.append(filterVO.getAcctBank().getId().toString());
        oqlA.append("'");
        oqlA.append(" AND FCreateDate >= {");
        oqlA.append(BankVCUtil.dateFormat.format(filterVO.getStartDate())).append("}");
        oqlA.append(" AND FCreateDate <= {");
        oqlA.append(BankVCUtil.dateFormat.format(filterVO.getEndDate()));
        oqlA.append("}");
        return oqlA.toString();
    }

    private String getSelectjournalSQL(BankVCFilterVO filterVO) {
        StringBuffer oqlA = new StringBuffer();
        oqlA.append("SELECT FID FROM T_CAS_Journal WHERE FcurrencyID = '");
        oqlA.append(filterVO.getCurrency().getId().toString());
        oqlA.append("' AND FAccountBankID = '");
        oqlA.append(filterVO.getAcctBank().getId().toString());
        oqlA.append("'");
        oqlA.append(" AND FCreateDate >= {");
        oqlA.append(BankVCUtil.dateFormat.format(filterVO.getStartDate())).append("}");
        oqlA.append(" AND FCreateDate <= {");
        oqlA.append(BankVCUtil.dateFormat.format(filterVO.getEndDate()));
        oqlA.append("}");
        return oqlA.toString();
    }

    @Override
    protected Map _saveCancelVCHistory(Context ctx, String jsonstr) throws BOSException, EASBizException {
        HashMap<String, Object> rstData = new HashMap<String, Object>();
        BankVCCancelVO cancelVO = (BankVCCancelVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr, BankVCCancelVO.class);
        if (cancelVO == null) {
            rstData.put("MsgStr", CASWebUtil.getResource(ctx, "PleSelecedQueryFilter"));
            return rstData;
        }
        try {
            BankVcCheckWebHelper bankVCHelper = new BankVcCheckWebHelper(ctx);
            bankVCHelper.checkBankVCFuncPermission(rstData, cancelVO.getCompanyID(), "cas_bankVcCheck_03cancelContrast");
            String msgStr = (String)rstData.get("MsgStr");
            if (!StringUtil.isEmptyString((String)msgStr)) {
                return rstData;
            }
            if (cancelVO.getVcHistroyIds() == null || cancelVO.getVcHistroyIds().length <= 0) {
                rstData.put("MsgStr", CASWebHelper.getCASMsg(ctx, "com.kingdee.eas.fi.cas.CheckoutResource", "SelectAntiRecordMsg"));
                return rstData;
            }
            bankVCHelper.saveCancelVCHistory(rstData, cancelVO);
            if (cancelVO.getVcHistroyFilter() != null) {
                HashMap rstMap = new HashMap();
                bankVCHelper.getQueryVCHistoryDatasByFilter(rstMap, cancelVO.getVcHistroyFilter());
                rstData.put("BankVCFilterVO", cancelVO.getVcHistroyFilter());
                if (rstMap.get("bankBCHistorys") != null) {
                    rstData.put("bankBCHistorys", rstMap.get("bankBCHistorys"));
                }
            }
        }
        catch (EASBizException e1) {
            rstData.put("MsgStr", e1.getMessage());
            rstData.put("MsgDetail", e1.toString());
            e1.printStackTrace();
        }
        catch (BOSException e2) {
            rstData.put("MsgStr", e2.getMessage());
            rstData.put("MsgDetail", e2.toString());
            e2.printStackTrace();
        }
        catch (SQLException e3) {
            rstData.put("MsgStr", e3.getMessage());
            rstData.put("MsgDetail", e3.toString());
            e3.printStackTrace();
        }
        return rstData;
    }

    @Override
    protected Map _getBatchVCPageInitData(Context ctx, String jsonstr) throws BOSException, EASBizException {
        HashMap hashMap = JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr);
        boolean share = (Boolean)hashMap.get("share");
        boolean isonload = (Boolean)hashMap.get("isonload");
        HashMap<String, Object> rstDataMap = new HashMap<String, Object>();
        ArrayList<BankVCBatchShowRowVO> batchVCSubRows = new ArrayList<BankVCBatchShowRowVO>();
        List<Object> companyList = new ArrayList<String>();
        String bankAccts = null;
        String currency = null;
        String companys = null;
        String status = null;
        String querySql = "select * from t_cas_bankvchistory ";
        if (isonload) {
            String filter = (String)hashMap.get("filter");
            if (!EmptyUtil.isEmpty((String)filter)) {
                if (filter.indexOf("accountBank.id") > 0 && filter.indexOf("accountBank.id is null") < 0) {
                    bankAccts = filter.substring(filter.indexOf("accountBank.id in ") + "accountBank.id in  ".length());
                    bankAccts = bankAccts.substring(0, bankAccts.indexOf(")"));
                }
                if (filter.indexOf("currency.id") > -1) {
                    currency = filter.substring(filter.indexOf("currency.id in ") + "currency.id in  ".length());
                    currency = currency.substring(0, currency.indexOf(")"));
                }
                if (filter.indexOf("company.id") > -1) {
                    if (filter.indexOf("company.id in") > -1) {
                        companys = filter.substring(filter.indexOf("company.id in ") + "company.id in  ".length());
                        companys = companys.substring(0, companys.indexOf(")"));
                        companyList = Arrays.asList(companys.split(","));
                    } else if (filter.indexOf("company.id =") > -1) {
                        String regex = "id\\s*=\\s*'(\\S*)'";
                        Pattern pattern = Pattern.compile(regex);
                        Matcher matcher = pattern.matcher(filter);
                        while (matcher.find()) {
                            companyList.add("'" + matcher.group(1) + "'");
                        }
                    }
                }
                if (filter.indexOf("status") > 0) {
                    if (filter.indexOf("status =") > 0 || filter.indexOf("status in") > 0) {
                        if (filter.indexOf("status = '2'") > 0 || filter.indexOf("status in ('2')") > 0) {
                            status = " fstatus ='\u5e73' ";
                        } else if (filter.indexOf("status = '3'") > 0 || filter.indexOf("status in ('3')") > 0) {
                            status = " fstatus ='\u4e0d\u5e73' ";
                        }
                    } else if (filter.indexOf("status not in") > 0) {
                        if (filter.indexOf("status not in ('2')") > 0) {
                            status = " fstatus ='\u4e0d\u5e73' ";
                        } else if (filter.indexOf("status not in ('3')") > 0) {
                            status = " fstatus ='\u5e73' ";
                        }
                    }
                }
            }
        } else {
            rstDataMap.put("curDateStr", BankVCUtil.dateFormat.format(new Date()));
            try {
                String SOLUTION_PARENTUINAME;
                BankVcCheckWebHelper bankVCHelper = new BankVcCheckWebHelper(ctx);
                CompanyOrgUnitInfo defaultFIUnit = ContextUtil.getCurrentFIUnit((Context)ctx);
                CompanyOrgUnitInfo selCompany = null;
                selCompany = bankVCHelper.doArrangeDefaultFIUnit_Currency_BeShare(rstDataMap, defaultFIUnit, share);
                if (selCompany == null || selCompany.getId() == null) {
                    throw new CasWebException(CasWebException.NO_ORG_AUTHRIZED);
                }
                String string = SOLUTION_PARENTUINAME = share ? "bizCommonQuery.advancedQuery.com.kingdee.eas.fi.cas.FI_CAS_BankVCSchemeBatchSettingUI_share" : "bizCommonQuery.advancedQuery.com.kingdee.eas.fi.cas.FI_CAS_BankVCSchemeBatchSettingUI";
                if (share) {
                    bankVCHelper.batchVC_doGetBatchAutoCheckPageData_Share(rstDataMap, selCompany, SOLUTION_PARENTUINAME, true, false, true, share);
                } else {
                    bankVCHelper.batchVC_doGetBatchAutoCheckPageData_Share(rstDataMap, selCompany, SOLUTION_PARENTUINAME, false, false, true, share);
                }
                companyList.add("'" + selCompany.getId().toString() + "'");
            }
            catch (EASBizException e1) {
                rstDataMap.put("MsgStr", e1.getMessage());
                rstDataMap.put("MsgDetail", e1.toString());
                e1.printStackTrace();
            }
            catch (BOSException e2) {
                rstDataMap.put("MsgStr", e2.getMessage());
                rstDataMap.put("MsgDetail", e2.toString());
                e2.printStackTrace();
            }
        }
        StringBuilder sql = new StringBuilder(querySql);
        if (bankAccts != null) {
            sql.append("where faccbankid in (" + bankAccts + ")");
        } else {
            String companyAll = "";
            for (int i = 0; i < companyList.size(); ++i) {
                companyAll = companyAll == "" ? (String)companyList.get(i) : companyAll + "," + (String)companyList.get(i);
            }
            sql.append("where fcompanyid in (" + companyAll + ")");
        }
        if (status != null) {
            sql.append(" and " + status);
        }
        if (currency != null) {
            sql.append(" and fcurrencyid in(" + currency + ")");
        }
        sql.append(" order by fcompanyid desc,fvctime desc");
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, CompanyOrgUnitInfo> companyGet = new HashMap<String, CompanyOrgUnitInfo>();
        HashSet<String> accountSet = new HashSet<String>();
        HashMap<String, BankVCBatchShowRowVO> map = new HashMap<String, BankVCBatchShowRowVO>();
        try {
            String filter;
            Locale cnLocal = Locale.SIMPLIFIED_CHINESE;
            Locale twLocal = Locale.TRADITIONAL_CHINESE;
            Locale enLocal = Locale.ENGLISH;
            while (set != null && set.next()) {
                if (companyGet.get(set.getString("fcompanyid")) == null) {
                    CompanyOrgUnitInfo companyinfo = new CompanyOrgUnitInfo();
                    companyinfo.setId(BOSUuid.read((String)set.getString("fcompanyid")));
                    companyGet.put(set.getString("fcompanyid"), companyinfo);
                    BankVCBatchShowRowVO voCompany = new BankVCBatchShowRowVO();
                    voCompany.setAddCheckBox(false);
                    voCompany.setCompanyColumn(set.getString("fcompanyname"));
                    voCompany.setId(set.getString("fcompanyid"));
                    voCompany.setCompany(companyinfo);
                    batchVCSubRows.add(voCompany);
                }
                accountSet.add(set.getString("faccbankid"));
                BankVCBatchShowRowVO vo = new BankVCBatchShowRowVO();
                vo.setAddCheckBox(false);
                vo.setId(set.getString("fid"));
                vo.setCompanyColumn(set.getString("faccbankname"));
                vo.setCurrencyColumn(set.getString("fcurrencyname"));
                vo.setStatusColumn(set.getString("fstatus"));
                vo.setRowIDColumn(set.getString("fid"));
                vo.setvcTimeColumn(set.getTimestamp("fvctime").toString());
                vo.setCompany((CompanyOrgUnitInfo)companyGet.get(set.getString("fcompanyid")));
                map.put(set.getString("faccbankid"), vo);
                batchVCSubRows.add(vo);
            }
            if (accountSet.size() > 0 && ((filter = (String)hashMap.get("filter")) == null || filter.indexOf("incluedCloseAcct = '2'") > 0 || filter.indexOf("incluedCloseAcct in ('2')") > 0 || filter.indexOf("incluedCloseAcct not in ('1')") > 0)) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", accountSet, CompareType.INCLUDE));
                view.setFilter(filterInfo);
                AccountBankCollection collection = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
                for (int i = 0; i < collection.size(); ++i) {
                    AccountBankInfo accountBankInfo = collection.get(i);
                    if (!accountBankInfo.isIsClosed()) continue;
                    BankVCBatchShowRowVO vo = (BankVCBatchShowRowVO)map.get(accountBankInfo.getId().toString());
                    batchVCSubRows.remove(vo);
                }
            }
        }
        catch (UuidException e) {
            rstDataMap.put("MsgStr", e.getMessage());
            rstDataMap.put("MsgDetail", e.toString());
            e.printStackTrace();
        }
        catch (SQLException e) {
            rstDataMap.put("MsgStr", e.getMessage());
            rstDataMap.put("MsgDetail", e.toString());
            e.printStackTrace();
        }
        rstDataMap.put("baVCOrgRowList", batchVCSubRows);
        return rstDataMap;
    }

    @Override
    protected Map _doBatchVCProcess(Context ctx, String jsonstr) throws BOSException, EASBizException {
        HashMap<String, Object> rstDataMap = new HashMap<String, Object>();
        rstDataMap.put("curDateStr", BankVCUtil.dateFormat.format(new Date()));
        if (jsonstr == null || jsonstr.length() <= 0) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "InputDataExption"));
            return rstDataMap;
        }
        HashMap hashMap = JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr);
        boolean share = (Boolean)hashMap.get("share");
        BatchVcFilterVO dataVO = (BatchVcFilterVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr, BatchVcFilterVO.class);
        if (dataVO == null || dataVO.getBatchVCIds() == null || dataVO.getBatchVCIds().size() == 0) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "InputOrgUnitIsNull"));
            return rstDataMap;
        }
        BatchVcSubFilterVO batchVCFilterVO = dataVO.getBatchVCFilter();
        if (batchVCFilterVO == null) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "InputDataExption"));
            return rstDataMap;
        }
        rstDataMap.put("batchVCFilterVO", batchVCFilterVO);
        String bankAccts = (String)hashMap.get("filter");
        if (!EmptyUtil.isEmpty((String)bankAccts) && bankAccts.indexOf("accountBank.id") > 0) {
            bankAccts = bankAccts.substring(bankAccts.indexOf("accountBank.id in ") + "accountBank.id in  ".length());
            bankAccts = bankAccts.substring(0, bankAccts.indexOf(")"));
        } else {
            bankAccts = null;
        }
        CompanyOrgUnitCollection orgColl = new CompanyOrgUnitCollection();
        if (EmptyUtil.isEmpty((String)bankAccts)) {
            StringBuffer whereIDs = new StringBuffer();
            for (String orgID : dataVO.getBatchVCIds()) {
                if (whereIDs.length() > 0) {
                    whereIDs.append(",");
                }
                whereIDs.append("'").append(orgID).append("'");
            }
            String filterstr = " where id is null ";
            if (whereIDs.length() > 0) {
                filterstr = "where id in (" + whereIDs.toString() + ") order by longnumber asc ";
            }
            orgColl = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(filterstr);
        } else {
            String filterstr = "select company.* where id in (" + bankAccts + ")";
            AccountBankCollection bankAcct = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(filterstr);
            for (int index = 0; index < bankAcct.size(); ++index) {
                orgColl.add(bankAcct.get(index).getCompany());
            }
        }
        rstDataMap.put("bankAccts", bankAccts);
        if (orgColl == null || orgColl.size() <= 0) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "InputOrgUnitIsNull"));
            return rstDataMap;
        }
        if (hashMap.get("isIntelligentBankVC") != null) {
            boolean isIntelligentBankVC = (Boolean)hashMap.get("isIntelligentBankVC");
            rstDataMap.put("isIntelligentBankVC", isIntelligentBankVC);
        }
        if (!"periodWay".equals(batchVCFilterVO.getPeriodWay()) && batchVCFilterVO.getEndDate() != null && dataVO.getCompanyId() != null) {
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(dataVO.getCompanyId().toString()));
            PeriodInfo periodInfo1 = PeriodUtils.getPeriodInfo((Date)batchVCFilterVO.getEndDate(), (CompanyOrgUnitInfo)companyInfo);
            if (periodInfo1 != null) {
                rstDataMap.put("bankVCPeriodInfo", periodInfo1);
            }
        }
        BankVcCheckWebHelper bankVCHelper = new BankVcCheckWebHelper(ctx, share);
        String SOLUTION_PARENTUINAME = share ? "bizCommonQuery.advancedQuery.com.kingdee.eas.fi.cas.FI_CAS_BankVCSchemeBatchSettingUI_share" : "bizCommonQuery.advancedQuery.com.kingdee.eas.fi.cas.FI_CAS_BankVCSchemeBatchSettingUI";
        ArrayList<BankVCBatchShowRowVO> batchVCAllRows = new ArrayList<BankVCBatchShowRowVO>();
        for (int idx = 0; idx < orgColl.size(); ++idx) {
            CompanyOrgUnitInfo companyInfo = orgColl.get(idx);
            try {
                String checkStr;
                HashMap rstMsgMap = new HashMap();
                if (hashMap.get("isIntelligentBankVC") == null) {
                    bankVCHelper.checkBankVCFuncPermission(rstMsgMap, companyInfo.getId().toString(), "cas_bankVcCheck_02contrast");
                }
                if ((checkStr = (String)rstMsgMap.get("MsgStr")) != null) {
                    List<BankVCBatchShowRowVO> vcOrgShowRows = bankVCHelper.batchVC_doGetBatchAutoCheckPageData(rstDataMap, companyInfo, SOLUTION_PARENTUINAME, false, false, false);
                    if (vcOrgShowRows != null && vcOrgShowRows.size() == 1) {
                        vcOrgShowRows.get(0).setStatusColumn(checkStr);
                    } else {
                        BankVCBatchShowRowVO orgMsgRowVO = new BankVCBatchShowRowVO();
                        orgMsgRowVO.setCompany(companyInfo);
                        orgMsgRowVO.setCompanyColumn(checkStr);
                        vcOrgShowRows.add(orgMsgRowVO);
                    }
                    batchVCAllRows.addAll(vcOrgShowRows);
                    continue;
                }
                PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
                if (curPeriod == null) {
                    String msgStr = CASWebUtil.getResource(ctx, "PleAddPeriodOfCurCompany");
                    List<BankVCBatchShowRowVO> vcOrgShowRows = bankVCHelper.batchVC_doGetBatchAutoCheckPageData(rstDataMap, companyInfo, SOLUTION_PARENTUINAME, false, false, false);
                    if (vcOrgShowRows != null && vcOrgShowRows.size() == 1) {
                        vcOrgShowRows.get(0).setStatusColumn(msgStr);
                    } else {
                        BankVCBatchShowRowVO orgMsgRowVO = new BankVCBatchShowRowVO();
                        orgMsgRowVO.setCompany(companyInfo);
                        orgMsgRowVO.setCompanyColumn(msgStr);
                        vcOrgShowRows.add(orgMsgRowVO);
                    }
                    batchVCAllRows.addAll(vcOrgShowRows);
                    continue;
                }
                PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
                int[] vcPeriodArray = bankVCHelper.batchVC_getVCPeriod_Array(batchVCFilterVO);
                boolean isBeforeStartPeriod = false;
                if (vcPeriodArray[0] < startPeriod.getPeriodYear() || vcPeriodArray[0] == startPeriod.getPeriodYear() && vcPeriodArray[1] < startPeriod.getPeriodNumber()) {
                    isBeforeStartPeriod = true;
                }
                if (isBeforeStartPeriod) {
                    String msgStr = CASWebUtil.getResource(ctx, "curVCPeriodBeforeStartPeriod");
                    List<BankVCBatchShowRowVO> vcOrgShowRows = bankVCHelper.batchVC_doGetBatchAutoCheckPageData(rstDataMap, companyInfo, SOLUTION_PARENTUINAME, false, false, false);
                    if (vcOrgShowRows != null && vcOrgShowRows.size() == 1) {
                        vcOrgShowRows.get(0).setStatusColumn(msgStr);
                    } else {
                        BankVCBatchShowRowVO orgMsgRowVO = new BankVCBatchShowRowVO();
                        orgMsgRowVO.setCompany(companyInfo);
                        orgMsgRowVO.setCompanyColumn(msgStr);
                        vcOrgShowRows.add(orgMsgRowVO);
                    }
                    batchVCAllRows.addAll(vcOrgShowRows);
                    continue;
                }
                List<BankVCBatchShowRowVO> batchVCSubRows = bankVCHelper.batchVC_doGetBatchAutoCheckPageData(rstDataMap, companyInfo, SOLUTION_PARENTUINAME, false, true, false);
                List<BankVCBatchRstVO> vcBatchRstVOs = bankVCHelper.batchVC_doBatchVC_Process(rstDataMap, batchVCSubRows, dataVO.getBatchVCFilter(), companyInfo);
                HashMap<String, String> vcRstMap = new HashMap<String, String>();
                for (BankVCBatchRstVO vcBatchVO : vcBatchRstVOs) {
                    if (vcBatchVO.getVcStatus() == null && vcBatchVO.getVcMsgStr() != null) {
                        vcRstMap.put(vcBatchVO.getKeyID(), vcBatchVO.getVcMsgStr());
                        continue;
                    }
                    vcRstMap.put(vcBatchVO.getKeyID(), vcBatchVO.getVcStatus());
                }
                Connection connection = null;
                PreparedStatement ps = null;
                try {
                    connection = this.getConnection(ctx);
                    String sql = "insert into t_cas_bankvchistory (FAccBankID,FAccBankName,FCurrencyID,FCurrencyName,FSchemeID,FCompanyID,FCompanyName,FStatus,FVCTime,FID)  values (?,?,?,?,?,?,?,?,?,?)";
                    ps = connection.prepareStatement(sql);
                    for (BankVCBatchShowRowVO subRow : batchVCSubRows) {
                        String keyStr = subRow.getDynamicRowIDKey();
                        SimpleDateFormat simpleDateTimeFormat = new SimpleDateFormat(" yyyy-MM-dd HH:mm:ss ");
                        String vcTime = simpleDateTimeFormat.format(Calendar.getInstance().getTime());
                        subRow.setvcTimeColumn(vcTime);
                        if (vcRstMap.get(keyStr) != null) {
                            subRow.setStatusColumn((String)vcRstMap.get(keyStr));
                        }
                        if (subRow.getAccBank() == null) continue;
                        String accbankid = subRow.getAccBank().getId().toString();
                        String delSql = "delete from t_cas_bankvchistory where faccbankid ='" + accbankid + "'";
                        DbUtil.execute((Context)ctx, (String)delSql);
                        ps.setString(1, accbankid);
                        ps.setString(2, subRow.getCompanyColumn());
                        ps.setString(3, subRow.getCurrency().getId().toString());
                        ps.setString(4, subRow.getCurrencyColumn());
                        ps.setString(5, subRow.getSchemeColumn());
                        ps.setString(6, subRow.getCompany().getId().toString());
                        ps.setString(7, subRow.getCompany().getName());
                        ps.setString(8, subRow.getStatusColumn());
                        ps.setTimestamp(9, new Timestamp(Calendar.getInstance().getTimeInMillis()));
                        ps.setString(10, subRow.getId());
                        ps.addBatch();
                    }
                    ps.executeBatch();
                }
                catch (SQLException e) {
                    try {
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(ps, (Connection)connection);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)ps, (Connection)connection);
                batchVCAllRows.addAll(batchVCSubRows);
                continue;
            }
            catch (Exception e) {
                rstDataMap.put("MsgStr", e.getMessage());
                rstDataMap.put("MsgDetail", e.toString());
                e.printStackTrace();
            }
        }
        rstDataMap.put("baVCOrgRowList", batchVCAllRows.toArray());
        return rstDataMap;
    }

    @Override
    protected Map _getBatchVCSettingInitData(Context ctx, String jsonstr) throws BOSException, EASBizException {
        HashMap<String, String> rstDataMap = new HashMap<String, String>();
        try {
            rstDataMap.put("curDateStr", BankVCUtil.dateFormat.format(new Date()));
            BatchVCSettingVO dataVO = (BatchVCSettingVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr, BatchVCSettingVO.class);
            if (dataVO == null || dataVO.getCompanyId() == null || dataVO.getCompanyId().length() <= 0) {
                rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "InputOrgUnitIsNull"));
                return rstDataMap;
            }
            CompanyOrgUnitInfo orgInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(dataVO.getCompanyId()));
            if (orgInfo == null || orgInfo.getId() == null) {
                rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "InputOrgUnitIsNull"));
                return rstDataMap;
            }
            BankVcCheckWebHelper bankVCHelper = new BankVcCheckWebHelper(ctx);
            bankVCHelper.vcSetting_getBatchVCSettingData(rstDataMap, dataVO);
        }
        catch (EASBizException e1) {
            rstDataMap.put("MsgStr", e1.getMessage());
            rstDataMap.put("MsgDetail", e1.toString());
            e1.printStackTrace();
        }
        catch (BOSException e2) {
            rstDataMap.put("MsgStr", e2.getMessage());
            rstDataMap.put("MsgDetail", e2.toString());
            e2.printStackTrace();
        }
        return rstDataMap;
    }

    @Override
    protected Map _getBatchVCSettingByCompanyID(Context ctx, String jsonstr) throws BOSException, EASBizException {
        HashMap<String, String> rstDataMap = new HashMap<String, String>();
        if (jsonstr == null || jsonstr.length() == 0 || !BOSUuid.isValid((String)jsonstr, (boolean)true)) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "InputOrgUnitIsNull"));
            return rstDataMap;
        }
        String curVCSettingName = null;
        BankVcCheckWebHelper bankVCHelper = new BankVcCheckWebHelper(ctx);
        BatchVCSettingVO queryVO = new BatchVCSettingVO(jsonstr);
        List<BankVCUserOptionVO> rstUserOptions = bankVCHelper.vcSetting_getBatchVCSettingData(rstDataMap, queryVO);
        if (rstUserOptions != null && rstUserOptions.size() > 0) {
            for (int idx = 0; idx < rstUserOptions.size(); ++idx) {
                BankVCUserOptionVO userOpt = rstUserOptions.get(idx);
                if (userOpt == null || userOpt.getSchemeName() == null || !userOpt.getDefaultScheme().booleanValue()) continue;
                curVCSettingName = userOpt.getSchemeName();
            }
        }
        if (curVCSettingName != null) {
            rstDataMap.put("curVCSettingName", curVCSettingName);
        }
        return rstDataMap;
    }

    @Override
    protected Map _saveBatchVCSettingData(Context ctx, String jsonstr) throws BOSException, EASBizException {
        HashMap<String, String> rstDataMap = new HashMap<String, String>();
        rstDataMap.put("curDateStr", BankVCUtil.dateFormat.format(new Date()));
        BankVCUserOptionVO dataVO = (BankVCUserOptionVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr, BankVCUserOptionVO.class);
        if (dataVO == null || dataVO.getCompanyID() == null || dataVO.getCompanyID().length() <= 0) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "InputOrgUnitIsNull"));
            return rstDataMap;
        }
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(dataVO.getCompanyID()));
        if (companyInfo == null || companyInfo.getId() == null) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "InputOrgUnitIsNull"));
            return rstDataMap;
        }
        if (dataVO == null || dataVO.getSchemeName() == null || dataVO.getSchemeName().length() <= 0) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "InputSchemeNameIsNull"));
            return rstDataMap;
        }
        IUserOption iUserOption = UserOptionFactory.getLocalInstance((Context)ctx);
        UserOptionInfo userOptionInfo = null;
        userOptionInfo = StringUtil.isEmptyString((String)dataVO.getSchemeID()) ? new UserOptionInfo() : iUserOption.getUserOptionInfo((IObjectPK)new ObjectUuidPK(dataVO.getSchemeID()));
        userOptionInfo.setCompany(companyInfo);
        userOptionInfo.setCreateDate(new Date());
        userOptionInfo.setCreateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        userOptionInfo.setOptKey("com.kingdee.eas.dynamic.web.BankVCSchemeSettingUI");
        if (userOptionInfo.getName() != null && userOptionInfo.getName().startsWith("Hello")) {
            userOptionInfo.setName("Hello" + dataVO.getSchemeName());
        } else {
            userOptionInfo.setName(dataVO.getSchemeName());
        }
        userOptionInfo.setOptValue(dataVO.toOptValString());
        iUserOption.submit((CoreBaseInfo)userOptionInfo);
        BatchVCSettingVO queryVO = new BatchVCSettingVO(dataVO.getCompanyID());
        BankVcCheckWebHelper bankVCHelper = new BankVcCheckWebHelper(ctx);
        bankVCHelper.vcSetting_getBatchVCSettingData(rstDataMap, queryVO);
        rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "AutoVCConfigOK"));
        return rstDataMap;
    }

    @Override
    protected Map _setBatchVCSettingDefault(Context ctx, String jsonstr) throws BOSException, EASBizException {
        HashMap<String, String> rstDataMap = new HashMap<String, String>();
        rstDataMap.put("curDateStr", BankVCUtil.dateFormat.format(new Date()));
        BatchVCSettingVO dataVO = (BatchVCSettingVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr, BatchVCSettingVO.class);
        if (dataVO == null || dataVO.getCompanyId() == null || dataVO.getCompanyId().length() <= 0) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "InputOrgUnitIsNull"));
            return rstDataMap;
        }
        if (dataVO == null || dataVO.getSchemeID() == null || dataVO.getSchemeID().length() <= 0) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "PelSelectedOneSchemeData"));
            return rstDataMap;
        }
        CompanyOrgUnitInfo orgInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(dataVO.getCompanyId()));
        if (orgInfo == null || orgInfo.getId() == null) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "InputOrgUnitIsNull"));
            return rstDataMap;
        }
        IUserOption iUserOption = UserOptionFactory.getLocalInstance((Context)ctx);
        StringBuffer queryfilter = new StringBuffer();
        queryfilter.append("select * where optKey='").append("com.kingdee.eas.dynamic.web.BankVCSchemeSettingUI").append("' ");
        queryfilter.append("and company.id='").append(orgInfo.getId().toString()).append("' ");
        queryfilter.append("and createUser.id='").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()).append("' ");
        queryfilter.append("and name like '").append("Hello").append("%' ");
        UserOptionCollection userOptionColl = iUserOption.getUserOptionCollection(queryfilter.toString());
        boolean isNeedUpdate = true;
        String tmpScehemeID = null;
        String tmpScehemeName = null;
        for (int idx = 0; idx < userOptionColl.size(); ++idx) {
            UserOptionInfo userOptionInfo = userOptionColl.get(idx);
            tmpScehemeID = userOptionInfo.getId().toString();
            if (StringUtil.isEmptyString((String)tmpScehemeID)) continue;
            if (tmpScehemeID.equals(dataVO.getSchemeID())) {
                isNeedUpdate = false;
                continue;
            }
            tmpScehemeName = userOptionInfo.getName();
            tmpScehemeName = tmpScehemeName.substring("Hello".length());
            userOptionInfo.setName(tmpScehemeName);
            iUserOption.submit((CoreBaseInfo)userOptionInfo);
        }
        if (isNeedUpdate) {
            UserOptionInfo optInfo = iUserOption.getUserOptionInfo((IObjectPK)new ObjectUuidPK(dataVO.getSchemeID()));
            String newSchemeName = "Hello" + optInfo.getName();
            optInfo.setName(newSchemeName);
            iUserOption.submit((CoreBaseInfo)optInfo);
        }
        rstDataMap.put("OPStatus", "success");
        return rstDataMap;
    }

    @Override
    protected Map _deleteBatchVCSettingData(Context ctx, String jsonstr) throws BOSException, EASBizException {
        ObjectUuidPK optPK;
        HashMap<String, String> rstDataMap = new HashMap<String, String>();
        rstDataMap.put("curDateStr", BankVCUtil.dateFormat.format(new Date()));
        BatchVCSettingVO dataVO = (BatchVCSettingVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr, BatchVCSettingVO.class);
        if (dataVO == null || dataVO.getCompanyId() == null || dataVO.getCompanyId().length() <= 0) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "InputOrgUnitIsNull"));
            return rstDataMap;
        }
        if (dataVO == null || dataVO.getSchemeID() == null || dataVO.getSchemeID().length() <= 0) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "PelSelectedOneSchemeData"));
            return rstDataMap;
        }
        CompanyOrgUnitInfo orgInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(dataVO.getCompanyId()));
        if (orgInfo == null || orgInfo.getId() == null) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "InputOrgUnitIsNull"));
            return rstDataMap;
        }
        IUserOption iUserOption = UserOptionFactory.getLocalInstance((Context)ctx);
        if (iUserOption.exists((IObjectPK)(optPK = new ObjectUuidPK(dataVO.getSchemeID())))) {
            iUserOption.delete((IObjectPK)optPK);
        }
        BankVcCheckWebHelper bankVCHelper = new BankVcCheckWebHelper(ctx);
        bankVCHelper.vcSetting_getBatchVCSettingData(rstDataMap, dataVO);
        rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "DeletedOK"));
        return rstDataMap;
    }

    @Override
    protected List _getSolutionList(Context ctx, String companyId, String parentuiname) throws BOSException, EASBizException {
        BatchVCSettingVO queryVO = new BatchVCSettingVO(companyId);
        BankVcCheckWebHelper bankVCHelper = new BankVcCheckWebHelper(ctx);
        UserOptionCollection userOptColl = bankVCHelper.vcSetting_getUserOptionCollection(queryVO);
        ArrayList<UserOptionInfo> resultDataList = new ArrayList<UserOptionInfo>();
        BankVCUserOptionVO bankVCOptVO = null;
        for (int idx = 0; idx < userOptColl.size(); ++idx) {
            UserOptionInfo userOptInfo = userOptColl.get(idx);
            bankVCOptVO = BankVCUserOptionVO.InfoToVO(userOptInfo);
            if (bankVCOptVO.getDefaultScheme().booleanValue()) {
                userOptInfo.setName(bankVCOptVO.getSchemeName());
                resultDataList.add(0, userOptInfo);
                continue;
            }
            resultDataList.add(userOptInfo);
        }
        return resultDataList;
    }

    @Override
    protected Map _getSolution(Context ctx, String solutionId) throws BOSException, EASBizException {
        HashMap<String, Object> rstDataMap = new HashMap<String, Object>();
        System.out.println("solutionId = " + solutionId);
        if (!BOSUuid.isValid((String)solutionId, (boolean)true)) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "InputDataExption"));
            return rstDataMap;
        }
        IUserOption iUserOption = UserOptionFactory.getLocalInstance((Context)ctx);
        UserOptionInfo userOptInfo = iUserOption.getUserOptionInfo((IObjectPK)new ObjectUuidPK(solutionId));
        rstDataMap.put("userOptInfo", userOptInfo);
        if (userOptInfo != null) {
            BankVCUserOptionVO userOptVO = BankVCUserOptionVO.InfoToVO(userOptInfo);
            rstDataMap.put("searchFilter", userOptVO);
            rstDataMap.put("defaultView", userOptVO.getDefaultScheme());
            rstDataMap.put("solutionName", userOptVO.getSchemeName());
        }
        return rstDataMap;
    }

    @Override
    protected Map _saveSolution(Context ctx, String companyId, String solutionname, boolean isdefault, String parentuiname, String filer) throws BOSException, EASBizException {
        HashMap<String, IObjectPK> rstDataMap = new HashMap<String, IObjectPK>();
        if (companyId == null || !BOSUuid.isValid((String)companyId, (boolean)true)) {
            throw new EASBizException(new NumericExceptionSubItem("20140120YY", CASWebUtil.getResource(ctx, "InputOrgUnitIsNull")));
        }
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        if (companyInfo == null) {
            throw new EASBizException(new NumericExceptionSubItem("20140120YY", CASWebUtil.getResource(ctx, "InputOrgUnitIsNull")));
        }
        IUserOption iUserOption = UserOptionFactory.getLocalInstance((Context)ctx);
        StringBuffer oql = new StringBuffer();
        oql.append("select * where optKey='").append("com.kingdee.eas.dynamic.web.BankVCSchemeSettingUI").append("' ");
        oql.append("and company.id='").append(companyId).append("' ");
        oql.append("and createUser.id='").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()).append("' ");
        UserOptionCollection userOptAllColl = iUserOption.getUserOptionCollection(oql.toString());
        UserOptionInfo insertUserOptInfo = null;
        ArrayList<UserOptionInfo> needUpdateUserOpts = new ArrayList<UserOptionInfo>();
        String tmpNameStr = null;
        UserOptionInfo tmpUserOptInfo = null;
        for (int idx = 0; idx < userOptAllColl.size(); ++idx) {
            tmpUserOptInfo = userOptAllColl.get(idx);
            if (tmpUserOptInfo == null || tmpUserOptInfo.getName() == null) continue;
            tmpNameStr = tmpUserOptInfo.getName();
            if (insertUserOptInfo == null && (tmpNameStr.equals("Hello" + solutionname) || tmpNameStr.equals(solutionname))) {
                insertUserOptInfo = tmpUserOptInfo;
                continue;
            }
            if (!isdefault || !tmpNameStr.startsWith("Hello")) continue;
            tmpNameStr = tmpNameStr.substring("Hello".length());
            tmpUserOptInfo.setName(tmpNameStr);
            needUpdateUserOpts.add(tmpUserOptInfo);
        }
        if (insertUserOptInfo == null) {
            insertUserOptInfo = new UserOptionInfo();
        }
        insertUserOptInfo.setCompany(companyInfo);
        insertUserOptInfo.setCreateDate(new Date());
        insertUserOptInfo.setCreateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        insertUserOptInfo.setOptKey("com.kingdee.eas.dynamic.web.BankVCSchemeSettingUI");
        if (isdefault) {
            insertUserOptInfo.setName("Hello" + solutionname);
        } else {
            insertUserOptInfo.setName(solutionname);
        }
        BankVCUserOptionVO dataVO = (BankVCUserOptionVO)JSONUtils.convertJsonToObject((Context)ctx, (String)filer, BankVCUserOptionVO.class);
        dataVO.setCompanyID(companyId);
        insertUserOptInfo.setOptValue(dataVO.toOptValString());
        IObjectPK userOptId = iUserOption.submit((CoreBaseInfo)insertUserOptInfo);
        if (needUpdateUserOpts.size() > 0) {
            for (UserOptionInfo subUserOptInfo : needUpdateUserOpts) {
                iUserOption.submit((CoreBaseInfo)subUserOptInfo);
            }
        }
        rstDataMap.put("viewId", userOptId);
        return rstDataMap;
    }

    @Override
    protected Map _copySolution(Context ctx, String companyId, String solutionname, boolean isdefault, String parentuiname, String orgs, String filer) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _removeSolution(Context ctx, String companyId, String parentuiname, String solutionId) throws BOSException, EASBizException {
        if (companyId == null || !BOSUuid.isValid((String)companyId, (boolean)true)) {
            throw new EASBizException(new NumericExceptionSubItem("20140120YY", CASWebUtil.getResource(ctx, "InputOrgUnitIsNull")));
        }
        if (solutionId == null || !BOSUuid.isValid((String)solutionId, (boolean)true)) {
            throw new EASBizException(new NumericExceptionSubItem("20140120YY", CASWebUtil.getResource(ctx, "InputDataExption")));
        }
        IUserOption iUserOption = UserOptionFactory.getLocalInstance((Context)ctx);
        iUserOption.delete((IObjectPK)new ObjectUuidPK(solutionId));
    }

    @Override
    protected Map _getBalanceAdjustPageInitData(Context ctx) throws BOSException, EASBizException {
        HashMap<String, Object> rstDataMap = new HashMap<String, Object>();
        BankVcCheckWebHelper bankVCHelper = new BankVcCheckWebHelper(ctx);
        CompanyOrgUnitInfo defaultFIUnit = ContextUtil.getCurrentFIUnit((Context)ctx);
        rstDataMap.put("curCompanyForUnShare", defaultFIUnit);
        CompanyOrgUnitInfo selCompany = bankVCHelper.doArrangeDefaultFIUnit_Currency_Permission(rstDataMap, defaultFIUnit, "cas_bankbalanceagjtable_01view");
        if (selCompany == null || selCompany.getId() == null) {
            throw new CasWebException(CasWebException.NO_ORG_AUTHRIZED);
        }
        String orgFilter = null;
        try {
            orgFilter = CASWebHelper.getAuthorizedOrgFilter_F7Special(ctx, "cas_bankbalanceagjtable_01view", false, "unit.id", "tree.id");
        }
        catch (EASBizException e1) {
            rstDataMap.put("MsgStr", e1.getMessage());
            rstDataMap.put("MsgDetail", e1.toString());
            e1.printStackTrace();
        }
        catch (BOSException e2) {
            rstDataMap.put("MsgStr", e2.getMessage());
            rstDataMap.put("MsgDetail", e2.toString());
            e2.printStackTrace();
        }
        if (orgFilter == null) {
            orgFilter = "unit.id = ''";
        }
        rstDataMap.put("OrgF7Filter", orgFilter);
        bankVCHelper.doArrangeCurrency_PeriodOfCompany(rstDataMap, selCompany, null);
        return rstDataMap;
    }

    @Override
    protected Map _getBalanceAdjustFilterDataBySolution(Context ctx, String jsonstr) throws BOSException, EASBizException {
        HashMap<String, String> rstDataMap = new HashMap<String, String>();
        if (jsonstr == null || jsonstr.length() <= 0) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "InputDataExption"));
            return rstDataMap;
        }
        BankVCAdjustmentFilterVO filterVO = (BankVCAdjustmentFilterVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr, BankVCAdjustmentFilterVO.class);
        if (filterVO == null) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "InputDataExption"));
            return rstDataMap;
        }
        try {
            BankVcCheckWebHelper bankVCHelper = new BankVcCheckWebHelper(ctx);
            bankVCHelper.balanceAdj_doArrangeFilterVO_ToCompleted(rstDataMap, filterVO);
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
            rstDataMap.put("MsgStr", e1.getMessage());
            rstDataMap.put("MsgDetail", e1.toString());
        }
        catch (BOSException e2) {
            e2.printStackTrace();
            rstDataMap.put("MsgStr", e2.getMessage());
            rstDataMap.put("MsgDetail", e2.toString());
        }
        return rstDataMap;
    }

    @Override
    protected Map _getBalanceAdjustDataByFilter(Context ctx, String jsonstr) throws BOSException, EASBizException {
        HashMap<String, Object> rstDataMap = new HashMap<String, Object>();
        if (jsonstr == null || jsonstr.length() <= 0) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "InputDataExption"));
            return rstDataMap;
        }
        BankVCAdjustmentFilterVO filterVO = (BankVCAdjustmentFilterVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr, BankVCAdjustmentFilterVO.class);
        if (filterVO == null || filterVO.getCompanyID() == null || !BOSUuid.isValid((String)filterVO.getCompanyID(), (boolean)true)) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "72_InputOrgUnitIsNull"));
            return rstDataMap;
        }
        if (filterVO == null || filterVO.getPeriodID() == null || !BOSUuid.isValid((String)filterVO.getPeriodID(), (boolean)true)) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "InputPeriodIsNull"));
            return rstDataMap;
        }
        if (filterVO == null || filterVO.getAcctBankID() == null || !BOSUuid.isValid((String)filterVO.getAcctBankID(), (boolean)true)) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "297_InputAcctBankIsNull"));
            return rstDataMap;
        }
        if (filterVO == null || filterVO.getCurrencyID() == null || !BOSUuid.isValid((String)filterVO.getCurrencyID(), (boolean)true)) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "298_InputCurrencyIsNull"));
            return rstDataMap;
        }
        try {
            BankVcCheckWebHelper bankVCHelper = new BankVcCheckWebHelper(ctx);
            bankVCHelper.balanceAdj_doArrangeFilterVO_ToCompleted(rstDataMap, filterVO);
            IBankBalanceAdjustment iAdjustment = BankBalanceAdjustmentFactory.getLocalInstance(ctx);
            BankStmtBookReportInfo rptInfo = iAdjustment.getBalanceReport(bankVCHelper.balanceAdj_doArrangeCondition(filterVO));
            rstDataMap.put("rptInfo", rptInfo);
            BigDecimal oJournalEndAmount = rptInfo.getBankBookAmt() == null ? Constants.ZERO : rptInfo.getBankBookAmt();
            BigDecimal oStatmntEndAmount = rptInfo.getBankStmtAmt() == null ? Constants.ZERO : rptInfo.getBankStmtAmt();
            BigDecimal oBankGotAmount = rptInfo.getBankGotAmt() == null ? Constants.ZERO : rptInfo.getBankGotAmt();
            BigDecimal oBankPayedAmount = rptInfo.getBankPayedAmt() == null ? Constants.ZERO : rptInfo.getBankPayedAmt();
            BigDecimal oEntprGotAmount = rptInfo.getEntprGotAmt() == null ? Constants.ZERO : rptInfo.getEntprGotAmt();
            BigDecimal oEntprPayedAmount = rptInfo.getEntprPayedAmt() == null ? Constants.ZERO : rptInfo.getEntprPayedAmt();
            BigDecimal oAdjustedJournalAmount = oJournalEndAmount.add(oBankGotAmount).subtract(oBankPayedAmount);
            rstDataMap.put("entBalance", oAdjustedJournalAmount);
            BigDecimal oAdjustedStatmntAmount = oStatmntEndAmount.add(oEntprGotAmount).subtract(oEntprPayedAmount);
            rstDataMap.put("bankBalance", oAdjustedStatmntAmount);
            IContextHelper contextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
            int cs018 = contextHelper.getIntParam("CS018", (IObjectPK)new ObjectUuidPK(filterVO.getCompanyID()));
            rstDataMap.put("CS018", cs018);
            rstDataMap.put("entprUnreachedColl", rptInfo.getEntprs());
            rstDataMap.put("bankUnreachedColl", rptInfo.getBanks());
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
            rstDataMap.put("MsgStr", e1.getMessage());
            rstDataMap.put("MsgDetail", e1.toString());
        }
        catch (BOSException e2) {
            e2.printStackTrace();
            rstDataMap.put("MsgStr", e2.getMessage());
            rstDataMap.put("MsgDetail", e2.toString());
        }
        return rstDataMap;
    }

    @Override
    public Map _getOutStandingPageInitData(Context ctx) throws BOSException, EASBizException {
        HashMap<String, Object> rstDataMap = new HashMap<String, Object>();
        BankVcCheckWebHelper bankVCHelper = new BankVcCheckWebHelper(ctx);
        CompanyOrgUnitInfo defaultFIUnit = ContextUtil.getCurrentFIUnit((Context)ctx);
        rstDataMap.put("curCompanyForUnShare", defaultFIUnit);
        CompanyOrgUnitInfo selCompany = bankVCHelper.doArrangeDefaultFIUnit_Currency_Permission(rstDataMap, defaultFIUnit, "cas_outstanding_01view");
        if (selCompany == null || selCompany.getId() == null) {
            throw new CasWebException(CasWebException.NO_ORG_AUTHRIZED);
        }
        String orgFilter = null;
        try {
            orgFilter = CASWebHelper.getAuthorizedOrgFilter_F7Special(ctx, "cas_bankbalanceagjtable_01view", false, "unit.id", "tree.id");
        }
        catch (EASBizException e1) {
            rstDataMap.put("MsgStr", e1.getMessage());
            rstDataMap.put("MsgDetail", e1.toString());
            e1.printStackTrace();
        }
        catch (BOSException e2) {
            rstDataMap.put("MsgStr", e2.getMessage());
            rstDataMap.put("MsgDetail", e2.toString());
            e2.printStackTrace();
        }
        if (orgFilter == null) {
            orgFilter = "id = ''";
        }
        rstDataMap.put("OrgF7Filter", orgFilter);
        bankVCHelper.doArrangeCurrency_PeriodOfCompany(rstDataMap, selCompany, null);
        return rstDataMap;
    }

    @Override
    protected Map _getOutStandingFilterDataBySolution(Context ctx, String jsonstr) throws BOSException, EASBizException {
        HashMap<String, String> rstDataMap = new HashMap<String, String>();
        if (jsonstr == null || jsonstr.length() <= 0) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "InputDataExption"));
            return rstDataMap;
        }
        BankVCOutStandingFilterVO filterVO = (BankVCOutStandingFilterVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr, BankVCOutStandingFilterVO.class);
        if (filterVO == null) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "InputDataExption"));
            return rstDataMap;
        }
        try {
            BankVcCheckWebHelper bankVCHelper = new BankVcCheckWebHelper(ctx);
            bankVCHelper.outStanding_doArrangeFilterVO_ToCompleted(rstDataMap, filterVO);
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
            rstDataMap.put("MsgStr", e1.getMessage());
            rstDataMap.put("MsgDetail", e1.toString());
        }
        catch (BOSException e2) {
            e2.printStackTrace();
            rstDataMap.put("MsgStr", e2.getMessage());
            rstDataMap.put("MsgDetail", e2.toString());
        }
        return rstDataMap;
    }

    @Override
    protected Map _getOutStandingDataByFilter(Context ctx, String jsonstr) throws BOSException, EASBizException {
        HashMap<String, String> rstDataMap = new HashMap<String, String>();
        if (jsonstr == null || jsonstr.length() <= 0) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "InputDataExption"));
            return rstDataMap;
        }
        BankVCOutStandingFilterVO filterVO = (BankVCOutStandingFilterVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr, BankVCOutStandingFilterVO.class);
        if (filterVO == null || filterVO.getCompanyID() == null || !BOSUuid.isValid((String)filterVO.getCompanyID(), (boolean)true)) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "72_InputOrgUnitIsNull"));
            return rstDataMap;
        }
        if (filterVO == null || filterVO.getPeriodID() == null || !BOSUuid.isValid((String)filterVO.getPeriodID(), (boolean)true)) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "InputPeriodIsNull"));
            return rstDataMap;
        }
        if (filterVO == null || filterVO.getAcctBankID() == null || !BOSUuid.isValid((String)filterVO.getAcctBankID(), (boolean)true)) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "297_InputAcctBankIsNull"));
            return rstDataMap;
        }
        if (filterVO == null || filterVO.getCurrencyID() == null || !BOSUuid.isValid((String)filterVO.getCurrencyID(), (boolean)true)) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "298_InputCurrencyIsNull"));
            return rstDataMap;
        }
        try {
            BankVcCheckWebHelper bankVCHelper = new BankVcCheckWebHelper(ctx);
            bankVCHelper.outStanding_doArrangeFilterVO_ToCompleted(rstDataMap, filterVO);
            bankVCHelper.outStanding_doGetRstData(rstDataMap, filterVO);
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
            rstDataMap.put("MsgStr", e1.getMessage());
            rstDataMap.put("MsgDetail", e1.toString());
        }
        catch (BOSException e2) {
            e2.printStackTrace();
            rstDataMap.put("MsgStr", e2.getMessage());
            rstDataMap.put("MsgDetail", e2.toString());
        }
        return rstDataMap;
    }

    @Override
    protected Map _balanceAdjustView(Context ctx, String companyId) throws BOSException, EASBizException {
        HashMap<String, String> rstData = new HashMap<String, String>();
        try {
            CompanyOrgUnitInfo defFIUnit = ContextUtil.getCurrentFIUnit((Context)ctx);
            boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), "cas_bankbalanceagjtable_01view");
            if (!isPermission) {
                throw new CasWebException(CasWebException.NO_CAS_BANKBALANCEAGJTABLE_01VIEW_AUTHRIZED);
            }
        }
        catch (EASBizException e1) {
            rstData.put("MsgStr", e1.getMessage(ctx.getLocale()));
            e1.printStackTrace();
            logger.debug((Object)e1);
            return rstData;
        }
        catch (BOSException e2) {
            rstData.put("MsgStr", e2.getMessage());
            e2.printStackTrace();
            logger.debug((Object)e2);
            return rstData;
        }
        return rstData;
    }

    @Override
    protected Map _getSumInfo(Context ctx, String filter, String filter1) throws BOSException, EASBizException {
        HashMap<String, IRowSet> rstData = new HashMap<String, IRowSet>();
        try {
            IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.cas.VcBankStatementQuery"));
            queryExecutor.setObjectView("SELECT company.name,createDate,description,settleType.name,settleNumber,debitAmount,creditAmount,oppUnit  where " + filter);
            IRowSet rowSet = queryExecutor.executeQuery();
            rstData.put("rowSet", rowSet);
            IQueryExecutor queryVcJournal = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.cas.VcJournalQuery"));
            queryVcJournal.setObjectView("SELECT company.name,bizDate,description,voucherNumber,billNumber,settlementNumber,debitAmount,creditAmount,billType,voucherType.name,settlementType.name,oppUnit where " + filter1 + "ORDER BY bizDate");
            IRowSet rowSetVcJournal = queryVcJournal.executeQuery();
            rstData.put("rowSetVcJournal", rowSetVcJournal);
        }
        catch (BOSException e2) {
            e2.printStackTrace();
        }
        return rstData;
    }

    @Override
    protected boolean _queryPermissions(Context ctx, boolean share) throws BOSException, EASBizException {
        CompanyOrgUnitInfo defaultFIUnit = ContextUtil.getCurrentFIUnit((Context)ctx);
        Object selCompany = null;
        BankVcCheckWebHelper bankVCHelper = new BankVcCheckWebHelper(ctx);
        boolean purview = bankVCHelper.queryPermissions_Currency_BeShare(defaultFIUnit, share);
        return purview;
    }

    @Override
    protected void _runIntelligentBankVC(Context ctx) throws BOSException, EASBizException {
        String jsonstr = "";
        CompanyOrgUnitCollection companyOrgUnitCollection = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection();
        for (int i = 0; i < companyOrgUnitCollection.size(); ++i) {
            PeriodInfo prePeriodInfo;
            PeriodInfo period;
            CompanyOrgUnitInfo companyOrgUnitInfo;
            block3: {
                companyOrgUnitInfo = companyOrgUnitCollection.get(i);
                period = null;
                prePeriodInfo = null;
                try {
                    period = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
                    prePeriodInfo = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)period);
                    if (EmptyUtil.isEmpty((CoreBaseInfo)prePeriodInfo) || !prePeriodInfo.isIsAdjustPeriod()) break block3;
                    prePeriodInfo = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)prePeriodInfo);
                }
                catch (Exception e) {
                    continue;
                }
            }
            if (null == period || null == period.getBeginDate()) continue;
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            HashMap<String, String> filterMap = new HashMap<String, String>();
            String beginDate = "";
            beginDate = !EmptyUtil.isEmpty((CoreBaseInfo)prePeriodInfo) && !EmptyUtil.isEmpty((Object)prePeriodInfo.getBeginDate()) ? prePeriodInfo.getBeginDate().toString() + " 00:00:00" : period.getBeginDate().toString() + " 00:00:00";
            String endDate = period.getEndDate().toString();
            endDate = endDate.substring(0, 10);
            filterMap.put("startDate", beginDate);
            filterMap.put("endDate", endDate + " 23:59:59");
            filterMap.put("periodId", period.getId().toString());
            filterMap.put("periodWay", "periodWay");
            jsonMap.put("companyId", companyOrgUnitInfo.getId().toString());
            jsonMap.put("batchVCIds", new String[]{companyOrgUnitInfo.getId().toString()});
            jsonMap.put("batchVCFilter", filterMap);
            jsonMap.put("share", true);
            jsonMap.put("isIntelligentBankVC", true);
            jsonstr = JSONUtils.convertObjectToJson((Context)ctx, jsonMap);
            this._doBatchVCProcess(ctx, jsonstr);
        }
        System.out.println("\u5bf9\u8d26\u6267\u884c\u5b8c\u6bd5\uff01");
    }

    @Override
    protected Map _getListSumInfo(Context ctx, String modelIds, String isBankState) throws BOSException, EASBizException {
        String sql = "";
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        sql = "true".equals(isBankState) ? "SELECT sum(FDEBITAMOUNT),sum(FCREDITAMOUNT) FROM T_CAS_BANKSTATEMENT where fid in (" + modelIds + ")" : "SELECT sum(FDEBITAMOUNT),sum(FCREDITAMOUNT) FROM T_CAS_Journal where fid in (" + modelIds + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                result.put("debitAmountSum", rs.getBigDecimal("sum(FDEBITAMOUNT)"));
                result.put("creditAmountSum", rs.getBigDecimal("sum(FCREDITAMOUNT)"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }
}

