/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.StringUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.vc.BankVcProcessFacadeFactory;
import com.kingdee.eas.base.vc.IBankVcProcessFacade;
import com.kingdee.eas.base.vc.IVcProcess;
import com.kingdee.eas.base.vc.IVcResult;
import com.kingdee.eas.base.vc.VcMatchConditionCollection;
import com.kingdee.eas.base.vc.VcMatchConditionInfo;
import com.kingdee.eas.base.vc.VcProcessFactory;
import com.kingdee.eas.base.vc.VcResultCollection;
import com.kingdee.eas.base.vc.VcResultFactory;
import com.kingdee.eas.base.vc.VcResultInfo;
import com.kingdee.eas.base.vc.VcSchemeInfo;
import com.kingdee.eas.base.vc.VcVerifyInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeCollection;
import com.kingdee.eas.basedata.assistant.PeriodTypeFactory;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.assistant.SharedAcctCollection;
import com.kingdee.eas.basedata.assistant.SharedAcctFactory;
import com.kingdee.eas.basedata.assistant.SharedAcctInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BankBalanceCondition;
import com.kingdee.eas.fi.cas.BankStatementCollection;
import com.kingdee.eas.fi.cas.BankStatementFactory;
import com.kingdee.eas.fi.cas.BankStatementInfo;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.CasWebParamFacadeFactory;
import com.kingdee.eas.fi.cas.CasWebQrySolFacadeFactory;
import com.kingdee.eas.fi.cas.IBankStatement;
import com.kingdee.eas.fi.cas.ICasWebParamFacade;
import com.kingdee.eas.fi.cas.ICasWebQrySolFacade;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.utils.BankJournalWebUtil;
import com.kingdee.eas.fi.cas.utils.BankVCUtil;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.vo.BankVCAdjustmentFilterVO;
import com.kingdee.eas.fi.cas.vo.BankVCBatchRstVO;
import com.kingdee.eas.fi.cas.vo.BankVCBatchShowRowVO;
import com.kingdee.eas.fi.cas.vo.BankVCCancelVO;
import com.kingdee.eas.fi.cas.vo.BankVCDataVO;
import com.kingdee.eas.fi.cas.vo.BankVCFilterVO;
import com.kingdee.eas.fi.cas.vo.BankVCHistoryGroupVO;
import com.kingdee.eas.fi.cas.vo.BankVCHistoryVO;
import com.kingdee.eas.fi.cas.vo.BankVCOutStandingFilterVO;
import com.kingdee.eas.fi.cas.vo.BankVCRstSubmitVO;
import com.kingdee.eas.fi.cas.vo.BankVCUserOptionVO;
import com.kingdee.eas.fi.cas.vo.BatchVCSettingVO;
import com.kingdee.eas.fi.cas.vo.BatchVcSubFilterVO;
import com.kingdee.eas.fi.cas.vo.EnumItemVO;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IUserOption;
import com.kingdee.eas.fm.common.UserOptionCollection;
import com.kingdee.eas.fm.common.UserOptionFactory;
import com.kingdee.eas.fm.common.UserOptionInfo;
import com.kingdee.eas.fm.common.UserOptionUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class BankVcCheckWebHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.BankVcCheckWebHelper");
    private Context ctx = null;
    private IContextHelper contextHelper = null;
    private boolean isShare = false;
    private boolean isIntelligentBankVC = false;
    public static final Map<String, Map<String, VcResultCollection>> autoBankVCResultCache = new ConcurrentHashMap<String, Map<String, VcResultCollection>>();
    public static final Map<String, VcSchemeInfo> autoBankVCSchemeCache = new ConcurrentHashMap<String, VcSchemeInfo>();
    private static final String JoinStr = "_#_";
    private static final String BankVcScheme = "com.kingdee.eas.base.vc.VcSchemeInfo";

    public BankVcCheckWebHelper(Context ctx) {
        this.ctx = ctx;
        if (this.ctx != null) {
            this.contextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        }
    }

    public BankVcCheckWebHelper(Context ctx, boolean isShare) {
        this.ctx = ctx;
        this.isShare = isShare;
        if (this.ctx != null) {
            this.contextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        }
    }

    protected CompanyOrgUnitInfo doArrangeDefaultFIUnit_Currency_Permission(Map rstDataMap, CompanyOrgUnitInfo curCompany, String permission) throws BOSException, EASBizException {
        if (curCompany == null) {
            curCompany = this.contextHelper.getCurrentCompany();
        }
        CompanyOrgUnitInfo selCompany = curCompany;
        AccountBankCollection acctBankColl = null;
        UserInfo curUser = this.contextHelper.getCurrentUser();
        if (curCompany.isIsBizUnit()) {
            IPermission iPermisson = PermissionFactory.getLocalInstance((Context)this.ctx);
            boolean flag = true;
            if (rstDataMap.get("isIntelligentBankVC") == null) {
                flag = iPermisson.hasFunctionPermission((IObjectPK)new ObjectUuidPK(curUser.getId().toString()), (IObjectPK)new ObjectUuidPK(curCompany.getId().toString()), permission);
            }
            selCompany = flag ? curCompany : this.getCompanyOrgUnitInfoByUserPermisson(permission);
        } else {
            selCompany = this.getCompanyOrgUnitInfoByUserPermisson(permission);
        }
        if (selCompany != null && selCompany.isIsBizUnit()) {
            String strCompanyId = selCompany.getId().toString();
            acctBankColl = CASWebHelper.getAccountBankCollection(this.ctx, strCompanyId, true);
        }
        rstDataMap.put("defaultFIUnit", selCompany);
        rstDataMap.put("acctBankColl", acctBankColl);
        return selCompany;
    }

    protected CompanyOrgUnitInfo doArrangeDefaultFIUnit_Currency_Permission_BeShare(Map rstDataMap, CompanyOrgUnitInfo curCompany, String permission, boolean share) throws BOSException, EASBizException {
        if (curCompany == null) {
            curCompany = this.contextHelper.getCurrentCompany();
        }
        CompanyOrgUnitInfo selCompany = curCompany;
        AccountBankCollection acctBankColl = null;
        UserInfo curUser = this.contextHelper.getCurrentUser();
        if (share) {
            IPermission iPermisson;
            boolean flag;
            selCompany = curCompany.isIsBizUnit() ? ((flag = (iPermisson = PermissionFactory.getLocalInstance((Context)this.ctx)).hasFunctionPermission((IObjectPK)new ObjectUuidPK(curUser.getId().toString()), (IObjectPK)new ObjectUuidPK(curCompany.getId().toString()), permission)) ? curCompany : this.getCompanyOrgUnitInfoByUserPermisson_Share(permission, share)) : this.getCompanyOrgUnitInfoByUserPermisson_Share(permission, share);
            if (selCompany != null && selCompany.isIsBizUnit()) {
                String strCompanyId = selCompany.getId().toString();
                acctBankColl = CASWebHelper.getAccountBankCollection(this.ctx, strCompanyId, true);
            }
            rstDataMap.put("defaultFIUnit", selCompany);
            rstDataMap.put("acctBankColl", acctBankColl);
        } else {
            if (curCompany.isIsBizUnit()) {
                IPermission iPermisson = PermissionFactory.getLocalInstance((Context)this.ctx);
                boolean flag = iPermisson.hasFunctionPermission((IObjectPK)new ObjectUuidPK(curUser.getId().toString()), (IObjectPK)new ObjectUuidPK(curCompany.getId().toString()), permission);
                if (!flag) {
                    throw new EASBizException(CasWebException.NO_ORG_AUTHRIZED);
                }
            } else {
                throw new EASBizException(CasWebException.NO_ORG_AUTHRIZED);
            }
            selCompany = curCompany;
            if (selCompany != null && selCompany.isIsBizUnit()) {
                String strCompanyId = selCompany.getId().toString();
                acctBankColl = CASWebHelper.getAccountBankCollection(this.ctx, strCompanyId, true);
            }
            rstDataMap.put("defaultFIUnit", selCompany);
            rstDataMap.put("acctBankColl", acctBankColl);
        }
        return selCompany;
    }

    protected boolean queryPermissions_Permission_BeShare(CompanyOrgUnitInfo curCompany, String permission, boolean share) throws BOSException, EASBizException {
        boolean purview = true;
        if (curCompany == null) {
            curCompany = this.contextHelper.getCurrentCompany();
        }
        CompanyOrgUnitInfo selCompany = curCompany;
        Object acctBankColl = null;
        UserInfo curUser = this.contextHelper.getCurrentUser();
        if (share) {
            IPermission iPermisson;
            boolean flag;
            selCompany = curCompany.isIsBizUnit() ? ((flag = (iPermisson = PermissionFactory.getLocalInstance((Context)this.ctx)).hasFunctionPermission((IObjectPK)new ObjectUuidPK(curUser.getId().toString()), (IObjectPK)new ObjectUuidPK(curCompany.getId().toString()), permission)) ? curCompany : this.getCompanyOrgUnitInfoByUserPermisson_Share(permission, share)) : this.getCompanyOrgUnitInfoByUserPermisson_Share(permission, share);
            if (selCompany == null || selCompany.getId() == null) {
                throw new EASBizException(new NumericExceptionSubItem(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CasWebException", (String)"NO_ORG_AUTHRIZED", (Locale)this.ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CasWebException", (String)"NO_ORG_AUTHRIZED", (Locale)this.ctx.getLocale())));
            }
        } else if (curCompany.isIsBizUnit()) {
            PeriodInfo startPeriod;
            IPermission iPermisson = PermissionFactory.getLocalInstance((Context)this.ctx);
            boolean flag = iPermisson.hasFunctionPermission((IObjectPK)new ObjectUuidPK(curUser.getId().toString()), (IObjectPK)new ObjectUuidPK(curCompany.getId().toString()), permission);
            if (!flag) {
                purview = false;
                throw new EASBizException(new NumericExceptionSubItem(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CasWebException", (String)"NO_ORG_AUTHRIZED", (Locale)this.ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CasWebException", (String)"NO_ORG_AUTHRIZED", (Locale)this.ctx.getLocale())));
            }
            if (curCompany.isIsBizUnit() && !curCompany.isIsOUSealUp() && !curCompany.isIsAssistantOrg() && (startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)this.ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)curCompany)) == null) {
                throw new CasWebException(CasWebException.COMPANY_NO_PERIOD);
            }
        } else {
            purview = false;
            throw new EASBizException(new NumericExceptionSubItem(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CasWebException", (String)"NO_BANKSTATEMENT_NOT_BIZUNIT", (Locale)this.ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CasWebException", (String)"NO_BANKSTATEMENT_NOT_BIZUNIT", (Locale)this.ctx.getLocale())));
        }
        return purview;
    }

    protected boolean queryPermissions_Permission_Voucher_BeShare(CompanyOrgUnitInfo curCompany, String permission, boolean share) throws BOSException, EASBizException {
        boolean purview = true;
        if (curCompany == null) {
            curCompany = this.contextHelper.getCurrentCompany();
        }
        CompanyOrgUnitInfo selCompany = curCompany;
        Object acctBankColl = null;
        UserInfo curUser = this.contextHelper.getCurrentUser();
        if (!share) {
            if (curCompany.isIsBizUnit()) {
                IPermission iPermisson = PermissionFactory.getLocalInstance((Context)this.ctx);
                boolean flag = iPermisson.hasFunctionPermission((IObjectPK)new ObjectUuidPK(curUser.getId().toString()), (IObjectPK)new ObjectUuidPK(curCompany.getId().toString()), permission);
                if (!flag) {
                    throw new CasWebException(CasWebException.NO_VOUCHER__PERMISSION_ONE);
                }
            } else {
                throw new CasWebException(CasWebException.VOUCHER_NOT_BIZUNIT);
            }
        }
        return purview;
    }

    protected CompanyOrgUnitInfo doArrangeDefaultFIUnit_Currency(Map rstDataMap, CompanyOrgUnitInfo curCompany) throws BOSException, EASBizException {
        return this.doArrangeDefaultFIUnit_Currency_Permission(rstDataMap, curCompany, "cas_bankVcCheck_01view");
    }

    protected CompanyOrgUnitInfo doArrangeDefaultFIUnit_Currency_BeShare(Map rstDataMap, CompanyOrgUnitInfo curCompany, boolean share) throws BOSException, EASBizException {
        return this.doArrangeDefaultFIUnit_Currency_Permission_BeShare(rstDataMap, curCompany, "cas_bankVcCheck_01view", share);
    }

    protected boolean queryPermissions_Currency_BeShare(CompanyOrgUnitInfo curCompany, boolean share) throws BOSException, EASBizException {
        return this.queryPermissions_Permission_BeShare(curCompany, "cas_bankVcCheck_01view", share);
    }

    protected boolean queryPermissions_Currency_Voucher_BeShare(CompanyOrgUnitInfo curCompany, boolean share) throws BOSException, EASBizException {
        return this.queryPermissions_Permission_Voucher_BeShare(curCompany, "cas_voucher_01view", share);
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitInfoByUserPermisson(String permission) throws EASBizException, BOSException {
        CompanyOrgUnitCollection companyColl = FMHelper.getUserOrgRangesWithRangeOfStart((Context)this.ctx, (String)permission, (boolean)false, (boolean)false, (boolean)false);
        if (companyColl.size() > 0) {
            return companyColl.get(0);
        }
        return null;
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitInfoByUserPermisson_Share(String permission, boolean share) throws EASBizException, BOSException {
        CompanyOrgUnitCollection companyColl = new CompanyOrgUnitCollection();
        companyColl = share ? FMHelper.getUserOrgRangesWithRange((Context)this.ctx, (String)permission) : FMHelper.getUserOrgRangesWithRangeOfStart((Context)this.ctx, (String)permission, (boolean)false, (boolean)false, (boolean)false);
        if (companyColl.size() > 0) {
            return companyColl.get(0);
        }
        return null;
    }

    protected void doArrangeCurrency_PeriodOfCompany(Map rstDataMap, CompanyOrgUnitInfo selCompany, AccountBankInfo accBank) throws EASBizException, BOSException {
        AccountBankCollection acctBankColls;
        CurrencyInfo currency = CASWebHelper.getBaseCurrency(this.ctx, selCompany);
        if (currency == null) {
            currency = ContextUtil.getCurrentFIUnit((Context)this.ctx).getBaseCurrency();
        }
        if ((accBank == null || accBank.getId() == null) && (acctBankColls = CASWebHelper.getAccountBankCollection(this.ctx, selCompany.getId().toString(), true)) != null && acctBankColls.size() > 0) {
            accBank = acctBankColls.get(0);
        }
        if (accBank != null && accBank.getId() != null && accBank.getCurrency() == null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("isByCurrency"));
            selector.add(new SelectorItemInfo("currency.id"));
            selector.add(new SelectorItemInfo("currency.number"));
            selector.add(new SelectorItemInfo("currency.name"));
            selector.add(new SelectorItemInfo("currency.CU.id"));
            accBank = AccountBankFactory.getLocalInstance((Context)this.ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(accBank.getId()), selector);
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)accBank) && accBank.isIsByCurrency()) {
            currency = accBank.getCurrency();
            rstDataMap.put("currencyDisable", "true");
        } else {
            currency = selCompany.getBaseCurrency();
            rstDataMap.put("currencyDisable", "false");
        }
        if (currency != null && currency.getId() != null && currency.getName() == null) {
            currency = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId()));
        }
        rstDataMap.put("currency", currency);
        rstDataMap.put("CurrencyF7Filter", " (id <> '11111111-1111-1111-1111-111111111111DEB58FDC' and id <> '22222222-2222-2222-2222-222222222222DEB58FDC') ");
        PeriodInfo curPeriod = null;
        if (selCompany != null) {
            curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)selCompany);
        }
        if (curPeriod == null) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(this.ctx, "PleAddPeriodOfCurCompany"));
        }
        rstDataMap.put("curPeriod", curPeriod);
        PeriodCollection periodColl = CASWebHelper.getPeriodColls(this.ctx, selCompany);
        rstDataMap.put("periodColl", periodColl);
        Date pDate = new Date();
        if (curPeriod != null) {
            pDate = curPeriod.getBeginDate();
            rstDataMap.put("curPeriodYearEnum", this.doArrangePeriodYear(selCompany));
            rstDataMap.put("curPeriodNumberEnum", this.doArrangePeriodNumber(selCompany, curPeriod.getPeriodYear()));
        }
        SimpleDateFormat dfm = new SimpleDateFormat("yyyy-MM-dd");
        Date startDate = DateUtil.getFirstDayOfMonth((Date)pDate);
        Date eneDate = DateUtil.getLastDayOfMonth((Date)pDate);
        rstDataMap.put("startDateStr", dfm.format(startDate));
        rstDataMap.put("eneDateStr", dfm.format(eneDate));
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)this.ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)selCompany);
        if (startPeriod != null) {
            String sDateStr = dfm.format(startPeriod.getBeginDate());
            sDateStr = "beginDate >= {d '" + sDateStr + "'}";
            rstDataMap.put("periodF7Filter", sDateStr);
        }
        rstDataMap.put("defaultFIUnit", selCompany);
    }

    protected void checkBankVCFuncPermission(Map rstDataMap, String companyID, String permissionItem) {
        if (com.kingdee.bos.ctrl.common.util.StringUtil.isEmptyString((String)companyID)) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(this.ctx, "InputOrgUnitIsNull"));
            return;
        }
        UserInfo curUser = this.contextHelper.getCurrentUser();
        if (curUser == null || curUser.getId() == null) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(this.ctx, "LoginUserIsNull"));
            return;
        }
        try {
            PermissionFactory.getLocalInstance((Context)this.ctx).checkFunctionPermission((IObjectPK)new ObjectUuidPK(curUser.getId()), (IObjectPK)new ObjectUuidPK(companyID), permissionItem);
        }
        catch (EASBizException e1) {
            rstDataMap.put("MsgStr", e1.getMessage());
            rstDataMap.put("MsgDetail", e1.toString());
            e1.printStackTrace();
        }
        catch (BOSException e2) {
            rstDataMap.put("MsgStr", e2.getMessage());
            rstDataMap.put("MsgDetail", e2.toString());
            e2.printStackTrace();
        }
    }

    protected void doArrangeQueryFilters(Map rstDataMap, BankVCFilterVO filterVO) throws EASBizException, BOSException {
        if (filterVO == null) {
            return;
        }
        this.doArrangeBankVCFilterVO(filterVO);
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)this.ctx);
        int param = new Integer(pc.getParamValue((IObjectPK)new ObjectUuidPK(filterVO.getCompanyID()), "CS117"));
        boolean isshareAcctCompany = this.isShareBalanceOfAcctCompany(filterVO.getAcctBank(), filterVO.getCompany().getId().toString());
        HashSet<String> bankSet = new HashSet<String>();
        HashSet<String> companySet = new HashSet<String>();
        if (isshareAcctCompany || filterVO.getAcctBank().getShareType().getValue() != 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)filterVO.getAcctBank().getBankAccountNumber(), CompareType.EQUALS));
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("company.id"));
            selector.add(new SelectorItemInfo("company.name"));
            selector.add(new SelectorItemInfo("company.number"));
            view.setSelector(selector);
            view.setFilter(filter);
            AccountBankCollection acctColl = AccountBankFactory.getLocalInstance((Context)this.ctx).getAccountBankCollection(view);
            for (int i = 0; i < acctColl.size(); ++i) {
                AccountBankInfo info = acctColl.get(i);
                bankSet.add(info.getId().toString());
                companySet.add(info.getCompany().getId().toString());
            }
        }
        StringBuffer oqlA = new StringBuffer();
        oqlA.append(" id != null ");
        Object acct = null;
        if (filterVO.getAcctBank().getShareType().getValue() != 0) {
            oqlA.append(" AND ").append(StringUtil.buildIn((String)"company.id", (Object[])companySet.toArray())).append(" AND currency.id = '").append(filterVO.getCurrency().getId().toString()).append("' AND ").append(StringUtil.buildIn((String)"accountBank.id", (Object[])bankSet.toArray()));
        } else {
            if (!com.kingdee.bos.ctrl.common.util.StringUtil.isEmptyString((String)filterVO.getCompanyID())) {
                oqlA.append(" AND company.id = '").append(filterVO.getCompanyID()).append("'");
            }
            if (!com.kingdee.bos.ctrl.common.util.StringUtil.isEmptyString((String)filterVO.getAcctBankID())) {
                oqlA.append(" AND accountBank.id = '").append(filterVO.getAcctBankID()).append("'");
            }
            if (!com.kingdee.bos.ctrl.common.util.StringUtil.isEmptyString((String)filterVO.getCurrencyID())) {
                oqlA.append(" AND currency.id = '").append(filterVO.getCurrencyID()).append("'");
            }
        }
        if ("periodWay".equals(filterVO.getPeriodWay())) {
            if (filterVO.getEndDate() != null) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(filterVO.getEndDate());
                ((Calendar)calendar).add(5, 1);
                String eDatestr = BankVCUtil.dateFormat.format(calendar.getTime());
                String sDatestr = BankVCUtil.dateFormat.format(filterVO.getStartDate());
                if (param != 0) {
                    Date date = new Date();
                    eDatestr = BankVCUtil.dateFormat.format(date);
                    GregorianCalendar calendar1 = new GregorianCalendar();
                    calendar1.setTime(date);
                    ((Calendar)calendar1).add(5, -1);
                    date = calendar1.getTime();
                    sDatestr = BankVCUtil.dateFormat.format(date);
                }
                oqlA.append(" AND createDate < {").append(eDatestr).append("} ");
                oqlA.append(" AND createDate >= {").append(sDatestr).append("} ");
            } else {
                if (filterVO.getPeriodYear() > 0) {
                    oqlA.append(" AND period.periodYear = '").append(filterVO.getPeriodYear()).append("'");
                }
                if (filterVO.getPeriodNum() > 0) {
                    oqlA.append(" AND period.periodNumber = '").append(filterVO.getPeriodNum()).append("'");
                }
            }
        } else {
            String sDatestr;
            if (!"periodWay".equals(filterVO.getPeriodWay()) && filterVO.getStartDate() != null) {
                sDatestr = BankVCUtil.timeFormat.format(filterVO.getStartDate());
                oqlA.append(" AND createDate >= {ts '").append(sDatestr).append("'} ");
            }
            if (filterVO.getEndDate() != null) {
                sDatestr = BankVCUtil.timeFormat.format(filterVO.getEndDate());
                oqlA.append(" AND createDate <= {ts '").append(sDatestr).append("'} ");
            }
        }
        oqlA.append(" AND verifyStatus != '").append(2).append("' ");
        oqlA.append("order by createDate ");
        rstDataMap.put("VcBankFilter", oqlA.toString());
        StringBuffer oqlB = new StringBuffer();
        oqlB.append(" id != null ");
        if (isshareAcctCompany) {
            oqlB.append(" AND ").append(StringUtil.buildIn((String)"company.id", (Object[])companySet.toArray())).append(" AND currency.id = '").append(filterVO.getCurrency().getId().toString()).append("' AND ").append(StringUtil.buildIn((String)"accountBank.id", (Object[])bankSet.toArray()));
        } else {
            if (!com.kingdee.bos.ctrl.common.util.StringUtil.isEmptyString((String)filterVO.getCompanyID())) {
                oqlB.append(" AND company.id = '").append(filterVO.getCompanyID()).append("'");
            }
            if (!com.kingdee.bos.ctrl.common.util.StringUtil.isEmptyString((String)filterVO.getAcctBankID())) {
                oqlB.append(" AND accountBank.id = '").append(filterVO.getAcctBankID()).append("'");
            }
            if (!com.kingdee.bos.ctrl.common.util.StringUtil.isEmptyString((String)filterVO.getCurrencyID())) {
                oqlB.append(" AND currency.id = '").append(filterVO.getCurrencyID()).append("'");
            }
        }
        if ("periodWay".equals(filterVO.getPeriodWay())) {
            if (filterVO.getEndDate() != null) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(filterVO.getEndDate());
                ((Calendar)calendar).add(5, 1);
                String eDatestr = BankVCUtil.dateFormat.format(calendar.getTime());
                String sDatestr = BankVCUtil.dateFormat.format(filterVO.getStartDate());
                if (param != 0) {
                    Date date = new Date();
                    eDatestr = BankVCUtil.dateFormat.format(date);
                    GregorianCalendar calendar1 = new GregorianCalendar();
                    calendar1.setTime(date);
                    ((Calendar)calendar1).add(5, -1);
                    date = calendar1.getTime();
                    sDatestr = BankVCUtil.dateFormat.format(date);
                }
                oqlB.append(" AND createDate < {").append(eDatestr).append("} ");
                oqlB.append(" AND createDate >= {").append(sDatestr).append("} ");
            } else {
                if (filterVO.getPeriodYear() > 0) {
                    oqlB.append(" AND period.periodYear = '").append(filterVO.getPeriodYear()).append("'");
                }
                if (filterVO.getPeriodNum() > 0) {
                    oqlB.append(" AND period.periodNumber = '").append(filterVO.getPeriodNum()).append("'");
                }
            }
        } else {
            String sDatestr;
            if (!"periodWay".equals(filterVO.getPeriodWay()) && filterVO.getStartDate() != null) {
                sDatestr = BankVCUtil.timeFormat.format(filterVO.getStartDate());
                oqlB.append(" AND createDate >= {ts '").append(sDatestr).append("'} ");
            }
            if (filterVO.getEndDate() != null) {
                sDatestr = BankVCUtil.timeFormat.format(filterVO.getEndDate());
                oqlB.append(" AND createDate <= {ts '").append(sDatestr).append("'} ");
            }
        }
        oqlB.append(" AND type = '").append(2).append("'");
        oqlB.append(" AND verifyStatus != '").append(2).append("' ");
        oqlB.append("order by createDate ");
        rstDataMap.put("VcJournalFilter", oqlB.toString());
        rstDataMap.put("defaultFIUnit", filterVO.getCompanyID());
    }

    protected boolean isShareBalanceOfAcctCompany(AccountBankInfo accountbank, String companyId) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("company.*"));
        selector.add(new SelectorItemInfo("shareAcct.*"));
        selector.add(new SelectorItemInfo("shareAcct.shareBalanceOfAcctCompany.id"));
        selector.add(new SelectorItemInfo("shareType"));
        AccountBankInfo accBankInfo = AccountBankFactory.getLocalInstance((Context)this.ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountbank.getId().toString()), selector);
        if (accBankInfo.getShareType().getValue() == 0) {
            return true;
        }
        SharedAcctInfo sharedAcctInfo = accBankInfo.getShareAcct();
        return sharedAcctInfo != null && sharedAcctInfo.getShareBalanceOfAcctCompany() != null && sharedAcctInfo.getShareBalanceOfAcctCompany().getId().toString().equals(companyId);
    }

    protected void doActionSubmitVCResult(Map rstData, BankVCDataVO dataVO) throws EASBizException, BOSException {
        ArrayList<String> bankList = new ArrayList<String>();
        for (String bankRow : dataVO.getVcBankRows()) {
            bankList.add(bankRow);
        }
        ArrayList<String> journalList = new ArrayList<String>();
        for (String journalRow : dataVO.getVcJournalRows()) {
            journalList.add(journalRow);
        }
        HashMap<String, ArrayList<String>> SelIdMap = new HashMap<String, ArrayList<String>>();
        SelIdMap.put("com.kingdee.eas.fi.cas.app.BankStatement", bankList);
        SelIdMap.put("com.kingdee.eas.fi.cas.app.Journal", journalList);
        String curCUID = this.contextHelper.getCurrentCtrlUnit().getId().toString();
        VcSchemeInfo vcSchemeInfo = CASWebHelper.getVcSchemeInfoByBiz(this.ctx, curCUID);
        if (vcSchemeInfo == null) {
            rstData.put("MsgStr", CASWebUtil.getResource(this.ctx, "VCSchemeIsNotFound"));
            return;
        }
        IBankVcProcessFacade iVcProcess = BankVcProcessFacadeFactory.getLocalInstance((Context)this.ctx);
        IObjectCollection coll = iVcProcess.manualProcess(SelIdMap);
        if (!EmptyUtil.isEmpty((Object)coll) && coll.size() > 0) {
            rstData.put("MsgStr", CASWebHelper.getCASMsg(this.ctx, "SaveResultSuccess"));
            rstData.put("OPStatus", "success");
        } else {
            rstData.put("MsgStr", ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"94_BankVcCheckWebHelper", (Locale)this.ctx.getLocale()));
            rstData.put("OPStatus", "failure");
        }
    }

    protected void doArrangeAutoCheckSetting(Map rstDataMap, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        Map map = this.getVcSolMap_OfBatchVC(company, this.isShare ? "bizCommonQuery.advancedQuery.com.kingdee.eas.fi.cas.FI_CAS_BankVCSchemeBatchSettingUI_share" : "bizCommonQuery.advancedQuery.com.kingdee.eas.fi.cas.FI_CAS_BankVCSchemeBatchSettingUI");
        rstDataMap.put("autoCheckSetting", map);
    }

    protected void doSaveAutoCheckSetting(Map rstMap, CompanyOrgUnitInfo company, BankVCUserOptionVO userOptionVO) throws EASBizException, BOSException {
        IUserOption iUserOption = UserOptionFactory.getLocalInstance((Context)this.ctx);
        UserInfo user = this.contextHelper.getCurrentUser();
        if (company == null) {
            company = this.doArrangeDefaultFIUnit_Currency(rstMap, null);
        }
        String companyID = this.contextHelper.getCurrentCompany().getId().toString();
        if (company != null && company.getId() != null) {
            companyID = company.getId().toString();
        }
        UserOptionInfo userOptionInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("optKey", (Object)"com.kingdee.eas.fi.cas.client.BankVcCheckSettingUI");
        filter.appendFilterItem("name", (Object)"Hello");
        filter.appendFilterItem("company.id", (Object)companyID);
        filter.appendFilterItem("createUser.id", (Object)user.getId().toString());
        viewInfo.setFilter(filter);
        UserOptionCollection userOptColl = iUserOption.getUserOptionCollection(viewInfo);
        if (userOptColl != null && userOptColl.size() > 0) {
            userOptionInfo = userOptColl.get(0);
            Map userOptMap = UserOptionUtil.string2Map((String)userOptionInfo.getOptValue());
            if (userOptMap != null) {
                Object btnLeftAndRight;
                Object btnUpAndDown;
                Object chkAutoSearch = userOptMap.get("chkAutoSearch");
                if (chkAutoSearch != null && "TRUE".equals(chkAutoSearch.toString().toUpperCase(Locale.ENGLISH))) {
                    userOptionVO.setChkAutoSearch(Boolean.TRUE);
                }
                if ((btnUpAndDown = userOptMap.get("btnUpAndDown")) != null && "FALSE".equals(btnUpAndDown.toString().toUpperCase(Locale.ENGLISH))) {
                    userOptionVO.setBtnUpAndDown(Boolean.FALSE);
                }
                if ((btnLeftAndRight = userOptMap.get("btnLeftAndRight")) != null && "TRUE".equals(btnLeftAndRight.toString().toUpperCase(Locale.ENGLISH))) {
                    userOptionVO.setBtnLeftAndRight(Boolean.TRUE);
                }
            }
        } else {
            userOptionInfo = new UserOptionInfo();
            userOptionInfo.setName("Hello");
            userOptionInfo.setCreateUser(user);
            userOptionInfo.setCreateDate(new Date());
            userOptionInfo.setCompany(company);
            userOptionInfo.setOptKey("com.kingdee.eas.fi.cas.client.BankVcCheckSettingUI");
        }
        userOptionInfo.setOptValue(userOptionVO.toOptValString());
        iUserOption.submit(userOptionInfo, true, company.getId().toString());
        rstMap.put("MsgStr", CASWebUtil.getResource(this.ctx, "AutoVCConfigOK"));
        rstMap.put("OPStatus", "success");
    }

    protected void saveCancelVCHistory(Map rstData, BankVCCancelVO cancelVO) throws EASBizException, BOSException {
        if (cancelVO == null || cancelVO.getVcHistroyIds().length <= 0) {
            rstData.put("MsgStr", CASWebUtil.getResource(this.ctx, "CancelVCRstNotFound"));
            return;
        }
        HashSet<String> idSet = new HashSet<String>();
        String vcHistoryID = null;
        for (int idx = 0; idx < cancelVO.getVcHistroyIds().length; ++idx) {
            vcHistoryID = cancelVO.getVcHistroyIds()[idx];
            idSet.add(vcHistoryID);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        IVcResult iVcResult = VcResultFactory.getLocalInstance((Context)this.ctx);
        VcResultCollection vcRstColl = iVcResult.getVcResultCollection(view);
        IVcProcess iVcProcess = VcProcessFactory.getLocalInstance((Context)this.ctx);
        iVcProcess.undoProcess(vcRstColl);
        rstData.put("MsgStr", CASWebUtil.getResource(this.ctx, "CancelVCRstSaveOK"));
        rstData.put("OPStatus", "success");
    }

    public HashMap doArrangeQueryVCHistoryFilters(BankVCFilterVO filterVO) {
        HashMap<String, String> mapOQL = new HashMap<String, String>();
        StringBuffer oqlA = new StringBuffer();
        oqlA.append(" WHERE currency.id = '");
        oqlA.append(filterVO.getCurrency().getId().toString());
        oqlA.append("' AND accountBank.id = '");
        oqlA.append(filterVO.getAcctBank().getId().toString());
        oqlA.append("'");
        if (!"periodWay".equals(filterVO.getPeriodWay())) {
            oqlA.append(" AND createDate >= {");
            oqlA.append(BankVCUtil.dateFormat.format(filterVO.getStartDate())).append("}");
        }
        oqlA.append(" AND createDate <= {");
        oqlA.append(BankVCUtil.dateFormat.format(filterVO.getEndDate()));
        oqlA.append("}");
        Object comfilter = null;
        if (comfilter != null && comfilter.getFilterItems().size() > 0) {
            FilterInfo bankState = (FilterInfo)comfilter.clone();
            for (int i = 0; i < bankState.getFilterItems().size(); ++i) {
                FilterItemInfo filterItem = bankState.getFilterItems().get(i);
                if (filterItem.getPropertyName().equalsIgnoreCase("BILLNUMBER")) {
                    filterItem.setPropertyName("id");
                    filterItem.setCompareValue((Object)" ");
                }
                if (!filterItem.getPropertyName().equalsIgnoreCase("AMOUNT")) continue;
                filterItem.setPropertyName(" FDebitAmount + FcreditAmount ");
            }
            String comFilter = bankState.toString().replaceAll("settlementNumber", "settleNumber").replaceAll("[(]", "( ").replaceAll("[)]", ") ");
            oqlA.append(" AND ( ").append(comFilter).append(" )");
        }
        mapOQL.put("com.kingdee.eas.fi.cas.app.BankStatement", oqlA.toString());
        StringBuffer oqlB = new StringBuffer();
        boolean isshareAcctCompany = false;
        try {
            isshareAcctCompany = this.isShareBalanceOfAcctCompany(filterVO.getAcctBank(), filterVO.getCompany().getId().toString());
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (isshareAcctCompany) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)filterVO.getAcctBank().getBankAccountNumber(), CompareType.EQUALS));
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("company.id"));
            selector.add(new SelectorItemInfo("company.name"));
            selector.add(new SelectorItemInfo("company.number"));
            view.setSelector(selector);
            view.setFilter(filter);
            AccountBankCollection acctColl = new AccountBankCollection();
            try {
                acctColl = AccountBankFactory.getLocalInstance((Context)this.ctx).getAccountBankCollection(view);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            HashSet<String> bankSet = new HashSet<String>();
            HashSet<String> companySet = new HashSet<String>();
            for (int i = 0; i < acctColl.size(); ++i) {
                AccountBankInfo info = acctColl.get(i);
                bankSet.add(info.getId().toString());
                companySet.add(info.getCompany().getId().toString());
            }
            oqlB.append(" WHERE currency.id = '").append(filterVO.getCurrency().getId().toString());
            oqlB.append("' AND ").append(FMHelper.buildIn((String)"accountBank.id", (Object[])bankSet.toArray()));
            if (!"periodWay".equals(filterVO.getPeriodWay())) {
                oqlB.append(" AND createDate >= {");
                oqlB.append(BankVCUtil.dateFormat.format(filterVO.getStartDate())).append("}");
            }
        } else {
            oqlB.append(" WHERE currency.id = '");
            oqlB.append(filterVO.getCurrency().getId().toString());
            oqlB.append("' AND accountBank.id = '");
            oqlB.append(filterVO.getAcctBank().getId().toString());
            oqlB.append("'");
            if (!"periodWay".equals(filterVO.getPeriodWay())) {
                oqlB.append(" AND createDate >= {");
                oqlB.append(BankVCUtil.dateFormat.format(filterVO.getStartDate())).append("}");
            }
        }
        oqlB.append(" AND createDate <= {");
        oqlB.append(BankVCUtil.dateFormat.format(filterVO.getEndDate())).append("}");
        oqlB.append(" AND type = ");
        oqlB.append(2);
        if (comfilter != null && comfilter.getFilterItems().size() > 0) {
            FilterInfo bankState = (FilterInfo)comfilter.clone();
            for (int i = 0; i < bankState.getFilterItems().size(); ++i) {
                FilterItemInfo filterItem = bankState.getFilterItems().get(i);
                if (!filterItem.getPropertyName().equalsIgnoreCase("AMOUNT")) continue;
                filterItem.setPropertyName(" FDebitAmount + FcreditAmount ");
            }
            String comFilter = bankState.toString().replaceAll("[(]", "( ").replaceAll("[)]", ") ");
            oqlB.append(" AND ( ").append(comFilter).append(" )");
        }
        mapOQL.put("com.kingdee.eas.fi.cas.app.Journal", oqlB.toString());
        return mapOQL;
    }

    protected void getQueryVCHistoryDatasByFilter(Map rstDataMap, BankVCFilterVO filterVO) throws EASBizException, BOSException, UuidException, SQLException {
        if (filterVO == null) {
            return;
        }
        this.doArrangeBankVCFilterVO(filterVO);
    }

    private void doArrangeBankVCResultOfPageShow(Map rstDataMap, String companyID, VcResultCollection resultColl, BankVCFilterVO filterVO, boolean isTempData) throws BOSException, UuidException, SQLException, EASBizException {
        HashMap<String, BankStatementInfo> bankMap = new HashMap<String, BankStatementInfo>();
        HashMap<String, JournalInfo> journalMap = new HashMap<String, JournalInfo>();
        StringBuffer sb = new StringBuffer(BankVCUtil.getBankStatSQL());
        sb.append(" ( '' ");
        int m = resultColl.size();
        for (int i = 0; i < m; ++i) {
            VcResultInfo resultInfo = resultColl.get(i);
            if (!"com.kingdee.eas.fi.cas.app.BankStatement".equals(resultInfo.getBizObjectFullName())) continue;
            sb.append(", '");
            sb.append(resultInfo.getBizObjectId().toString());
            sb.append("'");
        }
        sb.append(" ) ");
        ISQLExecutor sqlExe = SQLExecutorFactory.getLocalInstance((Context)this.ctx, (String)sb.toString());
        IRowSet rs = sqlExe.executeSQL();
        while (rs.next()) {
            BankStatementInfo info = new BankStatementInfo();
            String fid = rs.getString("id");
            info.setId(BOSUuid.read((String)fid));
            info.setCreateDate(rs.getDate("createDate"));
            info.setSettleNumber(rs.getString("settleNumber"));
            SettlementTypeInfo typeInfo = new SettlementTypeInfo();
            typeInfo.setName(rs.getString("settleType.name"));
            info.setSettleType(typeInfo);
            info.setDescription(rs.getString("description"));
            info.setDebitAmount(rs.getBigDecimal("debitAmount"));
            info.setCreditAmount(rs.getBigDecimal("creditAmount"));
            CompanyOrgUnitInfo com = new CompanyOrgUnitInfo();
            com.setId(BOSUuid.read((String)rs.getString("COMPANY.ID")));
            com.setName(rs.getString("COMPANY_NAME"));
            info.setCompany(com);
            bankMap.put(fid, info);
        }
        rstDataMap.put("com.kingdee.eas.fi.cas.app.BankStatement", bankMap);
        sb = new StringBuffer(BankVCUtil.getJournalSQL());
        sb.append(" ( '' ");
        int m2 = resultColl.size();
        for (int i = 0; i < m2; ++i) {
            VcResultInfo resultInfo = resultColl.get(i);
            if (!"com.kingdee.eas.fi.cas.app.Journal".equals(resultInfo.getBizObjectFullName())) continue;
            sb.append(", '");
            sb.append(resultInfo.getBizObjectId().toString());
            sb.append("'");
        }
        sb.append(" ) ");
        rs = null;
        sqlExe = SQLExecutorFactory.getLocalInstance((Context)this.ctx, (String)sb.toString());
        rs = sqlExe.executeSQL();
        while (rs.next()) {
            JournalInfo info = new JournalInfo();
            String fid = rs.getString("id");
            info.setId(BOSUuid.read((String)fid));
            info.setCreateDate((Date)rs.getDate("createDate"));
            if (rs.getDate("bizDate") != null) {
                info.setBizDate((Date)rs.getDate("bizDate"));
            }
            info.setSettlementNumber(rs.getString("settlementNumber"));
            SettlementTypeInfo settleTypeInfo = new SettlementTypeInfo();
            settleTypeInfo.setName(rs.getString("settlementType.name"));
            info.setSettlementType(settleTypeInfo);
            info.setDescription(rs.getString("description"));
            info.setVoucherNumber(rs.getString("voucherNumber"));
            VoucherTypeInfo voucherTypeInfo = new VoucherTypeInfo();
            voucherTypeInfo.setName(rs.getString("voucherType.name"));
            info.setVoucherType(voucherTypeInfo);
            info.setDebitAmount(rs.getBigDecimal("debitAmount"));
            info.setCreditAmount(rs.getBigDecimal("creditAmount"));
            CompanyOrgUnitInfo com = new CompanyOrgUnitInfo();
            com.setId(BOSUuid.read((String)rs.getString("COMPANY.ID")));
            com.setName(rs.getString("COMPANY_NAME"));
            info.setCompany(com);
            info.setBillNumber(rs.getString("BILLNUMBER"));
            if (rs.getString("BILLTYPE") != null) {
                info.setBillType(BillTypeEnum.getEnum(rs.getInt("BILLTYPE")));
            }
            journalMap.put(fid, info);
        }
        rstDataMap.put("com.kingdee.eas.fi.cas.app.Journal", journalMap);
        ArrayList<BankVCHistoryVO> vcHistoryLists = new ArrayList<BankVCHistoryVO>();
        int rstCont = resultColl.size();
        for (int idx = 0; idx < rstCont; ++idx) {
            BankStatementInfo boInfo;
            BOSUuid boId;
            VcResultInfo resultInfo = resultColl.get(idx);
            if (resultInfo == null || (boId = resultInfo.getBizObjectId()) == null) continue;
            String bankVCGroup = null;
            if (isTempData) {
                bankVCGroup = new String((resultInfo.getKey() != null ? resultInfo.getKey() : "") + resultInfo.getGroup());
                String rstKey = this.getCacheRstGroupKey(companyID).append(bankVCGroup).toString();
                this.saveCacheOfAutoBankVCRst(companyID, rstKey, resultInfo);
                if (resultInfo.getId() == null) {
                    resultInfo.setId(BOSUuid.create((String)"5E9E7DC0"));
                }
                VcResultInfo tmpVcResultInfo = new VcResultInfo();
                tmpVcResultInfo.setId(resultInfo.getId());
            } else {
                VcVerifyInfo vcVerify = new VcVerifyInfo();
                vcVerify.setId(BOSUuid.create((BOSObjectType)vcVerify.getBOSType()));
                bankVCGroup = new String(vcVerify.getId().toString() + resultInfo.getGroup());
            }
            BankVCHistoryVO vcHistory = new BankVCHistoryVO();
            vcHistory.setId(resultInfo.getId() != null ? resultInfo.getId().toString() : BOSUuid.create((String)"5E9E7DC0").toString());
            if (resultInfo.getBizObjectFullName().endsWith("BankStatement")) {
                boInfo = (BankStatementInfo)bankMap.get(boId.toString());
                if (boInfo == null) continue;
                vcHistory.setRecordType("bankStatement");
                vcHistory.setVcResultInfo(resultInfo);
                vcHistory.setGroup(bankVCGroup);
                vcHistory.setSelect(Boolean.FALSE);
                vcHistory.setCompany(boInfo.getCompany().getName());
                vcHistory.setRecord(CASWebHelper.getCASMsg(this.ctx, "com.kingdee.eas.fi.cas.CheckoutResource", "BankCheckRecord"));
                vcHistory.setDate(boInfo.getCreateDate());
                vcHistory.setSettNumber(boInfo.getSettleNumber());
                vcHistory.setSettType(boInfo.getSettleType().getName());
                vcHistory.setDescription(boInfo.getDescription());
                vcHistory.setDebitAmount(boInfo.getDebitAmount());
                vcHistory.setCreditAmount(boInfo.getCreditAmount());
            } else {
                boInfo = (JournalInfo)journalMap.get(boId.toString());
                if (boInfo == null) continue;
                vcHistory.setRecordType("bankJournal");
                vcHistory.setVcResultInfo(resultInfo);
                vcHistory.setGroup(bankVCGroup);
                vcHistory.setSelect(Boolean.FALSE);
                vcHistory.setRecord(CASWebHelper.getCASMsg(this.ctx, "com.kingdee.eas.fi.cas.CheckoutResource", "BankJournalRecord"));
                vcHistory.setDate(boInfo.getCreateDate());
                vcHistory.setBizDate(boInfo.getBizDate());
                vcHistory.setCompany(boInfo.getCompany().getName());
                vcHistory.setSettNumber(boInfo.getSettlementNumber());
                vcHistory.setSettType(boInfo.getSettlementType().getName());
                vcHistory.setDescription(boInfo.getDescription());
                if (boInfo.getVoucherNumber() != null) {
                    vcHistory.setVoucherNumber(boInfo.getVoucherNumber());
                }
                if (boInfo.getVoucherType() != null) {
                    vcHistory.setVoucherType(boInfo.getVoucherType().getName());
                }
                vcHistory.setDebitAmount(boInfo.getDebitAmount());
                vcHistory.setCreditAmount(boInfo.getCreditAmount());
                if (boInfo.getBillNumber() != null) {
                    vcHistory.setBillNumber(boInfo.getBillNumber());
                }
                if (boInfo.getBillType() != null) {
                    vcHistory.setBillType(boInfo.getBillType().getAlias());
                }
            }
            vcHistoryLists.add(vcHistory);
        }
        List<BankVCHistoryVO> sortedHistoryList = this.sortBankVCHistoryList(vcHistoryLists, filterVO);
        rstDataMap.put("bankBCHistorys", sortedHistoryList.toArray());
    }

    protected List<BankVCHistoryVO> sortBankVCHistoryList(List<BankVCHistoryVO> bankVCHistoryList, BankVCFilterVO filterVO) {
        ArrayList<BankVCHistoryVO> sortedHistoryList = new ArrayList<BankVCHistoryVO>(bankVCHistoryList.size());
        if (bankVCHistoryList != null && bankVCHistoryList.size() > 0) {
            HashMap<String, BankVCHistoryGroupVO> groupMap = new HashMap<String, BankVCHistoryGroupVO>();
            for (BankVCHistoryVO aVo : bankVCHistoryList) {
                String groupId = aVo.getGroup();
                if (!groupMap.containsKey(groupId)) {
                    ArrayList<BankVCHistoryVO> voList = new ArrayList<BankVCHistoryVO>();
                    voList.add(aVo);
                    groupMap.put(groupId, new BankVCHistoryGroupVO(groupId, voList, aVo.getDate(), true));
                    continue;
                }
                BankVCHistoryGroupVO groupVo = (BankVCHistoryGroupVO)groupMap.get(groupId);
                groupVo.getRecordList().add(aVo);
                Date minDate = groupVo.getMinDate();
                if (aVo.getDate().compareTo(minDate) >= 0) continue;
                groupVo.setMinDate(aVo.getDate());
            }
            ArrayList groupList = new ArrayList(groupMap.values());
            if ("periodWay".equals(filterVO.getPeriodWay())) {
                Date startDate = filterVO.getStartDate();
                Date endDate = filterVO.getEndDate();
                block1: for (BankVCHistoryGroupVO groupVo : groupList) {
                    List<BankVCHistoryVO> subList = groupVo.getRecordList();
                    if (subList == null || subList.size() <= 0) continue;
                    for (BankVCHistoryVO aVo : subList) {
                        if (aVo.getDate().getTime() < startDate.getTime() || aVo.getDate().getTime() > endDate.getTime()) continue;
                        groupVo.setHidden(false);
                        continue block1;
                    }
                }
                Iterator aIterator = groupList.iterator();
                while (aIterator.hasNext()) {
                    BankVCHistoryGroupVO groupVo;
                    groupVo = (BankVCHistoryGroupVO)aIterator.next();
                    if (!groupVo.isHidden()) continue;
                    aIterator.remove();
                }
            }
            Collections.sort(groupList, new Comparator<BankVCHistoryGroupVO>(){

                @Override
                public int compare(BankVCHistoryGroupVO o1, BankVCHistoryGroupVO o2) {
                    return o1.getMinDate().compareTo(o2.getMinDate());
                }
            });
            for (BankVCHistoryGroupVO groupVo : groupList) {
                List<BankVCHistoryVO> subList = groupVo.getRecordList();
                Collections.sort(subList, new Comparator<BankVCHistoryVO>(){

                    @Override
                    public int compare(BankVCHistoryVO o1, BankVCHistoryVO o2) {
                        return (o1.getRecordType() != null ? o1.getRecordType() : "").compareTo(o2.getRecordType() != null ? o2.getRecordType() : "");
                    }
                });
                Collections.reverse(subList);
                sortedHistoryList.addAll(subList);
            }
            int seq_Num = 1;
            HashMap<String, Integer> seqNumMap = new HashMap<String, Integer>();
            for (BankVCHistoryVO aVo : sortedHistoryList) {
                String groupId = aVo.getGroup();
                if (!seqNumMap.containsKey(groupId)) {
                    aVo.setQuerySeq_No(seq_Num);
                    seqNumMap.put(groupId, seq_Num);
                    ++seq_Num;
                    continue;
                }
                int querySeq_No = (Integer)seqNumMap.get(groupId);
                aVo.setQuerySeq_No(querySeq_No);
            }
        }
        return sortedHistoryList;
    }

    public void doArrangeBankVCFilterVO(BankVCFilterVO filterVO) throws EASBizException, BOSException {
        if (filterVO == null) {
            return;
        }
        if (filterVO.getCompanyID() != null) {
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(filterVO.getCompanyID()));
            filterVO.setCompany(companyInfo);
        }
        if (filterVO.getAcctBankID() != null) {
            AccountBankInfo acctBankInfo = AccountBankFactory.getLocalInstance((Context)this.ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(filterVO.getAcctBankID()));
            filterVO.setAcctBank(acctBankInfo);
        }
        if (filterVO.getCurrencyID() != null) {
            CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(filterVO.getCurrencyID()));
            filterVO.setCurrency(currencyInfo);
        }
        if ("periodWay".equals(filterVO.getPeriodWay())) {
            PeriodInfo period;
            IPeriod iperiod = PeriodFactory.getLocalInstance((Context)this.ctx);
            if (filterVO.getPeriodID() != null && (period = iperiod.getPeriodInfo((IObjectPK)new ObjectUuidPK(filterVO.getPeriodID()))) != null) {
                filterVO.setPeriodYear(period.getPeriodYear());
                filterVO.setPeriodNum(period.getPeriodNumber());
            }
            if (filterVO.getPeriodYear() > 0 && filterVO.getPeriodNum() > 0) {
                String oqlStr = "select * where periodYear = " + filterVO.getPeriodYear() + " and periodNumber = " + filterVO.getPeriodNum() + " and periodType.id = '" + filterVO.getCompany().getAccountPeriodType().getId().toString() + "' ";
                PeriodCollection periodColl = iperiod.getPeriodCollection(oqlStr);
                if (periodColl != null && periodColl.size() > 0 && periodColl.get(0) != null) {
                    PeriodInfo period2 = periodColl.get(0);
                    PeriodInfo prePeriodInfo = null;
                    if (this.isIntelligentBankVC && !EmptyUtil.isEmpty((CoreBaseInfo)(prePeriodInfo = PeriodUtils.getPrePeriodInfo((Context)this.ctx, (PeriodInfo)period2))) && prePeriodInfo.isIsAdjustPeriod()) {
                        prePeriodInfo = PeriodUtils.getPrePeriodInfo((Context)this.ctx, (PeriodInfo)prePeriodInfo);
                    }
                    if (!EmptyUtil.isEmpty(prePeriodInfo) && !EmptyUtil.isEmpty((Object)prePeriodInfo.getBeginDate())) {
                        filterVO.setStartDate(DateUtil.getFirstDayOfMonth((Date)prePeriodInfo.getBeginDate()));
                    } else {
                        filterVO.setStartDate(DateUtil.getFirstDayOfMonth((Date)period2.getBeginDate()));
                    }
                    filterVO.setEndDate(DateUtil.getLastDayOfMonth((Date)period2.getEndDate()));
                } else {
                    Date startDate = null;
                    startDate = BankJournalWebUtil.getPeriodInfo(this.ctx, filterVO.getPeriodYear(), filterVO.getPeriodNum(), filterVO.getCompany()).getBeginDate();
                    filterVO.setStartDate(startDate);
                    filterVO.setEndDate(DateUtil.getLastDayOfMonth((Date)startDate));
                }
            }
        } else {
            Date curDate = new Date();
            if (filterVO.getStartDate() != null) {
                curDate = filterVO.getStartDate();
            }
            if (filterVO.getEndDate() != null) {
                curDate = filterVO.getEndDate();
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(curDate);
            filterVO.setPeriodYear(cal.get(1));
            filterVO.setPeriodNum(cal.get(2) + 1);
        }
    }

    protected void getBankVCAutoCheckResult(Map rstData, BankVCFilterVO filterVO, CompanyOrgUnitInfo company, boolean isDirectSubmitToDB, boolean isHaveVCScheme) throws EASBizException, BOSException, UuidException, SQLException {
        if (filterVO == null) {
            return;
        }
        this.isIntelligentBankVC = false;
        if (rstData.get("isIntelligentBankVC") != null) {
            this.isIntelligentBankVC = (Boolean)rstData.get("isIntelligentBankVC");
        }
        this.doArrangeBankVCFilterVO(filterVO);
        IVcProcess iVcProcess = VcProcessFactory.getLocalInstance((Context)this.ctx);
        if (rstData.get("isIntelligentBankVC") == null) {
            iVcProcess.autoProcess_CAS(filterVO.getCompanyID(), filterVO.getAcctBankID(), filterVO.getCurrencyID(), filterVO.getStartDate(), filterVO.getEndDate(), this.isShare);
        } else {
            iVcProcess.intelligentVC(filterVO.getCompanyID(), filterVO.getAcctBankID(), filterVO.getCurrencyID(), filterVO.getStartDate(), filterVO.getEndDate());
        }
    }

    public VcMatchConditionCollection getCheckOutConfig(Map rstDataMap, CompanyOrgUnitInfo company, boolean isHaveVCScheme) throws EASBizException, BOSException {
        this.doArrangeDefaultFIUnit_Currency(rstDataMap, company);
        HashMap map = this.getVcSolMap_OfBatchVC(company, this.isShare ? "bizCommonQuery.advancedQuery.com.kingdee.eas.fi.cas.FI_CAS_BankVCSchemeBatchSettingUI_share" : "bizCommonQuery.advancedQuery.com.kingdee.eas.fi.cas.FI_CAS_BankVCSchemeBatchSettingUI");
        VcMatchConditionCollection vcColl = new VcMatchConditionCollection();
        if (map == null || map.size() == 0) {
            if (isHaveVCScheme) {
                map = new HashMap();
            } else {
                return null;
            }
        }
        boolean isDateEquals = Boolean.valueOf((String)map.get("chkDateEqual"));
        boolean isDescriptionEquals = Boolean.valueOf((String)map.get("chkDescriptionEqual"));
        boolean isSettTypeEquals = Boolean.valueOf((String)map.get("chkSettTypeEqual"));
        boolean isSettNumberEquals = Boolean.valueOf((String)map.get("chkSettNumberEqual"));
        boolean isMulSettNumberEquals = Boolean.valueOf((String)map.get("chkMulSettNumberEqual"));
        boolean[] blnArray = new boolean[]{isDateEquals, isDescriptionEquals, isSettTypeEquals, isSettNumberEquals, isMulSettNumberEquals};
        String[] strArray = new String[]{"bizDate", "description", "settlementType", "settlementNumber", "settlementNumber_m"};
        String[] bankStrArray = new String[]{"createDate", "description", "settleType", "settleNumber", "settleNumber_m"};
        VcMatchConditionInfo jounralVcInfo = null;
        VcMatchConditionInfo bankVcInfo = null;
        int serial = 10;
        for (int i = 0; i < blnArray.length; ++i) {
            if (blnArray[i]) {
                jounralVcInfo = new VcMatchConditionInfo();
                jounralVcInfo.setSeq(serial);
                jounralVcInfo.setPropFullName("com.kingdee.eas.fi.cas.app.Journal." + strArray[i]);
                String AND = CASWebHelper.getCASMsg(this.ctx, "com.kingdee.eas.base.vc.VcResource", "AND");
                jounralVcInfo.setPropName(strArray[i]);
                jounralVcInfo.setBizObjectName("com.kingdee.eas.fi.cas.app.Journal");
                jounralVcInfo.setAndor(AND);
                bankVcInfo = new VcMatchConditionInfo();
                bankVcInfo.setSeq(serial);
                bankVcInfo.setPropFullName("com.kingdee.eas.fi.cas.app.BankStatement." + bankStrArray[i]);
                bankVcInfo.setAndor(AND);
                bankVcInfo.setPropName(bankStrArray[i]);
                bankVcInfo.setBizObjectName("com.kingdee.eas.fi.cas.app.BankStatement");
                vcColl.add(jounralVcInfo);
                vcColl.add(bankVcInfo);
            }
            ++serial;
        }
        return vcColl;
    }

    protected Map getVcSolMap_OfBatchVC(CompanyOrgUnitInfo company, String parentUIName) throws BOSException, EASBizException {
        Map solDetail = null;
        ICasWebQrySolFacade facade = CasWebQrySolFacadeFactory.getLocalInstance(this.ctx);
        QuerySolutionInfo solInfo = facade.getDefaultSolution(company.getId().toString(), parentUIName);
        if (solInfo != null) {
            solDetail = facade.getSolutionFilterMap(solInfo.getId().toString());
        }
        return solDetail;
    }

    protected void submitAutoVCResultToDB(Map rstDataMap, BankVCRstSubmitVO dataVO, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        if (dataVO == null || dataVO.getVcAutoRstIds() == null || dataVO.getVcAutoRstIds().length == 0) {
            return;
        }
        if (company == null || company.getId() == null) {
            company = this.contextHelper.getCurrentCompany();
        }
        HashSet<String> vcRstIDsSet = new HashSet<String>();
        for (int idx = 0; idx < dataVO.getVcAutoRstIds().length; ++idx) {
            vcRstIDsSet.add(dataVO.getVcAutoRstIds()[idx]);
        }
        String companyID = company.getId().toString();
        VcResultCollection vcRstAllColl = new VcResultCollection();
        for (String bankVCGroup : vcRstIDsSet) {
            String rstKey = this.getCacheRstGroupKey(companyID).append(bankVCGroup).toString();
            VcResultCollection vcRstColl = this.getCacheOfAutoBankVCRst(companyID, rstKey);
            if (vcRstColl == null || vcRstColl.size() <= 0) continue;
            vcRstAllColl.addCollection(vcRstColl);
        }
        IBankVcProcessFacade iVcProcess = BankVcProcessFacadeFactory.getLocalInstance((Context)this.ctx);
        iVcProcess.submitResult((IObjectCollection)vcRstAllColl);
    }

    protected List<EnumItemVO> doArrangePeriodYear(CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        ArrayList<EnumItemVO> periodYears = new ArrayList<EnumItemVO>();
        PeriodCollection periodColl = CASWebHelper.getPeriodColls(this.ctx, companyInfo);
        ArrayList<Integer> pYears = new ArrayList<Integer>();
        for (int idx = 0; idx < periodColl.size(); ++idx) {
            PeriodInfo period = periodColl.get(idx);
            Integer pYear = new Integer(period.getPeriodYear());
            if (pYears.contains(pYear)) continue;
            pYears.add(pYear);
        }
        Collections.sort(pYears);
        for (Integer cpYear : pYears) {
            EnumItemVO itemVo = new EnumItemVO(cpYear.toString());
            periodYears.add(itemVo);
        }
        return periodYears;
    }

    protected List<EnumItemVO> doArrangePeriodNumber(CompanyOrgUnitInfo companyInfo, int periodYear) throws EASBizException, BOSException {
        ArrayList<EnumItemVO> periodNumbers = new ArrayList<EnumItemVO>();
        PeriodCollection periodColl = CASWebHelper.getPeriodColls(this.ctx, companyInfo);
        ArrayList<Integer> pNumbers = new ArrayList<Integer>();
        for (int idx = 0; idx < periodColl.size(); ++idx) {
            PeriodInfo period = periodColl.get(idx);
            Integer pNumber = new Integer(period.getPeriodNumber());
            if (periodYear != period.getPeriodYear() || pNumbers.contains(pNumber)) continue;
            pNumbers.add(pNumber);
        }
        Collections.sort(pNumbers);
        for (Integer cpNumber : pNumbers) {
            EnumItemVO itemVo = new EnumItemVO(cpNumber.toString());
            periodNumbers.add(itemVo);
        }
        return periodNumbers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getValidCurrencyIDs_OfBankVC(CompanyOrgUnitInfo companyOrg, AccountBankInfo accBankInfo) throws BOSException {
        StringBuffer bankStamentSQL = new StringBuffer();
        bankStamentSQL.append("SELECT DISTINCT BS.FCurrencyId FROM T_CAS_BankStatement AS BS WHERE BS.FID IS NOT NULL ");
        StringBuffer bankJournalSQL = new StringBuffer();
        bankJournalSQL.append("SELECT DISTINCT BJ.FCurrencyID FROM T_CAS_Journal AS BJ WHERE BJ.FID IS NOT NULL ");
        if (companyOrg != null && companyOrg.getId() != null) {
            bankStamentSQL.append(" AND BS.FCompanyID = '").append(companyOrg.getId().toString()).append("' ");
            bankJournalSQL.append(" AND BJ.FCompanyID = '").append(companyOrg.getId().toString()).append("' ");
        }
        if (accBankInfo != null && accBankInfo.getId() != null) {
            bankStamentSQL.append(" AND BS.FAccountBankID = '").append(accBankInfo.getId().toString()).append("' ");
            bankJournalSQL.append(" AND BJ.FAccountBankID = '").append(accBankInfo.getId().toString()).append("' ");
        }
        ArrayList<String> currencyIDs = new ArrayList<String>();
        Object[] params = new Object[]{};
        IRowSet rowSet_BS = null;
        String currencyID = null;
        try {
            rowSet_BS = DbUtil.executeQuery((Context)this.ctx, (String)bankStamentSQL.toString(), (Object[])params);
            while (rowSet_BS.next()) {
                currencyID = rowSet_BS.getString(1);
                if (currencyID == null) continue;
                currencyIDs.add(currencyID);
            }
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
        finally {
            try {
                rowSet_BS.close();
            }
            catch (SQLException e) {
                System.out.println(e.getMessage());
            }
        }
        IRowSet rowSet_BJ = null;
        try {
            rowSet_BJ = DbUtil.executeQuery((Context)this.ctx, (String)bankStamentSQL.toString(), (Object[])params);
            while (rowSet_BJ.next()) {
                currencyID = rowSet_BJ.getString(1);
                if (currencyID == null) continue;
                currencyIDs.add(currencyID);
            }
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
        finally {
            try {
                rowSet_BJ.close();
            }
            catch (SQLException e) {
                System.out.println(e.getMessage());
            }
        }
        return currencyIDs;
    }

    protected VcResultCollection getCacheOfAutoBankVCRst(String companyID, String rstKey) {
        Map<String, VcResultCollection> vcRstMap = this.getCacheOfAutoBankVCRst(companyID);
        VcResultCollection vcRstColl = vcRstMap.get(rstKey);
        if (vcRstColl == null) {
            vcRstColl = new VcResultCollection();
            vcRstMap.put(rstKey, vcRstColl);
        }
        return vcRstColl;
    }

    protected Map<String, VcResultCollection> getCacheOfAutoBankVCRst(String companyID) {
        String rstGroupKey = this.getCacheRstGroupKey(companyID).toString();
        Map<String, VcResultCollection> rstMap = autoBankVCResultCache.get(rstGroupKey);
        if (rstMap == null) {
            rstMap = new ConcurrentHashMap<String, VcResultCollection>();
            autoBankVCResultCache.put(rstGroupKey, rstMap);
        }
        return rstMap;
    }

    protected StringBuffer getCacheRstGroupKey(String companyID) {
        if (companyID == null) {
            companyID = this.contextHelper.getCurrentCompany().getId().toString();
        }
        return new StringBuffer().append(companyID).append(JoinStr).append(this.contextHelper.getCurrentUser().getId().toString()).append(JoinStr);
    }

    protected void saveCacheOfAutoBankVCRst(String companyID, String rstKey, VcResultInfo vcRstInfo) {
        VcResultCollection vcRstColl = this.getCacheOfAutoBankVCRst(companyID, rstKey);
        if (vcRstColl == null) {
            vcRstColl = new VcResultCollection();
            this.saveCacheOfAutoBankVCRst(companyID, rstKey, vcRstColl);
        }
        vcRstColl.add(vcRstInfo);
    }

    protected void saveCacheOfAutoBankVCRst(String companyID, String rstKey, VcResultCollection vcRstColl) {
        Map<String, VcResultCollection> vcRstMap = this.getCacheOfAutoBankVCRst(companyID);
        if (vcRstMap == null) {
            vcRstMap = new ConcurrentHashMap<String, VcResultCollection>();
            this.saveCacheOfAutoBankVCRst(companyID, vcRstMap);
        }
        vcRstMap.put(rstKey, vcRstColl);
    }

    protected void saveCacheOfAutoBankVCRst(String companyID, Map<String, VcResultCollection> vcRstMap) {
        String rstGroupKey = this.getCacheRstGroupKey(companyID).toString();
        autoBankVCResultCache.put(rstGroupKey, vcRstMap);
    }

    protected VcSchemeInfo getCacheOfBankVCScheme(String companyID) {
        StringBuffer groupKey = this.getCacheRstGroupKey(companyID);
        groupKey.append(BankVcScheme);
        return autoBankVCSchemeCache.get(groupKey.toString());
    }

    protected void saveCacheOfBankVCScheme(String companyID, VcSchemeInfo vcSchemeInfo) {
        if (companyID == null || vcSchemeInfo == null) {
            return;
        }
        StringBuffer groupKey = this.getCacheRstGroupKey(companyID);
        groupKey.append(BankVcScheme);
        autoBankVCSchemeCache.put(groupKey.toString(), vcSchemeInfo);
    }

    protected List<BankVCBatchShowRowVO> batchVC_doGetBatchAutoCheckPageData(Map rstDataMap, CompanyOrgUnitInfo selCompany, String parentUIName, boolean isAllOrg, boolean includeAccBank, boolean includePeriodInfo) throws BOSException, EASBizException {
        ICompanyOrgUnit iOrgUint = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx);
        CompanyOrgUnitCollection orgColl = new CompanyOrgUnitCollection();
        HashMap<String, String> periodTypes = new HashMap<String, String>();
        if (isAllOrg) {
            Set<String> authorOrgSet = CASWebHelper.getAuthorizedOrg(this.ctx, "cas_bankVcCheck_02contrast", false);
            EntityViewInfo orgView = new EntityViewInfo();
            FilterInfo orgFilter = new FilterInfo();
            orgFilter.getFilterItems().add(new FilterItemInfo("id", authorOrgSet, CompareType.INCLUDE));
            orgView.setFilter(orgFilter);
            orgView.getSorter().add(new SorterItemInfo("longNumber"));
            orgColl = iOrgUint.getCompanyOrgUnitCollection(orgView);
        } else {
            orgColl.add(selCompany);
        }
        if (orgColl.size() > 1) {
            CompanyOrgUnitInfo companyInfo = null;
            int orgCollSize = orgColl.size();
            for (int idx = orgCollSize - 1; idx >= 0; --idx) {
                companyInfo = orgColl.get(idx);
                PeriodInfo curDefPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
                if (curDefPeriod != null) continue;
                orgColl.remove(companyInfo);
            }
        }
        HashSet<String> periodTypeIDSet = new HashSet<String>();
        HashMap vcSchemeMap = new HashMap();
        String companyID = null;
        for (int idx = 0; idx < orgColl.size(); ++idx) {
            if (orgColl.get(idx) == null || orgColl.get(idx).getId() == null) continue;
            companyID = orgColl.get(idx).getId().toString();
            if (orgColl.get(idx).getAccountPeriodType() == null || orgColl.get(idx).getAccountPeriodType().getId() == null) continue;
            periodTypeIDSet.add(orgColl.get(idx).getAccountPeriodType().getId().toString());
        }
        EntityViewInfo perView = new EntityViewInfo();
        FilterInfo perFilter = new FilterInfo();
        perFilter.getFilterItems().add(new FilterItemInfo("id", periodTypeIDSet, CompareType.INCLUDE));
        perView.setFilter(perFilter);
        perView.getSorter().add(new SorterItemInfo("id"));
        PeriodTypeCollection perColl = PeriodTypeFactory.getLocalInstance((Context)this.ctx).getPeriodTypeCollection(perView);
        if (perColl.size() != 0) {
            for (int i = 0; i < perColl.size(); ++i) {
                periodTypes.put(perColl.get(i).getId().toString(), perColl.get(i).getName().toString());
            }
        }
        if (includePeriodInfo) {
            PeriodInfo defPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)selCompany);
            if (defPeriod == null) {
                for (int idx = 0; idx < orgColl.size() && (defPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)orgColl.get(idx))) == null; ++idx) {
                }
            }
            PeriodCollection allPeriodColl = this.batchVC_getPeriodCollByPeriodType(periodTypeIDSet);
            PeriodCollection periodColl = this.batchVC_doRemoveDoublePeriod(allPeriodColl, defPeriod);
            rstDataMap.put("baVCPeriodColl", periodColl);
            if (periodColl != null && periodColl.size() > 0) {
                if (defPeriod == null) {
                    defPeriod = periodColl.get(0);
                }
                rstDataMap.put("baVCDefPeriod", defPeriod);
                int pYear = defPeriod.getPeriodYear();
                int pNumber = defPeriod.getPeriodNumber() > 12 ? 12 : defPeriod.getPeriodNumber();
                rstDataMap.put("baVCDefStartDate", BankVCUtil.getFirstDayOfMonth(pYear, pNumber));
                rstDataMap.put("baVCDefEndDate", BankVCUtil.getLastDayOfMonth(pYear, pNumber));
                StringBuffer periodFilter = new StringBuffer();
                periodFilter.append(" id in (");
                for (int idx = 0; idx < periodColl.size(); ++idx) {
                    if (periodColl.get(idx) == null) continue;
                    if (idx > 0) {
                        periodFilter.append(",");
                    }
                    periodFilter.append("'").append(periodColl.get(idx).getId()).append("'");
                }
                periodFilter.append(") ");
                rstDataMap.put("baVCPeriodFilter", periodFilter.toString());
            } else {
                rstDataMap.put("MsgStr", CASWebUtil.getResource(this.ctx, "PleAddPeriodOfCurCompany"));
            }
        }
        ArrayList<BankVCBatchShowRowVO> baVCShowVOLists = new ArrayList<BankVCBatchShowRowVO>();
        CompanyOrgUnitInfo orgUnit = null;
        for (int idx = 0; idx < orgColl.size(); ++idx) {
            orgUnit = orgColl.get(idx);
            if (orgUnit == null || orgUnit.getId() == null) continue;
            companyID = orgUnit.getId().toString();
            BankVCBatchShowRowVO vcShowRowVO = new BankVCBatchShowRowVO();
            if (orgUnit.getName() == null) {
                orgUnit = iOrgUint.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnit.getId()));
            }
            vcShowRowVO.setAddCheckBox(false);
            vcShowRowVO.setRootRow(true);
            vcShowRowVO.setId(companyID);
            vcShowRowVO.setCompany(orgUnit);
            vcShowRowVO.setCompanyColumn(orgUnit.getName());
            String accountPeriodTypeId = orgUnit.getAccountPeriodType().getId().toString();
            vcShowRowVO.setPeriodTypeColumn(periodTypes.get(accountPeriodTypeId).toString());
            vcShowRowVO.setPeriodTypeId(accountPeriodTypeId);
            ICasWebQrySolFacade facade = CasWebQrySolFacadeFactory.getLocalInstance(this.ctx);
            QuerySolutionInfo solInfo = facade.getDefaultSolution(companyID, parentUIName);
            if (solInfo != null) {
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"201_default", (Locale)this.ctx.getLocale());
                vcShowRowVO.setSchemeColumn(msg + solInfo.getName());
                vcShowRowVO.setScheme(facade.getSolutionFilterMap(solInfo.getId().toString()));
                vcShowRowVO.setSolutionInfo(solInfo);
            }
            baVCShowVOLists.add(vcShowRowVO);
            if (!includeAccBank) continue;
            this.batchVC_doArrangeAccountBankOfCompany(rstDataMap, baVCShowVOLists, orgUnit);
        }
        rstDataMap.put("baVCOrgRowList", baVCShowVOLists.toArray());
        return baVCShowVOLists;
    }

    protected List<BankVCBatchShowRowVO> batchVC_doGetBatchAutoCheckPageData_Share(Map rstDataMap, CompanyOrgUnitInfo selCompany, String parentUIName, boolean isAllOrg, boolean includeAccBank, boolean includePeriodInfo, boolean share) throws BOSException, EASBizException {
        List list;
        Set entrySet;
        FilterInfo filter;
        EntityViewInfo evi;
        ICompanyOrgUnit iOrgUint = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx);
        CompanyOrgUnitCollection orgColl = new CompanyOrgUnitCollection();
        HashMap<String, String> periodTypes = new HashMap<String, String>();
        if (isAllOrg) {
            orgColl = CASWebHelper.getAuthorizedOrgCollection(this.ctx, "cas_bankVcCheck_02contrast", false);
        } else {
            orgColl.add(selCompany);
        }
        HashMap map = new HashMap();
        String companyIds = "(";
        for (int i = 0; i < orgColl.size(); ++i) {
            companyIds = i < orgColl.size() - 1 ? companyIds + "'" + orgColl.get(i).getId().toString() + "'," : companyIds + "'" + orgColl.get(i).getId().toString() + "')";
        }
        StringBuffer sql = new StringBuffer();
        ISystemStatusCtrol iSysStatusCtr = SystemStatusCtrolFactory.getLocalInstance((Context)this.ctx);
        sql.append(" select FStartPeriodID,FCurrentPeriodID,FCompanyID from T_BD_SystemStatusCtrol sysStaCtr,T_BD_SystemStatus sysSta ");
        sql.append(" where sysStaCtr.FSystemStatusID=sysSta.FID ");
        sql.append(" and sysStaCtr.FCompanyID in ");
        sql.append(companyIds);
        sql.append(" and sysSta.FName=7");
        IRowSet iRowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        HashMap<String, String> startMap = new HashMap<String, String>();
        HashMap<String, String> currMap = new HashMap<String, String>();
        HashSet<String> startSet = new HashSet<String>();
        HashSet<String> currSet = new HashSet<String>();
        if (iRowSet != null && iRowSet.size() > 0) {
            try {
                while (iRowSet.next()) {
                    String startPeriodID = iRowSet.getString("FStartPeriodID");
                    String currentPeriodID = iRowSet.getString("FCurrentPeriodID");
                    String companyID = iRowSet.getString("FCompanyID");
                    if (companyID == null || startPeriodID == null || currentPeriodID == null) continue;
                    startSet.add(startPeriodID);
                    currSet.add(currentPeriodID);
                    startMap.put(companyID, startPeriodID);
                    currMap.put(companyID, currentPeriodID);
                }
            }
            catch (SQLException e) {
                throw new SQLAccessException(e);
            }
        }
        if (startSet.size() > 0) {
            evi = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", startSet, CompareType.INCLUDE));
            evi.getSorter().add(new SorterItemInfo("periodYear"));
            evi.getSorter().add(new SorterItemInfo("periodNumber"));
            evi.setFilter(filter);
            PeriodCollection startPeriodColl = PeriodFactory.getLocalInstance((Context)this.ctx).getPeriodCollection(evi);
            HashMap<String, PeriodInfo> startList = new HashMap<String, PeriodInfo>();
            for (int i = 0; i < startPeriodColl.size(); ++i) {
                startList.put(startPeriodColl.get(i).getId().toString(), startPeriodColl.get(i));
            }
            entrySet = startMap.entrySet();
            for (Map.Entry entry : entrySet) {
                if (!startList.containsKey(entry.getValue())) continue;
                list = new ArrayList();
                list.add(startList.get(entry.getValue()));
                map.put(entry.getKey().toString(), list);
            }
        }
        if (currSet.size() > 0) {
            evi = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", currSet, CompareType.INCLUDE));
            evi.getSorter().add(new SorterItemInfo("periodYear"));
            evi.getSorter().add(new SorterItemInfo("periodNumber"));
            evi.setFilter(filter);
            PeriodCollection currentPeriodColl = PeriodFactory.getLocalInstance((Context)this.ctx).getPeriodCollection(evi);
            HashMap<String, PeriodInfo> currList = new HashMap<String, PeriodInfo>();
            for (int i = 0; i < currentPeriodColl.size(); ++i) {
                currList.put(currentPeriodColl.get(i).getId().toString(), currentPeriodColl.get(i));
            }
            entrySet = currMap.entrySet();
            for (Map.Entry entry : entrySet) {
                if (!currList.containsKey(entry.getValue())) continue;
                list = (List)map.get(entry.getKey());
                list.add(currList.get(entry.getValue()));
                map.put(entry.getKey().toString(), list);
            }
        }
        if (orgColl.size() >= 1) {
            CompanyOrgUnitInfo companyInfo = null;
            int orgCollSize = orgColl.size();
            for (int idx = orgCollSize - 1; idx >= 0; --idx) {
                companyInfo = orgColl.get(idx);
                if (map.get(companyInfo.getId().toString()) != null) continue;
                orgColl.remove(companyInfo);
            }
        }
        HashSet<String> periodTypeIDSet = new HashSet<String>();
        HashMap vcSchemeMap = new HashMap();
        String companyID = null;
        String startDate = null;
        String endDate = null;
        PeriodCollection periodCollection = null;
        PeriodInfo periodInfo = null;
        ICasWebParamFacade casWebParamFacade = CasWebParamFacadeFactory.getLocalInstance(this.ctx);
        for (int idx = 0; idx < orgColl.size(); ++idx) {
            if (orgColl.get(idx) == null || orgColl.get(idx).getId() == null) continue;
            companyID = orgColl.get(idx).getId().toString();
            if (orgColl.get(idx).getAccountPeriodType() == null || orgColl.get(idx).getAccountPeriodType().getId() == null) continue;
            periodTypeIDSet.add(orgColl.get(idx).getAccountPeriodType().getId().toString());
        }
        EntityViewInfo perView = new EntityViewInfo();
        FilterInfo perFilter = new FilterInfo();
        perFilter.getFilterItems().add(new FilterItemInfo("id", periodTypeIDSet, CompareType.INCLUDE));
        perView.setFilter(perFilter);
        perView.getSorter().add(new SorterItemInfo("id"));
        PeriodTypeCollection perColl = PeriodTypeFactory.getLocalInstance((Context)this.ctx).getPeriodTypeCollection(perView);
        if (perColl.size() != 0) {
            for (int i = 0; i < perColl.size(); ++i) {
                periodTypes.put(perColl.get(i).getId().toString(), perColl.get(i).getName().toString());
            }
        }
        periodCollection = null;
        periodInfo = null;
        if (includePeriodInfo) {
            PeriodInfo defPeriod = null;
            if (map.keySet().contains(selCompany.getId().toString())) {
                List list2 = (List)map.get(selCompany.getId().toString());
                defPeriod = (PeriodInfo)list2.get(1);
            } else {
                defPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)selCompany);
            }
            if (defPeriod == null) {
                for (int idx = 0; idx < orgColl.size() && (defPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)orgColl.get(idx))) == null; ++idx) {
                }
            }
            PeriodCollection allPeriodColl = this.batchVC_getPeriodCollByPeriodType(periodTypeIDSet);
            PeriodCollection periodColl = this.batchVC_doRemoveDoublePeriod(allPeriodColl, defPeriod);
            rstDataMap.put("baVCPeriodColl", periodColl);
            if (periodColl != null && periodColl.size() > 0) {
                if (defPeriod == null) {
                    defPeriod = periodColl.get(0);
                }
                rstDataMap.put("baVCDefPeriod", defPeriod);
                int pYear = defPeriod.getPeriodYear();
                int pNumber = defPeriod.getPeriodNumber() > 12 ? 12 : defPeriod.getPeriodNumber();
                rstDataMap.put("baVCDefStartDate", BankVCUtil.getFirstDayOfMonth(pYear, pNumber));
                rstDataMap.put("baVCDefEndDate", BankVCUtil.getLastDayOfMonth(pYear, pNumber));
                StringBuffer periodFilter = new StringBuffer();
                periodFilter.append(" id in (");
                for (int idx = 0; idx < periodColl.size(); ++idx) {
                    if (periodColl.get(idx) == null) continue;
                    if (idx > 0) {
                        periodFilter.append(",");
                    }
                    periodFilter.append("'").append(periodColl.get(idx).getId()).append("'");
                }
                periodFilter.append(") ");
                rstDataMap.put("baVCPeriodFilter", periodFilter.toString());
            } else {
                rstDataMap.put("MsgStr", CASWebUtil.getResource(this.ctx, "PleAddPeriodOfCurCompany"));
            }
        }
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)this.ctx);
        EntityViewInfo evi2 = new EntityViewInfo();
        FilterInfo filter2 = new FilterInfo();
        filter2.getFilterItems().add(new FilterItemInfo("periodType", periodTypeIDSet, CompareType.INCLUDE));
        evi2.getSorter().add(new SorterItemInfo("periodYear"));
        evi2.getSorter().add(new SorterItemInfo("periodNumber"));
        evi2.setFilter(filter2);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi2);
        HashMap<String, PeriodCollection> periodMap = new HashMap<String, PeriodCollection>();
        for (int i = 0; i < periodc.size(); ++i) {
            String periodTypeID = periodc.get(i).getPeriodType().getId().toString();
            if (periodMap.keySet().contains(periodTypeID)) {
                PeriodCollection collPer = (PeriodCollection)periodMap.get(periodTypeID);
                collPer.add(periodc.get(i));
                periodMap.put(periodTypeID, collPer);
                continue;
            }
            PeriodCollection peridoList = new PeriodCollection();
            peridoList.add(periodc.get(i));
            periodMap.put(periodTypeID, peridoList);
        }
        ArrayList<BankVCBatchShowRowVO> baVCShowVOLists = new ArrayList<BankVCBatchShowRowVO>();
        CompanyOrgUnitInfo orgUnit = null;
        HashSet<String> companySet = new HashSet<String>();
        for (int i = 0; i < orgColl.size(); ++i) {
            companySet.add(orgColl.get(i).getId().toString());
        }
        HashMap<String, QuerySolutionInfo> querySoluMap = new HashMap<String, QuerySolutionInfo>();
        if (companySet != null && parentUIName != null) {
            ArrayList solutions = new ArrayList();
            try {
                EntityViewInfo viewInfo = this.getQuerySolutionViewInfo(this.ctx, parentUIName, companySet);
                IQuerySolution iSolution = QuerySolutionFactory.getLocalInstance((Context)this.ctx);
                QuerySolutionCollection solutionCol = iSolution.getQuerySolutionCollection(viewInfo);
                for (int i = 0; i < solutionCol.size(); ++i) {
                    QuerySolutionInfo info = solutionCol.get(i);
                    if (info == null || !info.isIsUserDefaultSolu()) continue;
                    querySoluMap.put(info.getOrgID().toString(), info);
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        for (int idx = 0; idx < orgColl.size(); ++idx) {
            QuerySolutionInfo solInfo;
            List listP;
            orgUnit = orgColl.get(idx);
            if (orgUnit == null || orgUnit.getId() == null) continue;
            companyID = orgUnit.getId().toString();
            if (includePeriodInfo && (periodInfo = (PeriodInfo)(listP = (List)map.get(companyID)).get(1)) != null) {
                PeriodCollection periodColl;
                if (orgUnit.getAccountPeriodType() == null || orgUnit.getAccountPeriodType().getId() == null) {
                    ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx);
                    orgUnit = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnit.getId()));
                }
                if ((periodColl = (PeriodCollection)periodMap.get(orgUnit.getAccountPeriodType().getId().toString())) == null || periodColl.size() == 0) {
                    periodCollection = null;
                }
                if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)orgUnit)) {
                    periodCollection = periodColl;
                }
                List list3 = (List)map.get(orgUnit.getId().toString());
                PeriodInfo startPeriod = (PeriodInfo)list3.get(0);
                PeriodCollection rsltCols = new PeriodCollection();
                int n = periodColl.size();
                for (int i = 0; i < n; ++i) {
                    PeriodInfo periodInfo1 = periodColl.get(i);
                    if (!BankJournalWebUtil.isAfterStartPeriod(startPeriod, periodInfo1)) continue;
                    periodInfo1.toString();
                    rsltCols.add(periodInfo1);
                }
                periodCollection = rsltCols;
                int pYear = periodInfo.getPeriodYear();
                int pNumber = periodInfo.getPeriodNumber() > 12 ? 12 : periodInfo.getPeriodNumber();
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                startDate = dateFormat.format(periodInfo.getBeginDate());
                endDate = dateFormat.format(periodInfo.getEndDate());
            }
            BankVCBatchShowRowVO vcShowRowVO = new BankVCBatchShowRowVO();
            if (orgUnit.getName() == null) {
                orgUnit = iOrgUint.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnit.getId()));
            }
            vcShowRowVO.setAddCheckBox(false);
            vcShowRowVO.setRootRow(true);
            vcShowRowVO.setId(companyID);
            vcShowRowVO.setCompany(orgUnit);
            vcShowRowVO.setCompanyColumn(orgUnit.getName());
            String accountPeriodTypeId = orgUnit.getAccountPeriodType().getId().toString();
            vcShowRowVO.setPeriodTypeColumn(periodTypes.get(accountPeriodTypeId).toString());
            if (periodInfo == null) {
                vcShowRowVO.setPeriodTypeId("false");
            } else {
                vcShowRowVO.setPeriodTypeId(accountPeriodTypeId);
            }
            if (periodInfo != null && periodCollection != null) {
                vcShowRowVO.setPeriodInfo(periodInfo);
                vcShowRowVO.setPeriodCollection(periodCollection);
                vcShowRowVO.setStartDate(startDate);
                vcShowRowVO.setEndDate(endDate);
            }
            if ((solInfo = (QuerySolutionInfo)querySoluMap.get(companyID)) != null) {
                vcShowRowVO.setSchemeColumn("(\u9ed8\u8ba4)" + solInfo.getName());
                HashMap data = null;
                String customerParams = null;
                QueryPanelCollection queryPanels = solInfo.getQueryPanelInfo();
                for (int i0 = 0; i0 < queryPanels.size(); ++i0) {
                    QueryPanelInfo info = queryPanels.get(i0);
                    customerParams = info.getCustomerParams();
                }
                if (customerParams != null) {
                    CustomerParams cp = CustomerParams.getCustomerParams2(customerParams);
                    data = cp.getCustomerParamsHashMap();
                }
                vcShowRowVO.setScheme(data);
                vcShowRowVO.setSolutionInfo(solInfo);
            }
            baVCShowVOLists.add(vcShowRowVO);
            if (!includeAccBank) continue;
            this.batchVC_doArrangeAccountBankOfCompany(rstDataMap, baVCShowVOLists, orgUnit);
        }
        rstDataMap.put("baVCOrgRowList", baVCShowVOLists.toArray());
        return baVCShowVOLists;
    }

    public EntityViewInfo getQuerySolutionViewInfo(Context ctx, String parentUIName, Set companySet) throws EASBizException, BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("queryObjectName", null));
        filter.getFilterItems().add(new FilterItemInfo("parentUIName", (Object)parentUIName));
        if (companySet != null) {
            filter.getFilterItems().add(new FilterItemInfo("shareType", (Object)2));
            filter.getFilterItems().add(new FilterItemInfo("orgID", (Object)companySet, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("shareType", (Object)16));
            filter.getFilterItems().add(new FilterItemInfo("owner", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()));
        }
        boolean isShare = parentUIName.toLowerCase(Locale.ENGLISH).endsWith("share");
        if (!isShare) {
            CompanyOrgUnitInfo orgInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
            filter.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgInfo.getId().toString()));
        }
        viewInfo.setFilter(filter);
        SorterItemCollection sortCol = new SorterItemCollection();
        sortCol.add(new SorterItemInfo("name"));
        viewInfo.setSorter(sortCol);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.*"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.id"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.queryPanelType"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.panelClassName"));
        viewInfo.getSelector().addObjectCollection((IObjectCollection)sic);
        return viewInfo;
    }

    private void batchVC_doArrangeAccountBankOfCompany(Map rstDataMap, List<BankVCBatchShowRowVO> baVCShowVOLists, CompanyOrgUnitInfo orgUnit) throws BOSException, EASBizException {
        if (orgUnit == null || orgUnit.getId() == null) {
            return;
        }
        String companyID = orgUnit.getId().toString();
        CurrencyCollection currencyColl = CASWebHelper.getCurrencyColl(this.ctx);
        boolean includeColsed = false;
        HashMap rstMap = new HashMap();
        Map settingMap = this.getVcSolMap_OfBatchVC(orgUnit, this.isShare ? "bizCommonQuery.advancedQuery.com.kingdee.eas.fi.cas.FI_CAS_BankVCSchemeBatchSettingUI_share" : "bizCommonQuery.advancedQuery.com.kingdee.eas.fi.cas.FI_CAS_BankVCSchemeBatchSettingUI");
        if (settingMap != null) {
            includeColsed = Boolean.valueOf((String)settingMap.get("chkIncludeCanceled"));
        }
        AccountBankCollection acctBankColls = CASWebHelper.getAccountBankCollection(this.ctx, companyID, (String)rstDataMap.get("bankAccts"), includeColsed);
        AccountBankInfo accBankInfo = null;
        CurrencyInfo currencyInfo = null;
        for (int idx = 0; idx < acctBankColls.size(); ++idx) {
            accBankInfo = acctBankColls.get(idx);
            if (accBankInfo == null) continue;
            if (!EmptyUtil.isEmpty((CoreBaseInfo)accBankInfo) && accBankInfo.isIsByCurrency()) {
                currencyInfo = accBankInfo.getCurrency();
                this.batchVC_doMakePageShowData(baVCShowVOLists, accBankInfo, currencyInfo, orgUnit);
                continue;
            }
            List<String> validCurrencyIDs = this.getValidCurrencyIDs_OfBankVC(orgUnit, accBankInfo);
            for (int p = 0; p < currencyColl.size(); ++p) {
                currencyInfo = currencyColl.get(p);
                if (currencyInfo == null || !validCurrencyIDs.contains(currencyInfo.getId().toString())) continue;
                this.batchVC_doMakePageShowData(baVCShowVOLists, accBankInfo, currencyInfo, orgUnit);
            }
        }
    }

    private void batchVC_doMakePageShowData(List<BankVCBatchShowRowVO> baVCShowVOLists, AccountBankInfo accBankInfo, CurrencyInfo currencyInfo, CompanyOrgUnitInfo company) {
        BankVCBatchShowRowVO vcShowRowVO = new BankVCBatchShowRowVO();
        vcShowRowVO.setAddCheckBox(true);
        vcShowRowVO.setRootRow(false);
        StringBuffer columnStr = new StringBuffer();
        columnStr.append("          ").append(accBankInfo.getName()).append(" (").append(accBankInfo.getBank().getName()).append("  ").append(accBankInfo.getBankAccountNumber()).append(")");
        vcShowRowVO.setCompanyColumn(columnStr.toString());
        vcShowRowVO.setCompany(company);
        vcShowRowVO.setAccBank(accBankInfo);
        vcShowRowVO.setCurrencyColumn(currencyInfo.getName());
        vcShowRowVO.setCurrency(currencyInfo);
        vcShowRowVO.setSchemeColumn("");
        vcShowRowVO.setRowIDColumn(vcShowRowVO.getDynamicRowIDKey());
        vcShowRowVO.setId(vcShowRowVO.getRowIDColumn());
        baVCShowVOLists.add(vcShowRowVO);
    }

    private UserOptionInfo batchVC_getDefaultUserOption_OfBatchVC(String companyID) throws BOSException {
        IUserOption iUserOption = UserOptionFactory.getLocalInstance((Context)this.ctx);
        UserInfo curUser = this.contextHelper.getCurrentUser();
        EntityViewInfo schemeView = new EntityViewInfo();
        FilterInfo schemeFilter = new FilterInfo();
        schemeFilter.appendFilterItem("optKey", (Object)"com.kingdee.eas.dynamic.web.BankVCSchemeSettingUI");
        schemeFilter.getFilterItems().add(new FilterItemInfo("name", (Object)"Hello%", CompareType.LIKE));
        schemeFilter.appendFilterItem("company.id", (Object)companyID);
        schemeFilter.appendFilterItem("createUser.id", (Object)curUser.getId().toString());
        schemeView.setFilter(schemeFilter);
        UserOptionCollection userOptionColl = iUserOption.getUserOptionCollection(schemeView);
        if (userOptionColl == null || userOptionColl.size() == 0) {
            return null;
        }
        return userOptionColl.get(0);
    }

    private PeriodCollection batchVC_getPeriodCollByPeriodType(Set<String> peridTypeIdSet) throws BOSException, EASBizException {
        if (peridTypeIdSet == null || peridTypeIdSet.size() == 0) {
            return null;
        }
        StringBuffer pIdSb = new StringBuffer();
        for (String pTypeID : peridTypeIdSet) {
            if (pIdSb.length() > 0) {
                pIdSb.append(",");
            }
            pIdSb.append("'").append(pTypeID).append("'");
        }
        String sql = " SELECT FID, (FPeriodYear * 100 + FPeriodNumber) as periodStr FROM T_BD_Period  WHERE FTypeID in (" + pIdSb.toString() + ") order by periodStr desc, FPeriodYear asc, FPeriodNumber asc ";
        PreparedStatement stmt = null;
        Connection conn = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            conn = EJBFactory.getConnnection((Context)this.ctx);
            stmt = conn.prepareStatement(sql);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                list.add(rs.getString(1));
            }
        }
        catch (SQLException ex) {
            try {
                ex.printStackTrace();
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt);
        SQLUtils.cleanup((Connection)conn);
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)this.ctx);
        PeriodCollection periodc = new PeriodCollection();
        for (int idx = 0; idx < list.size(); ++idx) {
            periodc.add(iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(list.get(idx).toString())));
        }
        return periodc;
    }

    private PeriodCollection batchVC_doRemoveDoublePeriod(PeriodCollection periodColl, PeriodInfo defPeriod) {
        if (periodColl == null || periodColl.size() <= 0) {
            return periodColl;
        }
        PeriodCollection newPeriodColl = new PeriodCollection();
        PeriodInfo tmpPeriod = null;
        if (defPeriod != null && defPeriod.getPeriodType() != null && defPeriod.getPeriodType().getId() != null) {
            String defPeriodTypeID = defPeriod.getPeriodType().getId().toString();
            for (int idx = 0; idx < periodColl.size(); ++idx) {
                tmpPeriod = periodColl.get(idx);
                if (tmpPeriod == null || tmpPeriod.getPeriodType() == null || tmpPeriod.getPeriodType().getId() == null || !defPeriodTypeID.equals(tmpPeriod.getPeriodType().getId().toString())) continue;
                this.batchVC_doRemoveDoublePeriod_Add(newPeriodColl, tmpPeriod);
            }
        }
        for (int idx = 0; idx < periodColl.size(); ++idx) {
            tmpPeriod = periodColl.get(idx);
            this.batchVC_doRemoveDoublePeriod_Add(newPeriodColl, tmpPeriod);
        }
        return newPeriodColl;
    }

    private void batchVC_doRemoveDoublePeriod_Add(PeriodCollection periodColl, PeriodInfo addPeriod) {
        if (addPeriod == null) {
            return;
        }
        if (periodColl == null) {
            periodColl = new PeriodCollection();
        }
        boolean isAddIt = true;
        for (int min = 0; min < periodColl.size(); ++min) {
            if (addPeriod.getPeriodYear() != periodColl.get(min).getPeriodYear() || addPeriod.getPeriodNumber() != periodColl.get(min).getPeriodNumber()) continue;
            isAddIt = false;
            break;
        }
        if (isAddIt) {
            periodColl.add(addPeriod);
        }
    }

    protected void vcSetting_doCopyGUIExistVCSetting(CompanyOrgUnitInfo orgInfo) throws BOSException, EASBizException {
        String curCompanyID = orgInfo.getId().toString();
        String curUserID = this.contextHelper.getCurrentUser().getId().toString();
        IUserOption iUserOption = UserOptionFactory.getLocalInstance((Context)this.ctx);
        StringBuffer comfilter = new StringBuffer();
        comfilter.append("company.id='").append(curCompanyID).append("' ");
        comfilter.append("and createUser.id='").append(curUserID).append("' ");
        StringBuffer selfilter = new StringBuffer();
        selfilter.append("select * where optKey='").append("com.kingdee.eas.fi.cas.client.BankVcCheckSettingUI").append("' ");
        selfilter.append("and name='").append("Hello").append("' ");
        selfilter.append("and ").append(comfilter.toString());
        UserOptionCollection comUserOptionColl = iUserOption.getUserOptionCollection(selfilter.toString());
        StringBuffer newfilter = new StringBuffer();
        newfilter.append("select * where optKey='").append("com.kingdee.eas.dynamic.web.BankVCSchemeSettingUI").append("' ");
        newfilter.append("and name like '").append("Hello").append("%' ");
        newfilter.append("and ").append(comfilter.toString());
        UserOptionCollection newUserOptionColl = iUserOption.getUserOptionCollection(newfilter.toString());
        if (comUserOptionColl != null && comUserOptionColl.get(0) != null && (newUserOptionColl == null || newUserOptionColl.size() == 0)) {
            UserOptionInfo comUserOptionInfo = comUserOptionColl.get(0);
            comUserOptionInfo.setId(null);
            comUserOptionInfo.setOptKey("com.kingdee.eas.dynamic.web.BankVCSchemeSettingUI");
            comUserOptionInfo.setName("Hello" + BankVCUtil.getUserOptWEBName(this.ctx));
            iUserOption.submit((CoreBaseInfo)comUserOptionInfo);
        }
    }

    protected List<BankVCUserOptionVO> vcSetting_getBatchVCSettingData(Map rstDataMap, BatchVCSettingVO queryVO) throws BOSException {
        UserOptionCollection userOptionColl = this.vcSetting_getUserOptionCollection(queryVO);
        ArrayList<BankVCUserOptionVO> rstUserOptions = new ArrayList<BankVCUserOptionVO>();
        for (int idx = 0; idx < userOptionColl.size(); ++idx) {
            UserOptionInfo userOptionInfo = userOptionColl.get(idx);
            rstUserOptions.add(BankVCUserOptionVO.InfoToVO(userOptionInfo));
        }
        rstDataMap.put("baVCUserOptionSetting", rstUserOptions);
        return rstUserOptions;
    }

    protected UserOptionCollection vcSetting_getUserOptionCollection(BatchVCSettingVO queryVO) throws BOSException {
        String curCompanyID = queryVO.getCompanyId();
        String curUserID = this.contextHelper.getCurrentUser().getId().toString();
        IUserOption iUserOption = UserOptionFactory.getLocalInstance((Context)this.ctx);
        StringBuffer queryfilter = new StringBuffer();
        queryfilter.append("select * where optKey='").append("com.kingdee.eas.dynamic.web.BankVCSchemeSettingUI").append("' ");
        queryfilter.append("and company.id='").append(curCompanyID).append("' ");
        queryfilter.append("and createUser.id='").append(curUserID).append("' ");
        if (!com.kingdee.bos.ctrl.common.util.StringUtil.isEmptyString((String)queryVO.getSchemeName())) {
            queryfilter.append("and name='").append(queryVO.getSchemeName()).append("' ");
        }
        return iUserOption.getUserOptionCollection(queryfilter.toString());
    }

    protected int[] batchVC_getVCPeriod_Array(BatchVcSubFilterVO batchVCFilterVO) {
        int[] vcPeriodArray = new int[]{0, 0};
        if (batchVCFilterVO == null) {
            return vcPeriodArray;
        }
        if ("periodWay".equals(batchVCFilterVO.getPeriodWay())) {
            String periodID = batchVCFilterVO.getPeriodId();
            PeriodInfo vcPeriod = null;
            try {
                vcPeriod = PeriodFactory.getLocalInstance((Context)this.ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(periodID));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (vcPeriod != null) {
                vcPeriodArray[0] = vcPeriod.getPeriodYear();
                vcPeriodArray[1] = vcPeriod.getPeriodNumber();
            }
        } else {
            Date endDate = batchVCFilterVO.getEndDate();
            if (endDate != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(endDate);
                vcPeriodArray[0] = cal.get(1);
                vcPeriodArray[1] = cal.get(2) + 1;
            }
        }
        return vcPeriodArray;
    }

    protected List<BankVCBatchRstVO> batchVC_doBatchVC_Process(Map rstDataMap, List<BankVCBatchShowRowVO> batchVCRows, BatchVcSubFilterVO filterVO, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        if (filterVO == null) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(this.ctx, "PleSelecedQueryFilter"));
            return null;
        }
        PeriodInfo period = null;
        if (filterVO.getPeriodId() != null) {
            period = PeriodFactory.getLocalInstance((Context)this.ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(filterVO.getPeriodId()));
        }
        ArrayList<BankVCBatchRstVO> vcRstVOs = new ArrayList<BankVCBatchRstVO>();
        String bankAllID = null;
        for (int idx = 0; idx < batchVCRows.size(); ++idx) {
            String msgStr;
            if (batchVCRows.get(idx) == null || batchVCRows.get(idx).isRootRow()) continue;
            bankAllID = batchVCRows.get(idx).getDynamicRowIDKey();
            BankVCBatchRstVO vcRstVO = new BankVCBatchRstVO();
            vcRstVO.setKeyID(bankAllID);
            BankVCFilterVO autoVCFilterVO = BankVCBatchShowRowVO.getBankVCFilterVOByDynamicRowIDKey(bankAllID);
            autoVCFilterVO.setCompany(company);
            autoVCFilterVO.setCompanyID(company.getId().toString());
            autoVCFilterVO.setStartDate(filterVO.getStartDate());
            autoVCFilterVO.setEndDate(filterVO.getEndDate());
            autoVCFilterVO.setPeriodWay(filterVO.getPeriodWay());
            if (period != null) {
                autoVCFilterVO.setPeriodYear(period.getPeriodYear());
                autoVCFilterVO.setPeriodNum(period.getPeriodNumber());
            }
            try {
                HashMap<String, Boolean> vcRstMap = new HashMap<String, Boolean>();
                if (rstDataMap.get("isIntelligentBankVC") != null) {
                    vcRstMap.put("isIntelligentBankVC", (Boolean)rstDataMap.get("isIntelligentBankVC"));
                }
                this.getBankVCAutoCheckResult(vcRstMap, autoVCFilterVO, company, true, true);
                msgStr = (String)vcRstMap.get("MsgStr");
                if (msgStr != null && msgStr.length() > 0) {
                    vcRstVO.setVcMsgStr(msgStr);
                }
                boolean isBalance = true;
                this.doArrangeQueryFilters(vcRstMap, autoVCFilterVO);
                if (vcRstMap.get("VcBankFilter") != null) {
                    IBankStatement iBankStatement;
                    BankStatementCollection bankStatementColl;
                    String vcBankFilterSql = (String)vcRstMap.get("VcBankFilter");
                    if (vcBankFilterSql.toUpperCase().indexOf("WHERE") < 0) {
                        vcBankFilterSql = " select id where " + vcBankFilterSql;
                    }
                    if ((bankStatementColl = (iBankStatement = BankStatementFactory.getLocalInstance(this.ctx)).getBankStatementCollection(vcBankFilterSql)) != null && bankStatementColl.size() > 0) {
                        isBalance = false;
                    }
                }
                if (vcRstMap.get("VcJournalFilter") != null) {
                    JournalCollection journalColl;
                    String vcJournalFilterSql = (String)vcRstMap.get("VcJournalFilter");
                    if (vcJournalFilterSql.toUpperCase().indexOf("WHERE") < 0) {
                        vcJournalFilterSql = " select id where " + vcJournalFilterSql;
                    }
                    if ((journalColl = JournalFactory.getLocalInstance(this.ctx).getJournalCollection(vcJournalFilterSql)) != null && journalColl.size() > 0) {
                        isBalance = false;
                    }
                }
                String equal = CASWebUtil.getResource(this.ctx, "BankVC_CN_EQUAL");
                String unequal = CASWebUtil.getResource(this.ctx, "BankVC_CN_UNEQUAL");
                if (this.ctx.getLocale() == LocaleUtils.locale_l1) {
                    equal = "Balanced";
                    unequal = "Not in Balance";
                }
                String vcStatus = isBalance ? equal : unequal;
                vcRstVO.setVcStatus(vcStatus);
            }
            catch (Exception e) {
                msgStr = e.getMessage();
                vcRstVO.setVcMsgStr(msgStr);
                e.printStackTrace();
            }
            vcRstVOs.add(vcRstVO);
        }
        rstDataMap.put("baVCCheckResult", vcRstVOs);
        return vcRstVOs;
    }

    protected void balanceAdj_doArrangeFilterVO_ToCompleted(Map rstDataMap, BankVCAdjustmentFilterVO filterVO) throws EASBizException, BOSException {
        FilterInfo filter;
        EntityViewInfo view;
        Set idSet;
        String[] ids;
        if (filterVO == null) {
            return;
        }
        if (!EmptyUtil.isEmpty((String)filterVO.getCompanyID())) {
            ids = filterVO.getCompanyID().split(",");
            idSet = FMHelper.Array2Set((String[])ids);
            view = new EntityViewInfo();
            filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            CompanyOrgUnitCollection colls = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitCollection(view);
            CompanyOrgUnitInfo[] org = new CompanyOrgUnitInfo[colls.size()];
            for (int index = 0; index < colls.size(); ++index) {
                org[index] = colls.get(index);
            }
            filterVO.setCompany(org);
        }
        rstDataMap.put("companyOrg", filterVO.getCompany());
        rstDataMap.put("defaultFIUnit", filterVO.getCompany());
        rstDataMap.put("curCompanyForUnShare", filterVO.getCompany());
        if (filterVO.getAcctBankID() != null && (ids = filterVO.getAcctBankID().split(",")).length > 0) {
            idSet = FMHelper.Array2Set((String[])ids);
            view = new EntityViewInfo();
            filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            String[] orgs = filterVO.getCompanyID().split(",");
            Set orgSet = FMHelper.Array2Set((String[])orgs);
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)orgSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("isBank", (Object)FMConstants.TRUE));
            filter.getFilterItems().add(new FilterItemInfo("shareType", (Object)0, CompareType.EQUALS));
            EntityViewInfo viewShare = new EntityViewInfo();
            FilterInfo filterShare = new FilterInfo();
            filterShare.getFilterItems().add(new FilterItemInfo("shareBalanceOfAcctCompany.id", (Object)orgSet, CompareType.INCLUDE));
            viewShare.setFilter(filterShare);
            SharedAcctCollection coll = SharedAcctFactory.getRemoteInstance().getSharedAcctCollection(viewShare);
            HashSet<String> sharedAcctSet = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                SharedAcctInfo sharedAcct = coll.get(i);
                sharedAcctSet.add(sharedAcct.getBankAccount().getId().toString());
            }
            if (!EmptyUtil.isEmpty(sharedAcctSet)) {
                filter.getFilterItems().add(new FilterItemInfo("id", sharedAcctSet, CompareType.INCLUDE));
                filter.setMaskString("#0 and #1 and #2 and (#3 or #4)");
            }
            SelectorItemCollection selectorColl = new SelectorItemCollection();
            view.setSelector(selectorColl);
            selectorColl.add(new SelectorItemInfo("*"));
            selectorColl.add(new SelectorItemInfo("account.*"));
            AccountBankCollection colls = AccountBankFactory.getLocalInstance((Context)this.ctx).getAccountBankCollection(view);
            AccountBankInfo[] acctBank = new AccountBankInfo[colls.size()];
            for (int index = 0; index < colls.size(); ++index) {
                acctBank[index] = colls.get(index);
            }
            filterVO.setAcctBank(acctBank);
        }
        rstDataMap.put("accountBank", filterVO.getAcctBank());
        rstDataMap.put("curAcctBank", filterVO.getAcctBank());
        if (filterVO.getCurrencyID() != null && BOSUuid.isValid((String)filterVO.getCurrencyID(), (boolean)true)) {
            ObjectUuidPK ipk = new ObjectUuidPK(filterVO.getCurrencyID());
            filterVO.setCurrency(CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo((IObjectPK)ipk));
        }
        rstDataMap.put("currencyInfo", filterVO.getCurrency());
        rstDataMap.put("currency", filterVO.getCurrency());
        if (filterVO.getAcctBank() != null && filterVO.getAcctBank().length > 0) {
            rstDataMap.put("currencyDisable", filterVO.getAcctBank()[0].isIsByCurrency());
        }
        if (filterVO.getCurrency() != null) {
            rstDataMap.put("precision", filterVO.getCurrency().getPrecision());
        }
        if (filterVO.getPeriodID() != null && BOSUuid.isValid((String)filterVO.getPeriodID(), (boolean)true)) {
            IPeriod iperiod = PeriodFactory.getLocalInstance((Context)this.ctx);
            PeriodInfo period = iperiod.getPeriodInfo((IObjectPK)new ObjectUuidPK(filterVO.getPeriodID()));
            String oql = "select * where periodYear = '" + period.getPeriodYear() + "' and periodNumber = '" + period.getPeriodNumber() + "' and periodType.id = '" + period.getPeriodType().getId().toString() + "' ";
            PeriodCollection periodColl = iperiod.getPeriodCollection(oql);
            if (periodColl != null && periodColl.size() > 0 && periodColl.get(0) != null) {
                filterVO.setPeriod(periodColl.get(0));
                filterVO.setPeriodID(periodColl.get(0).getId().toString());
            } else {
                filterVO.setPeriod(period);
            }
        }
        rstDataMap.put("periodInfo", filterVO.getPeriod());
        rstDataMap.put("curPeriod", filterVO.getPeriod());
        PeriodCollection periodColl = new PeriodCollection();
        if (filterVO.getPeriod() != null) {
            periodColl = CASWebHelper.getPeriodColls(this.ctx, filterVO.getCompany()[0]);
        }
        rstDataMap.put("periodColl", periodColl);
        if (filterVO.getPeriod() != null) {
            Object[] args = new String[]{String.valueOf(filterVO.getPeriod().getPeriodYear()), String.valueOf(filterVO.getPeriod().getPeriodNumber())};
            String periodStr = MessageFormat.format(EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period", (Locale)this.ctx.getLocale()), args);
            rstDataMap.put("periodStr", periodStr);
        }
        rstDataMap.put("auditState", filterVO.getAuditState());
        rstDataMap.put("checkBoxIsVerify", filterVO.isCheckBoxIsVerify());
        if (filterVO.getCompanyID() != null && filterVO.getPeriod() != null) {
            String acctTableId = this.balanceAdj_getDisplayAcctTable(filterVO.getCompany()[0].getId().toString(), null, filterVO.getPeriod().getPeriodYear(), filterVO.getPeriod().getPeriodNumber(), filterVO.getPeriod().getPeriodYear(), filterVO.getPeriod().getPeriodNumber());
            filterVO.setAcctTableId(acctTableId);
        }
    }

    private String balanceAdj_getDisplayAcctTable(String companyId, String accountTableId, int beginYear, int beginMonth, int endYear, int endMonth) throws EASBizException, BOSException {
        AccountRefContrastInfo info;
        CompanyOrgUnitInfo companyInfo = null;
        if (com.kingdee.bos.ctrl.common.util.StringUtil.isEmptyString((String)companyId)) {
            companyInfo = this.contextHelper.getCurrentCompany();
            companyId = companyInfo.getId().toString();
        }
        ObjectUuidPK companyPK = new ObjectUuidPK(companyId);
        if (com.kingdee.bos.ctrl.common.util.StringUtil.isEmptyString((String)accountTableId)) {
            if (companyInfo == null) {
                companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)companyPK);
            }
            accountTableId = companyInfo.getAccountTable().getId().toString();
        }
        PeriodInfo beginPeriod = PeriodUtils.getPeriodInfo((Context)this.ctx, (int)beginYear, (int)beginMonth, (IObjectPK)companyPK);
        PeriodInfo endPeriod = PeriodUtils.getPeriodInfo((Context)this.ctx, (int)endYear, (int)endMonth, (IObjectPK)companyPK);
        if (EmptyUtil.isEmpty((CoreBaseInfo)beginPeriod) || EmptyUtil.isEmpty((CoreBaseInfo)endPeriod)) {
            throw new CasException(CasException.STARTPERIODNULL);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("enabledPeriod.endDate", (Object)DateTimeUtils.truncateDate((Date)beginPeriod.getBeginDate()), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("enabledPeriod.endDate", (Object)DateTimeUtils.truncateDate((Date)endPeriod.getEndDate()), CompareType.LESS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        AccountRefContrastCollection coll = AccountRefContrastFactory.getLocalInstance((Context)this.ctx).getAccountRefContrastCollection(evi);
        if (companyInfo != null && coll != null && coll.size() > 0) {
            AccountRefContrastInfo info2 = null;
            String acctTable = "";
            for (int i = 0; i < coll.size(); ++i) {
                info2 = coll.get(i);
                if (info2.getRefType() != null && 1 == info2.getRefType().getValue()) {
                    NumericExceptionSubItem HASCOMPANYADJUSTACCT = new NumericExceptionSubItem("012", "HasCompanyAdjustAcct");
                    throw new CasException(HASCOMPANYADJUSTACCT, new Object[]{companyInfo.getName()});
                }
                if (info2.getRefType() == null || 2 == info2.getRefType().getValue()) continue;
                acctTable = info2.getDisabledAcctTable().getId().toString();
            }
            if (EmptyUtil.isEmpty((String)acctTable)) {
                acctTable = coll.get(0).getEnabledAcctTable().getId().toString();
            }
            return acctTable;
        }
        if (endPeriod.isIsAdjustPeriod() && (info = AccountRefContrastFactory.getLocalInstance((Context)this.ctx).getLastAcctInfo(companyId, accountTableId, endYear, endMonth)).getEnabledPeriod() != null && info.getEnabledPeriod().getId().equals((Object)endPeriod.getId())) {
            return info.getDisabledAcctTable() == null ? null : info.getDisabledAcctTable().getId().toString();
        }
        return AccountTools.getCurrentAcctTable((Context)this.ctx, (String)companyId, (String)accountTableId, (int)endYear, (int)endMonth);
    }

    protected BankBalanceCondition balanceAdj_doArrangeCondition(BankVCAdjustmentFilterVO filterVO) {
        BankBalanceCondition condition = new BankBalanceCondition();
        condition.setCompanyInfo(filterVO.getCompany()[0]);
        condition.setBankId(filterVO.getAcctBankID());
        condition.setCurrencyId(filterVO.getCurrencyID());
        condition.setPeriodId(filterVO.getPeriodID());
        condition.setIsDetail(true);
        condition.setIsForInit(false);
        return condition;
    }

    protected void outStanding_doArrangeFilterVO_ToCompleted(Map rstDataMap, BankVCOutStandingFilterVO filterVO) throws EASBizException, BOSException {
        ObjectUuidPK ipk;
        if (filterVO == null) {
            return;
        }
        if (filterVO.getCompanyID() != null && BOSUuid.isValid((String)filterVO.getCompanyID(), (boolean)true)) {
            ipk = new ObjectUuidPK(filterVO.getCompanyID());
            filterVO.setCompany(CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)ipk));
        }
        rstDataMap.put("companyOrg", filterVO.getCompany());
        rstDataMap.put("defaultFIUnit", filterVO.getCompany());
        rstDataMap.put("curCompanyForUnShare", filterVO.getCompany());
        if (filterVO.getAcctBankID() != null && BOSUuid.isValid((String)filterVO.getAcctBankID(), (boolean)true)) {
            ipk = new ObjectUuidPK(filterVO.getAcctBankID());
            SelectorItemCollection selectorColl = new SelectorItemCollection();
            selectorColl.add(new SelectorItemInfo("*"));
            selectorColl.add(new SelectorItemInfo("account.*"));
            filterVO.setAcctBank(AccountBankFactory.getLocalInstance((Context)this.ctx).getAccountBankInfo((IObjectPK)ipk, selectorColl));
        }
        rstDataMap.put("accountBank", filterVO.getAcctBank());
        rstDataMap.put("curAcctBank", filterVO.getAcctBank());
        if (filterVO.getCurrencyID() != null && BOSUuid.isValid((String)filterVO.getCurrencyID(), (boolean)true)) {
            ipk = new ObjectUuidPK(filterVO.getCurrencyID());
            filterVO.setCurrency(CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo((IObjectPK)ipk));
        }
        rstDataMap.put("currencyInfo", filterVO.getCurrency());
        rstDataMap.put("currency", filterVO.getCurrency());
        if (filterVO.getAcctBank() != null) {
            rstDataMap.put("currencyDisable", filterVO.getAcctBank().isIsByCurrency());
        }
        rstDataMap.put("precision", filterVO.getCurrency().getPrecision());
        if (filterVO.getPeriodID() != null && BOSUuid.isValid((String)filterVO.getPeriodID(), (boolean)true)) {
            IPeriod iperiod = PeriodFactory.getLocalInstance((Context)this.ctx);
            PeriodInfo period = iperiod.getPeriodInfo((IObjectPK)new ObjectUuidPK(filterVO.getPeriodID()));
            String oql = "select * where periodYear = '" + period.getPeriodYear() + "' and periodNumber = '" + period.getPeriodNumber() + "' and periodType.id = '" + period.getPeriodType().getId().toString() + "' ";
            PeriodCollection periodColl = iperiod.getPeriodCollection(oql);
            if (periodColl != null && periodColl.size() > 0 && periodColl.get(0) != null) {
                filterVO.setPeriod(periodColl.get(0));
                filterVO.setPeriodID(periodColl.get(0).getId().toString());
            } else {
                filterVO.setPeriod(period);
            }
        }
        rstDataMap.put("periodInfo", filterVO.getPeriod());
        rstDataMap.put("curPeriod", filterVO.getPeriod());
        PeriodCollection periodColl = new PeriodCollection();
        if (filterVO.getPeriod() != null) {
            periodColl = CASWebHelper.getPeriodColls(this.ctx, filterVO.getCompany());
        }
        rstDataMap.put("periodColl", periodColl);
        Object[] args = new String[]{String.valueOf(filterVO.getPeriod().getPeriodYear()), String.valueOf(filterVO.getPeriod().getPeriodNumber())};
        String periodStr = MessageFormat.format(EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period", (Locale)this.ctx.getLocale()), args);
        rstDataMap.put("periodStr", periodStr);
        rstDataMap.put("greater", filterVO.getGreater());
        rstDataMap.put("isChkShowAmount", filterVO.getShowAmount());
        rstDataMap.put("isChkShowRecPay", filterVO.getShowRecPay());
        rstDataMap.put("isChkCancleAccount", filterVO.getChkCancleAccount());
        String acctTableId = this.balanceAdj_getDisplayAcctTable(filterVO.getCompanyID(), null, filterVO.getPeriod().getPeriodYear(), filterVO.getPeriod().getPeriodNumber(), filterVO.getPeriod().getPeriodYear(), filterVO.getPeriod().getPeriodNumber());
        filterVO.setAcctTableId(acctTableId);
    }

    protected FilterInfo outStanding_VO2Filter(BankVCOutStandingFilterVO vo) {
        FilterInfo filter = new FilterInfo();
        try {
            CompanyOrgUnitInfo companyInfo;
            IAccountBank iAccountBank = AccountBankFactory.getLocalInstance((Context)this.ctx);
            AccountBankInfo accBankInfo = vo.getAcctBank();
            if (EmptyUtil.isEmpty((CoreBaseInfo)accBankInfo)) {
                try {
                    accBankInfo = iAccountBank.getAccountBankInfo((IObjectPK)new ObjectUuidPK(vo.getAcctBankID()));
                }
                catch (EASBizException e1) {
                    e1.printStackTrace();
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                }
            }
            if (EmptyUtil.isEmpty((CoreBaseInfo)(companyInfo = vo.getCompany()))) {
                companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(vo.getCompanyID()));
            }
            if (this.isShareBalanceOfAcctCompany(accBankInfo, companyInfo.getId().toString())) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter1 = new FilterInfo();
                filter1.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)accBankInfo.getBankAccountNumber(), CompareType.EQUALS));
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("name"));
                selector.add(new SelectorItemInfo("number"));
                selector.add(new SelectorItemInfo("company.id"));
                selector.add(new SelectorItemInfo("company.name"));
                selector.add(new SelectorItemInfo("company.number"));
                view.setSelector(selector);
                view.setFilter(filter1);
                AccountBankCollection acctColl = iAccountBank.getAccountBankCollection(view);
                HashSet<String> bankSet = new HashSet<String>();
                HashSet<String> companySet = new HashSet<String>();
                for (int i = 0; i < acctColl.size(); ++i) {
                    AccountBankInfo tmp = acctColl.get(i);
                    bankSet.add(tmp.getId().toString());
                    companySet.add(tmp.getCompany().getId().toString());
                }
                filter.getFilterItems().add(new FilterItemInfo("accountBank.id", bankSet, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)vo.getCurrencyID()));
                filter.getFilterItems().add(new FilterItemInfo("company.id", companySet, CompareType.INCLUDE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)vo.getAcctBankID()));
                filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)vo.getCurrencyID()));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId().toString()));
            }
            PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((int)vo.getPeriod().getPeriodYear(), (int)vo.getPeriod().getPeriodNumber(), (CompanyOrgUnitInfo)companyInfo);
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(periodInfo.getEndDate());
            int offsetDays = 0;
            PeriodInfo prePeriodInfo = periodInfo;
            if (prePeriodInfo != null && vo.getGreater() > 0) {
                long days = DateUtil.dateDiff((String)"d", (Date)prePeriodInfo.getBeginDate(), (Date)prePeriodInfo.getEndDate());
                offsetDays = (int)((long)offsetDays + (days + 1L) * (long)vo.getGreater());
            }
            cal.set(5, cal.get(5) - offsetDays);
            filter.getFilterItems().add(new FilterItemInfo("createDate", (Object)DateTimeUtils.truncateDate((Date)cal.getTime()), CompareType.LESS_EQUALS));
        }
        catch (EASBizException e) {
            SysUtil.abort();
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        return filter;
    }

    protected void outStanding_doGetRstData(Map rstDataMap, BankVCOutStandingFilterVO vo) throws BOSException {
        FilterInfo queryFilter = this.outStanding_VO2Filter(vo);
        EntityViewInfo queryView = new EntityViewInfo();
        queryView.setFilter(queryFilter);
        MetaDataPK metaEnt = MetaDataPK.create((String)"com.kingdee.eas.fi.cas", (String)"OutStandingEntUnreachQuery");
        IQueryExecutor execEnt = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)metaEnt);
        execEnt.setObjectView(queryView);
        execEnt.option().isAutoTranslateEnum = true;
        IRowSet rowSetEnt = execEnt.executeQuery();
        List<Map<String, Object>> entOutStandList = this.outStanding_doArrange2ShowList(rowSetEnt, vo, false);
        rstDataMap.put("entOutStandUnreach", entOutStandList);
        MetaDataPK metaBank = MetaDataPK.create((String)"com.kingdee.eas.fi.cas", (String)"OutStandingBankUnreachQuery");
        IQueryExecutor execBank = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)metaBank);
        execBank.setObjectView(queryView);
        execBank.option().isAutoTranslateEnum = true;
        IRowSet rowSetBank = execBank.executeQuery();
        List<Map<String, Object>> bankOutStandList = this.outStanding_doArrange2ShowList(rowSetBank, vo, true);
        rstDataMap.put("bankOutStandUnreach", bankOutStandList);
    }

    private List<Map<String, Object>> outStanding_doArrange2ShowList(IRowSet rowSet, BankVCOutStandingFilterVO vo, boolean isBankNoEnt) {
        ArrayList<Map<String, Object>> showList = new ArrayList<Map<String, Object>>();
        String FIELD_CREATEDATE = "createDate";
        String FIELD_ISDEBIT = "isDebit";
        String FIELD_COMPANY = "company";
        String FIELD_DEBITAMOUNT = "debitAmount";
        String FIELD_CREDITAMOUNT = "creditAmount";
        String FIELD_ISTOTALROW = "isTotalRow";
        String COL_ITEM = "item";
        String COL_CREATEDATE = "createDate";
        String RES_TOTAL = EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.web.CasWebResource", (String)"OutStand_total", (Locale)this.ctx.getLocale());
        BigDecimal recSum = new BigDecimal("0.00");
        BigDecimal paySum = new BigDecimal("0.00");
        HashMap<String, Object> recSumRowMap = new HashMap<String, Object>();
        HashMap<String, Object> paySumRowMap = new HashMap<String, Object>();
        boolean showRecPay = vo.getShowRecPay();
        boolean showTotal = vo.getShowAmount();
        boolean isFirstPayRow = true;
        try {
            int colCount = rowSet.getMetaData().getColumnCount();
            if (showRecPay) {
                showList.add(recSumRowMap);
            }
            while (rowSet.next()) {
                if (showRecPay || showTotal) {
                    if (this.isRec(rowSet.getBoolean(FIELD_ISDEBIT), isBankNoEnt)) {
                        recSum = recSum.add(rowSet.getBigDecimal(this.getRecAmtFieldName(isBankNoEnt)));
                    } else {
                        BigDecimal value;
                        if (showRecPay && isFirstPayRow) {
                            showList.add(paySumRowMap);
                            isFirstPayRow = false;
                        }
                        if ((value = rowSet.getBigDecimal(this.getPayAmtFieldName(isBankNoEnt))) != null) {
                            paySum = paySum.add(value);
                        }
                    }
                }
                HashMap<String, Object> curTempRowMap = new HashMap<String, Object>();
                for (int idx = 1; idx < colCount; ++idx) {
                    String colName = rowSet.getMetaData().getColumnName(idx);
                    Object colVal = rowSet.getObject(colName);
                    curTempRowMap.put(colName, colVal);
                }
                showList.add(curTempRowMap);
            }
            if (showRecPay) {
                if (!showList.contains(recSumRowMap)) {
                    showList.add(recSumRowMap);
                }
                recSumRowMap.put(COL_ITEM, this.getRecItemTxt(isBankNoEnt));
                recSumRowMap.put(this.getRecAmtFieldName(isBankNoEnt), recSum);
                recSumRowMap.put(this.getRecAmtFieldName(!isBankNoEnt), new BigDecimal("0.00"));
                recSumRowMap.put(FIELD_ISTOTALROW, true);
                if (!showList.contains(paySumRowMap)) {
                    showList.add(paySumRowMap);
                }
                paySumRowMap.put(COL_ITEM, this.getPayItemTxt(isBankNoEnt));
                paySumRowMap.put(this.getPayAmtFieldName(isBankNoEnt), paySum);
                paySumRowMap.put(this.getPayAmtFieldName(!isBankNoEnt), new BigDecimal("0.00"));
                paySumRowMap.put(FIELD_ISTOTALROW, true);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (showTotal) {
            HashMap<String, Object> totalRowMap = new HashMap<String, Object>();
            showList.add(totalRowMap);
            if (showRecPay) {
                totalRowMap.put(COL_ITEM, RES_TOTAL);
            } else {
                totalRowMap.put(COL_CREATEDATE, RES_TOTAL);
            }
            totalRowMap.put(this.getRecAmtFieldName(isBankNoEnt), recSum);
            totalRowMap.put(this.getPayAmtFieldName(isBankNoEnt), paySum);
            totalRowMap.put(FIELD_ISTOTALROW, true);
        }
        return showList;
    }

    private boolean isRec(boolean isDebit, boolean isBankNoEnt) {
        return isBankNoEnt ? isDebit : !isDebit;
    }

    private String getRecAmtFieldName(boolean isBankNoEnt) {
        return isBankNoEnt ? "debitAmount" : "creditAmount";
    }

    private String getPayAmtFieldName(boolean isBankNoEnt) {
        return isBankNoEnt ? "creditAmount" : "debitAmount";
    }

    private String getRecItemTxt(boolean isBankNoEnt) {
        String RESOURCEPATH = "com.kingdee.eas.fi.cas.web.CasWebResource";
        return isBankNoEnt ? EASCommonResource.getString((String)RESOURCEPATH, (String)"OutStand_entRevBankNot", (Locale)this.ctx.getLocale()) : EASCommonResource.getString((String)RESOURCEPATH, (String)"OutStand_bankRevEntNot", (Locale)this.ctx.getLocale());
    }

    private String getPayItemTxt(boolean isBankNoEnt) {
        String RESOURCEPATH = "com.kingdee.eas.fi.cas.web.CasWebResource";
        return isBankNoEnt ? EASCommonResource.getString((String)RESOURCEPATH, (String)"OutStand_entPayBankNot", (Locale)this.ctx.getLocale()) : EASCommonResource.getString((String)RESOURCEPATH, (String)"OutStand_bankPayEntNot", (Locale)this.ctx.getLocale());
    }
}

