/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BankVcMultiCompanyCheck {
    private static final int PROFILE_TIME = 500;
    private static final String PARAM_ACCOUTN_BANK_ID = "accoutnBankIdSet";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.BankVcMultiCompanyCheck");
    private static final String currentLocaleString = BOSLocaleUtil.getDefaultLocale().getLanguage();
    private static final String SQL_TABLE_COMPANY_CURRENT_PERIOD = "CREATE TABLE {0} (FCompanyId VARCHAR(44),FCurrentPeriodId VARCHAR(44),FBeginDate DATETIME,FEndDate DATETIME)";
    private static final String SQL_INSERT_COMPANY_START_PERIOD = "INSERT INTO {0} (FCompanyId,FCurrentPeriodId,FBeginDate,FEndDate) \nSELECT STATUSCTROL.FCompanyId,STATUSCTROL.FCurrentPeriodId,PERIOD.FBeginDate,PERIOD.FEndDate \nFROM T_BD_SYSTEMSTATUSCTROL STATUSCTROL \nINNER JOIN T_BD_SYSTEMSTATUS SYSTEMSTATUS ON STATUSCTROL.FSYSTEMSTATUSID = SYSTEMSTATUS.FID AND SYSTEMSTATUS.FNAME = 7 \nINNER JOIN T_BD_PERIOD PERIOD ON STATUSCTROL.FCurrentPeriodId = PERIOD.FID \nWHERE STATUSCTROL.FCompanyId IN {1}";
    private static final String SQL_TABLE_ACCOUNTBANK = "CREATE TABLE {0} (FId VARCHAR(44),FName_{1} NVARCHAR(80),FNumber NVARCHAR(80),FBankAccountNumber NVARCHAR(80),FCompanyId VARCHAR(44),FCurrencyId VARCHAR(44))";
    private static final String SQL_INSERT_ACCOUNTBANK = "INSERT INTO {0} (FId,FName_{1},FBankAccountNumber,FCompanyId,FCurrencyId) \n";
    private static final String SQL_DATA_ACCOUNTBANK = "SELECT FId,FName_{1},FBankAccountNumber,FCompanyId,FCurrencyId \nFROM T_BD_ACCOUNTBANKS ACCOUNTBANK \nWHERE FIsClosed = 0 AND FCompanyId In {2}\n{3}";
    private static final String SQL_DATA_SHARED_ACCT = "SELECT ACCOUNTBANK.FId,ACCOUNTBANK.FName_{1},ACCOUNTBANK.FBankAccountNumber,SHAREDACCT.FShareBalanceOfAcctCompanyId,ACCOUNTBANK.FCurrencyId \nFROM T_BD_SHAREDACCT SHAREDACCT \nINNER JOIN T_BD_ACCOUNTBANKS ACCOUNTBANK ON SHAREDACCT.FBankAccountId = ACCOUNTBANK.FId AND ACCOUNTBANK.FIsClosed = 0 \nWHERE SHAREDACCT.FShareBalanceOfAcctCompanyId In {2} {3}";
    private static final String SQL_TABLE_COMPANY_BANKSTATEMENT = "CREATE TABLE {0} (FCompanyId VARCHAR(44),FPeriodId VARCHAR(44),FAccountBankId VARCHAR(44),FCurrencyId VARCHAR(44),FVerifyStatus NUMERIC(4),FRelatedBizDate DATETIME)";
    private static final String SQL_INSERT_COMPANY_BANKSTATEMENT = "INSERT INTO {0} (FCompanyId,FPeriodId,FAccountBankId,FCurrencyId,FVerifyStatus,FRelatedBizDate) \n";
    private static final String SQL_MULTI_COMPANY_BANKSTATEMENT = "SELECT BANKSTATEMENT.FCompanyId,COMPANYPERIOD.FCurrentPeriodId,BANKSTATEMENT.FAccountBankId,BANKSTATEMENT.FCurrencyId,\nMIN(BANKSTATEMENT.FVerifyStatus + ISNULL(JOURNAL.FVerifyStatus,0)) FVerifyStatus,MAX(BANKSTATEMENT.FRelatedBizDate) FRelatedBizDate \nFROM T_CAS_BANKSTATEMENT BANKSTATEMENT \nINNER JOIN {1} ACCOUNTBANK ON BANKSTATEMENT.FAccountBankId = ACCOUNTBANK.FID \nINNER JOIN {0} COMPANYPERIOD ON BANKSTATEMENT.FCompanyId=COMPANYPERIOD.FCompanyId AND BANKSTATEMENT.FCreateDate <= COMPANYPERIOD.FEndDate \nLEFT JOIN T_CAS_JOURNAL JOURNAL ON BANKSTATEMENT.FAccountBankId = JOURNAL.FAccountBankId AND BANKSTATEMENT.FCurrencyId = JOURNAL.FCurrencyId AND JOURNAL.FType = 2 \nGROUP BY BANKSTATEMENT.FCompanyId,COMPANYPERIOD.FCurrentPeriodId,BANKSTATEMENT.FAccountBankId,BANKSTATEMENT.FCurrencyId";
    private static final String SQL_MULTI_COMPANY_JOURNAL = "SELECT JOURNAL.FCompanyId,COMPANYPERIOD.FCurrentPeriodId,JOURNAL.FAccountBankId,JOURNAL.FCurrencyId,\nMIN(JOURNAL.FVerifyStatus) FVerifyStatus,MAX(JOURNAL.FRelatedBizDate) FRelatedBizDate \nFROM T_CAS_JOURNAL JOURNAL \nINNER JOIN {1} ACCOUNTBANK ON JOURNAL.FAccountBankId = ACCOUNTBANK.FID \nINNER JOIN {0} COMPANYPERIOD ON JOURNAL.FCompanyId = COMPANYPERIOD.FCompanyId AND JOURNAL.FCreateDate <= COMPANYPERIOD.FEndDate \nWHERE NOT EXISTS( \nSELECT BANKSTATEMENT.FID FROM T_CAS_BANKSTATEMENT BANKSTATEMENT \nWHERE JOURNAL.FAccountBankId = BANKSTATEMENT.FAccountBankId \nAND JOURNAL.FCurrencyId = BANKSTATEMENT.FCurrencyId AND BANKSTATEMENT.FCreateDate <= COMPANYPERIOD.FEndDate) \nAND JOURNAL.FType = 2 \nGROUP BY JOURNAL.FCompanyId,COMPANYPERIOD.FCurrentPeriodId,JOURNAL.FAccountBankId,JOURNAL.FCurrencyId";
    private static final String SQL_INSERT_GROUP_COMPANY_BANKSTATEMENT = "INSERT INTO {0} (FCompanyId,FPeriodId,FAccountBankId,FCurrencyId,FVerifyStatus,FRelatedBizDate) \nSELECT FCompanyId,FPeriodId,FAccountBankId,FCurrencyId,MIN(FVerifyStatus),MAX(FRelatedBizDate)\nFROM {1} \nGROUP BY FCompanyId,FPeriodId,FAccountBankId,FCurrencyId";
    private static final String SQL_COMPANY_BANKSTATEMENT_DATA = "SELECT BANKSTATEMENT.FCompanyId, COMPANY.FName_{1} FCompanyName,BANKSTATEMENT.FPeriodId,PERIOD.FNumber FPeriodNumber,PERIOD.FEndDate FPeriodEndDate,\nBANKSTATEMENT.FAccountBankId,ACCOUNTBANK.FName_{1} FAccountBankName,ACCOUNTBANK.FBankAccountNumber FBankAccountNumber,\nCURRENCY.FID FCurrencyId,CURRENCY.FName_{1} FCurrencyName, \nBANKSTATEMENT.FVerifyStatus,BANKSTATEMENT.FRelatedBizDate \nFROM {0} BANKSTATEMENT \nINNER JOIN T_ORG_COMPANY COMPANY ON BANKSTATEMENT.FCompanyId = COMPANY.FID \nINNER JOIN T_BD_PERIOD PERIOD ON BANKSTATEMENT.FPeriodId = PERIOD.FID \nINNER JOIN T_BD_ACCOUNTBANKS ACCOUNTBANK ON BANKSTATEMENT.FAccountBankId = ACCOUNTBANK.FID \nINNER JOIN T_BD_CURRENCY CURRENCY ON BANKSTATEMENT.FCurrencyId = CURRENCY.FID \nORDER BY COMPANY.FLongNumber,ACCOUNTBANK.FNumber,CURRENCY.FNumber";

    public static IRowSet executeQuery(Context ctx, String sql) throws BOSException {
        SimpleTimer timer = new SimpleTimer();
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
        long time = timer.getTime();
        if (time > 500L) {
            logger.info((Object)String.format("executeQuery:\n %s \n spend time: %s", sql, time));
        }
        return rowset;
    }

    public static void execute(Context ctx, String sql) throws BOSException {
        SimpleTimer timer = new SimpleTimer();
        DbUtil.execute((Context)ctx, (String)sql);
        long time = timer.getTime();
        if (time > 500L) {
            logger.info((Object)String.format("execute:\n %s \n spend time: %s", sql, time));
        }
    }

    private String getTempTable(ITableManagerFacade tableManagerFacade, String desc) throws BOSException {
        String tableName = tableManagerFacade.getTemporaryTableName(desc);
        if (tableName.length() > 30) {
            tableName = tableName.substring(0, 30);
        }
        return tableName;
    }

    private void releaseTempTable(ITableManagerFacade tableManagerFacade, String tableName) throws BOSException {
        if (tableName != null) {
            tableManagerFacade.releaseTemporaryTableName(tableName);
        }
    }

    private Set<String> getAuthoriedCompanyIds(Context ctx, String permItemName) throws BOSException, EASBizException {
        HashSet<String> authCompanyIds = null;
        FullOrgUnitCollection collection = PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrg((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId()), OrgType.Company, null, permItemName);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)collection)) {
            authCompanyIds = new HashSet<String>();
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                authCompanyIds.add(collection.get(i).getId().toString());
            }
        }
        return authCompanyIds;
    }

    private String getCompanyCurrentPeriodTable(Context ctx, Map paramMap, ITableManagerFacade tableManagerFacade, Set<String> authCompanyIds) throws BOSException, EASBizException {
        String tableName = this.getTempTable(tableManagerFacade, "CURRENT_PERIODID");
        String sql = MessageFormat.format(SQL_TABLE_COMPANY_CURRENT_PERIOD, tableName);
        BankVcMultiCompanyCheck.execute(ctx, sql);
        if (!EmptyUtil.isEmpty(authCompanyIds)) {
            sql = MessageFormat.format(SQL_INSERT_COMPANY_START_PERIOD, tableName, FMHelper.setTran2String(authCompanyIds));
            BankVcMultiCompanyCheck.execute(ctx, sql);
        }
        return tableName;
    }

    private String getAccountBankTable(Context ctx, Map paramMap, ITableManagerFacade tableManagerFacade, Set<String> companyIdSet) throws BOSException, EASBizException {
        String tableName = this.getTempTable(tableManagerFacade, "ACCOUNTBANK");
        String sql = MessageFormat.format(SQL_TABLE_ACCOUNTBANK, tableName, currentLocaleString);
        BankVcMultiCompanyCheck.execute(ctx, sql);
        StringBuilder filterBuilder = new StringBuilder();
        Set accoutnBankIdSet = null;
        if (paramMap != null) {
            Object accountBankObj = paramMap.get(PARAM_ACCOUTN_BANK_ID);
            if (accountBankObj != null && accountBankObj instanceof Set) {
                accoutnBankIdSet = (Set)accountBankObj;
            }
            if (!EmptyUtil.isEmpty(accoutnBankIdSet)) {
                filterBuilder.append(" AND ACCOUNTBANK.FId IN ").append(FMHelper.setTran2String((Set)accoutnBankIdSet));
            }
        }
        Object[] args = new Object[]{tableName, currentLocaleString, FMHelper.setTran2String(companyIdSet), filterBuilder.toString()};
        StringBuilder sqlBuilder = new StringBuilder(SQL_INSERT_ACCOUNTBANK);
        sqlBuilder.append(SQL_DATA_SHARED_ACCT);
        sqlBuilder.append("\n UNION \n");
        sqlBuilder.append(SQL_DATA_ACCOUNTBANK);
        BankVcMultiCompanyCheck.execute(ctx, MessageFormat.format(sqlBuilder.toString(), args));
        return tableName;
    }

    private String getBankStatementDetail(Context ctx, Map paramMap, ITableManagerFacade tableManagerFacade, String companyPeriodTable, String accountBankTable) throws BOSException {
        String bankStatementTable = this.getTempTable(tableManagerFacade, "COMPANY_BANKSTATEMENT");
        String sql = MessageFormat.format(SQL_TABLE_COMPANY_BANKSTATEMENT, bankStatementTable);
        BankVcMultiCompanyCheck.execute(ctx, sql);
        sql = MessageFormat.format(SQL_INSERT_COMPANY_BANKSTATEMENT, bankStatementTable);
        StringBuilder sqlBuilder = new StringBuilder(sql);
        sqlBuilder.append(MessageFormat.format(SQL_MULTI_COMPANY_BANKSTATEMENT, companyPeriodTable, accountBankTable));
        sqlBuilder.append("\n UNION ALL \n");
        sqlBuilder.append(MessageFormat.format(SQL_MULTI_COMPANY_JOURNAL, companyPeriodTable, accountBankTable));
        BankVcMultiCompanyCheck.execute(ctx, sqlBuilder.toString());
        return bankStatementTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRowSet getMultiOrgBankStatement(Context ctx, Map paramMap) throws BOSException, EASBizException {
        IRowSet iRowSet;
        ITableManagerFacade tableManagerFacade = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String companyPeriodTable = null;
        String accountBankTable = null;
        String bankStatementTable = null;
        String multiBankStatementTable = null;
        try {
            Set<String> authCompanyIds = this.getAuthoriedCompanyIds(ctx, "cas_bankVcCheck_02contrast");
            companyPeriodTable = this.getCompanyCurrentPeriodTable(ctx, paramMap, tableManagerFacade, authCompanyIds);
            accountBankTable = this.getAccountBankTable(ctx, paramMap, tableManagerFacade, authCompanyIds);
            bankStatementTable = this.getBankStatementDetail(ctx, paramMap, tableManagerFacade, companyPeriodTable, accountBankTable);
            multiBankStatementTable = this.getTempTable(tableManagerFacade, "MULTI_COMPANY_BANKSTATEMENT");
            String sql = MessageFormat.format(SQL_TABLE_COMPANY_BANKSTATEMENT, multiBankStatementTable);
            BankVcMultiCompanyCheck.execute(ctx, sql);
            sql = MessageFormat.format(SQL_INSERT_GROUP_COMPANY_BANKSTATEMENT, multiBankStatementTable, bankStatementTable);
            BankVcMultiCompanyCheck.execute(ctx, sql);
            sql = MessageFormat.format(SQL_COMPANY_BANKSTATEMENT_DATA, multiBankStatementTable, currentLocaleString);
            iRowSet = BankVcMultiCompanyCheck.executeQuery(ctx, sql);
        }
        catch (Throwable throwable) {
            this.releaseTempTable(tableManagerFacade, companyPeriodTable);
            this.releaseTempTable(tableManagerFacade, accountBankTable);
            this.releaseTempTable(tableManagerFacade, bankStatementTable);
            this.releaseTempTable(tableManagerFacade, multiBankStatementTable);
            throw throwable;
        }
        this.releaseTempTable(tableManagerFacade, companyPeriodTable);
        this.releaseTempTable(tableManagerFacade, accountBankTable);
        this.releaseTempTable(tableManagerFacade, bankStatementTable);
        this.releaseTempTable(tableManagerFacade, multiBankStatementTable);
        return iRowSet;
    }
}

