/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.vc.BankVcProcessFacadeFactory;
import com.kingdee.eas.base.vc.IBankVcProcessFacade;
import com.kingdee.eas.base.vc.VcMatchConditionCollection;
import com.kingdee.eas.base.vc.VcMatchConditionInfo;
import com.kingdee.eas.base.vc.VcResultCollection;
import com.kingdee.eas.base.vc.VcVerifyInfo;
import com.kingdee.eas.base.vc.app.model.BankStatementVO;
import com.kingdee.eas.base.vc.app.model.JournalVO;
import com.kingdee.eas.base.vc.app.task.VCTask;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BankVcProcessHelper {
    private int getJournalCount(Context ctx, List idList) throws SQLException, BOSException {
        String sql = "SELECT COUNT(*) NUM FROM T_CAS_Journal WHERE FId in " + FMHelper.setTran2String((Set)FMHelper.list2Set((List)idList)) + " AND FType=2 AND FVerifyStatus=0";
        Connection conn = null;
        PreparedStatement state = null;
        ResultSet countRowSet = null;
        int num = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            state = conn.prepareStatement(sql);
            countRowSet = state.executeQuery();
            countRowSet.next();
            num = countRowSet.getInt("NUM");
        }
        catch (SQLException exp) {
            try {
                throw new BOSException((Throwable)exp);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(countRowSet, state, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)countRowSet, (Statement)state, (Connection)conn);
        return num;
    }

    public VcResultCollection autoProcess_CAS(Context ctx, Map mapIdList, VcMatchConditionCollection bizMatchColl, String vctype) throws BOSException, EASBizException {
        VcResultCollection vcResultColl = null;
        VcVerifyInfo verifyInfo = new VcVerifyInfo();
        verifyInfo.setId(BOSUuid.create((BOSObjectType)verifyInfo.getBOSType()));
        String verifyId = verifyInfo.getId().toString();
        String[] tableName = new String[mapIdList.size()];
        Iterator it = mapIdList.keySet().iterator();
        boolean index = false;
        while (it.hasNext()) {
            String boInfo = (String)it.next();
            if (!boInfo.equals("com.kingdee.eas.fi.cas.app.Journal")) continue;
            int journalCount = 0;
            try {
                journalCount = this.getJournalCount(ctx, (List)mapIdList.get(boInfo));
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (journalCount != 0) continue;
            return null;
        }
        boolean isDateEquals = false;
        boolean isDescriptionEquals = false;
        boolean isSettTypeEquals = false;
        boolean isSettNumberEquals = false;
        boolean isMulSettNumberEquals = false;
        boolean isOppUnitEquals = false;
        if (bizMatchColl.size() > 0) {
            int m = bizMatchColl.size();
            for (int i = 0; i < m; ++i) {
                VcMatchConditionInfo tmpInfo = bizMatchColl.get(i);
                if (tmpInfo.getPropName().equals("FCreateDate") || tmpInfo.getPropName().equals("FBizDate")) {
                    isDateEquals = true;
                }
                if (tmpInfo.getPropName().equals("FDescription")) {
                    isDescriptionEquals = true;
                }
                if (tmpInfo.getPropName().equals("FSettleTypeID")) {
                    isSettTypeEquals = true;
                }
                if (tmpInfo.getPropName().equals("FSettleNumber")) {
                    isSettNumberEquals = true;
                }
                if (tmpInfo.getPropName().equals("FSettleNumber_m")) {
                    isMulSettNumberEquals = true;
                }
                if (!tmpInfo.getPropName().equals("FOppUnit")) continue;
                isOppUnitEquals = true;
            }
        }
        try {
            int groupIndex = 0;
            vcResultColl = this.autoProcessOne(ctx, verifyInfo, mapIdList, isDateEquals, isDescriptionEquals, isSettTypeEquals, isSettNumberEquals, isMulSettNumberEquals, false, 0, groupIndex, isOppUnitEquals);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return vcResultColl;
    }

    private VcResultCollection autoProcessOne(Context ctx, VcVerifyInfo verifyInfo, Map mapIdList, boolean dateEqual, boolean descriptionEqual, boolean settTypeEqual, boolean settNumberEqual, boolean mulSettNumberEqual, boolean vcNumberEqual, int dateDiff, int groupIndex, boolean isOppUnitEquals) throws BOSException, EASBizException, SQLException {
        VcResultCollection vcResultColl = null;
        vcResultColl = this.vcOne2One(ctx, mapIdList, dateEqual, descriptionEqual, settTypeEqual, settNumberEqual, vcNumberEqual, dateDiff, groupIndex, isOppUnitEquals);
        IBankVcProcessFacade iBankVcProcessFacade = BankVcProcessFacadeFactory.getLocalInstance((Context)ctx);
        iBankVcProcessFacade.submitResult((IObjectCollection)vcResultColl);
        return vcResultColl;
    }

    private VcResultCollection vcOne2One(Context ctx, Map mapIdList, boolean dateEqual, boolean descriptionEqual, boolean settTypeEqual, boolean settNumberEqual, boolean vcNumberEqual, int dateDiff, int groupNumber, boolean oppUnitEquals) throws EASBizException, BOSException, SQLException {
        Iterator it = mapIdList.keySet().iterator();
        boolean index = false;
        List<Object> bankStateList = new ArrayList();
        List<Object> journalList = new ArrayList();
        while (it.hasNext()) {
            String boInfo = (String)it.next();
            if (boInfo.equals("com.kingdee.eas.fi.cas.app.Journal")) {
                journalList = this.getJournalList(ctx, (List)mapIdList.get(boInfo));
            }
            if (!boInfo.equals("com.kingdee.eas.fi.cas.app.BankStatement")) continue;
            bankStateList = this.getBankStateList(ctx, (List)mapIdList.get(boInfo));
        }
        VCTask vcTask = new VCTask(dateEqual, descriptionEqual, settTypeEqual, settNumberEqual, vcNumberEqual, dateDiff, oppUnitEquals);
        VcResultCollection vcResultList = vcTask.autoProcess(ctx, journalList, bankStateList, groupNumber, false);
        return vcResultList;
    }

    private List<BankStatementVO> getBankStateList(Context ctx, List idList) throws BOSException, EASBizException, SQLException {
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("SELECT  FID, FCreateDate, FCompanyID, FBankVoucherNO, FAccountBankID, FCurrencyID, FBizDate, FVoucherNumber, FDebitAmount, FCreditAmount, FDescription, FSettleTypeId, FSettleNumber FROM T_CAS_BankStatement WHERE 1=1 ");
        sqlBuf.append(" AND FID in " + FMHelper.setTran2String((Set)FMHelper.list2Set((List)idList)));
        sqlBuf.append(" AND FVerifyStatus=0  ");
        sqlBuf.append(" ORDER BY FDebitAmount + FCreditAmount,FCreateDate");
        Connection conn = null;
        PreparedStatement state = null;
        ResultSet journalRowSet = null;
        ArrayList<BankStatementVO> bankStateList = new ArrayList<BankStatementVO>();
        conn = EJBFactory.getConnection((Context)ctx);
        state = conn.prepareStatement(sqlBuf.toString());
        journalRowSet = state.executeQuery();
        try {
            while (journalRowSet.next()) {
                String currency;
                String accountBank;
                String settlementId;
                BankStatementVO vo = new BankStatementVO();
                vo.setVcNumber(journalRowSet.getString("FBankVoucherNO"));
                vo.setCreateDate((Date)journalRowSet.getDate("FCreateDate"));
                vo.setCreditAmount(journalRowSet.getBigDecimal("FDebitAmount").setScale(6));
                vo.setDebitAmount(journalRowSet.getBigDecimal("FCreditAmount").setScale(6));
                vo.setDescription(journalRowSet.getString("FDescription"));
                vo.setId(journalRowSet.getString("FID"));
                vo.setSettlementNumber(journalRowSet.getString("FSettleNumber"));
                vo.setSettlenumber(journalRowSet.getString("FSettleNumber"));
                vo.setBizDate((Date)journalRowSet.getDate("FBizDate"));
                String companyId = journalRowSet.getString("FCompanyID");
                if (!EmptyUtil.isEmpty((String)companyId)) {
                    CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                    company.setId(BOSUuid.read((String)companyId));
                    vo.setCompany(company);
                }
                if (!EmptyUtil.isEmpty((String)(settlementId = journalRowSet.getString("FSettleTypeId")))) {
                    SettlementTypeInfo settleInfo = new SettlementTypeInfo();
                    settleInfo.setId(BOSUuid.read((String)settlementId));
                    vo.setSettlementTypeInfo(settleInfo);
                }
                if (!EmptyUtil.isEmpty((String)(accountBank = journalRowSet.getString("FAccountBankID")))) {
                    AccountBankInfo accountBankInfo = new AccountBankInfo();
                    accountBankInfo.setId(BOSUuid.read((String)accountBank));
                    vo.setAccountBank(accountBankInfo);
                }
                if (!EmptyUtil.isEmpty((String)(currency = journalRowSet.getString("FCurrencyID")))) {
                    CurrencyInfo currencyInfo = new CurrencyInfo();
                    currencyInfo.setId(BOSUuid.read((String)currency));
                    vo.setCurrencyInfo(currencyInfo);
                }
                bankStateList.add(vo);
            }
        }
        catch (SQLException exp) {
            throw new BOSException((Throwable)exp);
        }
        finally {
            SQLUtils.cleanup((ResultSet)journalRowSet, (Statement)state, (Connection)conn);
        }
        return bankStateList;
    }

    private List<JournalVO> getJournalList(Context ctx, List idList) throws BOSException, EASBizException, SQLException {
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("SELECT FID, FCreateDate, FCompanyID, FBankCheckFlag, FAccountBankID, FCurrencyID, FVoucherTypeID, FBizDate, FBillNumber, FVoucherNumber, FBillType,  FDebitAmount, FCreditAmount, FDescription, FSettlementTypeId, FSettlementNumber FROM T_CAS_Journal WHERE 1=1 ");
        sqlBuf.append(" AND FID in " + FMHelper.setTran2String((Set)FMHelper.list2Set((List)idList)));
        sqlBuf.append(" AND FType=2 AND FVerifyStatus=0 ");
        sqlBuf.append(" ORDER BY FDebitAmount + FCreditAmount,FCreateDate ");
        Connection conn = null;
        PreparedStatement state = null;
        ResultSet journalRowSet = null;
        ArrayList<JournalVO> journalList = new ArrayList<JournalVO>();
        conn = EJBFactory.getConnection((Context)ctx);
        state = conn.prepareStatement(sqlBuf.toString());
        journalRowSet = state.executeQuery();
        try {
            while (journalRowSet.next()) {
                String voucherId;
                String currency;
                String accountBank;
                String settlementId;
                JournalVO vo = new JournalVO();
                vo.setVcNumber(journalRowSet.getString("FBankCheckFlag"));
                vo.setCreateDate((Date)journalRowSet.getDate("FCreateDate"));
                vo.setCreditAmount(journalRowSet.getBigDecimal("FDebitAmount").setScale(6));
                vo.setDebitAmount(journalRowSet.getBigDecimal("FCreditAmount").setScale(6));
                vo.setDescription(journalRowSet.getString("FDescription"));
                vo.setId(journalRowSet.getString("FID"));
                vo.setSettlementNumber(journalRowSet.getString("FSettlementNumber"));
                vo.setSettlementType(journalRowSet.getString("FSettlementTypeId"));
                vo.setSettlenumber(journalRowSet.getString("FSettlementNumber"));
                vo.setBizDate((Date)journalRowSet.getDate("FBizDate"));
                vo.setBillNumber(journalRowSet.getString("FBillNumber"));
                String companyId = journalRowSet.getString("FCompanyID");
                if (!EmptyUtil.isEmpty((String)companyId)) {
                    CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                    company.setId(BOSUuid.read((String)companyId));
                    vo.setCompany(company);
                }
                if (!EmptyUtil.isEmpty((String)(settlementId = journalRowSet.getString("FSettlementTypeId")))) {
                    SettlementTypeInfo settleInfo = new SettlementTypeInfo();
                    settleInfo.setId(BOSUuid.read((String)settlementId));
                    vo.setSettlementTypeInfo(settleInfo);
                }
                if (!EmptyUtil.isEmpty((String)(accountBank = journalRowSet.getString("FAccountBankID")))) {
                    AccountBankInfo accountBankInfo = new AccountBankInfo();
                    accountBankInfo.setId(BOSUuid.read((String)accountBank));
                    vo.setAccountBank(accountBankInfo);
                }
                if (!EmptyUtil.isEmpty((String)(currency = journalRowSet.getString("FCurrencyID")))) {
                    CurrencyInfo currencyInfo = new CurrencyInfo();
                    currencyInfo.setId(BOSUuid.read((String)currency));
                    vo.setCurrencyInfo(currencyInfo);
                }
                if (!EmptyUtil.isEmpty((String)(voucherId = journalRowSet.getString("FVoucherTypeID")))) {
                    VoucherTypeInfo voucherType = new VoucherTypeInfo();
                    voucherType.setId(BOSUuid.read((String)voucherId));
                    vo.setVoucherTypeInfo(voucherType);
                }
                vo.setBillType(BillTypeEnum.getEnum(journalRowSet.getString("FBillType")));
                journalList.add(vo);
            }
        }
        catch (SQLException exp) {
            throw new BOSException((Throwable)exp);
        }
        finally {
            SQLUtils.cleanup((ResultSet)journalRowSet, (Statement)state, (Connection)conn);
        }
        return journalList;
    }
}

