/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankGroupInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CodingRuleMsgInfo;
import com.kingdee.eas.fi.cas.InnerCashFacadeFactory;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.RecPayInstanceResultBean;
import com.kingdee.eas.fi.cas.ReceivingBillCollection;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.app.AbstractBatchFetchParamFacadeControllerBean;
import com.kingdee.eas.fi.cas.app.ICasFetchParam;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class BatchFetchParamFacadeControllerBean
extends AbstractBatchFetchParamFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.BatchFetchParamFacadeControllerBean");

    @Override
    protected Map _fetchParam(Context ctx, Map paramNameMap) throws BOSException, EASBizException {
        String uiName = (String)paramNameMap.get("ui_name");
        ICasFetchParam cfp = this.getCasFetchParamInstance(uiName);
        if (cfp != null) {
            return cfp.fetchParam(ctx, paramNameMap);
        }
        return paramNameMap;
    }

    private ICasFetchParam getCasFetchParamInstance(String uiName) {
        String className = null;
        if (uiName.equals("CasReceivingBillUI")) {
            className = "com.kingdee.eas.fi.cas.app.FetchParamHelperForCasReceivingBillUI";
        } else if (uiName.equals("CasPaymentBillUI")) {
            className = "com.kingdee.eas.fi.cas.app.FetchParamHelperForPaymentBillUI";
        } else if (uiName.equals("CasReceivingAddBatchEditUI")) {
            className = "com.kingdee.eas.fi.cas.app.FetchParamCasReceAddBatchEditUI";
        } else if (uiName.equals("CasPaymentAddBatchEditUI")) {
            className = "com.kingdee.eas.fi.cas.app.FetchParamCasPaymentAddBatchEditUI";
        } else if (uiName.equals("TemplatePaymentBillEditUI")) {
            className = "com.kingdee.eas.fi.cas.app.FetchParamHelperForTemplatePaymentBillUI";
        } else if (uiName.equals("TemplateReceivingBillEditUI")) {
            className = "com.kingdee.eas.fi.cas.app.FetchParamHelperForTemplateReceivingBillUI";
        } else if (uiName.equals("CashMgtInitUI")) {
            className = "com.kingdee.eas.fi.cas.app.FetchParamCashMgtInitUI";
        } else {
            return null;
        }
        try {
            return (ICasFetchParam)Class.forName(className).newInstance();
        }
        catch (InstantiationException e) {
            logger.error((Object)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
        }
        return null;
    }

    @Override
    protected Map _instanceBalanceResult(Context ctx, String companyID, String acctBankID, String currencyID) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        if (EmptyUtil.isEmpty((String)companyID) || EmptyUtil.isEmpty((String)acctBankID) || EmptyUtil.isEmpty((String)currencyID)) {
            return resultMap;
        }
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyID));
        AccountBankInfo acctBank = new AccountBankInfo();
        acctBank.setId(BOSUuid.read((String)acctBankID));
        CurrencyInfo currency = new CurrencyInfo();
        currency.setId(BOSUuid.read((String)currencyID));
        BigDecimal balance = RecPayHelper.getTotalBalance(ctx, company, null, acctBank, currency);
        AccountBankGroupInfo acctBankGroup = AccountBankFactory.getLocalInstance((Context)ctx).getAcctBankGroup(acctBankID);
        BigDecimal totalbalance = Constants.ZERO;
        if (acctBankGroup != null) {
            totalbalance = InnerCashFacadeFactory.getLocalInstance(ctx).getAcctGroupInstantBalance((IObjectPK)new ObjectUuidPK(companyID), (IObjectPK)new ObjectUuidPK(acctBankGroup.getId().toString()), (IObjectPK)new ObjectUuidPK(currencyID));
        }
        resultMap.put("acctBankBalance", balance);
        resultMap.put("acctBankGroup", (BigDecimal)acctBankGroup);
        resultMap.put("acctBankGroupBalance", totalbalance);
        return resultMap;
    }

    @Override
    protected Map _fecheBatcheInstanceValue(Context ctx, ArrayList idList) throws BOSException, EASBizException {
        if (idList == null || idList.size() == 0) {
            return null;
        }
        String id = (String)idList.get(0);
        if (BOSUuid.read((String)id).getType().equals((Object)new PaymentBillInfo().getBOSType())) {
            return this.getPaymentBillMap(ctx, idList);
        }
        return this.getReceivingBillMap(ctx, idList);
    }

    private Map getReceivingBillMap(Context ctx, ArrayList idList) throws BOSException, EASBizException {
        HashMap<String, RecPayInstanceResultBean> result = new HashMap<String, RecPayInstanceResultBean>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        HashSet idSet = new HashSet();
        idSet.addAll(idList);
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("feeType.id");
        sic.add("feeType.name");
        sic.add("feeType.number");
        sic.add("currency.id");
        sic.add("company.id");
        sic.add("billStatus");
        sic.add("actRecAmt");
        sic.add("actPayAmt");
        sic.add("number");
        sic.add("payerAccountBankO.id");
        sic.add("payerAccountBankO.ctrlStrategy.overdraftCtrl");
        sic.add("payerAccountBankO.ctrlStrategy.remind");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        ReceivingBillCollection recColl = ReceivingBillFactory.getLocalInstance(ctx).getReceivingBillCollection(view);
        for (int i = 0; i < recColl.size(); ++i) {
            ReceivingBillInfo info = recColl.get(i);
            if (info.getPayerAccountBankO() != null) {
                String acctBankID = info.getPayerAccountBankO().getId().toString();
                String currencyID = info.getCurrency().getId().toString();
                String companyID = info.getCompany().getId().toString();
                Map instantMap = this._instanceBalanceResult(ctx, companyID, acctBankID, currencyID);
                AccountBankGroupInfo group = (AccountBankGroupInfo)instantMap.get("acctBankGroup");
                BigDecimal acctBankBalance = (BigDecimal)instantMap.get("acctBankBalance");
                BigDecimal acctBankGroupBalance = (BigDecimal)instantMap.get("acctBankGroupBalance");
                RecPayInstanceResultBean bean = new RecPayInstanceResultBean((CoreBillBaseInfo)info, group, acctBankBalance, acctBankGroupBalance);
                result.put(info.getId().toString(), bean);
                continue;
            }
            RecPayInstanceResultBean bean = new RecPayInstanceResultBean((CoreBillBaseInfo)info, null, null, null);
            result.put(info.getId().toString(), bean);
        }
        return result;
    }

    private Map getPaymentBillMap(Context ctx, ArrayList idList) throws BOSException, EASBizException {
        HashMap<String, RecPayInstanceResultBean> result = new HashMap<String, RecPayInstanceResultBean>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        HashSet idSet = new HashSet();
        idSet.addAll(idList);
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("feeType.id");
        sic.add("feeType.name");
        sic.add("feeType.number");
        sic.add("billStatus");
        sic.add("actPayAmt");
        sic.add("number");
        sic.add("payerAccountBank.id");
        sic.add("payerAccountBank.name");
        sic.add("payerAccountBank.number");
        sic.add("payerAccountBank.bank.id");
        sic.add("payerAccountBank.ctrlStrategy.overdraftCtrl");
        sic.add("payerAccountBank.ctrlStrategy.remind");
        sic.add("currency.id");
        sic.add("company.id");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        PaymentBillCollection recColl = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillCollection(view);
        for (int i = 0; i < recColl.size(); ++i) {
            PaymentBillInfo info = recColl.get(i);
            if (info.getPayerAccountBank() != null) {
                String acctBankID = info.getPayerAccountBank().getId().toString();
                String currencyID = info.getCurrency().getId().toString();
                String companyID = info.getCompany().getId().toString();
                Map instantMap = this._instanceBalanceResult(ctx, companyID, acctBankID, currencyID);
                AccountBankGroupInfo group = (AccountBankGroupInfo)instantMap.get("acctBankGroup");
                BigDecimal acctBankBalance = (BigDecimal)instantMap.get("acctBankBalance");
                BigDecimal acctBankGroupBalance = (BigDecimal)instantMap.get("acctBankGroupBalance");
                RecPayInstanceResultBean bean = new RecPayInstanceResultBean((CoreBillBaseInfo)info, group, acctBankBalance, acctBankGroupBalance);
                result.put(info.getId().toString(), bean);
                continue;
            }
            RecPayInstanceResultBean bean = new RecPayInstanceResultBean((CoreBillBaseInfo)info, null, null, null);
            result.put(info.getId().toString(), bean);
        }
        return result;
    }

    @Override
    protected CodingRuleMsgInfo _getCodingMsg(Context ctx, String companyID, IObjectValue objectValue) throws BOSException, EASBizException {
        CodingRuleMsgInfo msg = new CodingRuleMsgInfo();
        ICodingRuleManager manager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        boolean isExistCodingRule = manager.isExist(objectValue, companyID);
        msg.setExistCodingRule(isExistCodingRule);
        if (isExistCodingRule) {
            boolean isAddView = manager.isAddView(objectValue, companyID);
            boolean useInter = manager.isUseIntermitNumber(objectValue, companyID);
            msg.setModifiable(manager.isModifiable(objectValue, companyID));
            msg.setAddView(isAddView);
            msg.setUseIntermitNumber(useInter);
            if (isAddView && !useInter) {
                String number = manager.getNumber(objectValue, companyID);
                msg.setNumber(number);
            }
        }
        return msg;
    }
}

