/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AbstractPaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.AbstractReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.BookMessageInfo;
import com.kingdee.eas.fi.cas.BookNotifyException;
import com.kingdee.eas.fi.cas.BookNotifyFactory;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.IJournal;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fi.cas.PaymentBillEntryFactory;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.ReceivingBillEntryFactory;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.app.AbstractBookNotifyFacadeControllerBean;
import com.kingdee.eas.fi.gl.VoucherEntryFactory;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.fs.TransDownBillEntryFactory;
import com.kingdee.eas.fm.fs.TransDownBillEntryInfo;
import com.kingdee.eas.fm.fs.TransUpBillEntryFactory;
import com.kingdee.eas.fm.fs.TransUpBillEntryInfo;
import com.kingdee.eas.framework.BillBaseCollection;
import com.kingdee.eas.framework.IBillBase;
import com.kingdee.eas.framework.IBillEntryBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BookNotifyFacadeControllerBean
extends AbstractBookNotifyFacadeControllerBean {
    public static final BOSObjectType VOUCHER_BOSTYPE = new VoucherInfo().getBOSType();
    public static final BOSObjectType VOUCHER_ENTRY_BOSTYPE = new VoucherEntryInfo().getBOSType();
    private static Logger logger = Logger.getLogger(BookNotifyFacadeControllerBean.class);

    @Override
    protected IObjectCollection _genJournalCollection(Context ctx, String builderName, String billId) throws BOSException, EASBizException {
        return BookNotifyFactory.getInstance(builderName).getJournalColl(ctx, billId);
    }

    protected IObjectCollection _genJournalCollection(Context ctx, String builderName, Set ids) throws BOSException, EASBizException {
        return BookNotifyFactory.getInstance(builderName).getJournalColl(ctx, ids);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _checkStatus(Context ctx, String voucherId) throws BOSException, EASBizException {
        block11: {
            block10: {
                sql = "SELECT FCreateDate,FVerifyStatus,FCompanyid FROM T_CAS_Journal WHERE FBillId = ?";
                conn = null;
                pstmt = null;
                rs = null;
                try {
                    conn = this.getConnection(ctx);
                    pstmt = conn.prepareStatement(sql);
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)voucherId);
                    rs = pstmt.executeQuery();
                    periodInfo = null;
                    company = null;
lbl12:
                    // 2 sources

                    while (rs.next()) {
                        verifyStatus = rs.getInt("FVerifyStatus");
                        createDate = rs.getDate("FCreateDate");
                        companyid = rs.getString("FCompanyid");
                        if (company == null && companyid != null) {
                            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
                        }
                        if (periodInfo == null && company != null) {
                            periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, company);
                        }
                        if (periodInfo == null) {
                            break block10;
                        }
                        ** GOTO lbl-1000
                    }
                    break block11;
                }
                catch (SQLException e) {
                    try {
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable var12_13) {
                        SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                        throw var12_13;
                    }
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
            return;
lbl-1000:
            // 1 sources

            {
                if (verifyStatus == 1) {
                    throw new BookNotifyException(BookNotifyException.ALREADY_VERIFY);
                }
                if (!periodInfo.getBeginDate().after(createDate)) ** GOTO lbl12
                throw new BookNotifyException(BookNotifyException.ALREADY_VERIFY);
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    @Override
    protected void _batchAntiBook(Context ctx, Set idSet) throws BOSException, EASBizException {
        if (EmptyUtil.isEmpty((Collection)idSet)) {
            return;
        }
        this.batchCheckStatus(ctx, idSet);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("billId", (Object)idSet, CompareType.INCLUDE));
        IJournal journal = JournalFactory.getLocalInstance(ctx);
        journal.delete(fi);
    }

    private void batchAntiBook(Context ctx, Set idSet, PeriodInfo currentPeriod) throws BOSException, EASBizException {
        if (EmptyUtil.isEmpty((Collection)idSet)) {
            return;
        }
        this.batchCheckStatus(ctx, idSet, currentPeriod);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("billId", (Object)idSet, CompareType.INCLUDE));
        IJournal journal = JournalFactory.getLocalInstance(ctx);
        journal.delete(fi);
    }

    private void batchCheckStatus(Context ctx, Set idSet) throws BOSException, EASBizException {
        String sql = "SELECT FCreateDate,FVerifyStatus ,FCompanyid FROM T_CAS_Journal WHERE FBillId in " + FMHelper.setTran2String((Set)idSet);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        PeriodInfo periodInfo = null;
        int verifyStatus = -1;
        Date createDate = null;
        try {
            while (rs.next()) {
                verifyStatus = rs.getInt("FVerifyStatus");
                createDate = rs.getDate("FCreateDate");
                String companyid = rs.getString("FCompanyid");
                if (!EmptyUtil.isEmpty((String)companyid)) {
                    companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
                }
                if (companyInfo != null) {
                    periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
                }
                if (periodInfo == null) continue;
                if (verifyStatus == 1) {
                    throw new BookNotifyException(BookNotifyException.ALREADY_VERIFY);
                }
                if (!periodInfo.getBeginDate().after(createDate)) continue;
                throw new BookNotifyException(BookNotifyException.ALREADY_VERIFY);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void batchCheckStatus(Context ctx, Set idSet, PeriodInfo currentPeriod) throws BOSException, EASBizException {
        String sql = "SELECT FCreateDate,FVerifyStatus FROM T_CAS_Journal WHERE FBillId in " + FMHelper.setTran2String((Set)idSet);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (currentPeriod == null) {
            return;
        }
        int verifyStatus = -1;
        Date createDate = null;
        try {
            while (rs.next()) {
                verifyStatus = rs.getInt("FVerifyStatus");
                createDate = rs.getDate("FCreateDate");
                if (verifyStatus == 1) {
                    throw new BookNotifyException(BookNotifyException.ALREADY_VERIFY);
                }
                if (!currentPeriod.getBeginDate().after(createDate)) continue;
                throw new BookNotifyException(BookNotifyException.ALREADY_VERIFY);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _antiBook(Context ctx, String billId) throws BOSException, EASBizException {
        this._checkStatus(ctx, billId);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        IJournal journal = JournalFactory.getLocalInstance(ctx);
        journal.delete(fi);
    }

    @Override
    protected BookMessageInfo _book(Context ctx, String builderName, String billId) throws BOSException, EASBizException {
        IContextHelper localInstance = ContextHelperFactory.getLocalInstance((Context)ctx);
        BOSUuid id = BOSUuid.read((String)billId);
        BOSObjectType type = id.getType();
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(billId);
        BillBaseCollection coll = this.getBillBaseInfo(ctx, id, idSet);
        int val = 0;
        val = !EmptyUtil.isEmpty((AbstractObjectCollection)coll) || coll.size() > 0 ? localInstance.getIntParam("CS001", (IObjectPK)new ObjectUuidPK(coll.get(0).getCompany().getId().toString())) : localInstance.getIntParam("CS001", (IObjectPK)new ObjectUuidPK(localInstance.getCurrentCompany().getId().toString()));
        if (logger.isInfoEnabled()) {
            logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"55_BookNotifyFacadeControllerBean", (Locale)ctx.getLocale()) + val));
        }
        if (val == 0 && !type.equals((Object)VOUCHER_BOSTYPE) && !type.equals((Object)VOUCHER_ENTRY_BOSTYPE)) {
            JournalCollection journalCollection = (JournalCollection)this._genJournalCollection(ctx, builderName, billId);
            return this._bookBatch(ctx, (IObjectCollection)journalCollection);
        }
        if (val == 1 && (type.equals((Object)VOUCHER_BOSTYPE) || type.equals((Object)VOUCHER_ENTRY_BOSTYPE))) {
            JournalCollection journalCollection = (JournalCollection)this._genJournalCollection(ctx, builderName, billId);
            return this._bookBatch(ctx, (IObjectCollection)journalCollection);
        }
        return BookMessageInfo.BookTypeMismatchBillType(ctx);
    }

    private void checkCashSystemStatus(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException, CasException {
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        if (startPeriod == null) {
            throw new CasException(CasException.STARTPERIODNULL);
        }
    }

    private void checkIsSameCompany(Context ctx, JournalCollection journalC) throws EASBizException {
        int size = journalC.size();
        JournalInfo journalInfo = journalC.get(0);
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)journalInfo, (String)"company");
        String firstCompanyID = journalInfo.getCompany().getId().toString();
        for (int i = 1; i < size; ++i) {
            journalInfo = journalC.get(i);
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)journalInfo, (String)"company");
            if (firstCompanyID.equals(journalInfo.getCompany().getId().toString())) continue;
            throw new CasException(CasException.NOTSAMECOMPANY);
        }
    }

    @Override
    protected BookMessageInfo _bookBatch(Context ctx, IObjectCollection journalCollection) throws BOSException, EASBizException {
        int val;
        JournalCollection journalC = (JournalCollection)journalCollection;
        if (journalC == null || journalC.size() == 0) {
            return BookMessageInfo.NoJournalCollection(ctx);
        }
        this.checkIsSameCompany(ctx, journalC);
        String billId = journalC.get(0).getBillId();
        BOSUuid id = BOSUuid.read((String)billId);
        BOSObjectType type = id.getType();
        IContextHelper localInstance = ContextHelperFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo company = journalC.get(0).getCompany();
        if (company == null) {
            company = localInstance.getCurrentCompany();
        }
        if ((val = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("CS001", (IObjectPK)new ObjectUuidPK(company.getId()))) == 2) {
            return BookMessageInfo.BookByHand(ctx);
        }
        if (val == 0 && (type.equals((Object)VOUCHER_BOSTYPE) || type.equals((Object)VOUCHER_ENTRY_BOSTYPE))) {
            return BookMessageInfo.BookTypeMismatchBillType(ctx);
        }
        if (val == 1 && !type.equals((Object)VOUCHER_BOSTYPE) && !type.equals((Object)VOUCHER_ENTRY_BOSTYPE)) {
            return BookMessageInfo.BookTypeMismatchBillType(ctx);
        }
        this.checkCashSystemStatus(ctx, company);
        JournalInfo journalInfo = null;
        UserInfo user = localInstance.getCurrentUser();
        PeriodInfo currenPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        HashMap currency_precision = new HashMap(10);
        int size = journalCollection.size();
        for (int i = 0; i < size; ++i) {
            journalInfo = (JournalInfo)journalCollection.getObject(i);
            journalInfo.setHasEffected(true);
            journalInfo.setCashier(user);
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)journalInfo, (String)"company");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)journalInfo, (String)"billId");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)journalInfo, (String)"createDate");
            if (!journalInfo.isAgentBook() && !company.getId().equals((Object)journalInfo.getCompany().getId())) {
                throw new CasException(CasException.NOCURCOMPANY);
            }
            if (journalInfo.getCreditAmount() == null) {
                journalInfo.setCreditAmount(CasConstants.ZERO);
            }
            if (journalInfo.getDebitAmount() == null) {
                journalInfo.setDebitAmount(CasConstants.ZERO);
            }
            if (journalInfo.getDebitAmount().signum() != 0) {
                journalInfo.setIsDebit(true);
            } else {
                journalInfo.setIsDebit(false);
            }
            if (currenPeriodInfo != null && journalInfo.getCreateDate() != null && currenPeriodInfo.getBeginDate().after(journalInfo.getCreateDate())) {
                journalInfo.setCreateDate(currenPeriodInfo.getBeginDate());
                journalInfo.setPeriod(currenPeriodInfo);
            }
            if (journalInfo.getPeriod() == null) {
                PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (java.util.Date)journalInfo.getCreateDate(), (CompanyOrgUnitInfo)journalInfo.getCompany());
                if (period == null || period.getId() == null) {
                    throw new CasException(CasException.PERIODISNULL);
                }
                journalInfo.setPeriod(period);
            }
            if (journalInfo.getPeriod().isIsAdjustPeriod() || currenPeriodInfo.isIsAdjustPeriod()) {
                throw new CasException(CasException.ADJUSTCANNOTBOOK);
            }
            if (journalInfo.getCurrency() == null || journalInfo.getCurrency().getId() == null || !journalInfo.getType().equals((Object)JournalTypeEnum.BANK)) continue;
            Object oPrecision = currency_precision.get(journalInfo.getCurrency().getId());
            if (oPrecision == null) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("precision");
                CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(journalInfo.getCurrency().getId()), selector);
                oPrecision = new Integer(currency.getPrecision());
                currency_precision.put(journalInfo.getCurrency().getId(), oPrecision);
            }
            journalInfo.setCreditAmount(journalInfo.getCreditAmount().setScale((int)((Integer)oPrecision), 4));
            journalInfo.setDebitAmount(journalInfo.getDebitAmount().setScale((int)((Integer)oPrecision), 4));
        }
        boolean CS115 = localInstance.getBooleanParam("CS115", (IObjectPK)new ObjectUuidPK(company.getId()));
        JournalCollection newjournalCollection = new JournalCollection();
        int size2 = journalC.size();
        for (int i = 0; i < size2; ++i) {
            JournalInfo info = journalC.get(i);
            if (CS115 && info.getType().equals((Object)JournalTypeEnum.BANK) && info.getAccountBank() == null) continue;
            if (info.getDebitAmount() != null && info.getDebitAmount().signum() != 0) {
                newjournalCollection.add(info);
                continue;
            }
            if (info.getCreditAmount() == null || info.getCreditAmount().signum() == 0) continue;
            newjournalCollection.add(info);
        }
        IJournal journal = JournalFactory.getLocalInstance(ctx);
        HashSet<String> billIds = new HashSet<String>();
        for (int i = 0; i < journalC.size(); ++i) {
            String srcBillId = journalC.get(i).getBillId();
            if (EmptyUtil.isEmpty((String)srcBillId)) continue;
            billIds.add(srcBillId);
        }
        this.batchAntiBook(ctx, billIds, currenPeriodInfo);
        journal.addBatch((IObjectCollection)newjournalCollection);
        return BookMessageInfo.Success(ctx);
    }

    @Override
    protected void _bookModify(Context ctx, String billId, IObjectCollection journalCollection) throws BOSException, EASBizException {
        if (EmptyUtil.isEmpty((String)billId)) {
            return;
        }
        if (journalCollection == null || journalCollection.size() == 0) {
            return;
        }
        this._antiBook(ctx, billId);
        this._bookBatch(ctx, journalCollection);
    }

    protected void _checkStatusByEntry(Context ctx, String entryid) throws BOSException, EASBizException {
    }

    protected void _bookModifyByEntry(Context ctx, String billId, IObjectCollection jouranlColl) throws BOSException, EASBizException {
    }

    @Override
    protected BookMessageInfo _bookBatchSet(Context ctx, String builderName, Set idSet) throws BOSException, EASBizException {
        IContextHelper localInstance = ContextHelperFactory.getLocalInstance((Context)ctx);
        if (EmptyUtil.isEmpty((Collection)idSet)) {
            return BookMessageInfo.NoJournalCollection(ctx);
        }
        BOSUuid id = BOSUuid.read((String)idSet.toArray()[0].toString());
        BOSObjectType type = id.getType();
        int i = 0;
        BillBaseCollection coll = this.getBillBaseInfo(ctx, id, idSet);
        if (i < coll.size()) {
            ObjectUuidPK orgPK = new ObjectUuidPK(coll.get(i).getCompany().getId());
            HashSet<String> tmpSet = new HashSet<String>();
            tmpSet.add(coll.get(i).getId().toString());
            int val = localInstance.getIntParam("CS001", (IObjectPK)orgPK);
            if (logger.isInfoEnabled()) {
                logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"55_BookNotifyFacadeControllerBean", (Locale)ctx.getLocale()) + val));
            }
            if (val == 0 && !type.equals((Object)VOUCHER_BOSTYPE) && !type.equals((Object)VOUCHER_ENTRY_BOSTYPE)) {
                JournalCollection journalCollection = (JournalCollection)this._genJournalCollection(ctx, builderName, tmpSet);
                RecPayHelper.clearFundFlowJournal(journalCollection);
                return this._bookBatch(ctx, (IObjectCollection)journalCollection);
            }
            if (val == 1 && (type.equals((Object)VOUCHER_BOSTYPE) || type.equals((Object)VOUCHER_ENTRY_BOSTYPE))) {
                JournalCollection journalCollection = (JournalCollection)this._genJournalCollection(ctx, builderName, tmpSet);
                return this._bookBatch(ctx, (IObjectCollection)journalCollection);
            }
            return BookMessageInfo.BookTypeMismatchBillType(ctx);
        }
        return BookMessageInfo.NoJournalCollection(ctx);
    }

    private BillBaseCollection getBillBaseInfo(Context ctx, BOSUuid uuid, Set idSet) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("company.id");
        evi.getSelector().add("company.name");
        evi.getSelector().add("company.number");
        IBillBase iBillBase = null;
        if (BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)uuid.getType()) instanceof IBillBase) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            iBillBase = (IBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)uuid.getType());
        } else if (BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)uuid.getType()) instanceof IBillEntryBase) {
            Object entry;
            Object item = null;
            String entiryID = (String)idSet.iterator().next();
            if ("71AA9AF4".equals(uuid.getType().toString())) {
                entry = (VoucherEntryInfo)VoucherEntryFactory.getLocalInstance((Context)ctx).getBillEntryBaseInfo((IObjectPK)new ObjectUuidPK(entiryID));
                item = entry.getBill();
            } else if ("12A8AE34".equals(uuid.getType().toString())) {
                entry = (TransUpBillEntryInfo)TransUpBillEntryFactory.getLocalInstance((Context)ctx).getBillEntryBaseInfo((IObjectPK)new ObjectUuidPK(entiryID));
                item = entry.getParent();
            } else if ("43CC870D".equals(uuid.getType().toString())) {
                entry = (TransDownBillEntryInfo)TransDownBillEntryFactory.getLocalInstance((Context)ctx).getBillEntryBaseInfo((IObjectPK)new ObjectUuidPK(entiryID));
                item = entry.getParent();
            } else if ("92F9B271".equals(uuid.getType().toString())) {
                entry = (PaymentBillEntryInfo)PaymentBillEntryFactory.getLocalInstance(ctx).getBillEntryBaseInfo((IObjectPK)new ObjectUuidPK(entiryID));
                item = ((AbstractPaymentBillEntryInfo)entry).getPaymentBill();
            } else if ("299A3BD7".equals(uuid.getType().toString())) {
                entry = (ReceivingBillEntryInfo)ReceivingBillEntryFactory.getLocalInstance(ctx).getBillEntryBaseInfo((IObjectPK)new ObjectUuidPK(entiryID));
                item = ((AbstractReceivingBillEntryInfo)entry).getReceivingBill();
            } else {
                throw new CasException(CasException.NOENTRYBOOK);
            }
            iBillBase = (IBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)item.getId().getType());
            HashSet<String> set = new HashSet<String>();
            set.add(item.getId().toString());
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            evi.setFilter(filter);
        }
        return iBillBase.getBillBaseCollection(evi);
    }

    @Override
    protected void _clientBook(Context ctx, String builderName, Set billSet) throws BOSException, EASBizException {
        for (Map idMap : billSet) {
            HashSet<String> idSet = new HashSet<String>();
            String id = (String)idMap.get("id");
            String number = (String)idMap.get("number");
            idSet.add(id);
            logger.info((Object)"=====================================");
            logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"56_BookNotifyFacadeControllerBean", (Locale)ctx.getLocale()) + number + "--------"));
            this._book(ctx, builderName, id);
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"57_BookNotifyFacadeControllerBean", (Locale)ctx.getLocale()));
            logger.info((Object)"=====================================");
        }
    }

    @Override
    protected BookMessageInfo _book(Context ctx, String billId, JournalCollection journalC, int cs001, PeriodInfo startPeriod, PeriodInfo currenPeriod) throws BOSException, EASBizException {
        BOSObjectType type = BOSUuid.read((String)billId).getType();
        if (logger.isInfoEnabled()) {
            logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"55_BookNotifyFacadeControllerBean", (Locale)ctx.getLocale()) + cs001));
        }
        boolean isBook = false;
        if (cs001 == 0 && !type.equals((Object)VOUCHER_BOSTYPE) && !type.equals((Object)VOUCHER_ENTRY_BOSTYPE)) {
            isBook = true;
        }
        if (cs001 == 1 && (type.equals((Object)VOUCHER_BOSTYPE) || type.equals((Object)VOUCHER_ENTRY_BOSTYPE))) {
            isBook = true;
        }
        if (!isBook) {
            return BookMessageInfo.BookTypeMismatchBillType(ctx);
        }
        CompanyOrgUnitInfo company = journalC.get(0).getCompany();
        if (cs001 == 2) {
            return BookMessageInfo.BookByHand(ctx);
        }
        if (cs001 == 0 && (type.equals((Object)VOUCHER_BOSTYPE) || type.equals((Object)VOUCHER_ENTRY_BOSTYPE))) {
            return BookMessageInfo.BookTypeMismatchBillType(ctx);
        }
        if (cs001 == 1 && !type.equals((Object)VOUCHER_BOSTYPE) && !type.equals((Object)VOUCHER_ENTRY_BOSTYPE)) {
            return BookMessageInfo.BookTypeMismatchBillType(ctx);
        }
        if (startPeriod == null) {
            throw new CasException(CasException.STARTPERIODNULL);
        }
        IContextHelper localInstance = ContextHelperFactory.getLocalInstance((Context)ctx);
        JournalInfo journalInfo = null;
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        int size = journalC.size();
        for (int i = 0; i < size; ++i) {
            journalInfo = journalC.get(i);
            journalInfo.setHasEffected(true);
            journalInfo.setCashier(user);
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)journalInfo, (String)"company");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)journalInfo, (String)"billId");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)journalInfo, (String)"createDate");
            if (!journalInfo.isAgentBook() && !company.getId().equals((Object)journalInfo.getCompany().getId())) {
                throw new CasException(CasException.NOCURCOMPANY);
            }
            if (journalInfo.getCreditAmount() == null) {
                journalInfo.setCreditAmount(CasConstants.ZERO);
            }
            if (journalInfo.getDebitAmount() == null) {
                journalInfo.setDebitAmount(CasConstants.ZERO);
            }
            if (journalInfo.getDebitAmount().signum() != 0) {
                journalInfo.setIsDebit(true);
            } else {
                journalInfo.setIsDebit(false);
            }
            if (currenPeriod != null && journalInfo.getCreateDate() != null && currenPeriod.getBeginDate().after(journalInfo.getCreateDate())) {
                journalInfo.setCreateDate(currenPeriod.getBeginDate());
                journalInfo.setPeriod(currenPeriod);
            }
            if (journalInfo.getPeriod() == null) {
                PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (java.util.Date)journalInfo.getCreateDate(), (CompanyOrgUnitInfo)journalInfo.getCompany());
                if (period == null || period.getId() == null) {
                    throw new CasException(CasException.PERIODISNULL);
                }
                journalInfo.setPeriod(period);
            }
            if (journalInfo.getPeriod().isIsAdjustPeriod() || currenPeriod.isIsAdjustPeriod()) {
                throw new CasException(CasException.ADJUSTCANNOTBOOK);
            }
            if (journalInfo.getCurrency() == null || journalInfo.getCurrency().getId() == null || !journalInfo.getType().equals((Object)JournalTypeEnum.BANK)) continue;
            int precision = journalInfo.getCurrency().getPrecision();
            journalInfo.setCreditAmount(journalInfo.getCreditAmount().setScale(precision, 4));
            journalInfo.setDebitAmount(journalInfo.getDebitAmount().setScale(precision, 4));
        }
        JournalCollection newjournalCollection = new JournalCollection();
        int size2 = journalC.size();
        for (int i = 0; i < size2; ++i) {
            JournalInfo info = journalC.get(i);
            if (info.getDebitAmount() != null && info.getDebitAmount().signum() != 0) {
                newjournalCollection.add(info);
                continue;
            }
            if (info.getCreditAmount() == null || info.getCreditAmount().signum() == 0) continue;
            newjournalCollection.add(info);
        }
        IJournal journal = JournalFactory.getLocalInstance(ctx);
        HashSet<String> billIds = new HashSet<String>();
        for (int i = 0; i < journalC.size(); ++i) {
            String srcBillId = journalC.get(i).getBillId();
            if (EmptyUtil.isEmpty((String)srcBillId)) continue;
            billIds.add(srcBillId);
        }
        this.batchAntiBook(ctx, billIds, currenPeriod);
        journal.addBatch((IObjectCollection)newjournalCollection);
        return BookMessageInfo.Success(ctx);
    }
}

