/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.BizBalanceException;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.BizHasDealException;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.IBizCheckBalance;
import com.kingdee.eas.common.app.IBizHasDeal;
import com.kingdee.eas.common.app.IBizReference;
import com.kingdee.eas.fi.cas.BankStatementInfo;
import com.kingdee.eas.fi.cas.FinalCheckoutFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMQuerySqlBuilder;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class CASAccountCheckBalance
implements IBizCheckBalance,
IBizReference,
IBizHasDeal {
    private static Logger logger = Logger.getLogger((String)CASAccountCheckBalance.class.getName());

    private boolean isEnbale(Context ctx, BOSUuid id) throws BOSException {
        String sql = "select fisenabled from t_bd_acctrefcontrast where fid=? ";
        try {
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id.toString()});
            if (set != null && set.next()) {
                boolean enb = set.getBoolean("fisenabled");
                return enb;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    public BizCheckResult checkHasBalance(Context ctx, BOSUuid id) throws BizBalanceException {
        return null;
    }

    public BizCheckResult checkReferenced(Context ctx, BOSUuid id) throws BizReferenceException {
        return null;
    }

    public BizCheckResult checkHasDeal(Context ctx, BOSUuid acrefid) throws BizHasDealException {
        boolean isEnabled = true;
        try {
            isEnabled = this.isEnbale(ctx, acrefid);
            if (isEnabled) {
                this.doCheckHasDealCommon(ctx, acrefid);
                this.doCheckHasDeal(ctx, acrefid);
            } else {
                this.undoCheckHasDealCommon(ctx, acrefid);
                this.undoCheckHasDeal(ctx, acrefid);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new BizHasDealException(BizHasDealException.CHECK_ERROR, (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw new BizHasDealException(BizHasDealException.CHECK_ERROR, (Throwable)e);
        }
        return new BizCheckResult(false);
    }

    private void undoCheckHasDeal(Context ctx, BOSUuid acctrefId) throws BOSException, EASBizException {
        String companyId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        SystemStatusCtrolCollection coll = this.getSystemStauesColl(ctx, companyId);
        PeriodInfo cperiod = null;
        HashSet<String> companySet = new HashSet<String>();
        if (coll.size() == 0) {
            return;
        }
        for (int i = 0; i < coll.size(); ++i) {
            SystemStatusCtrolInfo info = coll.get(i);
            CompanyOrgUnitInfo company = info.getCompany();
            if (cperiod != null && !info.getCurrentPeriod().equalsPK((IObjectValue)cperiod)) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"58_CASAccountCheckBalance", (Locale)ctx.getLocale()) + company + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"59_CASAccountCheckBalance", (Locale)ctx.getLocale()));
            }
            cperiod = info.getCurrentPeriod();
            companySet.add(company.getId().toString());
        }
        if (!cperiod.isIsAdjustPeriod()) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"60_CASAccountCheckBalance", (Locale)ctx.getLocale()));
        }
        PeriodInfo nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, cperiod);
        this.checkHasExistNextPeriodJournal(ctx, companySet, nextPeriod);
        this.checkHasExistNextPeriodBankStatement(ctx, companySet, nextPeriod);
    }

    private void undoCheckHasDealCommon(Context ctx, BOSUuid acctrefId) throws BOSException, EASBizException {
        String companyId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        CompanyOrgUnitCollection coll = this.getCompanyColl(ctx, companyId);
        HashSet<String> companySet = new HashSet<String>();
        if (coll.size() == 0) {
            return;
        }
        for (int i = 0; i < coll.size(); ++i) {
            companySet.add(coll.get(i).getId().toString());
        }
        this.unadjuestAccountBanks(ctx, acctrefId, companySet);
        this.unadjustIntObjects(ctx, acctrefId, companySet);
    }

    private void unYearfinal(Context ctx, Set companySet) throws BOSException, EASBizException {
        Iterator it = companySet.iterator();
        while (it.hasNext()) {
            FinalCheckoutFactory.getLocalInstance(ctx).deleteCheckAccount((String)it.next());
        }
    }

    private void deleteJournals(Context ctx, Set companySet, PeriodInfo prePeriod) throws BOSException {
        FMQuerySqlBuilder sbjournal = new FMQuerySqlBuilder();
        sbjournal.appendSql("delete  from t_cas_journal where fperiodid=? and ");
        sbjournal.addParam((Object)prePeriod.getId().toString());
        sbjournal.appendParam("fcompanyid", companySet.toArray());
        sbjournal.execute(ctx);
    }

    private void deleteBankStatements(Context ctx, Set companySet, PeriodInfo prePeriod) throws BOSException {
        FMQuerySqlBuilder sbBankstatement = new FMQuerySqlBuilder();
        sbBankstatement.appendSql("delete  from t_cas_bankstatement where fperiodid=? and ");
        sbBankstatement.addParam((Object)prePeriod.getId().toString());
        sbBankstatement.appendParam("fcompanyid", companySet.toArray());
        sbBankstatement.execute(ctx);
    }

    private void doCheckHasDealCommon(Context ctx, BOSUuid acctrefId) throws BOSException, EASBizException {
        String companyId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        CompanyOrgUnitCollection coll = this.getCompanyColl(ctx, companyId);
        HashSet<String> companySet = new HashSet<String>();
        if (coll.size() == 0) {
            return;
        }
        for (int i = 0; i < coll.size(); ++i) {
            companySet.add(coll.get(i).getId().toString());
        }
        this.adjuestAccountBanks(ctx, acctrefId, companySet);
        this.adjustIntObjects(ctx, acctrefId, companySet);
    }

    private CompanyOrgUnitCollection getCompanyColl(Context ctx, String companyId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)companyId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        return iCompany.getCompanyOrgUnitCollection(evi);
    }

    private void doCheckHasDeal(Context ctx, BOSUuid acctrefId) throws BOSException, EASBizException {
        String companyId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        SystemStatusCtrolCollection coll = this.getSystemStauesColl(ctx, companyId);
        PeriodInfo curPeriod = null;
        HashSet<String> companySet = new HashSet<String>();
        if (coll.size() == 0) {
            return;
        }
        for (int i = 0; i < coll.size(); ++i) {
            SystemStatusCtrolInfo info = coll.get(i);
            CompanyOrgUnitInfo company = info.getCompany();
            if (curPeriod != null && !info.getCurrentPeriod().equalsPK((IObjectValue)curPeriod)) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"58_CASAccountCheckBalance", (Locale)ctx.getLocale()) + company + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"59_CASAccountCheckBalance", (Locale)ctx.getLocale()));
            }
            curPeriod = info.getCurrentPeriod();
            companySet.add(company.getId().toString());
        }
        if (curPeriod != null && !curPeriod.isIsAdjustPeriod()) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"61_CASAccountCheckBalance", (Locale)ctx.getLocale()));
        }
        PeriodInfo nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, curPeriod);
        this.checkHasExistNextPeriodJournal(ctx, companySet, nextPeriod);
        this.checkHasExistNextPeriodBankStatement(ctx, companySet, nextPeriod);
        this.genJournalOut(ctx, acctrefId, curPeriod, companySet);
        this.genJournalIn(ctx, acctrefId, curPeriod, companySet);
        this.genBankStatementOut(ctx, acctrefId, curPeriod, companySet);
        this.genBankStatementIn(ctx, acctrefId, curPeriod, companySet);
        this.finnalCheckOut(ctx, companySet);
        this.deleteZeroBalance(ctx, companySet, nextPeriod);
        this.deleteJournals(ctx, companySet, curPeriod);
        this.deleteBankStatements(ctx, companySet, curPeriod);
    }

    private void checkHasExistNextPeriodJournal(Context ctx, Set companySet, PeriodInfo nextPeriod) throws BOSException {
        FMQuerySqlBuilder sql = new FMQuerySqlBuilder();
        sql.appendSql("select fid from t_cas_journal where fcreatedate >= ? ");
        sql.addParam((Object)DateTimeUtils.truncateDate((Date)nextPeriod.getBeginDate()));
        sql.appendSql(" and ");
        sql.appendParam("fcompanyid", companySet.toArray());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.getTestSql());
        if (rs != null && rs.size() > 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"62_CASAccountCheckBalance", (Locale)ctx.getLocale()));
        }
    }

    private void checkHasExistNextPeriodBankStatement(Context ctx, Set companySet, PeriodInfo nextPeriod) throws BOSException {
        FMQuerySqlBuilder sql = new FMQuerySqlBuilder();
        sql.appendSql("select fid from t_cas_bankstatement where fcreatedate >= ? ");
        sql.addParam((Object)DateTimeUtils.truncateDate((Date)nextPeriod.getBeginDate()));
        sql.appendSql(" and ");
        sql.appendParam("fcompanyid", companySet.toArray());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.getTestSql());
        if (rs != null && rs.size() > 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"63_CASAccountCheckBalance", (Locale)ctx.getLocale()));
        }
    }

    private void finnalCheckOut(Context ctx, Set companySet) throws BOSException, EASBizException {
        Iterator it = companySet.iterator();
        while (it.hasNext()) {
            FinalCheckoutFactory.getLocalInstance(ctx).finalCheckAccount((String)it.next());
        }
    }

    private SystemStatusCtrolCollection getSystemStauesColl(Context ctx, String companyId) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isStart", (Object)FMConstants.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("systemStatus.name", (Object)new Integer(7)));
        ev.setFilter(filter);
        ev.getSelector().add("*");
        ev.getSelector().add("company.*");
        ev.getSelector().add("currentPeriod.*");
        SystemStatusCtrolCollection coll = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getSystemStatusCtrolCollection(ev);
        return coll;
    }

    private void deleteZeroBalance(Context ctx, Set companySet, PeriodInfo nextPeriod) throws BOSException {
        FMQuerySqlBuilder sb_deleteZeroBalance = new FMQuerySqlBuilder();
        sb_deleteZeroBalance.appendSql("delete FROM T_CAS_journalBalance where FMONTHSTARTAMT=0 and fperiodid=? and   ");
        sb_deleteZeroBalance.addParam((Object)nextPeriod.getId().toString());
        sb_deleteZeroBalance.appendParam("fcompanyid", companySet.toArray());
        sb_deleteZeroBalance.execute(ctx);
    }

    private void adjustIntObjects(Context ctx, BOSUuid acctrefId, Set companySet) throws BOSException {
        FMQuerySqlBuilder sb_acctBank = new FMQuerySqlBuilder();
        sb_acctBank.appendSql("update t_int_intobject set (fsourceId,fcontrolunitid )=  (select  fnewacctid,t_int_intobject.fcontrolunitid from T_BD_AcctRefContrastentry where  foldacctid=fsourceId and  FACCTREFCONTRASTID=?");
        sb_acctBank.appendSql(" and ");
        sb_acctBank.addParam((Object)acctrefId.toString());
        sb_acctBank.appendParam("t_int_intobject.fcompanyid", companySet.toArray());
        sb_acctBank.appendSql(" and t_int_intobject.fsourceType=1   ) ");
        DbUtil.execute((Context)ctx, (String)sb_acctBank.getTestSql());
        this.synIntObjectName(ctx, companySet);
        this.updateFinanceAtrrField(ctx, acctrefId, companySet, "FaccuralAccountID");
        this.updateFinanceAtrrField(ctx, acctrefId, companySet, "FrecPayedAcctID");
        this.updateFinanceAtrrField(ctx, acctrefId, companySet, "FrecPayableAcctID");
        this.updateFinanceAtrrField(ctx, acctrefId, companySet, "FoverAccountID");
        this.updateFinanceAtrrField(ctx, acctrefId, companySet, "FarrearAccountID");
        this.updateFinanceAtrrField(ctx, acctrefId, companySet, "FfeeAccountID");
        this.updateFinanceAtrrField(ctx, acctrefId, companySet, "FtaxAccountID");
    }

    private void unadjustIntObjects(Context ctx, BOSUuid acctrefId, Set companySet) throws BOSException {
        FMQuerySqlBuilder sb_acctBank = new FMQuerySqlBuilder();
        sb_acctBank.appendSql("update t_int_intobject set (fsourceId, fcontrolunitid)=  (select  foldacctid,t_int_intobject.fcontrolunitid  from T_BD_AcctRefContrastentry where  fnewacctid=fsourceId and  FACCTREFCONTRASTID=?");
        sb_acctBank.appendSql(" and ");
        sb_acctBank.addParam((Object)acctrefId.toString());
        sb_acctBank.appendParam("t_int_intobject.fcompanyid", companySet.toArray());
        sb_acctBank.appendSql(" and t_int_intobject.fsourceType=1   ) ");
        DbUtil.execute((Context)ctx, (String)sb_acctBank.getTestSql());
        this.synIntObjectName(ctx, companySet);
        this.unupdateFinanceAtrrField(ctx, acctrefId, companySet, "FaccuralAccountID");
        this.unupdateFinanceAtrrField(ctx, acctrefId, companySet, "FrecPayedAcctID");
        this.unupdateFinanceAtrrField(ctx, acctrefId, companySet, "FrecPayableAcctID");
        this.unupdateFinanceAtrrField(ctx, acctrefId, companySet, "FoverAccountID");
        this.unupdateFinanceAtrrField(ctx, acctrefId, companySet, "FarrearAccountID");
        this.unupdateFinanceAtrrField(ctx, acctrefId, companySet, "FfeeAccountID");
        this.unupdateFinanceAtrrField(ctx, acctrefId, companySet, "FtaxAccountID");
    }

    private void synIntObjectName(Context ctx, Set companySet) throws BOSException {
        FMQuerySqlBuilder sb_synName = new FMQuerySqlBuilder();
        sb_synName.appendSql("UPDATE t_int_intobject SET (fnumber, fname_l1, fname_l2, fname_l3) =  (SELECT T_BD_accountview.fnumber, T_BD_accountview.fname_l1, T_BD_accountview.fname_l2, T_BD_accountview.fname_l3  FROM T_BD_accountview WHERE fsourceId = T_BD_accountview.fid ");
        sb_synName.appendSql(" and ");
        sb_synName.appendParam("t_int_intobject.fcompanyid", companySet.toArray());
        sb_synName.appendSql(" and t_int_intobject.fsourceType=1  ) ");
        DbUtil.execute((Context)ctx, (String)sb_synName.getTestSql());
    }

    private void updateFinanceAtrrField(Context ctx, BOSUuid acctrefId, Set companySet, String fieldname) throws BOSException {
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql("update t_int_IntObjectFinance set (" + fieldname + ", fcontrolunitid) =(select  fnewacctid,t_int_IntObjectFinance.fcontrolunitid from T_BD_AcctRefContrastentry where foldacctid=" + fieldname + " and  FACCTREFCONTRASTID=?  and  t_int_IntObjectFinance.fid in ( select ffinanceAttrid from t_int_intobject where ");
        sb.addParam((Object)acctrefId.toString());
        sb.appendParam("fcompanyid", companySet.toArray());
        sb.appendSql("))");
        DbUtil.execute((Context)ctx, (String)sb.getTestSql());
    }

    private void unupdateFinanceAtrrField(Context ctx, BOSUuid acctrefId, Set companySet, String fieldname) throws BOSException {
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql("update t_int_IntObjectFinance set (" + fieldname + ", fcontrolunitid) =(select  foldacctid,t_int_IntObjectFinance.fcontrolunitid from T_BD_AcctRefContrastentry where fnewacctid=" + fieldname + " and  FACCTREFCONTRASTID=?  and  t_int_IntObjectFinance.fid in ( select ffinanceAttrid from t_int_intobject where ");
        sb.addParam((Object)acctrefId.toString());
        sb.appendParam("fcompanyid", companySet.toArray());
        sb.appendSql("))");
        DbUtil.execute((Context)ctx, (String)sb.getTestSql());
    }

    private void adjuestAccountBanks(Context ctx, BOSUuid acctrefId, Set companySet) throws BOSException {
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql("update t_bd_accountbanks set (faccountid, fcontrolunitid )=  (select  fnewacctid, t_bd_accountbanks.fcontrolunitid from T_BD_AcctRefContrastentry where  foldacctid=faccountid and  FACCTREFCONTRASTID=?");
        sb.appendSql(" and ");
        sb.addParam((Object)acctrefId.toString());
        sb.appendParam("t_bd_accountbanks.fcompanyid", companySet.toArray());
        sb.appendSql("   ) ");
        DbUtil.execute((Context)ctx, (String)sb.getTestSql());
    }

    private void unadjuestAccountBanks(Context ctx, BOSUuid acctrefId, Set companySet) throws BOSException {
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql("update t_bd_accountbanks set (faccountid ,fcontrolunitid)=  (select  foldacctid ,t_bd_accountbanks.fcontrolunitid from T_BD_AcctRefContrastentry where  fnewacctid=faccountid and  FACCTREFCONTRASTID=?");
        sb.appendSql(" and ");
        sb.addParam((Object)acctrefId.toString());
        sb.appendParam("t_bd_accountbanks.fcompanyid", companySet.toArray());
        sb.appendSql("   ) ");
        DbUtil.execute((Context)ctx, (String)sb.getTestSql());
    }

    private void genJournalIn(Context ctx, BOSUuid acctrefId, PeriodInfo cperiod, Set companySetId) throws BOSException {
        JournalInfo journal = new JournalInfo();
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" INSERT INTO t_cas_journal ").appendSql(" (fid, fhaseffected, ftype, fcompanyid, faccountviewid,").appendSql("  faccountbankid, fcurrencyid, fperiodid, fdebitamount, fisdebit,").appendSql("  fsource, fcreatedate, fverifystatus,fdescription,FControlUnitID)").appendSql(" SELECT ").appendSql(" dbo.newbosid('").appendSql(journal.getBOSType().toString()).appendSql("') , 1, jb.ftype, jb.fcompanyid, ar.fnewacctid, jb.faccountbankid,").appendSql("          jb.fcurrencyid, jb.fperiodid, jb.fmonthstartamt, 1, 3,").appendSql(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"64_CASAccountCheckBalance", (Locale)ctx.getLocale())).appendSql("     FROM t_cas_journalbalance jb , T_BD_AcctRefContrastentry ar ").appendSql("    WHERE ar.foldacctid= jb.faccountviewid").appendSql("  AND jb.fperiodid = ? and  ar.FACCTREFCONTRASTID=?  ");
        sb.addParam((Object)cperiod.getBeginDate());
        sb.addParam((Object)cperiod.getId().toString());
        sb.addParam((Object)acctrefId.toString());
        sb.appendSql(" and ");
        sb.appendParam("jb.fcompanyid", companySetId.toArray());
        DbUtil.execute((Context)ctx, (String)sb.getTestSql());
    }

    private void genBankStatementOut(Context ctx, BOSUuid acctrefId, PeriodInfo cperiod, Set companySetId) throws BOSException, EASBizException {
        BankStatementInfo bankStatement = new BankStatementInfo();
        FMQuerySqlBuilder oldsb = new FMQuerySqlBuilder();
        oldsb.appendSql(" INSERT INTO t_cas_bankstatement ").appendSql(" (fid, fcompanyid, faccountviewid, faccountbankid,fcurrencyid, fperiodid, fdebitamount,").appendSql(" fisdebit, fcreatedate, fverifystatus, fdescription)").appendSql(" SELECT ").appendSql(" dbo.newbosid('").appendSql(bankStatement.getBOSType().toString()).appendSql("'), fcompanyid, ar.foldacctid, faccountbankid, fcurrencyid, ?,sum(fmonthstartamt), 1,").appendSql(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"65_CASAccountCheckBalance", (Locale)ctx.getLocale())).appendSql(" FROM (SELECT   fcompanyid, faccountviewid, faccountbankid,fcurrencyid, to_char(null) fperiodid,").appendSql("  fdebitamount - fcreditamount  fmonthstartamt").appendSql(" FROM t_cas_bankstatement where  ");
        oldsb.addParam((Object)cperiod.getId().toString());
        oldsb.addParam((Object)cperiod.getBeginDate());
        oldsb.appendParam("fcompanyid", companySetId.toArray());
        oldsb.appendSql(" UNION ").appendSql(" SELECT fcompanyid, faccountviewid, faccountbankid, fcurrencyid, to_char(null) fperiodid,fmonthstartamt").appendSql(" FROM t_cas_journalbalance WHERE   ");
        oldsb.appendParam("fcompanyid", companySetId.toArray());
        oldsb.appendSql(" and ftype = 3) a,").appendSql(" t_bd_acctrefcontrastentry ar").appendSql(" WHERE ar.foldacctid = a.faccountviewid AND ar.facctrefcontrastid = ? ").appendSql("GROUP BY a.fcompanyid, ar.foldacctid, a.faccountbankid,a.fcurrencyid  having SUM (fmonthstartamt)<>0");
        oldsb.addParam((Object)acctrefId.toString());
        DbUtil.execute((Context)ctx, (String)oldsb.getTestSql());
    }

    private void genBankStatementIn(Context ctx, BOSUuid acctrefId, PeriodInfo cperiod, Set companySetId) throws BOSException {
        BankStatementInfo bankStatement = new BankStatementInfo();
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" INSERT INTO t_cas_bankstatement ").appendSql(" (fid, fcompanyid, faccountviewid, faccountbankid,fcurrencyid, fperiodid, fcreditamount,").appendSql(" fisdebit, fcreatedate, fverifystatus, fdescription)").appendSql(" SELECT ").appendSql(" dbo.newbosid('").appendSql(bankStatement.getBOSType().toString()).appendSql("'), fcompanyid, ar.foldacctid, faccountbankid, fcurrencyid, ?,sum(fmonthstartamt), 0,").appendSql(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"66_CASAccountCheckBalance", (Locale)ctx.getLocale())).appendSql(" FROM (SELECT   fcompanyid, faccountviewid, faccountbankid,fcurrencyid,to_char( null) fperiodid,").appendSql("  fdebitamount - fcreditamount  fmonthstartamt").appendSql(" FROM t_cas_bankstatement where  ");
        sb.addParam((Object)cperiod.getId().toString());
        sb.addParam((Object)cperiod.getBeginDate());
        sb.appendParam("fcompanyid", companySetId.toArray());
        sb.appendSql(" UNION ").appendSql(" SELECT fcompanyid, faccountviewid, faccountbankid, fcurrencyid,to_char( null) fperiodid,fmonthstartamt").appendSql(" FROM t_cas_journalbalance WHERE   ");
        sb.appendParam("fcompanyid", companySetId.toArray());
        sb.appendSql(" and ftype = 3) a,").appendSql(" t_bd_acctrefcontrastentry ar").appendSql(" WHERE ar.foldacctid = a.faccountviewid AND ar.facctrefcontrastid = ? ").appendSql("GROUP BY a.fcompanyid, ar.foldacctid, a.faccountbankid,a.fcurrencyid  having SUM (fmonthstartamt)<>0");
        sb.addParam((Object)acctrefId.toString());
        DbUtil.execute((Context)ctx, (String)sb.getTestSql());
    }

    public void genJournalOut(Context ctx, BOSUuid acctrefId, PeriodInfo cperiod, Set companySetId) throws BOSException {
        JournalInfo journal = new JournalInfo();
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" INSERT INTO t_cas_journal ").appendSql(" (fid, fhaseffected, ftype, fcompanyid, faccountviewid,").appendSql("  faccountbankid, fcurrencyid, fperiodid, fcreditamount, fisdebit,").appendSql("  fsource, fcreatedate, fverifystatus,fdescription,FControlUnitID)").appendSql(" SELECT ").appendSql(" dbo.newbosid('").appendSql(journal.getBOSType().toString()).appendSql("') , 1, jb.ftype, jb.fcompanyid, ar.foldacctid, jb.faccountbankid,").appendSql("          jb.fcurrencyid, jb.fperiodid, jb.fmonthstartamt, 0, 3,").appendSql(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"67_CASAccountCheckBalance", (Locale)ctx.getLocale())).appendSql("     FROM t_cas_journalbalance jb , T_BD_AcctRefContrastentry ar ").appendSql("    WHERE ar.foldacctid= jb.faccountviewid").appendSql("  AND jb.fperiodid = ? and  ar.FACCTREFCONTRASTID=? ");
        sb.addParam((Object)cperiod.getBeginDate());
        sb.addParam((Object)cperiod.getId().toString());
        sb.addParam((Object)acctrefId.toString());
        sb.appendSql(" and ");
        sb.appendParam("jb.fcompanyid", companySetId.toArray());
        DbUtil.execute((Context)ctx, (String)sb.getTestSql());
    }
}

