/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AbstractAccountRefContrastProcess;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BankStatementFactory;
import com.kingdee.eas.fi.cas.BankStatementInfo;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fm.common.FMQuerySqlBuilder;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;

public class CASAccountRefContrastProcess
extends AbstractAccountRefContrastProcess {
    public boolean enable(Context ctx, String companyid, String acrefid) throws BOSException, EASBizException {
        int systemEnum = 7;
        String curPeriodId = super.getCurrentPeriod(ctx, systemEnum, companyid);
        if (curPeriodId == null) {
            return false;
        }
        PeriodInfo perInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)curPeriodId)));
        if (!this.isStartSystem(ctx, systemEnum, companyid)) {
            return false;
        }
        if (!perInfo.isIsAdjustPeriod()) {
            throw this.util.getEASBizException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"68_CASAccountRefContrastProcess", (Locale)ctx.getLocale()), null);
        }
        AccountRefContrastInfo accountRefContrastInfo = AccountRefContrastFactory.getLocalInstance((Context)ctx).getAccountRefContrastInfo((IObjectPK)new ObjectUuidPK(acrefid));
        HashSet<BOSUuid> oldacct = new HashSet<BOSUuid>();
        for (int i = 0; i < accountRefContrastInfo.getAcctRefContrastEntry().size(); ++i) {
            oldacct.add(accountRefContrastInfo.getAcctRefContrastEntry().get(i).getOldAcct().getId());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("accountView.id", oldacct, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("createdate", (Object)perInfo.getEndDate(), CompareType.GREATER));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid, CompareType.EQUALS));
        Boolean journalExist = JournalFactory.getLocalInstance(ctx).exists(filter);
        Boolean bankStatementExist = BankStatementFactory.getLocalInstance(ctx).exists(filter);
        if (journalExist.booleanValue() || bankStatementExist.booleanValue()) {
            throw this.util.getEASBizException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"96_CASAccountRefContrastProcess", (Locale)ctx.getLocale()), null);
        }
        this.adjustIntObjects(ctx, acrefid, companyid);
        this.genJournalOut(ctx, acrefid, perInfo, companyid);
        this.genJournalIn(ctx, acrefid, perInfo, companyid);
        this.genBankStatementOut(ctx, acrefid, perInfo, companyid);
        this.genBankStatementIn(ctx, acrefid, perInfo, companyid);
        return true;
    }

    public boolean disEnable(Context ctx, String companyid, String acrefid) throws BOSException, EASBizException {
        int systemEnum = 7;
        String curPeriodId = super.getCurrentPeriod(ctx, systemEnum, companyid);
        if (curPeriodId == null) {
            return false;
        }
        PeriodInfo perInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)curPeriodId)));
        if (!this.isStartSystem(ctx, systemEnum, companyid)) {
            return false;
        }
        if (!perInfo.isIsAdjustPeriod()) {
            throw this.util.getEASBizException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"68_CASAccountRefContrastProcess", (Locale)ctx.getLocale()), null);
        }
        String CS134 = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(companyid), "CS134");
        if (CS134 == null || "true".equals(CS134)) {
            AccountRefContrastInfo accountRefContrastInfo = AccountRefContrastFactory.getLocalInstance((Context)ctx).getAccountRefContrastInfo((IObjectPK)new ObjectUuidPK(acrefid));
            HashSet<BOSUuid> newacct = new HashSet<BOSUuid>();
            for (int i = 0; i < accountRefContrastInfo.getAcctRefContrastEntry().size(); ++i) {
                newacct.add(accountRefContrastInfo.getAcctRefContrastEntry().get(i).getNewAcct().getId());
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("accountView.id", newacct, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("createdate", (Object)perInfo.getEndDate(), CompareType.GREATER));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid, CompareType.EQUALS));
            Boolean journalExist = JournalFactory.getLocalInstance(ctx).exists(filter);
            Boolean bankStatementExist = BankStatementFactory.getLocalInstance(ctx).exists(filter);
            if (journalExist.booleanValue() || bankStatementExist.booleanValue()) {
                throw this.util.getEASBizException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"97_CASAccountRefContrastProcess", (Locale)ctx.getLocale()), null);
            }
        }
        String templeTable = super.createTempleTable(ctx, acrefid);
        this.unadjustIntObjects(ctx, acrefid, companyid, templeTable);
        this.deleteJournals(ctx, companyid, curPeriodId);
        this.deleteBankStatements(ctx, companyid, curPeriodId);
        return true;
    }

    private void adjuestAccountBanks(Context ctx, String acctrefId, String companyid) throws BOSException {
        String sql = "update t_bd_accountbanks set (faccountid, fcontrolunitid )=  (select  fnewacctid, t_bd_accountbanks.fcontrolunitid from T_BD_AcctRefContrastentry where  foldacctid=faccountid and  FACCTREFCONTRASTID='" + acctrefId + "' and t_bd_accountbanks.fcompanyid='" + companyid + "')";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void adjustIntObjects(Context ctx, String acctrefId, String companyid) throws BOSException {
        FMQuerySqlBuilder sb_acctBank = new FMQuerySqlBuilder();
        sb_acctBank.appendSql("update t_int_intobject set (fsourceId,fcontrolunitid )=  (select  fnewacctid,t_int_intobject.fcontrolunitid from T_BD_AcctRefContrastentry where  foldacctid=fsourceId and  FACCTREFCONTRASTID='" + acctrefId + "' and t_int_intobject.fcompanyid='" + companyid + "'  and t_int_intobject.fsourceType=1)");
        DbUtil.execute((Context)ctx, (String)sb_acctBank.getTestSql());
        this.synIntObjectName(ctx, companyid);
        this.updateFinanceAtrrField(ctx, acctrefId, companyid, "FaccuralAccountID");
        this.updateFinanceAtrrField(ctx, acctrefId, companyid, "FrecPayedAcctID");
        this.updateFinanceAtrrField(ctx, acctrefId, companyid, "FrecPayableAcctID");
        this.updateFinanceAtrrField(ctx, acctrefId, companyid, "FoverAccountID");
        this.updateFinanceAtrrField(ctx, acctrefId, companyid, "FarrearAccountID");
        this.updateFinanceAtrrField(ctx, acctrefId, companyid, "FfeeAccountID");
        this.updateFinanceAtrrField(ctx, acctrefId, companyid, "FtaxAccountID");
    }

    private void checkHasExistNextPeriodJournal(Context ctx, String companyid, PeriodInfo nextPeriod) throws BOSException, EASBizException {
        FMQuerySqlBuilder sql = new FMQuerySqlBuilder();
        sql.appendSql("select fid from t_cas_journal where fcreatedate >= ? ");
        sql.addParam((Object)DateTimeUtils.truncateDate((Date)nextPeriod.getEndDate()));
        sql.appendSql(" and fcompanyid='" + companyid + "'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.getTestSql());
        if (rs != null && rs.size() > 0) {
            throw this.util.getEASBizException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"69_CASAccountRefContrastProcess", (Locale)ctx.getLocale()), null);
        }
    }

    private void checkHasExistNextPeriodBankStatement(Context ctx, String companyid, PeriodInfo nextPeriod) throws BOSException, EASBizException {
        FMQuerySqlBuilder sql = new FMQuerySqlBuilder();
        sql.appendSql("select fid from t_cas_bankstatement where fcreatedate >= ? ");
        sql.addParam((Object)DateTimeUtils.truncateDate((Date)nextPeriod.getEndDate()));
        sql.appendSql(" and fcompanyid='" + companyid + "'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.getTestSql());
        if (rs != null && rs.size() > 0) {
            throw this.util.getEASBizException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"70_CASAccountRefContrastProcess", (Locale)ctx.getLocale()), null);
        }
    }

    private void updateFinanceAtrrField(Context ctx, String acctrefId, String companyid, String fieldname) throws BOSException {
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql("update t_int_IntObjectFinance set (" + fieldname + ", fcontrolunitid) =(select  fnewacctid,t_int_IntObjectFinance.fcontrolunitid from T_BD_AcctRefContrastentry where foldacctid=" + fieldname + " and  FACCTREFCONTRASTID='" + acctrefId + "'  and  t_int_IntObjectFinance.fid in ( select ffinanceAttrid from t_int_intobject where fcompanyid='" + companyid + "'))");
        DbUtil.execute((Context)ctx, (String)sb.getTestSql());
    }

    private void synIntObjectName(Context ctx, String companyid) throws BOSException {
        FMQuerySqlBuilder sb_synName = new FMQuerySqlBuilder();
        sb_synName.appendSql("UPDATE t_int_intobject SET (fnumber, fname_l1, fname_l2, fname_l3) =  (SELECT T_BD_accountview.fnumber, T_BD_accountview.fname_l1, T_BD_accountview.fname_l2, T_BD_accountview.fname_l3  FROM T_BD_accountview WHERE fsourceId = T_BD_accountview.fid and t_int_intobject.fcompanyid='" + companyid + "' and t_int_intobject.fsourceType=1)");
        DbUtil.execute((Context)ctx, (String)sb_synName.getTestSql());
    }

    private void genJournalIn(Context ctx, String acctrefId, PeriodInfo cperiod, String companyid) throws BOSException {
        StringBuffer jourinSql = new StringBuffer();
        jourinSql.append("INSERT INTO t_cas_journal(");
        jourinSql.append("             fid,");
        jourinSql.append("             fhaseffected,");
        jourinSql.append("             ftype,");
        jourinSql.append("             fcompanyid,");
        jourinSql.append("             faccountviewid,");
        jourinSql.append("             faccountbankid,");
        jourinSql.append("             fcurrencyid,");
        jourinSql.append("             fperiodid,");
        jourinSql.append("             fdebitamount,");
        jourinSql.append("             fisdebit,");
        jourinSql.append("             fsource,");
        jourinSql.append("             fcreatedate,");
        jourinSql.append("             fbizdate,");
        jourinSql.append("             fverifystatus,");
        jourinSql.append("             fdescription,");
        jourinSql.append("             fcontrolunitid)");
        jourinSql.append(" SELECT dbo.Newbosid('DF8E708B'),");
        jourinSql.append("        1,");
        jourinSql.append("        jb.ftype,");
        jourinSql.append("        jb.fcompanyid,");
        jourinSql.append("        ar.fnewacctid,");
        jourinSql.append("        jb.faccountbankid,");
        jourinSql.append("        jb.fcurrencyid,");
        jourinSql.append("        jb.fperiodid,");
        jourinSql.append("        jb.fmonthstartamt,");
        jourinSql.append("        1,");
        jourinSql.append("        6,");
        jourinSql.append("        {ts '" + cperiod.getBeginDate().toString() + "'},");
        jourinSql.append("        {ts '" + cperiod.getBeginDate().toString() + "'},");
        jourinSql.append("        0,");
        jourinSql.append(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"71_CASAccountRefContrastProcess", (Locale)ctx.getLocale()));
        jourinSql.append("        jb.fcontrolunitid");
        jourinSql.append(" FROM   t_cas_journalbalance jb,");
        jourinSql.append("        t_bd_acctrefcontrastentry ar");
        jourinSql.append(" WHERE  ar.foldacctid = jb.faccountviewid");
        jourinSql.append("        AND jb.fperiodid = '" + cperiod.getId().toString() + "'");
        jourinSql.append("        AND ar.facctrefcontrastid ='" + acctrefId + "' ");
        jourinSql.append("        AND jb.fcompanyid ='" + companyid + "' ");
        DbUtil.execute((Context)ctx, (String)jourinSql.toString());
    }

    private void genBankStatementOut(Context ctx, String acctrefId, PeriodInfo cperiod, String companyid) throws BOSException, EASBizException {
        BankStatementInfo bankStatement = new BankStatementInfo();
        FMQuerySqlBuilder oldsb = new FMQuerySqlBuilder();
        oldsb.appendSql(" INSERT INTO t_cas_bankstatement ").appendSql(" (fid, fcompanyid, faccountviewid, faccountbankid,fcurrencyid, fperiodid, fdebitamount,").appendSql(" fisdebit, fcreatedate, fverifystatus, fdescription,fsource)").appendSql(" SELECT dbo.newbosid('").appendSql(bankStatement.getBOSType().toString()).appendSql("'), fcompanyid, ar.foldacctid, faccountbankid, fcurrencyid, '" + cperiod.getId().toString() + "',sum(fmonthstartamt), 1,").appendSql("  {ts '" + cperiod.getBeginDate() + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"72_CASAccountRefContrastProcess", (Locale)ctx.getLocale())).appendSql(" FROM (SELECT   fcompanyid, faccountviewid, faccountbankid,fcurrencyid, to_char(null) fperiodid,").appendSql("  fcreditamount - fdebitamount fmonthstartamt").appendSql(" FROM t_cas_bankstatement where fcompanyid='" + companyid + "'").appendSql(" and fcreatedate<={ts '" + cperiod.getBeginDate() + "'}").appendSql(" UNION ALL ").appendSql(" SELECT distinct fcompanyid, faccountviewid, faccountbankid, fcurrencyid, to_char(null) fperiodid,fmonthstartamt").appendSql(" FROM t_cas_journalbalance WHERE fcompanyid='" + companyid + "'").appendSql(" and ftype = 3) a, t_bd_acctrefcontrastentry ar").appendSql(" WHERE ar.foldacctid = a.faccountviewid AND ar.facctrefcontrastid = '" + acctrefId.toString() + "' ").appendSql("GROUP BY a.fcompanyid, ar.foldacctid, a.faccountbankid,a.fcurrencyid  having SUM (fmonthstartamt)<>0");
        DbUtil.execute((Context)ctx, (String)oldsb.getTestSql());
    }

    private void genBankStatementIn(Context ctx, String acctrefId, PeriodInfo cperiod, String companyid) throws BOSException {
        BankStatementInfo bankStatement = new BankStatementInfo();
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" INSERT INTO t_cas_bankstatement ").appendSql(" (fid, fcompanyid, faccountviewid, faccountbankid,fcurrencyid, fperiodid, fcreditamount,").appendSql(" fisdebit, fcreatedate, fverifystatus, fdescription,fsource)").appendSql(" SELECT dbo.newbosid('").appendSql(bankStatement.getBOSType().toString()).appendSql("'), fcompanyid,fnewacctid,faccountbankid, fcurrencyid,'" + cperiod.getId().toString() + "',fmonthstartamtsum, 0,").appendSql("{ts '" + cperiod.getBeginDate() + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"73_CASAccountRefContrastProcess", (Locale)ctx.getLocale())).appendSql(" FROM (SELECT fcompanyid, foldacctid,fnewacctid, faccountbankid, ").appendSql("fcurrencyid,sum(fmonthstartamt) fmonthstartamtsum from ").appendSql("(SELECT fcompanyid, ar.foldacctid,ar.fnewacctid, faccountbankid, ").appendSql("fcurrencyid,fmonthstartamt FROM (SELECT  fcompanyid,faccountviewid,").appendSql("faccountbankid,fcurrencyid,to_char( null) fperiodid,").appendSql("fcreditamount - fdebitamount fmonthstartamt FROM t_cas_bankstatement ").appendSql("where fcompanyid='" + companyid + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"74_CASAccountRefContrastProcess", (Locale)ctx.getLocale())).appendSql(" and fcreatedate<={ts '" + cperiod.getBeginDate() + "'}").appendSql("UNION ALL SELECT distinct fcompanyid, faccountviewid, faccountbankid, ").appendSql("fcurrencyid,to_char( null) fperiodid,fmonthstartamt FROM t_cas_journalbalance ").appendSql("WHERE fcompanyid='" + companyid + "' and ftype = 3) a,").appendSql("t_bd_acctrefcontrastentry ar WHERE ar.foldacctid = a.faccountviewid ").appendSql("AND ar.facctrefcontrastid = '" + acctrefId + "') temp1 ").appendSql("GROUP BY fcompanyid, foldacctid, fnewacctid, faccountbankid, fcurrencyid ").appendSql("having SUM (fmonthstartamt)<>0) temp2");
        DbUtil.execute((Context)ctx, (String)sb.getTestSql());
    }

    private void genJournalOut(Context ctx, String acctrefId, PeriodInfo cperiod, String companyid) throws BOSException {
        StringBuffer jouroutSql = new StringBuffer();
        jouroutSql.append("INSERT INTO t_cas_journal(");
        jouroutSql.append("             fid,");
        jouroutSql.append("             fhaseffected,");
        jouroutSql.append("             ftype,");
        jouroutSql.append("             fcompanyid,");
        jouroutSql.append("             faccountviewid,");
        jouroutSql.append("             faccountbankid,");
        jouroutSql.append("             fcurrencyid,");
        jouroutSql.append("             fperiodid,");
        jouroutSql.append("             fcreditamount,");
        jouroutSql.append("             fisdebit,");
        jouroutSql.append("             fsource,");
        jouroutSql.append("             fcreatedate,");
        jouroutSql.append("             fbizdate,");
        jouroutSql.append("             fverifystatus,");
        jouroutSql.append("             fdescription,");
        jouroutSql.append("             fcontrolunitid)");
        jouroutSql.append(" SELECT dbo.Newbosid('DF8E708B'),");
        jouroutSql.append("        1,");
        jouroutSql.append("        jb.ftype,");
        jouroutSql.append("        jb.fcompanyid,");
        jouroutSql.append("        ar.foldacctid,");
        jouroutSql.append("        jb.faccountbankid,");
        jouroutSql.append("        jb.fcurrencyid,");
        jouroutSql.append("        jb.fperiodid,");
        jouroutSql.append("        jb.fmonthstartamt,");
        jouroutSql.append("        0,");
        jouroutSql.append("        6,");
        jouroutSql.append("        {ts '" + cperiod.getBeginDate().toString() + "'},");
        jouroutSql.append("        {ts '" + cperiod.getBeginDate().toString() + "'},");
        jouroutSql.append("        0,");
        jouroutSql.append(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"75_CASAccountRefContrastProcess", (Locale)ctx.getLocale()));
        jouroutSql.append("        jb.fcontrolunitid ");
        jouroutSql.append(" FROM   t_cas_journalbalance jb,");
        jouroutSql.append("        t_bd_acctrefcontrastentry ar");
        jouroutSql.append(" WHERE  ar.foldacctid = jb.faccountviewid");
        jouroutSql.append("        AND jb.fperiodid = '" + cperiod.getId().toString() + "'");
        jouroutSql.append("        AND ar.facctrefcontrastid ='" + acctrefId + "' ");
        jouroutSql.append("        AND jb.fcompanyid ='" + companyid + "' ");
        DbUtil.execute((Context)ctx, (String)jouroutSql.toString());
    }

    private void unadjuestAccountBanks(Context ctx, String acctrefId, String companyid, String templeTable) throws BOSException {
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql("update t_bd_accountbanks set (faccountid)=  (select tem.foldacctid from " + templeTable + " tem where  tem.fnewacctid=faccountid and t_bd_accountbanks.fcompanyid='" + companyid + "' and faccountid is not null)");
        DbUtil.execute((Context)ctx, (String)sb.getTestSql());
    }

    private void unadjustIntObjects(Context ctx, String acctrefId, String companyid, String templeTable) throws BOSException {
        String sql = "update t_int_intobject set (fsourceId)=  (select tem.foldacctid from " + templeTable + " tem where  tem.fnewacctid=fsourceId and t_int_intobject.fcompanyid='" + companyid + "' and fsourceId is not null)";
        DbUtil.execute((Context)ctx, (String)sql);
        this.synIntObjectName(ctx, companyid);
        this.unupdateFinanceAtrrField(ctx, acctrefId, companyid, templeTable, "FaccuralAccountID");
        this.unupdateFinanceAtrrField(ctx, acctrefId, companyid, templeTable, "FrecPayedAcctID");
        this.unupdateFinanceAtrrField(ctx, acctrefId, companyid, templeTable, "FrecPayableAcctID");
        this.unupdateFinanceAtrrField(ctx, acctrefId, companyid, templeTable, "FoverAccountID");
        this.unupdateFinanceAtrrField(ctx, acctrefId, companyid, templeTable, "FarrearAccountID");
        this.unupdateFinanceAtrrField(ctx, acctrefId, companyid, templeTable, "FfeeAccountID");
        this.unupdateFinanceAtrrField(ctx, acctrefId, companyid, templeTable, "FtaxAccountID");
    }

    private void unupdateFinanceAtrrField(Context ctx, String acctrefId, String companyid, String templeTable, String fieldname) throws BOSException {
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql("update t_int_IntObjectFinance set (" + fieldname + ") =(select tem.foldacctid from " + templeTable + " tem where tem.fnewacctid= " + fieldname + " and  t_int_IntObjectFinance.fid in ( select ffinanceAttrid from t_int_intobject where fcompanyid='" + companyid + "') and " + fieldname + " is not null)");
        DbUtil.execute((Context)ctx, (String)sb.getTestSql());
    }

    private void deleteJournals(Context ctx, String companyid, String prePeriod) throws BOSException {
        String sql = "delete  from t_cas_journal where fperiodid='" + prePeriod + "' and fcompanyid='" + companyid + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void deleteBankStatements(Context ctx, String companyid, String prePeriod) throws BOSException {
        String sql = "delete  from t_cas_bankstatement where fperiodid='" + prePeriod + "' and fcompanyid='" + companyid + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }
}

