/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CashDataSourceEnum;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fi.cas.ICashManagement;
import com.kingdee.eas.fi.cas.app.AbstractCASFWarnFacadeControllerBean;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMQuerySqlBuilder;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public class CASFWarnFacadeControllerBean
extends AbstractCASFWarnFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.CASFWarnFacadeControllerBean");

    @Override
    protected BigDecimal _getCurrentBalance(Context ctx, String companyNumber, String acctNumber, String currencyNumber) throws BOSException, EASBizException {
        return CashManagementFactory.getLocalInstance(ctx).cash(companyNumber, CashDataSourceEnum.C, null, acctNumber, null, currencyNumber, new Date(), new Date(), CashDataTypeEnum.Y, false);
    }

    @Override
    protected BigDecimal _getBankAccountBalance(Context ctx, String acctBankId, String currencyNumber, Date bizDate) throws BOSException, EASBizException {
        SelectorItemCollection select = new SelectorItemCollection();
        select.add("*");
        select.add("company.*");
        IAccountBank accountBank = AccountBankFactory.getLocalInstance((Context)ctx);
        AccountBankInfo info = accountBank.getAccountBankInfo((IObjectPK)new ObjectUuidPK(acctBankId), select);
        ICashManagement bean = CashManagementFactory.getLocalInstance(ctx);
        String companyId = info.getCompany().getId().toString();
        String accountBankId = info.getId().toString();
        String currencyId = info.getCompany().getBaseCurrency().getId().toString();
        try {
            String sql;
            IRowSet rs;
            if (!EmptyUtil.isEmpty((String)currencyNumber) && (rs = DbUtil.executeQuery((Context)ctx, (String)(sql = "select fid from t_bd_currency where fnumber='" + currencyNumber + "' or fname_" + ctx.getLocale() + " ='" + currencyNumber + "'"))).next()) {
                currencyId = rs.getString(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (bizDate == null) {
            bizDate = DateHelper.getDayBegin();
        }
        BigDecimal rst = bean.getBankData(companyId, accountBankId, currencyId, bizDate, bizDate, CashDataTypeEnum.Y, true);
        return rst;
    }

    @Override
    protected boolean _isChange(Context ctx, String accountbankId, int days) throws BOSException, EASBizException {
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql("select count(fid) from t_cas_journal where FAccountBankID=? and FCreateDate>=?");
        Date d = DateHelper.getDayBegin();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(d);
        ((Calendar)cal).add(5, -days);
        d = cal.getTime();
        sb.addParam((Object)accountbankId);
        sb.addParam((Object)d);
        ResultSet rs = sb.exeQuery(ctx);
        try {
            int size;
            if (rs.next() && (size = rs.getInt(1)) > 0) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }
}

