/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AssItemsForCashRecCollection;
import com.kingdee.eas.fi.cas.AssItemsForCashRecInfo;
import com.kingdee.eas.fi.cas.BizTypeEnum;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.ICASDataImportVerify;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fpl.FPItemDirectionEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class CASReceivingBillImportVerify
implements ICASDataImportVerify {
    private static Logger logger = Logger.getLogger((String)CASReceivingBillImportVerify.class.getName());

    @Override
    public void verifyHead(Context ctx, CoreBaseInfo head) throws BOSException {
        SourceTypeEnum sourceType;
        if (!(head instanceof ReceivingBillInfo)) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"25_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        }
        ReceivingBillInfo info = (ReceivingBillInfo)head;
        CompanyOrgUnitInfo companyInfo = info.getCompany();
        CtrlUnitInfo cuInfo = companyInfo.getCU();
        boolean hasPermission = false;
        try {
            hasPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyInfo.getId()), "cas_paymentbill_02addNew");
        }
        catch (EASBizException e1) {
            throw new BOSException((Throwable)e1);
        }
        if (!hasPermission) {
            String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"109_CasPaymentBillImportVerify", (Locale)ctx.getLocale()) + companyInfo.getName(ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"110_CasPaymentBillImportVerify", (Locale)ctx.getLocale());
            throw new BOSException(msg);
        }
        if (info.getSourceType() == null) {
            info.setSourceType(SourceTypeEnum.AR);
        }
        if (!(sourceType = info.getSourceType()).equals((Object)SourceTypeEnum.AR) && !sourceType.equals((Object)SourceTypeEnum.CASH)) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"106_CASReceivingBillImportVerify", (Locale)ctx.getLocale()));
        }
        SystemEnum systemEnum = null;
        PeriodInfo currentPeriod = null;
        if (sourceType.equals((Object)SourceTypeEnum.AR)) {
            systemEnum = SystemEnum.ACCOUNTSRECEIVABLE;
            try {
                currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)systemEnum, (CompanyOrgUnitInfo)companyInfo);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"89_CasPaymentBillImportVerify", (Locale)ctx.getLocale()) + e.getMessage());
            }
            catch (BOSException e) {
                logger.error((Object)e);
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"89_CasPaymentBillImportVerify", (Locale)ctx.getLocale()) + e.getMessage());
            }
            if (info.getBizDate().compareTo(currentPeriod.getBeginDate()) < 0) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"90_CasPaymentBillImportVerify", (Locale)ctx.getLocale()));
            }
        }
        this.checkEmpty(ctx, info.getCurrency(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"27_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        CurrencyInfo currency = info.getCurrency();
        this.checkEmpty(ctx, info.getExchangeRate(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"28_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        if (info.getExchangeRate().compareTo(Constants.ZERO) < 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"29_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        }
        CurrencyInfo localCurrency = companyInfo.getBaseCurrency();
        if (currency.getId().equals((Object)localCurrency.getId()) && info.getExchangeRate().compareTo(Constants.ONE) != 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"30_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        }
        if (BizTypeEnum.BANK.equals((Object)info.getFundType())) {
            EntityViewInfo evi = RecPayHelper.getBankAccountEvi(cuInfo.getId().toString());
            try {
                Set idSet = FMHelper.getAcctViewIdSet((Context)ctx, (String)companyInfo.getId().toString(), (String)currency.getId().toString(), (EntityViewInfo)evi);
                if (idSet != null && info.getPayeeAccount() != null && !idSet.contains(info.getPayeeAccount().getId().toString())) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"107_CASReceivingBillImportVerify", (Locale)ctx.getLocale()));
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"108_CASReceivingBillImportVerify", (Locale)ctx.getLocale()) + e.getMessage());
            }
            catch (BOSException e) {
                logger.error((Object)e);
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"108_CASReceivingBillImportVerify", (Locale)ctx.getLocale()) + e.getMessage());
            }
            if (info.getPayeeAccountBank() != null && info.getPayeeAccountBank().getAccount() != null && !info.getPayeeAccount().getId().equals((Object)info.getPayeeAccountBank().getAccount().getId())) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"109_CASReceivingBillImportVerify", (Locale)ctx.getLocale()));
            }
        } else if (BizTypeEnum.CASH.equals((Object)info.getFundType())) {
            EntityViewInfo evi = RecPayHelper.getCashAccountEvi(cuInfo.getId().toString());
            try {
                Set idSet = FMHelper.getAcctViewIdSet((Context)ctx, (String)companyInfo.getId().toString(), (String)currency.getId().toString(), (EntityViewInfo)evi);
                if (idSet != null && info.getPayeeAccount() != null && !idSet.contains(info.getPayeeAccount().getId().toString())) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"110_CASReceivingBillImportVerify", (Locale)ctx.getLocale()));
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"108_CASReceivingBillImportVerify", (Locale)ctx.getLocale()) + e.getMessage());
            }
            catch (BOSException e) {
                logger.error((Object)e);
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"108_CASReceivingBillImportVerify", (Locale)ctx.getLocale()) + e.getMessage());
            }
        }
        if (info.getFpItem() != null && FPItemDirectionEnum.OUTWARD_MOVEMENT.equals((Object)info.getFpItem().getDirection())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"111_CASReceivingBillImportVerify", (Locale)ctx.getLocale()));
        }
    }

    private void checkEmpty(Context ctx, Object obj, String msg) throws BOSException {
        if (obj == null) {
            throw new BOSException(msg + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"31_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        }
    }

    @Override
    public void verifyEntry(Context ctx, CoreBaseInfo entry, SourceTypeEnum type, VoucherInfo.DynamicColumnInfo[] dyColumnInfos) throws BOSException {
        if (!(entry instanceof ReceivingBillEntryInfo)) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"99_CasPaymentBillImportVerify", (Locale)ctx.getLocale()));
        }
        ReceivingBillEntryInfo info = (ReceivingBillEntryInfo)entry;
        if (type.equals((Object)SourceTypeEnum.CASH)) {
            info.setAmount(null);
            info.setLocalAmt(null);
            info.setRebate(null);
            info.setRebateLocAmt(null);
            info.setBizDate(null);
            info.setBizBillNumber(null);
            info.setCustomerBillNum(null);
            if (info.getFpItem() != null && FPItemDirectionEnum.OUTWARD_MOVEMENT.equals((Object)info.getFpItem().getDirection())) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"111_CASReceivingBillImportVerify", (Locale)ctx.getLocale()));
            }
            if (info.getActualAmt() == null) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"499_CASReceivingBillImportVerify", (Locale)ctx.getLocale()));
            }
            if (info.getActualAmt() == null || info.getActualAmt().compareTo(BigDecimal.ZERO) == 0) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"523_CASPaymentBillImportVerify", (Locale)ctx.getLocale()));
            }
            if (info.getFundFlowItem() != null && info.getFundFlowItem().getState().getValue() == 1) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"493_CasImportFundItemVerify", (Locale)ctx.getLocale()));
            }
        } else if (type.equals((Object)SourceTypeEnum.AP) || type.equals((Object)SourceTypeEnum.AR)) {
            if (info.getAmount() == null) {
                info.setAmount(CasConstants.ZERO);
            }
            if (info.getRebate() == null) {
                info.setRebate(CasConstants.ZERO);
            }
            if (info.getActualAmt() == null) {
                info.setActualAmt(CasConstants.ZERO);
            }
            BigDecimal temp1 = info.getAmount().subtract(info.getRebate());
            if (info.getActualAmt().compareTo(temp1) != 0) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"112_CASReceivingBillImportVerify", (Locale)ctx.getLocale()));
            }
            if (info.getActualAmt().compareTo(CasConstants.ZERO) != 1) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"113_CASReceivingBillImportVerify", (Locale)ctx.getLocale()));
            }
            if (info.getLocalAmt() == null) {
                info.setLocalAmt(CasConstants.ZERO);
            }
            if (info.getRebateLocAmt() == null) {
                info.setRebateLocAmt(CasConstants.ZERO);
            }
            if (info.getActualLocAmt() == null) {
                info.setActualLocAmt(CasConstants.ZERO);
            }
            temp1 = info.getLocalAmt().subtract(info.getRebateLocAmt());
            if (info.getActualLocAmt().compareTo(temp1) != 0) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"114_CASReceivingBillImportVerify", (Locale)ctx.getLocale()));
            }
            if (info.getActualLocAmt().compareTo(CasConstants.ZERO) != 1) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"115_CASReceivingBillImportVerify", (Locale)ctx.getLocale()));
            }
        }
        AssItemsForCashRecCollection assCol = info.getAssItemsEntries();
        Iterator it = assCol.iterator();
        while (it.hasNext()) {
            AssItemsForCashRecInfo afcp = (AssItemsForCashRecInfo)it.next();
            AsstActTypeInfo acTypeInfo = afcp.getAsstActType();
            boolean flag = false;
            for (int i = 0; i < dyColumnInfos.length; ++i) {
                if (!dyColumnInfos[i].getId().equals((Object)acTypeInfo.getId())) continue;
                flag = true;
            }
            if (flag) continue;
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"104_CasPaymentBillImportVerify", (Locale)ctx.getLocale()) + acTypeInfo.getName() + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"105_CasPaymentBillImportVerify", (Locale)ctx.getLocale()));
        }
    }
}

