/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateUtils;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodException;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeCollection;
import com.kingdee.eas.basedata.assistant.PeriodTypeFactory;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.Account_ControlCollection;
import com.kingdee.eas.basedata.master.account.Account_ControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.app.AbstractCapitalSubLegerFecthParamFacadeControllerBean;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.util.FetchParamHelper;
import com.kingdee.eas.framework.SystemEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CapitalSubLegerFecthParamFacadeControllerBean
extends AbstractCapitalSubLegerFecthParamFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.CapitalSubLegerFecthParamFacadeControllerBean");
    private CompanyOrgUnitInfo company;

    @Override
    protected Map _fetchParam_MainUI(Context ctx, Map paramMap) throws BOSException, EASBizException {
        FetchParamHelper fph = new FetchParamHelper(ctx);
        if (paramMap.get("companyID") == null) {
            this.company = fph.getCurrentComapny();
        } else {
            this.company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)((String)paramMap.get("companyID")))));
            fph.setCurrentCompany(this.company);
        }
        paramMap.put("currentCompany", this.company);
        paramMap.put("currentPeriod", fph.getCurrentPeriod());
        paramMap.put("startPeriod", fph.getStartPeriod());
        paramMap.put("currencyCollection", fph.getCurrenyCol());
        paramMap.put("isStart", SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.company));
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.company)) {
            paramMap.put("accountTable", this.getAccountTable(ctx));
            paramMap.put("periodTypeInfo", this.getPeriodTypeInfo(ctx));
        } else {
            paramMap.put("accountTableCol", this.getAccountTableCol(ctx));
            paramMap.put("periodTypeCol", this.getPeriodTypeCol(ctx));
        }
        paramMap.put("periodCol_TypeID", this.getperiodCol_TypeID(ctx));
        paramMap.put("period_Now", this.getperiodCol_Now(ctx));
        CurrencyInfo baseCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.company.getBaseCurrency().getId()));
        paramMap.put("baseCurrency", baseCurrency);
        boolean val = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS003", (IObjectPK)new ObjectUuidPK(this.company.getId()));
        paramMap.put("CS003", val);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isBank", (Object)FMConstants.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("account.*"));
        AccountBankCollection accountBanks = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(evi);
        paramMap.put("accountBanks", accountBanks);
        return paramMap;
    }

    private PeriodInfo getperiodCol_Now(Context ctx) throws BOSException, EASBizException {
        if (this.company == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (this.company.getAccountPeriodType() == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        Date date = cal.getTime();
        PeriodInfo periodInfo = new PeriodInfo();
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)date), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)date), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)this.company.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            periodInfo = periodc.get(0);
        }
        if (periodInfo.getId() == null) {
            periodInfo = null;
        }
        return periodInfo;
    }

    private Object getperiodCol_TypeID(Context ctx) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)this.company.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        evi.getSorter().add(new SorterItemInfo("periodYear"));
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        evi.setFilter(filter);
        PeriodCollection pc = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(evi);
        return pc;
    }

    private PeriodTypeCollection getPeriodTypeCol(Context ctx) throws BOSException {
        return PeriodTypeFactory.getLocalInstance((Context)ctx).getPeriodTypeCollection();
    }

    private AccountTableCollection getAccountTableCol(Context ctx) throws BOSException {
        String cuId = this.company.getCU().getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("destcu", (Object)cuId));
        filter.getFilterItems().add(new FilterItemInfo("isDefaultForRefer", (Object)new Integer(0)));
        view.setFilter(filter);
        Account_ControlCollection account_ControlCollection = Account_ControlFactory.getLocalInstance((Context)ctx).getAccount_ControlCollection(view);
        int size = account_ControlCollection.size();
        String[] ids = new String[size];
        for (int i = 0; i < size; ++i) {
            ids[i] = account_ControlCollection.get(i).getAccountTableID().getId().toString();
        }
        AccountTableCollection accountTableCollection = AccountTableFactory.getLocalInstance((Context)ctx).getAccountTableCollection(this.getIncludeEntityView("id", ids));
        return accountTableCollection;
    }

    private EntityViewInfo getIncludeEntityView(String key, String[] array) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        Set bankSet = CapitalSubLegerFecthParamFacadeControllerBean.getSetByArray(array);
        if (bankSet != null && bankSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo(key, (Object)bankSet, CompareType.INCLUDE));
        }
        return view;
    }

    public static Set getSetByArray(String[] array) {
        HashSet<String> set = new HashSet<String>();
        if (array == null) {
            return set;
        }
        for (int i = 0; i < array.length; ++i) {
            set.add(array[i]);
        }
        return set;
    }

    private PeriodTypeInfo getPeriodTypeInfo(Context ctx) throws EASBizException, BOSException {
        return PeriodTypeFactory.getLocalInstance((Context)ctx).getPeriodTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.company.getAccountPeriodType().getId().toString())));
    }

    private Object getAccountTable(Context ctx) throws EASBizException, BOSException {
        return AccountTableFactory.getLocalInstance((Context)ctx).getAccountTableInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.company.getAccountTable().getId().toString())));
    }

    @Override
    protected Map _fetchParam_FilterUI(Context ctx, Map hm) throws BOSException, EASBizException {
        int beginYear = (Integer)hm.get("beginYear");
        int beginMonth = (Integer)hm.get("beginMonth");
        int endYear = (Integer)hm.get("endYear");
        int endMonth = (Integer)hm.get("endMonth");
        FetchParamHelper fph = new FetchParamHelper(ctx);
        this.company = fph.getCurrentComapny();
        PeriodInfo beginPeriod = this.getPeriodInfo(ctx, beginYear, beginMonth, this.company);
        PeriodInfo endPeriod = this.getPeriodInfo(ctx, endYear, endMonth, this.company);
        String acctTableId = fph.getAcctTableId(ctx, beginPeriod.getBeginDate(), (Date)endPeriod.getEndDate());
        hm.put("acctTableId", acctTableId);
        return hm;
    }

    private PeriodInfo getPeriodInfo(Context ctx, int periodYear, int periodNumber, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        PeriodInfo info = null;
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodNumber), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            info = periodc.get(0);
        }
        return info;
    }

    @Override
    protected Map _fetchParam_Verify(Context ctx, Map paramMap) throws BOSException, EASBizException {
        this.getAcctTableID(ctx, paramMap);
        this.getCompanyIDs(ctx, paramMap);
        return paramMap;
    }

    private void getCompanyIDs(Context ctx, Map paramMap) throws BOSException, EASBizException {
        ArrayList<String> companyRec = new ArrayList<String>();
        String[] companyIds = (String[])paramMap.get("companyIds");
        if (companyIds != null) {
            CompanyOrgUnitCollection companys = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(this.getIncludeEntityView("id", companyIds));
            int size = companys.size();
            for (int i = 0; i < size; ++i) {
                CompanyOrgUnitInfo company = companys.get(i);
                if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company)) {
                    companyRec.add(company.getId().toString());
                    continue;
                }
                PeriodInfo period = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
                if (period == null) continue;
                companyRec.add(company.getId().toString());
            }
            paramMap.put("companyIdsNew", companyRec.toArray(new String[companyRec.size()]));
        }
    }

    private void getAcctTableID(Context ctx, Map paramMap) throws BOSException, EASBizException {
        FetchParamHelper fph = new FetchParamHelper(ctx);
        int beginYear = (Integer)paramMap.get("beginYear");
        int beginMonth = (Integer)paramMap.get("beginMonth");
        int endYear = (Integer)paramMap.get("endYear");
        int endMonth = (Integer)paramMap.get("endMonth");
        String actualAcctTableId = fph.getAcctTableId(ctx, beginYear, beginMonth, endYear, endMonth);
        paramMap.put("actualAcctTableId", actualAcctTableId);
    }
}

