/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeFactory;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.IAccountRefContrast;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.CASCommonWebFacadeFactory;
import com.kingdee.eas.fi.cas.CapitalSubLegerFecthParamFacadeFactory;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.CasWebParamFacadeFactory;
import com.kingdee.eas.fi.cas.CashDataSourceEnum;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fi.cas.DirectionEnum;
import com.kingdee.eas.fi.cas.ICashManagement;
import com.kingdee.eas.fi.cas.InnerCashFacadeFactory;
import com.kingdee.eas.fi.cas.app.AbstractCapitalSubLegerWebFacadeControllerBean;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.utils.PeriodHelper;
import com.kingdee.eas.fi.cas.utils.PeriodRange;
import com.kingdee.eas.fi.cas.web.param.CapitalSubLegerWebFilterParam;
import com.kingdee.eas.fi.cas.web.param.QueryTable;
import com.kingdee.eas.fi.cas.web.param.QueryTableRow;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.util.FetchParamHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CapitalSubLegerWebFacadeControllerBean
extends AbstractCapitalSubLegerWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.CapitalSubLegerWebFacadeControllerBean");
    public static final String RES = "com.kingdee.eas.fi.cas.CasResources";

    @Override
    protected Map _getInitParam(Context ctx, String companyId) throws BOSException, EASBizException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        CompanyOrgUnitInfo curCompany = null;
        if (!EmptyUtil.isEmpty((String)companyId)) {
            paramMap.put("companyID", companyId);
            curCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        } else {
            curCompany = CasWebParamFacadeFactory.getLocalInstance(ctx).getCurrentCompany();
            companyId = curCompany.getId().toString();
        }
        boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), "cas_capitalSubLeger_01view");
        if (!isPermission || !this.checkCompany(ctx, curCompany)) {
            CompanyOrgUnitCollection authrizedOrg = CASCommonWebFacadeFactory.getLocalInstance(ctx).getAuthizedCompanyOrg("cas_capitalSubLeger_01view");
            if (authrizedOrg != null && authrizedOrg.size() > 0) {
                curCompany = authrizedOrg.get(0);
                paramMap.remove("companyID");
                companyId = curCompany.getId().toString();
                paramMap.put("companyID", companyId);
            } else {
                throw new CasWebException(CasWebException.NO_ORG_AUTHRIZED);
            }
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("accountTable.name"));
        sic.add(new SelectorItemInfo("accountTable.number"));
        sic.add(new SelectorItemInfo("baseCurrency.*"));
        sic.add(new SelectorItemInfo("accountPeriodType.id"));
        sic.add(new SelectorItemInfo("accountPeriodType.name"));
        sic.add(new SelectorItemInfo("accountPeriodType.number"));
        curCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), sic);
        paramMap.put("currentCompany", (String)curCompany);
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)curCompany);
        paramMap.put("currentPeriod", (String)currentPeriod);
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)curCompany);
        paramMap.put("startPeriod", (String)startPeriod);
        PeriodTypeInfo periodTypeInfo = PeriodTypeFactory.getLocalInstance((Context)ctx).getPeriodTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)curCompany.getAccountPeriodType().getId().toString())));
        paramMap.put("periodTypeInfo", (String)periodTypeInfo);
        FetchParamHelper fph = new FetchParamHelper(ctx);
        CurrencyCollection currencyCol = fph.getCurrenyCol();
        paramMap.put("baseCurrency", (String)curCompany.getBaseCurrency());
        paramMap.put("currencyCollection", (String)currencyCol);
        if (curCompany.getAccountTable() == null) {
            return paramMap;
        }
        paramMap.put("accountTable", (String)curCompany.getAccountTable());
        return paramMap;
    }

    private boolean checkCompany(Context ctx, CompanyOrgUnitInfo companyInfo) {
        boolean expired;
        if (companyInfo == null || GlUtils.isCompanyUnion((CompanyOrgUnitInfo)companyInfo)) {
            return false;
        }
        java.util.Date curDate = new java.util.Date();
        java.util.Date invalidDate = companyInfo.getInvalidDate();
        boolean bl = expired = invalidDate != null && curDate.after(invalidDate);
        return !expired;
    }

    @Override
    protected Map _getListData(Context ctx, CapitalSubLegerWebFilterParam param) throws BOSException, EASBizException {
        HashMap<String, Object> pageModel = new HashMap<String, Object>();
        try {
            HashMap<String, Object> paramMap = new HashMap<String, String>();
            paramMap.put("companyID", param.getCompanyId());
            paramMap = CapitalSubLegerFecthParamFacadeFactory.getLocalInstance(ctx).fetchParam_MainUI(paramMap);
            IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.cas.CapitalSubLegerQuery"));
            EntityViewInfo ev = new EntityViewInfo();
            ev.setFilter(this.getFilter(ctx, param, paramMap));
            SorterItemInfo sort = new SorterItemInfo("createDate");
            sort.setSortType(SortType.ASCEND);
            ev.getSorter().add(sort);
            queryExecutor.setObjectView(ev);
            IRowSet rs = queryExecutor.executeQuery();
            QueryTable queryTable = this.fillData(ctx, rs, param, paramMap);
            pageModel.put("queryTable", queryTable);
            pageModel.put("error", 0);
        }
        catch (Exception e) {
            logger.error((Object)e);
            pageModel.put("error", 1);
            pageModel.put("msg", e.getMessage());
        }
        return pageModel;
    }

    private FilterInfo getFilter(Context ctx, CapitalSubLegerWebFilterParam param, Map<String, Object> paramMap) throws EASBizException, BOSException {
        String acctTableId;
        FilterInfo filterInfo = new FilterInfo();
        Object[] companyIds = param.getCompanyIds();
        if (!EmptyUtil.isEmpty((Object[])companyIds)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)CASWebUtil.ids2Set((String[])companyIds), CompareType.INCLUDE));
        }
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)paramMap.get("currentCompany");
        PeriodInfo beginPeriod = CashHelper.getPeriodInfo(param.getBeginYear(), param.getBeginMonth(), companyInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("createDate", (Object)beginPeriod.getBeginDate(), CompareType.GREATER_EQUALS));
        PeriodInfo endPeriod = CashHelper.getPeriodInfo(param.getEndYear(), param.getEndMonth(), companyInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("createDate", (Object)endPeriod.getEndDate(), CompareType.LESS_EQUALS));
        if (!param.isIncludeUnSettBill()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("hasEffected", (Object)Boolean.TRUE));
        }
        if (EmptyUtil.isEmpty((String)(acctTableId = param.getAcctTableId()))) {
            acctTableId = InnerCashFacadeFactory.getLocalInstance(ctx).getActualAcctTableID(companyInfo.getId().toString(), beginPeriod.getBeginDate(), endPeriod.getEndDate());
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("accountView.accountTableID.id", (Object)acctTableId));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("currency.id", (Object)param.getCurrencyId()));
        PeriodRange pRGE = PeriodRange.getPeriodRange(param.getBeginYear(), param.getBeginMonth(), param.getEndYear(), param.getEndMonth());
        if (pRGE == PeriodRange.NO13) {
            filterInfo.getFilterItems().add(ConvertUtils.FITEM((Object[])new Object[]{"PERIODNUMBER", 13, CompareType.NOTEQUALS}));
        } else if (pRGE == PeriodRange.EQUAL13) {
            filterInfo.getFilterItems().add(ConvertUtils.FITEM((Object[])new Object[]{"PERIODNUMBER", 13, CompareType.EQUALS}));
        }
        if (param.getType() == 2) {
            String accountBankId = param.getAccountBankId();
            if (!EmptyUtil.isEmpty((String)accountBankId)) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("company.id"));
                AccountBankInfo accountBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountBankId), sic);
                if (accountBank.getCompany().getId().toString().equals(companyInfo.getId().toString())) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)accountBankId));
                }
            }
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("accountView.id", (Object)param.getAccountViewId()));
        }
        return filterInfo;
    }

    private QueryTable fillData(Context ctx, IRowSet rs, CapitalSubLegerWebFilterParam param, Map<String, Object> paramMap) throws BOSException, EASBizException, SQLException {
        QueryTable queryTable = new QueryTable();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)paramMap.get("currentCompany");
        String companyId = company.getId().toString();
        String accountBankId = param.getAccountBankId();
        String accountViewId = param.getAccountViewId();
        String currencyId = param.getCurrencyId();
        String[] currencyIds = new String[]{currencyId};
        PeriodInfo beginPeriodInfo = CashHelper.getPeriodInfo(param.getBeginYear(), param.getBeginMonth(), company);
        PeriodInfo startPeriod = (PeriodInfo)paramMap.get("startPeriod");
        java.util.Date beginDate = beginPeriodInfo.getBeginDate();
        PeriodInfo endPeriod = CashHelper.getPeriodInfo(param.getEndYear(), param.getEndMonth(), company);
        Timestamp endDate = endPeriod.getEndDate();
        BigDecimal exchange = null;
        int exchangePre = 0;
        if (currencyIds.length == 1 && !company.getBaseCurrency().getId().toString().equals(currencyId)) {
            exchange = CashHelper.getExchange(company, currencyId, null);
            exchangePre = CashHelper.getExchangePre(company, currencyId, null);
            if (exchange.compareTo(BigDecimal.ZERO) == 0) {
                exchange = null;
            }
        }
        CurrencyInfo baseCurrency = (CurrencyInfo)paramMap.get("baseCurrency");
        boolean accContrastEnable = false;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("enabledPeriod.id", (Object)beginPeriodInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("enabledAcctTable.id", (Object)param.getAcctTableId()));
        IAccountRefContrast acctContrast = AccountRefContrastFactory.getLocalInstance((Context)ctx);
        if (beginPeriodInfo.isIsAdjustPeriod() && acctContrast.exists(filter)) {
            accContrastEnable = true;
        }
        HashMap<String, BigDecimal> balance = new HashMap<String, BigDecimal>();
        for (int i = 0; i < currencyIds.length; ++i) {
            BigDecimal bal = SysConstant.BIGZERO;
            if (!accContrastEnable) {
                bal = accountBankId == null ? CashManagementFactory.getLocalInstance(ctx).getCashData(companyId, accountViewId, currencyIds[i], beginDate, beginDate, CashDataTypeEnum.C, false) : CashManagementFactory.getLocalInstance(ctx).getBankData(companyId, accountBankId, currencyIds[i], beginDate, beginDate, CashDataTypeEnum.C, false);
            }
            balance.put(currencyId, bal);
        }
        Map yearDebit = this.getYearDebitSum(ctx, currencyIds, company, accountBankId, accountViewId, beginDate, startPeriod, accContrastEnable);
        Map yearCredit = this.getYearCreditSum(ctx, currencyIds, company, accountBankId, accountViewId, beginDate, startPeriod, accContrastEnable);
        java.util.Date loopDate = beginDate;
        boolean isFirstDay = true;
        boolean isShowDayTotal = param.isShowTotal();
        PeriodInfo curLoopPeriod = beginPeriodInfo;
        this.addPeriodStart(ctx, queryTable, loopDate, balance, currencyIds, exchange, baseCurrency);
        HashMap<String, BigDecimal> dayDebit = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> dayCredit = new HashMap<String, BigDecimal>();
        this.clearMap(currencyIds, dayDebit);
        this.clearMap(currencyIds, dayCredit);
        HashMap periodDebit = new HashMap();
        HashMap periodCredit = new HashMap();
        this.clearMap(currencyIds, periodDebit);
        this.clearMap(currencyIds, periodCredit);
        while (rs.next()) {
            Date createDate = rs.getDate("createDate");
            if (loopDate.before(createDate)) {
                if (!isFirstDay && isShowDayTotal) {
                    this.addDaySum(ctx, queryTable, loopDate, dayDebit, dayCredit, balance, currencyIds, exchange, baseCurrency);
                }
                this.changePeriodData(currencyIds, periodDebit, periodCredit, dayDebit, dayCredit);
            }
            int periodNumber = rs.getInt("periodNumber");
            int year = rs.getInt("periodYear");
            while (curLoopPeriod != null && (curLoopPeriod.getPeriodNumber() < periodNumber && curLoopPeriod.getPeriodYear() == year || curLoopPeriod.getEndDate().before(createDate))) {
                this.addPeriodSum(ctx, queryTable, curLoopPeriod.getEndDate(), periodDebit, periodCredit, balance, currencyIds, exchange, baseCurrency);
                this.changeYearData(currencyIds, yearDebit, yearCredit, periodDebit, periodCredit);
                this.addYearSum(ctx, queryTable, curLoopPeriod.getEndDate(), yearDebit, yearCredit, balance, currencyIds, exchange, baseCurrency);
                curLoopPeriod = PeriodHelper.getNextPeriodInfo(company, curLoopPeriod) != null ? PeriodHelper.getNextPeriodInfo(company, curLoopPeriod) : PeriodUtils.getNextPeriodInfo((PeriodInfo)curLoopPeriod);
                if (curLoopPeriod.getPeriodYear() > endPeriod.getPeriodYear() || curLoopPeriod.getPeriodYear() == endPeriod.getPeriodYear() && curLoopPeriod.getPeriodNumber() > endPeriod.getPeriodNumber()) {
                    curLoopPeriod = endPeriod;
                    break;
                }
                this.addPeriodStart(ctx, queryTable, curLoopPeriod.getBeginDate(), balance, currencyIds, exchange, baseCurrency);
                if (curLoopPeriod.getPeriodNumber() != 1) continue;
                this.clearMap(currencyIds, yearDebit);
                this.clearMap(currencyIds, yearCredit);
            }
            BigDecimal debitAmount = rs.getBigDecimal("debitAmount");
            BigDecimal creditAmount = rs.getBigDecimal("creditAmount");
            dayDebit.put(currencyId, ((BigDecimal)dayDebit.get(currencyId)).add(debitAmount));
            dayCredit.put(currencyId, ((BigDecimal)dayCredit.get(currencyId)).add(creditAmount));
            BigDecimal bal = (BigDecimal)balance.get(currencyId);
            bal = bal.add(debitAmount).subtract(creditAmount);
            balance.put(currencyId, bal);
            this.addOneRowDetail(queryTable, rs, balance, exchange, baseCurrency);
            isFirstDay = false;
            loopDate = createDate;
        }
        if (!isFirstDay && isShowDayTotal) {
            this.addDaySum(ctx, queryTable, loopDate, dayDebit, dayCredit, balance, currencyIds, exchange, baseCurrency);
        }
        this.changePeriodData(currencyIds, periodDebit, periodCredit, dayDebit, dayCredit);
        this.addPeriodSum(ctx, queryTable, curLoopPeriod.getEndDate(), periodDebit, periodCredit, balance, currencyIds, exchange, baseCurrency);
        this.changeYearData(currencyIds, yearDebit, yearCredit, periodDebit, periodCredit);
        this.addYearSum(ctx, queryTable, curLoopPeriod.getEndDate(), yearDebit, yearCredit, balance, currencyIds, exchange, baseCurrency);
        curLoopPeriod = PeriodHelper.getNextPeriodInfo(company, curLoopPeriod) != null ? PeriodHelper.getNextPeriodInfo(company, curLoopPeriod) : PeriodUtils.getNextPeriodInfo((PeriodInfo)curLoopPeriod);
        if (curLoopPeriod != null && curLoopPeriod.getPeriodNumber() == 1) {
            this.clearMap(currencyIds, yearDebit);
            this.clearMap(currencyIds, yearCredit);
        }
        while (curLoopPeriod != null && !curLoopPeriod.getBeginDate().after(endDate)) {
            if (curLoopPeriod.getPeriodYear() > endPeriod.getPeriodYear() || curLoopPeriod.getPeriodYear() == endPeriod.getPeriodYear() && curLoopPeriod.getPeriodNumber() > endPeriod.getPeriodNumber()) {
                curLoopPeriod = endPeriod;
                break;
            }
            this.addPeriodStart(ctx, queryTable, curLoopPeriod.getBeginDate(), balance, currencyIds, exchange, baseCurrency);
            this.addPeriodSum(ctx, queryTable, curLoopPeriod.getEndDate(), periodDebit, periodCredit, balance, currencyIds, exchange, baseCurrency);
            this.addYearSum(ctx, queryTable, curLoopPeriod.getEndDate(), yearDebit, yearCredit, balance, currencyIds, exchange, baseCurrency);
            if ((curLoopPeriod = PeriodHelper.getNextPeriodInfo(company, curLoopPeriod) != null ? PeriodHelper.getNextPeriodInfo(company, curLoopPeriod) : PeriodUtils.getNextPeriodInfo((PeriodInfo)curLoopPeriod)) == null || curLoopPeriod.getPeriodNumber() != 1) continue;
            this.clearMap(currencyIds, yearDebit);
            this.clearMap(currencyIds, yearCredit);
        }
        return queryTable;
    }

    private void clearMap(String[] currencyIds, Map value) {
        for (int i = 0; i < currencyIds.length; ++i) {
            value.put(currencyIds[i], SysConstant.BIGZERO);
        }
    }

    private void addOneRowDetail(QueryTable table, IRowSet rs, Map balance, BigDecimal exchange, CurrencyInfo baseCurrency) throws SQLException {
        QueryTableRow row = table.addRow();
        String currencyId = rs.getString("currency.id");
        BigDecimal debitAmt = rs.getBigDecimal("debitAmount");
        BigDecimal creditAmt = rs.getBigDecimal("creditAmount");
        row.addCell("billId").setValue(rs.getString("billId"));
        row.addCell("id").setValue(rs.getString("id"));
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        row.addCell("createDate").setValue(dateFormat.format(rs.getDate("createDate")));
        row.addCell("voucherType").setValue(rs.getString("voucherType"));
        row.addCell("voucherNumber").setValue(rs.getString("voucherNumber"));
        row.addCell("oppAccountNumber").setValue(rs.getString("oppAccountView.number"));
        row.addCell("oppAccountViewName").setValue(rs.getString("oppAccountViewName"));
        row.addCell("billType").setValue((Object)BillTypeEnum.getEnum(rs.getInt("billType")));
        row.addCell("billNumber").setValue(rs.getString("billNumber"));
        row.addCell("description").setValue(rs.getString("description"));
        row.addCell("settlementType").setValue(rs.getString("settlementType"));
        row.addCell("settlementNumber").setValue(rs.getString("settlementNumber"));
        row.addCell("ticketNumber").setValue(rs.getString("ticketNumber"));
        if (debitAmt.signum() != 0) {
            row.addCell("debitAmount").setValue(debitAmt);
        }
        if (creditAmt.signum() != 0) {
            row.addCell("creditAmount").setValue(creditAmt);
        }
        BigDecimal bal = (BigDecimal)balance.get(currencyId);
        this.setRowDCByAmount(row, bal);
        row.addCell("balance").setValue(bal.abs());
        if (exchange != null) {
            row.addCell("exchange").setValue(exchange);
            if (debitAmt.signum() != 0) {
                row.addCell("localDebit_" + currencyId).setValue(debitAmt.multiply(exchange).setScale(baseCurrency.getPrecision(), 4));
            }
            if (creditAmt.signum() != 0) {
                row.addCell("localCredit_" + currencyId).setValue(creditAmt.multiply(exchange).setScale(baseCurrency.getPrecision(), 4));
            }
            row.addCell("localBalance_" + currencyId).setValue(bal.multiply(exchange).setScale(baseCurrency.getPrecision(), 4));
        }
    }

    private void addYearSum(Context ctx, QueryTable table, Timestamp endDate, Map yearDebit, Map yearCredit, Map balance, String[] currencyIds, BigDecimal exchange, CurrencyInfo baseCurrency) {
        QueryTableRow row = table.addRow();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        row.addCell("createDate").setValue(dateFormat.format(endDate));
        row.addCell("description").setValue(CASWebUtil.getResource(ctx, "366_YearTotal"));
        for (int i = 0; i < currencyIds.length; ++i) {
            String currencyId = currencyIds[i];
            BigDecimal debitAmount = (BigDecimal)yearDebit.get(currencyId);
            BigDecimal creditAmount = (BigDecimal)yearCredit.get(currencyId);
            BigDecimal balanceAmount = (BigDecimal)balance.get(currencyId);
            if (currencyIds.length == 1) {
                balanceAmount = balanceAmount.abs();
            }
            row.addCell("debitAmount").setValue(debitAmount);
            row.addCell("creditAmount").setValue(creditAmount);
            row.addCell("balance").setValue(balanceAmount);
        }
        if (currencyIds.length == 1 && exchange != null) {
            String currencyId = currencyIds[0];
            row.addCell("localDebit_" + currencyId).setValue(((BigDecimal)yearDebit.get(currencyId)).multiply(exchange).setScale(baseCurrency.getPrecision(), 4));
            row.addCell("localCredit_" + currencyId).setValue(((BigDecimal)yearCredit.get(currencyId)).multiply(exchange).setScale(baseCurrency.getPrecision(), 4));
            row.addCell("localBalance_" + currencyId).setValue(((BigDecimal)balance.get(currencyId)).multiply(exchange).setScale(baseCurrency.getPrecision(), 4));
            row.addCell("exchange").setValue(exchange);
        }
        if (currencyIds.length == 1) {
            this.setRowDCByAmount(row, (BigDecimal)balance.get(currencyIds[0]));
        } else {
            row.addCell("dc").setValue((Object)DirectionEnum.Debit);
        }
    }

    private void addPeriodSum(Context ctx, QueryTable table, Timestamp endDate, Map periodDebit, Map periodCredit, Map balance, String[] currencyIds, BigDecimal exchange, CurrencyInfo baseCurrency) {
        QueryTableRow row = table.addRow();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        row.addCell("createDate").setValue(dateFormat.format(endDate));
        row.addCell("description").setValue(CASWebUtil.getResource(ctx, "367_PeriodTotal"));
        for (int i = 0; i < currencyIds.length; ++i) {
            String currencyId = currencyIds[i];
            BigDecimal debitAmount = (BigDecimal)periodDebit.get(currencyId);
            BigDecimal creditAmount = (BigDecimal)periodCredit.get(currencyId);
            BigDecimal balanceAmount = (BigDecimal)balance.get(currencyId);
            if (currencyIds.length == 1) {
                balanceAmount = balanceAmount.abs();
            }
            row.addCell("debitAmount").setValue(debitAmount);
            row.addCell("creditAmount").setValue(creditAmount);
            row.addCell("balance").setValue(balanceAmount);
        }
        if (currencyIds.length == 1 && exchange != null) {
            String currencyId = currencyIds[0];
            row.addCell("localDebit_" + currencyId).setValue(((BigDecimal)periodDebit.get(currencyId)).multiply(exchange).setScale(baseCurrency.getPrecision(), 4));
            row.addCell("localCredit_" + currencyId).setValue(((BigDecimal)periodCredit.get(currencyId)).multiply(exchange).setScale(baseCurrency.getPrecision(), 4));
            row.addCell("localBalance_" + currencyId).setValue(((BigDecimal)balance.get(currencyId)).multiply(exchange).setScale(baseCurrency.getPrecision(), 4));
            row.addCell("exchange").setValue(exchange);
        }
        if (currencyIds.length == 1) {
            this.setRowDCByAmount(row, (BigDecimal)balance.get(currencyIds[0]));
        } else {
            row.addCell("dc").setValue((Object)DirectionEnum.Debit);
        }
    }

    private void addPeriodStart(Context ctx, QueryTable table, java.util.Date beginDate, Map balance, String[] currencyIds, BigDecimal exchange, CurrencyInfo baseCurrency) {
        QueryTableRow row = table.addRow();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        row.addCell("createDate").setValue(dateFormat.format(beginDate));
        row.addCell("description").setValue(CASWebUtil.getResource(ctx, "368_beginBalance"));
        for (int i = 0; i < currencyIds.length; ++i) {
            BigDecimal balanceValue = (BigDecimal)balance.get(currencyIds[i]);
            if (currencyIds.length == 1) {
                balanceValue = balanceValue.abs();
            }
            row.addCell("balance").setValue(balanceValue);
        }
        if (currencyIds.length == 1 && exchange != null) {
            row.addCell("exchange").setValue(exchange);
            row.addCell("localBalance_" + currencyIds[0]).setValue(((BigDecimal)balance.get(currencyIds[0])).multiply(exchange).setScale(baseCurrency.getPrecision(), 4));
        }
        if (currencyIds.length == 1) {
            this.setRowDCByAmount(row, (BigDecimal)balance.get(currencyIds[0]));
        } else {
            row.addCell("dc").setValue((Object)DirectionEnum.Debit);
        }
    }

    private void setRowDCByAmount(QueryTableRow row, BigDecimal amont) {
        if (amont.signum() > 0) {
            row.addCell("dc").setValue((Object)DirectionEnum.Debit);
        } else if (amont.signum() < 0) {
            row.addCell("dc").setValue((Object)DirectionEnum.Credit);
        } else {
            row.addCell("dc").setValue((Object)DirectionEnum.Balance);
        }
    }

    private void addDaySum(Context ctx, QueryTable table, java.util.Date beginDate, Map dayDebit, Map dayCredit, Map balance, String[] currencyIds, BigDecimal exchange, CurrencyInfo baseCurrency) {
        QueryTableRow row = table.addRow();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        row.addCell("createDate").setValue(dateFormat.format(beginDate));
        row.addCell("description").setValue(CASWebUtil.getResource(ctx, "369_DayTotal"));
        for (int i = 0; i < currencyIds.length; ++i) {
            String currencyId = currencyIds[i];
            BigDecimal debitAmount = (BigDecimal)dayDebit.get(currencyId);
            BigDecimal creditAmount = (BigDecimal)dayCredit.get(currencyId);
            BigDecimal balanceAmount = (BigDecimal)balance.get(currencyId);
            if (currencyIds.length == 1) {
                balanceAmount = balanceAmount.abs();
            }
            row.addCell("debitAmount").setValue(debitAmount);
            row.addCell("creditAmount").setValue(creditAmount);
            row.addCell("balance").setValue(balanceAmount);
        }
        if (currencyIds.length == 1 && exchange != null) {
            String currencyId = currencyIds[0];
            row.addCell("localDebit_" + currencyId).setValue(((BigDecimal)dayDebit.get(currencyId)).multiply(exchange).setScale(baseCurrency.getPrecision(), 4));
            row.addCell("localCredit_" + currencyId).setValue(((BigDecimal)dayCredit.get(currencyId)).multiply(exchange).setScale(baseCurrency.getPrecision(), 4));
            row.addCell("localBalance_" + currencyId).setValue(((BigDecimal)balance.get(currencyId)).multiply(exchange).setScale(baseCurrency.getPrecision(), 4));
            row.addCell("exchange").setValue(exchange);
        }
        if (currencyIds.length == 1) {
            this.setRowDCByAmount(row, (BigDecimal)balance.get(currencyIds[0]));
        } else {
            row.addCell("dc").setValue((Object)DirectionEnum.Debit);
        }
    }

    private void changePeriodData(String[] currencyIds, Map periodDebit, Map periodCredit, Map dayDebit, Map dayCredit) {
        int i;
        for (i = 0; i < currencyIds.length; ++i) {
            periodDebit.put(currencyIds[i], ((BigDecimal)periodDebit.get(currencyIds[i])).add((BigDecimal)dayDebit.get(currencyIds[i])));
        }
        for (i = 0; i < currencyIds.length; ++i) {
            periodCredit.put(currencyIds[i], ((BigDecimal)periodCredit.get(currencyIds[i])).add((BigDecimal)dayCredit.get(currencyIds[i])));
        }
        this.clearMap(currencyIds, dayDebit);
        this.clearMap(currencyIds, dayCredit);
    }

    private void changeYearData(String[] currencyIds, Map yearDebit, Map yearCredit, Map periodDebit, Map periodCredit) {
        int i;
        for (i = 0; i < currencyIds.length; ++i) {
            yearDebit.put(currencyIds[i], ((BigDecimal)yearDebit.get(currencyIds[i])).add((BigDecimal)periodDebit.get(currencyIds[i])));
        }
        for (i = 0; i < currencyIds.length; ++i) {
            yearCredit.put(currencyIds[i], ((BigDecimal)yearCredit.get(currencyIds[i])).add((BigDecimal)periodCredit.get(currencyIds[i])));
        }
        this.clearMap(currencyIds, periodDebit);
        this.clearMap(currencyIds, periodCredit);
    }

    private Map getYearDebitSum(Context ctx, String[] currencyIds, CompanyOrgUnitInfo company, String accountBankId, String accountViewId, java.util.Date beginDate, PeriodInfo periodStart, boolean accContrastEnable) throws EASBizException, BOSException, SQLException {
        GregorianCalendar endCal = new GregorianCalendar();
        endCal.setTime(beginDate);
        int year = endCal.get(1);
        GregorianCalendar beginCal = new GregorianCalendar(year, 0, 1);
        HashMap<String, BigDecimal> yearSum = new HashMap<String, BigDecimal>();
        String companyId = company.getId().toString();
        boolean isFirstYear = true;
        if (year != periodStart.getPeriodYear()) {
            isFirstYear = false;
        }
        for (int i = 0; i < currencyIds.length; ++i) {
            if (accContrastEnable) {
                yearSum.put(currencyIds[i], SysConstant.BIGZERO);
                continue;
            }
            String currencyId = currencyIds[i];
            BigDecimal value = SysConstant.BIGZERO;
            if (isFirstYear) {
                value = accountBankId == null ? this.getYearStartAmount(ctx, CashDataSourceEnum.C, companyId, accountViewId, null, currencyId, CashDataTypeEnum.JF) : this.getYearStartAmount(ctx, CashDataSourceEnum.B, companyId, null, accountBankId, currencyId, CashDataTypeEnum.JF);
            }
            ICashManagement cashInacct = CashManagementFactory.getLocalInstance(ctx);
            BigDecimal debit = null;
            debit = accountBankId == null ? cashInacct.getCashData(companyId, accountViewId, currencyId, beginCal.getTime(), DateUtil.getBeforeDay((java.util.Date)beginDate), CashDataTypeEnum.JF, true) : cashInacct.getBankData(companyId, accountBankId, currencyId, beginCal.getTime(), DateUtil.getBeforeDay((java.util.Date)beginDate), CashDataTypeEnum.JF, true);
            yearSum.put(currencyId, value.add(debit));
        }
        return yearSum;
    }

    private Map getYearCreditSum(Context ctx, String[] currencyIds, CompanyOrgUnitInfo company, String accountBankId, String accountViewId, java.util.Date beginDate, PeriodInfo periodStart, boolean accContrastEnable) throws EASBizException, BOSException, SQLException {
        GregorianCalendar endCal = new GregorianCalendar();
        endCal.setTime(beginDate);
        int year = endCal.get(1);
        GregorianCalendar begincal = new GregorianCalendar(year, 0, 1);
        HashMap<String, BigDecimal> yearSum = new HashMap<String, BigDecimal>();
        String companyId = company.getId().toString();
        boolean isFirstYear = true;
        if (year != periodStart.getPeriodYear()) {
            isFirstYear = false;
        }
        for (int i = 0; i < currencyIds.length; ++i) {
            if (accContrastEnable) {
                yearSum.put(currencyIds[i], SysConstant.BIGZERO);
                continue;
            }
            String currencyId = currencyIds[i];
            BigDecimal value = SysConstant.BIGZERO;
            if (isFirstYear) {
                value = accountBankId == null ? this.getYearStartAmount(ctx, CashDataSourceEnum.C, companyId, accountViewId, null, currencyId, CashDataTypeEnum.DF) : this.getYearStartAmount(ctx, CashDataSourceEnum.B, companyId, null, accountBankId, currencyId, CashDataTypeEnum.DF);
            }
            ICashManagement cashInacct = CashManagementFactory.getRemoteInstance();
            BigDecimal debit = null;
            debit = accountBankId == null ? cashInacct.getCashData(companyId, accountViewId, currencyId, begincal.getTime(), DateUtil.getBeforeDay((java.util.Date)beginDate), CashDataTypeEnum.DF, true) : cashInacct.getBankData(companyId, accountBankId, currencyId, begincal.getTime(), DateUtil.getBeforeDay((java.util.Date)beginDate), CashDataTypeEnum.DF, true);
            yearSum.put(currencyId, value.add(debit));
        }
        return yearSum;
    }

    public BigDecimal getYearStartAmount(Context ctx, CashDataSourceEnum dataSource, String companyId, String accountId, String accountBankIds, String currencyId, CashDataTypeEnum dataType) throws EASBizException, BOSException, SQLException {
        PeriodInfo startPeriod = CASWebHelper.getCashStartPeriod(ctx, companyId);
        if (startPeriod == null) {
            return CasConstants.ZERO;
        }
        StringBuffer sql = new StringBuffer();
        if (dataType.equals((Object)CashDataTypeEnum.JF)) {
            sql.append("select FDebitStartAmt result from T_CAS_JournalBalance where ");
        } else if (dataType.equals((Object)CashDataTypeEnum.DF)) {
            sql.append("select FCreditStartAmt result from T_CAS_JournalBalance where ");
        } else {
            return SysConstant.BIGZERO;
        }
        sql.append("FCompanyId='").append(companyId).append("' and FCurrencyId ='").append(currencyId).append("' and FPeriodId='").append(startPeriod.getId().toString()).append("'");
        if (dataSource.getValue() == 3) {
            sql.append("and FType= 3");
        } else if (dataSource.getValue() == 1) {
            sql.append("and FType= 2");
        } else {
            sql.append("and FType= 1");
        }
        if (!dataSource.equals((Object)CashDataSourceEnum.C) && !dataSource.equals((Object)CashDataSourceEnum.S) && accountBankIds != null && accountBankIds.length() > 0) {
            sql.append(" and FAccountBankID ='").append(accountBankIds + "'");
        }
        if (accountId != null) {
            sql.append(" and FAccountViewId ='").append(accountId).append("'");
        }
        sql.append(" and FIsInit =1");
        ISQLExecutor executor = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        IRowSet rowSet = executor.executeSQL();
        BigDecimal result = SysConstant.BIGZERO;
        if (rowSet.next()) {
            result = rowSet.getBigDecimal("result");
        }
        return result;
    }
}

