/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeCollection;
import com.kingdee.eas.basedata.assistant.PeriodTypeFactory;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountRefContrastCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.Account_ControlCollection;
import com.kingdee.eas.basedata.master.account.Account_ControlFactory;
import com.kingdee.eas.basedata.master.account.IAccountRefContrast;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CapitalVcSummaryFilterUIVerifyDTO;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.CashCommonException;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fi.cas.CompanyPeriodCol;
import com.kingdee.eas.fi.cas.CompanyPeriodSingleInfo;
import com.kingdee.eas.fi.cas.ICashManagement;
import com.kingdee.eas.fi.cas.JournalBalanceCollection;
import com.kingdee.eas.fi.cas.JournalBalanceFactory;
import com.kingdee.eas.fi.cas.JournalBalanceInfo;
import com.kingdee.eas.fi.cas.XTable;
import com.kingdee.eas.fi.cas.app.AbstractCapitalVcSummaryFetchParamFacadeControllerBean;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMPeriodUtils;
import com.kingdee.eas.fm.common.FmSysStatusCtrlUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CapitalVcSummaryFetchParamFacadeControllerBean
extends AbstractCapitalVcSummaryFetchParamFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.CapitalVcSummaryFetchParamFacadeControllerBean");
    private CompanyOrgUnitInfo currentCompany;

    @Override
    protected Map _fetchDataBatchForFilterUI(Context ctx, Map paramMap) throws BOSException, EASBizException {
        this.currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            paramMap.put("accountTable", this.getAccountTableInfo(ctx));
            paramMap.put("periodType", this.getPeriodType(ctx, paramMap));
        } else {
            paramMap.put("accountTableCol", this.getAccountTableCol(ctx));
            paramMap.put("periondCol", this.getPeriodCol(ctx, paramMap));
        }
        paramMap.put("currencyCollection", this.getCurrencyCollection(ctx));
        paramMap.put("periodCollection", this.getPeroindCollection(ctx, (PeriodTypeInfo)paramMap.get("periodType")));
        paramMap.put("isStart", this.getIsStart(ctx));
        paramMap.put("currentPeriod", this.getCurrencyPeriod(ctx));
        return paramMap;
    }

    private PeriodInfo getCurrencyPeriod(Context ctx) throws EASBizException, BOSException {
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            return null;
        }
        PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.currentCompany);
        return curPeriod;
    }

    private Boolean getIsStart(Context ctx) throws EASBizException, BOSException {
        boolean flag = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.currentCompany);
        return flag;
    }

    private PeriodTypeCollection getPeriodCol(Context ctx, Map paramMap) throws BOSException {
        PeriodTypeCollection typeCol = PeriodTypeFactory.getLocalInstance((Context)ctx).getPeriodTypeCollection();
        BOSUuid curID = this.currentCompany.getAccountPeriodType().getId();
        for (int i = 0; i < typeCol.size(); ++i) {
            PeriodTypeInfo infoType = typeCol.get(i);
            if (!infoType.getId().equals((Object)curID)) continue;
            paramMap.put("periodType", infoType);
            break;
        }
        return typeCol;
    }

    private AccountTableCollection getAccountTableCol(Context ctx) throws BOSException {
        String cuId = this.currentCompany.getCU().getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("destcu", (Object)cuId));
        filter.getFilterItems().add(new FilterItemInfo("isDefaultForRefer", (Object)new Integer(0)));
        view.setFilter(filter);
        Account_ControlCollection account_ControlCollection = Account_ControlFactory.getLocalInstance((Context)ctx).getAccount_ControlCollection(view);
        int size = account_ControlCollection.size();
        String[] ids = new String[size];
        for (int i = 0; i < size; ++i) {
            ids[i] = account_ControlCollection.get(i).getAccountTableID().getId().toString();
        }
        AccountTableCollection accountTableCollection = AccountTableFactory.getLocalInstance((Context)ctx).getAccountTableCollection(CapitalVcSummaryFetchParamFacadeControllerBean.getIncludeEntityView("id", ids));
        return accountTableCollection;
    }

    public static EntityViewInfo getIncludeEntityView(String key, String[] array) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        Set bankSet = CapitalVcSummaryFetchParamFacadeControllerBean.getSetByArray(array);
        if (bankSet != null && bankSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo(key, (Object)bankSet, CompareType.INCLUDE));
        }
        return view;
    }

    public static Set getSetByArray(String[] array) {
        HashSet<String> set = new HashSet<String>();
        if (array == null) {
            return set;
        }
        for (int i = 0; i < array.length; ++i) {
            set.add(array[i]);
        }
        return set;
    }

    private PeriodTypeInfo getPeriodType(Context ctx, Map paramMap) throws EASBizException, BOSException, UuidException {
        PeriodTypeInfo typeInfo = PeriodTypeFactory.getLocalInstance((Context)ctx).getPeriodTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.currentCompany.getAccountPeriodType().getId().toString())));
        paramMap.put("periodType", typeInfo);
        return typeInfo;
    }

    private AccountTableInfo getAccountTableInfo(Context ctx) throws EASBizException, BOSException {
        return AccountTableFactory.getLocalInstance((Context)ctx).getAccountTableInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.currentCompany.getAccountTable().getId().toString())));
    }

    private Object getPeroindCollection(Context ctx, PeriodTypeInfo periodTypeInfo) throws EASBizException, BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.currentCompany);
            PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.currentCompany);
            filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)startPeriod.getBeginDate(), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)curPeriod.getEndDate(), CompareType.LESS_EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodTypeInfo.getId().toString()));
        evi.getSorter().add(new SorterItemInfo("periodYear"));
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        evi.setFilter(filter);
        PeriodCollection pc = null;
        pc = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(evi);
        return pc;
    }

    private Object getCurrencyCollection(Context ctx) throws BOSException, EASBizException {
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        return iCurrency.getCurrencyCollection(true);
    }

    @Override
    protected Map _fetchDataBatchForMainUI(Context ctx, Map paramMap) throws BOSException, EASBizException {
        this.currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        paramMap.put("currency", this.getCurrencyInfo(ctx, paramMap));
        paramMap.put("journalTable", this.getIournalTable(ctx, paramMap));
        paramMap.put("bsTable", this.getBsTable(ctx, paramMap));
        paramMap.put("actualAcctTableId", this.getActualAcctTableId(ctx, paramMap));
        return paramMap;
    }

    private String getActualAcctTableId(Context ctx, Map paramMap) throws BOSException, EASBizException {
        String actualAcctTableId = "";
        String[] companyIds = (String[])paramMap.get("companyIdsArray");
        int beginYear = (Integer)paramMap.get("beginYear");
        int beginPeriod = (Integer)paramMap.get("beginPeriod");
        int endYear = (Integer)paramMap.get("endYear");
        int endPeriod = (Integer)paramMap.get("endPeriod");
        CompanyOrgUnitCollection companys = this.getCompanyCol(ctx, companyIds);
        int len = companys.size();
        for (int i = 0; i < len; ++i) {
            actualAcctTableId = this.getActualAcctTable_MainUI(ctx, companys.get(i), beginYear, beginPeriod, endYear, endPeriod);
        }
        return actualAcctTableId;
    }

    private String getActualAcctTable_MainUI(Context ctx, CompanyOrgUnitInfo companyInfo, int beginYear, int beginPeriod, int endYear, int endPeriod) throws EASBizException, BOSException {
        if (FMHelper.isEmpty((CoreBaseInfo)companyInfo)) {
            companyInfo = this.currentCompany;
        }
        PeriodInfo beginPeriodInfo = this.getPeriodInfo(ctx, beginYear, beginPeriod, companyInfo);
        PeriodInfo endPeriodInfo = this.getPeriodInfo(ctx, endYear, endPeriod, companyInfo);
        return this.getActualAcctTable(ctx, companyInfo, beginPeriodInfo.getBeginDate(), endPeriodInfo.getEndDate());
    }

    private XTable getBsTable(Context ctx, Map paramMap) throws EASBizException, BOSException {
        PeriodCollection periodCol = (PeriodCollection)paramMap.get("periodCol");
        String[] companyIds = (String[])paramMap.get("companyIdsArray");
        String[] bankIds = (String[])paramMap.get("bankIdsIdsArray");
        CurrencyInfo currency = this.getCurrencyInfo(ctx, paramMap);
        XTable balanceTable = CapitalVcSummaryFetchParamFacadeControllerBean.createBSBalanceTable(ctx, periodCol.get(0), companyIds, bankIds, currency);
        XTable sumTable = CapitalVcSummaryFetchParamFacadeControllerBean.createBSSumTable(ctx, periodCol, companyIds, bankIds, new String[]{currency.getId().toString()});
        for (int i = 0; i < periodCol.size(); ++i) {
            PeriodInfo curPeriod = periodCol.get(i);
            String[] rowKeys = balanceTable.getRowKeys();
            for (int j = 0; j < rowKeys.length; ++j) {
                String rowKey = rowKeys[j];
                Map balanceRow = balanceTable.getRow(rowKey);
                PeriodInfo period = (PeriodInfo)balanceRow.get("period");
                if (!curPeriod.getId().toString().equals(period.getId().toString())) continue;
                Map sumRow = sumTable.getRow(rowKey);
                if (sumRow != null) {
                    BigDecimal debitAmount = (BigDecimal)sumRow.get("debitamount");
                    BigDecimal creditAmount = (BigDecimal)sumRow.get("creditamount");
                    if (debitAmount == null) {
                        debitAmount = FMConstants.ZERO;
                    }
                    if (creditAmount == null) {
                        creditAmount = FMConstants.ZERO;
                    }
                    balanceRow.put("debitAmount", debitAmount);
                    balanceRow.put("creditAmount", creditAmount);
                } else {
                    balanceRow.put("debitAmount", FMConstants.ZERO);
                    balanceRow.put("creditAmount", FMConstants.ZERO);
                }
                if (i == periodCol.size() - 1) continue;
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)balanceRow.get("company");
                BankInfo bank = (BankInfo)balanceRow.get("bank");
                CurrencyInfo currencyInfo = (CurrencyInfo)balanceRow.get("currency");
                AccountBankInfo accountBank = (AccountBankInfo)balanceRow.get("accountBank");
                BigDecimal balance = (BigDecimal)balanceRow.get("balance");
                BigDecimal debitAmount = (BigDecimal)balanceRow.get("debitAmount");
                BigDecimal creditAmount = (BigDecimal)balanceRow.get("creditAmount");
                Map nextPeriodRow = balanceTable.addRow(periodCol.get(i + 1).getId().toString() + company.getId().toString() + bank.getId().toString() + currencyInfo.getId().toString() + accountBank.getId().toString());
                nextPeriodRow.put("period", periodCol.get(i + 1));
                nextPeriodRow.put("company", company);
                nextPeriodRow.put("bank", bank);
                nextPeriodRow.put("currency", currencyInfo);
                nextPeriodRow.put("accountBank", accountBank);
                nextPeriodRow.put("balance", balance.add(creditAmount).subtract(debitAmount));
                nextPeriodRow.put("debitAmount", FMConstants.ZERO);
                nextPeriodRow.put("creditAmount", FMConstants.ZERO);
            }
        }
        return balanceTable;
    }

    private static XTable createBSSumTable(Context ctx, PeriodCollection periodCol, String[] companyIds, String[] bankIds, String[] currencyIds) throws BOSException {
        String sumSql = CapitalVcSummaryFetchParamFacadeControllerBean.getBSSumSQL(periodCol, companyIds, bankIds, currencyIds);
        IRowSet sumRS = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sumSql).executeSQL();
        XTable xSumTable = new XTable(sumRS, new String[]{"period", "company", "bank", "currency", "accountBank"});
        return xSumTable;
    }

    private static String getBSSumSQL(PeriodCollection periodCol, String[] companyIds, String[] bankIds, String[] currencyIds) {
        int i;
        String select = "Select FPeriodID as period,t1.FCompanyID as company,FBank as bank,t1.FCurrencyID as currency,FAccountBankId as accountBank,sum(FDebitAmount) as debitAmount,sum(FCreditAmount) as creditAmount";
        String from = " From t_cas_bankStatement t1 left join t_bd_accountBanks t2 on t1.faccountbankid=t2.fid";
        String groupBy = " Group By FPeriodID,t1.FCompanyID,FBank,t1.FCurrencyID,FAccountBankId";
        StringBuffer where = new StringBuffer();
        where.append(" where 1=1 ");
        if (periodCol != null) {
            where.append(" And t1.FPeriodID in ('").append(periodCol.get(0).getId().toString()).append("'");
            for (i = 1; i < periodCol.size(); ++i) {
                where.append(",'").append(periodCol.get(i).getId().toString()).append("'");
            }
            where.append(")");
        }
        if (companyIds != null && companyIds.length != 0) {
            where.append(" And t1.FcompanyId in ('").append(companyIds[0]).append("'");
            for (i = 1; i < companyIds.length; ++i) {
                where.append(",'").append(companyIds[i]).append("'");
            }
            where.append(")");
        }
        if (bankIds != null && bankIds.length != 0) {
            where.append(" And  FBank in ('").append(bankIds[0]).append("'");
            for (i = 1; i < bankIds.length; ++i) {
                where.append(",'").append(bankIds[i]).append("'");
            }
            where.append(")");
        }
        if (currencyIds != null && currencyIds.length != 0) {
            where.append(" And  t1.FCurrencyID in ('").append(currencyIds[0]).append("'");
            for (i = 1; i < currencyIds.length; ++i) {
                where.append(",'").append(currencyIds[i]).append("'");
            }
            where.append(")");
        }
        String sql = select + from + where + groupBy;
        return sql;
    }

    private static XTable createBSBalanceTable(Context ctx, PeriodInfo period, String[] companyIds, String[] bankIds, CurrencyInfo currency) throws EASBizException, BOSException {
        XTable bsTable = new XTable();
        bsTable.addColumn("period");
        bsTable.addColumn("company");
        bsTable.addColumn("bank");
        bsTable.addColumn("accountBank");
        bsTable.addColumn("balance");
        bsTable.addColumn("debitAmount");
        bsTable.addColumn("creditAmount");
        CapitalVcSummaryFetchParamFacadeControllerBean.fillBSBalanceReport_New(ctx, bsTable, period, companyIds, bankIds, currency);
        return bsTable;
    }

    private static void fillBSBalanceReport_New(Context ctx, XTable bsTable, PeriodInfo period, String[] companyIds, String[] bankIds, CurrencyInfo currency) throws BOSException, EASBizException {
        boolean param = false;
        AccountBankCollection col = null;
        HashSet<String> bankSet = new HashSet<String>();
        if (bankIds != null) {
            for (int m = 0; m < bankIds.length; ++m) {
                bankSet.add(bankIds[m]);
            }
        }
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("bankAccountNumber");
        selector.add("name");
        selector.add("account.id");
        selector.add("account.number");
        selector.add("account.name");
        selector.add("bank.id");
        selector.add("bank.name");
        selector.add("company.name");
        selector.add("company.number");
        FilterInfo fi = new FilterInfo();
        if (companyIds != null && companyIds.length > 0) {
            fi.getFilterItems().add(new FilterItemInfo("company.id", new HashSet<String>(Arrays.asList(companyIds)), CompareType.INCLUDE));
        }
        if (bankIds != null) {
            fi.getFilterItems().add(new FilterItemInfo("bank.id", bankSet, CompareType.INCLUDE));
        }
        if (!param) {
            fi.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        }
        evi.setFilter(fi);
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        col = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(evi);
        if (col == null || col.size() == 0) {
            throw new CashCommonException(CashCommonException.ACCOUNTBANKEMPTY);
        }
        ICashManagement iCash = CashManagementFactory.getLocalInstance(ctx);
        CompanyPeriodCol companyPeriod = CapitalVcSummaryFetchParamFacadeControllerBean.getAllCompanyPeriodInfo(ctx, col);
        Map hmBalance = iCash.getBStateData2Map(col, currency.getId().toString(), period.getBeginDate(), period.getBeginDate(), CashDataTypeEnum.C, false, companyPeriod);
        for (int i = 0; i < col.size(); ++i) {
            AccountBankInfo accountBank = col.get(i);
            String rowKey = period.getId().toString() + accountBank.getCompany().getId().toString() + accountBank.getBank().getId().toString() + currency.getId().toString() + accountBank.getId().toString();
            Map map = bsTable.addRow(rowKey);
            BigDecimal balance = CapitalVcSummaryFetchParamFacadeControllerBean.getBalanceFromCache(accountBank, period, currency, hmBalance);
            map.put("period", period);
            map.put("company", accountBank.getCompany());
            map.put("bank", accountBank.getBank());
            map.put("currency", currency);
            map.put("accountBank", accountBank);
            map.put("balance", balance);
            map.put("debitAmount", FMConstants.ZERO);
            map.put("creditAmount", FMConstants.ZERO);
        }
    }

    private static CompanyPeriodCol getAllCompanyPeriodInfo(Context ctx, AccountBankCollection col) throws BOSException {
        CompanyPeriodCol co = new CompanyPeriodCol();
        String sql = CapitalVcSummaryFetchParamFacadeControllerBean.getSQL(col);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        CompanyPeriodSingleInfo cpi = null;
        try {
            while (rs.next()) {
                cpi = new CompanyPeriodSingleInfo();
                cpi.setCompanyID(rs.getString("companyid"));
                cpi.setStartP(CapitalVcSummaryFetchParamFacadeControllerBean.createStartPeriod(rs));
                cpi.setCurrP(CapitalVcSummaryFetchParamFacadeControllerBean.createCurrPeriod(rs));
                co.add(cpi);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getCause());
        }
        return co;
    }

    private static PeriodInfo createCurrPeriod(IRowSet rs) throws UuidException, SQLException {
        PeriodInfo curP = new PeriodInfo();
        if (rs.getString("currpid") == null) {
            return null;
        }
        curP.setId(BOSUuid.read((String)rs.getString("currpid")));
        curP.setPeriodYear(rs.getInt("currpy"));
        curP.setPeriodQuarter(rs.getInt("currpq"));
        curP.setPeriodNumber(rs.getInt("currpn"));
        curP.setBeginDate((Date)rs.getDate("currps"));
        curP.setEndDate(rs.getTimestamp("currpe"));
        curP.setIsAdjustPeriod(rs.getBoolean("currpisa"));
        return curP;
    }

    private static PeriodInfo createStartPeriod(IRowSet rs) throws UuidException, SQLException {
        PeriodInfo startp = new PeriodInfo();
        if (rs.getString("startpid") == null) {
            return null;
        }
        startp.setId(BOSUuid.read((String)rs.getString("startpid")));
        startp.setPeriodYear(rs.getInt("startpy"));
        startp.setPeriodQuarter(rs.getInt("startpq"));
        startp.setPeriodNumber(rs.getInt("startpn"));
        startp.setBeginDate((Date)rs.getDate("startps"));
        startp.setEndDate(rs.getTimestamp("startpe"));
        startp.setIsAdjustPeriod(rs.getBoolean("startpisa"));
        return startp;
    }

    private static String getSQL(AccountBankCollection col) {
        StringBuffer sb = new StringBuffer();
        sb.append("select ssc.fcompanyid as companyid , \n");
        sb.append(" \n");
        sb.append("startp.fid as startpid,startp.fperiodyear as startpy,startp.fperiodquarter as startpq,startp.fperiodnumber as startpn, \n");
        sb.append("startp.fbegindate as startps,startp.fenddate as startpe,startp.fisadjustperiod as startpisa, \n");
        sb.append(" \n");
        sb.append("currp.fid as currpid,currp.fperiodyear as currpy,currp.fperiodquarter as currpq,currp.fperiodnumber as currpn, \n");
        sb.append("currp.fbegindate as currps,currp.fenddate as currpe,currp.fisadjustperiod as currpisa \n");
        sb.append(" \n");
        sb.append("from T_BD_SystemStatusCtrol as ssc \n");
        sb.append("left outer join T_BD_SystemStatus as ss on ssc.FSystemStatusID=ss.FID  \n");
        sb.append("left outer join T_BD_Period as startp on ssc.FStartPeriodID=startp.FID \n");
        sb.append("left outer join T_BD_Period as currp on ssc.FCurrentPeriodID=currp.FID \n");
        sb.append("where ssc.FCompanyID in ").append(FMHelper.setTran2String((Set)CapitalVcSummaryFetchParamFacadeControllerBean.getCompanyIDSet(col))).append(" and ss.FName=7 \n");
        return sb.toString();
    }

    private static Set getCompanyIDSet(AccountBankCollection col) {
        HashSet<String> idSet = new HashSet<String>();
        if (col == null || col.size() == 0) {
            idSet.add("");
        } else {
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                if (col.get(i).getCompany() == null) continue;
                idSet.add(col.get(i).getCompany().getId().toString());
            }
        }
        return idSet;
    }

    private static BigDecimal getBalanceFromCache(AccountBankInfo accountBank, PeriodInfo period, CurrencyInfo currency, Map hmBalance) {
        String currencyId;
        String accountBankId;
        String companyId = accountBank.getCompany().getId().toString();
        String key = CapitalVcSummaryFetchParamFacadeControllerBean.genKey(companyId, accountBankId = accountBank.getId().toString(), currencyId = currency.getId().toString(), period.getBeginDate(), period.getBeginDate());
        Object banlanc = hmBalance.get(key);
        return banlanc == null ? FMConstants.ZERO : (BigDecimal)banlanc;
    }

    private static String genKey(String companyId, String accountBankId, String currencyId, Date beginDate, Date endDate) {
        StringBuffer sb = new StringBuffer();
        sb.append(companyId).append(accountBankId).append(currencyId).append(beginDate.toString()).append(endDate.toString());
        return sb.toString();
    }

    private XTable getIournalTable(Context ctx, Map paramMap) throws EASBizException, BOSException {
        return this.createJournalDataTable(ctx, (PeriodCollection)paramMap.get("periodCol"), (String[])paramMap.get("companyIdsArray"), (String[])paramMap.get("bankIdsIdsArray"), this.getCurrencyInfo(ctx, paramMap));
    }

    private XTable createJournalDataTable(Context ctx, PeriodCollection periodCol, String[] companyIds, String[] bankIds, CurrencyInfo currency) throws BOSException {
        XTable balanceTable = CapitalVcSummaryFetchParamFacadeControllerBean.createJournalBalanceTable(ctx, periodCol, companyIds, bankIds, currency);
        XTable sumTable = CapitalVcSummaryFetchParamFacadeControllerBean.createJournalSumTable(ctx, periodCol, companyIds, bankIds, new String[]{currency.getId().toString()});
        for (int i = 0; i < periodCol.size(); ++i) {
            PeriodInfo curPeriod = periodCol.get(i);
            String[] rowKeys = balanceTable.getRowKeys();
            for (int j = 0; j < rowKeys.length; ++j) {
                String rowKey = rowKeys[j];
                Map balanceRow = balanceTable.getRow(rowKey);
                PeriodInfo period = (PeriodInfo)balanceRow.get("period");
                if (!curPeriod.getId().toString().equals(period.getId().toString())) continue;
                Map sumRow = sumTable.getRow(rowKey);
                if (sumRow != null) {
                    BigDecimal debitAmount = (BigDecimal)sumRow.get("debitamount");
                    BigDecimal creditAmount = (BigDecimal)sumRow.get("creditamount");
                    if (debitAmount == null) {
                        debitAmount = FMConstants.ZERO;
                    }
                    if (creditAmount == null) {
                        creditAmount = FMConstants.ZERO;
                    }
                    String periodID = (String)sumRow.get("period");
                    if (period.getId().toString().equals(periodID) && period.isIsAdjustPeriod()) {
                        debitAmount = FMConstants.ZERO;
                    }
                    balanceRow.put("debitAmount", debitAmount);
                    balanceRow.put("creditAmount", creditAmount);
                } else {
                    balanceRow.put("debitAmount", FMConstants.ZERO);
                    balanceRow.put("creditAmount", FMConstants.ZERO);
                }
                if (i == periodCol.size() - 1) continue;
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)balanceRow.get("company");
                BankInfo bank = (BankInfo)balanceRow.get("bank");
                CurrencyInfo currencyInfo = (CurrencyInfo)balanceRow.get("currency");
                AccountBankInfo accountBank = (AccountBankInfo)balanceRow.get("accountBank");
                BigDecimal balance = (BigDecimal)balanceRow.get("balance");
                BigDecimal debitAmount = (BigDecimal)balanceRow.get("debitAmount");
                BigDecimal creditAmount = (BigDecimal)balanceRow.get("creditAmount");
                Map nextPeriodRow = balanceTable.addRow(periodCol.get(i + 1).getId().toString() + company.getId().toString() + bank.getId().toString() + currencyInfo.getId().toString() + accountBank.getId().toString());
                nextPeriodRow.put("period", periodCol.get(i + 1));
                nextPeriodRow.put("company", company);
                nextPeriodRow.put("bank", bank);
                nextPeriodRow.put("currency", currencyInfo);
                nextPeriodRow.put("accountBank", accountBank);
                nextPeriodRow.put("balance", balance.add(debitAmount).subtract(creditAmount));
                nextPeriodRow.put("debitAmount", FMConstants.ZERO);
                nextPeriodRow.put("creditAmount", FMConstants.ZERO);
            }
        }
        return balanceTable;
    }

    private static XTable createJournalBalanceTable(Context ctx, PeriodCollection periodCol, String[] companyIds, String[] bankIds, CurrencyInfo currency) throws BOSException {
        XTable journalTable = new XTable();
        journalTable.addColumn("period");
        journalTable.addColumn("company");
        journalTable.addColumn("bank");
        journalTable.addColumn("accountBank");
        journalTable.addColumn("balance");
        journalTable.addColumn("debitAmount");
        journalTable.addColumn("creditAmount");
        String[] periodIds = new String[periodCol.size()];
        for (int i = 0; i < periodCol.size(); ++i) {
            PeriodInfo period = periodCol.get(i);
            periodIds[i] = period.getId().toString();
            boolean param = false;
            AccountBankCollection col = new AccountBankCollection();
            HashSet<String> bankSet = new HashSet<String>();
            if (bankIds != null) {
                for (int m = 0; m < bankIds.length; ++m) {
                    bankSet.add(bankIds[m]);
                }
            }
            EntityViewInfo evi = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("bankAccountNumber");
            selector.add("name");
            selector.add("account.id");
            selector.add("account.number");
            selector.add("account.name");
            selector.add("bank.id");
            selector.add("bank.name");
            selector.add("company.name");
            selector.add("company.number");
            FilterInfo fi = new FilterInfo();
            if (companyIds != null && companyIds.length > 0) {
                fi.getFilterItems().add(new FilterItemInfo("company.id", new HashSet<String>(Arrays.asList(companyIds)), CompareType.INCLUDE));
            }
            if (bankSet != null && bankSet.size() > 0) {
                fi.getFilterItems().add(new FilterItemInfo("bank.id", bankSet, CompareType.INCLUDE));
            }
            if (!param) {
                fi.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
            }
            evi.setFilter(fi);
            evi.getSelector().addObjectCollection((IObjectCollection)selector);
            col = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(evi);
            for (int j = 0; j < col.size(); ++j) {
                AccountBankInfo accountBank = col.get(j);
                String rowKey = period.getId().toString() + accountBank.getCompany().getId().toString() + accountBank.getBank().getId().toString() + currency.getId().toString() + accountBank.getId().toString();
                Map map = journalTable.addRow(rowKey);
                map.put("period", period);
                map.put("company", accountBank.getCompany());
                map.put("bank", accountBank.getBank());
                map.put("currency", currency);
                map.put("accountBank", accountBank);
                map.put("balance", FMConstants.ZERO);
                map.put("debitAmount", FMConstants.ZERO);
                map.put("creditAmount", FMConstants.ZERO);
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("*");
        view.getSelector().add("period.*");
        view.getSelector().add("accountBank.bank.*");
        view.getSelector().add("accountBank.account.*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)FMHelper.asSet((String[])periodIds), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)FMHelper.asSet((String[])companyIds), CompareType.INCLUDE));
        if (!FMHelper.isEmpty((Object[])bankIds)) {
            filter.getFilterItems().add(new FilterItemInfo("accountBank.bank.id", (Object)FMHelper.asSet((String[])bankIds), CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currency.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(2)));
        view.setFilter(filter);
        JournalBalanceCollection col = JournalBalanceFactory.getLocalInstance(ctx).getJournalBalanceCollection(view);
        for (int i = 0; i < col.size(); ++i) {
            Map map;
            JournalBalanceInfo journalBalance = col.get(i);
            String rowKey = journalBalance.getPeriod().getId().toString() + journalBalance.getCompany().getId().toString() + journalBalance.getAccountBank().getBank().getId().toString() + journalBalance.getCurrency().getId().toString() + journalBalance.getAccountBank().getId().toString();
            if (journalBalance.getPeriod().isIsAdjustPeriod()) {
                if (journalBalance.getAccountView().getId().toString().equals(journalBalance.getAccountBank().getAccount().getId().toString()) || (map = journalTable.getRow(rowKey)) == null) continue;
                map.put("balance", journalBalance.getMonthStartAmt());
                map.put("debitAmount", journalBalance.getMonthDebitAmt());
                map.put("creditAmount", journalBalance.getMonthCreditAmt());
                continue;
            }
            if (!journalBalance.getAccountView().getId().equals((Object)journalBalance.getAccountBank().getAccount().getId()) || (map = journalTable.getRow(rowKey)) == null) continue;
            map.put("balance", journalBalance.getMonthStartAmt());
            map.put("debitAmount", journalBalance.getMonthDebitAmt());
            map.put("creditAmount", journalBalance.getMonthCreditAmt());
        }
        return journalTable;
    }

    private static XTable createJournalSumTable(Context ctx, PeriodCollection periodCol, String[] companyIds, String[] bankIds, String[] currencyIds) throws BOSException {
        String sumSql = CapitalVcSummaryFetchParamFacadeControllerBean.getJournalSumSQL(periodCol, companyIds, bankIds, currencyIds);
        IRowSet sumRS = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sumSql).executeSQL();
        XTable xSumTable = new XTable(sumRS, new String[]{"period", "company", "bank", "currency", "accountBank"});
        return xSumTable;
    }

    private static String getJournalSumSQL(PeriodCollection periodCol, String[] companyIds, String[] bankIds, String[] currencyIds) {
        int i;
        String select = "Select FPeriodID as period,t1.FCompanyID as company,FBank as bank,t1.FCurrencyID as currency,FAccountBankId as accountBank,sum(FDebitAmount) as debitAmount,sum(FCreditAmount) as creditAmount";
        String from = " From t_cas_journal t1 left join t_bd_accountBanks t2 on t1.faccountbankid=t2.fid";
        String groupBy = " Group By FPeriodID,t1.FCompanyID,FBank,t1.FCurrencyID,FAccountBankId";
        StringBuffer where = new StringBuffer();
        where.append(" where 1=1 ");
        if (periodCol != null) {
            where.append(" And t1.FPeriodID in ('").append(periodCol.get(0).getId().toString()).append("'");
            for (i = 1; i < periodCol.size(); ++i) {
                where.append(",'").append(periodCol.get(i).getId().toString()).append("'");
            }
            where.append(")");
        }
        if (companyIds != null && companyIds.length != 0) {
            where.append(" And t1.FcompanyId in ('").append(companyIds[0]).append("'");
            for (i = 1; i < companyIds.length; ++i) {
                where.append(",'").append(companyIds[i]).append("'");
            }
            where.append(")");
        }
        if (bankIds != null && bankIds.length != 0) {
            where.append(" And  FBank in ('").append(bankIds[0]).append("'");
            for (i = 1; i < bankIds.length; ++i) {
                where.append(",'").append(bankIds[i]).append("'");
            }
            where.append(")");
        }
        if (currencyIds != null && currencyIds.length != 0) {
            where.append(" And  t1.FCurrencyID in ('").append(currencyIds[0]).append("'");
            for (i = 1; i < currencyIds.length; ++i) {
                where.append(",'").append(currencyIds[i]).append("'");
            }
            where.append(")");
        }
        String sql = select + from + where + groupBy;
        return sql;
    }

    private CurrencyInfo getCurrencyInfo(Context ctx, Map paramMap) throws EASBizException, BOSException {
        return CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)((String)paramMap.get("currencyID")))));
    }

    @Override
    protected Map _fetchDataBatchForFilterUIVerify(Context ctx, Map paramMap) throws BOSException, EASBizException {
        this.currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        paramMap.put("CapitalVcSummaryFilterUIVerifyDTOList", this.getCapitalVcSummaryFilterUIVerifyDTOList(ctx, paramMap));
        return paramMap;
    }

    private List getCapitalVcSummaryFilterUIVerifyDTOList(Context ctx, Map paramMapVer) throws BOSException, EASBizException {
        Integer beginYear = (Integer)paramMapVer.get("beginYear");
        Integer endYear = (Integer)paramMapVer.get("endYear");
        Integer beginPeriod = (Integer)paramMapVer.get("beginPeriod");
        Integer endPeriod = (Integer)paramMapVer.get("endPeriod");
        ArrayList<CapitalVcSummaryFilterUIVerifyDTO> liReturn = new ArrayList<CapitalVcSummaryFilterUIVerifyDTO>();
        String[] companyIds = (String[])paramMapVer.get("companyIDs");
        CompanyOrgUnitCollection companys = this.getCompanyCol(ctx, companyIds);
        HashSet<String> companyIdSet = new HashSet<String>();
        int len = companyIds.length;
        for (int i = 0; i < len; ++i) {
            companyIdSet.add(companyIds[i]);
        }
        int system = 7;
        Map isStartMap = FmSysStatusCtrlUtils.isStart((Context)ctx, (int)system, companyIdSet);
        Map startPeriodMap = FmSysStatusCtrlUtils.getStartPeriod((Context)ctx, (int)system, companyIdSet);
        Map currentPeriodMap = FmSysStatusCtrlUtils.getCurrentPeriod((Context)ctx, (int)system, companyIdSet);
        Map beginPeriodMap = FMPeriodUtils.getPeriodColl((Context)ctx, (int)beginYear, (int)beginPeriod, companyIdSet);
        Map endPeriodMap = FMPeriodUtils.getPeriodColl((Context)ctx, (int)endYear, (int)endPeriod, companyIdSet);
        String companyId = null;
        for (int i = 0; i < companys.size(); ++i) {
            CompanyOrgUnitInfo tmp = companys.get(i);
            companyId = tmp.getId().toString();
            boolean isStart = (Boolean)isStartMap.get(companyId);
            PeriodInfo startPeriod = (PeriodInfo)startPeriodMap.get(companyId);
            PeriodInfo beginPeriodInfo = (PeriodInfo)beginPeriodMap.get(companyId);
            PeriodInfo curPeriod = (PeriodInfo)currentPeriodMap.get(companyId);
            PeriodInfo endPeriodInfo = (PeriodInfo)endPeriodMap.get(companyId);
            liReturn.add(new CapitalVcSummaryFilterUIVerifyDTO(tmp, isStart, startPeriod, curPeriod, beginPeriodInfo, endPeriodInfo));
        }
        return liReturn;
    }

    private CompanyOrgUnitCollection getCompanyCol(Context ctx, String[] companyIds) throws BOSException {
        EntityViewInfo ev = CapitalVcSummaryFetchParamFacadeControllerBean.getIncludeEntityView("id", companyIds);
        ev.getSelector().add("*");
        CompanyOrgUnitCollection companys = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(ev);
        return companys;
    }

    @Override
    protected Map _fetchDataBatchForFilterParam(Context ctx, Map paramMap) throws BOSException, EASBizException {
        paramMap.put("periodc", this.getPeriodColInFilterParam(ctx, paramMap));
        return paramMap;
    }

    private PeriodCollection getPeriodColInFilterParam(Context ctx, Map paramMap) throws EASBizException, BOSException {
        int beginYear = (Integer)paramMap.get("beginYear");
        int beginPeriod = (Integer)paramMap.get("beginPeriod");
        int endYear = (Integer)paramMap.get("endYear");
        int endPeriod = (Integer)paramMap.get("endPeriod");
        String periodTypeId = (String)paramMap.get("periodTypeId");
        PeriodCollection periodc = null;
        PeriodInfo beginPeriodInfo = FMPeriodUtils.getPeriodInfo((Context)ctx, (int)beginYear, (int)beginPeriod, (String)periodTypeId);
        PeriodInfo endPeriodInfo = FMPeriodUtils.getPeriodInfo((Context)ctx, (int)endYear, (int)endPeriod, (String)periodTypeId);
        if (beginPeriodInfo == null || endPeriodInfo == null) {
            throw new CasException(CasException.PERIOD_ERROR);
        }
        periodc = FMPeriodUtils.getPeriodCollection((Context)ctx, (Date)beginPeriodInfo.getBeginDate(), (Date)endPeriodInfo.getEndDate(), (String)periodTypeId);
        PeriodInfo period = null;
        for (int i = periodc.size() - 1; i >= 0; --i) {
            period = periodc.get(i);
            if ((period.getPeriodYear() != endYear || period.getPeriodNumber() <= endPeriod) && (period.getPeriodYear() != beginYear || period.getPeriodNumber() >= beginPeriod)) continue;
            periodc.remove(period);
        }
        return periodc;
    }

    @Override
    protected void _checkActualAcctTable(Context ctx, String[] companyIds, int beginYear, int beginMonth, int endYear, int endMonth) throws BOSException, EASBizException {
        this.currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        CompanyOrgUnitCollection companyCol = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(CapitalVcSummaryFetchParamFacadeControllerBean.getIncludeEntityView("id", companyIds));
        int len = companyCol.size();
        for (int i = 0; i < len; ++i) {
            CompanyOrgUnitInfo companyInfo = companyCol.get(i);
            if (FMHelper.isEmpty((CoreBaseInfo)companyInfo)) {
                companyInfo = this.currentCompany;
            }
            PeriodInfo beginPeriod = this.getPeriodInfo(ctx, beginYear, beginMonth, companyInfo);
            PeriodInfo endPeriod = this.getPeriodInfo(ctx, endYear, endMonth, companyInfo);
            this.getActualAcctTable(ctx, companyInfo, beginPeriod.getBeginDate(), endPeriod.getEndDate());
        }
    }

    private String getActualAcctTable(Context ctx, CompanyOrgUnitInfo companyInfo, Date beginDate, Date endDate) throws BOSException, EASBizException {
        String cuId;
        AccountRefContrastCollection coll;
        if (FMHelper.isEmpty((CoreBaseInfo)companyInfo)) {
            companyInfo = this.currentCompany;
        }
        if ((coll = this.getStrideAcctRefContrastColl(ctx, cuId = companyInfo.getCU().getId().toString(), beginDate, endDate)) == null || coll.isEmpty()) {
            PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)endDate, (CompanyOrgUnitInfo)companyInfo);
            if (period == null) {
                throw new CasException(CasException.PERIODERROR, new Object[]{DateHelper.DateToString((Date)endDate)});
            }
            int yearNumber = period.getPeriodYear();
            int monthNumber = period.getPeriodNumber();
            try {
                AccountTableInfo tbl = companyInfo.getAccountTable();
                String currTableId = AccountTools.getCurrentAcctTable((Context)ctx, (String)cuId, (String)tbl.getId().toString(), (int)yearNumber, (int)monthNumber);
                return currTableId;
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                throw new FMException(FMException.HASCOMPANYADJUSTACCT, new Object[]{companyInfo.getName() + "(" + companyInfo.getNumber() + ")"});
            }
        }
        return null;
    }

    private AccountRefContrastCollection getStrideAcctRefContrastColl(Context ctx, String cuId, Date beginDate, Date endDate) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cuId));
        filter.getFilterItems().add(new FilterItemInfo("enabledPeriod.endDate", (Object)DateTimeUtils.truncateDate((Date)beginDate), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("enabledPeriod.endDate", (Object)DateTimeUtils.truncateDate((Date)endDate), CompareType.LESS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IAccountRefContrast acctContrast = AccountRefContrastFactory.getLocalInstance((Context)ctx);
        AccountRefContrastCollection coll = acctContrast.getAccountRefContrastCollection(evi);
        return coll;
    }

    private PeriodInfo getPeriodInfo(Context ctx, int periodYear, int periodNumber, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        PeriodInfo info = null;
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodNumber), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            info = periodc.get(0);
        }
        return info;
    }
}

