/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.BankStatementFactory;
import com.kingdee.eas.fi.cas.BankStatementInfo;
import com.kingdee.eas.fi.cas.CasDataException;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class CasBankStateCaculaterStrategy {
    private static Logger logger = Logger.getLogger((String)CasBankStateCaculaterStrategy.class.getName());
    private static Context ctx = null;
    protected int MAX_COUNT = 100;

    public static CasBankStateCaculaterStrategy getInstance(Context serverCtx) {
        ctx = serverCtx;
        return new CasBankStateCaculaterStrategy();
    }

    public void doCash(List params, ICalculateContextProvider context) {
        Object fmCompanyPeriodCol = null;
        for (int i = 0; i < params.size(); ++i) {
            Date queryDate;
            String currencyNum;
            String bankAcctNum;
            String bankNum;
            String companyNum;
            Parameter param;
            block11: {
                param = (Parameter)params.get(i);
                Object[] args = param.getArgs();
                companyNum = "";
                companyNum = args[0] == null || args[0].toString().length() == 0 ? this.getReportCompany(context, ctx) : args[0].toString();
                bankNum = args[1] == null ? "" : args[1].toString();
                String string = bankAcctNum = args[2] == null ? "" : args[2].toString();
                if (bankNum.trim().length() == 0 && bankAcctNum.trim().length() == 0) {
                    param.setValue((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"76_CashCaculaterExtStrategy", (Locale)ctx.getLocale()));
                    continue;
                }
                currencyNum = "";
                currencyNum = args[3] == null || args[3].toString().length() == 0 ? this.getReportCurrency(context, ctx) : args[3].toString();
                queryDate = null;
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                DateFormat format = FMHelper.getNationalDateFormat((Context)ctx);
                if (args[4] == null || args[4].toString().length() == 0) {
                    queryDate = this.getReportEndDate(context, ctx);
                } else {
                    try {
                        queryDate = dateFormat.parse(dateFormat.format(format.parse(args[4].toString())));
                    }
                    catch (ParseException e) {
                        if (args[4] != null && args[4].toString().length() != 0) break block11;
                        queryDate = this.getReportEndDate(context, ctx);
                    }
                }
            }
            try {
                Set companyIdSet = this.getCompanyIds(ctx, companyNum);
                if (companyIdSet == null) {
                    throw new CasDataException(CasDataException.NULL_COMPANY);
                }
                Set bankAcctIdSet = null;
                bankAcctIdSet = !EmptyUtil.isEmpty((String)bankAcctNum) ? this.getBankAcctIds(ctx, bankAcctNum) : this.getBankAcctIdsByBank(ctx, bankNum);
                String currencyId = this.getCurrencyId(ctx, currencyNum);
                ICurrency currency = CurrencyFactory.getLocalInstance((Context)ctx);
                CurrencyInfo curInfo = null;
                if (!FMHelper.isEmpty((String)currencyId)) {
                    curInfo = currency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                }
                queryDate = DateTimeUtils.truncateDate((Date)queryDate);
                Object periodpk = null;
                ObjectUuidPK currencypk = new ObjectUuidPK(currencyId);
                BigDecimal result = this.getbalance(companyIdSet, bankAcctIdSet, (IObjectPK)currencypk, queryDate);
                if (curInfo != null && result != null) {
                    result = result.setScale(curInfo.getPrecision(), 4);
                }
                param.setValue((Object)result);
                continue;
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                param.setValue((Object)ex.getMessage());
            }
        }
    }

    private BigDecimal exeQuerySql(Context ctx, String sql) throws BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        BigDecimal result = FMConstants.ZERO;
        try {
            while (rs.next()) {
                BigDecimal value = rs.getBigDecimal("Result");
                if (value == null) continue;
                result = result.add(value);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    protected BigDecimal getbalance(Set companyIdSet, Set bankAcctIdSet, IObjectPK currencyId, Date queryDate) throws EASBizException, BOSException {
        BigDecimal result = SysConstant.BIGZERO;
        Object[] companys = companyIdSet.toArray();
        Object[] bankAccts = bankAcctIdSet.toArray();
        queryDate = DateUtil.getAfterDay((Date)queryDate);
        for (int i = 0; i < companys.length; ++i) {
            ObjectUuidPK companyId = new ObjectUuidPK((String)companys[i]);
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)companyId);
            PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)queryDate, (CompanyOrgUnitInfo)company);
            ObjectUuidPK periodid = null;
            if (period != null) {
                periodid = new ObjectUuidPK(period.getId().toString());
            }
            for (int k = 0; k < bankAccts.length; ++k) {
                ObjectUuidPK bankAcctid = new ObjectUuidPK((String)bankAccts[k]);
                ObjectUuidPK accountid = new ObjectUuidPK(this.getAccountId((IObjectPK)bankAcctid));
                BankStatementInfo info = BankStatementFactory.getLocalInstance(ctx).getDateStartData((IObjectPK)companyId, (IObjectPK)bankAcctid, currencyId, queryDate, (IObjectPK)periodid, (IObjectPK)accountid);
                BigDecimal balance = (BigDecimal)info.get("balance");
                result = result.add(balance);
            }
        }
        return result;
    }

    private String getAccountId(IObjectPK bankAcctid) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("account.id"));
        AccountBankInfo acct = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo(bankAcctid, sic);
        return acct.getAccount().getId().toString();
    }

    protected String composeParse(Set idSet) {
        if (idSet == null || idSet.size() == 0) {
            return null;
        }
        StringBuffer sIds = new StringBuffer();
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            sIds.append("'").append(it.next()).append("',");
        }
        if (sIds.length() > 0) {
            sIds = sIds.deleteCharAt(sIds.length() - 1);
        }
        return sIds.toString();
    }

    private Set getCompanyIds(Context ctx, String companyNum) throws BOSException {
        if (FMHelper.isEmpty((String)companyNum)) {
            return null;
        }
        StringBuffer sql = new StringBuffer(120);
        sql.append("select fid from t_org_company where (");
        if (companyNum.indexOf(";") > 0) {
            String[] nums = companyNum.split(";");
            for (int i = 0; i < nums.length; ++i) {
                if (i > 0) {
                    sql.append(" or ");
                }
                sql.append(" (FNumber = '").append(nums[i].trim()).append("'").append(" or FLongNumber like '").append(companyNum).append("!%' ").append(" or FLongNumber like '%!").append(companyNum).append("!%') ");
            }
        } else {
            sql.append(" FNumber = '").append(companyNum.trim()).append("'").append(" or FLongNumber like '").append(companyNum).append("!%' ").append(" or FLongNumber like '%!").append(companyNum).append("!%'");
        }
        sql.append(" ) and FIsOnlyUnion =0 ");
        sql.append(" order by FLongNumber asc");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            HashSet<String> idSet = new HashSet<String>();
            while (rs.next()) {
                idSet.add(rs.getString("fid"));
            }
            if (idSet.size() > 0) {
                return idSet;
            }
            return null;
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    private Set getBankAcctIds(Context ctx, String bankAcctNum) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)bankAcctNum)) {
            return null;
        }
        StringBuffer sql = new StringBuffer(100);
        sql.append("select Fid from t_bd_accountbanks where 1=1");
        if (!StringUtils.isEmpty((String)bankAcctNum)) {
            if (bankAcctNum.indexOf(";") > 0) {
                sql.append(" and FNumber in (");
                String[] nums = bankAcctNum.split(";");
                for (int i = 0; i < nums.length; ++i) {
                    if (i > 0) {
                        sql.append(",");
                    }
                    sql.append(" '").append(nums[i].trim()).append("'");
                }
                sql.append(")");
            } else {
                sql.append(" and FNumber = '").append(bankAcctNum.trim()).append("'");
            }
        }
        HashSet<String> bankAcctIdSet = new HashSet<String>();
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                if (rs.getString("FID") == null) continue;
                bankAcctIdSet.add(rs.getString("FID"));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        if (bankAcctIdSet.size() > 0) {
            return bankAcctIdSet;
        }
        throw new CasDataException(CasDataException.NULL_ACCOUNTBANK);
    }

    private Set getBankAcctIdsByBank(Context ctx, String bankNum) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)bankNum)) {
            return null;
        }
        StringBuffer sql = new StringBuffer(100);
        sql.append("select Fid from t_bd_bank where 1=1");
        if (!StringUtils.isEmpty((String)bankNum)) {
            if (bankNum.indexOf(";") > 0) {
                sql.append(" and FNumber in (");
                String[] nums = bankNum.split(";");
                for (int i = 0; i < nums.length; ++i) {
                    if (i > 0) {
                        sql.append(",");
                    }
                    sql.append(" '").append(nums[i].trim()).append("'");
                }
                sql.append(")");
            } else {
                sql.append(" and FNumber = '").append(bankNum.trim()).append("'");
            }
        }
        HashSet<String> bankIdSet = new HashSet<String>();
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                if (rs.getString("FID") == null) continue;
                bankIdSet.add(rs.getString("FID"));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        if (bankIdSet.size() > 0) {
            HashSet<String> bankAcctIdSet = new HashSet<String>();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("bank.id", bankIdSet, CompareType.INCLUDE));
            AccountBankCollection colls = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
            for (int index = 0; index < colls.size(); ++index) {
                AccountBankInfo info = colls.get(index);
                bankAcctIdSet.add(info.getId().toString());
            }
            if (bankAcctIdSet.size() > 0) {
                return bankAcctIdSet;
            }
        }
        throw new CasDataException(CasDataException.NULL_ACCOUNTBANK);
    }

    private String getCurrencyId(Context ctx, String currencyNum) throws BOSException, CasDataException {
        if (FMHelper.isEmpty((String)currencyNum)) {
            return null;
        }
        StringBuffer sql = new StringBuffer(100);
        sql.append("select fid from t_bd_currency where FNumber = ?");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{currencyNum});
            if (rs.next()) {
                return rs.getString(1);
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        throw new CasDataException(CasDataException.NULL_CURRENCY);
    }

    private Date getReportEndDate(ICalculateContextProvider context, Context ctx) {
        return (Date)context.getReportAdapter().getReportProperty("Report_EndDate");
    }

    private String getReportCompany(ICalculateContextProvider context, Context ctx) {
        BatchHelper batchHelper = new BatchHelper(context, ctx);
        return batchHelper.getCompany_Number();
    }

    private String getReportCurrency(ICalculateContextProvider context, Context ctx) {
        return (String)context.getReportAdapter().getReportProperty("Currency.Number");
    }
}

