/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AssItemsForCashPayCollection;
import com.kingdee.eas.fi.cas.AssItemsForCashPayInfo;
import com.kingdee.eas.fi.cas.BizTypeEnum;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.ICASDataImportVerify;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fpl.FPItemDirectionEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class CasPaymentBillImportVerify
implements ICASDataImportVerify {
    private static Logger logger = Logger.getLogger((String)CasPaymentBillImportVerify.class.getName());

    @Override
    public void verifyHead(Context ctx, CoreBaseInfo head) throws BOSException {
        Set idSet;
        if (!(head instanceof PaymentBillInfo)) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"25_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        }
        PaymentBillInfo info = (PaymentBillInfo)head;
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        CtrlUnitInfo cuInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCtrlUnit();
        boolean hasPermission = false;
        try {
            hasPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyInfo.getId()), "cas_paymentbill_02addNew");
        }
        catch (EASBizException e1) {
            throw new BOSException((Throwable)e1);
        }
        if (!hasPermission) {
            String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"109_CasPaymentBillImportVerify", (Locale)ctx.getLocale()) + companyInfo.getName(ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"110_CasPaymentBillImportVerify", (Locale)ctx.getLocale());
            throw new BOSException(msg);
        }
        if (info.getSourceType() == null) {
            info.setSourceType(SourceTypeEnum.AP);
        }
        SourceTypeEnum sourceType = SourceTypeEnum.CASH;
        this.checkEmpty(ctx, info.getBizDate(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"26_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        SystemEnum systemEnum = null;
        PeriodInfo currentPeriod = null;
        if (sourceType.equals((Object)SourceTypeEnum.AP)) {
            systemEnum = SystemEnum.ACCOUNTSPAYABLE;
            try {
                currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)systemEnum, (CompanyOrgUnitInfo)companyInfo);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"89_CasPaymentBillImportVerify", (Locale)ctx.getLocale()) + e.getMessage());
            }
            catch (BOSException e) {
                logger.error((Object)e);
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"89_CasPaymentBillImportVerify", (Locale)ctx.getLocale()) + e.getMessage());
            }
            if (info.getBizDate().compareTo(currentPeriod.getBeginDate()) < 0) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"90_CasPaymentBillImportVerify", (Locale)ctx.getLocale()));
            }
        }
        if (info.getActPayAmt().compareTo(BigDecimal.ZERO) == 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"521_CASPaymentBillImportVerify", (Locale)ctx.getLocale()));
        }
        this.checkEmpty(ctx, info.getCurrency(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"27_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        CurrencyInfo currency = info.getCurrency();
        this.checkEmpty(ctx, info.getExchangeRate(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"28_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        if (info.getExchangeRate().compareTo(FMConstants.ZERO) < 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"29_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        }
        CurrencyInfo localCurrency = companyInfo.getBaseCurrency();
        if (currency.getId().equals((Object)localCurrency.getId()) && info.getExchangeRate().compareTo(FMConstants.ONE) != 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"30_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        }
        if (info.getPayerAccountBank() != null) {
            boolean sameAccountAllowable = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS073", (IObjectPK)new ObjectUuidPK(companyInfo.getId()));
            if (!sameAccountAllowable) {
                AccountBankInfo payerAcctBankInfo = this.getAccountBankById(ctx, info.getPayerAccountBank().getId().toString());
                AccountBankInfo payeeAcctBankInfo = this.getAccountBankByAccountNumber(ctx, info.getPayeeAccountBank());
                if (payerAcctBankInfo != null && payerAcctBankInfo.getBankAccountNumber().equals(info.getPayeeAccountBank()) && payeeAcctBankInfo != null && payerAcctBankInfo.getCompany().getId().toString().equals(info.getPayeeAccountBankO().getCompany().getId().toString())) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"CantBeSameAccount", (Locale)ctx.getLocale()));
                }
            }
            if (info.getPayerAccountBank().isIsClosed()) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"93_CasPaymentBillImportVerify", (Locale)ctx.getLocale()));
            }
        }
        if (BizTypeEnum.BANK.equals((Object)info.getFundType())) {
            EntityViewInfo evi = RecPayHelper.getBankAccountEvi(cuInfo.getId().toString());
            try {
                idSet = FMHelper.getAcctViewIdSet((Context)ctx, (String)companyInfo.getId().toString(), (String)currency.getId().toString(), (EntityViewInfo)evi);
                if (idSet != null && info.getPayerAccount() != null && !idSet.contains(info.getPayerAccount().getId().toString())) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"94_CasPaymentBillImportVerify", (Locale)ctx.getLocale()));
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"95_CasPaymentBillImportVerify", (Locale)ctx.getLocale()) + e.getMessage());
            }
            catch (BOSException e) {
                logger.error((Object)e);
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"95_CasPaymentBillImportVerify", (Locale)ctx.getLocale()) + e.getMessage());
            }
            if (info.getPayerAccountBank() != null && info.getPayerAccountBank().getAccount() != null && !info.getPayerAccount().getId().equals((Object)info.getPayerAccountBank().getAccount().getId())) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"96_CasPaymentBillImportVerify", (Locale)ctx.getLocale()));
            }
        } else if (BizTypeEnum.CASH.equals((Object)info.getFundType())) {
            EntityViewInfo evi = RecPayHelper.getCashAccountEvi(cuInfo.getId().toString());
            try {
                idSet = FMHelper.getAcctViewIdSet((Context)ctx, (String)companyInfo.getId().toString(), (String)currency.getId().toString(), (EntityViewInfo)evi);
                if (idSet != null && info.getPayerAccount() != null && !idSet.contains(info.getPayerAccount().getId().toString())) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"97_CasPaymentBillImportVerify", (Locale)ctx.getLocale()));
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"95_CasPaymentBillImportVerify", (Locale)ctx.getLocale()) + e.getMessage());
            }
            catch (BOSException e) {
                logger.error((Object)e);
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"95_CasPaymentBillImportVerify", (Locale)ctx.getLocale()) + e.getMessage());
            }
        }
        if (info.getFpItem() != null && FPItemDirectionEnum.INWARD_MOVEMENT.equals((Object)info.getFpItem().getDirection())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"98_CasPaymentBillImportVerify", (Locale)ctx.getLocale()));
        }
    }

    private void checkEmpty(Context ctx, Object obj, String msg) throws BOSException {
        if (obj == null) {
            throw new BOSException(msg + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"31_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        }
    }

    private AccountBankInfo getAccountBankByAccountNumber(Context ctx, String acctNumber) {
        if (EmptyUtil.isEmpty((String)acctNumber)) {
            return null;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)acctNumber.trim()));
        try {
            AccountBankCollection banks = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(ev);
            if (banks != null && banks.size() > 0) {
                return banks.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return null;
    }

    private AccountBankInfo getAccountBankById(Context ctx, String id) {
        if (EmptyUtil.isEmpty((String)id)) {
            return null;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        try {
            AccountBankCollection banks = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(ev);
            if (banks != null && banks.size() > 0) {
                return banks.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return null;
    }

    @Override
    public void verifyEntry(Context ctx, CoreBaseInfo entry, SourceTypeEnum type, VoucherInfo.DynamicColumnInfo[] dyColumnInfos) throws BOSException {
        if (!(entry instanceof PaymentBillEntryInfo)) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"99_CasPaymentBillImportVerify", (Locale)ctx.getLocale()));
        }
        PaymentBillEntryInfo info = (PaymentBillEntryInfo)entry;
        if (type.equals((Object)SourceTypeEnum.CASH)) {
            info.setAmount(null);
            info.setLocalAmt(null);
            info.setRebate(null);
            info.setRebateLocAmt(null);
            if (info.getFpItem() != null && FPItemDirectionEnum.INWARD_MOVEMENT.equals((Object)info.getFpItem().getDirection())) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"98_CasPaymentBillImportVerify", (Locale)ctx.getLocale()));
            }
            if (info.getFundFlowItem() != null && info.getFundFlowItem().getState().getValue() == 1) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"493_CasImportFundItemVerify", (Locale)ctx.getLocale()));
            }
            if (info.getActualAmt() == null || info.getActualAmt().compareTo(BigDecimal.ZERO) == 0) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"523_CASPaymentBillImportVerify", (Locale)ctx.getLocale()));
            }
        } else if (type.equals((Object)SourceTypeEnum.AP) || type.equals((Object)SourceTypeEnum.AR)) {
            if (info.getAmount() == null) {
                info.setAmount(CasConstants.ZERO);
            }
            if (info.getRebate() == null) {
                info.setRebate(CasConstants.ZERO);
            }
            if (info.getActualAmt() == null) {
                info.setActualAmt(CasConstants.ZERO);
            }
            BigDecimal temp1 = info.getAmount().subtract(info.getRebate());
            if (info.getActualAmt().compareTo(temp1) != 0) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"100_CasPaymentBillImportVerify", (Locale)ctx.getLocale()));
            }
            if (info.getActualAmt().compareTo(CasConstants.ZERO) != 1) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"101_CasPaymentBillImportVerify", (Locale)ctx.getLocale()));
            }
            if (info.getLocalAmt() == null) {
                info.setLocalAmt(CasConstants.ZERO);
            }
            if (info.getRebateLocAmt() == null) {
                info.setRebateLocAmt(CasConstants.ZERO);
            }
            if (info.getActualLocAmt() == null) {
                info.setActualLocAmt(CasConstants.ZERO);
            }
            temp1 = info.getLocalAmt().subtract(info.getRebateLocAmt());
            if (info.getActualLocAmt().compareTo(temp1) != 0) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"102_CasPaymentBillImportVerify", (Locale)ctx.getLocale()));
            }
            if (info.getActualLocAmt().compareTo(CasConstants.ZERO) != 1) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"103_CasPaymentBillImportVerify", (Locale)ctx.getLocale()));
            }
        }
        AssItemsForCashPayCollection assCol = info.getAssItemsEntries();
        Iterator it = assCol.iterator();
        while (it.hasNext()) {
            AssItemsForCashPayInfo afcp = (AssItemsForCashPayInfo)it.next();
            AsstActTypeInfo acTypeInfo = afcp.getAsstActType();
            boolean flag = false;
            for (int i = 0; i < dyColumnInfos.length; ++i) {
                if (!dyColumnInfos[i].getId().equals((Object)acTypeInfo.getId())) continue;
                flag = true;
            }
            if (flag) continue;
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"104_CasPaymentBillImportVerify", (Locale)ctx.getLocale()) + acTypeInfo.getName() + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"105_CasPaymentBillImportVerify", (Locale)ctx.getLocale()));
        }
    }
}

