/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.IPaymentBillType;
import com.kingdee.eas.fi.cas.PaymentBillTypeCollection;
import com.kingdee.eas.fi.cas.PaymentBillTypeFactory;
import com.kingdee.eas.fi.cas.PaymentBillTypeInfo;
import com.kingdee.eas.fi.cas.ReceivingBillTypeCollection;
import com.kingdee.eas.fi.cas.ReceivingBillTypeFactory;
import com.kingdee.eas.fi.cas.ReceivingBillTypeInfo;
import com.kingdee.eas.fi.cas.app.ICasFetchParam;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CasRecPayFetchParamHelperBase
implements ICasFetchParam {
    protected CompanyOrgUnitInfo currentCompany;
    protected Context ctx;

    public boolean hasCodingRule(CoreBaseInfo info, String companyId) throws BOSException, EASBizException {
        if (info == null || companyId == null || companyId.equals("")) {
            return false;
        }
        boolean result = false;
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)this.ctx);
        result = codingRuleManager.isExist((IObjectValue)info, companyId);
        return result;
    }

    public boolean isAddView(CoreBaseInfo info, String companyId) throws BOSException, EASBizException {
        if (info == null || companyId == null || companyId.equals("")) {
            return false;
        }
        boolean result = false;
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)this.ctx);
        result = codingRuleManager.isAddView((IObjectValue)info, companyId);
        return result;
    }

    public boolean isModifiable(CoreBaseInfo info, String companyId) throws BOSException, EASBizException {
        if (info == null || companyId == null || companyId.equals("")) {
            return false;
        }
        boolean result = false;
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)this.ctx);
        result = codingRuleManager.isModifiable((IObjectValue)info, companyId);
        return result;
    }

    protected HashMap getParam(IObjectPK comPK, HashMap paramMap2) throws BOSException, EASBizException {
        Iterator it = paramMap2.keySet().iterator();
        while (it.hasNext()) {
            paramMap2.put(it.next(), comPK);
        }
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)this.ctx);
        paramMap2 = pc.getParamHashMap(paramMap2);
        for (String key : paramMap2.keySet()) {
            Object value = paramMap2.get(key);
            if (value == null || !value.equals("true") && !value.equals("false")) continue;
            paramMap2.put(key, Boolean.valueOf(value.toString()));
        }
        return paramMap2;
    }

    protected Object getCurrencyCollection() throws BOSException, EASBizException {
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)this.ctx);
        return iCurrency.getCurrencyCollection(true);
    }

    protected PeriodInfo getCurrentPeriond(CompanyOrgUnitInfo currentCompany) throws EASBizException, BOSException {
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)currentCompany);
        return periodInfo;
    }

    protected Boolean getSysParam(String paramName) {
        if (this.currentCompany == null) {
            this.currentCompany = ContextHelperFactory.getLocalInstance((Context)this.ctx).getCurrentCompany();
        }
        boolean val = ContextHelperFactory.getLocalInstance((Context)this.ctx).getBooleanParam(paramName, (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()));
        return new Boolean(val);
    }

    @Override
    public Map fetchParam(Context ctx, Map paramNameMap) throws BOSException, EASBizException {
        this.ctx = ctx;
        this.currentCompany = (CompanyOrgUnitInfo)paramNameMap.get("currentCompany");
        if (this.currentCompany == null) {
            this.currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)this.currentCompany.getAccountTable())) {
            AccountTableInfo accountTable = AccountTableFactory.getLocalInstance((Context)ctx).getAccountTableInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getAccountTable().getId()));
            paramNameMap.put("accountTable", accountTable);
        }
        ObjectUuidPK comPK = new ObjectUuidPK(BOSUuid.read((String)this.currentCompany.getId().toString()));
        HashMap paramMap2 = (HashMap)paramNameMap.get("param");
        if (paramMap2 != null) {
            paramMap2 = this.getParam((IObjectPK)comPK, paramMap2);
            paramNameMap.putAll(paramMap2);
        }
        if (paramNameMap.get("MBG_C001") == null) {
            Boolean MBG_C001 = FmMbgHelper.isMBG_C001((Context)ctx, (String)this.currentCompany.getId().toString());
            paramNameMap.put("MBG_C001", MBG_C001);
        }
        return paramNameMap;
    }

    protected AsstActTypeInfo getDefaultAsstActType(String cuId, boolean isPay, boolean isRec) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("select FAsstActTypeID, FLastUpdateUserId from T_BD_AsstActTypeDefault where FIsAccountCussent=1 ");
        sb.append(" and Fcompanyid='" + cuId + "'");
        if (isRec) {
            sb.append(" and FISDEFAULTACCOUNTRECEIVABLE = 1");
        }
        if (isPay) {
            sb.append(" and FISDEFAULTACCOUNTPAYABLE = 1");
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
        String id = null;
        try {
            if (rs.next()) {
                do {
                    id = rs.getString("FAsstActTypeID");
                } while (rs.getString("FLastUpdateUserId") == null && rs.next());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (id != null) {
            return AsstActTypeFactory.getLocalInstance((Context)this.ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(id));
        }
        return null;
    }

    public AsstActTypeCollection getAsstActTypeColl(Set companySet, boolean isPay, boolean isRec) throws BOSException {
        FilterInfo filter = this.getAsstActTypeFilter(companySet, isPay, isRec);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("realtionDataObject"));
        IAsstActType asstActType = AsstActTypeFactory.getLocalInstance((Context)this.ctx);
        AsstActTypeCollection asstActTypeCollection = asstActType.getAsstActTypeCollection(evi);
        return asstActTypeCollection;
    }

    public AsstActTypeCollection getAsstActTypeColl(String cuId, boolean isPay, boolean isRec) throws BOSException, EASBizException {
        FilterInfo filter = this.getAsstActTypeFilter(cuId, isPay, isRec);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("realtionDataObject"));
        IAsstActType asstActType = AsstActTypeFactory.getLocalInstance((Context)this.ctx);
        AsstActTypeCollection asstActTypeCollection = asstActType.getAsstActTypeCollection(evi);
        return asstActTypeCollection;
    }

    private FilterInfo getAsstActTypeFilter(Set companySet, boolean isPay, boolean isRec) throws BOSException {
        if (EmptyUtil.isEmpty((Collection)companySet)) {
            companySet = new HashSet<String>();
            companySet.add(ContextHelperFactory.getLocalInstance((Context)this.ctx).getCurrentCtrlUnit().getId().toString());
        }
        AsstActTypeCollection asstActTypeCollection = AsstActTypeFactory.getLocalInstance((Context)this.ctx).getAsstActTypeCollection();
        FilterInfo filter = new FilterInfo();
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < asstActTypeCollection.size(); ++i) {
            ids.add(asstActTypeCollection.get(i).getId().toString());
        }
        StringBuffer sb = new StringBuffer();
        sb.append("select FAsstActTypeID from T_BD_AsstActTypeDefault where FIsAccountCussent=1 ");
        Object[] set = new String[companySet.size()];
        Iterator it = companySet.iterator();
        int i = 0;
        while (it.hasNext()) {
            String id = (String)it.next();
            set[i++] = id;
        }
        sb.append(" and " + FMHelper.buildIn((String)"Fcompanyid", (Object[])set));
        if (isPay) {
            sb.append(" and FISDEFAULTACCOUNTPAYABLE=1");
        }
        if (isRec) {
            sb.append(" and FISDEFAULTACCOUNTRECEIVABLE=1");
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INNER));
        return filter;
    }

    private FilterInfo getAsstActTypeFilter(String cuId, boolean isPay, boolean isRec) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)cuId)) {
            cuId = ContextHelperFactory.getLocalInstance((Context)this.ctx).getCurrentCtrlUnit().getId().toString();
        }
        AsstActTypeCollection asstActTypeCollection = AsstActTypeFactory.getLocalInstance((Context)this.ctx).getAsstActTypeCollection();
        FilterInfo filter = new FilterInfo();
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < asstActTypeCollection.size(); ++i) {
            ids.add(asstActTypeCollection.get(i).getId().toString());
        }
        StringBuffer sb = new StringBuffer();
        sb.append("select FAsstActTypeID from T_BD_AsstActTypeDefault where FIsAccountCussent=1 ");
        sb.append(" and Fcompanyid='" + cuId + "'");
        if (isPay) {
            sb.append(" and FISDEFAULTACCOUNTPAYABLE=1");
        }
        if (isRec) {
            sb.append(" and FISDEFAULTACCOUNTRECEIVABLE=1");
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INNER));
        return filter;
    }

    protected ReceivingBillTypeInfo getDefaultBillType_ReceivingBill() throws BOSException {
        ReceivingBillTypeInfo defaultBillTypeInfo = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"999", CompareType.EQUALS));
        ReceivingBillTypeCollection coll = ReceivingBillTypeFactory.getLocalInstance(this.ctx).getReceivingBillTypeCollection(ev);
        if (coll != null && !coll.isEmpty()) {
            defaultBillTypeInfo = coll.get(0);
        }
        return defaultBillTypeInfo;
    }

    protected PaymentBillTypeInfo getDefaultBillType_PaymentBill() throws BOSException {
        PaymentBillTypeInfo defaultBillTypeInfo = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"999", CompareType.EQUALS));
        IPaymentBillType iPaymentBillType = PaymentBillTypeFactory.getLocalInstance(this.ctx);
        PaymentBillTypeCollection coll = iPaymentBillType.getPaymentBillTypeCollection(ev);
        if (coll != null && !coll.isEmpty()) {
            defaultBillTypeInfo = coll.get(0);
        }
        return defaultBillTypeInfo;
    }

    protected boolean hasNumber(Context ctx, CoreBaseInfo info, String companyId) throws BOSException, EASBizException {
        if (info == null || companyId == null || companyId.equals("")) {
            return false;
        }
        boolean result = false;
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        result = codingRuleManager.isExist((IObjectValue)info, companyId);
        return result;
    }

    protected String getDispNumber(Context ctx, CoreBaseInfo info, String companyId) throws BOSException, EASBizException {
        String number = null;
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (codingRuleManager.isAddView((IObjectValue)info, companyId) && !codingRuleManager.isUseIntermitNumber((IObjectValue)info, companyId)) {
            number = codingRuleManager.getNumber((IObjectValue)info, companyId);
        }
        return number;
    }

    protected CompanyOrgUnitCollection getUserOrgRangesWithRange(Context ctx, String permissionItem) throws BOSException, EASBizException {
        CompanyOrgUnitCollection orgColl = new CompanyOrgUnitCollection();
        if (this.currentCompany.isIsBizUnit() && this.currentCompany.getAccountTable() != null && !this.currentCompany.isIsOUSealUp()) {
            orgColl.add(this.currentCompany);
            return orgColl;
        }
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        Set orgPermSet = PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrgIds((IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgType.Company, null, permissionItem);
        for (String orgUnitId : orgPermSet) {
            ObjectUuidPK pk = new ObjectUuidPK(orgUnitId);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("*");
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)pk, selector);
            if (!company.isIsBizUnit() || company.getAccountTable() == null || company.isIsOUSealUp() || company.isIsSealUp()) continue;
            orgColl.add(company);
            break;
        }
        return orgColl;
    }

    protected SelectorItemCollection getPermOrgSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("isBizUnit");
        sic.add("accountTable");
        sic.add("isOUSealUp");
        return sic;
    }
}

