/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.AutoGenRuleForPayBillCollection;
import com.kingdee.eas.fi.cas.AutoGenRuleForPayBillFactory;
import com.kingdee.eas.fi.cas.AutoGenRuleForPayBillInfo;
import com.kingdee.eas.fi.cas.AutoGenRuleForRecBillCollection;
import com.kingdee.eas.fi.cas.AutoGenRuleForRecBillFactory;
import com.kingdee.eas.fi.cas.AutoGenRuleForRecBillInfo;
import com.kingdee.eas.fi.cas.BankStatementFactory;
import com.kingdee.eas.fi.cas.CasScheduleJobEntryInfo;
import com.kingdee.eas.fi.cas.CasScheduleJobFactory;
import com.kingdee.eas.fi.cas.CasScheduleJobInfo;
import com.kingdee.eas.fi.cas.DownLoadBankParam;
import com.kingdee.eas.fi.cas.IPaymentBillWebFacade;
import com.kingdee.eas.fi.cas.IReceivingbillWebFacade;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillWebFacadeFactory;
import com.kingdee.eas.fi.cas.ReceivingBillCollection;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingbillWebFacadeFactory;
import com.kingdee.eas.fi.cas.app.AbstractCasScheduleJobFacadeControllerBean;
import com.kingdee.eas.fi.cas.model.AutoBatchExecuteResult;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fm.be.ITransDetail;
import com.kingdee.eas.fm.be.TransDetailCollection;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.be.TransDetailInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CasScheduleJobFacadeControllerBean
extends AbstractCasScheduleJobFacadeControllerBean {
    private static final long serialVersionUID = -8747454787150516216L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.CasScheduleJobFacadeControllerBean");

    @Override
    protected void _runSchedule_bankStatement(Context ctx, String number) throws BOSException, EASBizException {
        Set<String> numberSet = this.initScheduleJobNumber(ctx, number);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(1)));
        if (numberSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("number", numberSet, CompareType.INCLUDE));
        }
        CoreBaseCollection colls = CasScheduleJobFactory.getLocalInstance(ctx).getCollection(view);
        for (int index = 0; index < colls.size(); ++index) {
            CasScheduleJobInfo info = (CasScheduleJobInfo)colls.get(index);
            this.runScheduleJob(ctx, info);
        }
    }

    protected void runScheduleJob(Context ctx, CasScheduleJobInfo info) throws EASBizException, BOSException {
        int totalBillCount = 0;
        String err = "";
        HashSet<String> bankAccountIdSet = new HashSet<String>();
        java.util.Date beginDate = DateUtil.getNextDay((java.util.Date)DateUtil.getDayEnd(), (int)(-info.getInterval()));
        java.util.Date endDate = DateUtil.getDayEnd();
        boolean isconTransDownUp = true;
        HashMap<String, DownLoadBankParam> fSparamMap = new HashMap<String, DownLoadBankParam>();
        for (int index = 0; index < info.getEntrys().size(); ++index) {
            CasScheduleJobEntryInfo casScheduleJobEntryInfo = info.getEntrys().get(index);
            isconTransDownUp = casScheduleJobEntryInfo.isIsconTransDownUp();
            String bankAcctId = info.getEntrys().get(index).getAccountbank().getId().toString();
            SelectorItemCollection select = new SelectorItemCollection();
            select.add("*");
            select.add("bank.*");
            AccountBankInfo content = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(bankAcctId), select);
            if (content.getBank().isInGroup()) {
                if (content.getCompany() == null && content.getInnerAcct() == null) {
                    err = ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"113_CasScheduleJobFacadeControllerBean", (Locale)ctx.getLocale());
                    continue;
                }
                DownLoadBankParam para = new DownLoadBankParam();
                para.setCompany(content.getCompany().getId().toString());
                para.setinnerAcct(content.getInnerAcct().getId().toString());
                para.setBankAccount(bankAcctId);
                para.setBeginDate(beginDate);
                para.setEndDate(endDate);
                if (isconTransDownUp) {
                    para.setIsconTransDownUp(isconTransDownUp);
                }
                fSparamMap.put(bankAcctId, para);
                continue;
            }
            bankAccountIdSet.add(bankAcctId);
        }
        try {
            DownLoadBankParam param = new DownLoadBankParam();
            param.setBankAccountIdSet(bankAccountIdSet);
            param.setIsconTransDownUp(isconTransDownUp);
            param.setBeginDate(beginDate);
            param.setEndDate(endDate);
            totalBillCount = BankStatementFactory.getLocalInstance(ctx).downloadBankState(param);
        }
        catch (Exception e) {
            err = e.getMessage();
        }
        for (String bankAcctId : fSparamMap.keySet()) {
            try {
                DownLoadBankParam para = (DownLoadBankParam)fSparamMap.get(bankAcctId);
                int billCount = BankStatementFactory.getLocalInstance(ctx).downLoadFSData4Schedule(para);
                totalBillCount += billCount;
            }
            catch (Exception e) {
                err = err + e.getMessage();
            }
        }
        if (!EmptyUtil.isEmpty((String)info.getMessageUserId())) {
            this.sendMessage(ctx, info.getName(), info.getMessageUserId().replaceAll(",", ";"), totalBillCount, err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _runSchedule_rec(Context ctx, String number) throws BOSException, EASBizException {
        Set<String> numberSet = this.initScheduleJobNumber(ctx, number);
        AutoGenRuleForRecBillCollection recRuleColls = this.getAutoGenRuleForRecBillCollection(ctx, numberSet);
        for (int i = 0; i < recRuleColls.size(); ++i) {
            IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            AutoGenRuleForRecBillInfo rule = recRuleColls.get(i);
            logger.error((Object)("\u5f00\u59cb\u6267\u884c\u8c03\u52a8\u4efb\u52a1\uff0c\u8c03\u5ea6\u7f16\u53f7\uff1a" + rule.getRuleNumber() + "."));
            boolean requestMutex = false;
            try {
                requestMutex = iMutex.requestObjIDForUpdate(rule.getId().toString());
                if (requestMutex) {
                    logger.error((Object)("\u7533\u8bf7\u5230\u7f51\u7edc\u4e92\u65a5\u9501\uff1a" + rule.getRuleNumber() + "."));
                    this.dealReceivingBillRule(ctx, rule);
                }
            }
            finally {
                if (requestMutex) {
                    iMutex.releaseObjIDForUpdate(rule.getId().toString());
                }
            }
            logger.error((Object)("\u6267\u884c\u8c03\u52a8\u4efb\u52a1\u5b8c\u6210\uff0c\u8c03\u5ea6\u7f16\u53f7\uff1a" + rule.getRuleNumber() + "."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _runSchedule_pay(Context ctx, String number) throws BOSException, EASBizException {
        Set<String> numberSet = this.initScheduleJobNumber(ctx, number);
        AutoGenRuleForPayBillCollection recRuleColls = this.getAutoGenRuleForPayBillCollection(ctx, numberSet);
        for (int i = 0; i < recRuleColls.size(); ++i) {
            IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            AutoGenRuleForPayBillInfo rule = recRuleColls.get(i);
            logger.error((Object)("\u5f00\u59cb\u6267\u884c\u8c03\u52a8\u4efb\u52a1\uff0c\u8c03\u5ea6\u7f16\u53f7\uff1a" + rule.getRuleNumber() + "."));
            boolean requestMutex = false;
            try {
                requestMutex = iMutex.requestObjIDForUpdate(rule.getId().toString());
                if (requestMutex) {
                    logger.error((Object)("\u7533\u8bf7\u5230\u7f51\u7edc\u4e92\u65a5\u9501\uff1a" + rule.getRuleNumber() + "."));
                    this.dealPaymentBillRule(ctx, rule);
                }
            }
            finally {
                if (requestMutex) {
                    iMutex.releaseObjIDForUpdate(rule.getId().toString());
                }
            }
            logger.error((Object)("\u6267\u884c\u8c03\u52a8\u4efb\u52a1\u5b8c\u6210\uff0c\u8c03\u5ea6\u7f16\u53f7\uff1a" + rule.getRuleNumber() + "."));
        }
    }

    private Set<String> initScheduleJobNumber(Context ctx, String number) throws EASBizException {
        HashSet<String> numberSet = new HashSet<String>();
        if (!EmptyUtil.isEmpty((String)number)) {
            if (number.indexOf("-") > 0) {
                String beginNum = "";
                String endNum = "";
                String beginChar = "";
                String endChar = "";
                String[] nums = number.trim().split("-");
                if (nums.length == 2) {
                    char num_temp;
                    int index;
                    String beginNum_temp = nums[0];
                    String endNum_temp = nums[1];
                    for (index = beginNum_temp.length() - 1; index >= 0; --index) {
                        num_temp = beginNum_temp.charAt(index);
                        if (new Integer(num_temp) >= 48 && new Integer(num_temp) <= 57) {
                            beginNum = num_temp + beginNum;
                            continue;
                        }
                        beginChar = num_temp + beginChar;
                    }
                    for (index = endNum_temp.length() - 1; index >= 0; --index) {
                        num_temp = endNum_temp.charAt(index);
                        if (new Integer(num_temp) >= 48 && new Integer(num_temp) <= 57) {
                            endNum = num_temp + endNum;
                            continue;
                        }
                        endChar = num_temp + endChar;
                    }
                    if (beginNum.length() != endNum.length()) {
                        throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"117_CasScheduleJobFacadeControllerBean", (Locale)ctx.getLocale())));
                    }
                    if (!beginChar.equals(endChar)) {
                        throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"118_CasScheduleJobFacadeControllerBean", (Locale)ctx.getLocale())));
                    }
                    if (!EmptyUtil.isEmpty((String)beginNum) && !EmptyUtil.isEmpty((String)endNum)) {
                        int endNumber = new Integer(endNum);
                        for (int beginNumber = new Integer(beginNum).intValue(); beginNumber <= endNumber; ++beginNumber) {
                            String T_number = beginChar + this.fillZoreFull(String.valueOf(beginNumber), beginNum.length());
                            numberSet.add(T_number);
                        }
                    }
                }
            } else if (number.indexOf(",") > 0) {
                String[] nums = number.trim().split(",");
                for (int index = 0; index < nums.length; ++index) {
                    numberSet.add(nums[index]);
                }
            } else {
                numberSet.add(number);
            }
        }
        return numberSet;
    }

    private String fillZoreFull(String number, int size) {
        if (number.length() != size && number.length() < size) {
            number = "0" + number;
        }
        return number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dealReceivingBillRule(Context ctx, AutoGenRuleForRecBillInfo rule) throws EASBizException, BOSException {
        int failCount = 0;
        java.util.Date startDate = rule.getStartDate();
        String ruleName = rule.getRuleNumber();
        CompanyOrgUnitInfo company = rule.getCompany();
        AccountBankInfo accountBank = rule.getAccountBank();
        String receiveMessager = rule.getMsgReceiverId();
        int autoExecOper = rule.getAutoExecOper().getValue();
        TransDetailCollection transColl = this.getTransDetailCollForRecBill(ctx, company, accountBank, startDate);
        AutoBatchExecuteResult autoExeResult = new AutoBatchExecuteResult();
        autoExeResult.setTotalBillCount(transColl.size());
        logger.error((Object)("\u4ea4\u6613\u660e\u7ec6\u6570\u91cf\uff1a" + transColl.size() + "\u884c\u3002"));
        for (int index = 0; index < transColl.size(); ++index) {
            TransDetailInfo info = transColl.get(index);
            HashSet<String> ids = new HashSet<String>();
            ids.add(info.getId().toString());
            logger.error((Object)("\u4ea4\u6613\u660e\u7ec6\uff1a[" + info.getId().toString() + "] \u751f\u6210\u6536\u6b3e\u5355\u3002"));
            ReceivingBillCollection colls = null;
            IObjectPK user = ctx.getCaller();
            try {
                colls = (ReceivingBillCollection)ReceivingBillFactory.getLocalInstance(ctx).recTrans(ids);
                if (rule.getCreaterId() != null && !rule.getCreaterId().trim().equals("")) {
                    StringBuffer sb = new StringBuffer("UPDATE T_CAS_RECEIVINGBILL SET FCREATORID = '" + rule.getCreaterId() + "' where fid in (");
                    for (int i = 0; i < colls.size(); ++i) {
                        if (i < colls.size() - 1) {
                            sb.append("'" + colls.get(i).getId().toString() + "',");
                            continue;
                        }
                        sb.append("'" + colls.get(i).getId().toString() + "')");
                    }
                    DbUtil.execute((Context)ctx, (String)sb.toString());
                }
                if (colls != null && colls.size() > 0) {
                    String number = colls.getObject(0).getString("number");
                    try {
                        logger.error((Object)("\u4ea4\u6613\u660e\u7ec6\uff1a[" + info.getId().toString() + "] \u63d0\u4ea4\u6536\u6b3e\u5355\u3002"));
                        IReceivingbillWebFacade recWebFacade = ReceivingbillWebFacadeFactory.getLocalInstance(ctx);
                        if (autoExecOper < 1) continue;
                        String[] recBillIds = new String[]{colls.getObject(0).getString("id")};
                        logger.error((Object)"\u5f00\u59cb\u63d0\u4ea4\u6536\u6b3e\u5355\u3002");
                        ctx.setCaller((IObjectPK)new ObjectUuidPK(rule.getCreaterId()));
                        ctx.put((Object)"UserInfo", (Object)UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller()));
                        BatchExecuteResult result = (BatchExecuteResult)recWebFacade.batchSubmit(recBillIds);
                        if (result.getDetailMsgList().size() > 0) {
                            autoExeResult.getDetailMsgList().addAll(result.getDetailMsgList());
                            continue;
                        }
                        logger.error((Object)"\u5f00\u59cb\u5ba1\u6279\u6536\u6b3e\u5355\u3002");
                        ctx.setCaller((IObjectPK)new ObjectUuidPK(rule.getAuditorId()));
                        ctx.put((Object)"UserInfo", (Object)UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller()));
                        result = (BatchExecuteResult)recWebFacade.batchAudit(recBillIds);
                        if (result.getDetailMsgList().size() > 0) {
                            autoExeResult.getDetailMsgList().addAll(result.getDetailMsgList());
                            continue;
                        }
                        if (autoExecOper != 2) continue;
                        logger.error((Object)"\u5f00\u59cb\u6536\u6b3e\u5355\u6536\u6b3e\u3002");
                        ctx.setCaller((IObjectPK)new ObjectUuidPK(rule.getCasherId()));
                        ctx.put((Object)"UserInfo", (Object)UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller()));
                        result = (BatchExecuteResult)recWebFacade.batchRec(recBillIds);
                        if (result.getDetailMsgList().size() <= 0) continue;
                        autoExeResult.getDetailMsgList().addAll(result.getDetailMsgList());
                        continue;
                    }
                    catch (Exception e) {
                        autoExeResult.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"127_CasScheduleJobFacadeControllerBean", (Locale)ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"128_CasScheduleJobFacadeControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
                        continue;
                    }
                    finally {
                        ctx.setCaller(user);
                    }
                }
                ++failCount;
                autoExeResult.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"129_CasScheduleJobFacadeControllerBean", (Locale)ctx.getLocale()) + info.getId().toString() + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"130_CasScheduleJobFacadeControllerBean", (Locale)ctx.getLocale()));
                continue;
            }
            catch (Exception e) {
                ++failCount;
                autoExeResult.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"129_CasScheduleJobFacadeControllerBean", (Locale)ctx.getLocale()) + info.getId().toString() + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"131_CasScheduleJobFacadeControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
            }
        }
        autoExeResult.setSuccess(autoExeResult.getTotalBillCount() - failCount);
        if (receiveMessager != null) {
            this.sendMessage(ctx, ruleName, company, accountBank, receiveMessager, autoExeResult, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dealPaymentBillRule(Context ctx, AutoGenRuleForPayBillInfo rule) throws EASBizException, BOSException {
        int failCount = 0;
        java.util.Date startDate = rule.getStartDate();
        String ruleName = rule.getRuleNumber();
        CompanyOrgUnitInfo company = rule.getCompany();
        String receiveMessager = rule.getMsgReceiverId();
        AccountBankInfo accountBank = rule.getAccountBank();
        int autoExecOper = rule.getAutoExecOper().getValue();
        TransDetailCollection transColl = this.getTransDetailCollForPayBill(ctx, company, accountBank, startDate);
        logger.error((Object)("\u4ea4\u6613\u660e\u7ec6\u6570\u91cf\uff1a" + transColl.size() + "\u884c\u3002"));
        AutoBatchExecuteResult autoExeResult = new AutoBatchExecuteResult();
        autoExeResult.setTotalBillCount(transColl.size());
        for (int index = 0; index < transColl.size(); ++index) {
            TransDetailInfo info = transColl.get(index);
            HashSet<String> ids = new HashSet<String>();
            ids.add(info.getId().toString());
            logger.error((Object)("\u4ea4\u6613\u660e\u7ec6\uff1a[" + info.getId().toString() + "] \u751f\u6210\u4ed8\u6b3e\u5355\u3002"));
            PaymentBillCollection colls = null;
            IObjectPK user = ctx.getCaller();
            try {
                colls = (PaymentBillCollection)PaymentBillFactory.getLocalInstance(ctx).recTrans(ids);
                if (rule.getCreaterId() != null && !rule.getCreaterId().trim().equals("")) {
                    StringBuffer sb = new StringBuffer("UPDATE T_CAS_PAYMENTBILL SET FCREATORID = '" + rule.getCreaterId() + "' where fid in (");
                    for (int i = 0; i < colls.size(); ++i) {
                        if (i < colls.size() - 1) {
                            sb.append("'" + colls.get(i).getId().toString() + "',");
                            continue;
                        }
                        sb.append("'" + colls.get(i).getId().toString() + "')");
                    }
                    DbUtil.execute((Context)ctx, (String)sb.toString());
                }
                if (colls != null && colls.size() > 0) {
                    String number = colls.getObject(0).getString("number");
                    try {
                        logger.error((Object)("\u4ea4\u6613\u660e\u7ec6\uff1a[" + info.getId().toString() + "] \u63d0\u4ea4\u4ed8\u6b3e\u5355\u3002"));
                        IPaymentBillWebFacade payWebFacade = PaymentBillWebFacadeFactory.getLocalInstance(ctx);
                        if (autoExecOper < 1) continue;
                        String[] payBillIds = new String[]{colls.getObject(0).getString("id")};
                        logger.error((Object)"\u5f00\u59cb\u63d0\u4ea4\u4ed8\u6b3e\u5355\u3002");
                        ctx.setCaller((IObjectPK)new ObjectUuidPK(rule.getCreaterId()));
                        ctx.put((Object)"UserInfo", (Object)UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller()));
                        BatchExecuteResult result = (BatchExecuteResult)payWebFacade.batchSubmit(payBillIds, null);
                        if (result.getDetailMsgList().size() > 0) {
                            autoExeResult.getDetailMsgList().addAll(result.getDetailMsgList());
                            continue;
                        }
                        logger.error((Object)"\u5f00\u59cb\u5ba1\u6279\u4ed8\u6b3e\u5355\u3002");
                        ctx.setCaller((IObjectPK)new ObjectUuidPK(rule.getAuditorId()));
                        ctx.put((Object)"UserInfo", (Object)UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller()));
                        result = (BatchExecuteResult)payWebFacade.batchAudit(payBillIds, null);
                        if (result.getDetailMsgList().size() > 0) {
                            autoExeResult.getDetailMsgList().addAll(result.getDetailMsgList());
                            continue;
                        }
                        if (autoExecOper != 3) continue;
                        logger.error((Object)"\u5f00\u59cb\u4ed8\u6b3e\u5355\u4ed8\u6b3e\u3002");
                        ctx.setCaller((IObjectPK)new ObjectUuidPK(rule.getCasherId()));
                        ctx.put((Object)"UserInfo", (Object)UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller()));
                        result = (BatchExecuteResult)payWebFacade.batchPay(payBillIds, null);
                        if (result.getDetailMsgList().size() <= 0) continue;
                        autoExeResult.getDetailMsgList().addAll(result.getDetailMsgList());
                        continue;
                    }
                    catch (Exception e) {
                        autoExeResult.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"137_CasScheduleJobFacadeControllerBean", (Locale)ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"128_CasScheduleJobFacadeControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
                        continue;
                    }
                    finally {
                        ctx.setCaller(user);
                    }
                }
                ++failCount;
                autoExeResult.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"129_CasScheduleJobFacadeControllerBean", (Locale)ctx.getLocale()) + info.getId().toString() + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"138_CasScheduleJobFacadeControllerBean", (Locale)ctx.getLocale()));
                continue;
            }
            catch (Exception e) {
                ++failCount;
                autoExeResult.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"129_CasScheduleJobFacadeControllerBean", (Locale)ctx.getLocale()) + info.getId().toString() + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"139_CasScheduleJobFacadeControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
            }
        }
        autoExeResult.setSuccess(autoExeResult.getTotalBillCount() - failCount);
        if (receiveMessager != null) {
            this.sendMessage(ctx, ruleName, company, accountBank, receiveMessager, autoExeResult, 1);
        }
    }

    private AutoGenRuleForRecBillCollection getAutoGenRuleForRecBillCollection(Context ctx, Set<String> numberSet) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        if (numberSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("rulenumber", numberSet, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("isStart", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("startDate", (Object)DateUtil.getDayBegin(), CompareType.LESS_EQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("accountBank.id"));
        sic.add(new SelectorItemInfo("accountBank.name"));
        sic.add(new SelectorItemInfo("accountBank.number"));
        ev.setSelector(sic);
        return AutoGenRuleForRecBillFactory.getLocalInstance(ctx).getAutoGenRuleForRecBillCollection(ev);
    }

    private AutoGenRuleForPayBillCollection getAutoGenRuleForPayBillCollection(Context ctx, Set<String> numberSet) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        if (numberSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("rulenumber", numberSet, CompareType.INCLUDE));
        }
        Date now = new Date(new java.util.Date().getTime());
        filter.getFilterItems().add(new FilterItemInfo("isStart", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("startDate", (Object)DateUtil.getDayBegin(), CompareType.LESS_EQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("accountBank.id"));
        sic.add(new SelectorItemInfo("accountBank.name"));
        sic.add(new SelectorItemInfo("accountBank.number"));
        ev.setSelector(sic);
        logger.error((Object)("SQL:" + ev.toString()));
        return AutoGenRuleForPayBillFactory.getLocalInstance(ctx).getAutoGenRuleForPayBillCollection(ev);
    }

    protected TransDetailCollection getTransDetailCollForRecBill(Context ctx, CompanyOrgUnitInfo company, AccountBankInfo accountBank, java.util.Date beginDate) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)accountBank.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isDebit", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("bizTime", (Object)beginDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("creditAmount", (Object)new Double(0.0), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isReced", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isTransUp", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isKDRetFlag", (Object)new Integer(0), CompareType.EQUALS));
        Set<String> acctSet = null;
        String strValue = ContextHelperFactory.getLocalInstance((Context)ctx).getStringParam("TM113", (IObjectPK)new ObjectUuidPK(company.getId().toString()));
        if (strValue == null || "0".equals(strValue)) {
            acctSet = this.getBankAccount(ctx, company.getId().toString());
        }
        if (acctSet != null) {
            filter.getFilterItems().add(new FilterItemInfo("oppBankNumber", acctSet, CompareType.INCLUDE));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        ITransDetail iTrans = TransDetailFactory.getLocalInstance((Context)ctx);
        logger.error((Object)("SQL:" + evi.toString()));
        TransDetailCollection transColl = iTrans.getTransDetailCollection(evi);
        return transColl;
    }

    protected TransDetailCollection getTransDetailCollForPayBill(Context ctx, CompanyOrgUnitInfo company, AccountBankInfo accountBank, java.util.Date beginDate) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)accountBank.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isDebit", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizTime", (Object)beginDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("debitAmount", (Object)new Double(0.0), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isReced", (Object)new Integer(0), CompareType.EQUALS));
        FilterInfo kdFilter = new FilterInfo();
        kdFilter.getFilterItems().add(new FilterItemInfo("isTransUp", (Object)new Integer(1), CompareType.EQUALS));
        kdFilter.getFilterItems().add(new FilterItemInfo("isBankWithHolding", (Object)new Integer(1), CompareType.EQUALS));
        kdFilter.setMaskString("#0 OR #1");
        filter.mergeFilter(kdFilter, "AND");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        ITransDetail iTrans = TransDetailFactory.getLocalInstance((Context)ctx);
        logger.error((Object)("SQL:" + evi.toString()));
        TransDetailCollection transColl = iTrans.getTransDetailCollection(evi);
        return transColl;
    }

    private Set<String> getBankAccount(Context ctx, String companyId) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("select FRelatedCompanyId from T_BD_Bank where FRelatedCompanyId = '");
        sb.append(companyId).append("'");
        String relatedCompanyId = null;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rs.next()) {
                relatedCompanyId = rs.getString("FRelatedCompanyId");
            }
            HashSet<String> acctNotIncluSet = new HashSet<String>();
            if (relatedCompanyId != null) {
                sb = new StringBuffer();
                sb.append("select FBankAccountNumber from t_bd_accountBanks where FCompanyID = '");
                sb.append(relatedCompanyId);
                sb.append("'");
                rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                while (rs.next()) {
                    acctNotIncluSet.add(rs.getString("FBankAccountNumber"));
                }
            }
            if (acctNotIncluSet.size() > 0) {
                return acctNotIncluSet;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return null;
    }

    private void sendMessage(Context ctx, String ruleName, String receiveMessager, int totalBillCount, String err) throws EASBizException, BOSException {
        String msgTitle = ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"475_CasScheduleJob", (Locale)ctx.getLocale());
        String msgBody = ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"474_CasScheduleJob", (Locale)ctx.getLocale());
        if (!EmptyUtil.isEmpty((String)err)) {
            msgTitle = ruleName + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"140_CasScheduleJobFacadeControllerBean", (Locale)ctx.getLocale());
            msgBody = ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"141_CasScheduleJobFacadeControllerBean", (Locale)ctx.getLocale()) + err;
        } else {
            msgTitle = MessageFormat.format(msgTitle, ruleName);
            msgBody = MessageFormat.format(msgBody, ruleName, String.valueOf(totalBillCount));
        }
        this.sendByMessage(ctx, msgTitle, "administrator", msgBody, receiveMessager);
    }

    private void sendMessage(Context ctx, String ruleName, CompanyOrgUnitInfo companyInfo, AccountBankInfo accBankInfo, String receiveMessager, Map result, int type) throws EASBizException, BOSException {
        AutoBatchExecuteResult res = (AutoBatchExecuteResult)result;
        String companyName = companyInfo.getName();
        if (companyName == null) {
            companyName = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId().toString())).getName();
        }
        String accBankName = "";
        if (accBankInfo != null && (accBankName = accBankInfo.getName()) == null) {
            accBankName = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(accBankInfo.getId().toString())).getName();
        }
        String bizDate = DateUtil.getSQLBegin((java.util.Date)new java.util.Date()).toString();
        String year = bizDate.substring(0, 4);
        String month = bizDate.substring(5, 7);
        String day = bizDate.substring(8, 10);
        String hour = String.valueOf(Calendar.getInstance().get(11));
        String languageKey = "";
        switch (type) {
            case 0: {
                languageKey = "199_generaRecBillMess";
                break;
            }
            case 1: {
                languageKey = "201_generaPayBillMess";
                break;
            }
            case 2: {
                languageKey = "200_generaRecSettleBillMess";
                break;
            }
            case 3: {
                languageKey = "202_generaPaySettleBillMess";
                break;
            }
            case 4: {
                languageKey = "203_generaTransUpBillMess";
                break;
            }
            case 5: {
                languageKey = "204_generaTransDownBillMess";
            }
        }
        String msgTitle = CasScheduleJobFacadeControllerBean.getResourceString(ctx, languageKey, new String[]{year, month, day, hour, companyName, accBankName, ruleName});
        StringBuffer msgBody = new StringBuffer();
        msgBody.append(CasScheduleJobFacadeControllerBean.getResourceString(ctx, "205_autoGenaraDetailMess", new String[]{res.getSuccess().toString(), new Integer(res.getTotalBillCount() - res.getSuccess()).toString()}));
        if (res.getDetailMsgList().size() > 0) {
            msgBody.append("\n----------------------------------------detail------------------------------------------------\n");
            Iterator<String> it = res.getDetailMsgList().iterator();
            while (it.hasNext()) {
                msgBody.append(it.next() + "\n");
            }
        }
        this.sendByMessage(ctx, msgTitle, "administrator", msgBody.toString(), receiveMessager);
    }

    private static String getResourceString(Context ctx, String languageKey, String[] args) {
        Locale locale = null;
        locale = ctx == null ? SysContext.getSysContext().getLocale() : ctx.getLocale();
        if (args == null || args.length == 0) {
            return EASCommonResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)languageKey, (Locale)locale);
        }
        MessageFormat mf = new MessageFormat(EASCommonResource.getString((String)"com.kingdee.eas.fm.be.BEAutoGenerateResource", (String)languageKey, (Locale)locale));
        return mf.format(args);
    }

    private void sendByMessage(Context ctx, String msgTitle, String msgSender, String msgBody, String msgReceiver) {
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        Locale[] lcla = this.getContextLocales(ctx);
        Locale locale2 = null;
        Message message = MessageFactory.newMessage((String)"kingdee.workflow");
        for (Locale locale2 : lcla) {
            message.setLocaleStringHeader("title", msgTitle, locale2);
            message.setLocaleStringHeader("sender", msgSender, locale2);
            message.setLocaleStringHeader("body", msgBody, locale2);
        }
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 50);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 10);
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        message.setStringHeader("receiver", msgReceiver);
        senderAgent.sendMessage(message);
    }

    private Locale[] getContextLocales(Context ctx) {
        LanguageCollection langs;
        Locale[] locales = null;
        SolutionInfo solu = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        if (solu != null && (langs = solu.getLanguages()) != null) {
            locales = new Locale[langs.size()];
            for (int i = 0; i < langs.size(); ++i) {
                locales[i] = langs.get(i).getLocale();
            }
        }
        return locales;
    }

    @Override
    protected void _runSchedule_syncAgent(Context ctx) throws BOSException, EASBizException {
        logger.error((Object)"\u5f00\u59cb\u6267\u884c\u540c\u6b65\u4ee3\u53d1\u5355\u65e5\u8bb0\u8d26\u91d1\u989d\u4efb\u52a1");
        HashSet<String> idSet = new HashSet<String>();
        java.util.Date endDate = DateUtil.getDayBegin();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(endDate);
        ((Calendar)cal).add(5, -6);
        java.util.Date beginDate = cal.getTime();
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT J.FID as FID ");
        sql.append("FROM T_CAS_AGENTPAYBILL as A,T_CAS_JOURNAL as J where A.FBANKCHECKFLAG  is not null and A.FID = J.FBILLID  AND J.FVERIFYSTATUS  = 0 and A.FID  in  (");
        sql.append("select m.FSOURCEBILLID  from  T_BE_BANKAGENTPAYBILL m,  T_BE_BANKAGENTPAYBILLENTRY e where m.fid = e.FPARENTID  and e.FSTATE  in (5, 6) ");
        sql.append("and m.FCREATETIME  >= {");
        sql.append(sdf1.format(beginDate));
        sql.append("} )");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                idSet.add(rs.getString("FID"));
            }
            CoreBaseCollection newJournal = new CoreBaseCollection();
            if (idSet != null && idSet.size() > 0) {
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                evi.setFilter(fi);
                JournalCollection coll = JournalFactory.getLocalInstance(ctx).getJournalCollection(evi);
                for (int i = 0; i < coll.size(); ++i) {
                    JournalInfo journal = coll.get(i);
                    String bankCheckFlag = journal.getBankCheckFlag();
                    EntityViewInfo entityView = new EntityViewInfo();
                    FilterInfo filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("bankCheckFlag", (Object)bankCheckFlag, CompareType.EQUALS));
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("debitAmount"));
                    entityView.setSelector(sic);
                    entityView.setFilter(filterInfo);
                    TransDetailCollection transDetailCollection = TransDetailFactory.getLocalInstance((Context)ctx).getTransDetailCollection(entityView);
                    BigDecimal tranDebitAmount = new BigDecimal(0);
                    for (int j = 0; j < transDetailCollection.size(); ++j) {
                        TransDetailInfo detali = transDetailCollection.get(j);
                        if (EmptyUtil.isEmpty((Object)detali.getDebitAmount())) continue;
                        tranDebitAmount = tranDebitAmount.add(detali.getDebitAmount());
                    }
                    if (journal.getCreditAmount().compareTo(BigDecimal.ZERO) == 0 || tranDebitAmount.compareTo(BigDecimal.ZERO) == 0 || journal.getCreditAmount().compareTo(tranDebitAmount) == 0) continue;
                    journal.setCreditAmount(tranDebitAmount);
                    newJournal.add((CoreBaseInfo)journal);
                }
            }
            if (newJournal != null && newJournal.size() > 0) {
                JournalFactory.getLocalInstance(ctx).updateBatchData(newJournal);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            BOSException ex = new BOSException();
            ex.setStackTrace(e.getStackTrace());
            throw ex;
        }
        logger.error((Object)"\u540c\u6b65\u4ee3\u53d1\u5355\u65e5\u8bb0\u8d26\u91d1\u989d\u4efb\u52a1\uff0c\u6267\u884c\u5b8c\u6210");
    }
}

