/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.app.AbstractCasSubSidiaryLedgerFacadeControllerBean;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMQuerySqlBuilder;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.IInnerAccount;
import com.kingdee.eas.fm.fs.InAcctDataTypeEnum;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CasSubSidiaryLedgerFacadeControllerBean
extends AbstractCasSubSidiaryLedgerFacadeControllerBean {
    private static final String SUMMARY_QUERY = "com.kingdee.eas.fm.fs.SummaryLedgerQuery";
    private static final String SUB_QUERY = "com.kingdee.eas.fm.fs.SubsidiaryLedgerQuery";
    private static final String DEBIT_COUNTS = "debitCounts";
    private static final String CREDIT_COUNTS = "creditCounts";
    private static final String DEBIT_TOTAL = "debitTotal";
    private static final String CREDIT_TOTAL = "creditTotal";
    private static final String END_BALANCE = "endBalance";
    private static final String COMPANY_ID = "company.id";
    private static final String INNERACCT_ID = "innerAccountID";
    private static final String BankAcct_ID = "bankAcctID";
    private static final String INNERACCT_TYPE = "innerAccount.type";
    private static final String CAPITAL_TYPE = "capitalType";
    private static final String CURRENCY_ID = "currencyID";
    private static final String BIZEDATE = "bizDate";
    private static final String SUBSIDIARY_TYPE = "type";
    public final String EARLIEST_OPENDATE = "earliest_opendate";
    public final String LATEST_OPENDATE = "latest_opendate";
    public final String EARLIEST_SETTLEDATE = "earliest_settledate";
    public final String LATEST_SETTLEDATE = "latest_settledate";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.CasSubSidiaryLedgerFacadeControllerBean");

    @Override
    protected java.util.Date _getEarliestSettleDate(Context ctx, String acctNumber) throws BOSException, EASBizException {
        Date settleDate = null;
        String[] ids = this.getCleanHouseID(ctx, acctNumber);
        StringBuffer getDate = new StringBuffer();
        getDate.append("select max(FsettleDate) as maxFsettleDate from T_BD_Bank where  fid in ( ");
        for (int j = 0; j < ids.length; ++j) {
            if (j > 0) {
                getDate.append(",");
            }
            getDate.append(" '").append(ids[j].trim()).append("'");
        }
        getDate.append(")");
        IRowSet set2 = DbUtil.executeQuery((Context)ctx, (String)getDate.toString());
        try {
            if (set2.next()) {
                settleDate = set2.getDate("maxFsettleDate");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return settleDate;
    }

    private String[] getCleanHouseID(Context ctx, String acctNumber) throws BOSException {
        String[] nums = acctNumber.split(",");
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct FClearingHouseID from T_FS_InnerAccount where");
        sql.append("  FNumber in (");
        for (int i = 0; i < nums.length; ++i) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append(" '").append(nums[i]).append("'");
        }
        sql.append(")");
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String[] ids = new String[set.size()];
        int i = 0;
        try {
            while (set.next()) {
                ids[i++] = set.getString("FClearingHouseID");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return ids;
    }

    @Override
    protected BigDecimal _inAcct(Context ctx, String companyNumber, String innerAcctNumber, String currencyNumber, java.util.Date beginDay, java.util.Date endDay, InAcctDataTypeEnum inAcctDataType) throws BOSException, EASBizException {
        if (inAcctDataType == null) {
            throw new FSException(FSException.INACCTTYPEISNULL);
        }
        if (FMHelper.isEmpty((String)innerAcctNumber)) {
            return FMConstants.ZERO;
        }
        Set companyIds = null;
        Set innerAcctIds = null;
        CurrencyInfo currency = null;
        if (companyNumber != null) {
            companyNumber = companyNumber.trim();
            companyIds = CasSubSidiaryLedgerFacadeControllerBean.parseCompanyParam(ctx, companyNumber);
        }
        if (currencyNumber != null) {
            currencyNumber = currencyNumber.trim();
            currency = this.getCurrency(ctx, currencyNumber);
        }
        if (beginDay == null) {
            throw new FSException(FSException.STARTDAYISNULL);
        }
        beginDay = DateTimeUtils.truncateDate((java.util.Date)beginDay);
        if (inAcctDataType.equals((Object)InAcctDataTypeEnum.C) || inAcctDataType.equals((Object)InAcctDataTypeEnum.Y)) {
            endDay = null;
        }
        if (endDay != null) {
            endDay = DateTimeUtils.truncateDate((java.util.Date)endDay);
        }
        if (beginDay != null && endDay != null && endDay.before(beginDay)) {
            throw new FSException(FSException.BEGINLARGEREND);
        }
        if (innerAcctNumber != null) {
            innerAcctIds = this.parseInnerAcctParam(ctx, innerAcctNumber);
        }
        BigDecimal result = null;
        if (inAcctDataType.getValue().equals("C")) {
            result = this.getCValue(ctx, companyIds, innerAcctNumber, null, currency, beginDay, endDay);
        } else if (inAcctDataType.getValue().equals("Y")) {
            result = this.getYValue(ctx, companyIds, innerAcctIds, null, currency, beginDay, endDay);
        } else if (inAcctDataType.getValue().equals("MAY")) {
            result = this.getMAYValue(ctx, companyIds, innerAcctIds, null, currency, beginDay, endDay);
        } else if (inAcctDataType.getValue().equals("WAY")) {
            result = this.getWAYValue(ctx, companyIds, innerAcctIds, null, currency, beginDay, endDay);
        } else if (inAcctDataType.getValue().equals("JF")) {
            result = this.getJFValue(ctx, companyIds, innerAcctIds, null, currency, beginDay, endDay);
        } else if (inAcctDataType.getValue().equals("DF")) {
            result = this.getDFValue(ctx, companyIds, innerAcctIds, null, currency, beginDay, endDay);
        } else if (inAcctDataType.getValue().equals("QJF")) {
            result = this.getQJFValue(ctx, companyIds, innerAcctIds, null, currency, beginDay, endDay);
        } else if (inAcctDataType.getValue().equals("QDF")) {
            result = this.getQDFValue(ctx, companyIds, innerAcctIds, null, currency, beginDay, endDay);
        } else if (inAcctDataType.getValue().equals("K")) {
            result = this.getKValue(ctx, companyIds, innerAcctIds, null, currency, beginDay, endDay);
        }
        if (result != null && currency != null) {
            result = result.setScale(currency.getPrecision(), 4);
        }
        return result;
    }

    private String getSubsidiarySQL(Context ctx, String selector, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, java.util.Date beginDay, java.util.Date endDay) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemInfo selectorItemInfo = new SelectorItemInfo(selector);
        view.getSelector().add(selectorItemInfo);
        FilterInfo filter = this.getSubsidiaryFilter(companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
        view.setFilter(filter);
        String subSql = null;
        MetaDataPK mainQueryPK = new MetaDataPK(SUB_QUERY);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
        exec.setObjectView(view);
        subSql = exec.getSQL();
        return subSql;
    }

    private BigDecimal getKValue(Context ctx, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, java.util.Date beginDay, java.util.Date endDay) throws EASBizException, BOSException {
        String companyId = companyIds.iterator().next().toString();
        BankInfo CHInfo = FSHelper.getClearingHouseInfo((Context)ctx, (String)companyId);
        if (CHInfo == null) {
            Iterator iter = innerAcctIds.iterator();
            CHInfo = FSHelper.getClearingHouseInfoByInnerAcct((Context)ctx, (String)iter.next().toString());
        }
        java.util.Date unSettledDate = CHInfo.getSettleDate();
        unSettledDate = DateTimeUtils.truncateDate((java.util.Date)unSettledDate);
        BigDecimal resultSubL = FMConstants.ZERO;
        if (!beginDay.before(unSettledDate)) {
            String subsidiarySQL = this.getSubsidiarySQL(ctx, "amountOffset", companyIds, innerAcctIds, null, currency, unSettledDate, beginDay);
            String subsidiarySumSQL = "select sum(amountOffset) result from (" + subsidiarySQL + ") as subTable";
            resultSubL = this.getResultBySQL(ctx, subsidiarySumSQL);
            beginDay = this.getBeforeDay(unSettledDate);
        }
        String subSql = this.getSubSQL(ctx, END_BALANCE, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, null);
        String sql = "select sum(endBalance) result from (" + subSql + ") as subTable";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql);
        }
        return this.getResultBySQL(ctx, sql).add(resultSubL);
    }

    private BigDecimal getCValue(Context ctx, Set companyIds, String innerAcctNumber, Set bankAcctIds, CurrencyInfo currency, java.util.Date beginDay, java.util.Date endDay) throws EASBizException, BOSException {
        java.util.Date settleDate;
        Set innerAcctIds = null;
        if (innerAcctNumber != null) {
            innerAcctIds = this.parseInnerAcctParam(ctx, innerAcctNumber);
        }
        if (beginDay.after(settleDate = (java.util.Date)this.getCleanHouseDate(ctx, innerAcctNumber).get("latest_settledate"))) {
            beginDay = settleDate;
        }
        String subSql = this.getSubSQL(ctx, END_BALANCE, companyIds, innerAcctIds, bankAcctIds, currency, this.getBeforeDay(beginDay), endDay);
        String sql = "select sum(endBalance) result from (" + subSql + ") as subTable";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql);
        }
        return this.getResultBySQL(ctx, sql);
    }

    private BigDecimal getYValue(Context ctx, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, java.util.Date beginDay, java.util.Date endDay) throws EASBizException, BOSException {
        java.util.Date settleDate;
        String companyId = companyIds.iterator().next().toString();
        BankInfo CHInfo = FSHelper.getClearingHouseInfo((Context)ctx, (String)companyId);
        if (CHInfo == null) {
            Iterator iter = innerAcctIds.iterator();
            CHInfo = FSHelper.getClearingHouseInfoByInnerAcct((Context)ctx, (String)iter.next().toString());
        }
        if (beginDay.after(this.getBeforeDay(settleDate = DateTimeUtils.truncateDate((java.util.Date)CHInfo.getSettleDate())))) {
            beginDay = this.getBeforeDay(settleDate);
        }
        String subSql = this.getSubSQL(ctx, END_BALANCE, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
        String sql = "select sum(endBalance) result from (" + subSql + ") as subTable";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql);
        }
        return this.getResultBySQL(ctx, sql);
    }

    private BigDecimal getMAYValue(Context ctx, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, java.util.Date beginDay, java.util.Date endDay) throws EASBizException, BOSException {
        if (endDay == null) {
            throw new FSException(FSException.ENDDAYISNULL);
        }
        String companyId = companyIds.iterator().next().toString();
        BankInfo CHInfo = FSHelper.getClearingHouseInfo((Context)ctx, (String)companyId);
        if (CHInfo == null) {
            Iterator iter = innerAcctIds.iterator();
            CHInfo = FSHelper.getClearingHouseInfoByInnerAcct((Context)ctx, (String)iter.next().toString());
        }
        java.util.Date openDate = DateTimeUtils.truncateDate((java.util.Date)CHInfo.getOpenDate());
        java.util.Date settleDate = DateTimeUtils.truncateDate((java.util.Date)CHInfo.getSettleDate());
        if (beginDay.before(openDate)) {
            beginDay = this.getBeforeDay(openDate);
        }
        if (beginDay.after(this.getBeforeDay(settleDate))) {
            return this.getYValue(ctx, companyIds, innerAcctIds, bankAcctIds, currency, this.getBeforeDay(settleDate), null);
        }
        if (endDay.before(openDate)) {
            return FMConstants.ZERO;
        }
        String subSql = this.getSubSQL(ctx, END_BALANCE, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
        String sql = "select sum(endBalance) result from (" + subSql + ") as subTable";
        BigDecimal sum = this.getResultBySQL(ctx, sql);
        long subDay = (endDay.getTime() - beginDay.getTime()) / 1000L / 60L / 60L / 24L + 1L;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql);
        }
        return sum.divide(new BigDecimal(subDay), 6, 4);
    }

    private BigDecimal getWAYValue(Context ctx, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, java.util.Date beginDay, java.util.Date endDay) throws EASBizException, BOSException {
        if (endDay == null) {
            throw new FSException(FSException.ENDDAYISNULL);
        }
        String companyId = companyIds.iterator().next().toString();
        BankInfo CHInfo = FSHelper.getClearingHouseInfo((Context)ctx, (String)companyId);
        if (CHInfo == null) {
            Iterator iter = innerAcctIds.iterator();
            CHInfo = FSHelper.getClearingHouseInfoByInnerAcct((Context)ctx, (String)iter.next().toString());
        }
        java.util.Date openDate = DateTimeUtils.truncateDate((java.util.Date)CHInfo.getOpenDate());
        java.util.Date settleDate = DateTimeUtils.truncateDate((java.util.Date)CHInfo.getSettleDate());
        if (beginDay.before(openDate)) {
            beginDay = this.getBeforeDay(openDate);
        }
        if (beginDay.after(this.getBeforeDay(settleDate))) {
            return this.getYValue(ctx, companyIds, innerAcctIds, bankAcctIds, currency, this.getBeforeDay(settleDate), null);
        }
        if (endDay.before(openDate)) {
            return FMConstants.ZERO;
        }
        String subSql = this.getSubSQL(ctx, END_BALANCE, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
        if (endDay.before(this.getBeforeDay(settleDate))) {
            String sql = "select sum(endBalance) result from (" + subSql + ") as subTable";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)sql);
            }
            BigDecimal sum = this.getResultBySQL(ctx, sql);
            long subDay = (endDay.getTime() - beginDay.getTime()) / 1000L / 60L / 60L / 24L + 1L;
            return sum.divide(new BigDecimal(subDay), 6, 4);
        }
        String sql = "select sum(endBalance) result from (" + subSql + ") as subTable";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql);
        }
        BigDecimal sum = this.getResultBySQL(ctx, sql);
        BigDecimal sumAdd = this.getCValue(ctx, companyIds, null, bankAcctIds, currency, settleDate, null);
        long subDay = (endDay.getTime() - beginDay.getTime()) / 1000L / 60L / 60L / 24L + 1L;
        long subDay2 = (endDay.getTime() - settleDate.getTime()) / 1000L / 60L / 60L / 24L + 1L;
        sum = sum.add(sumAdd.multiply(new BigDecimal(subDay2)));
        BigDecimal result = sum.divide(new BigDecimal(subDay), 6, 4);
        return result;
    }

    private BigDecimal getJFValue(Context ctx, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, java.util.Date beginDay, java.util.Date endDay) throws BOSException, FSException {
        if (endDay == null) {
            throw new FSException(FSException.ENDDAYISNULL);
        }
        String subSql = this.getSubSQL(ctx, DEBIT_TOTAL, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
        String sql = "select sum(debitTotal) result from (" + subSql + ") as subTable";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql);
        }
        return this.getResultBySQL(ctx, sql);
    }

    private BigDecimal getDFValue(Context ctx, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, java.util.Date beginDay, java.util.Date endDay) throws BOSException, FSException {
        if (endDay == null) {
            throw new FSException(FSException.ENDDAYISNULL);
        }
        String subSql = this.getSubSQL(ctx, CREDIT_TOTAL, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
        String sql = "select sum(creditTotal) result from (" + subSql + ") as subTable";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql);
        }
        return this.getResultBySQL(ctx, sql);
    }

    private BigDecimal getQJFValue(Context ctx, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, java.util.Date beginDay, java.util.Date endDay) throws BOSException, FSException {
        if (endDay == null) {
            throw new FSException(FSException.ENDDAYISNULL);
        }
        String subSql = this.getSubSQL(ctx, DEBIT_COUNTS, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
        String sql = "select sum(debitCounts) result from (" + subSql + ") as subTable";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql);
        }
        return this.getResultBySQL(ctx, sql);
    }

    private BigDecimal getQDFValue(Context ctx, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, java.util.Date beginDay, java.util.Date endDay) throws BOSException, FSException {
        if (endDay == null) {
            throw new FSException(FSException.ENDDAYISNULL);
        }
        String subSql = this.getSubSQL(ctx, CREDIT_COUNTS, companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
        String sql = "select sum(creditCounts) result from (" + subSql + ") as subTable";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql);
        }
        return this.getResultBySQL(ctx, sql);
    }

    private String getSubSQL(Context ctx, String entry, Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, java.util.Date beginDay, java.util.Date endDay) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo(entry));
        FilterInfo filter = this.getFilter(companyIds, innerAcctIds, bankAcctIds, currency, beginDay, endDay);
        view.setFilter(filter);
        String subSql = null;
        MetaDataPK mainQueryPK = new MetaDataPK(SUMMARY_QUERY);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
        exec.setObjectView(view);
        subSql = exec.getSQL();
        return subSql;
    }

    private FilterInfo getSubsidiaryFilter(Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, java.util.Date beginDay, java.util.Date endDay) {
        FilterItemInfo filterItem;
        FilterInfo filter = new FilterInfo();
        if (companyIds != null) {
            filterItem = new FilterItemInfo(COMPANY_ID, (Object)companyIds, CompareType.INCLUDE);
            filter.getFilterItems().add(filterItem);
        }
        if (innerAcctIds != null) {
            filter.getFilterItems().add(this.getInnerAccountFilterItem(innerAcctIds));
        }
        if (bankAcctIds != null) {
            filter.getFilterItems().add(this.getBankAcctFilterItem(bankAcctIds));
        }
        if (currency != null) {
            filterItem = new FilterItemInfo("currency", (Object)currency.getId().toString());
            filter.getFilterItems().add(filterItem);
        }
        if (beginDay != null) {
            beginDay = DateTimeUtils.truncateDate((java.util.Date)beginDay);
            filterItem = new FilterItemInfo("date", (Object)beginDay, CompareType.GREATER_EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        return filter;
    }

    private FilterInfo getFilter(Set companyIds, Set innerAcctIds, Set bankAcctIds, CurrencyInfo currency, java.util.Date beginDay, java.util.Date endDay) {
        FilterInfo filter = new FilterInfo();
        if (companyIds != null) {
            filter.getFilterItems().add(this.getApplyUnitFilterItem(companyIds));
        }
        if (innerAcctIds != null) {
            filter.getFilterItems().add(this.getInnerAccountFilterItem(innerAcctIds));
        }
        if (bankAcctIds != null) {
            filter.getFilterItems().add(this.getBankAcctFilterItem(bankAcctIds));
        }
        if (currency != null) {
            filter.getFilterItems().add(this.getCurrencyFilterItem(currency));
        }
        if (beginDay != null) {
            if (endDay != null) {
                filter.getFilterItems().add(this.getBeginDateFilterItem(beginDay, CompareType.GREATER_EQUALS));
                filter.getFilterItems().add(this.getEndDateFilterItem(endDay));
            } else {
                filter.getFilterItems().add(this.getBeginDateFilterItem(beginDay, CompareType.EQUALS));
            }
        }
        return filter;
    }

    private java.util.Date getBeforeDay(java.util.Date date) {
        if (date == null) {
            return null;
        }
        date = DateTimeUtils.truncateDate((java.util.Date)date);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) - 1);
        return cal.getTime();
    }

    private static Set parseCompanyParam(Context ctx, String param) throws BOSException {
        if (FMHelper.isEmpty((String)param)) {
            return new HashSet();
        }
        if (param.indexOf(",") > 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"116_CasSubSidiaryLedgerFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)param));
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("*"));
        view.setFilter(filter);
        CompanyOrgUnitCollection co = iCompany.getCompanyOrgUnitCollection(view);
        int size = co.size();
        if (size == 0) {
            return null;
        }
        HashSet<BOSUuid> companySet = new HashSet<BOSUuid>();
        for (int i = 0; i < size; ++i) {
            CompanyOrgUnitInfo companyInfo = co.get(i);
            companySet.add(companyInfo.getId());
        }
        return companySet;
    }

    private Set parseInnerAcctParam(Context ctx, String param) throws FSException, BOSException {
        FilterInfo filter = this.parseParamFilter(param);
        IInnerAccount iInner = InnerAccountFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.setFilter(filter);
        CoreBaseCollection co = iInner.getCollection(view);
        int size = co.size();
        if (size == 0) {
            return null;
        }
        HashSet<BOSUuid> innerSet = new HashSet<BOSUuid>();
        for (int i = 0; i < size; ++i) {
            innerSet.add(co.get(i).getId());
        }
        return innerSet;
    }

    private FilterInfo parseParamFilter(String param) throws FSException {
        HashSet<String> aloneSet = new HashSet<String>();
        HashSet<String> periodSet = new HashSet<String>();
        if (param == null) {
            return null;
        }
        if (param.indexOf(",") == -1 && param.indexOf(":") == -1) {
            aloneSet.add(param);
        } else {
            String[] subParam = param.split(",");
            for (int i = 0; i < subParam.length; ++i) {
                if (subParam[i].indexOf(":") == -1) {
                    aloneSet.add(subParam[i]);
                    continue;
                }
                periodSet.add(subParam[i]);
            }
        }
        FilterInfo filter = new FilterInfo();
        FilterItemInfo aloneFilter = null;
        if (aloneSet.size() != 0) {
            aloneFilter = new FilterItemInfo("number", aloneSet, CompareType.INCLUDE);
        }
        FilterItemCollection periodFilters = new FilterItemCollection();
        Iterator it = periodSet.iterator();
        while (it.hasNext()) {
            String[] periodString = ((String)it.next()).split(":");
            if (periodString.length != 2) {
                throw new FSException(FSException.EXPRESSWRONG);
            }
            if (periodString[1].compareTo(periodString[0]) < 0) {
                throw new FSException(FSException.NUMBERWRONG);
            }
            periodFilters.add(new FilterItemInfo("number", (Object)periodString[0], CompareType.GREATER_EQUALS));
            periodFilters.add(new FilterItemInfo("number", (Object)periodString[1], CompareType.LESS_EQUALS));
        }
        int maskCount = 0;
        StringBuffer maskString = new StringBuffer("");
        if (aloneFilter != null) {
            filter.getFilterItems().add(aloneFilter);
            maskString.append("#" + maskCount);
            ++maskCount;
        }
        if (periodFilters.size() != 0) {
            filter.getFilterItems().addObjectCollection((IObjectCollection)periodFilters);
            for (int i = 0; i < periodFilters.size(); i += 2) {
                if (!maskString.toString().equals("")) {
                    maskString.append(" or ");
                }
                maskString.append("(#" + maskCount + " and #" + (maskCount + 1) + ")");
                maskCount += 2;
            }
            filter.setMaskString(maskString.toString());
        }
        return filter;
    }

    private FilterItemInfo getApplyUnitFilterItem(Set companyIds) {
        FilterItemInfo filter = new FilterItemInfo(COMPANY_ID, (Object)companyIds, CompareType.INCLUDE);
        return filter;
    }

    private FilterItemInfo getInnerAccountFilterItem(Set innerAcctIds) {
        FilterItemInfo filter = new FilterItemInfo(INNERACCT_ID, (Object)innerAcctIds, CompareType.INCLUDE);
        return filter;
    }

    private FilterItemInfo getBankAcctFilterItem(Set bankAcctIds) {
        FilterItemInfo filter = new FilterItemInfo(BankAcct_ID, (Object)bankAcctIds, CompareType.INCLUDE);
        return filter;
    }

    private FilterItemInfo getBeginDateFilterItem(java.util.Date beginDay, CompareType type) {
        beginDay = DateTimeUtils.truncateDate((java.util.Date)beginDay);
        FilterItemInfo filterItem = new FilterItemInfo(BIZEDATE, (Object)beginDay, type);
        return filterItem;
    }

    private FilterItemInfo getEndDateFilterItem(java.util.Date endDay) {
        FilterItemInfo filterItem = new FilterItemInfo(BIZEDATE, (Object)endDay, CompareType.LESS_EQUALS);
        return filterItem;
    }

    private FilterItemInfo getCurrencyFilterItem(CurrencyInfo currency) {
        FilterItemInfo filterItem = new FilterItemInfo(CURRENCY_ID, (Object)currency.getId().toString());
        return filterItem;
    }

    private CurrencyInfo getCurrency(Context ctx, String currencyNumber) throws BOSException, FSException {
        if (currencyNumber == null) {
            return null;
        }
        CurrencyCollection currencyCollection = null;
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)currencyNumber));
        view.setFilter(filter);
        currencyCollection = iCurrency.getCurrencyCollection(view);
        if (currencyCollection.size() != 1) {
            throw new FSException(FSException.CURRENCYNUMNOTEXSIST);
        }
        return currencyCollection.get(0);
    }

    private BigDecimal getResultBySQL(Context ctx, String sql) throws SQLDataException, BOSException {
        BigDecimal result = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            if (rs.next() && (result = rs.getBigDecimal("result")) == null) {
                result = FMConstants.ZERO;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return result;
    }

    @Override
    protected Map _getInnerAcctDailyBalance(Context ctx, String innerAcctID, String currencyID, java.util.Date beginDate, java.util.Date endDate) throws BOSException, EASBizException {
        FMQuerySqlBuilder builder = new FMQuerySqlBuilder();
        builder.appendSql("select  fdate ,sum(fdebitamount-fcreditamount) amount  ");
        builder.appendSql(" from t_fs_subsidiaryledger");
        builder.appendSql(" where   FCurrencyId =");
        builder.appendParam((Object)currencyID);
        builder.appendSql(" and FInnerAccountID=");
        builder.appendParam((Object)innerAcctID);
        builder.appendSql(" and fdate>=");
        builder.appendParam((Object)DateHelper.getSQLBegin((java.util.Date)beginDate));
        builder.appendSql(" and fdate<=");
        builder.appendParam((Object)DateHelper.getSQLBegin((java.util.Date)endDate));
        builder.appendSql(" group by fdate");
        HashMap<Date, BigDecimal> result = new HashMap<Date, BigDecimal>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            pstmt = builder.createState(con);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Date date = rs.getDate("fdate");
                BigDecimal amount = rs.getBigDecimal("amount");
                result.put(date, amount);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)("sql: " + builder.getTestSql()));
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return result;
    }

    @Override
    protected Map _getCleanHouseDate(Context ctx, String acctNumber) throws BOSException, EASBizException {
        HashMap<String, Date> returnMap = new HashMap<String, Date>();
        String[] ids = this.getCleanHouseID(ctx, acctNumber);
        StringBuffer getDate = new StringBuffer();
        getDate.append("select").append(" max(FsettleDate) as maxFsettleDate,min(FsettleDate) AS minFsettleDate,").append(" max(FopenDate) as maxOpenDate,min(FopenDate)  AS minOpenDate ").append("from T_BD_Bank where  fid in ( ");
        for (int j = 0; j < ids.length; ++j) {
            if (j > 0) {
                getDate.append(",");
            }
            getDate.append(" '").append(ids[j].trim()).append("'");
        }
        getDate.append(")");
        IRowSet bankSet = DbUtil.executeQuery((Context)ctx, (String)getDate.toString());
        try {
            if (bankSet.next()) {
                returnMap.put("earliest_settledate", bankSet.getDate("maxFsettleDate"));
                returnMap.put("earliest_opendate", bankSet.getDate("minOpenDate"));
                returnMap.put("latest_settledate", bankSet.getDate("minFsettleDate"));
                returnMap.put("latest_opendate", bankSet.getDate("maxOpenDate"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return returnMap;
    }
}

