/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SharedAcctFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.assistant.VoucherTypeCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.app.AbstractCasWebParamFacadeControllerBean;
import com.kingdee.eas.fi.cas.utils.BankJournalWebUtil;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.JournalWebUtil;
import com.kingdee.eas.fi.cas.web.param.FetchAccTableParam;
import com.kingdee.eas.framework.SystemEnum;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class CasWebParamFacadeControllerBean
extends AbstractCasWebParamFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.CasWebParamFacadeControllerBean");

    @Override
    protected CompanyOrgUnitInfo _getCurrentCompany(Context ctx) throws BOSException, EASBizException {
        return (CompanyOrgUnitInfo)ctx.get((Object)OrgType.Company);
    }

    @Override
    protected CompanyOrgUnitInfo _getCompanyById(Context ctx, String companyId) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = null;
        if (companyId != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("baseCurrency.*"));
            sic.add(new SelectorItemInfo("accountTable.id"));
            sic.add(new SelectorItemInfo("accountTable.name"));
            sic.add(new SelectorItemInfo("accountTable.number"));
            companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), sic);
        }
        return companyInfo;
    }

    @Override
    protected CurrencyInfo _getBaseCurrencyByCom(Context ctx, String companyId) throws BOSException, EASBizException {
        CurrencyInfo curInfo = null;
        if (companyId != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("baseCurrency.*"));
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), sic);
            curInfo = company.getBaseCurrency();
        }
        return curInfo;
    }

    @Override
    protected CurrencyInfo _getCurrencyById(Context ctx, String currencyId) throws BOSException, EASBizException {
        CurrencyInfo currencyInfo = null;
        if (!EmptyUtil.isEmpty((String)currencyId)) {
            currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
        }
        return currencyInfo;
    }

    @Override
    protected AccountViewInfo _getAccountViewByBank(Context ctx, String accountBankId) throws BOSException, EASBizException {
        AccountViewInfo avInfo = null;
        if (accountBankId != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("account.*"));
            AccountBankInfo abInfo = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountBankId), sic);
            if (abInfo != null) {
                avInfo = abInfo.getAccount();
            }
        }
        return avInfo;
    }

    @Override
    protected PeriodInfo _getStartPeriodByCom(Context ctx, String companyId) throws BOSException, EASBizException {
        PeriodInfo periodInfo = null;
        if (companyId != null) {
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            periodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        }
        return periodInfo;
    }

    @Override
    protected PeriodCollection _getPeriodsByPeriodType(Context ctx, String periodType) throws BOSException, EASBizException {
        PeriodCollection accountPeriodColl = null;
        if (periodType != null) {
            EntityViewInfo accountPeriodsView = new EntityViewInfo();
            SelectorItemCollection accountPeriodsSic = new SelectorItemCollection();
            accountPeriodsSic.add(new SelectorItemInfo(" * "));
            accountPeriodsView.setSelector(accountPeriodsSic);
            FilterInfo accountPeriodsFilter = new FilterInfo();
            accountPeriodsFilter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodType, CompareType.EQUALS));
            accountPeriodsView.setFilter(accountPeriodsFilter);
            accountPeriodsView.getSorter().add(new SorterItemInfo("periodYear"));
            accountPeriodsView.getSorter().add(new SorterItemInfo("periodNumber"));
            accountPeriodColl = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(accountPeriodsView);
        }
        return accountPeriodColl;
    }

    @Override
    protected PeriodInfo _getPeriodByDate(Context ctx, String companyId, long dateMis) throws BOSException, EASBizException {
        PeriodInfo periodInfo = null;
        try {
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)new Date(dateMis), (CompanyOrgUnitInfo)company);
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
        return periodInfo;
    }

    @Override
    protected boolean _checkPermission(Context ctx, String companyId, String itemName) throws BOSException, EASBizException {
        PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), itemName);
        return true;
    }

    @Override
    protected boolean _checkIsAdjustPeriod(Context ctx, String companyId) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        return periodInfo.isIsAdjustPeriod();
    }

    @Override
    protected PeriodCollection _getCompanyPeriods(Context ctx, String companyId) throws BOSException, EASBizException {
        PeriodCollection periods = null;
        if (companyId != null) {
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            periods = BankJournalWebUtil.getPeriodc(ctx, company);
        }
        return periods;
    }

    @Override
    protected Map _getCompanyPeriodsMap(Context ctx, String companyId) throws BOSException, EASBizException {
        TreeMap periodsMap = new TreeMap();
        PeriodCollection periods = this._getCompanyPeriods(ctx, companyId);
        if (periods != null) {
            for (Object period : periods.toArray()) {
                PeriodInfo periodInfo = (PeriodInfo)period;
                if (!periodsMap.containsKey(periodInfo.getPeriodYear())) {
                    periodsMap.put(periodInfo.getPeriodYear(), new TreeSet());
                }
                TreeSet periodMonthList = (TreeSet)periodsMap.get(periodInfo.getPeriodYear());
                periodMonthList.add(periodInfo.getPeriodNumber());
            }
        }
        return periodsMap;
    }

    @Override
    protected PeriodInfo _getCurrentPeriod(Context ctx, String companyId) throws BOSException, EASBizException {
        PeriodInfo periodInfo = null;
        if (companyId != null) {
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        }
        return periodInfo;
    }

    @Override
    protected String _getAuthorizedOrgFilter(Context ctx, String prmitItem) throws BOSException, EASBizException {
        return CASWebHelper.getAuthorizedOrgFilter(ctx, prmitItem, false, "id");
    }

    @Override
    protected boolean _checkJournalUnique(Context ctx, String jsonStr) throws BOSException, EASBizException {
        boolean flag = false;
        JournalInfo journal = null;
        journal = (JournalInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonStr, JournalInfo.class);
        if (journal != null && !EmptyUtil.isEmpty((String)journal.getVoucherNumber())) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)journal.getPeriod().getId().toString()));
            if (journal.getVoucherType() != null) {
                filter.getFilterItems().add(new FilterItemInfo("voucherType.id", (Object)journal.getVoucherType().getId()));
            }
            if (!EmptyUtil.isEmpty((String)journal.getVoucherNumber())) {
                filter.getFilterItems().add(new FilterItemInfo("voucherNumber", (Object)journal.getVoucherNumber()));
            }
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)journal.getCompany().getId().toString()));
            if (!EmptyUtil.isEmpty((Object)journal.getId())) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)journal.getId(), CompareType.NOTEQUALS));
            }
            flag = JournalFactory.getLocalInstance(ctx).exists(filter);
        }
        return flag;
    }

    @Override
    protected boolean _chkCanMulUnionQuery(Context ctx, String companyId, String accountBankId) throws BOSException, EASBizException {
        boolean isCanMulUnionQuery = false;
        if (!EmptyUtil.isEmpty((String)companyId) && !EmptyUtil.isEmpty((String)accountBankId)) {
            AccountBankInfo abInfo = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountBankId));
            if (0 == abInfo.getShareType().getValue() || abInfo.isIsForEDrafOnly()) {
                isCanMulUnionQuery = false;
            } else {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("shareBalanceOfAcctCompany.id", (Object)companyId));
                isCanMulUnionQuery = SharedAcctFactory.getLocalInstance((Context)ctx).exists(filter);
            }
        }
        return isCanMulUnionQuery;
    }

    @Override
    protected String _getDisplayAcctTableId(Context ctx, FetchAccTableParam param) throws BOSException, EASBizException {
        String accTableId = null;
        if (param != null) {
            accTableId = JournalWebUtil.getDisplayAcctTable(ctx, param);
        }
        return accTableId;
    }

    @Override
    protected AccountViewCollection _getAccountViewList(Context ctx, String companyId, String acctTableId, boolean isShowForbidden) throws BOSException, EASBizException {
        AccountViewCollection accountCol = null;
        accountCol = JournalWebUtil.getAccountViewList(ctx, companyId, acctTableId, isShowForbidden);
        return accountCol;
    }

    @Override
    protected AccountBankInfo _getDefaultAccountBank(Context ctx, String companyId) throws BOSException, EASBizException {
        AccountBankInfo accountBankInfo = null;
        if (companyId != null) {
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            EntityViewInfo accountBankEntity = new EntityViewInfo();
            FilterInfo accountBankFilter = new FilterInfo();
            accountBankEntity.setFilter(accountBankFilter);
            accountBankFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId().toString(), CompareType.EQUALS));
            accountBankFilter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0), CompareType.EQUALS));
            accountBankFilter.getFilterItems().add(new FilterItemInfo("isBank", (Object)new Integer(1), CompareType.EQUALS));
            accountBankEntity.getSorter().add(new SorterItemInfo("number"));
            SelectorItemCollection accountBankSic = new SelectorItemCollection();
            accountBankSic.add(new SelectorItemInfo("*"));
            accountBankSic.add(new SelectorItemInfo("currency.*"));
            accountBankSic.add(new SelectorItemInfo("company.*"));
            accountBankSic.add(new SelectorItemInfo("account.*"));
            accountBankSic.add(new SelectorItemInfo("bank.id"));
            accountBankSic.add(new SelectorItemInfo("bank.name"));
            accountBankSic.add(new SelectorItemInfo("bank.number"));
            accountBankEntity.setSelector(accountBankSic);
            AccountBankCollection accountBankCol = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(accountBankEntity);
            if (accountBankCol != null && accountBankCol.size() > 0) {
                accountBankInfo = accountBankCol.get(0);
                PeriodInfo curPeriod = JournalWebUtil.getCurrentPeriod(ctx, companyInfo.getId().toString());
                String accTableId = JournalWebUtil.getAccTableIdByPeriod(companyInfo.getId().toString(), null, curPeriod.getPeriodYear(), curPeriod.getPeriodNumber(), curPeriod.getPeriodYear(), curPeriod.getPeriodNumber());
                accountBankInfo = accountBankCol.get(0);
                accountBankInfo = JournalWebUtil.getJouranlBalanceAcctBank(ctx, accountBankInfo, curPeriod.getId().toString(), accTableId);
            }
        }
        return accountBankInfo;
    }

    @Override
    protected BigDecimal _getCurExchange(Context ctx, String companyId, String srcCurrencyId) throws BOSException, EASBizException {
        BigDecimal exchange = null;
        if (companyId != null && srcCurrencyId != null) {
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(srcCurrencyId));
            exchange = JournalWebUtil.getExchange(ctx, company, currencyInfo, null, null);
        }
        return exchange;
    }

    @Override
    protected BigDecimal _getExchangeRate(Context ctx, String companyId, String srcCurId, String desCurId, Date date) throws BOSException, EASBizException {
        return JournalWebUtil.getExchangeRate(ctx, companyId, srcCurId, desCurId, date);
    }

    @Override
    protected BigDecimal _getSimpleExchangeRate(Context ctx, String companyId, String srcCurId) throws BOSException, EASBizException {
        return JournalWebUtil.getSimpleExchangeRate(ctx, companyId, srcCurId);
    }

    @Override
    protected VoucherTypeCollection _getVoucherTypeList(Context ctx, String companyId) throws BOSException, EASBizException {
        VoucherTypeCollection vouhcerTypeList = null;
        if (companyId != null) {
            CompanyOrgUnitInfo company = this.getCompanyById(ctx, companyId);
            EntityViewInfo viewInfo = new EntityViewInfo();
            BOSUuid pk = company.getCU().getId();
            FilterInfo filter = VoucherTypeFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(pk.toString()), "id", "adminCU.id");
            viewInfo.setFilter(filter);
            vouhcerTypeList = VoucherTypeFactory.getLocalInstance((Context)ctx).getVoucherTypeCollection(viewInfo);
        }
        return vouhcerTypeList;
    }

    @Override
    protected String _getAuthorizedOrgFilterF7(Context ctx, String prmitItem) throws BOSException, EASBizException {
        return CASWebHelper.getAuthorizedOrgFilter_F7Special(ctx, prmitItem, false, "unit.id", null);
    }

    @Override
    protected boolean _checkHasRate(Context ctx, String companyId, String srcCurrencyId) throws BOSException, EASBizException {
        return JournalWebUtil.checkHasRate(ctx, companyId, srcCurrencyId);
    }
}

