/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QueryPanelTypeEnum;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.ShareTypeEnum;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.app.AbstractCasWebQrySolFacadeControllerBean;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.JournalWebUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CasWebQrySolFacadeControllerBean
extends AbstractCasWebQrySolFacadeControllerBean {
    public static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.CasWebQrySolFacadeControllerBean");
    public static final String FILTER_PANEL_CLASS_NAME = "com.kingdee.eas.fi.cas.commonquery.CommonFilterPanel";

    @Override
    protected List _getSolutionList(Context ctx, String orgId, String parentUIName) throws BOSException, EASBizException {
        ArrayList<QuerySolutionInfo> solutions = new ArrayList<QuerySolutionInfo>();
        BOSUuid orgUuid = BOSUuid.read((String)orgId);
        try {
            EntityViewInfo viewInfo = this.getQuerySolutionViewInfo(ctx, parentUIName, orgUuid);
            IQuerySolution iSolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
            QuerySolutionCollection solutionCol = iSolution.getQuerySolutionCollection(viewInfo);
            for (int i = 0; i < solutionCol.size(); ++i) {
                QuerySolutionInfo info = solutionCol.get(i);
                if (info.isIsUserDefaultSolu()) {
                    solutions.add(0, info);
                    continue;
                }
                solutions.add(info);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return solutions;
    }

    public SelectorItemCollection getSelectorItemCollection() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.*"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.id"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.queryPanelType"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.panelClassName"));
        return sic;
    }

    @Override
    protected Map _getSolutionDetail(Context ctx, String solutionId) throws BOSException, EASBizException {
        HashMap data = new HashMap();
        if (solutionId != null && solutionId.length() > 0) {
            String customerParams = null;
            QuerySolutionInfo solutionInfo = null;
            IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
            solutionInfo = iQuerySolution.getQuerySolutionInfo((IObjectPK)new ObjectUuidPK(solutionId));
            QueryPanelCollection queryPanels = solutionInfo.getQueryPanelInfo();
            for (int i0 = 0; i0 < queryPanels.size(); ++i0) {
                QueryPanelInfo info = queryPanels.get(i0);
                customerParams = info.getCustomerParams();
            }
            if (customerParams != null) {
                CustomerParams cp = CustomerParams.getCustomerParams2(customerParams);
                HashMap searchFilter = cp.getCustomerParamsHashMap();
                this.afterGetSolution(searchFilter);
                data.put("searchFilter", searchFilter);
                data.put("solution", solutionInfo);
            }
        }
        return data;
    }

    @Override
    protected String _saveSolution(Context ctx, String companyId, String solutionName, String parentUIName, String filterJsonStr) throws BOSException, EASBizException {
        String solutionId = null;
        if (companyId != null && solutionName != null && parentUIName != null && filterJsonStr != null) {
            HashMap searchFilter = JSONUtils.convertJsonToObject((Context)ctx, (String)filterJsonStr);
            String viewId = null;
            QuerySolutionInfo solutionInfo = this.getSameNameSolution(ctx, solutionName, parentUIName, companyId);
            if (solutionInfo != null) {
                viewId = solutionInfo.getId().toString();
                solutionInfo = this.editSolution(ctx, viewId, parentUIName, solutionName, searchFilter, companyId);
            } else {
                solutionInfo = this.addSolution(ctx, parentUIName, solutionName, searchFilter, companyId);
            }
            solutionId = solutionInfo.getId().toString();
        }
        return solutionId;
    }

    public QuerySolutionInfo getSameNameSolution(Context ctx, String solutionName, String parentUIName, String orgId) throws EASBizException, BOSException {
        IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
        return iQuerySolution.getOwnerSolutionByName(orgId, this.getQueryPk(), parentUIName, this.getShareType(), solutionName);
    }

    public QuerySolutionInfo getSameNameUserSolution(Context ctx, String solutionName, String parentUIName) throws EASBizException, BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parentUIName", (Object)parentUIName));
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)solutionName));
        filterInfo.getFilterItems().add(new FilterItemInfo("owner", (Object)ctx.getCaller().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("shareType", (Object)this.getShareType().getValue()));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        QuerySolutionCollection querySolutionCollection = QuerySolutionFactory.getRemoteInstance().getQuerySolutionCollection(entityViewInfo);
        if (querySolutionCollection.size() != 0) {
            return querySolutionCollection.get(0);
        }
        return null;
    }

    @Override
    protected void _setDefaultSolution(Context ctx, String companyId, String parentUIName, String solutionId) throws BOSException, EASBizException {
        if (solutionId != null && companyId != null && parentUIName != null) {
            EntityViewInfo viewInfo;
            IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
            QuerySolutionCollection solutionCol = iQuerySolution.getQuerySolutionCollection(viewInfo = this.getQuerySolutionViewInfo(ctx, parentUIName, BOSUuid.read((String)companyId)));
            if (solutionCol != null && solutionCol.size() > 0) {
                int size = solutionCol.size();
                for (int i = 0; i < size; ++i) {
                    QuerySolutionInfo info = solutionCol.get(i);
                    if (!info.isIsUserDefaultSolu() || info.getIdentity().toString().equals(solutionId)) continue;
                    info.setIsUserDefaultSolu(false);
                    SelectorItemCollection updateSelector = new SelectorItemCollection();
                    updateSelector.add(new SelectorItemInfo("isUserDefaultSolu"));
                    iQuerySolution.updatePartial((CoreBaseInfo)info, updateSelector);
                }
            }
            QuerySolutionInfo solutionInfo = null;
            solutionInfo = iQuerySolution.getQuerySolutionInfo((IObjectPK)new ObjectUuidPK(solutionId));
            if (solutionInfo != null) {
                solutionInfo.setIsUserDefaultSolu(true);
                SelectorItemCollection updateSelector = new SelectorItemCollection();
                updateSelector.add(new SelectorItemInfo("isUserDefaultSolu"));
                iQuerySolution.updatePartial((CoreBaseInfo)solutionInfo, updateSelector);
            }
        }
    }

    @Override
    protected void _removeSolution(Context ctx, String companyId, String parentUIName, String solutionId) throws BOSException, EASBizException {
        IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
        iQuerySolution.delete((IObjectPK)new ObjectUuidPK(solutionId));
        this.resetDefaultSolution(ctx, companyId, parentUIName);
    }

    public BOSUuid getCurrentUserId(Context ctx) {
        return ContextUtil.getCurrentUserInfo((Context)ctx).getId();
    }

    public ShareTypeEnum getShareType() {
        return ShareTypeEnum.USER_NOORG_LEVEL;
    }

    public void afterGetSolution(Map searchFilter) throws EASBizException, BOSException {
    }

    public void beforeSaveSolution(Map searchFilter) throws EASBizException, BOSException {
    }

    public void checkBeforeCopy(String companyId, String solutionname, boolean isdefault, String parentuiname, String filer) throws EASBizException, BOSException {
    }

    public String getQueryPk() {
        return null;
    }

    public EntityViewInfo getQuerySolutionViewInfo(Context ctx, String parentUIName, BOSUuid orgUuid) throws EASBizException, BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("queryObjectName", (Object)this.getQueryPk()));
        filter.getFilterItems().add(new FilterItemInfo("parentUIName", (Object)parentUIName));
        if (orgUuid != null) {
            filter.getFilterItems().add(new FilterItemInfo("shareType", (Object)2));
            filter.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgUuid));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("shareType", (Object)16));
            filter.getFilterItems().add(new FilterItemInfo("owner", (Object)this.getCurrentUserId(ctx).toString()));
        }
        boolean isShare = parentUIName.toLowerCase(Locale.ENGLISH).endsWith("share");
        if (!isShare) {
            CompanyOrgUnitInfo orgInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
            filter.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgInfo.getId().toString()));
        }
        viewInfo.setFilter(filter);
        SorterItemCollection sortCol = new SorterItemCollection();
        sortCol.add(new SorterItemInfo("name"));
        viewInfo.setSorter(sortCol);
        viewInfo.getSelector().addObjectCollection((IObjectCollection)this.getSelectorItemCollection());
        return viewInfo;
    }

    public QuerySolutionInfo editUserSolution(Context ctx, String solutionId, String parentUIName, String solutionName, Map searchFilter) throws EASBizException, BOSException {
        QuerySolutionInfo solutionInfo = null;
        try {
            IQuerySolution iSolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)solutionId));
            solutionInfo = iSolution.getQuerySolutionInfo((IObjectPK)pk);
            solutionInfo.setShareType(this.getShareType());
            QueryPanelCollection queryPanelCol = this.getQueryPanelCollection(searchFilter);
            solutionInfo.getQueryPanelInfo().clear();
            solutionInfo.getQueryPanelInfo().addCollection(queryPanelCol);
            solutionInfo.setRowCount(-1);
            List list = this.getUserSolutionList(ctx, parentUIName);
            if (list == null || list.size() == 0) {
                solutionInfo.setIsUserDefaultSolu(true);
            }
            iSolution.update((IObjectPK)pk, (CoreBaseInfo)solutionInfo);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return solutionInfo;
    }

    public QuerySolutionInfo editSolution(Context ctx, String solutionId, String parentUIName, String solutionName, Map searchFilter, String orgId) throws EASBizException, BOSException {
        QuerySolutionInfo solutionInfo = null;
        try {
            IQuerySolution iSolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)solutionId));
            solutionInfo = iSolution.getQuerySolutionInfo((IObjectPK)pk);
            solutionInfo.setShareType(this.getShareType());
            QueryPanelCollection queryPanelCol = this.getQueryPanelCollection(searchFilter);
            solutionInfo.getQueryPanelInfo().clear();
            solutionInfo.getQueryPanelInfo().addCollection(queryPanelCol);
            solutionInfo.setRowCount(-1);
            List list = this.getUserSolutionList(ctx, parentUIName);
            if (list == null || list.size() == 0) {
                solutionInfo.setIsUserDefaultSolu(true);
            }
            iSolution.update((IObjectPK)pk, (CoreBaseInfo)solutionInfo);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return solutionInfo;
    }

    public QuerySolutionInfo addUserSolution(Context ctx, String parentUIName, String solutionName, Map searchFilter, String userId) throws EASBizException, BOSException {
        QuerySolutionInfo solutionInfo = null;
        try {
            solutionInfo = new QuerySolutionInfo();
            solutionInfo.setName(solutionName);
            solutionInfo.setName(solutionName, new Locale("l1"));
            solutionInfo.setName(solutionName, new Locale("l3"));
            CompanyOrgUnitInfo orgInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
            solutionInfo.setOrgID(BOSUuid.read((String)orgInfo.getId().toString()));
            solutionInfo.setQueryObjectName(this.getQueryPk());
            solutionInfo.setShareType(this.getShareType());
            solutionInfo.setSolutionType(SolutionTypeEnum.CUSTOMER_SOLUTION);
            solutionInfo.setParentUIName(parentUIName);
            solutionInfo.setIsUserDefaultSolu(false);
            solutionInfo.setOwner(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
            QueryPanelCollection queryPanelCol = this.getQueryPanelCollection(searchFilter);
            solutionInfo.getQueryPanelInfo().addCollection(queryPanelCol);
            solutionInfo.setRowCount(-1);
            List list = this.getUserSolutionList(ctx, parentUIName);
            if (list == null || list.size() == 0) {
                solutionInfo.setIsUserDefaultSolu(true);
            } else {
                boolean hasDefault = false;
                for (Object o : list) {
                    QuerySolutionInfo sol = (QuerySolutionInfo)o;
                    if (!sol.isIsUserDefaultSolu()) continue;
                    hasDefault = true;
                    break;
                }
                if (!hasDefault) {
                    solutionInfo.setIsUserDefaultSolu(true);
                }
            }
            IQuerySolution iSolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
            IObjectPK pk = iSolution.addnew((CoreBaseInfo)solutionInfo);
            solutionInfo.setId(BOSUuid.read((String)pk.toString()));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return solutionInfo;
    }

    public QuerySolutionInfo addSolution(Context ctx, String parentUIName, String solutionName, Map searchFilter, String orgId) throws EASBizException, BOSException {
        QuerySolutionInfo solutionInfo = null;
        try {
            solutionInfo = new QuerySolutionInfo();
            solutionInfo.setName(solutionName);
            solutionInfo.setName(solutionName, new Locale("l1"));
            solutionInfo.setName(solutionName, new Locale("l3"));
            solutionInfo.setOrgID(BOSUuid.read((String)orgId));
            solutionInfo.setQueryObjectName(this.getQueryPk());
            solutionInfo.setShareType(this.getShareType());
            solutionInfo.setSolutionType(SolutionTypeEnum.CUSTOMER_SOLUTION);
            solutionInfo.setParentUIName(parentUIName);
            solutionInfo.setIsUserDefaultSolu(false);
            solutionInfo.setOwner(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
            QueryPanelCollection queryPanelCol = this.getQueryPanelCollection(searchFilter);
            solutionInfo.getQueryPanelInfo().addCollection(queryPanelCol);
            solutionInfo.setRowCount(-1);
            List list = this.getSolutionList(ctx, orgId, parentUIName);
            if (list == null || list.size() == 0) {
                solutionInfo.setIsUserDefaultSolu(true);
            } else {
                boolean hasDefault = false;
                for (Object o : list) {
                    QuerySolutionInfo sol = (QuerySolutionInfo)o;
                    if (!sol.isIsUserDefaultSolu()) continue;
                    hasDefault = true;
                    break;
                }
                if (!hasDefault) {
                    solutionInfo.setIsUserDefaultSolu(true);
                }
            }
            IQuerySolution iSolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
            IObjectPK pk = iSolution.addnew((CoreBaseInfo)solutionInfo);
            solutionInfo.setId(BOSUuid.read((String)pk.toString()));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return solutionInfo;
    }

    public void updateOtherUserDefault(Context ctx, String orgId, String currentSolutionID, String parentUIName) throws BOSException, EASBizException {
        IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo parentUIFilterItem = new FilterItemInfo("parentUIName", (Object)parentUIName);
        FilterItemInfo isUserDefaultFilterItem = new FilterItemInfo("isUserDefaultSolu", (Object)true);
        FilterItemInfo orgFilterItem = new FilterItemInfo("orgID", (Object)orgId);
        filterInfo.getFilterItems().add(parentUIFilterItem);
        filterInfo.getFilterItems().add(isUserDefaultFilterItem);
        filterInfo.getFilterItems().add(orgFilterItem);
        String maskString = " #0 and #1 and #2 ";
        filterInfo.setMaskString(maskString);
        evi.setFilter(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("isUserDefaultSolu"));
        selector.add(new SelectorItemInfo("id"));
        evi.setSelector(selector);
        QuerySolutionCollection querySolutionCollection = iQuerySolution.getQuerySolutionCollection(evi);
        QuerySolutionInfo querySolutionInfoOld = null;
        SelectorItemCollection updateSelector = new SelectorItemCollection();
        updateSelector.add(new SelectorItemInfo("isUserDefaultSolu"));
        int size = querySolutionCollection.size();
        for (int i = 0; i < size; ++i) {
            querySolutionInfoOld = querySolutionCollection.get(i);
            if (querySolutionInfoOld.getId().toString().equals(currentSolutionID)) continue;
            querySolutionInfoOld.setIsUserDefaultSolu(false);
            iQuerySolution.updatePartial((CoreBaseInfo)querySolutionInfoOld, updateSelector);
        }
    }

    public void resetDefaultSolution(Context ctx, String orgId, String parentUIName) throws BOSException, EASBizException {
        EntityViewInfo viewInfo;
        IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
        QuerySolutionCollection solutionCol = iQuerySolution.getQuerySolutionCollection(viewInfo = this.getQuerySolutionViewInfo(ctx, parentUIName, BOSUuid.read((String)orgId)));
        if (solutionCol != null && solutionCol.size() > 0) {
            int size = solutionCol.size();
            for (int i = 0; i < size; ++i) {
                QuerySolutionInfo info = solutionCol.get(i);
                if (!info.isIsUserDefaultSolu()) continue;
                return;
            }
            QuerySolutionInfo querySolutionInfoOld = solutionCol.get(0);
            querySolutionInfoOld.setIsUserDefaultSolu(true);
            SelectorItemCollection updateSelector = new SelectorItemCollection();
            updateSelector.add(new SelectorItemInfo("isUserDefaultSolu"));
            iQuerySolution.updatePartial((CoreBaseInfo)querySolutionInfoOld, updateSelector);
        }
    }

    public void resetDefaultUserSolution(Context ctx, String parentUIName) throws BOSException, EASBizException {
        EntityViewInfo viewInfo;
        IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
        QuerySolutionCollection solutionCol = iQuerySolution.getQuerySolutionCollection(viewInfo = this.getQuerySolutionViewInfo(ctx, parentUIName, null));
        if (solutionCol != null && solutionCol.size() > 0) {
            int size = solutionCol.size();
            for (int i = 0; i < size; ++i) {
                QuerySolutionInfo info = solutionCol.get(i);
                if (!info.isIsUserDefaultSolu()) continue;
                return;
            }
            QuerySolutionInfo querySolutionInfoOld = solutionCol.get(0);
            querySolutionInfoOld.setIsUserDefaultSolu(true);
            SelectorItemCollection updateSelector = new SelectorItemCollection();
            updateSelector.add(new SelectorItemInfo("isUserDefaultSolu"));
            iQuerySolution.updatePartial((CoreBaseInfo)querySolutionInfoOld, updateSelector);
        }
    }

    public QueryPanelCollection getQueryPanelCollection(Map searchFilter) throws EASBizException, BOSException {
        this.beforeSaveSolution(searchFilter);
        QueryPanelInfo queryPanelInfo = new QueryPanelInfo();
        queryPanelInfo.setPanelClassName(FILTER_PANEL_CLASS_NAME);
        FilterInfo filter = new FilterInfo();
        queryPanelInfo.setFilterInfo(filter.toString());
        queryPanelInfo.setQueryPanelType(QueryPanelTypeEnum.CUSTOMER_PANEL);
        String customerParams = "";
        if (searchFilter != null) {
            Set keys = searchFilter.keySet();
            Collection values = searchFilter.values();
            if (keys.size() > 0) {
                try {
                    customerParams = XMLBean.CreateXMLStrRecursion(keys, values);
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        queryPanelInfo.setCustomerParams(customerParams);
        QueryPanelCollection queryPanelCol = new QueryPanelCollection();
        queryPanelCol.add(queryPanelInfo);
        return queryPanelCol;
    }

    @Override
    protected List _getCompanyListByIds(Context ctx, String[] ids) throws BOSException, EASBizException {
        ArrayList<CompanyOrgUnitInfo> companyList = null;
        if (ids != null && ids.length > 0) {
            EntityViewInfo entity = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            entity.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(Arrays.asList(ids)), CompareType.INCLUDE));
            entity.getSorter().add(new SorterItemInfo("number"));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("baseCurrency.*"));
            sic.add(new SelectorItemInfo("accountTable.id"));
            sic.add(new SelectorItemInfo("accountTable.name"));
            sic.add(new SelectorItemInfo("accountTable.number"));
            entity.setSelector(sic);
            CompanyOrgUnitCollection companyCol = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(entity);
            if (companyCol != null && companyCol.size() > 0) {
                companyList = new ArrayList<CompanyOrgUnitInfo>(companyCol.size());
                for (int i = 0; i < companyCol.size(); ++i) {
                    companyList.add(companyCol.get(i));
                }
            }
        }
        return companyList;
    }

    @Override
    protected List _getCompanyListByPerm(Context ctx, String permItem) throws BOSException, EASBizException {
        ArrayList<CompanyOrgUnitInfo> companyList = null;
        LinkedList<String> idSet = new LinkedList<String>();
        IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
        FullOrgUnitCollection orgColls = permission.getAuthorizedOrg(ctx.getCaller(), OrgType.Company, null, permItem);
        orgColls.sort("number");
        for (int idx = 0; idx < orgColls.size(); ++idx) {
            FullOrgUnitInfo orgUnit = orgColls.get(idx);
            if (orgUnit == null || orgUnit.getId() == null) continue;
            idSet.add(orgUnit.getId().toString());
        }
        EntityViewInfo entity = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        entity.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        entity.getSorter().add(new SorterItemInfo("number"));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("baseCurrency.*"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("accountTable.name"));
        sic.add(new SelectorItemInfo("accountTable.number"));
        entity.setSelector(sic);
        CompanyOrgUnitCollection companyCol = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(entity);
        if (companyCol != null && companyCol.size() > 0) {
            companyList = new ArrayList<CompanyOrgUnitInfo>(companyCol.size());
            for (int i = 0; i < companyCol.size(); ++i) {
                companyList.add(companyCol.get(i));
            }
        }
        return companyList;
    }

    @Override
    protected Map _getQrySolResMap(Context ctx) throws BOSException, EASBizException {
        return JournalWebUtil.getResources(ctx, "com.kingdee.eas.fi.cas.web.CasWebResource", new String[]{"236_SOLUTION_SAVE_OK", "237_SOLUTION_SET_OK", "238_SOLUTION_DELETE_OK", "257_DEFAULT_SOLUTION", "340_HAS_SAME_SOLUTION", "259_PROCESS_QRY", "260_SAVE_SOL", "261_INPUT_SOLNAME", "262_SELECTED_ITEMS", "263_MORE", "264_CLLAPSE", "265_DELETE_SOL", "266_SET_DEFAULT", "267_SETUP", "268_COM_SOL", "207_REQUIRE_COMPANY", "269_SOL_NAME", "270_COM_ITEMS", "271_SOL_QRY", "287_DEFAULT_SOL", "403_UNFLOD", "404_PACK_UP"});
    }

    @Override
    protected Map _getSolutionFilterMap(Context ctx, String solutionId) throws BOSException, EASBizException {
        HashMap data = null;
        if (solutionId != null && solutionId.length() > 0) {
            String customerParams = null;
            QuerySolutionInfo solutionInfo = null;
            IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
            solutionInfo = iQuerySolution.getQuerySolutionInfo((IObjectPK)new ObjectUuidPK(solutionId));
            QueryPanelCollection queryPanels = solutionInfo.getQueryPanelInfo();
            for (int i0 = 0; i0 < queryPanels.size(); ++i0) {
                QueryPanelInfo info = queryPanels.get(i0);
                customerParams = info.getCustomerParams();
            }
            if (customerParams != null) {
                CustomerParams cp = CustomerParams.getCustomerParams2(customerParams);
                data = cp.getCustomerParamsHashMap();
                this.afterGetSolution(data);
            }
        }
        return data;
    }

    @Override
    protected QuerySolutionInfo _getDefaultSolution(Context ctx, String companyId, String parentUIName) throws BOSException, EASBizException {
        QuerySolutionInfo solInfo = null;
        if (companyId != null && parentUIName != null) {
            ArrayList solutions = new ArrayList();
            BOSUuid orgUuid = BOSUuid.read((String)companyId);
            try {
                EntityViewInfo viewInfo = this.getQuerySolutionViewInfo(ctx, parentUIName, orgUuid);
                IQuerySolution iSolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
                QuerySolutionCollection solutionCol = iSolution.getQuerySolutionCollection(viewInfo);
                for (int i = 0; i < solutionCol.size(); ++i) {
                    QuerySolutionInfo info = solutionCol.get(i);
                    if (info == null || !info.isIsUserDefaultSolu()) continue;
                    solInfo = info;
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return solInfo;
    }

    @Override
    protected String _saveUserSolution(Context ctx, String solutionName, String parentUIName, String filterJsonStr) throws BOSException, EASBizException {
        String userId = ctx.getCaller().toString();
        String solutionId = null;
        if (userId != null && solutionName != null && parentUIName != null && filterJsonStr != null) {
            HashMap searchFilter = JSONUtils.convertJsonToObject((Context)ctx, (String)filterJsonStr);
            QuerySolutionInfo solutionInfo = this.getSameNameUserSolution(ctx, solutionName, parentUIName);
            if (solutionInfo != null) {
                solutionId = solutionInfo.getId().toString();
                solutionInfo = this.editUserSolution(ctx, solutionId, parentUIName, solutionName, searchFilter);
            } else {
                solutionInfo = this.addUserSolution(ctx, parentUIName, solutionName, searchFilter, userId);
            }
            solutionId = solutionInfo.getId().toString();
        }
        return solutionId;
    }

    @Override
    protected List _getUserSolutionList(Context ctx, String parentUIName) throws BOSException, EASBizException {
        ArrayList<QuerySolutionInfo> solutions = new ArrayList<QuerySolutionInfo>();
        try {
            EntityViewInfo viewInfo = this.getQuerySolutionViewInfo(ctx, parentUIName, null);
            IQuerySolution iSolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
            QuerySolutionCollection solutionCol = iSolution.getQuerySolutionCollection(viewInfo);
            for (int i = 0; i < solutionCol.size(); ++i) {
                QuerySolutionInfo info = solutionCol.get(i);
                if (info.isIsUserDefaultSolu()) {
                    solutions.add(0, info);
                    continue;
                }
                solutions.add(info);
            }
            if (solutions.size() > 0 && !((QuerySolutionInfo)solutions.get(0)).isIsUserDefaultSolu()) {
                QuerySolutionInfo info = (QuerySolutionInfo)solutions.get(0);
                info.setIsUserDefaultSolu(true);
                solutions.remove(0);
                solutions.add(0, info);
                ObjectUuidPK pk = new ObjectUuidPK(info.getId());
                SelectorItemCollection updateSelector = new SelectorItemCollection();
                updateSelector.add(new SelectorItemInfo("isUserDefaultSolu"));
                iSolution.updatePartial((CoreBaseInfo)info, updateSelector);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return solutions;
    }

    @Override
    protected void _removeUserSolution(Context ctx, String parentUIName, String solutionId) throws BOSException, EASBizException {
        IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
        iQuerySolution.delete((IObjectPK)new ObjectUuidPK(solutionId));
        this.resetDefaultUserSolution(ctx, parentUIName);
    }

    protected void removeUserSolutionByName(Context ctx, String parentUIName, String solutionId) throws BOSException, EASBizException {
        IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
        iQuerySolution.delete((IObjectPK)new ObjectUuidPK(solutionId));
    }

    @Override
    protected void _setUserDefaultSolution(Context ctx, String parentUIName, String solutionId) throws BOSException, EASBizException {
        if (solutionId != null && parentUIName != null) {
            EntityViewInfo viewInfo;
            IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
            QuerySolutionCollection solutionCol = iQuerySolution.getQuerySolutionCollection(viewInfo = this.getQuerySolutionViewInfo(ctx, parentUIName, null));
            if (solutionCol != null && solutionCol.size() > 0) {
                int size = solutionCol.size();
                for (int i = 0; i < size; ++i) {
                    QuerySolutionInfo info = solutionCol.get(i);
                    if (!info.isIsUserDefaultSolu() || info.getIdentity().toString().equals(solutionId)) continue;
                    info.setIsUserDefaultSolu(false);
                    SelectorItemCollection updateSelector = new SelectorItemCollection();
                    updateSelector.add(new SelectorItemInfo("isUserDefaultSolu"));
                    iQuerySolution.updatePartial((CoreBaseInfo)info, updateSelector);
                }
            }
            QuerySolutionInfo solutionInfo = null;
            solutionInfo = iQuerySolution.getQuerySolutionInfo((IObjectPK)new ObjectUuidPK(solutionId));
            if (solutionInfo != null) {
                solutionInfo.setIsUserDefaultSolu(true);
                SelectorItemCollection updateSelector = new SelectorItemCollection();
                updateSelector.add(new SelectorItemInfo("isUserDefaultSolu"));
                iQuerySolution.updatePartial((CoreBaseInfo)solutionInfo, updateSelector);
            }
        }
    }

    @Override
    protected List _getUserSolutionListIsFilter(Context ctx, String parentUIName, String permssion) throws BOSException, EASBizException {
        ArrayList<QuerySolutionInfo> solutions = new ArrayList<QuerySolutionInfo>();
        try {
            EntityViewInfo viewInfo = this.getQuerySolutionViewInfo(ctx, parentUIName, null);
            IQuerySolution iSolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
            QuerySolutionCollection solutionCol = iSolution.getQuerySolutionCollection(viewInfo);
            Map solDetail = new HashMap();
            Map searchFilter = new HashMap();
            String company = "";
            for (int i = 0; i < solutionCol.size(); ++i) {
                boolean isPermission;
                QuerySolutionInfo info = solutionCol.get(i);
                solDetail = this.getSolutionDetail(ctx, info.getId().toString());
                searchFilter = (Map)solDetail.get("searchFilter");
                company = (String)searchFilter.get("companyId");
                if (company == null && (company = (String)searchFilter.get("companyID")).indexOf(",") > 0) {
                    company = info.getOrgID().toString();
                }
                if (!(isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(company.replaceAll("'", "")), permssion))) continue;
                if (info.isIsUserDefaultSolu()) {
                    solutions.add(0, info);
                    continue;
                }
                solutions.add(info);
            }
            if (solutions.size() > 0 && !((QuerySolutionInfo)solutions.get(0)).isIsUserDefaultSolu()) {
                QuerySolutionInfo info = (QuerySolutionInfo)solutions.get(0);
                info.setIsUserDefaultSolu(true);
                solutions.remove(0);
                solutions.add(0, info);
                ObjectUuidPK pk = new ObjectUuidPK(info.getId());
                SelectorItemCollection updateSelector = new SelectorItemCollection();
                updateSelector.add(new SelectorItemInfo("isUserDefaultSolu"));
                iSolution.updatePartial((CoreBaseInfo)info, updateSelector);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return solutions;
    }
}

