/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.app.AbstractCasWorkPlatformWebFacadeControllerBean;
import com.kingdee.eas.fi.cas.utils.BankVCUtil;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.utils.CasWorkPlatfromBankJournalTimerTask;
import com.kingdee.eas.fi.cas.utils.CasWorkPlatfromCashFlowTimerTask;
import com.kingdee.eas.fi.cas.utils.CasWorkPlatfromCashJournalUtil;
import com.kingdee.eas.fi.cas.utils.CasWorkPlatfromHelper;
import com.kingdee.eas.fi.cas.vo.WelcomePageBankVO;
import com.kingdee.eas.fi.cas.vo.WelcomePageFundRptDatasetVO;
import com.kingdee.eas.fi.cas.vo.WelcomePageFundRptVO;
import com.kingdee.eas.fi.cas.vo.WelcomePageUserOptionMainVO;
import com.kingdee.eas.fi.cas.vo.WelcomePageUserOptionVO;
import com.kingdee.eas.fm.common.IUserOption;
import com.kingdee.eas.fm.common.UserOptionCollection;
import com.kingdee.eas.fm.common.UserOptionFactory;
import com.kingdee.eas.fm.common.UserOptionInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class CasWorkPlatformWebFacadeControllerBean
extends AbstractCasWorkPlatformWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.CasWorkPlatformWebFacadeControllerBean");
    private static final String KEY_CURDATESTR = "CurDateStr";
    private static final String KEY_CURCOMPANYID = "CurCompanyID";
    private static final String KEY_CURCOMPANY = "CurCompany";
    private static final String KEY_RECPAYCHARTDATA = "RecPayChartData";
    private static final String KEY_CASHFLOWCHARTTITLE = "CashFlowChartTitle";
    private static final String KEY_CASHFLOWCHARTDATA = "CashFlowChartData";
    private static final String KEY_BANKJOURANLCURDAYLIST = "BankJouranlCurDayList";
    private static final String KEY_BANKJOURANLSHOWLIST = "BankJouranlShowList";
    private static final String KEY_BANKJOURANLUpdateTime = "BankJouranlUpdateTime";
    private static final String KEY_BANKJOURANLCURUSEROPTIONS = "BankJouranlCurUserOptions";
    private static SimpleDateFormat DATE_FM = new SimpleDateFormat("yyyy-MM-dd");
    private static BigDecimal TenThousandMoney = new BigDecimal("10000.00");
    private static final int RPType_Rec = 0;
    private static final int RPType_Pay = 1;

    @Override
    protected Map _getWelcomePageInitData(Context ctx) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getWelcomePageDataByFilter(Context ctx, String jsonstr) throws BOSException, EASBizException {
        HashMap<String, String> rstDataMap = new HashMap<String, String>();
        rstDataMap.put(KEY_CURDATESTR, DATE_FM.format(new Date()));
        if (jsonstr == null || jsonstr.length() <= 0) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "InputDataExption"));
            return rstDataMap;
        }
        try {
            CompanyOrgUnitInfo companyInfo = null;
            String filterstr = "where " + jsonstr.replaceAll("company.id", "id");
            CompanyOrgUnitCollection orgColl = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(filterstr);
            if (orgColl == null || orgColl.size() <= 0) {
                rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "InputOrgUnitIsNull"));
                return rstDataMap;
            }
            companyInfo = orgColl.get(0);
            rstDataMap.put(KEY_CURCOMPANYID, companyInfo.getId().toString());
            long dTime = System.currentTimeMillis();
            this.sub_welcomePage_CashFlowChartData(ctx, rstDataMap, companyInfo, false);
            System.out.println("sub_welcomePage_CashFlowChartData: " + (System.currentTimeMillis() - dTime));
            dTime = System.currentTimeMillis();
            this.sub_welcomePage_BankJouranlData(ctx, rstDataMap, companyInfo, false);
            System.out.println("sub_welcomePage_BankJouranlData: " + (System.currentTimeMillis() - dTime));
            dTime = System.currentTimeMillis();
            this.sub_welcomePage_BankJouranlData_OfUserOptions(ctx, rstDataMap, companyInfo);
            System.out.println("sub_welcomePage_BankJouranlData_OfUserOptions: " + (System.currentTimeMillis() - dTime));
            dTime = System.currentTimeMillis();
            this.sub_welcomePage_RecAndPayData(ctx, rstDataMap, companyInfo);
            System.out.println("sub_welcomePage_RecAndPayData: " + (System.currentTimeMillis() - dTime));
            dTime = System.currentTimeMillis();
        }
        catch (EASBizException e1) {
            rstDataMap.put("MsgStr", e1.getMessage() + ", " + e1.toString());
            e1.printStackTrace();
        }
        catch (BOSException e2) {
            rstDataMap.put("MsgStr", e2.getMessage() + ", " + e2.toString());
            e2.printStackTrace();
        }
        catch (SQLException e3) {
            rstDataMap.put("MsgStr", e3.getMessage() + ", " + e3.toString());
            e3.printStackTrace();
        }
        return rstDataMap;
    }

    @Override
    protected Map _saveUserOptionOfBankAccountShow(Context ctx, String jsonstr) throws BOSException, EASBizException {
        HashMap<String, Object> rstDataMap = new HashMap<String, Object>();
        rstDataMap.put(KEY_CURDATESTR, DATE_FM.format(new Date()));
        WelcomePageUserOptionMainVO dataMainVO = (WelcomePageUserOptionMainVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr, WelcomePageUserOptionMainVO.class);
        if (dataMainVO == null || dataMainVO.getCurCompanyID() == null) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "PleSelecedQueryFilter"));
            return rstDataMap;
        }
        String orgFilter = "where id = '" + dataMainVO.getCurCompanyID() + "' ";
        CompanyOrgUnitCollection orgColl = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(orgFilter);
        if (orgColl == null || orgColl.size() <= 0) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "InputOrgUnitIsNull"));
            return rstDataMap;
        }
        CompanyOrgUnitInfo companyInfo = orgColl.get(0);
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        IUserOption iUserOption = UserOptionFactory.getLocalInstance((Context)ctx);
        String uerOptionOql = this.sub_welcomePage_getUerOptionOql(ctx, companyInfo);
        UserOptionCollection upColl = iUserOption.getUserOptionCollection(uerOptionOql);
        UserOptionInfo uerOptionInfo = null;
        if (upColl == null || upColl.size() == 0) {
            uerOptionInfo = new UserOptionInfo();
            uerOptionInfo.setCreateDate(new Date());
            uerOptionInfo.setCreateUser(userInfo);
            uerOptionInfo.setCompany(companyInfo);
            uerOptionInfo.setOptKey("com.kingdee.eas.dynamic.web.FI_CAS_WorkPlatform_Welcome");
            uerOptionInfo.setName("hello");
        } else {
            uerOptionInfo = upColl.get(0);
            if (upColl.size() > 1) {
                ObjectUuidPK[] uuidPKs = new ObjectUuidPK[upColl.size() - 1];
                for (int idx = 1; idx < upColl.size(); ++idx) {
                    uuidPKs[idx - 1] = new ObjectUuidPK(upColl.get(idx).getId());
                }
                iUserOption.delete((IObjectPK[])uuidPKs);
            }
        }
        StringBuffer savesb = new StringBuffer();
        for (WelcomePageUserOptionVO userOption : dataMainVO.getUserOptionBanks()) {
            if (savesb.length() > 0) {
                savesb.append(";");
            }
            savesb.append(userOption.toMyString());
        }
        uerOptionInfo.setOptValue(savesb.toString());
        iUserOption.submit(uerOptionInfo, true, companyInfo.getId().toString());
        CasWorkPlatfromHelper casWorkPlatfromHelper = CasWorkPlatfromHelper.getInstance(ctx);
        List<WelcomePageBankVO> bankDataList = casWorkPlatfromHelper.getBankJournalDataList(companyInfo.getId().toString());
        List<WelcomePageBankVO> bankDataNewList = this.sub_welcomePage_BankJouranlData_Clone(bankDataList);
        Collections.sort(bankDataNewList, new Comparator<WelcomePageBankVO>(){

            @Override
            public int compare(WelcomePageBankVO o1, WelcomePageBankVO o2) {
                int key = o1.getCurDayBalanceColumn().compareTo(o2.getCurDayBalanceColumn());
                return key > 0 ? -1 : 1;
            }
        });
        this.sub_welcomePage_BankJouranlData_AddTotalRow(ctx, bankDataNewList);
        this.sub_welcomePage_BankJouranlData_ChangeWANYUAN(bankDataNewList);
        rstDataMap.put(KEY_BANKJOURANLCURDAYLIST, bankDataNewList);
        Date flagDate = casWorkPlatfromHelper.getBankJournalFinishDateMap(companyInfo.getId().toString());
        flagDate = flagDate == null ? new Date() : flagDate;
        StringBuffer showTitleSb = new StringBuffer();
        CurrencyInfo currency = CASWebHelper.getBaseCurrency(ctx, companyInfo);
        String currencyName = null;
        if (currency != null && currency.getId() != null) {
            if (currency.getName() == null) {
                SelectorItemCollection selectColl = new SelectorItemCollection();
                selectColl.add("id");
                selectColl.add("number");
                selectColl.add("name");
                currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId()), selectColl);
            }
            currencyName = currency.getName();
        }
        String[] args = new String[]{BankVCUtil.getTimeCNFormat(ctx).format(flagDate), currencyName == null ? " " : currencyName};
        showTitleSb.append(CASWebUtil.getResource(ctx, "WorkPlatform_Journal_TitleStr", args));
        rstDataMap.put(KEY_BANKJOURANLUpdateTime, showTitleSb.toString());
        this.sub_welcomePage_BankJouranlData_OfUserOptions(ctx, rstDataMap, companyInfo);
        return rstDataMap;
    }

    @Override
    protected Map _doRefreshWelcomePageByFilter(Context ctx, String jsonstr, boolean isShare) throws BOSException, EASBizException {
        HashMap<String, String> rstDataMap = new HashMap<String, String>();
        rstDataMap.put(KEY_CURDATESTR, DATE_FM.format(new Date()));
        if (jsonstr == null || jsonstr.length() <= 0) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "InputDataExption"));
            return rstDataMap;
        }
        try {
            CompanyOrgUnitInfo companyInfo = null;
            if (isShare) {
                String filterstr = "where " + jsonstr.replaceAll("company.id", "id");
                CompanyOrgUnitCollection orgColl = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(filterstr);
                if (orgColl == null || orgColl.size() <= 0) {
                    rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "InputOrgUnitIsNull"));
                    return rstDataMap;
                }
                companyInfo = orgColl.get(0);
                rstDataMap.put(KEY_CURCOMPANYID, companyInfo.getId().toString());
            } else {
                companyInfo = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
                rstDataMap.put(KEY_CURCOMPANYID, companyInfo.getId().toString());
            }
            this.sub_welcomePage_CashFlowChartData(ctx, rstDataMap, companyInfo, true);
            this.sub_welcomePage_BankJouranlData(ctx, rstDataMap, companyInfo, true);
            this.sub_welcomePage_BankJouranlData_OfUserOptions(ctx, rstDataMap, companyInfo);
            this.sub_welcomePage_RecAndPayData(ctx, rstDataMap, companyInfo);
        }
        catch (EASBizException e1) {
            rstDataMap.put("MsgStr", e1.getMessage() + ", " + e1.toString());
            e1.printStackTrace();
        }
        catch (BOSException e2) {
            rstDataMap.put("MsgStr", e2.getMessage() + ", " + e2.toString());
            e2.printStackTrace();
        }
        catch (SQLException e3) {
            rstDataMap.put("MsgStr", e3.getMessage() + ", " + e3.toString());
            e3.printStackTrace();
        }
        return rstDataMap;
    }

    private void sub_welcomePage_CashFlowChartData(Context ctx, Map rstDataMap, CompanyOrgUnitInfo company, boolean isRefresh) throws BOSException, EASBizException, SQLException {
        if (company == null || company.getId() == null) {
            return;
        }
        String curCompanyID = company.getId().toString();
        PeriodInfo curPeriod = CASWebHelper.getCurrentPeriod(ctx, company);
        if (curPeriod == null) {
            curPeriod = CasWorkPlatfromCashJournalUtil.getPeriodInfo(ctx, new Date(), company);
        }
        if (curPeriod == null) {
            rstDataMap.put("MsgStr", CASWebUtil.getResource(ctx, "PleAddPeriodOfCurCompany"));
        }
        CasWorkPlatfromHelper casWorkPlatfromHelper = CasWorkPlatfromHelper.getInstance(ctx);
        Map<String, BigDecimal[]> cashFlowSubMap = casWorkPlatfromHelper.getCashFlowDataMap(curCompanyID);
        if (isRefresh || cashFlowSubMap == null) {
            long dTime = System.currentTimeMillis();
            cashFlowSubMap = casWorkPlatfromHelper.welcomePage_CashFlowChartData(company, curPeriod);
            System.out.println("casWorkPlatfromHelper.welcomePage_CashFlowChartData: " + (System.currentTimeMillis() - dTime));
            if (cashFlowSubMap != null) {
                casWorkPlatfromHelper.setCashFlowDataMap(curCompanyID, cashFlowSubMap);
                casWorkPlatfromHelper.setCashFlowFinishDateMap(curCompanyID, new Date());
            }
        }
        Timer casWorkPlatFromTimer = CasWorkPlatfromHelper.getCasWorkPlatfromTimer();
        CasWorkPlatfromCashFlowTimerTask cashFlowTimerTask = new CasWorkPlatfromCashFlowTimerTask(ctx);
        cashFlowTimerTask.setCompanyID_Prior(curCompanyID);
        casWorkPlatFromTimer.schedule((TimerTask)cashFlowTimerTask, CasWorkPlatfromHelper.timer_firstTime);
        String[] args = new String[]{};
        Date startDate = null;
        Date endDate = null;
        if (curPeriod != null && (DateUtil.getDiffDays((Date)curPeriod.getEndDate(), (Date)new Date()) >= 0 || DateUtil.getDiffDays((Date)new Date(), (Date)curPeriod.getBeginDate()) >= 0)) {
            startDate = curPeriod.getBeginDate();
            endDate = curPeriod.getEndDate();
            args = new String[]{String.valueOf(curPeriod.getPeriodYear()), String.valueOf(curPeriod.getPeriodNumber())};
        } else {
            startDate = DateUtil.getFirstDayOfCurMonth();
            endDate = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(endDate);
            args = new String[]{String.valueOf(calendar.get(1)), String.valueOf(calendar.get(2) + 1)};
        }
        WelcomePageFundRptVO fundRptVO = new WelcomePageFundRptVO(ctx, true, startDate, endDate);
        String cashFlowTitle = CASWebUtil.getResource(ctx, "WorkPlatform_CashFlowChartName", args);
        fundRptVO.getChart().setCaption("");
        rstDataMap.put(KEY_CASHFLOWCHARTTITLE, cashFlowTitle);
        if (cashFlowSubMap == null) {
            rstDataMap.put(KEY_CASHFLOWCHARTDATA, fundRptVO);
            return;
        }
        int dateDiff = DateUtil.getDiffDays((Date)startDate, (Date)endDate) + 1;
        BigDecimal[] totals = new BigDecimal[]{SysConstant.BIGZERO, SysConstant.BIGZERO, SysConstant.BIGZERO};
        String keyStr = null;
        for (int idx = 0; idx < dateDiff; ++idx) {
            if (idx == 0) {
                keyStr = "xxxx-xx-00";
                fundRptVO.getDataset().get(0).getData().clear();
                fundRptVO.getDataset().get(1).getData().clear();
                fundRptVO.getDataset().get(2).getData().clear();
            } else {
                Date curDate = DateUtil.getNextDay((Date)startDate, (int)(idx - 1));
                keyStr = CasWorkPlatfromHelper.DATE_FM_KEY.format(curDate);
            }
            BigDecimal[] cashFlowArrays = cashFlowSubMap.get(keyStr);
            if (cashFlowArrays == null) continue;
            BigDecimal[] newCashArrays = new BigDecimal[cashFlowArrays.length];
            for (int min = 0; min < cashFlowArrays.length; ++min) {
                BigDecimal cashVal = cashFlowArrays[min];
                newCashArrays[min] = cashVal = cashVal.divide(TenThousandMoney, 5, RoundingMode.HALF_EVEN);
            }
            BigDecimal incomeVal = newCashArrays[0];
            this._welcomePage_CashFlowChartData_AddVO(fundRptVO, totals, incomeVal, 0, idx, true);
            BigDecimal expendVal = newCashArrays[1];
            this._welcomePage_CashFlowChartData_AddVO(fundRptVO, totals, expendVal, 1, idx, true);
            BigDecimal balanceVal = newCashArrays[2];
            this._welcomePage_CashFlowChartData_AddVO(fundRptVO, totals, balanceVal, 2, idx, false);
        }
        this._welcomePage_CashFlowChart_DoReplenish(fundRptVO, totals, 0, true, dateDiff);
        this._welcomePage_CashFlowChart_DoReplenish(fundRptVO, totals, 1, true, dateDiff);
        this._welcomePage_CashFlowChart_DoReplenish(fundRptVO, totals, 2, false, dateDiff);
        rstDataMap.put(KEY_CASHFLOWCHARTDATA, fundRptVO);
    }

    private void sub_welcomePage_CashFlowChart_ToolText(Context ctx, WelcomePageFundRptVO fundRptVO) {
        int idx;
        String title;
        String toolText;
        String valueStr;
        BigDecimal value;
        int dataSize;
        if (fundRptVO == null || fundRptVO.getDataset() == null || fundRptVO.getDataset().size() == 0) {
            return;
        }
        DecimalFormat decimalFormat = new DecimalFormat("#,##0.00");
        int dataSetCount = fundRptVO.getDataset().size();
        if (0 < dataSetCount) {
            dataSize = fundRptVO.getDataset().get(0).getData().size();
            value = null;
            valueStr = null;
            toolText = null;
            title = CASWebUtil.getResource(ctx, "WorkPlatform_Receipt");
            for (idx = 0; idx < dataSize; ++idx) {
                value = fundRptVO.getDataset().get(0).getData().get(idx).getValue();
                valueStr = decimalFormat.format(value.doubleValue());
                toolText = idx == 0 ? "  " : CASWebUtil.getResource(ctx, "WorkPlatform_CashFlowChart_ToolText", new String[]{idx + "", title, valueStr});
                fundRptVO.getDataset().get(0).getData().get(idx).setToolText(toolText);
            }
        }
        if (1 < dataSetCount) {
            dataSize = fundRptVO.getDataset().get(1).getData().size();
            value = null;
            valueStr = null;
            toolText = null;
            title = CASWebUtil.getResource(ctx, "WorkPlatform_Payment");
            for (idx = 0; idx < dataSize; ++idx) {
                value = fundRptVO.getDataset().get(1).getData().get(idx).getValue();
                valueStr = decimalFormat.format(value.doubleValue());
                toolText = idx == 0 ? "  " : CASWebUtil.getResource(ctx, "WorkPlatform_CashFlowChart_ToolText", new String[]{idx + "", title, valueStr});
                fundRptVO.getDataset().get(1).getData().get(idx).setToolText(toolText);
            }
        }
        if (2 < dataSetCount) {
            dataSize = fundRptVO.getDataset().get(2).getData().size();
            value = null;
            valueStr = null;
            toolText = null;
            title = CASWebUtil.getResource(ctx, "WorkPlatform_Balance");
            for (idx = 0; idx < dataSize; ++idx) {
                value = fundRptVO.getDataset().get(2).getData().get(idx).getValue();
                valueStr = decimalFormat.format(value.doubleValue());
                toolText = idx == 0 ? CASWebUtil.getResource(ctx, "WorkPlatform_CashFlowChart_ToolText0", new String[]{title, valueStr}) : CASWebUtil.getResource(ctx, "WorkPlatform_CashFlowChart_ToolText", new String[]{idx + "", title, valueStr});
                fundRptVO.getDataset().get(2).getData().get(idx).setToolText(toolText);
            }
        }
    }

    private void _welcomePage_CashFlowChart_DoReplenish(WelcomePageFundRptVO fundRptVO, BigDecimal[] totals, int flagIdx, boolean isRepZero, int maxLength) {
        int curCount = fundRptVO.getDataset().get(flagIdx).getData().size();
        if (curCount > 0 && curCount < maxLength) {
            BigDecimal doAddVal = isRepZero ? SysConstant.BIGZERO : fundRptVO.getDataset().get(flagIdx).getData().get(curCount - 1).getValue();
            int doAddCount = maxLength - curCount;
            for (int idx = 0; idx < doAddCount; ++idx) {
                this._welcomePage_CashFlowChartData_AddVO(fundRptVO, totals, doAddVal, flagIdx, curCount + idx, false);
            }
        }
    }

    private void _welcomePage_CashFlowChartData_AddVO(WelcomePageFundRptVO fundRptVO, BigDecimal[] totals, BigDecimal curVal, int subIdx, int axisPosition, boolean isRepZero) {
        WelcomePageFundRptDatasetVO welcomePageFundRptDatasetVO = fundRptVO.getDataset().get(subIdx);
        welcomePageFundRptDatasetVO.getClass();
        WelcomePageFundRptDatasetVO.WelcomePageFundRptDataset_DataVO recDataVO = new WelcomePageFundRptDatasetVO.WelcomePageFundRptDataset_DataVO(welcomePageFundRptDatasetVO, curVal);
        int curDataSize = fundRptVO.getDataset().get(subIdx).getData().size();
        if (axisPosition > curDataSize) {
            int addSize = axisPosition - curDataSize;
            BigDecimal insetRefVal = curVal;
            insetRefVal = isRepZero || curDataSize <= 0 ? SysConstant.BIGZERO : fundRptVO.getDataset().get(subIdx).getData().get(curDataSize - 1).getValue();
            for (int pp = 0; pp < addSize; ++pp) {
                WelcomePageFundRptDatasetVO welcomePageFundRptDatasetVO2 = fundRptVO.getDataset().get(subIdx);
                welcomePageFundRptDatasetVO2.getClass();
                WelcomePageFundRptDatasetVO.WelcomePageFundRptDataset_DataVO subDataVO = new WelcomePageFundRptDatasetVO.WelcomePageFundRptDataset_DataVO(welcomePageFundRptDatasetVO2, insetRefVal);
                fundRptVO.getDataset().get(subIdx).getData().add(subDataVO);
                totals[subIdx] = totals[subIdx].add(insetRefVal);
            }
        }
        fundRptVO.getDataset().get(subIdx).getData().add(recDataVO);
        totals[subIdx] = totals[subIdx].add(curVal);
    }

    private void sub_welcomePage_BankJouranlData(Context ctx, Map rstDataMap, CompanyOrgUnitInfo company, boolean isRefresh) throws BOSException, EASBizException, SQLException {
        if (company == null || company.getId() == null) {
            return;
        }
        String curCompanyID = company.getId().toString();
        CasWorkPlatfromHelper casWorkPlatfromHelper = CasWorkPlatfromHelper.getInstance(ctx);
        List<WelcomePageBankVO> bankDataList = casWorkPlatfromHelper.getBankJournalDataList(curCompanyID);
        if (isRefresh || bankDataList == null) {
            bankDataList = casWorkPlatfromHelper.welcomePage_BankJouranlData(company);
            casWorkPlatfromHelper.setBankJournalDataList(curCompanyID, bankDataList);
            casWorkPlatfromHelper.setBankJournalFinishDateMap(curCompanyID, new Date());
        }
        Timer casWorkPlatFromTimer = CasWorkPlatfromHelper.getCasWorkPlatfromTimer();
        CasWorkPlatfromBankJournalTimerTask bankJournalTimerTask = new CasWorkPlatfromBankJournalTimerTask(ctx);
        bankJournalTimerTask.setCompanyID_Prior(curCompanyID);
        casWorkPlatFromTimer.schedule((TimerTask)bankJournalTimerTask, CasWorkPlatfromHelper.timer_firstTime);
        List<WelcomePageBankVO> bankDataNewList = this.sub_welcomePage_BankJouranlData_Clone(bankDataList);
        Collections.sort(bankDataNewList, new Comparator<WelcomePageBankVO>(){

            @Override
            public int compare(WelcomePageBankVO o1, WelcomePageBankVO o2) {
                int key = o1.getCurDayBalanceColumn().compareTo(o2.getCurDayBalanceColumn());
                if (key > 0) {
                    return -1;
                }
                if (key < 0) {
                    return 1;
                }
                return 0;
            }
        });
        this.sub_welcomePage_BankJouranlData_AddTotalRow(ctx, bankDataNewList);
        this.sub_welcomePage_BankJouranlData_ChangeWANYUAN(bankDataNewList);
        rstDataMap.put(KEY_BANKJOURANLCURDAYLIST, bankDataNewList);
        Date flagDate = casWorkPlatfromHelper.getBankJournalFinishDateMap(curCompanyID);
        flagDate = flagDate == null ? new Date() : flagDate;
        StringBuffer showTitleSb = new StringBuffer();
        CurrencyInfo currency = CASWebHelper.getBaseCurrency(ctx, company);
        String currencyName = null;
        if (currency != null && currency.getId() != null) {
            if (currency.getName() == null) {
                SelectorItemCollection selectColl = new SelectorItemCollection();
                selectColl.add("id");
                selectColl.add("number");
                selectColl.add("name");
                currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId()), selectColl);
            }
            currencyName = currency.getName();
        }
        String[] args = new String[]{BankVCUtil.getTimeCNFormat(ctx).format(flagDate), currencyName == null ? " " : currencyName};
        showTitleSb.append(CASWebUtil.getResource(ctx, "WorkPlatform_Journal_TitleStr", args));
        rstDataMap.put(KEY_BANKJOURANLUpdateTime, showTitleSb.toString());
    }

    private void sub_welcomePage_BankJouranlData_AddTotalRow(Context ctx, List<WelcomePageBankVO> bankDataList) {
        WelcomePageBankVO totalVO = new WelcomePageBankVO();
        totalVO.setIsTotal(Boolean.TRUE);
        String AMOUNTTOTAL = EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"Outstanding_Amount", (Locale)ctx.getLocale());
        totalVO.setAccountBankColumn(AMOUNTTOTAL);
        totalVO.setCurDayBalanceColumn(SysConstant.BIGZERO);
        BigDecimal totalMoney = totalVO.getCurDayBalanceColumn();
        for (WelcomePageBankVO bankVO : bankDataList) {
            totalMoney = totalMoney.add(bankVO.getCurDayBalanceColumn());
        }
        totalVO.setCurDayBalanceColumn(totalMoney);
        totalVO.setId("idIsNull_forTotalRow");
        bankDataList.add(0, totalVO);
    }

    private List<WelcomePageBankVO> sub_welcomePage_BankJouranlData_Clone(List<WelcomePageBankVO> bankDataList) {
        ArrayList<WelcomePageBankVO> bankDataNewList = new ArrayList<WelcomePageBankVO>();
        for (WelcomePageBankVO bankVO : bankDataList) {
            bankDataNewList.add(bankVO.Clone());
        }
        return bankDataNewList;
    }

    private void sub_welcomePage_BankJouranlData_ChangeWANYUAN(List<WelcomePageBankVO> bankDataList) {
        BigDecimal tmpMoney = SysConstant.BIGZERO;
        for (WelcomePageBankVO bankVO : bankDataList) {
            tmpMoney = bankVO.getCurDayBalanceColumn();
            if (SysConstant.BIGZERO.compareTo(tmpMoney) < 0) {
                tmpMoney = tmpMoney.divide(TenThousandMoney, 5, RoundingMode.HALF_EVEN);
            }
            bankVO.setCurDayBalanceColumn(tmpMoney);
        }
    }

    private void sub_welcomePage_BankJouranlData_ConvertWANYUAN(List<WelcomePageBankVO> bankDataList) {
        BigDecimal tmpMoney = SysConstant.BIGZERO;
        for (WelcomePageBankVO bankVO : bankDataList) {
            tmpMoney = bankVO.getCurDayBalanceColumn();
            tmpMoney = tmpMoney.divide(TenThousandMoney, 5, RoundingMode.HALF_EVEN).setScale(4, 4);
            bankVO.setCurDayBalanceColumn(tmpMoney);
        }
    }

    private void sub_welcomePage_BankJouranlData_OfUserOptions(Context ctx, Map rstDataMap, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        String queryOql;
        if (company == null || company.getId() == null) {
            return;
        }
        IUserOption iUserOption = UserOptionFactory.getLocalInstance((Context)ctx);
        UserOptionCollection userOptionColls = iUserOption.getUserOptionCollection(queryOql = this.sub_welcomePage_getUerOptionOql(ctx, company));
        if (userOptionColls == null || userOptionColls.size() <= 0) {
            return;
        }
        ArrayList<WelcomePageUserOptionVO> wpUserOptionVOs = new ArrayList<WelcomePageUserOptionVO>();
        String userOptionStr = userOptionColls.get(0).getOptValue();
        String[] userOptionArray = userOptionStr.split(";");
        for (int idx = 0; idx < userOptionArray.length; ++idx) {
            WelcomePageUserOptionVO uerOptionVO = new WelcomePageUserOptionVO(userOptionArray[idx]);
            wpUserOptionVOs.add(uerOptionVO);
        }
        Collections.sort(wpUserOptionVOs, new Comparator<WelcomePageUserOptionVO>(){

            @Override
            public int compare(WelcomePageUserOptionVO o1, WelcomePageUserOptionVO o2) {
                int key = o1.getOrder() - o2.getOrder();
                return key > 0 ? 1 : -1;
            }
        });
        rstDataMap.put(KEY_BANKJOURANLCURUSEROPTIONS, wpUserOptionVOs);
        if (wpUserOptionVOs.size() > 0) {
            CasWorkPlatfromHelper casWorkPlatfromHelper = CasWorkPlatfromHelper.getInstance(ctx);
            List<WelcomePageBankVO> bankDataList = casWorkPlatfromHelper.getBankJournalDataList(company.getId().toString());
            List<WelcomePageBankVO> bankDataNewList = this.sub_welcomePage_BankJouranlData_Clone(bankDataList);
            ArrayList<WelcomePageBankVO> bankDataShowList = new ArrayList<WelcomePageBankVO>();
            for (WelcomePageUserOptionVO uerOptionVO : wpUserOptionVOs) {
                if (uerOptionVO == null || uerOptionVO.getBankAccountID() == null) continue;
                for (WelcomePageBankVO bankVO : bankDataNewList) {
                    if (bankVO == null || bankVO.getAccountBankId() == null || !uerOptionVO.getBankAccountID().equals(bankVO.getAccountBankId())) continue;
                    bankDataShowList.add(bankVO);
                }
            }
            this.sub_welcomePage_BankJouranlData_AddTotalRow(ctx, bankDataShowList);
            this.sub_welcomePage_BankJouranlData_ConvertWANYUAN(bankDataShowList);
            rstDataMap.put(KEY_BANKJOURANLSHOWLIST, bankDataShowList);
        }
    }

    private String sub_welcomePage_getUerOptionOql(Context ctx, CompanyOrgUnitInfo companyInfo) {
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        StringBuffer oqlsb = new StringBuffer().append("where createUser.id = '").append(userInfo.getId()).append("' and company.id = '").append(companyInfo.getId()).append("' and optKey = '").append("com.kingdee.eas.dynamic.web.FI_CAS_WorkPlatform_Welcome").append("' and name = '").append("hello").append("' ");
        return oqlsb.toString();
    }

    private void sub_welcomePage_RecAndPayData(Context ctx, Map rstDataMap, CompanyOrgUnitInfo orgInfo) throws BOSException {
        String companyId = orgInfo.getId().toString();
        ArrayList<Integer> rstBillCounts = new ArrayList<Integer>();
        int recSubmit = this.sub_recPay_getRecPayCount(ctx, companyId, 10, 0);
        rstBillCounts.add(recSubmit);
        int recAudit = this.sub_recPay_getRecPayCount(ctx, companyId, 11, 0);
        rstBillCounts.add(recAudit);
        int recRecVieing = this.sub_recPay_getRecPayCount(ctx, companyId, 12, 0);
        rstBillCounts.add(recRecVieing);
        int paySubmit = this.sub_recPay_getRecPayCount(ctx, companyId, 10, 1);
        rstBillCounts.add(paySubmit);
        int payAudit = this.sub_recPay_getRecPayCount(ctx, companyId, 11, 1);
        rstBillCounts.add(payAudit);
        int payPaymenting = this.sub_recPay_getRecPayCount(ctx, companyId, 12, 1);
        rstBillCounts.add(payPaymenting);
        rstDataMap.put(KEY_RECPAYCHARTDATA, rstBillCounts);
    }

    private int sub_recPay_getRecPayCount(Context ctx, String companyId, int billStatus, int recPayType) throws BOSException {
        int count = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT count(*) ");
        if (recPayType == 0) {
            sql.append("FROM T_CAS_ReceivingBill bizTbl ");
        } else {
            sql.append("from T_CAS_PaymentBill bizTbl ");
        }
        sql.append("INNER JOIN T_ORG_Company orgTbl ON bizTbl.FCOMPANYID = orgTbl.FID ");
        sql.append("INNER JOIN T_PM_User userTbl ON bizTbl.FCreatorID = userTbl.FID ");
        sql.append("WHERE bizTbl.FIsInitializeBill = 0 ");
        sql.append("AND orgTbl.FID = ? ");
        sql.append("AND bizTbl.FBillStatus = ? ");
        if (recPayType == 1) {
            sql.append("AND bizTbl.FISCBPAY = 0 ");
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Object[] params = new Object[]{companyId, billStatus};
        logger.debug((Object)sql.toString());
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            rowSet.next();
            count = rowSet.getInt(1);
        }
        catch (SQLException e) {
            logger.debug((Object)e.getMessage());
            e.printStackTrace();
        }
        return count;
    }
}

