/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodException;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.master.account.IAccountTable;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGCollection;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeSysEnum;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.AccountTypeEnum;
import com.kingdee.eas.fi.cas.CapitalTypeEnum;
import com.kingdee.eas.fi.cas.CasContrastGLInfo;
import com.kingdee.eas.fi.cas.CasDataException;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.CashDataSourceEnum;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.CashFetchDataParam;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fi.cas.ICashManagement;
import com.kingdee.eas.fi.cas.app.AbstractCashBankContrastGLControllerBean;
import com.kingdee.eas.fi.gl.AssistBalanceCollection;
import com.kingdee.eas.fi.gl.AssistBalanceFactory;
import com.kingdee.eas.fi.gl.AssistBalanceInfo;
import com.kingdee.eas.fi.gl.IAssistBalance;
import com.kingdee.eas.fi.gl.IInitAssistBalance;
import com.kingdee.eas.fi.gl.InitAssistBalanceCollection;
import com.kingdee.eas.fi.gl.InitAssistBalanceFactory;
import com.kingdee.eas.fi.gl.InitAssistBalanceInfo;
import com.kingdee.eas.fi.rpt.BalanceTypeEnum;
import com.kingdee.eas.fi.rpt.IReportCacl;
import com.kingdee.eas.fi.rpt.ReportCaclFactory;
import com.kingdee.eas.fi.rpt.VoucherGetTypeEnum;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmSysStatusCtrlUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CashBankContrastGLControllerBean
extends AbstractCashBankContrastGLControllerBean {
    private static Logger logger = Logger.getLogger((String)CashBankContrastGLControllerBean.class.getName());
    private static final BigDecimal ZERO = new BigDecimal("0.00");

    @Override
    protected Map _getDayData(Context ctx, EntityViewInfo view) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getPeriodData(Context ctx, EntityViewInfo view) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getYearData(Context ctx, EntityViewInfo view) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getCasContrastGLData(Context ctx, CapitalTypeEnum capitalType, String accountNum, String bankAcctNum, String currencyNum, Date beginDate, Date endDate, IObjectValue period, boolean unTranVoucher, String companyid) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = this.getCompanyInfo(ctx, companyid);
        String acctTableId = companyInfo.getAccountTable().getId().toString();
        if (period != null) {
            PeriodInfo periodInfo = (PeriodInfo)period;
            acctTableId = AccountTools.getCurrentAcctTable((Context)ctx, (String)companyInfo.getId().toString(), (String)companyInfo.getAccountTable().getId().toString(), (int)periodInfo.getPeriodYear(), (int)periodInfo.getPeriodNumber());
        } else {
            acctTableId = FMHelper.getActualAcctTable((Context)ctx, (String)companyInfo.getId().toString(), (Date)beginDate, (Date)endDate);
        }
        IAccountTable iAcctTable = AccountTableFactory.getLocalInstance((Context)ctx);
        AccountTableInfo acctTableInfo = iAcctTable.getAccountTableInfo((IObjectPK)new ObjectUuidPK(acctTableId));
        return this.getCasContrastGLData(ctx, capitalType, accountNum, bankAcctNum, currencyNum, beginDate, endDate, companyInfo, acctTableInfo, period, unTranVoucher);
    }

    private Map getCasContrastGLData(Context ctx, CapitalTypeEnum capitalType, String accountNum, String bankAcctNum, String currencyNum, Date beginDate, Date endDate, CompanyOrgUnitInfo companyInfo, AccountTableInfo acctTableInfo, IObjectValue period, boolean unTranVoucher) throws BOSException, EASBizException {
        boolean isYear = false;
        boolean isReturnNull = false;
        if (this.isYearBalance(beginDate, endDate)) {
            isYear = true;
        }
        HashMap<String, CasContrastGLInfo> hashMap = new HashMap<String, CasContrastGLInfo>();
        String companyNum = companyInfo.getNumber();
        String acctTableNum = acctTableInfo.getNumber();
        String acctBankId = this.getBankAcctId(ctx, bankAcctNum, companyInfo.getId().toString());
        CasContrastGLInfo byGLInfo = this.getGLData(ctx, capitalType, accountNum, bankAcctNum, currencyNum, beginDate, endDate, companyInfo, acctTableInfo, period, unTranVoucher, companyNum, isYear, isReturnNull, acctTableNum, acctBankId);
        hashMap.put("byGL", byGLInfo);
        CasContrastGLInfo byCASInfo = new CasContrastGLInfo();
        CasContrastGLInfo byDiffInfo = new CasContrastGLInfo();
        BigDecimal tmpAmt = byGLInfo.getBeginBalance();
        CashDataSourceEnum dataSource = null;
        CashDataTypeEnum dataType = null;
        Date casBeginDate = beginDate;
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (isYear && periodInfo.getBeginDate().after(beginDate)) {
            casBeginDate = periodInfo.getBeginDate();
        }
        if (capitalType.equals((Object)CapitalTypeEnum.BANK)) {
            dataSource = CashDataSourceEnum.B;
        } else if (capitalType.equals((Object)CapitalTypeEnum.CASH)) {
            dataSource = CashDataSourceEnum.C;
        }
        dataType = CashDataTypeEnum.C;
        String acctViewId = null;
        CurrencyInfo currency = this.getCurrency(ctx, currencyNum);
        String currencyId = currency.getId().toString();
        Set companyIdSet = CashHelper.getCompanyIds(ctx, companyNum);
        if (companyIdSet == null) {
            throw new CasDataException(CasDataException.NULL_COMPANY);
        }
        Set acctBankIdSet = CashHelper.getBankAcctIds(ctx, companyNum, bankAcctNum, false);
        Map startPeriodMap = FmSysStatusCtrlUtils.getStartPeriod((Context)ctx, (int)7, (Set)companyIdSet);
        Map currentPeriodMap = FmSysStatusCtrlUtils.getCurrentPeriod((Context)ctx, (int)7, (Set)companyIdSet);
        BigDecimal beginBalance = ZERO;
        BigDecimal endBalance = ZERO;
        BigDecimal debitAmt = ZERO;
        BigDecimal creditAmt = ZERO;
        PeriodInfo calculatePeriod = (PeriodInfo)period;
        if (isYear && periodInfo.getBeginDate().getYear() == beginDate.getYear()) {
            acctViewId = this.getAccountId(ctx, acctTableNum, companyInfo.getId().toString(), dataSource, accountNum);
            beginBalance = this.getCASYearStartAmount(ctx, dataSource, companyInfo.getId().toString(), acctViewId, acctBankId, currencyId, CashDataTypeEnum.Y);
        } else {
            beginBalance = this.getCASData(ctx, companyIdSet, dataSource, acctTableNum, accountNum, acctBankIdSet, currency, beginDate, beginDate, dataType, startPeriodMap, currentPeriodMap, calculatePeriod);
        }
        tmpAmt = beginBalance.subtract(tmpAmt);
        byDiffInfo.setBeginBalance(tmpAmt);
        dataType = CashDataTypeEnum.JF;
        tmpAmt = byGLInfo.getDebitAmount();
        debitAmt = this.getCASData(ctx, companyIdSet, dataSource, acctTableNum, accountNum, acctBankIdSet, currency, casBeginDate, endDate, dataType, startPeriodMap, currentPeriodMap, calculatePeriod);
        if (isYear && periodInfo.getBeginDate().getYear() == beginDate.getYear()) {
            BigDecimal yearDebitAmt = this.getCASYearStartAmount(ctx, dataSource, companyInfo.getId().toString(), acctViewId, acctBankId, currencyId, CashDataTypeEnum.JF);
            debitAmt = debitAmt.add(yearDebitAmt);
        }
        tmpAmt = debitAmt.subtract(tmpAmt);
        byDiffInfo.setDebitAmount(tmpAmt);
        dataType = CashDataTypeEnum.DF;
        tmpAmt = byGLInfo.getCreditAmount();
        creditAmt = this.getCASData(ctx, companyIdSet, dataSource, acctTableNum, accountNum, acctBankIdSet, currency, casBeginDate, endDate, dataType, startPeriodMap, currentPeriodMap, calculatePeriod);
        if (isYear && periodInfo.getBeginDate().getYear() == beginDate.getYear()) {
            BigDecimal yearCreditAmt = this.getCASYearStartAmount(ctx, dataSource, companyInfo.getId().toString(), acctViewId, acctBankId, currencyId, CashDataTypeEnum.DF);
            creditAmt = creditAmt.add(yearCreditAmt);
        }
        tmpAmt = creditAmt.subtract(tmpAmt);
        byDiffInfo.setCreditAmount(tmpAmt);
        tmpAmt = byGLInfo.getEndBalance();
        endBalance = beginBalance.add(debitAmt).subtract(creditAmt);
        tmpAmt = endBalance.subtract(tmpAmt);
        byDiffInfo.setEndBalance(tmpAmt);
        byCASInfo.setBeginBalance(beginBalance);
        byCASInfo.setEndBalance(endBalance);
        byCASInfo.setDebitAmount(debitAmt);
        byCASInfo.setCreditAmount(creditAmt);
        hashMap.put("byCAS", byCASInfo);
        hashMap.put("byDiff", byDiffInfo);
        CasContrastGLInfo byBALInfo = new CasContrastGLInfo();
        beginBalance = ZERO;
        endBalance = ZERO;
        debitAmt = ZERO;
        creditAmt = ZERO;
        if (capitalType.equals((Object)CapitalTypeEnum.BANK)) {
            dataSource = CashDataSourceEnum.R;
        } else if (capitalType.equals((Object)CapitalTypeEnum.CASH)) {
            dataSource = CashDataSourceEnum.S;
        }
        dataType = CashDataTypeEnum.C;
        if (calculatePeriod.getPeriodNumber() == 13) {
            dataType = CashDataTypeEnum.Y;
        }
        if (capitalType.equals((Object)CapitalTypeEnum.CASH)) {
            beginBalance = this.getCASData(ctx, companyIdSet, dataSource, acctTableNum, accountNum, acctBankIdSet, currency, casBeginDate, casBeginDate, dataType, startPeriodMap, currentPeriodMap, calculatePeriod);
        } else if (isYear && capitalType.equals((Object)CapitalTypeEnum.BANK) && periodInfo.getBeginDate().getYear() == beginDate.getYear()) {
            acctViewId = this.getAccountId(ctx, acctTableNum, companyInfo.getId().toString(), dataSource, accountNum);
            beginBalance = this.getCASYearStartAmount(ctx, dataSource, companyInfo.getId().toString(), acctViewId, acctBankId, currencyId, CashDataTypeEnum.Y);
        } else {
            beginBalance = this.getCASData(ctx, companyIdSet, dataSource, acctTableNum, accountNum, acctBankIdSet, currency, beginDate, beginDate, dataType, startPeriodMap, currentPeriodMap, calculatePeriod);
        }
        if (capitalType.equals((Object)CapitalTypeEnum.BANK)) {
            dataType = CashDataTypeEnum.JF;
            debitAmt = this.getCASData(ctx, companyIdSet, dataSource, acctTableNum, accountNum, acctBankIdSet, currency, casBeginDate, endDate, dataType, startPeriodMap, currentPeriodMap, calculatePeriod);
            if (isYear && periodInfo.getBeginDate().getYear() == beginDate.getYear()) {
                BigDecimal yearDebitAmt = this.getCASYearStartAmount(ctx, dataSource, companyInfo.getId().toString(), acctViewId, acctBankId, currencyId, CashDataTypeEnum.JF);
                debitAmt = debitAmt.add(yearDebitAmt);
            }
        }
        if (capitalType.equals((Object)CapitalTypeEnum.BANK)) {
            dataType = CashDataTypeEnum.DF;
            creditAmt = this.getCASData(ctx, companyIdSet, dataSource, acctTableNum, accountNum, acctBankIdSet, currency, casBeginDate, endDate, dataType, startPeriodMap, currentPeriodMap, calculatePeriod);
            if (isYear && periodInfo.getBeginDate().getYear() == beginDate.getYear()) {
                BigDecimal yearCreditAmt = this.getCASYearStartAmount(ctx, dataSource, companyInfo.getId().toString(), acctViewId, acctBankId, currencyId, CashDataTypeEnum.DF);
                creditAmt = creditAmt.add(yearCreditAmt);
            }
        }
        byBALInfo.setBeginBalance(beginBalance);
        if (capitalType.equals((Object)CapitalTypeEnum.CASH)) {
            endBalance = this.getCASData(ctx, companyIdSet, dataSource, acctTableNum, accountNum, acctBankIdSet, currency, beginDate, endDate, CashDataTypeEnum.Y, startPeriodMap, currentPeriodMap, calculatePeriod);
        } else if (isYear && periodInfo.getBeginDate().getYear() == beginDate.getYear()) {
            dataType = CashDataTypeEnum.Y;
            endBalance = this.getCASData(ctx, companyIdSet, dataSource, acctTableNum, accountNum, acctBankIdSet, currency, beginDate, endDate, CashDataTypeEnum.Y, startPeriodMap, currentPeriodMap, calculatePeriod);
        } else {
            endBalance = beginBalance.subtract(debitAmt).add(creditAmt);
        }
        byBALInfo.setEndBalance(endBalance);
        byBALInfo.setDebitAmount(debitAmt);
        byBALInfo.setCreditAmount(creditAmt);
        hashMap.put("byBal", byBALInfo);
        return hashMap;
    }

    private CasContrastGLInfo getGLData(Context ctx, CapitalTypeEnum capitalType, String accountNum, String bankAcctNum, String currencyNum, Date beginDate, Date endDate, CompanyOrgUnitInfo companyInfo, AccountTableInfo acctTableInfo, IObjectValue period, boolean unTranVoucher, String companyNum, boolean isYear, boolean isReturnNull, String acctTableNum, String acctBankId) throws EASBizException, BOSException {
        CasContrastGLInfo byGLInfo = new CasContrastGLInfo();
        BalanceTypeEnum beginBalType = BalanceTypeEnum.C;
        BalanceTypeEnum endBalType = BalanceTypeEnum.Y;
        BalanceTypeEnum debitType = BalanceTypeEnum.JF;
        BalanceTypeEnum creditType = BalanceTypeEnum.DF;
        BigDecimal beginBalance = ZERO;
        BigDecimal endBalance = ZERO;
        BigDecimal debitAmt = ZERO;
        BigDecimal creditAmt = ZERO;
        boolean fGLStart = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)companyInfo);
        if (fGLStart) {
            PeriodInfo glCurrPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)companyInfo);
            PeriodInfo glStartPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)companyInfo);
            Date glEndDate = endDate;
            Date glBeginDate = beginDate;
            boolean isGLOver = false;
            if (endDate.after(glCurrPeriod.getEndDate())) {
                glEndDate = glCurrPeriod.getEndDate();
                if (!isYear && !beginDate.equals(endDate)) {
                    glBeginDate = glCurrPeriod.getBeginDate();
                }
                isGLOver = true;
                if (isYear && glStartPeriod.getBeginDate().getYear() == glEndDate.getYear()) {
                    glBeginDate = glStartPeriod.getBeginDate();
                }
            }
            if (isYear && glStartPeriod.getBeginDate().getYear() == beginDate.getYear()) {
                glBeginDate = glStartPeriod.getBeginDate();
            }
            PeriodInfo calculatePeriod = (PeriodInfo)period;
            boolean isNotGetAssis = true;
            String acctViewId = null;
            if (capitalType.equals((Object)CapitalTypeEnum.BANK)) {
                acctViewId = this.getAccountId(ctx, acctTableNum, companyInfo.getId().toString(), CashDataSourceEnum.B, accountNum);
                AccountViewInfo acctViewInfo = this.getAcctViewInfoById(ctx, acctViewId);
                if (acctViewInfo == null) {
                    throw new CasException(CasException.ACCTBANKACCTNULL, new Object[]{bankAcctNum});
                }
                if (acctViewInfo.getGAA() != null || acctViewInfo.getCAA() != null) {
                    AsstAccountInfo asstAcctInfo = null;
                    if (acctViewInfo.getGAA() != null) {
                        asstAcctInfo = acctViewInfo.getGAA();
                    }
                    if (acctViewInfo.getCAA() != null) {
                        asstAcctInfo = acctViewInfo.getCAA();
                    }
                    if (asstAcctInfo != null && asstAcctInfo.getId() != null && this.isHasAssistant(ctx, acctBankId, asstAcctInfo.getId().toString())) {
                        IAsstActType asstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
                        AsstActTypeInfo asstAct = asstActType.getAsstActType(AsstActTypeSysEnum.BANKACCOUNT);
                        if (beginDate.equals(endDate) && !calculatePeriod.isIsAdjustPeriod()) {
                            if (isGLOver) {
                                beginBalance = this.getGLDayAssisData(ctx, companyNum, accountNum, bankAcctNum, currencyNum, glEndDate, glEndDate, VoucherGetTypeEnum.C, asstAct, unTranVoucher);
                                debitAmt = this.getGLDayAssisData(ctx, companyNum, accountNum, bankAcctNum, currencyNum, glEndDate, glEndDate, VoucherGetTypeEnum.JF, asstAct, unTranVoucher);
                                creditAmt = this.getGLDayAssisData(ctx, companyNum, accountNum, bankAcctNum, currencyNum, glEndDate, glEndDate, VoucherGetTypeEnum.DF, asstAct, unTranVoucher);
                            } else {
                                beginBalance = this.getGLDayAssisData(ctx, companyNum, accountNum, bankAcctNum, currencyNum, beginDate, endDate, VoucherGetTypeEnum.C, asstAct, unTranVoucher);
                                debitAmt = this.getGLDayAssisData(ctx, companyNum, accountNum, bankAcctNum, currencyNum, beginDate, endDate, VoucherGetTypeEnum.JF, asstAct, unTranVoucher);
                                creditAmt = this.getGLDayAssisData(ctx, companyNum, accountNum, bankAcctNum, currencyNum, beginDate, endDate, VoucherGetTypeEnum.DF, asstAct, unTranVoucher);
                            }
                        } else {
                            PeriodInfo firstDatePeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)DateHelper.getFirstYearDate((Date)glBeginDate), (CompanyOrgUnitInfo)companyInfo);
                            PeriodInfo beginPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)glBeginDate, (CompanyOrgUnitInfo)companyInfo);
                            PeriodInfo endPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)glEndDate, (CompanyOrgUnitInfo)companyInfo);
                            if (isYear) {
                                beginBalance = this.getGLAssisData(ctx, companyInfo, accountNum, bankAcctNum, currencyNum, firstDatePeriod, endPeriod, beginBalType, asstAct, period, unTranVoucher);
                                debitAmt = this.getGLAssisData(ctx, companyInfo, accountNum, bankAcctNum, currencyNum, beginPeriod, endPeriod, BalanceTypeEnum.JL, asstAct, period, unTranVoucher);
                                creditAmt = this.getGLAssisData(ctx, companyInfo, accountNum, bankAcctNum, currencyNum, beginPeriod, endPeriod, BalanceTypeEnum.DL, asstAct, period, unTranVoucher);
                            } else {
                                beginBalance = this.getGLAssisData(ctx, companyInfo, accountNum, bankAcctNum, currencyNum, beginPeriod, endPeriod, beginBalType, asstAct, period, unTranVoucher);
                                debitAmt = this.getGLAssisData(ctx, companyInfo, accountNum, bankAcctNum, currencyNum, beginPeriod, endPeriod, debitType, asstAct, period, unTranVoucher);
                                creditAmt = this.getGLAssisData(ctx, companyInfo, accountNum, bankAcctNum, currencyNum, beginPeriod, endPeriod, creditType, asstAct, period, unTranVoucher);
                            }
                        }
                        if (!(beginBalance.equals(ZERO) && endBalance.equals(ZERO) && debitAmt.equals(ZERO) && creditAmt.equals(ZERO))) {
                            isNotGetAssis = false;
                        }
                    }
                }
            }
            if (isNotGetAssis) {
                boolean isExistMultiBankAcct;
                boolean isGetAcctBal = true;
                if (capitalType.equals((Object)CapitalTypeEnum.BANK) && (isExistMultiBankAcct = FMHelper.isExistMultiBankAcct((Context)ctx, (String)companyInfo.getId().toString(), (String)acctViewId))) {
                    isGetAcctBal = false;
                    isReturnNull = true;
                }
                if (isGetAcctBal) {
                    if (beginDate.equals(endDate) && !calculatePeriod.isIsAdjustPeriod()) {
                        if (isGLOver) {
                            beginBalance = this.getGLExtBalance(ctx, companyNum, accountNum, currencyNum, glEndDate, glEndDate, VoucherGetTypeEnum.C, unTranVoucher);
                            debitAmt = this.getGLExtBalance(ctx, companyNum, accountNum, currencyNum, glEndDate, glEndDate, VoucherGetTypeEnum.JF, unTranVoucher);
                            creditAmt = this.getGLExtBalance(ctx, companyNum, accountNum, currencyNum, glEndDate, glEndDate, VoucherGetTypeEnum.DF, unTranVoucher);
                        } else {
                            beginBalance = this.getGLExtBalance(ctx, companyNum, accountNum, currencyNum, beginDate, endDate, VoucherGetTypeEnum.C, unTranVoucher);
                            debitAmt = this.getGLExtBalance(ctx, companyNum, accountNum, currencyNum, beginDate, endDate, VoucherGetTypeEnum.JF, unTranVoucher);
                            creditAmt = this.getGLExtBalance(ctx, companyNum, accountNum, currencyNum, beginDate, endDate, VoucherGetTypeEnum.DF, unTranVoucher);
                        }
                    } else if (isYear) {
                        beginBalance = this.getGLData(ctx, companyNum, accountNum, currencyNum, DateHelper.getFirstYearDate((Date)glBeginDate), glEndDate, beginBalType, period, unTranVoucher);
                        debitAmt = this.getGLData(ctx, companyNum, accountNum, currencyNum, glBeginDate, glEndDate, BalanceTypeEnum.JL, period, unTranVoucher);
                        creditAmt = this.getGLData(ctx, companyNum, accountNum, currencyNum, glBeginDate, glEndDate, BalanceTypeEnum.DL, period, unTranVoucher);
                    } else {
                        beginBalance = this.getGLData(ctx, companyNum, accountNum, currencyNum, glBeginDate, glEndDate, beginBalType, period, unTranVoucher);
                        AccountViewInfo acctViewInfo = this.getAcctViewInfoById(ctx, acctViewId);
                        if (acctViewInfo != null && BalanceDirectionEnum.CREDIT.equals((Object)acctViewInfo.getDC())) {
                            beginBalance = beginBalance.multiply(new BigDecimal(-1));
                        }
                        debitAmt = this.getGLData(ctx, companyNum, accountNum, currencyNum, glBeginDate, glEndDate, debitType, period, unTranVoucher);
                        creditAmt = this.getGLData(ctx, companyNum, accountNum, currencyNum, glBeginDate, glEndDate, creditType, period, unTranVoucher);
                    }
                }
            }
        }
        if (isReturnNull) {
            byGLInfo.setBeginBalance(null);
            byGLInfo.setDebitAmount(null);
            byGLInfo.setCreditAmount(null);
            byGLInfo.setEndBalance(null);
        } else {
            byGLInfo.setBeginBalance(beginBalance);
            endBalance = beginBalance.add(debitAmt).subtract(creditAmt);
            byGLInfo.setEndBalance(endBalance);
            byGLInfo.setDebitAmount(debitAmt);
            byGLInfo.setCreditAmount(creditAmt);
        }
        return byGLInfo;
    }

    private boolean isHasAssistant(Context ctx, String bankAccountId, String asstAcctViewId) throws BOSException {
        IAssistantHG assistantHG = AssistantHGFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)bankAccountId));
        fi.getFilterItems().add(new FilterItemInfo("asstAccount.id", (Object)asstAcctViewId));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.setFilter(fi);
        AssistantHGCollection assistantHGColl = assistantHG.getAssistantHGCollection(evi);
        return assistantHGColl != null && assistantHGColl.size() != 0;
    }

    private boolean isYearBalance(Date beginDate, Date endDate) {
        return !beginDate.equals(endDate) && beginDate.getYear() == endDate.getYear() && beginDate.getMonth() == 0 && endDate.getMonth() == 11;
    }

    private String getAccountId(Context ctx, String acctTableNum, String companyId, CashDataSourceEnum dataSource, String accountNum) throws BOSException {
        if (accountNum == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer(120);
        sql.append("select t1.FId from t_bd_accountview t1 inner join t_bd_accountTable t2").append(" on t1.FAccountTableID =t2.FID ").append("where  t1.FIsLeaf = 1 ");
        sql.append(" and t1.FCompanyId = '").append(companyId).append("'");
        if (!StringUtils.isEmpty((String)accountNum)) {
            if (accountNum.indexOf(",") > 0) {
                sql.append(" and t1.FNumber in (");
                String[] nums = accountNum.split(",");
                for (int i = 0; i < nums.length; ++i) {
                    if (i > 0) {
                        sql.append(",");
                    }
                    sql.append(" '").append(nums[i].trim()).append("'");
                }
                sql.append(")");
            } else {
                sql.append(" and t1.FNumber = '").append(accountNum.trim()).append("'");
            }
        }
        if (dataSource.getValue() == 1 || dataSource.getValue() == 3) {
            sql.append(" and t1.FIsBank = 1");
        } else if (dataSource.getValue() == 0 || dataSource.getValue() == 2) {
            sql.append(" and t1.FIsCash = 1");
        }
        if (acctTableNum != null) {
            sql.append("and t2.FNumber = '").append(acctTableNum).append("'");
        }
        String accountId = null;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                if (rs.getString("FID") == null) continue;
                accountId = rs.getString("FID");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            BOSException ex = new BOSException();
            ex.setStackTrace(e.getStackTrace());
            throw ex;
        }
        return accountId;
    }

    private BigDecimal getCASYearStartAmount(Context ctx, CashDataSourceEnum dataSource, String companyId, String accountId, String accountBankIds, String currencyId, CashDataTypeEnum dataType) throws EASBizException, BOSException {
        if (!SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyId)))) {
            return SysConstant.BIGZERO;
        }
        StringBuffer sql = new StringBuffer();
        if (dataType.equals((Object)CashDataTypeEnum.JF)) {
            sql.append("select FDebitStartAmt result from T_CAS_JournalBalance where ");
        } else if (dataType.equals((Object)CashDataTypeEnum.DF)) {
            sql.append("select FCreditStartAmt result from T_CAS_JournalBalance where ");
        } else {
            sql.append("select FYearStartAmt result from T_CAS_JournalBalance where ");
        }
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        sql.append("FCompanyId='").append(companyId).append("' and FCurrencyId ='").append(currencyId).append("' and FPeriodId='").append(startPeriod.getId().toString()).append("'");
        if (dataSource.getValue() == 3) {
            sql.append("and FType= 3");
        } else if (dataSource.getValue() == 1) {
            sql.append("and FType= 2");
        } else {
            sql.append("and FType= 1");
        }
        if (!dataSource.equals((Object)CashDataSourceEnum.C) && !dataSource.equals((Object)CashDataSourceEnum.S) && accountBankIds != null && accountBankIds.length() > 0) {
            sql.append(" and FAccountBankID ='").append(accountBankIds + "'");
        }
        if (accountId != null) {
            sql.append(" and FAccountViewId ='").append(accountId).append("'");
        }
        sql.append(" and FIsInit =1");
        BigDecimal result = SysConstant.BIGZERO;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                result = rs.getBigDecimal("result");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            BOSException ex = new BOSException();
            ex.setStackTrace(e.getStackTrace());
            throw ex;
        }
        return result == null ? ZERO : result;
    }

    private AssistantHGInfo getHasAssistant(Context ctx, String bankAccountId, String asstAccountId) throws BOSException {
        IAssistantHG assistantHG = AssistantHGFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (bankAccountId != null) {
            fi.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)bankAccountId));
        }
        if (asstAccountId != null) {
            fi.getFilterItems().add(new FilterItemInfo("asstAccount.id", (Object)asstAccountId));
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("bankAccount.id"));
        selector.add(new SelectorItemInfo("asstAccount.id"));
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.setFilter(fi);
        AssistantHGCollection assistantHGColl = assistantHG.getAssistantHGCollection(evi);
        if (assistantHGColl == null || assistantHGColl.size() == 0) {
            return null;
        }
        return assistantHGColl.get(0);
    }

    private CompanyOrgUnitInfo getCompanyInfo(Context ctx, String fid) throws BOSException {
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("name");
        selector.add("number");
        selector.add("accountTable.id");
        selector.add("accountTable.number");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)fid));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        CompanyOrgUnitCollection companyColl = iCompany.getCompanyOrgUnitCollection(viewInfo);
        if (companyColl != null) {
            return companyColl.get(0);
        }
        return null;
    }

    private CompanyOrgUnitInfo getCompanyInfoByNumber(Context ctx, String fnumber) throws BOSException {
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("name");
        selector.add("number");
        selector.add("accountTable.id");
        selector.add("accountTable.number");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)fnumber));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        CompanyOrgUnitCollection companyColl = iCompany.getCompanyOrgUnitCollection(viewInfo);
        if (companyColl != null) {
            return companyColl.get(0);
        }
        return null;
    }

    private BigDecimal getCASData(Context ctx, String companyNum, CashDataSourceEnum dataSource, String acctTableNum, String accountNum, String bankAcctNum, String currencyNum, Date beginDate, Date endDate, CashDataTypeEnum dataType) throws EASBizException, BOSException {
        ICashManagement iCashManage = CashManagementFactory.getLocalInstance(ctx);
        BigDecimal data = ZERO;
        data = iCashManage.cash(companyNum, dataSource, acctTableNum, accountNum, bankAcctNum, currencyNum, beginDate, endDate, dataType, false);
        return data == null ? ZERO : data;
    }

    private BigDecimal getCASData(Context ctx, Set companyIdSet, CashDataSourceEnum dataSource, String acctTableNum, String accountNum, Set acctBankIdSet, CurrencyInfo currency, Date beginDate, Date endDate, CashDataTypeEnum dataType, Map startPeriodMap, Map currentPeriodMap, PeriodInfo calculatePeriod) throws EASBizException, BOSException {
        CashFetchDataParam param = new CashFetchDataParam();
        param.setCompanyIdSet(companyIdSet);
        param.setDataSource(dataSource);
        param.setAcctTableNum(acctTableNum);
        param.setAcctViewNum(accountNum);
        param.setAcctBankIdSet(acctBankIdSet);
        param.setCurrency(currency);
        param.setBeginDate(beginDate);
        param.setEndDate(endDate);
        param.setDataType(dataType);
        param.setStartPeriodMap(startPeriodMap);
        param.setCurrentPeriodMap(currentPeriodMap);
        param.setIncludeUnsettled(false);
        param.setCalculatePeriod(calculatePeriod);
        ICashManagement iCashManage = CashManagementFactory.getLocalInstance(ctx);
        BigDecimal data = ZERO;
        data = iCashManage.cash(param);
        return data == null ? ZERO : data;
    }

    private BigDecimal getGLData(Context ctx, String companyNum, String accountNum, String currencyNum, Date beginDate, Date endDate, BalanceTypeEnum balanceType, IObjectValue object, boolean unTranVoucher) throws BOSException, EASBizException {
        if (beginDate == null || endDate == null) {
            return null;
        }
        CompanyOrgUnitInfo companyInfo = this.getCompanyInfoByNumber(ctx, companyNum);
        PeriodInfo beginPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)beginDate, (CompanyOrgUnitInfo)companyInfo);
        PeriodInfo endPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)endDate, (CompanyOrgUnitInfo)companyInfo);
        return this.getGLData(ctx, companyInfo, accountNum, currencyNum, beginPeriod, endPeriod, balanceType, object, unTranVoucher);
    }

    private BigDecimal getGLData(Context ctx, CompanyOrgUnitInfo companyInfo, String accountNum, String currencyNum, PeriodInfo beginPeriod, PeriodInfo endPeriod, BalanceTypeEnum balanceType, IObjectValue object, boolean unTranVoucher) throws BOSException, EASBizException {
        IReportCacl reportCacl = ReportCaclFactory.getLocalInstance((Context)ctx);
        if (beginPeriod == null || endPeriod == null) {
            return null;
        }
        boolean checkDataRight = false;
        String companyNum = companyInfo.getNumber();
        int startYear = beginPeriod.getPeriodYear();
        int startNum = beginPeriod.getPeriodNumber();
        int endYear = endPeriod.getPeriodYear();
        int endNum = endPeriod.getPeriodNumber();
        PeriodInfo period = (PeriodInfo)object;
        if (period.isIsAdjustPeriod()) {
            startYear = period.getPeriodYear();
            startNum = period.getPeriodNumber();
            endYear = period.getPeriodYear();
            endNum = period.getPeriodNumber();
        }
        BigDecimal balance = ZERO;
        balance = reportCacl.acct(companyNum, accountNum, balanceType, startYear, startNum, endYear, endNum, currencyNum, false, unTranVoucher, checkDataRight);
        return balance == null ? ZERO : balance;
    }

    private BigDecimal getGLAssisData(Context ctx, CompanyOrgUnitInfo org, String accountNum, String acctBankNum, String currencyNum, PeriodInfo beginPeriod, PeriodInfo endPeriod, BalanceTypeEnum balanceType, AsstActTypeInfo asstAct, IObjectValue period, boolean unTranVoucher) throws BOSException, EASBizException {
        IReportCacl reportCacl = ReportCaclFactory.getLocalInstance((Context)ctx);
        if (beginPeriod == null || endPeriod == null) {
            return null;
        }
        boolean checkDataRight = false;
        PeriodInfo currentPeriod = (PeriodInfo)period;
        String companyNum = org.getNumber();
        int startYear = beginPeriod.getPeriodYear();
        int startNum = beginPeriod.getPeriodNumber();
        int endYear = endPeriod.getPeriodYear();
        int endNum = endPeriod.getPeriodNumber();
        if (currentPeriod.isIsAdjustPeriod()) {
            startYear = currentPeriod.getPeriodYear();
            startNum = currentPeriod.getPeriodNumber();
            endYear = currentPeriod.getPeriodYear();
            endNum = currentPeriod.getPeriodNumber();
        }
        BigDecimal balance = ZERO;
        if (asstAct != null) {
            balance = reportCacl.acct(companyNum, accountNum + "|" + asstAct.getNumber() + "|" + acctBankNum, balanceType, startYear, startNum, endYear, endNum, currencyNum, false, unTranVoucher, checkDataRight);
        }
        return balance == null ? ZERO : balance;
    }

    private BigDecimal getGLDayAssisData(Context ctx, String companyNum, String accountNum, String acctBankNum, String currencyNum, Date beginDate, Date endDate, VoucherGetTypeEnum type, AsstActTypeInfo asstAct, boolean unTranVoucher) throws BOSException, EASBizException {
        IReportCacl reportCacl = ReportCaclFactory.getLocalInstance((Context)ctx);
        if (beginDate == null || endDate == null) {
            return null;
        }
        boolean checkDataRight = false;
        BigDecimal balance = ZERO;
        if (asstAct != null) {
            String strBeginDate = beginDate.toString();
            String strEndDate = endDate.toString();
            balance = reportCacl.acctExt(companyNum, accountNum + "|" + asstAct.getNumber() + "|" + acctBankNum, "", null, type, currencyNum, strBeginDate, strEndDate, unTranVoucher, checkDataRight);
        }
        return balance == null ? ZERO : balance;
    }

    private BigDecimal getGLExtBalance(Context ctx, String companyNum, String accountNum, String currencyNum, Date beginDate, Date endDate, VoucherGetTypeEnum type, boolean unTranVoucher) throws BOSException, EASBizException {
        BigDecimal balance = ZERO;
        IReportCacl reportCacl = ReportCaclFactory.getLocalInstance((Context)ctx);
        boolean checkDataRight = false;
        String strBeginDate = beginDate.toString();
        String strEndDate = endDate.toString();
        try {
            balance = reportCacl.acctExt(companyNum, accountNum, "", null, type, currencyNum, strBeginDate, strEndDate, unTranVoucher, checkDataRight);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return balance;
    }

    private Map getSetAssistantBeginAmtMap(Context ctx, CompanyOrgUnitInfo companyInfo, String currencyId, String periodId, String accountId, String assistGrpId, boolean bln) throws EASBizException, BOSException {
        HashMap<String, Comparable<BigDecimal>> map = new HashMap<String, Comparable<BigDecimal>>();
        boolean isSetAssis = true;
        BigDecimal beginBalance = ZERO;
        BigDecimal endBalance = ZERO;
        BigDecimal debitAmt = ZERO;
        BigDecimal creditAmt = ZERO;
        PeriodInfo glStartPeriodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)companyInfo);
        boolean isGLInit = periodId.equals(glStartPeriodInfo.getId().toString());
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (companyInfo != null) {
            fi.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)companyInfo.getId().toString()));
        }
        if (!isGLInit && periodId != null) {
            fi.getFilterItems().add(new FilterItemInfo("period.id", (Object)periodId));
        }
        if (accountId != null) {
            fi.getFilterItems().add(new FilterItemInfo("account.id", (Object)accountId));
        }
        if (currencyId != null) {
            fi.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        }
        if (!isGLInit) {
            if (assistGrpId != null) {
                fi.getFilterItems().add(new FilterItemInfo("assistGrp.id", (Object)assistGrpId));
            }
            if (bln) {
                fi.getFilterItems().add(new FilterItemInfo("balType", (Object)new Integer(5)));
            } else {
                fi.getFilterItems().add(new FilterItemInfo("balType", (Object)new Integer(1)));
            }
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("beginBalanceFor"));
        selector.add(new SelectorItemInfo("endBalanceFor"));
        selector.add(new SelectorItemInfo("debitFor"));
        selector.add(new SelectorItemInfo("creditFor"));
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.setFilter(fi);
        if (isGLInit) {
            IInitAssistBalance iInitAsstBal = InitAssistBalanceFactory.getLocalInstance((Context)ctx);
            InitAssistBalanceCollection initAssistBalColl = iInitAsstBal.getInitAssistBalanceCollection(evi);
            if (initAssistBalColl != null && initAssistBalColl.size() > 0) {
                InitAssistBalanceInfo initAssistBalInfo = initAssistBalColl.get(0);
                beginBalance = this.getBigDecimal(initAssistBalInfo.getBeginBalanceFor());
                endBalance = this.getBigDecimal(initAssistBalInfo.getEndBalanceFor());
                debitAmt = this.getBigDecimal(initAssistBalInfo.getDebitFor());
                creditAmt = this.getBigDecimal(initAssistBalInfo.getCreditFor());
                isSetAssis = false;
            }
        } else {
            IAssistBalance iAssistBal = AssistBalanceFactory.getLocalInstance((Context)ctx);
            AssistBalanceCollection assistBalColl = iAssistBal.getAssistBalanceCollection(evi);
            if (assistBalColl != null && assistBalColl.size() > 0) {
                AssistBalanceInfo assistBalInfo = assistBalColl.get(0);
                beginBalance = this.getBigDecimal(assistBalInfo.getBeginBalanceFor());
                endBalance = this.getBigDecimal(assistBalInfo.getEndBalanceFor());
                debitAmt = this.getBigDecimal(assistBalInfo.getDebitFor());
                creditAmt = this.getBigDecimal(assistBalInfo.getCreditFor());
                isSetAssis = false;
            }
        }
        map.put("beginBalance", beginBalance);
        map.put("endBalance", endBalance);
        map.put("debitAmt", debitAmt);
        map.put("creditAmt", creditAmt);
        map.put("isSetAssis", new Boolean(isSetAssis));
        return map;
    }

    public BigDecimal getBigDecimal(BigDecimal big) {
        return big == null ? ZERO : big;
    }

    private AccountViewInfo getAcctViewInfoById(Context ctx, String acctViewId) throws EASBizException, BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("GAA.id"));
        selector.add(new SelectorItemInfo("GAA.name"));
        selector.add(new SelectorItemInfo("CAA.id"));
        selector.add(new SelectorItemInfo("CAA.name"));
        FilterInfo fi = new FilterInfo();
        FilterItemCollection items = fi.getFilterItems();
        items.add(new FilterItemInfo("id", (Object)acctViewId));
        evi.setFilter(fi);
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        AccountViewCollection acctViewCol = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(evi);
        return acctViewCol == null ? null : acctViewCol.get(0);
    }

    private CurrencyInfo getCurrency(Context ctx, String currencyNum) throws BOSException, CasDataException {
        if (currencyNum == null) {
            throw new CasDataException(CasDataException.NULL_CURRENCY);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)currencyNum));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        CurrencyCollection coll = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(evi);
        if (coll != null && !coll.isEmpty()) {
            return coll.get(0);
        }
        return null;
    }

    private String getBankAcctId(Context ctx, String bankAcctNum, String companyid) throws BOSException {
        if (bankAcctNum == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select Fid from t_bd_accountbanks where ").append(" FNumber = '").append(bankAcctNum.trim()).append("'");
        sql.append(" and FCompanyid = '" + companyid + "'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                if (rs.getString("FID") == null) continue;
                return rs.getString("FID");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            BOSException ex = new BOSException();
            ex.setStackTrace(e.getStackTrace());
            throw ex;
        }
        return null;
    }

    @Override
    protected IRowSet _getGLRowset(Context ctx, IObjectPK mainQueryPK, IObjectValue mainQuery, BOSUuid currencyId, Set acctBankIdSet, Set acctViewIdSet, CapitalTypeEnum capitalType, IObjectValue object) throws BOSException, EASBizException {
        Map acctViewMap = this.getAcctViewAndAsstAccountBankMapping(ctx, acctViewIdSet);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)((IMetaDataPK)mainQueryPK));
        EntityViewInfo ev = (EntityViewInfo)((EntityViewInfo)mainQuery).clone();
        FilterInfo filter = ev.getFilter();
        FilterInfo baseFilter = new FilterInfo();
        baseFilter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        baseFilter.getFilterItems().add(new FilterItemInfo("period.id", (Object)((PeriodInfo)object).getId().toString(), CompareType.EQUALS));
        baseFilter.setMaskString("#0 and #1");
        try {
            filter.mergeFilter(baseFilter, "and");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (capitalType.equals((Object)CapitalTypeEnum.CASH)) {
            FilterInfo filterAcctView = new FilterInfo();
            filterAcctView.getFilterItems().add(new FilterItemInfo("entries.account.id", (Object)acctViewIdSet, CompareType.INCLUDE));
            filter.mergeFilter(filterAcctView, "and");
        } else if (capitalType.equals((Object)CapitalTypeEnum.BANK)) {
            FilterInfo filterAcctView;
            AccountBankCollection coll = this.getBankAcctColl(ctx, acctBankIdSet);
            String acctTableID = null;
            Iterator it = acctViewIdSet.iterator();
            if (it.hasNext()) {
                String acctViewID = it.next().toString();
                AccountViewInfo acctView = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(acctViewID));
                acctTableID = acctView.getAccountTableID().getId().toString();
            }
            if (!FMHelper.isEmpty(acctTableID)) {
                coll = FMHelper.getJouranlBalanceAcctBank((Context)ctx, (AccountBankCollection)coll, null, acctTableID);
            }
            if ((filterAcctView = this.getAcctViewFilter(acctViewMap, coll)).getFilterItems().size() > 0) {
                filter.mergeFilter(filterAcctView, "and");
            }
        }
        ev.getSorter().add(new SorterItemInfo("voucherNumber"));
        exec.setObjectView(ev);
        IRowSet rs = exec.executeQuery();
        return rs;
    }

    private AccountBankCollection getBankAcctColl(Context ctx, Set acctBankIdSet) throws BOSException {
        EntityViewInfo viewBank = new EntityViewInfo();
        FilterInfo filterBank = new FilterInfo();
        filterBank.getFilterItems().add(new FilterItemInfo("id", (Object)acctBankIdSet, CompareType.INCLUDE));
        viewBank.setFilter(filterBank);
        AccountBankCollection coll = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(viewBank);
        return coll;
    }

    private FilterInfo getAcctViewFilter(Map acctViewMap, AccountBankCollection coll) throws BOSException {
        FilterInfo filterAcctView = new FilterInfo();
        for (int i = 0; i < coll.size(); ++i) {
            AccountBankInfo acctBankInfo = coll.get(i);
            AccountViewInfo acctViewInfo = acctBankInfo.getAccount();
            String acctViewId = acctViewInfo.getId().toString();
            if (FMHelper.isEmpty((String)acctViewId)) continue;
            FilterInfo filterAcctViewSub = new FilterInfo();
            filterAcctViewSub.getFilterItems().add(new FilterItemInfo("entries.account.id", (Object)acctViewId));
            if (acctViewMap.get(acctViewId) != null && acctViewMap.get(acctViewId) == Boolean.TRUE) {
                filterAcctViewSub.getFilterItems().add(new FilterItemInfo("entries.assistRecords.assGrp.bankAccount.id", (Object)acctBankInfo.getId()));
            }
            filterAcctView.mergeFilter(filterAcctViewSub, "or");
        }
        return filterAcctView;
    }

    private Map getAcctViewAndAsstAccountBankMapping(Context ctx, Set acctViewIdSet) throws BOSException {
        HashMap<String, Boolean> acctViewMap = new HashMap<String, Boolean>();
        Object[] objs = acctViewIdSet.toArray();
        StringBuffer sql = new StringBuffer();
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        sql.append("select a.FID, a.FNumber, a.FName_").append(loc).append("  from T_BD_AccountView a \n").append(" join T_BD_AsstAccount b on a.FCAA = b.FID \n").append(" join T_BD_AsstActGroupDetail c on c.FAsstAccountID = b.FID \n").append(" join T_BD_AsstActType d on c.FAsstActTypeID = d.FID \n").append(" where d.FRealtionDataObject = 'T_BD_AccountBanks' \n");
        sql.append(" and a.FID in (");
        for (int i = 0; i < acctViewIdSet.size(); ++i) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append(" '").append(objs[i].toString()).append("'");
        }
        sql.append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                acctViewMap.put(rs.getString("FID"), Boolean.TRUE);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return acctViewMap;
    }

    @Override
    protected Map _getAllBankAcctCasContrastGLData(Context ctx, CapitalTypeEnum capitalType, String accountNum, String bankAcctNum, String currencyNum, Date beginDate, Date endDate, IObjectValue period, boolean unTranVoucher, String companyid) throws BOSException, EASBizException {
        Object[] nums;
        ArrayList<Map> resultList = new ArrayList<Map>();
        if (bankAcctNum == null) {
            nums = accountNum.split(",");
            for (int i = 0; i < nums.length; ++i) {
                Map map = this._getCasContrastGLData(ctx, capitalType, nums[i], null, currencyNum, beginDate, endDate, period, unTranVoucher, companyid);
                resultList.add(map);
            }
        } else {
            nums = bankAcctNum.split(",");
            CompanyOrgUnitInfo company = this.getCompanyInfo(ctx, companyid);
            String acctTableId = company.getAccountTable().getId().toString();
            if (period != null) {
                PeriodInfo periodInfo = (PeriodInfo)period;
                acctTableId = AccountTools.getCurrentAcctTable((Context)ctx, (String)company.getId().toString(), (String)company.getAccountTable().getId().toString(), (int)periodInfo.getPeriodYear(), (int)periodInfo.getPeriodNumber());
            } else {
                acctTableId = FMHelper.getActualAcctTable((Context)ctx, (String)company.getId().toString(), (Date)beginDate, (Date)endDate);
            }
            IAccountTable iAcctTable = AccountTableFactory.getLocalInstance((Context)ctx);
            AccountTableInfo acctTableInfo = iAcctTable.getAccountTableInfo((IObjectPK)new ObjectUuidPK(acctTableId));
            String oql = "select * ,account.* where " + FMHelper.buildIn((String)"number", (Object[])nums) + " and company.id = '" + companyid + "'";
            AccountBankCollection coll = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(oql);
            if (company != null && company.getAccountTable() != null) {
                coll = FMHelper.getJouranlBalanceAcctBank((Context)ctx, (AccountBankCollection)coll, null, (String)acctTableId);
            }
            AccountBankInfo acctBank = null;
            for (int i = 0; i < coll.size(); ++i) {
                acctBank = coll.get(i);
                Map map = this.getCasContrastGLData(ctx, capitalType, acctBank.getAccount().getNumber(), acctBank.getNumber(), currencyNum, beginDate, endDate, company, acctTableInfo, period, unTranVoucher);
                resultList.add(map);
                map.put("actualAcctBank", acctBank);
            }
        }
        Map map = this.getResultMap(resultList);
        return map;
    }

    private Map getResultMap(List resultList) {
        HashMap mapResult = new HashMap();
        CasContrastGLInfo byGLInfo = new CasContrastGLInfo();
        CasContrastGLInfo byCASInfo = new CasContrastGLInfo();
        CasContrastGLInfo byDiffInfo = new CasContrastGLInfo();
        CasContrastGLInfo byBALInfo = new CasContrastGLInfo();
        for (Map map : resultList) {
            byGLInfo = byGLInfo.add((CasContrastGLInfo)((Object)map.get("byGL")));
            byCASInfo = byCASInfo.add((CasContrastGLInfo)((Object)map.get("byCAS")));
            byDiffInfo = byDiffInfo.add((CasContrastGLInfo)((Object)map.get("byDiff")));
            byBALInfo = byBALInfo.add((CasContrastGLInfo)((Object)map.get("byBal")));
            if (!map.containsKey("actualAcctBank")) continue;
            mapResult.put("actualAcctBank", map.get("actualAcctBank"));
        }
        mapResult.put("byGL", byGLInfo);
        mapResult.put("byCAS", byCASInfo);
        mapResult.put("byDiff", byDiffInfo);
        mapResult.put("byBal", byBALInfo);
        return mapResult;
    }

    @Override
    protected Map _getAllBankAcctCasContrastGLSumData(Context ctx, Set companySet, CurrencyInfo currencyInfo, PeriodInfo period, boolean cancleAccountBank, boolean unBalance, boolean unTranVoucher) throws BOSException, EASBizException {
        int year = period.getPeriodYear();
        int spNum = period.getPeriodNumber();
        HashMap resultMap = new HashMap();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        Iterator it = companySet.iterator();
        while (it.hasNext()) {
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(it.next().toString()));
            period = this.getPeriodInfo(ctx, year, spNum, company);
            String acctTableId = AccountTools.getCurrentAcctTable((Context)ctx, (String)company.getId().toString(), (String)company.getAccountTable().getId().toString(), (int)year, (int)spNum);
            AccountViewCollection acctViewColl = FMHelper.getAcctViewCollection((Context)ctx, (String)company.getId().toString(), (String)acctTableId, (String)currencyInfo.getId().toString(), (AccountTypeEnum)AccountTypeEnum.CASHACCOUNT);
            HashMap<String, Map> acctViewMap = new HashMap<String, Map>();
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)acctViewColl)) {
                for (int i = 0; i < acctViewColl.size(); ++i) {
                    AccountViewInfo acctView = acctViewColl.get(i);
                    if (!dataMap.containsKey(acctView.getId().toString())) {
                        dataMap.put(acctView.getId().toString(), acctView);
                    }
                    Map tmp = this._getAllBankAcctCasContrastGLData(ctx, CapitalTypeEnum.CASH, acctView.getNumber(), null, currencyInfo.getNumber(), period.getBeginDate(), period.getEndDate(), (IObjectValue)period, unTranVoucher, company.getId().toString());
                    acctViewMap.put(acctView.getId().toString(), tmp);
                }
            }
            resultMap.put(company.getId().toString() + "_acctView", acctViewMap);
            AccountBankCollection acctColl = this.getAccountBankCollection(ctx, company.getId().toString(), cancleAccountBank);
            LinkedHashMap<String, Map> acctMap = new LinkedHashMap<String, Map>();
            for (int i = 0; i < acctColl.size(); ++i) {
                AccountBankInfo acct = acctColl.get(i);
                if (!dataMap.containsKey(acct.getId().toString())) {
                    dataMap.put(acct.getId().toString(), acct);
                }
                Map tmp = this._getAllBankAcctCasContrastGLData(ctx, CapitalTypeEnum.BANK, null, acct.getNumber(), currencyInfo.getNumber(), period.getBeginDate(), period.getEndDate(), (IObjectValue)period, unTranVoucher, company.getId().toString());
                acctMap.put(acct.getId().toString(), tmp);
            }
            resultMap.put(company.getId().toString() + "_acct", acctMap);
        }
        resultMap.put("data", dataMap);
        return resultMap;
    }

    private PeriodInfo getPeriodInfo(Context ctx, int periodYear, int periodNumber, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (companyInfo.getAccountPeriodType() == null || companyInfo.getAccountPeriodType().getId() == null) {
            ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        }
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        PeriodInfo info = null;
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodNumber), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            info = periodc.get(0);
        }
        return info;
    }

    private AccountBankCollection getAccountBankCollection(Context ctx, String strCompanyId, boolean cancleAccountBank) throws BOSException {
        IAccountBank iAcctBank = AccountBankFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("bankaccountnumber");
        selector.add("name");
        selector.add("account.id");
        selector.add("account.number");
        selector.add("account.name");
        selector.add("bank.id");
        selector.add("bank.name");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (strCompanyId != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)strCompanyId));
        }
        filter.getFilterItems().add(new FilterItemInfo("isBank", (Object)FMConstants.TRUE));
        if (!cancleAccountBank) {
            filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)FMConstants.FALSE));
        }
        viewInfo.setFilter(filter);
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        viewInfo.getSorter().add(new SorterItemInfo("bank.name"));
        viewInfo.getSorter().add(new SorterItemInfo("name"));
        AccountBankCollection acctBankColl = iAcctBank.getAccountBankCollection(viewInfo);
        for (int i = 0; i < acctBankColl.size(); ++i) {
            acctBankColl.get(i).setDisplayFormat("$number$ - $name$");
        }
        return acctBankColl;
    }
}

