/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.CasDataException;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.app.CashCaculaterExt_AY;
import com.kingdee.eas.fi.cas.app.CashCaculaterExt_C;
import com.kingdee.eas.fi.cas.app.CashCaculaterExt_DF;
import com.kingdee.eas.fi.cas.app.CashCaculaterExt_JF;
import com.kingdee.eas.fi.cas.app.CashCaculaterExt_QDF;
import com.kingdee.eas.fi.cas.app.CashCaculaterExt_QJF;
import com.kingdee.eas.fi.cas.app.CashCaculaterExt_Y;
import com.kingdee.eas.fi.cas.app.CompanyPeriodInfo;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CashCaculaterExtStrategy {
    private static Logger logger = Logger.getLogger((String)CashCaculaterExtStrategy.class.getName());
    private static Context ctx = null;
    protected int MAX_COUNT = 100;

    public static CashCaculaterExtStrategy getInstance(Context serverCtx, String dataType) {
        int dataTypeValue = CashDataTypeEnum.getEnum(dataType).getValue();
        ctx = serverCtx;
        switch (dataTypeValue) {
            case 1: {
                return CashCaculaterExt_Y.getInstance(serverCtx);
            }
            case 0: {
                return CashCaculaterExt_C.getInstance(serverCtx);
            }
            case 2: {
                return CashCaculaterExt_AY.getInstance(serverCtx);
            }
            case 3: {
                return CashCaculaterExt_JF.getInstance(serverCtx);
            }
            case 4: {
                return CashCaculaterExt_DF.getInstance(serverCtx);
            }
            case 5: {
                return CashCaculaterExt_QJF.getInstance(serverCtx);
            }
            case 6: {
                return CashCaculaterExt_QDF.getInstance(serverCtx);
            }
        }
        return null;
    }

    public void doCash(List params, ICalculateContextProvider context) {
        Map fmCompanyPeriodCol = null;
        for (int i = 0; i < params.size(); ++i) {
            java.util.Date endDate;
            java.util.Date beginDate;
            String currencyNum;
            String bankAcctNum;
            String bankNum;
            String companyNum;
            Object[] args;
            Parameter param;
            block22: {
                param = (Parameter)params.get(i);
                args = param.getArgs();
                companyNum = "";
                companyNum = args[0] == null || args[0].toString().length() == 0 ? this.getReportCompany(context, ctx) : args[0].toString();
                bankNum = args[1] == null ? "" : args[1].toString();
                String string = bankAcctNum = args[2] == null ? "" : args[2].toString();
                if (bankNum.trim().length() == 0 && bankAcctNum.trim().length() == 0) {
                    param.setValue((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"76_CashCaculaterExtStrategy", (Locale)ctx.getLocale()));
                    continue;
                }
                currencyNum = "";
                currencyNum = args[3] == null || args[3].toString().length() == 0 ? this.getReportCurrency(context, ctx) : args[3].toString();
                beginDate = null;
                endDate = null;
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                DateFormat format = FMHelper.getNationalDateFormat((Context)ctx);
                if (args[4] == null || args[4].toString().length() == 0) {
                    beginDate = this.getReportStartDate(context, ctx);
                } else {
                    try {
                        beginDate = dateFormat.parse(dateFormat.format(format.parse(args[4].toString())));
                    }
                    catch (ParseException e) {
                        beginDate = this.getReportStartDate(context, ctx);
                    }
                }
                if (args[5] == null || args[5].toString().length() == 0) {
                    endDate = this.getReportEndDate(context, ctx);
                } else {
                    try {
                        endDate = dateFormat.parse(dateFormat.format(format.parse(args[5].toString())));
                    }
                    catch (ParseException e) {
                        if (args[5] != null && args[5].toString().length() != 0) break block22;
                        endDate = this.getReportEndDate(context, ctx);
                    }
                }
            }
            CashDataTypeEnum dataType = CashDataTypeEnum.getEnum(args[6].toString());
            try {
                FMVerifyHelper.checkBlank((Object)((Object)dataType), (Object[])new Object[]{"dataType"});
                if (dataType.getValue() == 0 || dataType.getValue() == 1) {
                    FMVerifyHelper.checkBlank((Object)endDate, (Object[])new Object[]{"endDate"});
                    beginDate = null;
                } else {
                    FMVerifyHelper.checkBlank((Object)beginDate, (Object[])new Object[]{"beginDate"});
                    FMVerifyHelper.checkBlank((Object)endDate, (Object[])new Object[]{"endDate"});
                }
                Set companyIdSet = this.getCompanyIds(ctx, companyNum);
                if (companyIdSet == null) {
                    throw new CasDataException(CasDataException.NULL_COMPANY);
                }
                fmCompanyPeriodCol = this.createCache(companyIdSet);
                Set bankAcctIdSet = this.getBankAcctIds(ctx, bankAcctNum);
                String currencyId = this.getCurrencyId(ctx, currencyNum);
                ICurrency currency = CurrencyFactory.getLocalInstance((Context)ctx);
                CurrencyInfo curInfo = null;
                if (!FMHelper.isEmpty((String)currencyId)) {
                    curInfo = currency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                }
                if (beginDate != null) {
                    beginDate = DateTimeUtils.truncateDate((java.util.Date)beginDate);
                }
                endDate = DateTimeUtils.truncateDate((java.util.Date)endDate);
                EntityViewInfo view = new EntityViewInfo();
                view.getSelector().add("accountTable.number");
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)companyNum));
                view.setFilter(filter);
                CompanyOrgUnitCollection coll = this.getComp(ctx).getCompanyOrgUnitCollection(view);
                CompanyOrgUnitInfo company = coll.get(0);
                String acctTableNum = null;
                if (!company.isIsOnlyUnion()) {
                    acctTableNum = company.getAccountTable().getNumber();
                }
                List sqls = this.getSqls(ctx, companyIdSet, acctTableNum, bankAcctIdSet, currencyId, beginDate, endDate, bankNum, fmCompanyPeriodCol);
                BigDecimal result = SysConstant.BIGZERO;
                if (sqls != null) {
                    for (int j = 0; j < sqls.size(); ++j) {
                        String sql = sqls.get(j).toString();
                        if (sql == null) continue;
                        result = result.add(this.exeQuerySql(ctx, sql.toString()));
                    }
                }
                if (curInfo != null && result != null) {
                    result = result.setScale(curInfo.getPrecision(), 4);
                }
                param.setValue((Object)result);
                continue;
            }
            catch (EASBizException ex) {
                logger.error((Object)ex);
                param.setValue((Object)ex.getMessage());
                continue;
            }
            catch (BOSException ex) {
                logger.error((Object)ex);
                param.setValue((Object)ex.getMessage());
            }
        }
    }

    private Map createCache(Set companyIdSet) throws BOSException {
        HashMap<String, CompanyPeriodInfo> returnHm = new HashMap<String, CompanyPeriodInfo>();
        StringBuffer sb = new StringBuffer();
        sb.append("select contr.FCompanyID,startPeriod.FBeginDate,startPeriod.fendDate,                     \n ");
        sb.append("currentPeriod.FBeginDate,currentPeriod.fendDate,startPeriod.fid,currentPeriod.fid        \n ");
        sb.append("from T_BD_SystemStatusCtrol as contr                                                     \n ");
        sb.append("left outer join T_BD_Period as startPeriod on contr.FStartPeriodID = startPeriod.fid     \n ");
        sb.append("left outer join T_BD_Period as currentPeriod on contr.FCurrentPeriodID = currentPeriod.fid \n");
        sb.append("where contr.FCompanyID in (").append(this.composeParse(companyIdSet)).append(") and startPeriod.FIsAdjustPeriod =0 ");
        sb.append("and contr.FSystemStatusID = 'e45c1988-00fd-1000-e000-33f9c0a8100d02A5514C' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rs.next()) {
                String companyid = rs.getString(1);
                Date startPeriodBeginDate = rs.getDate(2);
                Date startPeriodEndDate = rs.getDate(3);
                Date currentPeriodBeginDate = rs.getDate(4);
                Date currentPeriodEndDate = rs.getDate(5);
                String startPeriodID = rs.getString(6);
                String currentPeriodID = rs.getString(7);
                returnHm.put(companyid, new CompanyPeriodInfo(companyid, startPeriodBeginDate, startPeriodEndDate, currentPeriodBeginDate, currentPeriodEndDate, startPeriodID, currentPeriodID));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return returnHm;
    }

    private BigDecimal exeQuerySql(Context ctx, String sql) throws BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        BigDecimal result = FMConstants.ZERO;
        try {
            while (rs.next()) {
                BigDecimal value = rs.getBigDecimal("Result");
                if (value == null) continue;
                result = result.add(value);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    protected List getSqls(Context ctx2, Set companyIdSet, String acctTableNum, Set bankAcctIdSet, String currencyId, java.util.Date beginDate, java.util.Date endDate, String bankNum, Map fmCompanyPeriodCol) throws EASBizException, BOSException {
        return null;
    }

    protected String composeParse(Set idSet) {
        if (idSet == null || idSet.size() == 0) {
            return null;
        }
        StringBuffer sIds = new StringBuffer();
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            sIds.append("'").append(it.next()).append("',");
        }
        if (sIds.length() > 0) {
            sIds = sIds.deleteCharAt(sIds.length() - 1);
        }
        return sIds.toString();
    }

    private Set getCompanyIds(Context ctx, String companyNum) throws BOSException {
        if (FMHelper.isEmpty((String)companyNum)) {
            return null;
        }
        StringBuffer sql = new StringBuffer(120);
        sql.append("select fid from t_org_company where (");
        if (companyNum.indexOf(";") > 0) {
            String[] nums = companyNum.split(";");
            for (int i = 0; i < nums.length; ++i) {
                if (i > 0) {
                    sql.append(" or ");
                }
                sql.append(" (FNumber = '").append(nums[i].trim()).append("'").append(" or FLongNumber like '").append(companyNum).append("!%' ").append(" or FLongNumber like '%!").append(companyNum).append("!%') ");
            }
        } else {
            sql.append(" FNumber = '").append(companyNum.trim()).append("'").append(" or FLongNumber like '").append(companyNum).append("!%' ").append(" or FLongNumber like '%!").append(companyNum).append("!%'");
        }
        sql.append(" ) and FIsOnlyUnion =0 ");
        sql.append(" order by FLongNumber asc");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            HashSet<String> idSet = new HashSet<String>();
            while (rs.next()) {
                idSet.add(rs.getString("fid"));
            }
            if (idSet.size() > 0) {
                return idSet;
            }
            return null;
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    private Set getBankAcctIds(Context ctx, String bankAcctNum) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)bankAcctNum)) {
            return null;
        }
        StringBuffer sql = new StringBuffer(100);
        sql.append("select Fid from t_bd_accountbanks where 1=1");
        if (!StringUtils.isEmpty((String)bankAcctNum)) {
            if (bankAcctNum.indexOf(";") > 0) {
                sql.append(" and FNumber in (");
                String[] nums = bankAcctNum.split(";");
                for (int i = 0; i < nums.length; ++i) {
                    if (i > 0) {
                        sql.append(",");
                    }
                    sql.append(" '").append(nums[i].trim()).append("'");
                }
                sql.append(")");
            } else {
                sql.append(" and FNumber = '").append(bankAcctNum.trim()).append("'");
            }
        }
        HashSet<String> bankAcctIdSet = new HashSet<String>();
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                if (rs.getString("FID") == null) continue;
                bankAcctIdSet.add(rs.getString("FID"));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        if (bankAcctIdSet.size() > 0) {
            return bankAcctIdSet;
        }
        throw new CasDataException(CasDataException.NULL_ACCOUNTBANK);
    }

    private String getCurrencyId(Context ctx, String currencyNum) throws BOSException, CasDataException {
        if (FMHelper.isEmpty((String)currencyNum)) {
            return null;
        }
        StringBuffer sql = new StringBuffer(100);
        sql.append("select fid from t_bd_currency where FNumber = ?");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{currencyNum});
            if (rs.next()) {
                return rs.getString(1);
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        throw new CasDataException(CasDataException.NULL_CURRENCY);
    }

    private ICompanyOrgUnit getComp(Context serverCtx) throws BOSException {
        ICompanyOrgUnit comp = serverCtx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)serverCtx);
        return comp;
    }

    protected Set getAccountIds(Context ctx, String acctTableNum, String companyId, String accountNum) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)accountNum)) {
            return null;
        }
        StringBuffer sql = new StringBuffer(120);
        sql.append("select t1.FId from t_bd_accountview t1 inner join t_bd_accountTable t2").append(" on t1.FAccountTableID =t2.FID ").append("where  t1.FIsLeaf = 1 ");
        CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyId)));
        CtrlUnitInfo cu = companyOrgUnitInfo.getCU();
        sql.append(" and t1.FCompanyId='").append(companyId).append("'");
        if (!StringUtils.isEmpty((String)accountNum)) {
            if (accountNum.indexOf(",") > 0) {
                sql.append(" and t1.FNumber in (");
                String[] nums = accountNum.split(",");
                for (int i = 0; i < nums.length; ++i) {
                    if (i > 0) {
                        sql.append(",");
                    }
                    sql.append(" t1.FNumber = '").append(nums[i].trim()).append("'");
                }
                sql.append(")");
            } else {
                sql.append(" and t1.FNumber = '").append(accountNum.trim()).append("'");
            }
        }
        sql.append(" and t1.FIsBank = 1");
        if (acctTableNum != null) {
            sql.append("and t2.FNumber = '").append(acctTableNum).append("'");
        }
        HashSet<String> acctIdSet = new HashSet<String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                if (rs.getString("FID") == null) continue;
                acctIdSet.add(rs.getString("FID"));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        if (acctIdSet.size() > 0) {
            return FMHelper.getAllRefAcctIdSet((Context)ctx, (String)cu.getId().toString(), acctIdSet);
        }
        throw new CasDataException(CasDataException.NULL_ACCOUNT);
    }

    protected String getWhere(String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, java.util.Date beginDate, java.util.Date endDate, String bankNum) {
        String accountIds = this.composeParse(accountIdSet);
        String bankAcctIds = this.composeParse(bankAcctIdSet);
        StringBuffer where = new StringBuffer(100);
        where.append(" where FCompanyId in ('").append(companyId).append("') ").append(" and FCreateDate >={").append(TypeConversionUtils.objToDate((Object)beginDate)).append("} and FCreateDate <= {").append(TypeConversionUtils.objToDate((Object)endDate)).append("}");
        if (currencyId != null) {
            where.append(" and FCurrencyId = '").append(currencyId).append("'");
        }
        if (accountIds != null) {
            where.append(" and FAccountViewId in (").append(accountIds).append(")");
        }
        where.append(" and FAccountBankId in (").append(this.addAcountBankCondition(bankNum, bankAcctIds)).append(")");
        where.append(" and FType = 2 ");
        return where.toString();
    }

    protected String getWhere(String companyId, Set bankAcctIdSet, String currencyId, java.util.Date beginDate, java.util.Date endDate, String bankNum) {
        String bankAcctIds = this.composeParse(bankAcctIdSet);
        StringBuffer where = new StringBuffer(100);
        where.append(" where FCompanyId in ('").append(companyId).append("') ").append(" and FCreateDate >={").append(TypeConversionUtils.objToDate((Object)beginDate)).append("} and FCreateDate <= {").append(TypeConversionUtils.objToDate((Object)endDate)).append("}");
        if (currencyId != null) {
            where.append(" and FCurrencyId = '").append(currencyId).append("'");
        }
        where.append(" and FAccountBankId in (").append(this.addAcountBankCondition(bankNum, bankAcctIds)).append(")");
        where.append(" and FType = 2 ");
        return where.toString();
    }

    protected String addAcountBankCondition(String bankNum, String bankAcctIds) {
        boolean isBankNumberNull = this.isBankNumberNull(bankNum);
        boolean isBankAccountNull = this.isBankAccountNull(bankAcctIds);
        if (!isBankAccountNull) {
            return bankAcctIds;
        }
        if (!isBankNumberNull) {
            return this.getAccountBankInnerSQL(bankNum);
        }
        return "";
    }

    private String getAccountBankInnerSQL(String bankNum) {
        String[] banks = bankNum.split(";");
        HashSet<String> set = new HashSet<String>(Arrays.asList(banks));
        String bankFilter = "(" + this.composeParse(set) + ")";
        StringBuffer sbInner = new StringBuffer(150);
        sbInner.append("select acct.fid  from t_bd_accountbanks as acct ");
        sbInner.append("LEFT OUTER JOIN  t_bd_bank as banks ");
        sbInner.append("on acct.fbank = banks.fid where banks.fnumber in ");
        sbInner.append(bankFilter);
        return sbInner.toString();
    }

    private boolean isBankAccountNull(String bankAcctIds) {
        return bankAcctIds == null || bankAcctIds.trim().length() == 0;
    }

    private boolean isBankNumberNull(String bankNum) {
        return bankNum == null || bankNum.trim().length() == 0;
    }

    protected boolean currentPeriodNull(CompanyPeriodInfo periodInfo) {
        return periodInfo.getCurrentPeriodBeginDate() == null || periodInfo.getCurrentPeriodEndDate() == null;
    }

    protected boolean startPeriodNull(CompanyPeriodInfo periodInfo) {
        return periodInfo.getStartPeriodBeginDate() == null || periodInfo.getStartPeriodEndDate() == null;
    }

    private java.util.Date getReportEndDate(ICalculateContextProvider context, Context ctx) {
        return (java.util.Date)context.getReportAdapter().getReportProperty("Report_EndDate");
    }

    private String getReportCompany(ICalculateContextProvider context, Context ctx) {
        BatchHelper batchHelper = new BatchHelper(context, ctx);
        return batchHelper.getCompany_Number();
    }

    private String getReportCurrency(ICalculateContextProvider context, Context ctx) {
        return (String)context.getReportAdapter().getReportProperty("Currency.Number");
    }

    private java.util.Date getReportStartDate(ICalculateContextProvider context, Context ctx) {
        BatchHelper batchHelper = new BatchHelper(context, ctx);
        return batchHelper.getReport_StartDate();
    }
}

