/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.app.CashCaculaterExtStrategy;
import com.kingdee.eas.fi.cas.app.CompanyPeriodInfo;
import com.kingdee.eas.fm.common.DateHelper;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CashCaculaterExt_C
extends CashCaculaterExtStrategy {
    private static CashCaculaterExt_C instance = null;
    private static Context ctx = null;

    private CashCaculaterExt_C() {
    }

    public static CashCaculaterExt_C getInstance(Context serverCtx) {
        if (instance == null) {
            instance = new CashCaculaterExt_C();
        }
        ctx = serverCtx;
        return instance;
    }

    @Override
    protected List getSqls(Context ctx, Set companyIdSet, String acctTableNum, Set bankAcctIdSet, String currencyId, Date beginDate, Date endDate, String bankNumber, Map fmCompanyPeriodCol) throws EASBizException, BOSException {
        ArrayList<String> returnSQLArray = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        ArrayList<StringBuffer> sqls = new ArrayList<StringBuffer>();
        String[] companyIDs = companyIdSet.toArray(new String[companyIdSet.size()]);
        for (int i = 0; i < companyIDs.length; ++i) {
            String companyId = companyIDs[i];
            Set accountIdSet = this.getAccountIds(ctx, acctTableNum, companyId, "");
            StringBuffer subSql = new StringBuffer();
            String querySql = null;
            querySql = this.getBalanceSql(ctx, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, endDate, bankNumber, fmCompanyPeriodCol);
            if (querySql == null || "null".equalsIgnoreCase(querySql)) continue;
            subSql.append(" select sum(SubResult) Result from ( ");
            subSql.append(querySql);
            subSql.append(") SubQuery");
            sqls.add(subSql);
        }
        if (sqls.size() <= 0) {
            return null;
        }
        sql.append(sqls.get(0));
        for (int j = 1; j < sqls.size(); ++j) {
            sql.append(" union all ").append(sqls.get(j));
            if (j % this.MAX_COUNT != this.MAX_COUNT - 1) continue;
            returnSQLArray.add(sql.toString());
            if (j == sqls.size() - 1) continue;
            sql = new StringBuffer();
            sql.append(sqls.get(j + 1));
            ++j;
        }
        returnSQLArray.add(sql.toString());
        return returnSQLArray;
    }

    private String getBalanceSql(Context ctx, String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, Date beginDate, Date endDate, String bankNumber, Map fmCompanyPeriodCol) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        String bBalanceSql = this.getJTypeBalanceSql(ctx, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, endDate, bankNumber, fmCompanyPeriodCol);
        sql.append(bBalanceSql);
        return sql.toString();
    }

    private String getJTypeBalanceSql(Context ctx2, String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, Date beginDate, Date endDate, String bankNumber, Map fmCompanyPeriodCol) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        CompanyPeriodInfo periodInfo = (CompanyPeriodInfo)fmCompanyPeriodCol.get(companyId);
        if (periodInfo == null) {
            return null;
        }
        if (this.startPeriodNull(periodInfo) || this.currentPeriodNull(periodInfo)) {
            return null;
        }
        if (endDate.before(periodInfo.getStartPeriodBeginDate())) {
            return null;
        }
        PeriodInfo period = null;
        Date calculateBeginDate = null;
        Date calculateEndDate = null;
        calculateEndDate = DateHelper.getBeforeDay((Date)endDate);
        if (calculateEndDate.before(periodInfo.getStartPeriodBeginDate())) {
            period = new PeriodInfo();
            period.setId(BOSUuid.read((String)periodInfo.getStartPeriodid()));
            period.setBeginDate(periodInfo.getStartPeriodBeginDate());
            period.setEndDate(new Timestamp(periodInfo.getStartPeriodEndDate().getTime()));
        } else if (calculateEndDate.after(periodInfo.getCurrentPeriodBeginDate())) {
            period = new PeriodInfo();
            period.setId(BOSUuid.read((String)periodInfo.getCurrentPeriodid()));
            period.setBeginDate(periodInfo.getCurrentPeriodBeginDate());
            period.setEndDate(new Timestamp(periodInfo.getCurrentPeriodEndDate().getTime()));
        } else {
            period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)calculateEndDate, (CompanyOrgUnitInfo)company);
        }
        calculateBeginDate = period.getBeginDate();
        sql.append(this.getPeriodStartSql(companyId, accountIdSet, bankAcctIdSet, currencyId, period, bankNumber));
        sql.append(" union all ");
        sql.append(this.getRangeSql(companyId, accountIdSet, bankAcctIdSet, currencyId, calculateBeginDate, calculateEndDate, bankNumber));
        return sql.toString();
    }

    private String getRangeSql(String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, Date beginDate, Date endDate, String bankNumber) {
        StringBuffer sql = new StringBuffer(200);
        String field = "sum(FDebitAmount - FCreditAmount) ";
        String from = " SubResult from t_cas_JournalSummary ";
        String where = this.getWhere(companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, endDate, bankNumber);
        sql.append("select ").append(field).append(from).append(where);
        return sql.toString();
    }

    private String getPeriodStartSql(String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, PeriodInfo period, String bankNumber) {
        StringBuffer sql = new StringBuffer();
        String accountIds = this.composeParse(accountIdSet);
        String accountBankIds = this.composeParse(bankAcctIdSet);
        sql.append("select FMonthStartAmt SubResult from T_CAS_JournalBalance where ");
        sql.append("FIsInit =0  and ");
        sql.append("FCompanyId='").append(companyId).append("' and FCurrencyId ='").append(currencyId).append("' and FPeriodId='").append(period.getId().toString()).append("'");
        sql.append("and FType= 2");
        sql.append(" and FAccountBankID in (").append(this.addAcountBankCondition(bankNumber, accountBankIds) + ")");
        if (accountIds != null && accountIds.length() > 0) {
            sql.append(" and FAccountViewId in (").append(accountIds).append(")");
        }
        return sql.toString();
    }
}

