/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.app.AbstractCashContrastGLUIFetchDataFacadeControllerBean;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.util.FetchParamHelper;
import com.kingdee.eas.framework.SystemEnum;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class CashContrastGLUIFetchDataFacadeControllerBean
extends AbstractCashContrastGLUIFetchDataFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.CashContrastGLUIFetchDataFacadeControllerBean");
    private CompanyOrgUnitInfo currentCompany;

    @Override
    protected Map _fetchDataForMainUI(Context ctx, Map paramMap) throws BOSException, EASBizException {
        FetchParamHelper fph = new FetchParamHelper(ctx);
        this.currentCompany = fph.getCurrentComapny();
        CompanyOrgUnitCollection companyColl = new CompanyOrgUnitCollection();
        CompanyOrgUnitCollection coll = FMHelper.getUserOrgRangesWithRange((Context)ctx, (String)"cas_cashcontrastGL_01view");
        for (int i = 0; i < coll.size(); ++i) {
            PeriodInfo startPeriod;
            CompanyOrgUnitInfo info = coll.get(i);
            if (!info.isIsBizUnit() || info.isIsOUSealUp() || info.isIsAssistantOrg() || null == (startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)info))) continue;
            companyColl.add(info);
        }
        paramMap.put("UserOrgRanges", companyColl);
        if (!fph.getCurrentComapny().isIsBizUnit() && companyColl.size() > 0) {
            this.currentCompany = companyColl.get(0);
        }
        paramMap.put("currentCompany", this.currentCompany);
        paramMap.put("currentPeriod", this.getCurrentPeriod(ctx));
        paramMap.put("fGLStart", this.getIsGLStart(ctx));
        paramMap.put("isStart", this.getIsStart(ctx));
        paramMap.put("currencyCollection", this.getCurrencyCollection(ctx));
        paramMap.put("baseCurrency", this.getBaseCurrency(ctx));
        paramMap.put("startPeriod", this.getStartPeriod(ctx));
        paramMap.put("glCurrentPeriod", this.getGLCurrentPriond(ctx));
        paramMap.put("commonPeriodColl", this.getCommonPeriodColl(ctx));
        return paramMap;
    }

    private PeriodCollection getCommonPeriodColl(Context ctx) throws EASBizException, BOSException {
        PeriodCollection cashPeriodColl = this.getPeriodColl(ctx, SystemEnum.CASHMANAGEMENT);
        PeriodCollection glPeriodColl = this.getPeriodColl(ctx, SystemEnum.GENERALLEDGER);
        PeriodInfo cashPeriod = null;
        PeriodInfo glPeriod = null;
        PeriodCollection commonColl = new PeriodCollection();
        for (int i = 0; i < cashPeriodColl.size(); ++i) {
            cashPeriod = cashPeriodColl.get(i);
            for (int j = 0; j < glPeriodColl.size(); ++j) {
                glPeriod = glPeriodColl.get(j);
                if (!cashPeriod.equals((Object)glPeriod)) continue;
                commonColl.add(cashPeriod);
            }
        }
        return commonColl;
    }

    private PeriodCollection getPeriodColl(Context ctx, SystemEnum system) throws EASBizException, BOSException {
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)system, (CompanyOrgUnitInfo)this.currentCompany);
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)system, (CompanyOrgUnitInfo)this.currentCompany);
        if (startPeriod == null || currPeriod == null) {
            return new PeriodCollection();
        }
        ObjectUuidPK pkFrom = new ObjectUuidPK(startPeriod.getId());
        ObjectUuidPK pkTo = new ObjectUuidPK(currPeriod.getId());
        ObjectUuidPK companyPk = new ObjectUuidPK(this.currentCompany.getId());
        PeriodCollection periodColl = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection((IObjectPK)pkFrom, (IObjectPK)pkTo, (IObjectPK)companyPk);
        return periodColl;
    }

    private PeriodInfo getGLCurrentPriond(Context ctx) throws EASBizException, BOSException {
        return SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.currentCompany);
    }

    private PeriodInfo getStartPeriod(Context ctx) throws EASBizException, BOSException {
        return SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.currentCompany);
    }

    private CurrencyInfo getBaseCurrency(Context ctx) throws EASBizException, BOSException {
        return ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(this.currentCompany);
    }

    private CurrencyCollection getCurrencyCollection(Context ctx) throws EASBizException, BOSException {
        return CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(true);
    }

    private Boolean getIsStart(Context ctx) throws EASBizException, BOSException {
        boolean isStart = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.currentCompany);
        return isStart;
    }

    private Boolean getIsGLStart(Context ctx) throws EASBizException, BOSException {
        boolean isGLStart = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.currentCompany);
        return isGLStart;
    }

    private PeriodInfo getCurrentPeriod(Context ctx) throws EASBizException, BOSException {
        return SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.currentCompany);
    }

    @Override
    protected Map _fetchDataForOther(Context ctx, Map paramMap) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _fetchDataForVerify(Context ctx, Map hmVer) throws BOSException, EASBizException {
        this.currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        if (hmVer.get("date") != null) {
            Date date = (Date)hmVer.get("date");
            hmVer.put("acctTableId", this.getAcctTableId(ctx, date));
        } else {
            int periodYear = (Integer)hmVer.get("periodYear");
            int periodNumber = (Integer)hmVer.get("periodNumber");
            hmVer.put("acctTableId", AccountTools.getCurrentAcctTable((Context)ctx, (String)this.currentCompany.getId().toString(), (String)this.currentCompany.getAccountTable().getId().toString(), (int)periodYear, (int)periodNumber));
            hmVer.put("filterPeriod", PeriodUtils.getPeriodInfo((Context)ctx, (int)periodYear, (int)periodNumber, (CompanyOrgUnitInfo)this.currentCompany));
        }
        return hmVer;
    }

    private String getAcctTableId(Context ctx, Date date) throws BOSException, EASBizException {
        String companyid = this.currentCompany.getId().toString();
        PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)date, (CompanyOrgUnitInfo)this.currentCompany);
        if (period == null) {
            throw new CasException(CasException.PERIODERROR, new Object[]{DateHelper.DateToString((Date)date)});
        }
        int yearNumber = period.getPeriodYear();
        int monthNumber = period.getPeriodNumber();
        AccountTableInfo tbl = this.currentCompany.getAccountTable();
        String currTableId = AccountTools.getCurrentAcctTable((Context)ctx, (String)companyid, (String)tbl.getId().toString(), (int)yearNumber, (int)monthNumber);
        return currTableId;
    }
}

