/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGCollection;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AccountTypeEnum;
import com.kingdee.eas.fi.cas.CapitalTypeEnum;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CasContrastGLInfo;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.CashBankContrastGLFactory;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.ICashBankContrastGL;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.app.AbstractCashContrastGLWebFacadeControllerBean;
import com.kingdee.eas.fi.cas.app.SystemStatusCtrolUtils;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.utils.CashContrastGLHelper;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fm.common.FMBatchProcessFacadeFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmRpcCacheInfo;
import com.kingdee.eas.fm.common.VOComparator;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CashContrastGLWebFacadeControllerBean
extends AbstractCashContrastGLWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.CashContrastGLWebFacadeControllerBean");
    public static final String resourceCasPath = "com.kingdee.eas.fi.cas.CasResources";
    private static final String resource = "com.kingdee.eas.fi.cas.CasResources";
    public static final String resourceCheckoutPath = "com.kingdee.eas.fi.cas.CheckoutResource";
    private final String[] rowKeys = new String[]{"beginBalance", "debitAmount", "creditAmount", "endBalance"};
    private final String[] keys = new String[]{"byCAS", "byGL", "byDiff", "byBal"};
    protected FmRpcCacheInfo rpcCacheInfo;
    public static final String resourcePath = "com.kingdee.eas.fi.cas.client.CashMgtResource";
    public static final int UN_CONTRAST_FLAG = 0;
    List<Map<String, Object>> cashRsData = new ArrayList<Map<String, Object>>();
    List<Map<String, Object>> glRsData = new ArrayList<Map<String, Object>>();
    BigInteger maxGroupNumber = new BigInteger("0");
    public static final int AUTO_CONTRAST_FLAG = 1;
    private int sucessContrastTotal = 0;
    public static final int MANUAL_CONTRAST_FLAG = 2;
    List<Map<String, Object>> autoCashRsData = new ArrayList<Map<String, Object>>();
    List<Map<String, Object>> autoGlRsData = new ArrayList<Map<String, Object>>();
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat sdfFull = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String formatDate(Date date) {
        return sdf.format(date);
    }

    public static String formatDateFull(Date date) {
        return sdfFull.format(date);
    }

    public static Date parseDate(String date) {
        try {
            if (date.indexOf(" ") > 0) {
                return sdfFull.parse(date);
            }
            return sdf.parse(date);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Map _getInitData(Context ctx, String periodId, boolean share) throws BOSException, EASBizException {
        HashMap<String, Object> onloadData = new HashMap<String, Object>();
        int error = 0;
        String errorMsg = null;
        try {
            CompanyOrgUnitCollection companyColl = new CompanyOrgUnitCollection();
            long startTime = System.currentTimeMillis();
            CompanyOrgUnitCollection coll = FMHelper.getUserOrgRangesWithRange((Context)ctx, (String)"cas_cashcontrastGL_01view");
            long endTime = System.currentTimeMillis();
            logger.error((Object)("-----------\u7b2c\u4e00\u6b65\uff1a\u83b7\u53d6\u516c\u53f8\u96c6\u5408\u8017\u65f6\uff1a" + (endTime - startTime) + "----------------------"));
            if (!share) {
                CompanyOrgUnitInfo currentCompany = (CompanyOrgUnitInfo)ctx.get((Object)OrgType.Company);
                for (int i = 0; i < coll.size(); ++i) {
                    CompanyOrgUnitInfo rowCompany = coll.get(i);
                    if (rowCompany.getId().equals((Object)currentCompany.getId())) continue;
                    coll.removeObject(i);
                    --i;
                }
                if (coll.size() == 0) {
                    throw new CasWebException(CasWebException.NO_CASHCONTRASTGL_AUTHRIZED);
                }
            }
            CompanyOrgUnitCollection initColl = new CompanyOrgUnitCollection();
            if (coll != null) {
                HashSet<String> companySet = new HashSet<String>();
                HashMap<String, CompanyOrgUnitInfo> companyMap = new HashMap<String, CompanyOrgUnitInfo>();
                for (int i = 0; i < coll.size(); ++i) {
                    CompanyOrgUnitInfo info = coll.get(i);
                    if (!info.isIsBizUnit() || info.isIsOUSealUp() || info.isIsAssistantOrg()) continue;
                    companySet.add(info.getId().toString());
                    companyMap.put(info.getId().toString(), info);
                }
                String companyIds = FMHelper.setTran2String(companySet);
                StringBuffer sql = new StringBuffer();
                ISystemStatusCtrol iSysStatusCtr = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
                sql.append(" select FStartPeriodID,FCurrentPeriodID,FCompanyID from T_BD_SystemStatusCtrol sysStaCtr,T_BD_SystemStatus sysSta ");
                sql.append(" where sysStaCtr.FSystemStatusID=sysSta.FID ");
                sql.append(" and sysStaCtr.FCompanyID in ");
                sql.append(companyIds);
                sql.append(" and sysSta.FName=7");
                sql.append(" and sysStaCtr.FIsStart=1");
                startTime = System.currentTimeMillis();
                IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                endTime = System.currentTimeMillis();
                logger.error((Object)("-----------\u7b2c\u4e8c\u6b65\uff1a\u83b7\u53d6\u51fa\u7eb3\u671f\u95f4\u96c6\u5408\u8017\u65f6\uff1a" + (endTime - startTime) + "----------------------"));
                HashMap<String, String> cashStartMap = new HashMap<String, String>();
                HashMap<String, String> cashCurrMap = new HashMap<String, String>();
                HashSet<String> cashStartSet = new HashSet<String>();
                HashSet<String> cashCurrSet = new HashSet<String>();
                HashSet<String> cashCompanySet = new HashSet<String>();
                while (iRowSet.next()) {
                    String startPeriodID = iRowSet.getString("FStartPeriodID");
                    String currentPeriodID = iRowSet.getString("FCurrentPeriodID");
                    String companyID = iRowSet.getString("FCompanyID");
                    if (EmptyUtil.isEmpty((String)companyID) || EmptyUtil.isEmpty((String)startPeriodID) || EmptyUtil.isEmpty((String)currentPeriodID)) continue;
                    cashStartSet.add(startPeriodID);
                    cashCurrSet.add(currentPeriodID);
                    cashStartMap.put(companyID, startPeriodID);
                    cashCurrMap.put(companyID, currentPeriodID);
                    cashCompanySet.add(companyID);
                }
                HashSet<String> glCompanySet = new HashSet<String>();
                HashMap<String, String> glStartMap = new HashMap<String, String>();
                HashMap<String, String> glCurrMap = new HashMap<String, String>();
                HashSet<String> glStartSet = new HashSet<String>();
                HashSet<String> glCurrSet = new HashSet<String>();
                if (cashCompanySet != null && cashCompanySet.size() > 0) {
                    sql = new StringBuffer();
                    sql.append(" select sysStaCtr.fid,FCompanyID,FStartPeriodID,FCurrentPeriodID from T_BD_SystemStatusCtrol sysStaCtr,T_BD_SystemStatus sysSta ");
                    sql.append(" where sysStaCtr.FSystemStatusID=sysSta.FID ");
                    sql.append(" and sysStaCtr.FCompanyID in ");
                    sql.append(FMHelper.setTran2String(cashCompanySet));
                    sql.append(" and sysSta.FName= 6");
                    sql.append(" and sysStaCtr.FIsStart=1");
                    startTime = System.currentTimeMillis();
                    iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    endTime = System.currentTimeMillis();
                    logger.error((Object)("-----------\u7b2c\u4e09\u6b65\uff1a\u83b7\u53d6\u603b\u8d26\u671f\u95f4\u96c6\u5408\u8017\u65f6\uff1a" + (endTime - startTime) + "----------------------"));
                    while (iRowSet.next()) {
                        String startPeriodID = iRowSet.getString("FStartPeriodID");
                        String currentPeriodID = iRowSet.getString("FCurrentPeriodID");
                        String companyID = iRowSet.getString("FCompanyID");
                        if (EmptyUtil.isEmpty((String)companyID) || EmptyUtil.isEmpty((String)startPeriodID) || EmptyUtil.isEmpty((String)currentPeriodID)) continue;
                        glStartSet.add(startPeriodID);
                        glCurrSet.add(currentPeriodID);
                        glStartMap.put(companyID, startPeriodID);
                        glCurrMap.put(companyID, currentPeriodID);
                        glCompanySet.add(companyID);
                    }
                }
                Iterator it = glCompanySet.iterator();
                PeriodCollection commonPeriodCollAll = null;
                ArrayList loadData = new ArrayList();
                StringBuffer periodFilter = new StringBuffer("id in ('NE')");
                HashMap<String, PeriodCollection> map = new HashMap<String, PeriodCollection>();
                while (it.hasNext()) {
                    PeriodCollection commonPeriodColl = null;
                    PeriodCollection commonPeriodCollNew = new PeriodCollection();
                    String companyId = it.next().toString();
                    String cashStartPeriod = cashStartMap.get(companyId).toString();
                    String cashCurrPeriod = cashCurrMap.get(companyId).toString();
                    startTime = System.currentTimeMillis();
                    PeriodCollection cashPeriodColl = CashContrastGLWebFacadeControllerBean.getPeriodColl(ctx, cashStartPeriod, cashCurrPeriod, companyId);
                    endTime = System.currentTimeMillis();
                    logger.error((Object)("-----------\u7b2c\u56db\u6b65\uff1a\u83b7\u53d6\u51fa\u7eb3\u671f\u95f4\uff1a" + (endTime - startTime) + "----------------------"));
                    String glStartPeriod = glStartMap.get(companyId).toString();
                    String glCurrPeriod = glCurrMap.get(companyId).toString();
                    startTime = System.currentTimeMillis();
                    PeriodCollection glPeriodColl = CashContrastGLWebFacadeControllerBean.getPeriodColl(ctx, glStartPeriod, glCurrPeriod, companyId);
                    endTime = System.currentTimeMillis();
                    logger.error((Object)("-----------\u7b2c\u4e94\u6b65\uff1a\u83b7\u53d6\u603b\u8d26\u671f\u95f4\uff1a" + (endTime - startTime) + "----------------------"));
                    commonPeriodColl = CashContrastGLWebFacadeControllerBean.getCashGlPeriod(ctx, cashPeriodColl, glPeriodColl);
                    if (commonPeriodColl.size() == 0) continue;
                    if (periodId == null) {
                        commonPeriodCollNew.addCollection(commonPeriodColl);
                        map.put(companyId, commonPeriodCollNew);
                    }
                    if (null == commonPeriodCollAll && null != commonPeriodColl) {
                        commonPeriodCollAll = commonPeriodColl;
                        onloadData.put("period", commonPeriodColl.get(0));
                    } else {
                        for (int j = 0; j < commonPeriodColl.size(); ++j) {
                            PeriodInfo glPeriod = null;
                            glPeriod = commonPeriodColl.get(j);
                            for (int z = 0; z < commonPeriodCollAll.size() && (commonPeriodCollAll.get(z).getPeriodYear() != glPeriod.getPeriodYear() || commonPeriodCollAll.get(z).getNumber() != glPeriod.getNumber()); ++z) {
                                if (z != commonPeriodCollAll.size() - 1) continue;
                                commonPeriodCollAll.add(glPeriod);
                            }
                        }
                    }
                    if (periodId == null) {
                        initColl.add((CompanyOrgUnitInfo)companyMap.get(companyId));
                        continue;
                    }
                    PeriodInfo period = new PeriodInfo();
                    period.setId(BOSUuid.read((String)periodId));
                    startTime = System.currentTimeMillis();
                    period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(period.getId().toString()));
                    endTime = System.currentTimeMillis();
                    logger.error((Object)("-----------\u7b2c\u516d\u6b65\u8017\u65f6\uff1a" + (endTime - startTime) + "----------------------"));
                    onloadData.put("period", period);
                    CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)companyMap.get(companyId);
                    startTime = System.currentTimeMillis();
                    period = this.getPeriodInfo(ctx, info, period.getPeriodYear(), period.getPeriodNumber());
                    endTime = System.currentTimeMillis();
                    logger.error((Object)("-----------\u7b2c\u4e03\u6b65\u8017\u65f6\uff1a" + (endTime - startTime) + "----------------------"));
                    if (!commonPeriodColl.contains(period)) continue;
                    companyColl.add(info);
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    row.put("id", info.getId().toString());
                    row.put("detailPeriod", period.getNumber());
                    row.put("companyId", info.getId().toString());
                    row.put("company_name", info.getName());
                    row.put("isBizUnit", info.isIsBizUnit());
                    row.put("scheme", CASWebUtil.getResource(ctx, "UnTranVoucherAndCancleAccountBank"));
                    row.put("ckbUnTranVoucher", true);
                    row.put("ckbCancleAccountBank", true);
                    row.put("ckbUnBalance", true);
                    loadData.add(row);
                }
                if (commonPeriodCollAll != null) {
                    PeriodCollection newCommonPeriodCollDescAll = new PeriodCollection();
                    int maxIndex = 0;
                    PeriodInfo max = commonPeriodCollAll.get(0);
                    while (commonPeriodCollAll.size() > 0) {
                        for (int j = 1; j < commonPeriodCollAll.size(); ++j) {
                            if (commonPeriodCollAll.get(j).getNumber() <= max.getNumber()) continue;
                            maxIndex = j;
                            max = commonPeriodCollAll.get(j);
                        }
                        commonPeriodCollAll.removeObject(maxIndex);
                        newCommonPeriodCollDescAll.add(max);
                        if (commonPeriodCollAll.size() <= 0) continue;
                        maxIndex = 0;
                        max = commonPeriodCollAll.get(0);
                    }
                    onloadData.put("commonPeriodCollAll", newCommonPeriodCollDescAll);
                    periodFilter = new StringBuffer("id in (");
                    PeriodInfo initPeriod = new PeriodInfo();
                    initPeriod.setId(BOSUuid.read((String)newCommonPeriodCollDescAll.get(0).getId().toString()));
                    startTime = System.currentTimeMillis();
                    initPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(initPeriod.getId().toString()));
                    endTime = System.currentTimeMillis();
                    logger.error((Object)("-----------\u7b2c\u516b\u6b65\u8017\u65f6\uff1a" + (endTime - startTime) + "----------------------"));
                    if (periodId == null) {
                        onloadData.put("period", initPeriod);
                    }
                    for (int k = 0; k < newCommonPeriodCollDescAll.size(); ++k) {
                        periodFilter.append("'" + newCommonPeriodCollDescAll.get(k).getId().toString() + "',");
                        if (initPeriod.getNumber() >= newCommonPeriodCollDescAll.get(k).getNumber()) continue;
                        initPeriod = newCommonPeriodCollDescAll.get(k);
                        if (periodId != null) continue;
                        onloadData.put("period", initPeriod);
                    }
                    periodFilter.deleteCharAt(periodFilter.length() - 1);
                    periodFilter.append(") ");
                    if (periodId == null) {
                        PeriodCollection commonPeriodInitColl = null;
                        for (int l = 0; l < initColl.size(); ++l) {
                            CompanyOrgUnitInfo info = initColl.get(l);
                            commonPeriodInitColl = (PeriodCollection)map.get(info.getId().toString());
                            PeriodInfo period = new PeriodInfo();
                            startTime = System.currentTimeMillis();
                            period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(initPeriod.getId().toString()));
                            period = this.getPeriodInfo(ctx, info, period.getPeriodYear(), period.getPeriodNumber());
                            endTime = System.currentTimeMillis();
                            logger.error((Object)("-----------\u7b2c\u4e5d\u6b65\u8017\u65f6\uff1a" + (endTime - startTime) + "----------------------"));
                            if (commonPeriodInitColl == null || !commonPeriodInitColl.contains(period)) continue;
                            companyColl.add(info);
                            HashMap<String, Object> row = new HashMap<String, Object>();
                            row.put("id", info.getId().toString());
                            row.put("detailPeriod", period.getNumber());
                            row.put("companyId", info.getId().toString());
                            row.put("company_name", info.getName());
                            row.put("isBizUnit", info.isIsBizUnit());
                            row.put("scheme", CASWebUtil.getResource(ctx, "UnTranVoucherAndCancleAccountBank"));
                            row.put("ckbUnTranVoucher", true);
                            row.put("ckbCancleAccountBank", true);
                            row.put("ckbUnBalance", true);
                            loadData.add(row);
                        }
                    }
                } else {
                    errorMsg = CASWebUtil.getResource(ctx, "NoContrastPeriod");
                }
                onloadData.put("onloadData", loadData);
                onloadData.put("periodF7Filter", periodFilter.toString());
                onloadData.put("error", error);
                onloadData.put("errorMsg", errorMsg);
                return onloadData;
            }
        }
        catch (Exception e) {
            EASBizException be;
            if (e instanceof EASBizException && (be = (EASBizException)((Object)e)).getMainCode().equals("20") && be.getSubCode().equals("013")) {
                throw be;
            }
            e.printStackTrace();
            error = 1;
            errorMsg = e.getMessage();
        }
        onloadData.put("error", error);
        onloadData.put("errorMsg", errorMsg);
        return onloadData;
    }

    protected Map _getInitData2(Context ctx, String periodId, boolean share) throws BOSException, EASBizException {
        HashMap<String, Object> onloadData = new HashMap<String, Object>();
        int error = 0;
        String errorMsg = null;
        try {
            CompanyOrgUnitCollection companyColl = new CompanyOrgUnitCollection();
            CompanyOrgUnitCollection coll = FMHelper.getUserOrgRangesWithRange((Context)ctx, (String)"cas_cashcontrastGL_01view");
            if (!share) {
                CompanyOrgUnitInfo currentCompany = (CompanyOrgUnitInfo)ctx.get((Object)OrgType.Company);
                for (int i = 0; i < coll.size(); ++i) {
                    CompanyOrgUnitInfo rowCompany = coll.get(i);
                    if (rowCompany.getId().equals((Object)currentCompany.getId())) continue;
                    coll.removeObject(i);
                    --i;
                }
                if (coll.size() == 0) {
                    throw new CasWebException(CasWebException.NO_CASHCONTRASTGL_AUTHRIZED);
                }
            }
            CompanyOrgUnitCollection initColl = new CompanyOrgUnitCollection();
            if (coll != null) {
                ArrayList loadData = new ArrayList();
                PeriodCollection commonPeriodCollAll = new PeriodCollection();
                StringBuffer periodFilter = new StringBuffer("id in ('NE')");
                for (int i = 0; i < coll.size(); ++i) {
                    boolean flag;
                    boolean fGLStart;
                    PeriodInfo startPeriod;
                    PeriodCollection commonPeriodColl = null;
                    CompanyOrgUnitInfo info = coll.get(i);
                    if (!info.isIsBizUnit() || info.isIsOUSealUp() || info.isIsAssistantOrg() || null == (startPeriod = SystemStatusCtrolUtils.getStartPeriod(ctx, SystemEnum.CASHMANAGEMENT, info)) || !(fGLStart = SystemStatusCtrolUtils.isStart(ctx, SystemEnum.GENERALLEDGER, info)) || !(flag = SystemStatusCtrolUtils.isStart(ctx, SystemEnum.CASHMANAGEMENT, info))) continue;
                    commonPeriodColl = CashContrastGLWebFacadeControllerBean.getCashGlPeriod(ctx, info);
                    if (commonPeriodColl.size() == 0) continue;
                    if (null == commonPeriodCollAll && null != commonPeriodColl) {
                        commonPeriodCollAll = commonPeriodColl;
                        onloadData.put("period", commonPeriodColl.get(0));
                    } else {
                        for (int j = 0; j < commonPeriodColl.size(); ++j) {
                            PeriodInfo glPeriod = null;
                            glPeriod = commonPeriodColl.get(j);
                            for (int z = 0; z < commonPeriodCollAll.size() && (commonPeriodCollAll.get(z).getPeriodYear() != glPeriod.getPeriodYear() || commonPeriodCollAll.get(z).getNumber() != glPeriod.getNumber()); ++z) {
                                if (z != commonPeriodCollAll.size() - 1) continue;
                                commonPeriodCollAll.add(glPeriod);
                            }
                        }
                    }
                    if (periodId == null) {
                        initColl.add(coll.get(i));
                        continue;
                    }
                    PeriodInfo period = new PeriodInfo();
                    period.setId(BOSUuid.read((String)periodId));
                    period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(period.getId().toString()));
                    onloadData.put("period", period);
                    period = this.getPeriodInfo(ctx, info, period.getPeriodYear(), period.getPeriodNumber());
                    if (!commonPeriodColl.contains(period)) continue;
                    companyColl.add(info);
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    row.put("id", info.getId().toString());
                    row.put("detailPeriod", period.getNumber());
                    row.put("companyId", info.getId().toString());
                    row.put("company_name", info.getName());
                    row.put("isBizUnit", info.isIsBizUnit());
                    row.put("scheme", CASWebUtil.getResource(ctx, "UnTranVoucherAndCancleAccountBank"));
                    row.put("ckbUnTranVoucher", true);
                    row.put("ckbCancleAccountBank", true);
                    row.put("ckbUnBalance", true);
                    loadData.add(row);
                }
                if (commonPeriodCollAll != null) {
                    PeriodCollection newCommonPeriodCollDescAll = new PeriodCollection();
                    int maxIndex = 0;
                    PeriodInfo max = commonPeriodCollAll.get(0);
                    while (commonPeriodCollAll.size() > 0) {
                        for (int j = 1; j < commonPeriodCollAll.size(); ++j) {
                            if (commonPeriodCollAll.get(j).getNumber() <= max.getNumber()) continue;
                            maxIndex = j;
                            max = commonPeriodCollAll.get(j);
                        }
                        commonPeriodCollAll.removeObject(maxIndex);
                        newCommonPeriodCollDescAll.add(max);
                        if (commonPeriodCollAll.size() <= 0) continue;
                        maxIndex = 0;
                        max = commonPeriodCollAll.get(0);
                    }
                    onloadData.put("commonPeriodCollAll", newCommonPeriodCollDescAll);
                    periodFilter = new StringBuffer("id in (");
                    PeriodInfo initPeriod = new PeriodInfo();
                    initPeriod.setId(BOSUuid.read((String)newCommonPeriodCollDescAll.get(0).getId().toString()));
                    initPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(initPeriod.getId().toString()));
                    if (periodId == null) {
                        onloadData.put("period", initPeriod);
                    }
                    for (int k = 0; k < newCommonPeriodCollDescAll.size(); ++k) {
                        periodFilter.append("'" + newCommonPeriodCollDescAll.get(k).getId().toString() + "',");
                        if (initPeriod.getNumber() >= newCommonPeriodCollDescAll.get(k).getNumber()) continue;
                        initPeriod = newCommonPeriodCollDescAll.get(k);
                        if (periodId != null) continue;
                        onloadData.put("period", initPeriod);
                    }
                    periodFilter.deleteCharAt(periodFilter.length() - 1);
                    periodFilter.append(") ");
                    if (periodId == null) {
                        PeriodCollection commonPeriodInitColl = null;
                        for (int l = 0; l < initColl.size(); ++l) {
                            CompanyOrgUnitInfo info = initColl.get(l);
                            commonPeriodInitColl = CashContrastGLWebFacadeControllerBean.getCashGlPeriod(ctx, info);
                            PeriodInfo period = new PeriodInfo();
                            period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(initPeriod.getId().toString()));
                            if (!commonPeriodInitColl.contains(period = this.getPeriodInfo(ctx, info, period.getPeriodYear(), period.getPeriodNumber()))) continue;
                            companyColl.add(info);
                            HashMap<String, Object> row = new HashMap<String, Object>();
                            row.put("id", info.getId().toString());
                            row.put("detailPeriod", period.getNumber());
                            row.put("companyId", info.getId().toString());
                            row.put("company_name", info.getName());
                            row.put("isBizUnit", info.isIsBizUnit());
                            row.put("scheme", CASWebUtil.getResource(ctx, "UnTranVoucherAndCancleAccountBank"));
                            row.put("ckbUnTranVoucher", true);
                            row.put("ckbCancleAccountBank", true);
                            row.put("ckbUnBalance", true);
                            loadData.add(row);
                        }
                    }
                } else {
                    errorMsg = CASWebUtil.getResource(ctx, "NoContrastPeriod");
                }
                onloadData.put("onloadData", loadData);
                onloadData.put("periodF7Filter", periodFilter.toString());
                onloadData.put("error", error);
                onloadData.put("errorMsg", errorMsg);
                return onloadData;
            }
        }
        catch (Exception e) {
            EASBizException be;
            if (e instanceof EASBizException && (be = (EASBizException)((Object)e)).getMainCode().equals("20") && be.getSubCode().equals("013")) {
                throw be;
            }
            e.printStackTrace();
            error = 1;
            errorMsg = e.getMessage();
        }
        onloadData.put("error", error);
        onloadData.put("errorMsg", errorMsg);
        return onloadData;
    }

    public static PeriodCollection getCashGlPeriod(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        PeriodCollection cashPeriodColl = CashContrastGLWebFacadeControllerBean.getPeriodColl(ctx, companyInfo, SystemEnum.CASHMANAGEMENT);
        PeriodCollection glPeriodColl = CashContrastGLWebFacadeControllerBean.getPeriodColl(ctx, companyInfo, SystemEnum.GENERALLEDGER);
        PeriodInfo cashPeriod = null;
        PeriodInfo glPeriod = null;
        PeriodCollection commonColl = new PeriodCollection();
        for (int i = 0; i < cashPeriodColl.size(); ++i) {
            cashPeriod = cashPeriodColl.get(i);
            for (int j = 0; j < glPeriodColl.size(); ++j) {
                glPeriod = glPeriodColl.get(j);
                if (!cashPeriod.equals((Object)glPeriod)) continue;
                commonColl.add(cashPeriod);
            }
        }
        return commonColl;
    }

    private static PeriodCollection getPeriodColl(Context ctx, CompanyOrgUnitInfo companyInfo, SystemEnum system) throws EASBizException, BOSException {
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(ctx, system, companyInfo);
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod(ctx, system, companyInfo);
        if (startPeriod == null || currPeriod == null) {
            return new PeriodCollection();
        }
        ObjectUuidPK pkFrom = new ObjectUuidPK(startPeriod.getId());
        ObjectUuidPK pkTo = new ObjectUuidPK(currPeriod.getId());
        ObjectUuidPK companyPk = new ObjectUuidPK(companyInfo.getId());
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        PeriodCollection periodColl = iPeriod.getPeriodCollection((IObjectPK)pkFrom, (IObjectPK)pkTo, (IObjectPK)companyPk);
        return periodColl;
    }

    private PeriodInfo getPeriodInfo(Context ctx, CompanyOrgUnitInfo companyInfo, int PeriodYear, int PeriodNumber) throws EASBizException, BOSException {
        PeriodTypeInfo periodType = companyInfo.getAccountPeriodType();
        return PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo(PeriodYear, PeriodNumber, periodType);
    }

    @Override
    protected Map _cashContrastGL(Context ctx, String modelStr) throws BOSException, EASBizException {
        int notAuthrized;
        int notBalance;
        int balance;
        int countCompany;
        String result;
        HashMap<String, Object> cashContrastGLMsg;
        String errorMsg;
        int error;
        block32: {
            logger.info((Object)"CashContrastGLImpl of cashContrastGL start");
            error = 0;
            errorMsg = "";
            List cashContrastGLData = new ArrayList();
            cashContrastGLMsg = new HashMap<String, Object>();
            HashMap notCashContrastGLMsgMap = new HashMap();
            boolean isFalse = true;
            result = null;
            countCompany = 0;
            balance = 0;
            notBalance = 0;
            notAuthrized = 0;
            try {
                if (modelStr == null) {
                    error = 1;
                    errorMsg = CASWebUtil.getResource(ctx, "PelSelectedOneDataRow");
                    cashContrastGLMsg.put("error", error);
                    cashContrastGLMsg.put("errorMsg", errorMsg);
                    return cashContrastGLMsg;
                }
                HashMap modelMap = JSONUtils.convertJsonToObject((Context)ctx, (String)modelStr);
                PeriodInfo period = new PeriodInfo();
                period.setId(BOSUuid.read((String)((String)modelMap.get("period"))));
                period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(period.getId().toString()));
                if (modelMap.get("arr") != null) {
                    cashContrastGLData = (List)modelMap.get("arr");
                }
                if (cashContrastGLData.size() <= 0) break block32;
                countCompany = cashContrastGLData.size();
                ArrayList checkMsg = new ArrayList();
                CurrencyCollection currencyCollection = CashContrastGLWebFacadeControllerBean.getCurrencyCollection(ctx);
                for (int i = 0; i < cashContrastGLData.size(); ++i) {
                    int size;
                    boolean flag;
                    boolean fGLStart;
                    PeriodInfo currentPeriod;
                    boolean expired;
                    Map row = (Map)cashContrastGLData.get(i);
                    HashMap checkRow = new HashMap();
                    String reportMsg = "";
                    String companyId = (String)row.get("companyId");
                    CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                    company.setId(BOSUuid.read((String)companyId));
                    company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()));
                    isFalse = true;
                    checkRow.put("id", row.get("id"));
                    checkRow.put("company_name", row.get("company_name"));
                    checkRow.put("company_id", row.get("companyId"));
                    checkRow.put("check_msg", CASWebUtil.getResource(ctx, "Balance"));
                    checkRow.put("ckbUnTranVoucher", row.get("ckbUnTranVoucher"));
                    checkRow.put("ckbCancleAccountBank", row.get("ckbCancleAccountBank"));
                    checkRow.put("ckbUnBalance", row.get("ckbUnBalance"));
                    boolean cancleAccountBank = false;
                    boolean unBalance = false;
                    boolean unTranVoucher = false;
                    Map map = this.getUIOptionMap(ctx, company.getId().toString(), (Boolean)modelMap.get("isShare"));
                    unTranVoucher = TypeConversionUtils.objToBoolean(map.get("containNoAccVoucher"));
                    cancleAccountBank = TypeConversionUtils.objToBoolean(map.get("containInvalidBankAcc"));
                    boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), "cas_cashcontrastGLDetail_02query");
                    if (!isPermission) {
                        String cashcontrastGL_01view = CASWebUtil.getResource(ctx, "301_NO_CASHCONTRASTGLDETAIL_AUTHRIZED");
                        errorMsg = errorMsg + cashcontrastGL_01view;
                        reportMsg = reportMsg + errorMsg;
                        ++notAuthrized;
                        checkRow.put("check_msg", reportMsg);
                        checkMsg.add(checkRow);
                        continue;
                    }
                    String className = "bizCommonQuery.advancedQuery.com.kingdee.eas.dynamic.web.solution_cas_page";
                    try {
                        EntityViewInfo viewInfo = CashContrastGLWebFacadeControllerBean.getQuerySolutionViewInfo(null, className, company.getId().toString(), null);
                    }
                    catch (Exception e) {
                        throw new BOSException((Throwable)e);
                    }
                    if (company == null || GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company)) {
                        errorMsg = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"Company_AlertMsg", (Locale)ctx.getLocale());
                        reportMsg = reportMsg + errorMsg;
                        checkRow.put("Company_AlertMsg", errorMsg);
                        isFalse = false;
                    }
                    Date curDate = new Date();
                    Date invalidDate = company.getInvalidDate();
                    boolean bl = expired = invalidDate != null && curDate.after(invalidDate);
                    if (expired) {
                        errorMsg = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"Company_InvalidMsg", (Locale)ctx.getLocale());
                        reportMsg = reportMsg + errorMsg;
                        checkRow.put("Company_InvalidMsg", errorMsg);
                        isFalse = false;
                    }
                    if (company != null && company.isIsBizUnit()) {
                        PeriodInfo startPeriodInfo = null;
                        startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod(ctx, SystemEnum.CASHMANAGEMENT, company);
                        if (startPeriodInfo == null) {
                            errorMsg = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"StartPeriod_NullMsg", (Locale)ctx.getLocale());
                            reportMsg = reportMsg + errorMsg;
                            checkRow.put("periodError", errorMsg);
                            isFalse = false;
                        }
                    }
                    if ((currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(ctx, SystemEnum.CASHMANAGEMENT, company)) == null) {
                        errorMsg = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"MSG_periodError", (Locale)ctx.getLocale());
                        reportMsg = reportMsg + errorMsg;
                        checkRow.put("periodError", errorMsg);
                        isFalse = false;
                    }
                    if (!(fGLStart = SystemStatusCtrolUtils.isStart(ctx, SystemEnum.GENERALLEDGER, company))) {
                        errorMsg = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"CheckGLStart", (Locale)ctx.getLocale());
                        reportMsg = reportMsg + errorMsg;
                        checkRow.put("CheckGLStart", errorMsg);
                        isFalse = false;
                    }
                    if (!(flag = SystemStatusCtrolUtils.isStart(ctx, SystemEnum.CASHMANAGEMENT, company))) {
                        errorMsg = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"NoFinishInit", (Locale)ctx.getLocale());
                        reportMsg = reportMsg + errorMsg;
                        checkRow.put("NoFinishInit", errorMsg);
                        isFalse = false;
                    }
                    PeriodCollection commonPeriodColl = null;
                    try {
                        boolean flagCashGLPeriodNotValid = CashContrastGLWebFacadeControllerBean.checkCashGLPeriod(ctx, company);
                        if (!flagCashGLPeriodNotValid) {
                            errorMsg = EASResource.getString((String)resourceCheckoutPath, (String)"CashGLPeriodNotValid", (Locale)ctx.getLocale());
                            reportMsg = reportMsg + errorMsg;
                            checkRow.put("CashGLPeriodNotValid", errorMsg);
                            isFalse = false;
                        }
                        commonPeriodColl = CashContrastGLWebFacadeControllerBean.getCashGlPeriod(ctx, company);
                    }
                    catch (EASBizException flagCashGLPeriodNotValid) {
                    }
                    catch (BOSException flagCashGLPeriodNotValid) {
                        // empty catch block
                    }
                    if (!fGLStart) {
                        checkRow.put("check_msg", reportMsg);
                        checkMsg.add(checkRow);
                        continue;
                    }
                    PeriodInfo glPeriod = null;
                    glPeriod = SystemStatusCtrolUtils.getCurrentPeriod(ctx, SystemEnum.GENERALLEDGER, company);
                    int glYear = glPeriod.getPeriodYear();
                    int glNum = glPeriod.getPeriodNumber();
                    int spYear = period.getPeriodYear();
                    int spNum = period.getPeriodNumber();
                    if (spYear > glYear || spYear == glYear && spNum > glNum) {
                        errorMsg = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"CheckGLPeriod", (Locale)ctx.getLocale());
                        reportMsg = reportMsg + errorMsg;
                        checkRow.put("CheckGLPeriod", errorMsg);
                        isFalse = false;
                    }
                    if ((size = commonPeriodColl.size()) == 0) {
                        checkRow.put("check_msg", reportMsg);
                        checkMsg.add(checkRow);
                        continue;
                    }
                    PeriodInfo beginPeriod = commonPeriodColl.get(0);
                    PeriodInfo endPeriod = commonPeriodColl.get(size - 1);
                    int beginYear = beginPeriod.getPeriodYear();
                    int beginNum = beginPeriod.getPeriodNumber();
                    int endYear = endPeriod.getPeriodYear();
                    int endNum = endPeriod.getPeriodNumber();
                    if (spYear < beginYear || spYear == beginYear && spNum < beginNum || spYear > endYear || spYear == endYear && spNum > endNum) {
                        errorMsg = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"checkCashGLPeriod", (Locale)ctx.getLocale());
                        reportMsg = reportMsg + errorMsg;
                        checkRow.put("CheckGLPeriod", errorMsg);
                        isFalse = false;
                    }
                    if (!isFalse) {
                        checkRow.put("check_msg", reportMsg);
                    } else {
                        int periodYear = period.getPeriodYear();
                        int periodNumber = period.getPeriodNumber();
                        Date beginDate = null;
                        Timestamp endDate = null;
                        beginDate = period.getBeginDate();
                        endDate = period.getEndDate();
                        String acctTableId = CashContrastGLWebFacadeControllerBean.getCurrentAcctTable(ctx, company.getId().toString(), company.getAccountTable().getId().toString(), periodYear, periodNumber);
                        CapitalTypeEnum capitalType = CapitalTypeEnum.CASH;
                        AccountViewCollection acctViewColl = null;
                        block8: for (int j = 0; j < currencyCollection.size(); ++j) {
                            IRowSet rowSetGL;
                            IRowSet rowSetCash = DbUtil.executeQuery((Context)ctx, (String)("select top 1 Fid FROM T_CAS_Journal where  FCompanyID='" + company.getId() + "' AND FPeriodId='" + period.getId() + "'  AND  FCurrencyID='" + currencyCollection.get(j).getId() + "'"));
                            if (!rowSetCash.next() && (unTranVoucher ? !(rowSetGL = DbUtil.executeQuery((Context)ctx, (String)("select top 1 FOrgUnitID FROM T_GL_AccountBalance_1f where  FOrgUnitID='" + company.getId() + "' AND FPeriod=" + (spYear * 100 + spNum) + "  AND  FCurrencyID='" + currencyCollection.get(j).getId() + "'"))).next() : !(rowSetGL = DbUtil.executeQuery((Context)ctx, (String)("select top 1 FOrgUnitID FROM T_GL_AccountBalance_5f where  FOrgUnitID='" + company.getId() + "' AND FPeriod=" + (spYear * 100 + spNum) + "  AND  FCurrencyID='" + currencyCollection.get(j).getId() + "'"))).next())) continue;
                            acctViewColl = FMHelper.getAcctViewCollection((Context)ctx, (String)company.getId().toString(), (String)acctTableId, (String)currencyCollection.get(j).getId().toString(), (AccountTypeEnum)AccountTypeEnum.CASHACCOUNT);
                            for (int k = 0; k < acctViewColl.size(); ++k) {
                                CasContrastGLInfo casContrastGLInfo;
                                ICashBankContrastGL iCashGL = CashBankContrastGLFactory.getLocalInstance(ctx);
                                Map hashMap = iCashGL.getAllBankAcctCasContrastGLData(capitalType, acctViewColl.get(k).getNumber().toString(), null, currencyCollection.get(j).getNumber(), beginDate, endDate, period, unTranVoucher, company.getId().toString());
                                if (hashMap.size() <= 0 || (casContrastGLInfo = (CasContrastGLInfo)((Object)hashMap.get("byDiff"))) == null) continue;
                                for (int l = 0; l < 4; ++l) {
                                    BigDecimal amount = casContrastGLInfo.getBigDecimal(this.rowKeys[l]);
                                    BigDecimal zero = new BigDecimal("0");
                                    if (amount.equals(zero = zero.setScale(amount.scale(), 4))) continue;
                                    checkRow.put("check_msg", CASWebUtil.getResource(ctx, "Unbalance"));
                                    ++notBalance;
                                    break block8;
                                }
                            }
                        }
                        if (checkRow.get("check_msg").toString().equals(CASWebUtil.getResource(ctx, "Balance"))) {
                            capitalType = CapitalTypeEnum.BANK;
                            AccountBankCollection acctBankColl = CashContrastGLWebFacadeControllerBean.getAccountBankCollection(ctx, company.getId().toString(), cancleAccountBank);
                            block11: for (int j = 0; j < currencyCollection.size(); ++j) {
                                acctViewColl = FMHelper.getAcctViewCollection((Context)ctx, (String)company.getId().toString(), (String)acctTableId, (String)currencyCollection.get(j).getId().toString(), (AccountTypeEnum)AccountTypeEnum.BANKACCOUNT);
                                if (acctViewColl.size() == 0) continue;
                                for (int k = 0; k < acctBankColl.size(); ++k) {
                                    CasContrastGLInfo casContrastGLInfo;
                                    IRowSet rowSetGL;
                                    IRowSet rowSetM = DbUtil.executeQuery((Context)ctx, (String)("select top 1 Fid FROM T_CAS_Journal where  FCompanyID='" + company.getId() + "' AND FPeriodId='" + period.getId() + "' AND  FAccountBankID='" + acctBankColl.get(k).getId() + "'AND  FCurrencyID='" + currencyCollection.get(j).getId() + "'"));
                                    if (!rowSetM.next() && (!unTranVoucher ? !(rowSetGL = DbUtil.executeQuery((Context)ctx, (String)("select top 1 FOrgUnitID FROM T_GL_AccountBalance_5f where  FOrgUnitID='" + company.getId() + "' AND FPeriod=" + (spYear * 100 + spNum) + "  AND  FCurrencyID='" + currencyCollection.get(j).getId() + "'"))).next() : !(rowSetGL = DbUtil.executeQuery((Context)ctx, (String)("select top 1 FOrgUnitID FROM T_GL_AccountBalance_1f where  FOrgUnitID='" + company.getId() + "' AND FPeriod=" + (spYear * 100 + spNum) + "  AND  FCurrencyID='" + currencyCollection.get(j).getId() + "'"))).next())) continue;
                                    ICashBankContrastGL iCashGL = CashBankContrastGLFactory.getLocalInstance(ctx);
                                    Map hashMap = iCashGL.getAllBankAcctCasContrastGLData(capitalType, null, acctBankColl.get(k).getNumber().toString(), currencyCollection.get(j).getNumber(), beginDate, endDate, period, unTranVoucher, company.getId().toString());
                                    if (hashMap.size() <= 0 || (casContrastGLInfo = (CasContrastGLInfo)((Object)hashMap.get("byDiff"))) == null) continue;
                                    for (int l = 0; l < 4; ++l) {
                                        BigDecimal amount = casContrastGLInfo.getBigDecimal(this.rowKeys[l]);
                                        BigDecimal zero = new BigDecimal("0");
                                        if (amount.equals(zero = zero.setScale(amount.scale(), 4))) continue;
                                        checkRow.put("check_msg", CASWebUtil.getResource(ctx, "Unbalance"));
                                        ++notBalance;
                                        break block11;
                                    }
                                }
                            }
                        }
                    }
                    checkMsg.add(checkRow);
                }
                cashContrastGLMsg.put("checkMsg", checkMsg);
            }
            catch (Exception e) {
                error = 1;
                errorMsg = e.getMessage();
                logger.error((Object)"CashContrastGLImpl of cashContrastGL error", (Throwable)e);
                e.printStackTrace();
                cashContrastGLMsg.put("error", error);
                cashContrastGLMsg.put("errorMsg", errorMsg);
                return cashContrastGLMsg;
            }
        }
        balance = countCompany - notBalance - notAuthrized;
        result = CASWebUtil.getResource(ctx, "CashContrastResult", new String[]{String.valueOf(countCompany), String.valueOf(balance), String.valueOf(notBalance), String.valueOf(notAuthrized)});
        cashContrastGLMsg.put("error", error);
        cashContrastGLMsg.put("errorMsg", errorMsg);
        cashContrastGLMsg.put("result", result);
        logger.info((Object)"CashContrastGLImpl of cashContrastGL start");
        return cashContrastGLMsg;
    }

    public static CurrencyCollection getCurrencyCollection(Context ctx) throws BOSException, EASBizException {
        CurrencyCollection col = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(true);
        VOComparator comp = new VOComparator(new String[]{"number"}, true);
        Object[] infoArray = col.toArray();
        Arrays.sort(infoArray, comp);
        col.clear();
        for (int i = 0; i < infoArray.length; ++i) {
            col.addObject((IObjectValue)infoArray[i]);
        }
        return col;
    }

    public static EntityViewInfo getQuerySolutionViewInfo(String queryName, String parentPageName, String orgID, String userID) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("queryObjectName", (Object)queryName));
        filter.getFilterItems().add(new FilterItemInfo("parentUIName", (Object)parentPageName));
        filter.getFilterItems().add(new FilterItemInfo("shareType", (Object)String.valueOf(2)));
        filter.getFilterItems().add(new FilterItemInfo("isUserDefaultSolu", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgID));
        filter.setMaskString(" #0 AND #1 AND #2 AND #3 and #4 ");
        viewInfo.setFilter(filter);
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        sorterItemCollection.getSorter().decode("order by name");
        viewInfo.setSorter(sorterItemCollection);
        viewInfo.getSelector().addObjectCollection((IObjectCollection)CashContrastGLWebFacadeControllerBean.getSelectorItemCollection());
        return viewInfo;
    }

    public static boolean checkCashGLPeriod(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        PeriodCollection cashPeriodColl = CashContrastGLWebFacadeControllerBean.getPeriodColl(ctx, companyInfo, SystemEnum.CASHMANAGEMENT);
        PeriodCollection glPeriodColl = CashContrastGLWebFacadeControllerBean.getPeriodColl(ctx, companyInfo, SystemEnum.GENERALLEDGER);
        PeriodInfo cashPeriod = null;
        PeriodInfo glPeriod = null;
        for (int i = 0; i < cashPeriodColl.size(); ++i) {
            cashPeriod = cashPeriodColl.get(i);
            for (int j = 0; j < glPeriodColl.size(); ++j) {
                glPeriod = glPeriodColl.get(j);
                if (!cashPeriod.equals((Object)glPeriod)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getCurrentAcctTable(Context ctx, String companyID, String curAcctTableID, int periodYear, int periodNumber) throws BOSException, EASBizException {
        AccountRefContrastInfo info = AccountRefContrastFactory.getLocalInstance((Context)ctx).getLastAcctInfo(companyID, curAcctTableID, periodYear, periodNumber);
        return info == null ? null : info.getEnabledAcctTable().getId().toString();
    }

    public static AccountBankCollection getAccountBankCollection(Context ctx, String strCompanyId, boolean cancleAccountBank) throws BOSException {
        IAccountBank iAcctBank = AccountBankFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("bankaccountnumber");
        selector.add("name");
        selector.add("account.id");
        selector.add("account.number");
        selector.add("account.name");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (!cancleAccountBank) {
            filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)FMConstants.FALSE));
        }
        if (strCompanyId != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)strCompanyId));
        }
        filter.getFilterItems().add(new FilterItemInfo("isBank", (Object)FMConstants.TRUE));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        viewInfo.getSorter().add(new SorterItemInfo("number"));
        AccountBankCollection acctBankColl = iAcctBank.getAccountBankCollection(viewInfo);
        for (int i = 0; i < acctBankColl.size(); ++i) {
            acctBankColl.get(i).setDisplayFormat("$number$ - $name$");
        }
        return acctBankColl;
    }

    private static SelectorItemCollection getSelectorItemCollection() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.*"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.id"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.queryPanelType"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.panelClassName"));
        return sic;
    }

    @Override
    protected Map _getSumInitData(Context ctx, String companyId, String detailPeriodId, String strUnTranVoucher, String strCancleAccountBank, boolean isShare) throws BOSException, EASBizException {
        int error = 0;
        Object errorMsg = null;
        Object cashContrastGLData = null;
        HashMap<String, Object> onloadData = new HashMap<String, Object>();
        HashMap result = new HashMap();
        String asdsds = companyId + detailPeriodId;
        DecimalFormat COMMA_FORMAT = new DecimalFormat("#,###");
        try {
            IContextHelper contextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
            String userID = contextHelper.getCurrentUser().getId().toString();
            String pk = new String();
            BigInteger maxGroupNumber = new BigInteger("0");
            CurrencyCollection currencyCollection = CashContrastGLWebFacadeControllerBean.getCurrencyCollection(ctx);
            boolean unTranVoucher = false;
            boolean cancleAccountBank = false;
            boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), "cas_cashcontrastGL_03query");
            if (!isPermission) {
                throw new CasWebException(CasWebException.NO_CASHCONTRASTGL_AUTHRIZED);
            }
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            company.setId(BOSUuid.read((String)companyId));
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()));
            onloadData.put("labelCompany", company.getName());
            Map map = this.getUIOptionMap(ctx, company.getId().toString(), isShare);
            unTranVoucher = TypeConversionUtils.objToBoolean(map.get("containNoAccVoucher"));
            cancleAccountBank = TypeConversionUtils.objToBoolean(map.get("containInvalidBankAcc"));
            PeriodInfo period = new PeriodInfo();
            period = this.getPeriodInfo(ctx, company, Integer.parseInt(detailPeriodId));
            onloadData.put("labelPeriod", CASWebUtil.getResource(ctx, "WorkPlatform_Period", new String[]{String.valueOf(period.getPeriodYear()), String.valueOf(period.getPeriodNumber())}));
            int periodYear = period.getPeriodYear();
            int periodNumber = period.getPeriodNumber();
            Date beginDate = null;
            Timestamp endDate = null;
            beginDate = period.getBeginDate();
            endDate = period.getEndDate();
            String acctTableId = CashContrastGLWebFacadeControllerBean.getCurrentAcctTable(ctx, company.getId().toString(), company.getAccountTable().getId().toString(), periodYear, periodNumber);
            CapitalTypeEnum capitalType = CapitalTypeEnum.CASH;
            AccountViewCollection acctViewColl = null;
            ArrayList loadData = new ArrayList();
            for (int j = 0; j < currencyCollection.size(); ++j) {
                IRowSet rowSetGL;
                IRowSet rowSetCash = DbUtil.executeQuery((Context)ctx, (String)("select top 1 Fid FROM T_CAS_Journal where  FCompanyID='" + company.getId() + "' AND FPeriodId='" + period.getId() + "'  AND  FCurrencyID='" + currencyCollection.get(j).getId() + "'"));
                if (!rowSetCash.next() && (unTranVoucher ? !(rowSetGL = DbUtil.executeQuery((Context)ctx, (String)("select top 1 FOrgUnitID FROM T_GL_AccountBalance_1f where  FOrgUnitID='" + company.getId() + "' AND FPeriod=" + period.getNumber() + "  AND  FCurrencyID='" + currencyCollection.get(j).getId() + "'"))).next() : !(rowSetGL = DbUtil.executeQuery((Context)ctx, (String)("select top 1 FOrgUnitID FROM T_GL_AccountBalance_5f where  FOrgUnitID='" + company.getId() + "' AND FPeriod=" + period.getNumber() + "  AND  FCurrencyID='" + currencyCollection.get(j).getId() + "'"))).next())) continue;
                acctViewColl = FMHelper.getAcctViewCollection((Context)ctx, (String)company.getId().toString(), (String)acctTableId, (String)currencyCollection.get(j).getId().toString(), (AccountTypeEnum)AccountTypeEnum.CASHACCOUNT);
                for (int k = 0; k < acctViewColl.size(); ++k) {
                    ICashBankContrastGL iCashGL = CashBankContrastGLFactory.getLocalInstance(ctx);
                    Map hashMap = iCashGL.getAllBankAcctCasContrastGLData(capitalType, acctViewColl.get(k).getNumber().toString(), null, currencyCollection.get(j).getNumber(), beginDate, endDate, period, unTranVoucher, company.getId().toString());
                    if (hashMap.size() <= 0) continue;
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    row.put("accountBankNo", "");
                    row.put("accountBankNoId", "");
                    row.put("account", acctViewColl.get(k).getNumber().toString() + "<br>" + acctViewColl.get(k).getName());
                    row.put("accountId", acctViewColl.get(k).getId().toString());
                    row.put("currency", currencyCollection.get(j).getName());
                    row.put("currencyId", currencyCollection.get(j).getId().toString());
                    row.put("item", CASWebUtil.getResource(ctx, "amountBeginBalance") + "<br>" + CASWebUtil.getResource(ctx, "AmountDebitAmount") + "<br>" + CASWebUtil.getResource(ctx, "AmountCreditAmount") + "<br>" + CASWebUtil.getResource(ctx, "AmountEndBalance"));
                    row.put("result", CASWebUtil.getResource(ctx, "Balance"));
                    CasContrastGLInfo casContrastGLInfo = (CasContrastGLInfo)((Object)hashMap.get(this.keys[0]));
                    BigDecimal amountBeginBalance = casContrastGLInfo.getBigDecimal(this.rowKeys[0]);
                    BigDecimal amountDebitAmount = casContrastGLInfo.getBigDecimal(this.rowKeys[1]);
                    BigDecimal amountCreditAmount = casContrastGLInfo.getBigDecimal(this.rowKeys[2]);
                    BigDecimal amountEndBalance = casContrastGLInfo.getBigDecimal(this.rowKeys[3]);
                    row.put("beginBalance_cas", amountBeginBalance);
                    row.put("debitAmount_cas", amountDebitAmount);
                    row.put("creditAmount_cas", amountCreditAmount);
                    row.put("endBalance_cas", amountEndBalance);
                    BigDecimal zero = new BigDecimal("0");
                    zero = zero.setScale(amountBeginBalance.scale(), 4);
                    COMMA_FORMAT = new DecimalFormat("#,###" + zero.toString().substring(1));
                    String byCAS = "";
                    byCAS = amountBeginBalance.equals(zero) ? zero + "<br>" : COMMA_FORMAT.format(amountBeginBalance) + "<br>";
                    byCAS = amountDebitAmount.equals(zero) ? byCAS + zero + "<br>" : byCAS + COMMA_FORMAT.format(amountDebitAmount) + "<br>";
                    byCAS = amountCreditAmount.equals(zero) ? byCAS + zero + "<br>" : byCAS + COMMA_FORMAT.format(amountCreditAmount) + "<br>";
                    byCAS = amountEndBalance.equals(zero) ? byCAS + zero : byCAS + COMMA_FORMAT.format(amountEndBalance);
                    if (!(casContrastGLInfo == null || amountBeginBalance.equals(zero) && amountDebitAmount.equals(zero) && amountCreditAmount.equals(zero) && amountEndBalance.equals(zero))) {
                        row.put("byCAS", byCAS);
                    }
                    if ((casContrastGLInfo = (CasContrastGLInfo)((Object)hashMap.get(this.keys[1]))) != null) {
                        amountBeginBalance = casContrastGLInfo.getBigDecimal(this.rowKeys[0]);
                        amountDebitAmount = casContrastGLInfo.getBigDecimal(this.rowKeys[1]);
                        amountCreditAmount = casContrastGLInfo.getBigDecimal(this.rowKeys[2]);
                        amountEndBalance = casContrastGLInfo.getBigDecimal(this.rowKeys[3]);
                        row.put("beginBalance_gl", amountBeginBalance);
                        row.put("debitAmount_gl", amountDebitAmount);
                        row.put("creditAmount_gl", amountCreditAmount);
                        row.put("endBalance_gl", amountEndBalance);
                        zero = new BigDecimal("0");
                        zero = zero.setScale(amountBeginBalance.scale(), 4);
                        COMMA_FORMAT = new DecimalFormat("#,###" + zero.toString().substring(1));
                        String byGL = "";
                        byGL = amountBeginBalance.equals(zero) ? zero + "<br>" : COMMA_FORMAT.format(amountBeginBalance) + "<br>";
                        byGL = amountDebitAmount.equals(zero) ? byGL + zero + "<br>" : byGL + COMMA_FORMAT.format(amountDebitAmount) + "<br>";
                        byGL = amountCreditAmount.equals(zero) ? byGL + zero + "<br>" : byGL + COMMA_FORMAT.format(amountCreditAmount) + "<br>";
                        byGL = amountEndBalance.equals(zero) ? byGL + zero : byGL + COMMA_FORMAT.format(amountEndBalance);
                        if (!(amountBeginBalance.equals(zero) && amountDebitAmount.equals(zero) && amountCreditAmount.equals(zero) && amountEndBalance.equals(zero))) {
                            row.put("byGL", byGL);
                        }
                    }
                    if ((casContrastGLInfo = (CasContrastGLInfo)((Object)hashMap.get(this.keys[2]))) != null) {
                        amountBeginBalance = casContrastGLInfo.getBigDecimal(this.rowKeys[0]);
                        amountDebitAmount = casContrastGLInfo.getBigDecimal(this.rowKeys[1]);
                        amountCreditAmount = casContrastGLInfo.getBigDecimal(this.rowKeys[2]);
                        amountEndBalance = casContrastGLInfo.getBigDecimal(this.rowKeys[3]);
                        row.put("beginBalance_diff", amountBeginBalance);
                        row.put("debitAmount_diff", amountDebitAmount);
                        row.put("creditAmount_diff", amountCreditAmount);
                        row.put("endBalance_diff", amountEndBalance);
                        zero = new BigDecimal("0");
                        zero = zero.setScale(amountBeginBalance.scale(), 4);
                        COMMA_FORMAT = new DecimalFormat("#,###" + zero.toString().substring(1));
                        String byDIFF = "";
                        byDIFF = amountBeginBalance.equals(zero) ? zero + "<br>" : COMMA_FORMAT.format(amountBeginBalance) + "<br>";
                        byDIFF = amountDebitAmount.equals(zero) ? byDIFF + zero + "<br>" : byDIFF + COMMA_FORMAT.format(amountDebitAmount) + "<br>";
                        byDIFF = amountCreditAmount.equals(zero) ? byDIFF + zero + "<br>" : byDIFF + COMMA_FORMAT.format(amountCreditAmount) + "<br>";
                        byDIFF = amountEndBalance.equals(zero) ? byDIFF + zero : byDIFF + COMMA_FORMAT.format(amountEndBalance);
                        if (!(amountBeginBalance.equals(zero) && amountDebitAmount.equals(zero) && amountCreditAmount.equals(zero) && amountEndBalance.equals(zero))) {
                            row.put("byDIFF", byDIFF);
                            row.put("result", CASWebUtil.getResource(ctx, "Unbalance"));
                        }
                    }
                    if (row.get("byCAS") == null && row.get("byGL") == null && row.get("byDIFF") == null) continue;
                    if (row.get("byCAS") == null) {
                        row.put("byCAS", zero + "<br>" + zero + "<br>" + zero + "<br>" + zero);
                    }
                    if (row.get("byGL") == null) {
                        row.put("byGL", zero + "<br>" + zero + "<br>" + zero + "<br>" + zero);
                    }
                    if (row.get("byDIFF") == null) {
                        row.put("byDIFF", zero + "<br>" + zero + "<br>" + zero + "<br>" + zero);
                    }
                    pk = userID + period.getId().toString() + company.getId().toString() + acctViewColl.get(k).getId().toString() + currencyCollection.get(j).getId().toString();
                    ArrayList<Map<String, Object>> newCacheOfContrastRst = new ArrayList<Map<String, Object>>();
                    ArrayList<Map<String, Object>> newUnContrastCashRst = new ArrayList<Map<String, Object>>();
                    ArrayList<Map<String, Object>> newUnContrastGLRst = new ArrayList<Map<String, Object>>();
                    CashContrastGLHelper.saveCacheOfContrastRst(pk, newCacheOfContrastRst);
                    CashContrastGLHelper.saveCacheOfUncontrastCashRst(pk, newUnContrastCashRst);
                    CashContrastGLHelper.saveCacheOfUncontrastGLRst(pk, newUnContrastGLRst);
                    CashContrastGLHelper.saveCacheOfGroupMaxNumber(pk, maxGroupNumber);
                    loadData.add(row);
                }
            }
            capitalType = CapitalTypeEnum.BANK;
            AccountBankCollection acctBankColl = CashContrastGLWebFacadeControllerBean.getAccountBankCollection(ctx, company.getId().toString(), cancleAccountBank);
            acctBankColl = FMHelper.getJouranlBalanceAcctBank((Context)ctx, (AccountBankCollection)acctBankColl, (String)period.getId().toString(), (String)acctTableId);
            for (int h = 0; h < acctBankColl.size(); ++h) {
                IRowSet rowSetGL;
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)("select top 1 Fid FROM T_CAS_Journal where  FCompanyID='" + company.getId() + "' AND FPeriodId='" + period.getId() + "'  AND  FAccountBankID='" + acctBankColl.get(h).getId() + "'"));
                if (!rowSet.next() && (!unTranVoucher ? !(rowSetGL = DbUtil.executeQuery((Context)ctx, (String)("select top 1 FOrgUnitID FROM T_GL_AccountBalance_5f where  FOrgUnitID='" + company.getId() + "' AND FPeriod=" + period.getNumber()))).next() : !(rowSetGL = DbUtil.executeQuery((Context)ctx, (String)("select top 1 FOrgUnitID FROM T_GL_AccountBalance_1f where  FOrgUnitID='" + company.getId() + "' AND FPeriod=" + period.getNumber()))).next())) continue;
                boolean isByCurrency = acctBankColl.get(h).isIsByCurrency();
                if (isByCurrency) {
                    CurrencyInfo currencyInfo = acctBankColl.get(h).getCurrency();
                    ICashBankContrastGL iCashGL = CashBankContrastGLFactory.getLocalInstance(ctx);
                    Map hashMap = iCashGL.getAllBankAcctCasContrastGLData(capitalType, null, acctBankColl.get(h).getNumber().toString(), currencyInfo.getNumber(), beginDate, endDate, period, unTranVoucher, company.getId().toString());
                    if (hashMap.size() <= 0) continue;
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    row.put("accountBankNo", acctBankColl.get(h).getBankAccountNumber().toString() + "<br>" + acctBankColl.get(h).getName());
                    row.put("accountBankNoId", acctBankColl.get(h).getId().toString());
                    row.put("account", acctBankColl.get(h).getAccount().getNumber().toString() + "<br>" + acctBankColl.get(h).getAccount().getName());
                    row.put("accountId", acctBankColl.get(h).getAccount().getId().toString());
                    row.put("currency", currencyInfo.getName());
                    row.put("currencyId", currencyCollection.get(h).getId().toString());
                    row.put("item", CASWebUtil.getResource(ctx, "amountBeginBalance") + "<br>" + CASWebUtil.getResource(ctx, "AmountDebitAmount") + "<br>" + CASWebUtil.getResource(ctx, "AmountCreditAmount") + "<br>" + CASWebUtil.getResource(ctx, "AmountEndBalance"));
                    row.put("result", CASWebUtil.getResource(ctx, "Balance"));
                    CasContrastGLInfo casContrastGLInfo = (CasContrastGLInfo)((Object)hashMap.get(this.keys[0]));
                    BigDecimal amountBeginBalance = casContrastGLInfo.getBigDecimal(this.rowKeys[0]);
                    BigDecimal amountDebitAmount = casContrastGLInfo.getBigDecimal(this.rowKeys[1]);
                    BigDecimal amountCreditAmount = casContrastGLInfo.getBigDecimal(this.rowKeys[2]);
                    BigDecimal amountEndBalance = casContrastGLInfo.getBigDecimal(this.rowKeys[3]);
                    row.put("beginBalance_cas", amountBeginBalance);
                    row.put("debitAmount_cas", amountDebitAmount);
                    row.put("creditAmount_cas", amountCreditAmount);
                    row.put("endBalance_cas", amountEndBalance);
                    BigDecimal zero = new BigDecimal("0");
                    zero = zero.setScale(amountBeginBalance.scale(), 4);
                    COMMA_FORMAT = new DecimalFormat("#,###" + zero.toString().substring(1));
                    String byCAS = "";
                    byCAS = amountBeginBalance.equals(zero) ? zero + "<br>" : COMMA_FORMAT.format(amountBeginBalance) + "<br>";
                    byCAS = amountDebitAmount.equals(zero) ? byCAS + zero + "<br>" : byCAS + COMMA_FORMAT.format(amountDebitAmount) + "<br>";
                    byCAS = amountCreditAmount.equals(zero) ? byCAS + zero + "<br>" : byCAS + COMMA_FORMAT.format(amountCreditAmount) + "<br>";
                    byCAS = amountEndBalance.equals(zero) ? byCAS + zero : byCAS + COMMA_FORMAT.format(amountEndBalance);
                    if (!(casContrastGLInfo == null || amountBeginBalance.equals(zero) && amountDebitAmount.equals(zero) && amountCreditAmount.equals(zero) && amountEndBalance.equals(zero))) {
                        row.put("byCAS", byCAS);
                    }
                    if ((casContrastGLInfo = (CasContrastGLInfo)((Object)hashMap.get(this.keys[1]))) != null) {
                        amountBeginBalance = casContrastGLInfo.getBigDecimal(this.rowKeys[0]);
                        amountDebitAmount = casContrastGLInfo.getBigDecimal(this.rowKeys[1]);
                        amountCreditAmount = casContrastGLInfo.getBigDecimal(this.rowKeys[2]);
                        amountEndBalance = casContrastGLInfo.getBigDecimal(this.rowKeys[3]);
                        row.put("beginBalance_gl", amountBeginBalance);
                        row.put("debitAmount_gl", amountDebitAmount);
                        row.put("creditAmount_gl", amountCreditAmount);
                        row.put("endBalance_gl", amountEndBalance);
                        zero = new BigDecimal("0");
                        zero = zero.setScale(amountBeginBalance.scale(), 4);
                        COMMA_FORMAT = new DecimalFormat("#,###" + zero.toString().substring(1));
                        String byGL = "";
                        byGL = amountBeginBalance.equals(zero) ? zero + "<br>" : COMMA_FORMAT.format(amountBeginBalance) + "<br>";
                        byGL = amountDebitAmount.equals(zero) ? byGL + zero + "<br>" : byGL + COMMA_FORMAT.format(amountDebitAmount) + "<br>";
                        byGL = amountCreditAmount.equals(zero) ? byGL + zero + "<br>" : byGL + COMMA_FORMAT.format(amountCreditAmount) + "<br>";
                        byGL = amountEndBalance.equals(zero) ? byGL + zero : byGL + COMMA_FORMAT.format(amountEndBalance);
                        if (!(amountBeginBalance.equals(zero) && amountDebitAmount.equals(zero) && amountCreditAmount.equals(zero) && amountEndBalance.equals(zero))) {
                            row.put("byGL", byGL);
                        }
                    }
                    if ((casContrastGLInfo = (CasContrastGLInfo)((Object)hashMap.get(this.keys[2]))) != null) {
                        amountBeginBalance = casContrastGLInfo.getBigDecimal(this.rowKeys[0]);
                        amountDebitAmount = casContrastGLInfo.getBigDecimal(this.rowKeys[1]);
                        amountCreditAmount = casContrastGLInfo.getBigDecimal(this.rowKeys[2]);
                        amountEndBalance = casContrastGLInfo.getBigDecimal(this.rowKeys[3]);
                        row.put("beginBalance_diff", amountBeginBalance);
                        row.put("debitAmount_diff", amountDebitAmount);
                        row.put("creditAmount_diff", amountCreditAmount);
                        row.put("endBalance_diff", amountEndBalance);
                        zero = new BigDecimal("0");
                        zero = zero.setScale(amountBeginBalance.scale(), 4);
                        COMMA_FORMAT = new DecimalFormat("#,###" + zero.toString().substring(1));
                        String byDIFF = "";
                        byDIFF = amountBeginBalance.equals(zero) ? zero + "<br>" : COMMA_FORMAT.format(amountBeginBalance) + "<br>";
                        byDIFF = amountDebitAmount.equals(zero) ? byDIFF + zero + "<br>" : byDIFF + COMMA_FORMAT.format(amountDebitAmount) + "<br>";
                        byDIFF = amountCreditAmount.equals(zero) ? byDIFF + zero + "<br>" : byDIFF + COMMA_FORMAT.format(amountCreditAmount) + "<br>";
                        byDIFF = amountEndBalance.equals(zero) ? byDIFF + zero : byDIFF + COMMA_FORMAT.format(amountEndBalance);
                        if (!(amountBeginBalance.equals(zero) && amountDebitAmount.equals(zero) && amountCreditAmount.equals(zero) && amountEndBalance.equals(zero))) {
                            row.put("byDIFF", byDIFF);
                            row.put("result", CASWebUtil.getResource(ctx, "Unbalance"));
                        }
                    }
                    if (row.get("byCAS") == null && row.get("byGL") == null && row.get("byDIFF") == null) continue;
                    if (row.get("byCAS") == null) {
                        row.put("byCAS", zero + "<br>" + zero + "<br>" + zero + "<br>" + zero);
                    }
                    if (row.get("byGL") == null) {
                        row.put("byGL", zero + "<br>" + zero + "<br>" + zero + "<br>" + zero);
                    }
                    if (row.get("byDIFF") == null) {
                        row.put("byDIFF", zero + "<br>" + zero + "<br>" + zero + "<br>" + zero);
                    }
                    pk = userID + period.getId().toString() + company.getId().toString() + acctBankColl.get(h).getId().toString() + acctBankColl.get(h).getAccount().getId().toString() + currencyCollection.get(h).getId().toString();
                    ArrayList<Map<String, Object>> newCacheOfContrastRst = new ArrayList<Map<String, Object>>();
                    ArrayList<Map<String, Object>> newUnContrastCashRst = new ArrayList<Map<String, Object>>();
                    ArrayList<Map<String, Object>> newUnContrastGLRst = new ArrayList<Map<String, Object>>();
                    CashContrastGLHelper.saveCacheOfContrastRst(pk, newCacheOfContrastRst);
                    CashContrastGLHelper.saveCacheOfUncontrastCashRst(pk, newUnContrastCashRst);
                    CashContrastGLHelper.saveCacheOfUncontrastGLRst(pk, newUnContrastGLRst);
                    CashContrastGLHelper.saveCacheOfGroupMaxNumber(pk, maxGroupNumber);
                    loadData.add(row);
                    continue;
                }
                for (int j = 0; j < currencyCollection.size(); ++j) {
                    ICashBankContrastGL iCashGL;
                    Map hashMap;
                    IRowSet rowSetGL2;
                    IRowSet rowSetM = DbUtil.executeQuery((Context)ctx, (String)("select top 1 Fid FROM T_CAS_Journal where  FCompanyID='" + company.getId() + "' AND FPeriodId='" + period.getId() + "' AND  FAccountBankID='" + acctBankColl.get(h).getId() + "'AND  FCurrencyID='" + currencyCollection.get(j).getId() + "'"));
                    if (!rowSetM.next() && (!unTranVoucher ? !(rowSetGL2 = DbUtil.executeQuery((Context)ctx, (String)("select top 1 FOrgUnitID FROM T_GL_AccountBalance_5f where  FOrgUnitID='" + company.getId() + "' AND FPeriod=" + period.getNumber() + "  AND  FCurrencyID='" + currencyCollection.get(j).getId() + "'"))).next() : !(rowSetGL2 = DbUtil.executeQuery((Context)ctx, (String)("select top 1 FOrgUnitID FROM T_GL_AccountBalance_1f where  FOrgUnitID='" + company.getId() + "' AND FPeriod=" + period.getNumber() + "  AND  FCurrencyID='" + currencyCollection.get(j).getId() + "'"))).next()) || (hashMap = (iCashGL = CashBankContrastGLFactory.getLocalInstance(ctx)).getAllBankAcctCasContrastGLData(capitalType, null, acctBankColl.get(h).getNumber().toString(), currencyCollection.get(j).getNumber(), beginDate, endDate, period, unTranVoucher, company.getId().toString())).size() <= 0) continue;
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    row.put("accountBankNo", acctBankColl.get(h).getBankAccountNumber().toString() + "<br>" + acctBankColl.get(h).getName());
                    row.put("accountBankNoId", acctBankColl.get(h).getId().toString());
                    row.put("account", acctBankColl.get(h).getAccount().getNumber().toString() + "<br>" + acctBankColl.get(h).getAccount().getName());
                    row.put("accountId", acctBankColl.get(h).getAccount().getId().toString());
                    row.put("currency", currencyCollection.get(j).getName());
                    row.put("currencyId", currencyCollection.get(j).getId().toString());
                    row.put("item", CASWebUtil.getResource(ctx, "amountBeginBalance") + "<br>" + CASWebUtil.getResource(ctx, "AmountDebitAmount") + "<br>" + CASWebUtil.getResource(ctx, "AmountCreditAmount") + "<br>" + CASWebUtil.getResource(ctx, "AmountEndBalance"));
                    row.put("result", CASWebUtil.getResource(ctx, "Balance"));
                    CasContrastGLInfo casContrastGLInfo = (CasContrastGLInfo)((Object)hashMap.get(this.keys[0]));
                    BigDecimal amountBeginBalance = casContrastGLInfo.getBigDecimal(this.rowKeys[0]);
                    BigDecimal amountDebitAmount = casContrastGLInfo.getBigDecimal(this.rowKeys[1]);
                    BigDecimal amountCreditAmount = casContrastGLInfo.getBigDecimal(this.rowKeys[2]);
                    BigDecimal amountEndBalance = casContrastGLInfo.getBigDecimal(this.rowKeys[3]);
                    row.put("beginBalance_cas", amountBeginBalance);
                    row.put("debitAmount_cas", amountDebitAmount);
                    row.put("creditAmount_cas", amountCreditAmount);
                    row.put("endBalance_cas", amountEndBalance);
                    BigDecimal zero = new BigDecimal("0");
                    zero = zero.setScale(amountBeginBalance.scale(), 4);
                    COMMA_FORMAT = new DecimalFormat("#,###" + zero.toString().substring(1));
                    String byCAS = "";
                    byCAS = amountBeginBalance.equals(zero) ? zero + "<br>" : COMMA_FORMAT.format(amountBeginBalance) + "<br>";
                    byCAS = amountDebitAmount.equals(zero) ? byCAS + zero + "<br>" : byCAS + COMMA_FORMAT.format(amountDebitAmount) + "<br>";
                    byCAS = amountCreditAmount.equals(zero) ? byCAS + zero + "<br>" : byCAS + COMMA_FORMAT.format(amountCreditAmount) + "<br>";
                    byCAS = amountEndBalance.equals(zero) ? byCAS + zero : byCAS + COMMA_FORMAT.format(amountEndBalance);
                    if (!(casContrastGLInfo == null || amountBeginBalance.equals(zero) && amountDebitAmount.equals(zero) && amountCreditAmount.equals(zero) && amountEndBalance.equals(zero))) {
                        row.put("byCAS", byCAS);
                    }
                    if ((casContrastGLInfo = (CasContrastGLInfo)((Object)hashMap.get(this.keys[1]))) != null) {
                        amountBeginBalance = casContrastGLInfo.getBigDecimal(this.rowKeys[0]);
                        amountDebitAmount = casContrastGLInfo.getBigDecimal(this.rowKeys[1]);
                        amountCreditAmount = casContrastGLInfo.getBigDecimal(this.rowKeys[2]);
                        amountEndBalance = casContrastGLInfo.getBigDecimal(this.rowKeys[3]);
                        row.put("beginBalance_gl", amountBeginBalance);
                        row.put("debitAmount_gl", amountDebitAmount);
                        row.put("creditAmount_gl", amountCreditAmount);
                        row.put("endBalance_gl", amountEndBalance);
                        zero = new BigDecimal("0");
                        zero = zero.setScale(amountBeginBalance.scale(), 4);
                        COMMA_FORMAT = new DecimalFormat("#,###" + zero.toString().substring(1));
                        String byGL = "";
                        byGL = amountBeginBalance.equals(zero) ? zero + "<br>" : COMMA_FORMAT.format(amountBeginBalance) + "<br>";
                        byGL = amountDebitAmount.equals(zero) ? byGL + zero + "<br>" : byGL + COMMA_FORMAT.format(amountDebitAmount) + "<br>";
                        byGL = amountCreditAmount.equals(zero) ? byGL + zero + "<br>" : byGL + COMMA_FORMAT.format(amountCreditAmount) + "<br>";
                        byGL = amountEndBalance.equals(zero) ? byGL + zero : byGL + COMMA_FORMAT.format(amountEndBalance);
                        if (!(amountBeginBalance.equals(zero) && amountDebitAmount.equals(zero) && amountCreditAmount.equals(zero) && amountEndBalance.equals(zero))) {
                            row.put("byGL", byGL);
                        }
                    }
                    if ((casContrastGLInfo = (CasContrastGLInfo)((Object)hashMap.get(this.keys[2]))) != null) {
                        amountBeginBalance = casContrastGLInfo.getBigDecimal(this.rowKeys[0]);
                        amountDebitAmount = casContrastGLInfo.getBigDecimal(this.rowKeys[1]);
                        amountCreditAmount = casContrastGLInfo.getBigDecimal(this.rowKeys[2]);
                        amountEndBalance = casContrastGLInfo.getBigDecimal(this.rowKeys[3]);
                        row.put("beginBalance_diff", amountBeginBalance);
                        row.put("debitAmount_diff", amountDebitAmount);
                        row.put("creditAmount_diff", amountCreditAmount);
                        row.put("endBalance_diff", amountEndBalance);
                        zero = new BigDecimal("0");
                        zero = zero.setScale(amountBeginBalance.scale(), 4);
                        COMMA_FORMAT = new DecimalFormat("#,###" + zero.toString().substring(1));
                        String byDIFF = "";
                        byDIFF = amountBeginBalance.equals(zero) ? zero + "<br>" : COMMA_FORMAT.format(amountBeginBalance) + "<br>";
                        byDIFF = amountDebitAmount.equals(zero) ? byDIFF + zero + "<br>" : byDIFF + COMMA_FORMAT.format(amountDebitAmount) + "<br>";
                        byDIFF = amountCreditAmount.equals(zero) ? byDIFF + zero + "<br>" : byDIFF + COMMA_FORMAT.format(amountCreditAmount) + "<br>";
                        byDIFF = amountEndBalance.equals(zero) ? byDIFF + zero : byDIFF + COMMA_FORMAT.format(amountEndBalance);
                        if (!(amountBeginBalance.equals(zero) && amountDebitAmount.equals(zero) && amountCreditAmount.equals(zero) && amountEndBalance.equals(zero))) {
                            row.put("byDIFF", byDIFF);
                            row.put("result", CASWebUtil.getResource(ctx, "Unbalance"));
                        }
                    }
                    if (row.get("byCAS") == null && row.get("byGL") == null && row.get("byDIFF") == null) continue;
                    if (row.get("byCAS") == null) {
                        row.put("byCAS", zero + "<br>" + zero + "<br>" + zero + "<br>" + zero);
                    }
                    if (row.get("byGL") == null) {
                        row.put("byGL", zero + "<br>" + zero + "<br>" + zero + "<br>" + zero);
                    }
                    if (row.get("byDIFF") == null) {
                        row.put("byDIFF", zero + "<br>" + zero + "<br>" + zero + "<br>" + zero);
                    }
                    pk = userID + period.getId().toString() + company.getId().toString() + acctBankColl.get(h).getId().toString() + acctBankColl.get(h).getAccount().getId().toString() + currencyCollection.get(j).getId().toString();
                    ArrayList<Map<String, Object>> newCacheOfContrastRst = new ArrayList<Map<String, Object>>();
                    ArrayList<Map<String, Object>> newUnContrastCashRst = new ArrayList<Map<String, Object>>();
                    ArrayList<Map<String, Object>> newUnContrastGLRst = new ArrayList<Map<String, Object>>();
                    CashContrastGLHelper.saveCacheOfContrastRst(pk, newCacheOfContrastRst);
                    CashContrastGLHelper.saveCacheOfUncontrastCashRst(pk, newUnContrastCashRst);
                    CashContrastGLHelper.saveCacheOfUncontrastGLRst(pk, newUnContrastGLRst);
                    CashContrastGLHelper.saveCacheOfGroupMaxNumber(pk, maxGroupNumber);
                    loadData.add(row);
                }
            }
            onloadData.put("period", period);
            onloadData.put("company", company);
            onloadData.put("onloadData", loadData);
            onloadData.put("error", error);
            onloadData.put("errorMsg", errorMsg);
            ArrayList convertedLoadData = new ArrayList();
            for (int i = 0; i < loadData.size(); ++i) {
                HashMap row0 = new HashMap();
                HashMap row1 = new HashMap();
                HashMap row2 = new HashMap();
                HashMap row3 = new HashMap();
                Map orginalRow = (Map)loadData.get(i);
                Object[] keys = orginalRow.keySet().toArray();
                for (int j = 0; j < keys.length; ++j) {
                    row0.put((String)keys[j], orginalRow.get(keys[j]));
                    row1.put((String)keys[j], orginalRow.get(keys[j]));
                    row2.put((String)keys[j], orginalRow.get(keys[j]));
                    row3.put((String)keys[j], orginalRow.get(keys[j]));
                }
                String rowSpanKey = orginalRow.get("accountBankNoId") + "-" + orginalRow.get("accountId") + "-" + orginalRow.get("currencyId");
                row0.put("rowSpanKey", rowSpanKey);
                row1.put("rowSpanKey", rowSpanKey);
                row2.put("rowSpanKey", rowSpanKey);
                row3.put("rowSpanKey", rowSpanKey);
                String querySeq_No = i + 1 + "";
                row0.put("querySeq_No", querySeq_No);
                row1.put("querySeq_No", querySeq_No);
                row2.put("querySeq_No", querySeq_No);
                row3.put("querySeq_No", querySeq_No);
                row0.put("item", CASWebUtil.getResource(ctx, "amountBeginBalance"));
                row1.put("item", CASWebUtil.getResource(ctx, "AmountDebitAmount"));
                row2.put("item", CASWebUtil.getResource(ctx, "AmountCreditAmount"));
                row3.put("item", CASWebUtil.getResource(ctx, "AmountEndBalance"));
                row0.put("byCAS", CASWebUtil.formatNumber((BigDecimal)orginalRow.get("beginBalance_cas")));
                row0.put("byGL", CASWebUtil.formatNumber((BigDecimal)orginalRow.get("beginBalance_gl")));
                row0.put("byDIFF", CASWebUtil.formatNumber((BigDecimal)orginalRow.get("beginBalance_diff")));
                row1.put("byCAS", CASWebUtil.formatNumber((BigDecimal)orginalRow.get("debitAmount_cas")));
                row1.put("byGL", CASWebUtil.formatNumber((BigDecimal)orginalRow.get("debitAmount_gl")));
                row1.put("byDIFF", CASWebUtil.formatNumber((BigDecimal)orginalRow.get("debitAmount_diff")));
                row2.put("byCAS", CASWebUtil.formatNumber((BigDecimal)orginalRow.get("creditAmount_cas")));
                row2.put("byGL", CASWebUtil.formatNumber((BigDecimal)orginalRow.get("creditAmount_gl")));
                row2.put("byDIFF", CASWebUtil.formatNumber((BigDecimal)orginalRow.get("creditAmount_diff")));
                row3.put("byCAS", CASWebUtil.formatNumber((BigDecimal)orginalRow.get("endBalance_cas")));
                row3.put("byGL", CASWebUtil.formatNumber((BigDecimal)orginalRow.get("endBalance_gl")));
                row3.put("byDIFF", CASWebUtil.formatNumber((BigDecimal)orginalRow.get("endBalance_diff")));
                convertedLoadData.add(row0);
                convertedLoadData.add(row1);
                convertedLoadData.add(row2);
                convertedLoadData.add(row3);
            }
            onloadData.put("onloadData", convertedLoadData);
            return onloadData;
        }
        catch (Exception e) {
            logger.error((Object)e);
            e.printStackTrace();
            onloadData.put("error", 1);
            onloadData.put("errorMsg", e.getMessage());
            return onloadData;
        }
    }

    public Map getUIOptionMap(Context ctx, String companyID, boolean isShare) throws BOSException, EASBizException {
        EntityViewInfo viewInfo;
        HashMap searchFilter = new HashMap();
        String className = "bizCommonQuery.advancedQuery.com.kingdee.eas.fi.cas.solution_cas_page";
        if (isShare) {
            className = className + "Share";
        }
        try {
            viewInfo = CashContrastGLWebFacadeControllerBean.getQuerySolutionViewInfo(null, className, companyID, null);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        IQuerySolution iSolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
        QuerySolutionCollection solutionCol = iSolution.getQuerySolutionCollection(viewInfo);
        if (solutionCol.size() > 0) {
            QuerySolutionInfo solutionInfo = solutionCol.get(0);
            if (solutionInfo != null && solutionInfo.getSolutionType() == SolutionTypeEnum.CUSTOMER_SOLUTION) {
                QueryPanelCollection queryPanels = solutionInfo.getQueryPanelInfo();
                String customerParams = "";
                for (int i0 = 0; i0 < queryPanels.size(); ++i0) {
                    QueryPanelInfo info = queryPanels.get(i0);
                    customerParams = info.getCustomerParams();
                }
                CustomerParams cp = CustomerParams.getCustomerParams2((String)customerParams);
                searchFilter = cp.getCustomerParamsHashMap();
            }
        } else {
            searchFilter.put("bizDateEq", Boolean.FALSE);
            searchFilter.put("settlementTypeEq", Boolean.FALSE);
            searchFilter.put("voucherNumberEq", Boolean.FALSE);
            searchFilter.put("descriptionEq", Boolean.FALSE);
            searchFilter.put("settlementNumberEq", Boolean.FALSE);
            searchFilter.put("containNoAccVoucher", Boolean.FALSE);
            searchFilter.put("containInvalidBankAcc", Boolean.FALSE);
        }
        return searchFilter;
    }

    private PeriodInfo getPeriodInfo(Context ctx, CompanyOrgUnitInfo companyInfo, int period) throws EASBizException, BOSException {
        int PeriodYear = period / 100;
        int PeriodNumber = period % 100;
        PeriodTypeInfo periodType = companyInfo.getAccountPeriodType();
        return PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo(PeriodYear, PeriodNumber, periodType);
    }

    @Override
    protected Map _sucessContrast(Context ctx, String companyId, String detailPeriodId, String strUnTranVoucher, String strCancleAccountBank) throws BOSException, EASBizException {
        boolean error = false;
        Object errorMsg = null;
        Object cashContrastGLData = null;
        HashMap onloadData = new HashMap();
        HashMap result = new HashMap();
        return result;
    }

    @Override
    protected Map _getDiffRptInitData(Context ctx, String companyId, String periodId, String accountBankNoId, String accountId, String currencyId, boolean isShare) throws BOSException, EASBizException {
        int error = 0;
        String errorMsg = null;
        Object cashContrastGLData = null;
        HashMap<String, Object> onloadData = new HashMap<String, Object>();
        HashMap result = new HashMap();
        try {
            Map<Object, Object> glRow;
            int flag;
            boolean isPermission;
            IContextHelper contextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
            String userID = contextHelper.getCurrentUser().getId().toString();
            PeriodInfo period = new PeriodInfo();
            period.setId(BOSUuid.read((String)periodId));
            period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(period.getId().toString()));
            onloadData.put("labelPeriod", CASWebUtil.getResource(ctx, "WorkPlatform_Period", new String[]{String.valueOf(period.getPeriodYear()), String.valueOf(period.getPeriodNumber())}));
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            company.setId(BOSUuid.read((String)companyId));
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()));
            onloadData.put("labelCompany", company.getName());
            Map map = this.getUIOptionMap(ctx, company.getId().toString(), isShare);
            FmRpcCacheInfo paramInfo = new FmRpcCacheInfo();
            paramInfo.setBatchImplClassName(this.getRpcBatchImplClassName());
            paramInfo.put("company", (Object)company);
            this.rpcCacheInfo = FMBatchProcessFacadeFactory.getLocalInstance((Context)ctx).batchFetchData(paramInfo);
            AccountBankInfo accountBank = new AccountBankInfo();
            CapitalTypeEnum capitalType = CapitalTypeEnum.CASH;
            HashSet<String> bankAcctIdSet = new HashSet<String>();
            if (accountBankNoId.length() != 0) {
                accountBank.setId(BOSUuid.read((String)accountBankNoId));
                accountBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountBank.getId().toString()));
                capitalType = CapitalTypeEnum.BANK;
                bankAcctIdSet.add(accountBank.getId().toString());
                onloadData.put("labelAccountBank", accountBank.getBankAccountNumber());
            }
            AccountViewInfo accountView = new AccountViewInfo();
            accountView.setId(BOSUuid.read((String)accountId));
            accountView = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountView.getId().toString()));
            HashSet<String> acctViewIdSet = new HashSet<String>();
            acctViewIdSet.add(accountView.getId().toString());
            onloadData.put("labelAccountView", accountView.getName());
            CurrencyInfo currency = new CurrencyInfo();
            currency.setId(BOSUuid.read((String)currencyId));
            currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId().toString()));
            onloadData.put("labelCurrency", currency.getName());
            MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.fi.cas", "CashSystemWebQuery");
            EntityViewInfo mainQuery = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id ", (Object)company.getId()));
            filter.getFilterItems().add(new FilterItemInfo("createDate", (Object)period.getBeginDate(), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("createDate", (Object)period.getEndDate(), CompareType.LESS_EQUALS));
            mainQuery.setFilter(filter);
            ArrayList<Map<String, Object>> loadData = new ArrayList();
            ArrayList GLRsData = new ArrayList();
            String pk = new String();
            pk = accountBankNoId.length() != 0 ? userID + period.getId().toString() + company.getId().toString() + accountBank.getId().toString() + accountView.getId().toString() + currency.getId().toString() : userID + period.getId().toString() + company.getId().toString() + accountView.getId().toString() + currency.getId().toString();
            onloadData.put("pk", pk);
            int precision = this.getPrecision(ctx, currencyId);
            onloadData.put("precision", precision);
            List<Object> cacheOfUnContrastCashRst = new ArrayList();
            cacheOfUnContrastCashRst = CashContrastGLHelper.getCacheOfUnContrastCashRst(pk);
            if (cacheOfUnContrastCashRst.size() >= 1) {
                onloadData.put("cashData", cacheOfUnContrastCashRst);
            }
            if (!(isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), "cas_cashcontrastGL_03query"))) {
                onloadData.put("period", period);
                onloadData.put("company", company);
                onloadData.put("accountBank", accountBank);
                onloadData.put("accountView", accountView);
                onloadData.put("currency", currency);
                throw new CasWebException(CasWebException.NO_CASHCONTRASTGL_AUTHRIZED);
            }
            List<Object> cacheOfUnContrastGLRst = new ArrayList();
            cacheOfUnContrastGLRst = CashContrastGLHelper.getCacheOfUnContrastGLRst(pk);
            if (cacheOfUnContrastGLRst.size() >= 1) {
                for (int k = 0; k < cacheOfUnContrastGLRst.size(); ++k) {
                    Map glRow2 = new HashMap();
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    glRow2 = (Map)cacheOfUnContrastGLRst.get(k);
                    row.put("GLselect", Boolean.FALSE);
                    row.put("GLrecord", CASWebUtil.getResource(ctx, "GL"));
                    row.put("GLsystem", glRow2.get("system"));
                    row.put("GLoppAccountView", glRow2.get("oppAccountView"));
                    row.put("GLsettTypeNumber", glRow2.get("settTypeNumber"));
                    row.put("GLdate", glRow2.get("date"));
                    row.put("GLdescription", glRow2.get("description"));
                    row.put("GLvoucher", glRow2.get("voucher"));
                    row.put("GLvoucherNumber", glRow2.get("voucherNumber"));
                    row.put("GLdebitAmount", glRow2.get("debitAmount"));
                    row.put("GLcreditAmount", glRow2.get("creditAmount"));
                    row.put("GLflag", glRow2.get("flag"));
                    row.put("GLcheck", glRow2.get("check"));
                    row.put("GLsource", glRow2.get("source"));
                    GLRsData.add(row);
                }
                onloadData.put("gldata", GLRsData);
            }
            if (cacheOfUnContrastCashRst.size() >= 1 || cacheOfUnContrastGLRst.size() >= 1) {
                onloadData.put("period", period);
                onloadData.put("company", company);
                onloadData.put("accountBank", accountBank);
                onloadData.put("accountView", accountView);
                onloadData.put("currency", currency);
                onloadData.put("error", error);
                onloadData.put("errorMsg", errorMsg);
                return onloadData;
            }
            List<Object> cacheOfContrastRst = new ArrayList();
            cacheOfContrastRst = CashContrastGLHelper.getCacheOfContrastRst(pk);
            if (cacheOfContrastRst.size() >= 1) {
                onloadData.put("period", period);
                onloadData.put("company", company);
                onloadData.put("accountBank", accountBank);
                onloadData.put("accountView", accountView);
                onloadData.put("currency", currency);
                onloadData.put("onloadData", cacheOfContrastRst);
                onloadData.put("error", error);
                onloadData.put("errorMsg", errorMsg);
                return onloadData;
            }
            IRowSet cashRs = this.getCashRowset(ctx, (IMetaDataPK)mainQueryPK, mainQuery, currency.getId(), bankAcctIdSet, acctViewIdSet, capitalType, period);
            MetaDataPK gLSystemQueryPK = new MetaDataPK("com.kingdee.eas.fi.cas", "GLSystemWebQuery");
            EntityViewInfo gLSystemQuery = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id ", (Object)company.getId()));
            filter.getFilterItems().add(new FilterItemInfo("createDate", (Object)period.getBeginDate(), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("createDate", (Object)period.getEndDate(), CompareType.LESS_EQUALS));
            FilterInfo filterbizStatus = new FilterInfo();
            filterbizStatus.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(5), CompareType.EQUALS));
            if (TypeConversionUtils.objToBoolean(map.get("containNoAccVoucher"))) {
                filterbizStatus.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(1), CompareType.EQUALS));
                filterbizStatus.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(3), CompareType.EQUALS));
                filterbizStatus.setMaskString("#0 or #1 or #2");
            }
            filter.mergeFilter(filterbizStatus, "and");
            gLSystemQuery.setFilter(filter);
            IRowSet glRs = CashBankContrastGLFactory.getLocalInstance(ctx).getGLRowset((IObjectPK)gLSystemQueryPK, (IObjectValue)gLSystemQuery, currency.getId(), bankAcctIdSet, acctViewIdSet, capitalType, period);
            if (cashRs != null || cashRs.size() != 0 || glRs != null || glRs.size() != 0) {
                int i = 0;
                while (cashRs.next()) {
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    row.put("select", Boolean.FALSE);
                    row.put("record", CASWebUtil.getResource(ctx, "CASH"));
                    row.put("system", EASResource.getString((String)resourcePath, (String)"CashSystem"));
                    row.put("id", "1" + i++);
                    row.put("date", cashRs.getDate("createDate"));
                    row.put("description", cashRs.getString("description"));
                    String voucherTypeNumber = "";
                    String voucherNumber = "";
                    if (cashRs.getString("voucherNumber") != null) {
                        voucherTypeNumber = voucherNumber = cashRs.getString("voucherNumber");
                    }
                    String voucherType = "";
                    if (cashRs.getString("voucherType.name") != null) {
                        voucherType = cashRs.getString("voucherType.name");
                        voucherTypeNumber = voucherType + "\u3000" + voucherTypeNumber;
                    }
                    row.put("voucher", voucherTypeNumber);
                    row.put("voucherNumber", cashRs.getString("voucherNumber"));
                    String oppAccountView = "";
                    if (cashRs.getString("oppAccountView.number") != null) {
                        oppAccountView = cashRs.getString("oppAccountView.number") + "\u3000" + cashRs.getString("oppAccountView.name");
                    }
                    row.put("oppAccountView", oppAccountView);
                    String settTypeNumber = "";
                    String settType = "";
                    String settNumber = "";
                    if (cashRs.getString("settlementNumber") != null) {
                        settTypeNumber = settNumber = cashRs.getString("settlementNumber");
                    }
                    if (cashRs.getString("settlementType.name") != null) {
                        settType = cashRs.getString("settlementType.name");
                        settTypeNumber = settType + "\u3000" + settTypeNumber;
                    }
                    row.put("settTypeNumber", settTypeNumber);
                    row.put("settType", settType);
                    row.put("settNumber", settNumber);
                    row.put("debitAmount", cashRs.getBigDecimal("debitAmount").setScale(precision, 4) + "");
                    row.put("creditAmount", cashRs.getBigDecimal("creditAmount").setScale(precision, 4) + "");
                    row.put("flag", new Integer(0));
                    row.put("cash", cashRs.getString("cashier.name"));
                    row.put("source", JournalSourceEnum.getEnum((int)cashRs.getInt("source")).getAlias());
                    loadData.add(row);
                    this.cashRsData.add(row);
                }
                Iterator it = acctViewIdSet.iterator();
                int j = 0;
                while (it.hasNext()) {
                    String acctViewID = it.next().toString();
                    Iterator it2 = bankAcctIdSet.iterator();
                    String bankAccountId = null;
                    if (bankAcctIdSet.size() == 0) {
                        while (glRs.next()) {
                            HashMap<String, Object> row;
                            BigDecimal emtriesAmt = glRs.getBigDecimal("entries.originalAmount");
                            BigDecimal amt = glRs.getBigDecimal("assistRecords.originalAmount");
                            if (amt == null) {
                                row = new HashMap<String, Object>();
                                row.put("select", Boolean.FALSE);
                                row.put("record", CASWebUtil.getResource(ctx, "GL"));
                                row.put("id", "2" + j++);
                                row.put("system", EASResource.getString((String)resourcePath, (String)"GLSystem"));
                                row.put("date", glRs.getDate("createDate"));
                                row.put("description", glRs.getString("entries.description"));
                                String voucherTypeNumber = "";
                                String voucherNumber = "";
                                if (glRs.getString("voucherNumber") != null) {
                                    voucherTypeNumber = voucherNumber = glRs.getString("voucherNumber");
                                }
                                String voucherType = "";
                                if (glRs.getString("voucherType.name") != null) {
                                    voucherType = glRs.getString("voucherType.name");
                                    voucherTypeNumber = voucherType + "\u3000" + voucherTypeNumber;
                                }
                                row.put("voucher", voucherTypeNumber);
                                row.put("voucherNumber", glRs.getString("voucherNumber"));
                                String oppAccountView = "";
                                if (glRs.getString("account.number") != null) {
                                    oppAccountView = glRs.getString("account.number") + "\u3000" + glRs.getString("account.name");
                                }
                                row.put("oppAccountView", oppAccountView);
                                String settTypeNumber = "";
                                String settType = "";
                                String settNumber = "";
                                row.put("settTypeNumber", settTypeNumber);
                                row.put("settType", settType);
                                row.put("settNumber", settNumber);
                                if (glRs.getInt("entries.entryDC") > 0) {
                                    row.put("debitAmount", emtriesAmt.setScale(precision, 4) + "");
                                    row.put("creditAmount", CasConstants.ZERO.setScale(precision, 4) + "");
                                } else {
                                    row.put("debitAmount", CasConstants.ZERO.setScale(precision, 4) + "");
                                    row.put("creditAmount", emtriesAmt.setScale(precision, 4) + "");
                                }
                                row.put("flag", new Integer(0));
                                row.put("check", glRs.getString("cashier.name"));
                                row.put("source", SourceType.getEnum((int)glRs.getInt("sourceType")).getAlias());
                                loadData.add(row);
                                this.glRsData.add(row);
                                continue;
                            }
                            bankAccountId = glRs.getString("bankAccount.id");
                            row = new HashMap();
                            row.put("select", Boolean.FALSE);
                            row.put("record", CASWebUtil.getResource(ctx, "GL"));
                            row.put("id", "2" + j++);
                            row.put("system", EASResource.getString((String)resourcePath, (String)"GLSystem"));
                            row.put("date", glRs.getDate("createDate"));
                            String desc = glRs.getString("assistRecords.description");
                            if (desc == null) {
                                desc = glRs.getString("entries.description");
                            }
                            row.put("description", desc);
                            String voucherTypeNumber = "";
                            String voucherNumber = "";
                            if (glRs.getString("voucherNumber") != null) {
                                voucherTypeNumber = voucherNumber = glRs.getString("voucherNumber");
                            }
                            String voucherType = "";
                            if (glRs.getString("voucherType.name") != null) {
                                voucherType = glRs.getString("voucherType.name");
                                voucherTypeNumber = voucherType + "\u3000" + voucherTypeNumber;
                            }
                            row.put("voucher", voucherTypeNumber);
                            row.put("voucherNumber", glRs.getString("voucherNumber"));
                            String oppAccountView = "";
                            if (glRs.getString("account.number") != null) {
                                oppAccountView = glRs.getString("account.number") + "\u3000" + glRs.getString("account.name");
                            }
                            row.put("oppAccountView", oppAccountView);
                            String settTypeNumber = "";
                            String settType = "";
                            String settNumber = "";
                            if (glRs.getString("assistRecords.settlementCode") != null) {
                                settTypeNumber = settNumber = glRs.getString("assistRecords.settlementCode");
                            }
                            if (glRs.getString("settlementType.name") != null) {
                                settType = glRs.getString("settlementType.name");
                                settTypeNumber = settType + "\u3000" + settTypeNumber;
                            }
                            row.put("settTypeNumber", settTypeNumber);
                            row.put("settType", settType);
                            row.put("settNumber", settNumber);
                            if (glRs.getInt("entries.entryDC") > 0) {
                                row.put("debitAmount", amt.setScale(precision, 4) + "");
                                row.put("creditAmount", CasConstants.ZERO.setScale(precision, 4) + "");
                            } else {
                                row.put("debitAmount", CasConstants.ZERO.setScale(precision, 4) + "");
                                row.put("creditAmount", amt.setScale(precision, 4) + "");
                            }
                            row.put("flag", new Integer(0));
                            row.put("check", glRs.getString("cashier.name"));
                            row.put("source", SourceType.getEnum((int)Integer.parseInt(glRs.getString("sourceType"))).getAlias());
                            loadData.add(row);
                            this.glRsData.add(row);
                        }
                        continue;
                    }
                    while (it2.hasNext()) {
                        String accountBankId = it2.next().toString();
                        String desc = null;
                        while (glRs.next()) {
                            String settNumber;
                            String settType;
                            String settTypeNumber;
                            String oppAccountView;
                            String voucherType;
                            String voucherNumber;
                            String voucherTypeNumber;
                            HashMap<String, Object> row;
                            BigDecimal emtriesAmt = glRs.getBigDecimal("entries.originalAmount");
                            BigDecimal amt = glRs.getBigDecimal("assistRecords.originalAmount");
                            if (amt == null) {
                                row = new HashMap<String, Object>();
                                row.put("select", Boolean.FALSE);
                                row.put("record", CASWebUtil.getResource(ctx, "GL"));
                                row.put("id", "2" + j++);
                                row.put("system", EASResource.getString((String)resourcePath, (String)"GLSystem"));
                                row.put("date", glRs.getDate("createDate"));
                                row.put("description", glRs.getString("entries.description"));
                                voucherTypeNumber = "";
                                voucherNumber = "";
                                if (glRs.getString("voucherNumber") != null) {
                                    voucherTypeNumber = voucherNumber = glRs.getString("voucherNumber");
                                }
                                voucherType = "";
                                if (glRs.getString("voucherType.name") != null) {
                                    voucherType = glRs.getString("voucherType.name");
                                    voucherTypeNumber = voucherType + "\u3000" + voucherTypeNumber;
                                }
                                row.put("voucher", voucherTypeNumber);
                                row.put("voucherNumber", glRs.getString("voucherNumber"));
                                oppAccountView = "";
                                if (glRs.getString("account.number") != null) {
                                    oppAccountView = glRs.getString("account.number") + "\u3000" + glRs.getString("account.name");
                                }
                                row.put("oppAccountView", oppAccountView);
                                settTypeNumber = "";
                                settType = "";
                                settNumber = "";
                                row.put("settTypeNumber", settTypeNumber);
                                row.put("settType", settType);
                                row.put("settNumber", settNumber);
                                if (glRs.getInt("entries.entryDC") > 0) {
                                    row.put("debitAmount", emtriesAmt.setScale(precision, 4) + "");
                                    row.put("creditAmount", CasConstants.ZERO.setScale(precision, 4) + "");
                                } else {
                                    row.put("debitAmount", CasConstants.ZERO.setScale(precision, 4) + "");
                                    row.put("creditAmount", emtriesAmt.setScale(precision, 4) + "");
                                }
                                row.put("flag", new Integer(0));
                                row.put("check", glRs.getString("cashier.name"));
                                row.put("source", SourceType.getEnum((int)glRs.getInt("sourceType")).getAlias());
                                loadData.add(row);
                                this.glRsData.add(row);
                                continue;
                            }
                            bankAccountId = glRs.getString("bankAccount.id");
                            row = new HashMap();
                            row.put("select", Boolean.FALSE);
                            row.put("record", CASWebUtil.getResource(ctx, "GL"));
                            row.put("id", "2" + j++);
                            row.put("system", EASResource.getString((String)resourcePath, (String)"GLSystem"));
                            row.put("date", glRs.getDate("createDate"));
                            desc = glRs.getString("assistRecords.description");
                            if (desc == null) {
                                desc = glRs.getString("entries.description");
                            }
                            row.put("description", desc);
                            voucherTypeNumber = "";
                            voucherNumber = "";
                            if (glRs.getString("voucherNumber") != null) {
                                voucherTypeNumber = voucherNumber = glRs.getString("voucherNumber");
                            }
                            voucherType = "";
                            if (glRs.getString("voucherType.name") != null) {
                                voucherType = glRs.getString("voucherType.name");
                                voucherTypeNumber = voucherType + "\u3000" + voucherTypeNumber;
                            }
                            row.put("voucher", voucherTypeNumber);
                            row.put("voucherNumber", glRs.getString("voucherNumber"));
                            oppAccountView = "";
                            if (glRs.getString("account.number") != null) {
                                oppAccountView = glRs.getString("account.number") + "\u3000" + glRs.getString("account.name");
                            }
                            row.put("oppAccountView", oppAccountView);
                            settTypeNumber = "";
                            settType = "";
                            settNumber = "";
                            if (glRs.getString("assistRecords.settlementCode") != null) {
                                settTypeNumber = settNumber = glRs.getString("assistRecords.settlementCode");
                            }
                            if (glRs.getString("settlementType.name") != null) {
                                settType = glRs.getString("settlementType.name");
                                settTypeNumber = settType + "\u3000" + settTypeNumber;
                            }
                            row.put("settTypeNumber", settTypeNumber);
                            row.put("settType", settType);
                            row.put("settNumber", settNumber);
                            if (glRs.getInt("entries.entryDC") > 0) {
                                row.put("debitAmount", amt.setScale(precision, 4) + "");
                                row.put("creditAmount", CasConstants.ZERO.setScale(precision, 4) + "");
                            } else {
                                row.put("debitAmount", CasConstants.ZERO.setScale(precision, 4) + "");
                                row.put("creditAmount", amt.setScale(precision, 4) + "");
                            }
                            row.put("flag", new Integer(0));
                            row.put("check", glRs.getString("cashier.name"));
                            row.put("source", SourceType.getEnum((int)Integer.parseInt(glRs.getString("sourceType"))).getAlias());
                            loadData.add(row);
                            this.glRsData.add(row);
                        }
                    }
                }
            }
            loadData = this.autoContrast_Multi_New2(this.cashRsData, this.glRsData, map);
            onloadData.put("onloadData", loadData);
            CashContrastGLHelper.saveCacheOfContrastRst(pk, loadData);
            CashContrastGLHelper.saveCacheOfGroupMaxNumber(pk, this.maxGroupNumber);
            ArrayList<Map<String, Object>> unContrastCashRst = new ArrayList<Map<String, Object>>();
            for (int i = 0; i < this.cashRsData.size(); ++i) {
                Map<Object, Object> cashRow = new HashMap();
                cashRow = this.cashRsData.get(i);
                flag = (Integer)cashRow.get("flag");
                if (flag != 0) continue;
                unContrastCashRst.add(cashRow);
            }
            ArrayList<Map<String, Object>> unContrastGLRst = new ArrayList<Map<String, Object>>();
            for (int i = 0; i < this.glRsData.size(); ++i) {
                glRow = new HashMap();
                glRow = this.glRsData.get(i);
                flag = (Integer)glRow.get("flag");
                if (flag != 0) continue;
                unContrastGLRst.add(glRow);
            }
            CashContrastGLHelper.saveCacheOfUncontrastCashRst(pk, unContrastCashRst);
            CashContrastGLHelper.saveCacheOfUncontrastGLRst(pk, unContrastGLRst);
            for (int k = 0; k < unContrastGLRst.size(); ++k) {
                glRow = new HashMap();
                HashMap<String, Object> row = new HashMap<String, Object>();
                glRow = (Map)unContrastGLRst.get(k);
                row.put("GLselect", Boolean.FALSE);
                row.put("GLrecord", CASWebUtil.getResource(ctx, "GL"));
                row.put("GLsystem", glRow.get("system"));
                row.put("GLoppAccountView", glRow.get("oppAccountView"));
                row.put("GLsettTypeNumber", glRow.get("settTypeNumber"));
                row.put("GLdate", glRow.get("date"));
                row.put("GLdescription", glRow.get("description"));
                row.put("GLvoucher", glRow.get("voucher"));
                row.put("GLvoucherNumber", glRow.get("voucherNumber"));
                row.put("GLdebitAmount", glRow.get("debitAmount"));
                row.put("GLcreditAmount", glRow.get("creditAmount"));
                row.put("GLflag", glRow.get("flag"));
                row.put("GLcheck", glRow.get("check"));
                row.put("GLsource", glRow.get("source"));
                GLRsData.add(row);
            }
            onloadData.put("period", period);
            onloadData.put("company", company);
            onloadData.put("accountBank", accountBank);
            onloadData.put("accountView", accountView);
            onloadData.put("currency", currency);
            onloadData.put("cashData", unContrastCashRst);
            onloadData.put("gldata", GLRsData);
            onloadData.put("error", error);
            onloadData.put("errorMsg", errorMsg);
            return onloadData;
        }
        catch (Exception e) {
            error = 1;
            errorMsg = e.getMessage();
            e.printStackTrace();
            onloadData.put("error", error);
            onloadData.put("errorMsg", errorMsg);
            return onloadData;
        }
    }

    protected String getRpcBatchImplClassName() {
        return "com.kingdee.eas.fi.cas.app.CashContrastGlBatchFetcher";
    }

    private int getPrecision(Context ctx, String currencyId) {
        String str = "select fid,fprecision from t_bd_currency where fid ='" + currencyId + "'";
        ISQLExecutor sqlExe = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)str);
        IRowSet rs = null;
        try {
            rs = sqlExe.executeSQL();
            if (rs.next()) {
                return new Integer(rs.getInt(2));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 10;
    }

    public IRowSet getCashRowset(Context ctx, IMetaDataPK mainQueryPK, EntityViewInfo mainQuery, BOSUuid currencyId, Set acctBankIdSet, Set acctViewIdSet, CapitalTypeEnum capitalType, PeriodInfo period) throws BOSException {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
        EntityViewInfo ev = (EntityViewInfo)mainQuery.clone();
        FilterInfo filter = ev.getFilter();
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        if (capitalType.equals((Object)CapitalTypeEnum.BANK)) {
            filter.getFilterItems().add(new FilterItemInfo("bankAccountId", (Object)acctBankIdSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(2), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("accountViewId", (Object)acctViewIdSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(1), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)period.getId().toString(), CompareType.EQUALS));
        ev.getSorter().add(new SorterItemInfo("voucherNumber"));
        exec.setObjectView(ev);
        IRowSet rs = exec.executeQuery();
        return rs;
    }

    private boolean isMultiBankAccount(Context ctx, String accountViewId) throws BOSException {
        CompanyOrgUnitInfo companyInfo = ClientUtils.getCurrLoginCompany();
        return FMHelper.isExistMultiBankAcct((Context)ctx, (String)companyInfo.getId().toString(), (String)accountViewId);
    }

    private boolean isHasAssistant(Context ctx, String bankAccountId) throws BOSException {
        IAssistantHG assistantHG = AssistantHGFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)bankAccountId));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.setFilter(fi);
        AssistantHGCollection assistantHGColl = assistantHG.getAssistantHGCollection(evi);
        return assistantHGColl != null && assistantHGColl.size() != 0;
    }

    public List<Map<String, Object>> autoContrast_Multi_New2(List<Map<String, Object>> cashRsData, List<Map<String, Object>> glRsData, Map map) throws BOSException, EASBizException {
        ArrayList<Map<String, Object>> loadData = new ArrayList<Map<String, Object>>();
        int tblCashSize = cashRsData.size();
        int tblGLSize = glRsData.size();
        if (tblCashSize == 0 || tblGLSize == 0) {
            return loadData;
        }
        BigDecimal tmpCashCreditAmount = CasConstants.ZERO;
        BigDecimal tmpGlDebitAmount = CasConstants.ZERO;
        BigDecimal tmpGlCreditAmount = CasConstants.ZERO;
        int total = 0;
        Map<Object, Object> cashRow = new HashMap();
        Map<Object, Object> glRow = new HashMap();
        ArrayList itemList = new ArrayList();
        block0: for (int i = 0; i < tblCashSize; ++i) {
            cashRow = cashRsData.get(i);
            int flag = (Integer)cashRow.get("flag");
            if (flag != 0) continue;
            BigDecimal tmpCashDebitAmount = new BigDecimal((String)cashRow.get("debitAmount"));
            tmpCashCreditAmount = new BigDecimal((String)cashRow.get("creditAmount"));
            for (int j = 0; j < tblGLSize; ++j) {
                glRow = glRsData.get(j);
                flag = (Integer)glRow.get("flag");
                if (flag != 0) continue;
                tmpGlDebitAmount = new BigDecimal((String)glRow.get("debitAmount"));
                tmpGlCreditAmount = new BigDecimal((String)glRow.get("creditAmount"));
                if (tmpCashDebitAmount.compareTo(tmpGlDebitAmount) != 0 || tmpCashCreditAmount.compareTo(tmpGlCreditAmount) != 0 || !this.isMeetOtherConditions(cashRow, glRow, map)) continue;
                cashRow.put("group", i);
                cashRow.put("select", Boolean.FALSE);
                cashRow.put("flag", new Integer(1));
                glRow.put("group", i);
                glRow.put("select", Boolean.FALSE);
                glRow.put("flag", new Integer(1));
                itemList = new ArrayList();
                loadData.add(cashRow);
                loadData.add(glRow);
                ++total;
                continue block0;
            }
        }
        this.sucessContrastTotal += total;
        StringBuffer msgStr = new StringBuffer(128);
        msgStr.append(EASResource.getString((String)resourcePath, (String)"SucessContrastTotal"));
        msgStr.append(total);
        msgStr.append(EASResource.getString((String)resourcePath, (String)"Group"));
        return loadData;
    }

    private boolean isMeetOtherConditions(Map<String, Object> cashRow, Map<String, Object> glRow, Map map) {
        boolean isDateEquals = false;
        boolean isDescriptionEquals = false;
        boolean isSettTypeEquals = false;
        boolean isSettNumberEquals = false;
        boolean isVoucherNumEquals = false;
        if (map != null && map.size() != 0) {
            isDateEquals = TypeConversionUtils.objToBoolean(map.get("bizDateEq"));
            isDescriptionEquals = TypeConversionUtils.objToBoolean(map.get("descriptionEq"));
            isSettTypeEquals = TypeConversionUtils.objToBoolean(map.get("settlementTypeEq"));
            isSettNumberEquals = TypeConversionUtils.objToBoolean(map.get("settlementNumberEq"));
            isVoucherNumEquals = TypeConversionUtils.objToBoolean(map.get("voucherNumberEq"));
        }
        boolean isEquals = false;
        Date cashCreateDate = (Date)cashRow.get("date");
        String cashVoucherNumber = (String)cashRow.get("voucherNumber");
        String cashDescription = (String)cashRow.get("description");
        String cashSettType = (String)cashRow.get("settType");
        String cashSettNumber = (String)cashRow.get("settNumber");
        Date glCreateDate = (Date)glRow.get("date");
        String glVoucherNumber = (String)glRow.get("voucherNumber");
        String glDescription = (String)glRow.get("description");
        String glSettType = (String)glRow.get("settType");
        String glSettNumber = (String)glRow.get("settNumber");
        isDateEquals = isDateEquals ? CashHelper.isEquals(cashCreateDate, glCreateDate) : true;
        isDescriptionEquals = isDescriptionEquals ? CashHelper.isEquals(cashDescription, glDescription) : true;
        isSettTypeEquals = isSettTypeEquals ? CashHelper.isEquals(cashSettType, glSettType) : true;
        isSettNumberEquals = isSettNumberEquals ? CashHelper.isEquals(cashSettNumber, glSettNumber) : true;
        isVoucherNumEquals = isVoucherNumEquals ? CashHelper.isEquals(cashVoucherNumber, glVoucherNumber) : true;
        isEquals = isDateEquals && isDescriptionEquals && isSettTypeEquals && isSettNumberEquals && isVoucherNumEquals;
        return isEquals;
    }

    @Override
    protected Map _getSucessInitData(Context ctx, String companyId, String periodId, String accountBankNoId, String accountId, String currencyId, boolean isShare) throws BOSException, EASBizException {
        if (accountBankNoId == null) {
            accountBankNoId = "";
        }
        int error = 0;
        String errorMsg = null;
        Object cashContrastGLData = null;
        HashMap<String, Object> onloadData = new HashMap<String, Object>();
        HashMap result = new HashMap();
        try {
            int flag;
            IContextHelper contextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
            String userID = contextHelper.getCurrentUser().getId().toString();
            PeriodInfo period = new PeriodInfo();
            period.setId(BOSUuid.read((String)periodId));
            period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(period.getId().toString()));
            onloadData.put("labelPeriod", CASWebUtil.getResource(ctx, "WorkPlatform_Period", new String[]{String.valueOf(period.getPeriodYear()), String.valueOf(period.getPeriodNumber())}));
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            company.setId(BOSUuid.read((String)companyId));
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()));
            onloadData.put("labelCompany", company.getName());
            Map map = this.getUIOptionMap(ctx, company.getId().toString(), isShare);
            FmRpcCacheInfo paramInfo = new FmRpcCacheInfo();
            paramInfo.setBatchImplClassName(this.getRpcBatchImplClassName());
            paramInfo.put("company", (Object)company);
            this.rpcCacheInfo = FMBatchProcessFacadeFactory.getLocalInstance((Context)ctx).batchFetchData(paramInfo);
            AccountBankInfo accountBank = new AccountBankInfo();
            CapitalTypeEnum capitalType = CapitalTypeEnum.CASH;
            HashSet<String> bankAcctIdSet = new HashSet<String>();
            if (accountBankNoId.length() != 0) {
                accountBank.setId(BOSUuid.read((String)accountBankNoId));
                accountBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountBank.getId().toString()));
                capitalType = CapitalTypeEnum.BANK;
                bankAcctIdSet.add(accountBank.getId().toString());
                onloadData.put("labelAccountBank", accountBank.getBankAccountNumber());
            }
            AccountViewInfo accountView = new AccountViewInfo();
            accountView.setId(BOSUuid.read((String)accountId));
            accountView = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountView.getId().toString()));
            HashSet<String> acctViewIdSet = new HashSet<String>();
            acctViewIdSet.add(accountView.getId().toString());
            onloadData.put("labelAccountView", accountView.getName());
            CurrencyInfo currency = new CurrencyInfo();
            currency.setId(BOSUuid.read((String)currencyId));
            currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId().toString()));
            onloadData.put("labelCurrency", currency.getName());
            boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), "cas_cashcontrastGL_03query");
            if (!isPermission) {
                onloadData.put("period", period);
                onloadData.put("company", company);
                onloadData.put("accountBank", accountBank);
                onloadData.put("accountView", accountView);
                onloadData.put("currency", currency);
                throw new CasWebException(CasWebException.NO_CASHCONTRASTGL_AUTHRIZED);
            }
            MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.fi.cas", "CashSystemWebQuery");
            EntityViewInfo mainQuery = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id ", (Object)company.getId()));
            filter.getFilterItems().add(new FilterItemInfo("createDate", (Object)period.getBeginDate(), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("createDate", (Object)period.getEndDate(), CompareType.LESS_EQUALS));
            mainQuery.setFilter(filter);
            int precision = this.getPrecision(ctx, currencyId);
            onloadData.put("precision", precision);
            String pk = new String();
            pk = accountBankNoId.length() != 0 ? userID + period.getId().toString() + company.getId().toString() + accountBank.getId().toString() + accountView.getId().toString() + currency.getId().toString() : userID + period.getId().toString() + company.getId().toString() + accountView.getId().toString() + currency.getId().toString();
            onloadData.put("pk", pk);
            List<Object> cacheOfContrastRst = new ArrayList();
            cacheOfContrastRst = CashContrastGLHelper.getCacheOfContrastRst(pk);
            List<Object> cacheOfUnContrastCashRst = new ArrayList();
            cacheOfUnContrastCashRst = CashContrastGLHelper.getCacheOfUnContrastCashRst(pk);
            List<Object> cacheOfUnContrastGLRst = new ArrayList();
            cacheOfUnContrastGLRst = CashContrastGLHelper.getCacheOfUnContrastGLRst(pk);
            if (cacheOfContrastRst.size() >= 1 || cacheOfUnContrastCashRst.size() >= 1 || cacheOfUnContrastGLRst.size() >= 1) {
                onloadData.put("period", period);
                onloadData.put("company", company);
                onloadData.put("accountBank", accountBank);
                onloadData.put("accountView", accountView);
                onloadData.put("currency", currency);
                onloadData.put("onloadData", cacheOfContrastRst);
                onloadData.put("error", error);
                onloadData.put("errorMsg", errorMsg);
                return onloadData;
            }
            IRowSet cashRs = this.getCashRowset(ctx, (IMetaDataPK)mainQueryPK, mainQuery, currency.getId(), bankAcctIdSet, acctViewIdSet, capitalType, period);
            MetaDataPK gLSystemQueryPK = new MetaDataPK("com.kingdee.eas.fi.cas", "GLSystemWebQuery");
            EntityViewInfo gLSystemQuery = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id ", (Object)company.getId()));
            filter.getFilterItems().add(new FilterItemInfo("createDate", (Object)period.getBeginDate(), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("createDate", (Object)period.getEndDate(), CompareType.LESS_EQUALS));
            FilterInfo filterbizStatus = new FilterInfo();
            filterbizStatus.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(5), CompareType.EQUALS));
            if (TypeConversionUtils.objToBoolean(map.get("containNoAccVoucher"))) {
                filterbizStatus.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(1), CompareType.EQUALS));
                filterbizStatus.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(3), CompareType.EQUALS));
                filterbizStatus.setMaskString("#0 or #1 or #2");
            }
            filter.mergeFilter(filterbizStatus, "and");
            gLSystemQuery.setFilter(filter);
            IRowSet glRs = CashBankContrastGLFactory.getLocalInstance(ctx).getGLRowset((IObjectPK)gLSystemQueryPK, (IObjectValue)gLSystemQuery, currency.getId(), bankAcctIdSet, acctViewIdSet, capitalType, period);
            ArrayList<Map<String, Object>> loadData = new ArrayList();
            if (cashRs != null && cashRs.size() != 0 && glRs != null && glRs.size() != 0) {
                int i = 0;
                while (cashRs.next()) {
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    row.put("select", Boolean.FALSE);
                    row.put("record", CASWebUtil.getResource(ctx, "CASH"));
                    row.put("system", EASResource.getString((String)resourcePath, (String)"CashSystem"));
                    row.put("id", "1" + i++);
                    row.put("date", cashRs.getDate("createDate"));
                    row.put("description", cashRs.getString("description"));
                    String voucherTypeNumber = "";
                    String voucherNumber = "";
                    if (cashRs.getString("voucherNumber") != null) {
                        voucherTypeNumber = voucherNumber = cashRs.getString("voucherNumber");
                    }
                    String voucherType = "";
                    if (cashRs.getString("voucherType.name") != null) {
                        voucherType = cashRs.getString("voucherType.name");
                        voucherTypeNumber = voucherType + "\u3000" + voucherTypeNumber;
                    }
                    row.put("voucher", voucherTypeNumber);
                    row.put("voucherNumber", cashRs.getString("voucherNumber"));
                    String oppAccountView = "";
                    if (cashRs.getString("oppAccountView.number") != null) {
                        oppAccountView = cashRs.getString("oppAccountView.number") + "\u3000" + cashRs.getString("oppAccountView.name");
                    }
                    row.put("oppAccountView", oppAccountView);
                    String settTypeNumber = "";
                    String settType = "";
                    String settNumber = "";
                    if (cashRs.getString("settlementNumber") != null) {
                        settTypeNumber = settNumber = cashRs.getString("settlementNumber");
                    }
                    if (cashRs.getString("settlementType.name") != null) {
                        settType = cashRs.getString("settlementType.name");
                        settTypeNumber = settType + "\u3000" + settTypeNumber;
                    }
                    row.put("settTypeNumber", settTypeNumber);
                    row.put("settType", settType);
                    row.put("settNumber", settNumber);
                    row.put("debitAmount", cashRs.getBigDecimal("debitAmount").setScale(precision, 4) + "");
                    row.put("creditAmount", cashRs.getBigDecimal("creditAmount").setScale(precision, 4) + "");
                    row.put("flag", new Integer(0));
                    row.put("cash", cashRs.getString("cashier.name"));
                    row.put("source", JournalSourceEnum.getEnum((int)cashRs.getInt("source")).getAlias());
                    loadData.add(row);
                    this.cashRsData.add(row);
                }
                Iterator it = acctViewIdSet.iterator();
                int j = 0;
                while (it.hasNext()) {
                    String acctViewID = it.next().toString();
                    Iterator it2 = bankAcctIdSet.iterator();
                    String bankAccountId = null;
                    if (bankAcctIdSet.size() == 0) {
                        while (glRs.next()) {
                            HashMap<String, Object> row;
                            BigDecimal emtriesAmt = glRs.getBigDecimal("entries.originalAmount");
                            BigDecimal amt = glRs.getBigDecimal("assistRecords.originalAmount");
                            if (amt == null) {
                                row = new HashMap<String, Object>();
                                row.put("select", Boolean.FALSE);
                                row.put("record", CASWebUtil.getResource(ctx, "GL"));
                                row.put("id", "2" + j++);
                                row.put("system", EASResource.getString((String)resourcePath, (String)"GLSystem"));
                                row.put("date", glRs.getDate("createDate"));
                                row.put("description", glRs.getString("entries.description"));
                                String voucherTypeNumber = "";
                                String voucherNumber = "";
                                if (glRs.getString("voucherNumber") != null) {
                                    voucherTypeNumber = voucherNumber = glRs.getString("voucherNumber");
                                }
                                String voucherType = "";
                                if (glRs.getString("voucherType.name") != null) {
                                    voucherType = glRs.getString("voucherType.name");
                                    voucherTypeNumber = voucherType + "\u3000" + voucherTypeNumber;
                                }
                                row.put("voucher", voucherTypeNumber);
                                row.put("voucherNumber", glRs.getString("voucherNumber"));
                                String oppAccountView = "";
                                if (glRs.getString("account.number") != null) {
                                    oppAccountView = glRs.getString("account.number") + "\u3000" + glRs.getString("account.name");
                                }
                                row.put("oppAccountView", oppAccountView);
                                String settTypeNumber = "";
                                String settType = "";
                                String settNumber = "";
                                row.put("settTypeNumber", settTypeNumber);
                                row.put("settType", settType);
                                row.put("settNumber", settNumber);
                                if (glRs.getInt("entries.entryDC") > 0) {
                                    row.put("debitAmount", emtriesAmt.setScale(precision, 4) + "");
                                    row.put("creditAmount", CasConstants.ZERO.setScale(precision, 4) + "");
                                } else {
                                    row.put("debitAmount", CasConstants.ZERO.setScale(precision, 4) + "");
                                    row.put("creditAmount", emtriesAmt.setScale(precision, 4) + "");
                                }
                                row.put("flag", new Integer(0));
                                row.put("check", glRs.getString("cashier.name"));
                                row.put("source", SourceType.getEnum((int)glRs.getInt("sourceType")).getAlias());
                                loadData.add(row);
                                this.glRsData.add(row);
                                continue;
                            }
                            bankAccountId = glRs.getString("bankAccount.id");
                            row = new HashMap();
                            row.put("select", Boolean.FALSE);
                            row.put("record", CASWebUtil.getResource(ctx, "GL"));
                            row.put("id", "2" + j++);
                            row.put("system", EASResource.getString((String)resourcePath, (String)"GLSystem"));
                            row.put("date", glRs.getDate("createDate"));
                            String desc = glRs.getString("assistRecords.description");
                            if (desc == null) {
                                desc = glRs.getString("entries.description");
                            }
                            row.put("description", desc);
                            String voucherTypeNumber = "";
                            String voucherNumber = "";
                            if (glRs.getString("voucherNumber") != null) {
                                voucherTypeNumber = voucherNumber = glRs.getString("voucherNumber");
                            }
                            String voucherType = "";
                            if (glRs.getString("voucherType.name") != null) {
                                voucherType = glRs.getString("voucherType.name");
                                voucherTypeNumber = voucherType + "\u3000" + voucherTypeNumber;
                            }
                            row.put("voucher", voucherTypeNumber);
                            row.put("voucherNumber", glRs.getString("voucherNumber"));
                            String oppAccountView = "";
                            if (glRs.getString("account.number") != null) {
                                oppAccountView = glRs.getString("account.number") + "\u3000" + glRs.getString("account.name");
                            }
                            row.put("oppAccountView", oppAccountView);
                            String settTypeNumber = "";
                            String settType = "";
                            String settNumber = "";
                            if (glRs.getString("assistRecords.settlementCode") != null) {
                                settTypeNumber = settNumber = glRs.getString("assistRecords.settlementCode");
                            }
                            if (glRs.getString("settlementType.name") != null) {
                                settType = glRs.getString("settlementType.name");
                                settTypeNumber = settType + "\u3000" + settTypeNumber;
                            }
                            row.put("settTypeNumber", settTypeNumber);
                            row.put("settType", settType);
                            row.put("settNumber", settNumber);
                            if (glRs.getInt("entries.entryDC") > 0) {
                                row.put("debitAmount", amt.setScale(precision, 4) + "");
                                row.put("creditAmount", CasConstants.ZERO.setScale(precision, 4) + "");
                            } else {
                                row.put("debitAmount", CasConstants.ZERO.setScale(precision, 4) + "");
                                row.put("creditAmount", amt.setScale(precision, 4) + "");
                            }
                            row.put("flag", new Integer(0));
                            row.put("check", glRs.getString("cashier.name"));
                            row.put("source", SourceType.getEnum((int)Integer.parseInt(glRs.getString("sourceType"))).getAlias());
                            loadData.add(row);
                            this.glRsData.add(row);
                        }
                        continue;
                    }
                    while (it2.hasNext()) {
                        String accountBankId = it2.next().toString();
                        boolean isMultiBankAcct = false;
                        boolean isHasAssistant = false;
                        boolean isBank = capitalType.equals((Object)CapitalTypeEnum.BANK);
                        bankAccountId = null;
                        String desc = null;
                        if (isBank) {
                            if (this.rpcCacheInfo == null) {
                                isMultiBankAcct = this.isMultiBankAccount(ctx, acctViewID);
                                isHasAssistant = this.isHasAssistant(ctx, accountBankId);
                            } else {
                                Map acctViewCntMap = (Map)this.rpcCacheInfo.get("acctViewCntMap");
                                int count = (Integer)acctViewCntMap.get(acctViewID);
                                isMultiBankAcct = count > 1;
                                Map hasAssistantHGMap = (Map)this.rpcCacheInfo.get("hasAssistantHGMap");
                                if (hasAssistantHGMap.containsKey(accountBankId)) {
                                    isHasAssistant = true;
                                }
                            }
                            if (!isMultiBankAcct || !isHasAssistant) {
                                // empty if block
                            }
                        }
                        while (glRs.next()) {
                            String settNumber;
                            String settType;
                            String settTypeNumber;
                            String oppAccountView;
                            String voucherType;
                            String voucherNumber;
                            String voucherTypeNumber;
                            HashMap<String, Object> row;
                            BigDecimal emtriesAmt = glRs.getBigDecimal("entries.originalAmount");
                            BigDecimal amt = glRs.getBigDecimal("assistRecords.originalAmount");
                            if (amt == null) {
                                row = new HashMap<String, Object>();
                                row.put("select", Boolean.FALSE);
                                row.put("record", CASWebUtil.getResource(ctx, "GL"));
                                row.put("id", "2" + j++);
                                row.put("system", EASResource.getString((String)resourcePath, (String)"GLSystem"));
                                row.put("date", glRs.getDate("createDate"));
                                row.put("description", glRs.getString("entries.description"));
                                voucherTypeNumber = "";
                                voucherNumber = "";
                                if (glRs.getString("voucherNumber") != null) {
                                    voucherTypeNumber = voucherNumber = glRs.getString("voucherNumber");
                                }
                                voucherType = "";
                                if (glRs.getString("voucherType.name") != null) {
                                    voucherType = glRs.getString("voucherType.name");
                                    voucherTypeNumber = voucherType + "\u3000" + voucherTypeNumber;
                                }
                                row.put("voucher", voucherTypeNumber);
                                row.put("voucherNumber", glRs.getString("voucherNumber"));
                                oppAccountView = "";
                                if (glRs.getString("account.number") != null) {
                                    oppAccountView = glRs.getString("account.number") + "\u3000" + glRs.getString("account.name");
                                }
                                row.put("oppAccountView", oppAccountView);
                                settTypeNumber = "";
                                settType = "";
                                settNumber = "";
                                row.put("settTypeNumber", settTypeNumber);
                                row.put("settType", settType);
                                row.put("settNumber", settNumber);
                                if (glRs.getInt("entries.entryDC") > 0) {
                                    row.put("debitAmount", emtriesAmt.setScale(precision, 4) + "");
                                    row.put("creditAmount", CasConstants.ZERO.setScale(precision, 4) + "");
                                } else {
                                    row.put("debitAmount", CasConstants.ZERO.setScale(precision, 4) + "");
                                    row.put("creditAmount", emtriesAmt.setScale(precision, 4) + "");
                                }
                                row.put("flag", new Integer(0));
                                row.put("check", glRs.getString("cashier.name"));
                                row.put("source", SourceType.getEnum((int)glRs.getInt("sourceType")).getAlias());
                                loadData.add(row);
                                this.glRsData.add(row);
                                continue;
                            }
                            bankAccountId = glRs.getString("bankAccount.id");
                            row = new HashMap();
                            row.put("select", Boolean.FALSE);
                            row.put("record", CASWebUtil.getResource(ctx, "GL"));
                            row.put("id", "2" + j++);
                            row.put("system", EASResource.getString((String)resourcePath, (String)"GLSystem"));
                            row.put("date", glRs.getDate("createDate"));
                            desc = glRs.getString("assistRecords.description");
                            if (desc == null) {
                                desc = glRs.getString("entries.description");
                            }
                            row.put("description", desc);
                            voucherTypeNumber = "";
                            voucherNumber = "";
                            if (glRs.getString("voucherNumber") != null) {
                                voucherTypeNumber = voucherNumber = glRs.getString("voucherNumber");
                            }
                            voucherType = "";
                            if (glRs.getString("voucherType.name") != null) {
                                voucherType = glRs.getString("voucherType.name");
                                voucherTypeNumber = voucherType + "\u3000" + voucherTypeNumber;
                            }
                            row.put("voucher", voucherTypeNumber);
                            row.put("voucherNumber", glRs.getString("voucherNumber"));
                            oppAccountView = "";
                            if (glRs.getString("account.number") != null) {
                                oppAccountView = glRs.getString("account.number") + "\u3000" + glRs.getString("account.name");
                            }
                            row.put("oppAccountView", oppAccountView);
                            settTypeNumber = "";
                            settType = "";
                            settNumber = "";
                            if (glRs.getString("assistRecords.settlementCode") != null) {
                                settTypeNumber = settNumber = glRs.getString("assistRecords.settlementCode");
                            }
                            if (glRs.getString("settlementType.name") != null) {
                                settType = glRs.getString("settlementType.name");
                                settTypeNumber = settType + "\u3000" + settTypeNumber;
                            }
                            row.put("settTypeNumber", settTypeNumber);
                            row.put("settType", settType);
                            row.put("settNumber", settNumber);
                            if (glRs.getInt("entries.entryDC") > 0) {
                                row.put("debitAmount", amt.setScale(precision, 4) + "");
                                row.put("creditAmount", CasConstants.ZERO.setScale(precision, 4) + "");
                            } else {
                                row.put("debitAmount", CasConstants.ZERO.setScale(precision, 4) + "");
                                row.put("creditAmount", amt.setScale(precision, 4) + "");
                            }
                            row.put("flag", new Integer(0));
                            row.put("check", glRs.getString("cashier.name"));
                            row.put("source", SourceType.getEnum((int)Integer.parseInt(glRs.getString("sourceType"))).getAlias());
                            loadData.add(row);
                            this.glRsData.add(row);
                        }
                    }
                }
            }
            onloadData.put("period", period);
            onloadData.put("company", company);
            onloadData.put("accountBank", accountBank);
            onloadData.put("accountView", accountView);
            onloadData.put("currency", currency);
            onloadData.put("onloadData", loadData);
            onloadData.put("error", error);
            onloadData.put("errorMsg", errorMsg);
            loadData = this.autoContrast_Multi_New2(this.cashRsData, this.glRsData, map);
            onloadData.put("onloadData", loadData);
            CashContrastGLHelper.saveCacheOfContrastRst(pk, loadData);
            CashContrastGLHelper.saveCacheOfGroupMaxNumber(pk, this.maxGroupNumber);
            ArrayList<Map<String, Object>> unContrastCashRst = new ArrayList<Map<String, Object>>();
            for (int i = 0; i < this.cashRsData.size(); ++i) {
                Map<Object, Object> cashRow = new HashMap();
                cashRow = this.cashRsData.get(i);
                flag = (Integer)cashRow.get("flag");
                if (flag != 0) continue;
                unContrastCashRst.add(cashRow);
            }
            ArrayList<Map<String, Object>> unContrastGLRst = new ArrayList<Map<String, Object>>();
            for (int i = 0; i < this.glRsData.size(); ++i) {
                Map<Object, Object> glRow = new HashMap();
                glRow = this.glRsData.get(i);
                flag = (Integer)glRow.get("flag");
                if (flag != 0) continue;
                unContrastGLRst.add(glRow);
            }
            CashContrastGLHelper.saveCacheOfUncontrastCashRst(pk, unContrastCashRst);
            CashContrastGLHelper.saveCacheOfUncontrastGLRst(pk, unContrastGLRst);
            return onloadData;
        }
        catch (Exception e) {
            error = 1;
            errorMsg = e.getMessage();
            e.printStackTrace();
            onloadData.put("error", error);
            onloadData.put("errorMsg", errorMsg);
            return onloadData;
        }
    }

    @Override
    protected Map _unContrastSel(Context ctx, String modelStr) throws BOSException, EASBizException {
        int error = 0;
        String errorMsg = null;
        HashMap<String, Object> onloadData = new HashMap<String, Object>();
        List unContrastSel = null;
        try {
            HashMap modelMap = JSONUtils.convertJsonToObject((Context)ctx, (String)modelStr);
            IContextHelper contextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
            String userID = contextHelper.getCurrentUser().getId().toString();
            if (modelMap.get("arr") != null) {
                unContrastSel = (List)modelMap.get("arr");
            }
            if (unContrastSel.size() > 0) {
                PeriodInfo period = new PeriodInfo();
                period.setId(BOSUuid.read((String)((String)modelMap.get("periodId"))));
                period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(period.getId().toString()));
                onloadData.put("labelPeriod", CASWebUtil.getResource(ctx, "WorkPlatform_Period", new String[]{String.valueOf(period.getPeriodYear()), String.valueOf(period.getPeriodNumber())}));
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                company.setId(BOSUuid.read((String)((String)modelMap.get("companyId"))));
                company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()));
                onloadData.put("labelCompany", company.getName());
                FmRpcCacheInfo paramInfo = new FmRpcCacheInfo();
                paramInfo.setBatchImplClassName(this.getRpcBatchImplClassName());
                paramInfo.put("company", (Object)company);
                this.rpcCacheInfo = FMBatchProcessFacadeFactory.getLocalInstance((Context)ctx).batchFetchData(paramInfo);
                AccountBankInfo accountBank = new AccountBankInfo();
                CapitalTypeEnum capitalType = CapitalTypeEnum.CASH;
                HashSet<String> bankAcctIdSet = new HashSet<String>();
                String accountBankNoId = (String)modelMap.get("accountBankNoId");
                if (accountBankNoId.length() != 0) {
                    accountBank.setId(BOSUuid.read((String)accountBankNoId));
                    accountBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountBank.getId().toString()));
                    capitalType = CapitalTypeEnum.BANK;
                    bankAcctIdSet.add(accountBank.getId().toString());
                    onloadData.put("labelAccountBank", accountBank.getBankAccountNumber());
                }
                AccountViewInfo accountView = new AccountViewInfo();
                accountView.setId(BOSUuid.read((String)((String)modelMap.get("accountId"))));
                accountView = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountView.getId().toString()));
                HashSet<String> acctViewIdSet = new HashSet<String>();
                acctViewIdSet.add(accountView.getId().toString());
                onloadData.put("labelAccountView", accountView.getName());
                CurrencyInfo currency = new CurrencyInfo();
                currency.setId(BOSUuid.read((String)((String)modelMap.get("currencyId"))));
                currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId().toString()));
                onloadData.put("labelCurrency", currency.getName());
                String pk = new String();
                pk = accountBankNoId.length() != 0 ? userID + period.getId().toString() + company.getId().toString() + accountBank.getId().toString() + accountView.getId().toString() + currency.getId().toString() : userID + period.getId().toString() + company.getId().toString() + accountView.getId().toString() + currency.getId().toString();
                onloadData.put("pk", pk);
                List<Object> cacheOfContrastRst = new ArrayList();
                cacheOfContrastRst = CashContrastGLHelper.getCacheOfContrastRst(pk);
                ArrayList<Map<String, Object>> newCacheOfContrastRst = new ArrayList<Map<String, Object>>();
                ArrayList<Map<String, Object>> unContrastCashRst = new ArrayList();
                unContrastCashRst = CashContrastGLHelper.getCacheOfUnContrastCashRst(pk);
                ArrayList newUnContrastCashRst = new ArrayList();
                ArrayList<Map<String, Object>> unContrastGLRst = new ArrayList();
                unContrastGLRst = CashContrastGLHelper.getCacheOfUnContrastGLRst(pk);
                ArrayList newUnContrastGLRst = new ArrayList();
                if (cacheOfContrastRst.size() >= 1) {
                    for (int i = 0; i < cacheOfContrastRst.size(); ++i) {
                        Map contrastRstRow = new HashMap();
                        contrastRstRow = (Map)cacheOfContrastRst.get(i);
                        BigInteger contrastRstGroup = new BigInteger(contrastRstRow.get("group").toString());
                        boolean isAdd = true;
                        for (int j = 0; j < unContrastSel.size(); ++j) {
                            BigInteger group = new BigInteger(unContrastSel.get(j).toString());
                            if (!contrastRstGroup.equals(group)) continue;
                            String record = (String)contrastRstRow.get("record");
                            if (record.equals(CASWebUtil.getResource(ctx, "CASH"))) {
                                Map<String, Integer> unContrastCashRow = new HashMap();
                                unContrastCashRow = contrastRstRow;
                                unContrastCashRow.put("flag", new Integer(0));
                                unContrastCashRst.add(unContrastCashRow);
                            }
                            if (record.equals(CASWebUtil.getResource(ctx, "GL"))) {
                                Map<String, Integer> unContrastGLRow = new HashMap();
                                unContrastGLRow = contrastRstRow;
                                unContrastGLRow.put("flag", new Integer(0));
                                unContrastGLRst.add(unContrastGLRow);
                            }
                            isAdd = false;
                        }
                        if (!isAdd) continue;
                        newCacheOfContrastRst.add(contrastRstRow);
                    }
                    CashContrastGLHelper.saveCacheOfContrastRst(pk, newCacheOfContrastRst);
                    if (newCacheOfContrastRst.size() != cacheOfContrastRst.size()) {
                        onloadData.put("summaryMsg", CASWebUtil.getResource(ctx, "295_UnContrastSel_SUCCES"));
                        error = 0;
                        onloadData.put("error", error);
                    }
                    CashContrastGLHelper.saveCacheOfUncontrastCashRst(pk, unContrastCashRst);
                    CashContrastGLHelper.saveCacheOfUncontrastGLRst(pk, unContrastGLRst);
                    onloadData.put("period", period);
                    onloadData.put("company", company);
                    onloadData.put("accountBank", accountBank);
                    onloadData.put("accountView", accountView);
                    onloadData.put("currency", currency);
                    onloadData.put("onloadData", newCacheOfContrastRst);
                    onloadData.put("error", error);
                    onloadData.put("errorMsg", errorMsg);
                }
            }
        }
        catch (Exception e) {
            error = 1;
            errorMsg = e.getMessage();
            e.printStackTrace();
        }
        return onloadData;
    }

    @Override
    protected Map _getManualInitData(Context ctx, String companyId, String periodId, String accountBankNoId, String accountId, String currencyId, boolean isShare) throws BOSException, EASBizException {
        if (accountBankNoId == null) {
            accountBankNoId = "";
        }
        int error = 0;
        String errorMsg = null;
        Object cashContrastGLData = null;
        HashMap<String, Object> onloadData = new HashMap<String, Object>();
        HashMap result = new HashMap();
        try {
            HashMap<String, Object> row;
            Map<Object, Object> glRow;
            int flag;
            IContextHelper contextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
            String userID = contextHelper.getCurrentUser().getId().toString();
            PeriodInfo period = new PeriodInfo();
            period.setId(BOSUuid.read((String)periodId));
            period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(period.getId().toString()));
            onloadData.put("labelPeriod", CASWebUtil.getResource(ctx, "WorkPlatform_Period", new String[]{String.valueOf(period.getPeriodYear()), String.valueOf(period.getPeriodNumber())}));
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            company.setId(BOSUuid.read((String)companyId));
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()));
            onloadData.put("labelCompany", company.getName());
            Map map = this.getUIOptionMap(ctx, company.getId().toString(), isShare);
            FmRpcCacheInfo paramInfo = new FmRpcCacheInfo();
            paramInfo.setBatchImplClassName(this.getRpcBatchImplClassName());
            paramInfo.put("company", (Object)company);
            this.rpcCacheInfo = FMBatchProcessFacadeFactory.getLocalInstance((Context)ctx).batchFetchData(paramInfo);
            AccountBankInfo accountBank = new AccountBankInfo();
            CapitalTypeEnum capitalType = CapitalTypeEnum.CASH;
            HashSet<String> bankAcctIdSet = new HashSet<String>();
            if (accountBankNoId.length() != 0) {
                accountBank.setId(BOSUuid.read((String)accountBankNoId));
                accountBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountBank.getId().toString()));
                capitalType = CapitalTypeEnum.BANK;
                bankAcctIdSet.add(accountBank.getId().toString());
                onloadData.put("labelAccountBank", accountBank.getBankAccountNumber());
            }
            AccountViewInfo accountView = new AccountViewInfo();
            accountView.setId(BOSUuid.read((String)accountId));
            accountView = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountView.getId().toString()));
            HashSet<String> acctViewIdSet = new HashSet<String>();
            acctViewIdSet.add(accountView.getId().toString());
            onloadData.put("labelAccountView", accountView.getName());
            CurrencyInfo currency = new CurrencyInfo();
            currency.setId(BOSUuid.read((String)currencyId));
            currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId().toString()));
            onloadData.put("labelCurrency", currency.getName());
            MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.fi.cas", "CashSystemWebQuery");
            EntityViewInfo mainQuery = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id ", (Object)company.getId()));
            filter.getFilterItems().add(new FilterItemInfo("createDate", (Object)period.getBeginDate(), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("createDate", (Object)period.getEndDate(), CompareType.LESS_EQUALS));
            mainQuery.setFilter(filter);
            ArrayList<Map<String, Object>> loadData = new ArrayList();
            ArrayList GLRsData = new ArrayList();
            ArrayList CashRsData = new ArrayList();
            String pk = new String();
            pk = accountBankNoId.length() != 0 ? userID + period.getId().toString() + company.getId().toString() + accountBank.getId().toString() + accountView.getId().toString() + currency.getId().toString() : userID + period.getId().toString() + company.getId().toString() + accountView.getId().toString() + currency.getId().toString();
            onloadData.put("pk", pk);
            boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), "cas_cashcontrastGL_03query");
            if (!isPermission) {
                onloadData.put("period", period);
                onloadData.put("company", company);
                onloadData.put("accountBank", accountBank);
                onloadData.put("accountView", accountView);
                onloadData.put("currency", currency);
                throw new CasWebException(CasWebException.NO_CASHCONTRASTGL_AUTHRIZED);
            }
            int precision = this.getPrecision(ctx, currencyId);
            onloadData.put("precision", precision);
            List<Object> cacheOfUnContrastCashRst = new ArrayList();
            cacheOfUnContrastCashRst = CashContrastGLHelper.getCacheOfUnContrastCashRst(pk);
            if (cacheOfUnContrastCashRst.size() >= 1) {
                for (int z = 0; z < cacheOfUnContrastCashRst.size(); ++z) {
                    Map cashRow = new HashMap();
                    HashMap<String, Object> row2 = new HashMap<String, Object>();
                    cashRow = (Map)cacheOfUnContrastCashRst.get(z);
                    row2.put("select", Boolean.FALSE);
                    row2.put("record", CASWebUtil.getResource(ctx, "CASH"));
                    row2.put("cashId", cashRow.get("id"));
                    row2.put("system", cashRow.get("system"));
                    row2.put("date", cashRow.get("date"));
                    row2.put("description", cashRow.get("description"));
                    row2.put("voucher", cashRow.get("voucher"));
                    row2.put("voucherNumber", cashRow.get("voucherNumber"));
                    row2.put("oppAccountView", cashRow.get("oppAccountView"));
                    row2.put("debitAmount", cashRow.get("debitAmount") + "");
                    row2.put("creditAmount", cashRow.get("creditAmount") + "");
                    row2.put("flag", cashRow.get("flag"));
                    row2.put("settTypeNumber", cashRow.get("settTypeNumber"));
                    row2.put("settType", cashRow.get("settType"));
                    row2.put("settNumber", cashRow.get("settNumber"));
                    row2.put("cash", cashRow.get("cash"));
                    row2.put("source", cashRow.get("source"));
                    CashRsData.add(row2);
                }
                onloadData.put("cashData", CashRsData);
            }
            List<Object> cacheOfUnContrastGLRst = new ArrayList();
            cacheOfUnContrastGLRst = CashContrastGLHelper.getCacheOfUnContrastGLRst(pk);
            if (cacheOfUnContrastGLRst.size() >= 1) {
                for (int k = 0; k < cacheOfUnContrastGLRst.size(); ++k) {
                    Map glRow2 = new HashMap();
                    HashMap<String, Object> row3 = new HashMap<String, Object>();
                    glRow2 = (Map)cacheOfUnContrastGLRst.get(k);
                    row3.put("GLselect", Boolean.FALSE);
                    row3.put("GLrecord", CASWebUtil.getResource(ctx, "GL"));
                    row3.put("GLId", glRow2.get("id"));
                    row3.put("GLsystem", glRow2.get("system"));
                    row3.put("GLoppAccountView", glRow2.get("oppAccountView"));
                    row3.put("GLsettTypeNumber", glRow2.get("settTypeNumber"));
                    row3.put("GLsettType", glRow2.get("settType"));
                    row3.put("GLsettNumber", glRow2.get("settNumber"));
                    row3.put("GLdate", glRow2.get("date"));
                    row3.put("GLdescription", glRow2.get("description"));
                    row3.put("GLvoucher", glRow2.get("voucher"));
                    row3.put("GLvoucherNumber", glRow2.get("voucherNumber"));
                    row3.put("GLdebitAmount", glRow2.get("debitAmount") + "");
                    row3.put("GLcreditAmount", glRow2.get("creditAmount") + "");
                    row3.put("GLflag", glRow2.get("flag"));
                    row3.put("GLcheck", glRow2.get("check"));
                    row3.put("GLsource", glRow2.get("source"));
                    GLRsData.add(row3);
                }
                onloadData.put("gldata", GLRsData);
            }
            if (cacheOfUnContrastCashRst.size() >= 1 || cacheOfUnContrastGLRst.size() >= 1) {
                onloadData.put("period", period);
                onloadData.put("company", company);
                onloadData.put("accountBank", accountBank);
                onloadData.put("accountView", accountView);
                onloadData.put("currency", currency);
                onloadData.put("error", error);
                onloadData.put("errorMsg", errorMsg);
                return onloadData;
            }
            List<Object> cacheOfContrastRst = new ArrayList();
            cacheOfContrastRst = CashContrastGLHelper.getCacheOfContrastRst(pk);
            if (cacheOfContrastRst.size() >= 1) {
                onloadData.put("period", period);
                onloadData.put("company", company);
                onloadData.put("accountBank", accountBank);
                onloadData.put("accountView", accountView);
                onloadData.put("currency", currency);
                onloadData.put("onloadData", cacheOfContrastRst);
                onloadData.put("error", error);
                onloadData.put("errorMsg", errorMsg);
                return onloadData;
            }
            IRowSet cashRs = this.getCashRowset(ctx, (IMetaDataPK)mainQueryPK, mainQuery, currency.getId(), bankAcctIdSet, acctViewIdSet, capitalType, period);
            MetaDataPK gLSystemQueryPK = new MetaDataPK("com.kingdee.eas.fi.cas", "GLSystemWebQuery");
            EntityViewInfo gLSystemQuery = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id ", (Object)company.getId()));
            filter.getFilterItems().add(new FilterItemInfo("createDate", (Object)period.getBeginDate(), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("createDate", (Object)period.getEndDate(), CompareType.LESS_EQUALS));
            FilterInfo filterbizStatus = new FilterInfo();
            filterbizStatus.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(5), CompareType.EQUALS));
            if (TypeConversionUtils.objToBoolean(map.get("containNoAccVoucher"))) {
                filterbizStatus.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(1), CompareType.EQUALS));
                filterbizStatus.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)new Integer(3), CompareType.EQUALS));
                filterbizStatus.setMaskString("#0 or #1 or #2");
            }
            filter.mergeFilter(filterbizStatus, "and");
            gLSystemQuery.setFilter(filter);
            IRowSet glRs = CashBankContrastGLFactory.getLocalInstance(ctx).getGLRowset((IObjectPK)gLSystemQueryPK, (IObjectValue)gLSystemQuery, currency.getId(), bankAcctIdSet, acctViewIdSet, capitalType, period);
            if (cashRs != null || cashRs.size() != 0 || glRs != null || glRs.size() != 0) {
                int i = 0;
                while (cashRs.next()) {
                    HashMap<String, Object> row4 = new HashMap<String, Object>();
                    row4.put("select", Boolean.FALSE);
                    row4.put("record", CASWebUtil.getResource(ctx, "CASH"));
                    row4.put("system", EASResource.getString((String)resourcePath, (String)"CashSystem"));
                    row4.put("id", "1" + i++);
                    row4.put("date", cashRs.getDate("createDate"));
                    row4.put("description", cashRs.getString("description"));
                    String voucherTypeNumber = "";
                    String voucherNumber = "";
                    if (cashRs.getString("voucherNumber") != null) {
                        voucherTypeNumber = voucherNumber = cashRs.getString("voucherNumber");
                    }
                    String voucherType = "";
                    if (cashRs.getString("voucherType.name") != null) {
                        voucherType = cashRs.getString("voucherType.name");
                        voucherTypeNumber = voucherType + "\u3000" + voucherTypeNumber;
                    }
                    row4.put("voucher", voucherTypeNumber);
                    row4.put("voucherNumber", cashRs.getString("voucherNumber"));
                    String oppAccountView = "";
                    if (cashRs.getString("oppAccountView.number") != null) {
                        oppAccountView = cashRs.getString("oppAccountView.number") + "\u3000" + cashRs.getString("oppAccountView.name");
                    }
                    row4.put("oppAccountView", oppAccountView);
                    String settTypeNumber = "";
                    String settType = "";
                    String settNumber = "";
                    if (cashRs.getString("settlementNumber") != null) {
                        settTypeNumber = settNumber = cashRs.getString("settlementNumber");
                    }
                    if (cashRs.getString("settlementType.name") != null) {
                        settType = cashRs.getString("settlementType.name");
                        settTypeNumber = settType + "\u3000" + settTypeNumber;
                    }
                    row4.put("settTypeNumber", settTypeNumber);
                    row4.put("settType", settType);
                    row4.put("settNumber", settNumber);
                    row4.put("debitAmount", cashRs.getBigDecimal("debitAmount").setScale(precision, 4) + "");
                    row4.put("creditAmount", cashRs.getBigDecimal("creditAmount").setScale(precision, 4) + "");
                    row4.put("flag", new Integer(0));
                    row4.put("cash", cashRs.getString("cashier.name"));
                    row4.put("source", JournalSourceEnum.getEnum((int)cashRs.getInt("source")).getAlias());
                    loadData.add(row4);
                    this.cashRsData.add(row4);
                }
                Iterator it = acctViewIdSet.iterator();
                int j = 0;
                while (it.hasNext()) {
                    String acctViewID = it.next().toString();
                    Iterator it2 = bankAcctIdSet.iterator();
                    String bankAccountId = null;
                    if (bankAcctIdSet.size() == 0) {
                        while (glRs.next()) {
                            HashMap<String, Object> row5;
                            BigDecimal emtriesAmt = glRs.getBigDecimal("entries.originalAmount");
                            BigDecimal amt = glRs.getBigDecimal("assistRecords.originalAmount");
                            if (amt == null) {
                                row5 = new HashMap<String, Object>();
                                row5.put("select", Boolean.FALSE);
                                row5.put("record", CASWebUtil.getResource(ctx, "GL"));
                                row5.put("id", "2" + j++);
                                row5.put("system", EASResource.getString((String)resourcePath, (String)"GLSystem"));
                                row5.put("date", glRs.getDate("createDate"));
                                row5.put("description", glRs.getString("entries.description"));
                                String voucherTypeNumber = "";
                                String voucherNumber = "";
                                if (glRs.getString("voucherNumber") != null) {
                                    voucherTypeNumber = voucherNumber = glRs.getString("voucherNumber");
                                }
                                String voucherType = "";
                                if (glRs.getString("voucherType.name") != null) {
                                    voucherType = glRs.getString("voucherType.name");
                                    voucherTypeNumber = voucherType + "\u3000" + voucherTypeNumber;
                                }
                                row5.put("voucher", voucherTypeNumber);
                                row5.put("voucherNumber", glRs.getString("voucherNumber"));
                                String oppAccountView = "";
                                if (glRs.getString("account.number") != null) {
                                    oppAccountView = glRs.getString("account.number") + "\u3000" + glRs.getString("account.name");
                                }
                                row5.put("oppAccountView", oppAccountView);
                                String settTypeNumber = "";
                                String settType = "";
                                String settNumber = "";
                                row5.put("settTypeNumber", settTypeNumber);
                                row5.put("settType", settType);
                                row5.put("settNumber", settNumber);
                                if (glRs.getInt("entries.entryDC") > 0) {
                                    row5.put("debitAmount", emtriesAmt.setScale(precision, 4) + "");
                                    row5.put("creditAmount", CasConstants.ZERO.setScale(precision, 4) + "");
                                } else {
                                    row5.put("debitAmount", CasConstants.ZERO.setScale(precision, 4) + "");
                                    row5.put("creditAmount", emtriesAmt.setScale(precision, 4) + "");
                                }
                                row5.put("flag", new Integer(0));
                                row5.put("check", glRs.getString("cashier.name"));
                                row5.put("source", SourceType.getEnum((int)glRs.getInt("sourceType")).getAlias());
                                loadData.add(row5);
                                this.glRsData.add(row5);
                                continue;
                            }
                            bankAccountId = glRs.getString("bankAccount.id");
                            row5 = new HashMap();
                            row5.put("select", Boolean.FALSE);
                            row5.put("record", CASWebUtil.getResource(ctx, "GL"));
                            row5.put("id", "2" + j++);
                            row5.put("system", EASResource.getString((String)resourcePath, (String)"GLSystem"));
                            row5.put("date", glRs.getDate("createDate"));
                            String desc = glRs.getString("assistRecords.description");
                            if (desc == null) {
                                desc = glRs.getString("entries.description");
                            }
                            row5.put("description", desc);
                            String voucherTypeNumber = "";
                            String voucherNumber = "";
                            if (glRs.getString("voucherNumber") != null) {
                                voucherTypeNumber = voucherNumber = glRs.getString("voucherNumber");
                            }
                            String voucherType = "";
                            if (glRs.getString("voucherType.name") != null) {
                                voucherType = glRs.getString("voucherType.name");
                                voucherTypeNumber = voucherType + "\u3000" + voucherTypeNumber;
                            }
                            row5.put("voucher", voucherTypeNumber);
                            row5.put("voucherNumber", glRs.getString("voucherNumber"));
                            String oppAccountView = "";
                            if (glRs.getString("account.number") != null) {
                                oppAccountView = glRs.getString("account.number") + "\u3000" + glRs.getString("account.name");
                            }
                            row5.put("oppAccountView", oppAccountView);
                            String settTypeNumber = "";
                            String settType = "";
                            String settNumber = "";
                            if (glRs.getString("assistRecords.settlementCode") != null) {
                                settTypeNumber = settNumber = glRs.getString("assistRecords.settlementCode");
                            }
                            if (glRs.getString("settlementType.name") != null) {
                                settType = glRs.getString("settlementType.name");
                                settTypeNumber = settType + "\u3000" + settTypeNumber;
                            }
                            row5.put("settTypeNumber", settTypeNumber);
                            row5.put("settType", settType);
                            row5.put("settNumber", settNumber);
                            if (glRs.getInt("entries.entryDC") > 0) {
                                row5.put("debitAmount", amt.setScale(precision, 4) + "");
                                row5.put("creditAmount", CasConstants.ZERO.setScale(precision, 4) + "");
                            } else {
                                row5.put("debitAmount", CasConstants.ZERO.setScale(precision, 4) + "");
                                row5.put("creditAmount", amt.setScale(precision, 4) + "");
                            }
                            row5.put("flag", new Integer(0));
                            row5.put("check", glRs.getString("cashier.name"));
                            row5.put("source", SourceType.getEnum((int)Integer.parseInt(glRs.getString("sourceType"))).getAlias());
                            loadData.add(row5);
                            this.glRsData.add(row5);
                        }
                        continue;
                    }
                    while (it2.hasNext()) {
                        String accountBankId = it2.next().toString();
                        String desc = null;
                        while (glRs.next()) {
                            String settNumber;
                            String settType;
                            String settTypeNumber;
                            String oppAccountView;
                            String voucherType;
                            String voucherNumber;
                            String voucherTypeNumber;
                            HashMap<String, Object> row6;
                            BigDecimal emtriesAmt = glRs.getBigDecimal("entries.originalAmount");
                            BigDecimal amt = glRs.getBigDecimal("assistRecords.originalAmount");
                            if (amt == null) {
                                row6 = new HashMap<String, Object>();
                                row6.put("select", Boolean.FALSE);
                                row6.put("record", CASWebUtil.getResource(ctx, "GL"));
                                row6.put("id", "2" + j++);
                                row6.put("system", EASResource.getString((String)resourcePath, (String)"GLSystem"));
                                row6.put("date", glRs.getDate("createDate"));
                                row6.put("description", glRs.getString("entries.description"));
                                voucherTypeNumber = "";
                                voucherNumber = "";
                                if (glRs.getString("voucherNumber") != null) {
                                    voucherTypeNumber = voucherNumber = glRs.getString("voucherNumber");
                                }
                                voucherType = "";
                                if (glRs.getString("voucherType.name") != null) {
                                    voucherType = glRs.getString("voucherType.name");
                                    voucherTypeNumber = voucherType + "\u3000" + voucherTypeNumber;
                                }
                                row6.put("voucher", voucherTypeNumber);
                                row6.put("voucherNumber", glRs.getString("voucherNumber"));
                                oppAccountView = "";
                                if (glRs.getString("account.number") != null) {
                                    oppAccountView = glRs.getString("account.number") + "\u3000" + glRs.getString("account.name");
                                }
                                row6.put("oppAccountView", oppAccountView);
                                settTypeNumber = "";
                                settType = "";
                                settNumber = "";
                                row6.put("settTypeNumber", settTypeNumber);
                                row6.put("settType", settType);
                                row6.put("settNumber", settNumber);
                                if (glRs.getInt("entries.entryDC") > 0) {
                                    row6.put("debitAmount", emtriesAmt.setScale(precision, 4) + "");
                                    row6.put("creditAmount", CasConstants.ZERO.setScale(precision, 4) + "");
                                } else {
                                    row6.put("debitAmount", CasConstants.ZERO.setScale(precision, 4) + "");
                                    row6.put("creditAmount", emtriesAmt.setScale(precision, 4) + "");
                                }
                                row6.put("flag", new Integer(0));
                                row6.put("check", glRs.getString("cashier.name"));
                                row6.put("source", SourceType.getEnum((int)glRs.getInt("sourceType")).getAlias());
                                loadData.add(row6);
                                this.glRsData.add(row6);
                                continue;
                            }
                            bankAccountId = glRs.getString("bankAccount.id");
                            row6 = new HashMap();
                            row6.put("select", Boolean.FALSE);
                            row6.put("record", CASWebUtil.getResource(ctx, "GL"));
                            row6.put("id", "2" + j++);
                            row6.put("system", EASResource.getString((String)resourcePath, (String)"GLSystem"));
                            row6.put("date", glRs.getDate("createDate"));
                            desc = glRs.getString("assistRecords.description");
                            if (desc == null) {
                                desc = glRs.getString("entries.description");
                            }
                            row6.put("description", desc);
                            voucherTypeNumber = "";
                            voucherNumber = "";
                            if (glRs.getString("voucherNumber") != null) {
                                voucherTypeNumber = voucherNumber = glRs.getString("voucherNumber");
                            }
                            voucherType = "";
                            if (glRs.getString("voucherType.name") != null) {
                                voucherType = glRs.getString("voucherType.name");
                                voucherTypeNumber = voucherType + "\u3000" + voucherTypeNumber;
                            }
                            row6.put("voucher", voucherTypeNumber);
                            row6.put("voucherNumber", glRs.getString("voucherNumber"));
                            oppAccountView = "";
                            if (glRs.getString("account.number") != null) {
                                oppAccountView = glRs.getString("account.number") + "\u3000" + glRs.getString("account.name");
                            }
                            row6.put("oppAccountView", oppAccountView);
                            settTypeNumber = "";
                            settType = "";
                            settNumber = "";
                            if (glRs.getString("assistRecords.settlementCode") != null) {
                                settTypeNumber = settNumber = glRs.getString("assistRecords.settlementCode");
                            }
                            if (glRs.getString("settlementType.name") != null) {
                                settType = glRs.getString("settlementType.name");
                                settTypeNumber = settType + "\u3000" + settTypeNumber;
                            }
                            row6.put("settTypeNumber", settTypeNumber);
                            row6.put("settType", settType);
                            row6.put("settNumber", settNumber);
                            if (glRs.getInt("entries.entryDC") > 0) {
                                row6.put("debitAmount", amt.setScale(precision, 4) + "");
                                row6.put("creditAmount", CasConstants.ZERO.setScale(precision, 4) + "");
                            } else {
                                row6.put("debitAmount", CasConstants.ZERO.setScale(precision, 4) + "");
                                row6.put("creditAmount", amt.setScale(precision, 4) + "");
                            }
                            row6.put("flag", new Integer(0));
                            row6.put("check", glRs.getString("cashier.name"));
                            row6.put("source", SourceType.getEnum((int)Integer.parseInt(glRs.getString("sourceType"))).getAlias());
                            loadData.add(row6);
                            this.glRsData.add(row6);
                        }
                    }
                }
            }
            loadData = this.autoContrast_Multi_New2(this.cashRsData, this.glRsData, map);
            onloadData.put("onloadData", loadData);
            CashContrastGLHelper.saveCacheOfContrastRst(pk, loadData);
            CashContrastGLHelper.saveCacheOfGroupMaxNumber(pk, this.maxGroupNumber);
            ArrayList<Map<String, Object>> unContrastCashRst = new ArrayList<Map<String, Object>>();
            for (int i = 0; i < this.cashRsData.size(); ++i) {
                Map<Object, Object> cashRow = new HashMap();
                cashRow = this.cashRsData.get(i);
                flag = (Integer)cashRow.get("flag");
                if (flag != 0) continue;
                unContrastCashRst.add(cashRow);
            }
            ArrayList<Map<String, Object>> unContrastGLRst = new ArrayList<Map<String, Object>>();
            for (int i = 0; i < this.glRsData.size(); ++i) {
                glRow = new HashMap();
                glRow = this.glRsData.get(i);
                flag = (Integer)glRow.get("flag");
                if (flag != 0) continue;
                unContrastGLRst.add(glRow);
            }
            CashContrastGLHelper.saveCacheOfUncontrastCashRst(pk, unContrastCashRst);
            CashContrastGLHelper.saveCacheOfUncontrastGLRst(pk, unContrastGLRst);
            for (int x = 0; x < unContrastCashRst.size(); ++x) {
                Map cashRow = new HashMap();
                row = new HashMap<String, Object>();
                cashRow = (Map)unContrastCashRst.get(x);
                row.put("select", Boolean.FALSE);
                row.put("record", CASWebUtil.getResource(ctx, "CASH"));
                row.put("cashId", cashRow.get("id"));
                row.put("system", cashRow.get("system"));
                row.put("date", cashRow.get("date"));
                row.put("description", cashRow.get("description"));
                row.put("voucher", cashRow.get("voucher"));
                row.put("voucherNumber", cashRow.get("voucherNumber"));
                row.put("oppAccountView", cashRow.get("oppAccountView"));
                row.put("debitAmount", cashRow.get("debitAmount"));
                row.put("creditAmount", cashRow.get("creditAmount"));
                row.put("flag", cashRow.get("flag"));
                row.put("settTypeNumber", cashRow.get("settTypeNumber"));
                row.put("settType", cashRow.get("settType"));
                row.put("settNumber", cashRow.get("settNumber"));
                row.put("cash", cashRow.get("cash"));
                row.put("source", cashRow.get("source"));
                CashRsData.add(row);
            }
            for (int k = 0; k < unContrastGLRst.size(); ++k) {
                glRow = new HashMap();
                row = new HashMap();
                glRow = (Map)unContrastGLRst.get(k);
                row.put("GLselect", Boolean.FALSE);
                row.put("GLrecord", CASWebUtil.getResource(ctx, "GL"));
                row.put("GLsystem", glRow.get("system"));
                row.put("GLoppAccountView", glRow.get("oppAccountView"));
                row.put("GLsettTypeNumber", glRow.get("settTypeNumber"));
                row.put("GLsettType", glRow.get("settType"));
                row.put("GLsettNumber", glRow.get("settNumber"));
                row.put("GLdate", glRow.get("date"));
                row.put("GLdescription", glRow.get("description"));
                row.put("GLvoucher", glRow.get("voucher"));
                row.put("GLvoucherNumber", glRow.get("voucherNumber"));
                row.put("GLdebitAmount", glRow.get("debitAmount"));
                row.put("GLcreditAmount", glRow.get("creditAmount"));
                row.put("GLflag", glRow.get("flag"));
                row.put("GLcheck", glRow.get("check"));
                row.put("GLId", glRow.get("id"));
                row.put("GLsource", glRow.get("source"));
                GLRsData.add(row);
            }
            onloadData.put("period", period);
            onloadData.put("company", company);
            onloadData.put("accountBank", accountBank);
            onloadData.put("accountView", accountView);
            onloadData.put("currency", currency);
            onloadData.put("cashData", CashRsData);
            onloadData.put("gldata", GLRsData);
            onloadData.put("error", error);
            onloadData.put("errorMsg", errorMsg);
            return onloadData;
        }
        catch (Exception e) {
            error = 1;
            errorMsg = e.getMessage();
            e.printStackTrace();
            onloadData.put("error", error);
            onloadData.put("errorMsg", errorMsg);
            return onloadData;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _manualContrast(Context ctx, String modelStr) throws BOSException, EASBizException {
        int j;
        int j2;
        boolean isAdd;
        int i;
        ArrayList<Map<String, Object>> newUnContrastGLRst;
        List<Object> unContrastGLRst;
        ArrayList<Map<String, Object>> newUnContrastCashRst;
        ArrayList<Map<String, Object>> newCacheOfContrastRst;
        List<Object> cacheOfContrastRst;
        String pk;
        List GLDataArr;
        List cashDataArr;
        HashMap<String, Object> onloadData;
        String errorMsg;
        int error;
        block27: {
            List<Object> unContrastCashRst;
            block28: {
                error = 0;
                errorMsg = null;
                onloadData = new HashMap<String, Object>();
                cashDataArr = null;
                GLDataArr = null;
                try {
                    HashMap modelMap = JSONUtils.convertJsonToObject((Context)ctx, (String)modelStr);
                    IContextHelper contextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
                    String userID = contextHelper.getCurrentUser().getId().toString();
                    if (modelMap.get("cashDataArr") != null) {
                        cashDataArr = (List)modelMap.get("cashDataArr");
                    }
                    if (modelMap.get("GLDataArr") != null) {
                        GLDataArr = (List)modelMap.get("GLDataArr");
                    }
                    if (cashDataArr.size() <= 0) {
                        error = 1;
                        errorMsg = CASWebUtil.getResource(ctx, "SelectManualCash");
                        onloadData.put("error", error);
                        onloadData.put("errorMsg", errorMsg);
                        return onloadData;
                    }
                    if (GLDataArr.size() <= 0) {
                        error = 1;
                        errorMsg = CASWebUtil.getResource(ctx, "SelectManualGL");
                        onloadData.put("error", error);
                        onloadData.put("errorMsg", errorMsg);
                        return onloadData;
                    }
                    BigDecimal tmpCashDebitAmount = CasConstants.ZERO;
                    BigDecimal tmpCashCreditAmount = CasConstants.ZERO;
                    BigDecimal tmpGlDebitAmount = CasConstants.ZERO;
                    BigDecimal tmpGlCreditAmount = CasConstants.ZERO;
                    Map cashRow = new HashMap();
                    for (int i2 = 0; i2 < cashDataArr.size(); tmpCashDebitAmount = tmpCashDebitAmount.add(new BigDecimal((Double)cashRow.get("debitAmount"))), tmpCashCreditAmount = tmpCashCreditAmount.add(new BigDecimal((Double)cashRow.get("creditAmount"))), ++i2) {
                        cashRow = (Map)cashDataArr.get(i2);
                    }
                    Map GLRow = new HashMap();
                    for (int i3 = 0; i3 < GLDataArr.size(); tmpGlDebitAmount = tmpGlDebitAmount.add(new BigDecimal((Double)GLRow.get("GLdebitAmount"))), tmpGlCreditAmount = tmpGlCreditAmount.add(new BigDecimal((Double)GLRow.get("GLcreditAmount"))), ++i3) {
                        GLRow = (Map)GLDataArr.get(i3);
                    }
                    if (tmpCashDebitAmount.compareTo(tmpGlDebitAmount) == 0 && tmpCashCreditAmount.compareTo(tmpGlCreditAmount) == 0) {
                        PeriodInfo period = new PeriodInfo();
                        period.setId(BOSUuid.read((String)((String)modelMap.get("periodId"))));
                        period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(period.getId().toString()));
                        onloadData.put("labelPeriod", CASWebUtil.getResource(ctx, "WorkPlatform_Period", new String[]{String.valueOf(period.getPeriodYear()), String.valueOf(period.getPeriodNumber())}));
                        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                        company.setId(BOSUuid.read((String)((String)modelMap.get("companyId"))));
                        company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()));
                        onloadData.put("labelCompany", company.getName());
                        FmRpcCacheInfo paramInfo = new FmRpcCacheInfo();
                        paramInfo.setBatchImplClassName(this.getRpcBatchImplClassName());
                        paramInfo.put("company", (Object)company);
                        this.rpcCacheInfo = FMBatchProcessFacadeFactory.getLocalInstance((Context)ctx).batchFetchData(paramInfo);
                        AccountBankInfo accountBank = new AccountBankInfo();
                        CapitalTypeEnum capitalType = CapitalTypeEnum.CASH;
                        HashSet<String> bankAcctIdSet = new HashSet<String>();
                        String accountBankNoId = (String)modelMap.get("accountBankNoId");
                        if (accountBankNoId.length() != 0) {
                            accountBank.setId(BOSUuid.read((String)accountBankNoId));
                            accountBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountBank.getId().toString()));
                            capitalType = CapitalTypeEnum.BANK;
                            bankAcctIdSet.add(accountBank.getId().toString());
                            onloadData.put("labelAccountBank", accountBank.getBankAccountNumber());
                        }
                        AccountViewInfo accountView = new AccountViewInfo();
                        accountView.setId(BOSUuid.read((String)((String)modelMap.get("accountId"))));
                        accountView = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountView.getId().toString()));
                        HashSet<String> acctViewIdSet = new HashSet<String>();
                        acctViewIdSet.add(accountView.getId().toString());
                        onloadData.put("labelAccountView", accountView.getName());
                        CurrencyInfo currency = new CurrencyInfo();
                        currency.setId(BOSUuid.read((String)((String)modelMap.get("currencyId"))));
                        currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId().toString()));
                        onloadData.put("labelCurrency", currency.getName());
                        pk = new String();
                        pk = accountBankNoId.length() != 0 ? userID + period.getId().toString() + company.getId().toString() + accountBank.getId().toString() + accountView.getId().toString() + currency.getId().toString() : userID + period.getId().toString() + company.getId().toString() + accountView.getId().toString() + currency.getId().toString();
                        onloadData.put("pk", pk);
                        onloadData.put("error", error);
                        onloadData.put("errorMsg", errorMsg);
                        onloadData.put("period", period);
                        onloadData.put("company", company);
                        onloadData.put("accountBank", accountBank);
                        onloadData.put("accountView", accountView);
                        onloadData.put("currency", currency);
                        cacheOfContrastRst = new ArrayList();
                        cacheOfContrastRst = CashContrastGLHelper.getCacheOfContrastRst(pk);
                        newCacheOfContrastRst = new ArrayList<Map<String, Object>>();
                        unContrastCashRst = new ArrayList();
                        unContrastCashRst = CashContrastGLHelper.getCacheOfUnContrastCashRst(pk);
                        newUnContrastCashRst = new ArrayList<Map<String, Object>>();
                        unContrastGLRst = new ArrayList();
                        unContrastGLRst = CashContrastGLHelper.getCacheOfUnContrastGLRst(pk);
                        newUnContrastGLRst = new ArrayList<Map<String, Object>>();
                        if (unContrastCashRst.size() < 1) break block27;
                        break block28;
                    }
                    error = 1;
                    errorMsg = EASResource.getString((String)resourcePath, (String)"NoContrastCon");
                    errorMsg = CASWebUtil.getResource(ctx, "NoContrastCon");
                    onloadData.put("error", error);
                    onloadData.put("errorMsg", errorMsg);
                    return onloadData;
                }
                catch (Exception e) {
                    error = 1;
                    errorMsg = e.getMessage();
                    e.printStackTrace();
                }
                return onloadData;
            }
            for (i = 0; i < unContrastCashRst.size(); ++i) {
                Map cashRstRow = new HashMap();
                cashRstRow = (Map)unContrastCashRst.get(i);
                int cashId = Integer.parseInt(cashRstRow.get("id").toString());
                isAdd = true;
                for (j2 = 0; j2 < cashDataArr.size(); ++j2) {
                    HashMap hashMap = new HashMap();
                    Map map = (Map)cashDataArr.get(j2);
                    int cashDataId = Integer.parseInt(map.get("cashId").toString());
                    if (cashId != cashDataId) continue;
                    isAdd = false;
                }
                if (!isAdd) continue;
                cashRstRow.put("date", cashRstRow.get("date"));
                newUnContrastCashRst.add(cashRstRow);
            }
        }
        onloadData.put("cashData", newUnContrastCashRst);
        if (unContrastGLRst.size() >= 1) {
            for (i = 0; i < unContrastGLRst.size(); ++i) {
                Map GLRstRow = new HashMap();
                GLRstRow = (Map)unContrastGLRst.get(i);
                int GLId = Integer.parseInt(GLRstRow.get("id").toString());
                isAdd = true;
                for (j2 = 0; j2 < GLDataArr.size(); ++j2) {
                    HashMap hashMap = new HashMap();
                    Map map = (Map)GLDataArr.get(j2);
                    int GLDataId = Integer.parseInt(map.get("GLId").toString());
                    if (GLId != GLDataId) continue;
                    isAdd = false;
                }
                if (!isAdd) continue;
                GLRstRow.put("GLdate", GLRstRow.get("GLdate"));
                newUnContrastGLRst.add(GLRstRow);
            }
        }
        BigInteger maxGroupNumber = CashContrastGLHelper.getCacheOfGroupMaxNumber(pk);
        BigInteger step = new BigInteger("1");
        maxGroupNumber = maxGroupNumber.add(step);
        CashContrastGLHelper.saveCacheOfGroupMaxNumber(pk, maxGroupNumber);
        if (cashDataArr.size() > 0) {
            cacheOfContrastRst = CashContrastGLHelper.getCacheOfContrastRst(pk);
            for (j = 0; j < cashDataArr.size(); ++j) {
                Map<String, Boolean> cashDataRow = new HashMap();
                cashDataRow = (Map)cashDataArr.get(j);
                cashDataRow.put("group", (Boolean)((Object)maxGroupNumber));
                cashDataRow.put("select", Boolean.FALSE);
                cashDataRow.put("id", (Boolean)cashDataRow.get("cashId"));
                cashDataRow.put("flag", (Boolean)((Object)new Integer(2)));
                cashDataRow.put("date", (Boolean)((Object)CashContrastGLWebFacadeControllerBean.parseDate((String)cashDataRow.get("date"))));
                newCacheOfContrastRst.add(cashDataRow);
            }
        }
        if (GLDataArr.size() > 0) {
            for (j = 0; j < GLDataArr.size(); ++j) {
                Map GLDataRow = new HashMap();
                GLDataRow = (Map)GLDataArr.get(j);
                HashMap<String, Object> row = new HashMap<String, Object>();
                row.put("select", Boolean.FALSE);
                row.put("record", CASWebUtil.getResource(ctx, "GL"));
                row.put("id", GLDataRow.get("GLId"));
                row.put("system", GLDataRow.get("GLsystem"));
                row.put("date", CashContrastGLWebFacadeControllerBean.parseDate((String)GLDataRow.get("GLdate")));
                row.put("description", GLDataRow.get("GLdescription"));
                row.put("voucher", GLDataRow.get("GLvoucher"));
                row.put("voucherNumber", GLDataRow.get("GLvoucherNumber"));
                String string = "";
                String settType = "";
                String settNumber = "";
                row.put("settTypeNumber", GLDataRow.get("GLsettTypeNumber"));
                row.put("settType", GLDataRow.get("GLsettType"));
                row.put("settNumber", GLDataRow.get("GLsettNumber"));
                row.put("debitAmount", GLDataRow.get("GLdebitAmount"));
                row.put("creditAmount", GLDataRow.get("GLcreditAmount"));
                row.put("flag", GLDataRow.get("GLflag"));
                row.put("check", GLDataRow.get("GLcheck"));
                row.put("source", GLDataRow.get("GLsource"));
                row.put("group", maxGroupNumber);
                row.put("select", Boolean.FALSE);
                row.put("flag", new Integer(2));
                row.put("oppAccountView", GLDataRow.get("GLoppAccountView"));
                newCacheOfContrastRst.add(row);
            }
        }
        ArrayList newCashRsData = new ArrayList();
        if (newUnContrastCashRst.size() >= 1) {
            for (int y = 0; y < newUnContrastCashRst.size(); ++y) {
                Map cashNewRow = new HashMap();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                cashNewRow = (Map)newUnContrastCashRst.get(y);
                hashMap.put("select", Boolean.FALSE);
                hashMap.put("record", CASWebUtil.getResource(ctx, "CASH"));
                hashMap.put("cashId", cashNewRow.get("id"));
                hashMap.put("system", cashNewRow.get("system"));
                hashMap.put("date", cashNewRow.get("date"));
                hashMap.put("description", cashNewRow.get("description"));
                hashMap.put("voucher", cashNewRow.get("voucher"));
                hashMap.put("voucherNumber", cashNewRow.get("voucherNumber"));
                hashMap.put("oppAccountView", cashNewRow.get("oppAccountView"));
                hashMap.put("debitAmount", cashNewRow.get("debitAmount"));
                hashMap.put("creditAmount", cashNewRow.get("creditAmount"));
                hashMap.put("flag", cashNewRow.get("flag"));
                hashMap.put("settTypeNumber", cashNewRow.get("settTypeNumber"));
                hashMap.put("settType", cashNewRow.get("settType"));
                hashMap.put("settNumber", cashNewRow.get("settNumber"));
                hashMap.put("cash", cashNewRow.get("cash"));
                hashMap.put("source", cashNewRow.get("source"));
                newCashRsData.add(hashMap);
            }
        }
        onloadData.put("cashData", newCashRsData);
        ArrayList newGLRsData = new ArrayList();
        if (newUnContrastGLRst.size() >= 1) {
            for (int k = 0; k < newUnContrastGLRst.size(); ++k) {
                HashMap hashMap = new HashMap();
                HashMap<String, Object> row = new HashMap<String, Object>();
                Map map = (Map)newUnContrastGLRst.get(k);
                row.put("GLselect", Boolean.FALSE);
                row.put("GLrecord", CASWebUtil.getResource(ctx, "GL"));
                row.put("GLId", map.get("id"));
                row.put("GLsystem", map.get("system"));
                row.put("GLoppAccountView", map.get("oppAccountView"));
                row.put("GLsettTypeNumber", map.get("settTypeNumber"));
                row.put("GLsettType", map.get("settType"));
                row.put("GLsettNumber", map.get("settNumber"));
                row.put("GLdate", map.get("date"));
                row.put("GLdescription", map.get("description"));
                row.put("GLvoucher", map.get("voucher"));
                row.put("GLvoucherNumber", map.get("voucherNumber"));
                row.put("GLdebitAmount", map.get("debitAmount"));
                row.put("GLcreditAmount", map.get("creditAmount"));
                row.put("GLflag", map.get("flag"));
                row.put("GLcheck", map.get("check"));
                row.put("GLsource", map.get("source"));
                newGLRsData.add(row);
            }
        }
        onloadData.put("gldata", newGLRsData);
        if (newCacheOfContrastRst.size() >= 1) {
            CashContrastGLHelper.saveCacheOfContrastRst(pk, newCacheOfContrastRst);
            if (newCacheOfContrastRst.size() != cacheOfContrastRst.size()) {
                onloadData.put("summaryMsg", CASWebUtil.getResource(ctx, "296_ManualContrast_SUCCESS"));
                error = 0;
                onloadData.put("error", error);
            }
        }
        if (cacheOfContrastRst.size() >= 1) {
            for (int i4 = 0; i4 < cacheOfContrastRst.size(); ++i4) {
                HashMap hashMap = new HashMap();
                Map map = (Map)cacheOfContrastRst.get(i4);
                newCacheOfContrastRst.add(map);
            }
            onloadData.put("error", error);
            onloadData.put("errorMsg", errorMsg);
        }
        onloadData.put("onloadData", newCacheOfContrastRst);
        CashContrastGLHelper.saveCacheOfContrastRst(pk, newCacheOfContrastRst);
        CashContrastGLHelper.saveCacheOfUncontrastCashRst(pk, newUnContrastCashRst);
        CashContrastGLHelper.saveCacheOfUncontrastGLRst(pk, newUnContrastGLRst);
        return onloadData;
    }

    @Override
    protected Map _autoContrast(Context ctx, String modelStr) throws BOSException, EASBizException {
        int error = 0;
        String errorMsg = null;
        Object cashContrastGLData = null;
        HashMap<String, Object> onloadData = new HashMap<String, Object>();
        HashMap result = new HashMap();
        try {
            HashMap<String, Object> row;
            Map glRow;
            HashMap modelMap = JSONUtils.convertJsonToObject((Context)ctx, (String)modelStr);
            IContextHelper contextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
            String userID = contextHelper.getCurrentUser().getId().toString();
            PeriodInfo period = new PeriodInfo();
            period.setId(BOSUuid.read((String)((String)modelMap.get("periodId"))));
            period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(period.getId().toString()));
            onloadData.put("labelPeriod", CASWebUtil.getResource(ctx, "WorkPlatform_Period", new String[]{String.valueOf(period.getPeriodYear()), String.valueOf(period.getPeriodNumber())}));
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            company.setId(BOSUuid.read((String)((String)modelMap.get("companyId"))));
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()));
            onloadData.put("labelCompany", company.getName());
            Map map = this.getUIOptionMap(ctx, company.getId().toString(), (Boolean)modelMap.get("isShare"));
            FmRpcCacheInfo paramInfo = new FmRpcCacheInfo();
            paramInfo.setBatchImplClassName(this.getRpcBatchImplClassName());
            paramInfo.put("company", (Object)company);
            this.rpcCacheInfo = FMBatchProcessFacadeFactory.getLocalInstance((Context)ctx).batchFetchData(paramInfo);
            AccountBankInfo accountBank = new AccountBankInfo();
            CapitalTypeEnum capitalType = CapitalTypeEnum.CASH;
            HashSet<String> bankAcctIdSet = new HashSet<String>();
            String accountBankNoId = (String)modelMap.get("accountBankNoId");
            if (accountBankNoId.length() != 0) {
                accountBank.setId(BOSUuid.read((String)accountBankNoId));
                accountBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountBank.getId().toString()));
                capitalType = CapitalTypeEnum.BANK;
                bankAcctIdSet.add(accountBank.getId().toString());
                onloadData.put("labelAccountBank", accountBank.getBankAccountNumber());
            }
            AccountViewInfo accountView = new AccountViewInfo();
            accountView.setId(BOSUuid.read((String)((String)modelMap.get("accountId"))));
            accountView = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountView.getId().toString()));
            HashSet<String> acctViewIdSet = new HashSet<String>();
            acctViewIdSet.add(accountView.getId().toString());
            onloadData.put("labelAccountView", accountView.getName());
            CurrencyInfo currency = new CurrencyInfo();
            currency.setId(BOSUuid.read((String)((String)modelMap.get("currencyId"))));
            currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId().toString()));
            onloadData.put("labelCurrency", currency.getName());
            List<Object> loadData = new ArrayList();
            ArrayList GLRsData = new ArrayList();
            ArrayList CashRsData = new ArrayList();
            String pk = new String();
            pk = accountBankNoId.length() != 0 ? userID + period.getId().toString() + company.getId().toString() + accountBank.getId().toString() + accountView.getId().toString() + currency.getId().toString() : userID + period.getId().toString() + company.getId().toString() + accountView.getId().toString() + currency.getId().toString();
            onloadData.put("pk", pk);
            int precision = this.getPrecision(ctx, (String)modelMap.get("currencyId"));
            onloadData.put("precision", precision);
            List<Object> cacheOfUnContrastCashRst = new ArrayList();
            cacheOfUnContrastCashRst = CashContrastGLHelper.getCacheOfUnContrastCashRst(pk);
            boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(company.getId().toString()), "cas_cashcontrastGLDetail_02query");
            if (!isPermission) {
                onloadData.put("period", period);
                onloadData.put("company", company);
                onloadData.put("accountBank", accountBank);
                onloadData.put("accountView", accountView);
                onloadData.put("currency", currency);
                throw new CasWebException(CasWebException.NO_CASHCONTRASTGLDETAIL_AUTHRIZED);
            }
            if (cacheOfUnContrastCashRst.size() >= 1) {
                for (int z = 0; z < cacheOfUnContrastCashRst.size(); ++z) {
                    Map cashRow = new HashMap();
                    HashMap<String, Object> row2 = new HashMap<String, Object>();
                    cashRow = (Map)cacheOfUnContrastCashRst.get(z);
                    row2.put("select", Boolean.FALSE);
                    row2.put("record", CASWebUtil.getResource(ctx, "CASH"));
                    row2.put("id", cashRow.get("id"));
                    row2.put("system", cashRow.get("system"));
                    row2.put("date", cashRow.get("date"));
                    row2.put("description", cashRow.get("description"));
                    row2.put("voucher", cashRow.get("voucher"));
                    row2.put("voucherNumber", cashRow.get("voucherNumber"));
                    row2.put("oppAccountView", cashRow.get("oppAccountView"));
                    row2.put("debitAmount", cashRow.get("debitAmount") + "");
                    row2.put("creditAmount", cashRow.get("creditAmount") + "");
                    row2.put("flag", cashRow.get("flag"));
                    row2.put("settTypeNumber", cashRow.get("settTypeNumber"));
                    row2.put("settType", cashRow.get("settType"));
                    row2.put("settNumber", cashRow.get("settNumber"));
                    row2.put("cash", cashRow.get("cash"));
                    row2.put("source", cashRow.get("source"));
                    this.autoCashRsData.add(row2);
                }
            }
            List<Object> cacheOfUnContrastGLRst = new ArrayList();
            cacheOfUnContrastGLRst = CashContrastGLHelper.getCacheOfUnContrastGLRst(pk);
            if (cacheOfUnContrastGLRst.size() >= 1) {
                int flag;
                for (int k = 0; k < cacheOfUnContrastGLRst.size(); ++k) {
                    glRow = new HashMap();
                    row = new HashMap<String, Object>();
                    glRow = (Map)cacheOfUnContrastGLRst.get(k);
                    row.put("select", Boolean.FALSE);
                    row.put("record", CASWebUtil.getResource(ctx, "GL"));
                    row.put("id", glRow.get("id"));
                    row.put("system", glRow.get("system"));
                    row.put("oppAccountView", glRow.get("oppAccountView"));
                    row.put("settTypeNumber", glRow.get("settTypeNumber"));
                    row.put("settType", glRow.get("settType"));
                    row.put("settNumber", glRow.get("settNumber"));
                    row.put("date", glRow.get("date"));
                    row.put("description", glRow.get("description"));
                    row.put("voucher", glRow.get("voucher"));
                    row.put("voucherNumber", glRow.get("voucherNumber"));
                    row.put("debitAmount", glRow.get("debitAmount") + "");
                    row.put("creditAmount", glRow.get("creditAmount") + "");
                    row.put("flag", glRow.get("flag"));
                    row.put("check", glRow.get("check"));
                    row.put("source", glRow.get("source"));
                    this.autoGlRsData.add(row);
                }
                loadData = this.autoContrast_Multi_New22(this.autoCashRsData, this.autoGlRsData, map);
                BigInteger maxGroupNumber = CashContrastGLHelper.getCacheOfGroupMaxNumber(pk);
                BigInteger step = new BigInteger("1");
                maxGroupNumber = maxGroupNumber.add(step);
                CashContrastGLHelper.saveCacheOfGroupMaxNumber(pk, maxGroupNumber);
                List<Object> cacheOfContrastRst = new ArrayList();
                cacheOfContrastRst = CashContrastGLHelper.getCacheOfContrastRst(pk);
                ArrayList<Map<String, Object>> newCacheOfContrastRst = new ArrayList();
                if (loadData.size() >= 1) {
                    newCacheOfContrastRst = loadData;
                    if (cacheOfContrastRst.size() >= 1) {
                        for (int i = 0; i < cacheOfContrastRst.size(); ++i) {
                            Map contrastRstRow = new HashMap();
                            contrastRstRow = (Map)cacheOfContrastRst.get(i);
                            newCacheOfContrastRst.add(contrastRstRow);
                        }
                    }
                    CashContrastGLHelper.saveCacheOfContrastRst(pk, newCacheOfContrastRst);
                }
                ArrayList<Map<String, Object>> unContrastCashRst = new ArrayList<Map<String, Object>>();
                for (int i = 0; i < this.autoCashRsData.size(); ++i) {
                    Map<Object, Object> cashRow = new HashMap();
                    cashRow = this.autoCashRsData.get(i);
                    flag = (Integer)cashRow.get("flag");
                    if (flag != 0) continue;
                    unContrastCashRst.add(cashRow);
                }
                ArrayList<Map<String, Object>> unContrastGLRst = new ArrayList<Map<String, Object>>();
                for (int i = 0; i < this.autoGlRsData.size(); ++i) {
                    Map<Object, Object> glRow2 = new HashMap();
                    glRow2 = this.autoGlRsData.get(i);
                    flag = (Integer)glRow2.get("flag");
                    if (flag != 0) continue;
                    unContrastGLRst.add(glRow2);
                }
                CashContrastGLHelper.saveCacheOfUncontrastCashRst(pk, unContrastCashRst);
                CashContrastGLHelper.saveCacheOfUncontrastGLRst(pk, unContrastGLRst);
            }
            cacheOfUnContrastCashRst = new ArrayList();
            cacheOfUnContrastCashRst = CashContrastGLHelper.getCacheOfUnContrastCashRst(pk);
            if (cacheOfUnContrastCashRst.size() >= 1) {
                for (int z = 0; z < cacheOfUnContrastCashRst.size(); ++z) {
                    Map cashRow = new HashMap();
                    row = new HashMap();
                    cashRow = (Map)cacheOfUnContrastCashRst.get(z);
                    row.put("select", Boolean.FALSE);
                    row.put("record", CASWebUtil.getResource(ctx, "CASH"));
                    row.put("cashId", cashRow.get("id"));
                    row.put("system", cashRow.get("system"));
                    row.put("date", cashRow.get("date"));
                    row.put("description", cashRow.get("description"));
                    row.put("voucher", cashRow.get("voucher"));
                    row.put("voucherNumber", cashRow.get("voucherNumber"));
                    row.put("oppAccountView", cashRow.get("oppAccountView"));
                    row.put("debitAmount", cashRow.get("debitAmount"));
                    row.put("creditAmount", cashRow.get("creditAmount"));
                    row.put("flag", cashRow.get("flag"));
                    row.put("settTypeNumber", cashRow.get("settTypeNumber"));
                    row.put("settType", cashRow.get("settType"));
                    row.put("settNumber", cashRow.get("settNumber"));
                    row.put("cash", cashRow.get("cash"));
                    row.put("source", cashRow.get("source"));
                    CashRsData.add(row);
                }
                onloadData.put("cashData", CashRsData);
            }
            cacheOfUnContrastGLRst = new ArrayList();
            cacheOfUnContrastGLRst = CashContrastGLHelper.getCacheOfUnContrastGLRst(pk);
            if (cacheOfUnContrastGLRst.size() >= 1) {
                for (int k = 0; k < cacheOfUnContrastGLRst.size(); ++k) {
                    glRow = new HashMap();
                    row = new HashMap();
                    glRow = (Map)cacheOfUnContrastGLRst.get(k);
                    row.put("GLselect", Boolean.FALSE);
                    row.put("GLrecord", CASWebUtil.getResource(ctx, "GL"));
                    row.put("GLId", glRow.get("id"));
                    row.put("GLsystem", glRow.get("system"));
                    row.put("GLoppAccountView", glRow.get("oppAccountView"));
                    row.put("GLsettTypeNumber", glRow.get("settTypeNumber"));
                    row.put("GLsettType", glRow.get("settType"));
                    row.put("GLsettNumber", glRow.get("settNumber"));
                    row.put("GLdate", glRow.get("date"));
                    row.put("GLdescription", glRow.get("description"));
                    row.put("GLvoucher", glRow.get("voucher"));
                    row.put("GLvoucherNumber", glRow.get("voucherNumber"));
                    row.put("GLdebitAmount", glRow.get("debitAmount"));
                    row.put("GLcreditAmount", glRow.get("creditAmount"));
                    row.put("GLflag", glRow.get("flag"));
                    row.put("GLcheck", glRow.get("check"));
                    row.put("GLsource", glRow.get("source"));
                    GLRsData.add(row);
                }
                onloadData.put("gldata", GLRsData);
            }
            onloadData.put("period", period);
            onloadData.put("company", company);
            onloadData.put("accountBank", accountBank);
            onloadData.put("accountView", accountView);
            onloadData.put("currency", currency);
            onloadData.put("cashData", CashRsData);
            onloadData.put("gldata", GLRsData);
            onloadData.put("error", error);
            onloadData.put("errorMsg", errorMsg);
            return onloadData;
        }
        catch (Exception e) {
            error = 1;
            errorMsg = e.getMessage();
            e.printStackTrace();
            return result;
        }
    }

    public List<Map<String, Object>> autoContrast_Multi_New22(List<Map<String, Object>> cashRsData, List<Map<String, Object>> glRsData, Map map) throws BOSException, EASBizException {
        ArrayList<Map<String, Object>> loadData = new ArrayList<Map<String, Object>>();
        int tblCashSize = cashRsData.size();
        int tblGLSize = glRsData.size();
        if (tblCashSize == 0 || tblGLSize == 0) {
            return loadData;
        }
        BigDecimal tmpCashCreditAmount = CasConstants.ZERO;
        BigDecimal tmpGlDebitAmount = CasConstants.ZERO;
        BigDecimal tmpGlCreditAmount = CasConstants.ZERO;
        int total = 0;
        Map<Object, Object> cashRow = new HashMap();
        Map<Object, Object> glRow = new HashMap();
        ArrayList itemList = new ArrayList();
        block0: for (int i = 0; i < tblCashSize; ++i) {
            cashRow = cashRsData.get(i);
            int flag = (Integer)cashRow.get("flag");
            if (flag != 0) continue;
            BigDecimal tmpCashDebitAmount = new BigDecimal((String)cashRow.get("debitAmount"));
            tmpCashCreditAmount = new BigDecimal((String)cashRow.get("creditAmount"));
            for (int j = 0; j < tblGLSize; ++j) {
                glRow = glRsData.get(j);
                flag = (Integer)glRow.get("flag");
                if (flag != 0) continue;
                tmpGlDebitAmount = new BigDecimal((String)glRow.get("debitAmount"));
                tmpGlCreditAmount = new BigDecimal((String)glRow.get("creditAmount"));
                if (tmpCashDebitAmount.compareTo(tmpGlDebitAmount) != 0 || tmpCashCreditAmount.compareTo(tmpGlCreditAmount) != 0 || !this.isMeetOtherConditionsManual(cashRow, glRow, map)) continue;
                cashRow.put("group", i);
                cashRow.put("select", Boolean.FALSE);
                cashRow.put("flag", new Integer(1));
                glRow.put("group", i);
                glRow.put("select", Boolean.FALSE);
                glRow.put("flag", new Integer(1));
                itemList = new ArrayList();
                loadData.add(cashRow);
                loadData.add(glRow);
                ++total;
                continue block0;
            }
        }
        this.sucessContrastTotal += total;
        StringBuffer msgStr = new StringBuffer(128);
        msgStr.append(EASResource.getString((String)resourcePath, (String)"SucessContrastTotal"));
        msgStr.append(total);
        msgStr.append(EASResource.getString((String)resourcePath, (String)"Group"));
        return loadData;
    }

    private boolean isMeetOtherConditionsManual(Map<String, Object> cashRow, Map<String, Object> glRow, Map map) {
        boolean isDateEquals = false;
        boolean isDescriptionEquals = false;
        boolean isSettTypeEquals = false;
        boolean isSettNumberEquals = false;
        boolean isVoucherNumEquals = false;
        if (map != null && map.size() != 0) {
            isDateEquals = TypeConversionUtils.objToBoolean(map.get("bizDateEq"));
            isDescriptionEquals = TypeConversionUtils.objToBoolean(map.get("descriptionEq"));
            isSettTypeEquals = TypeConversionUtils.objToBoolean(map.get("settlementTypeEq"));
            isSettNumberEquals = TypeConversionUtils.objToBoolean(map.get("settlementNumberEq"));
            isVoucherNumEquals = TypeConversionUtils.objToBoolean(map.get("voucherNumberEq"));
        }
        boolean isEquals = false;
        Date cashCreateDate = (Date)cashRow.get("date");
        String cashVoucherNumber = (String)cashRow.get("voucherNumber");
        String cashDescription = (String)cashRow.get("description");
        String cashSettType = (String)cashRow.get("settType");
        String cashSettNumber = (String)cashRow.get("settNumber");
        Date glCreateDate = (Date)glRow.get("date");
        String glVoucherNumber = (String)glRow.get("voucherNumber");
        String glDescription = (String)glRow.get("description");
        String glSettType = (String)glRow.get("settType");
        String glSettNumber = (String)glRow.get("settNumber");
        isDateEquals = isDateEquals ? CashHelper.isEquals(cashCreateDate, glCreateDate) : true;
        isDescriptionEquals = isDescriptionEquals ? CashHelper.isEquals(cashDescription, glDescription) : true;
        isSettTypeEquals = isSettTypeEquals ? CashHelper.isEquals(cashSettType, glSettType) : true;
        isSettNumberEquals = isSettNumberEquals ? CashHelper.isEquals(cashSettNumber, glSettNumber) : true;
        isVoucherNumEquals = isVoucherNumEquals ? CashHelper.isEquals(cashVoucherNumber, glVoucherNumber) : true;
        isEquals = isDateEquals && isDescriptionEquals && isSettTypeEquals && isSettNumberEquals && isVoucherNumEquals;
        return isEquals;
    }

    @Override
    protected String _getOrgDataFilter(Context ctx, boolean share) throws BOSException, EASBizException {
        StringBuffer orgDataFilter = new StringBuffer("id in ( ");
        try {
            CompanyOrgUnitCollection companyColl = new CompanyOrgUnitCollection();
            CompanyOrgUnitCollection coll = FMHelper.getUserOrgRangesWithRange((Context)ctx, (String)"cas_cashcontrastGL_01view");
            CompanyOrgUnitCollection initColl = new CompanyOrgUnitCollection();
            CompanyOrgUnitInfo current = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
            if (coll != null) {
                for (int i = 0; i < coll.size(); ++i) {
                    boolean flag;
                    boolean fGLStart;
                    boolean isPermission;
                    PeriodInfo startPeriod;
                    PeriodCollection commonPeriodColl = null;
                    CompanyOrgUnitInfo info = coll.get(i);
                    if (!info.isIsBizUnit() || info.isIsOUSealUp() || info.isIsAssistantOrg() || null == (startPeriod = SystemStatusCtrolUtils.getStartPeriod(ctx, SystemEnum.CASHMANAGEMENT, info)) || !(isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getId().toString()), "cas_cashcontrastGL_01view")) || !(fGLStart = SystemStatusCtrolUtils.isStart(ctx, SystemEnum.GENERALLEDGER, info)) || !(flag = SystemStatusCtrolUtils.isStart(ctx, SystemEnum.CASHMANAGEMENT, info))) continue;
                    commonPeriodColl = CashContrastGLWebFacadeControllerBean.getCashGlPeriod(ctx, info);
                    if (commonPeriodColl.size() == 0) continue;
                    initColl.add(coll.get(i));
                    String orgUnitId = coll.get(i).getId().toString();
                    if (share) {
                        orgDataFilter.append("'" + orgUnitId + "',");
                        continue;
                    }
                    if (!current.getId().toString().equals(orgUnitId)) continue;
                    orgDataFilter.append("'" + orgUnitId + "',");
                }
                if (orgDataFilter.toString().equals("id in ( ")) {
                    orgDataFilter = new StringBuffer("id in ('NE')");
                } else {
                    orgDataFilter.deleteCharAt(orgDataFilter.length() - 1);
                    orgDataFilter.append(") ");
                }
                return orgDataFilter.toString();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return null;
    }

    private static PeriodCollection getPeriodColl(Context ctx, String startPeriod, String currPeriod, String companyId) throws EASBizException, BOSException {
        if (startPeriod == null || currPeriod == null) {
            return new PeriodCollection();
        }
        ObjectUuidPK pkFrom = new ObjectUuidPK(startPeriod);
        ObjectUuidPK pkTo = new ObjectUuidPK(currPeriod);
        ObjectUuidPK companyPk = new ObjectUuidPK(companyId);
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        PeriodCollection periodColl = iPeriod.getPeriodCollection((IObjectPK)pkFrom, (IObjectPK)pkTo, (IObjectPK)companyPk);
        return periodColl;
    }

    public static PeriodCollection getCashGlPeriod(Context ctx, PeriodCollection cashPeriodColl, PeriodCollection glPeriodColl) throws EASBizException, BOSException {
        PeriodInfo cashPeriod = null;
        PeriodInfo glPeriod = null;
        PeriodCollection commonColl = new PeriodCollection();
        for (int i = 0; i < cashPeriodColl.size(); ++i) {
            cashPeriod = cashPeriodColl.get(i);
            for (int j = 0; j < glPeriodColl.size(); ++j) {
                glPeriod = glPeriodColl.get(j);
                if (!cashPeriod.equals((Object)glPeriod)) continue;
                commonColl.add(cashPeriod);
            }
        }
        return commonColl;
    }
}

