/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.DenominationCollection;
import com.kingdee.eas.basedata.assistant.DenominationFactory;
import com.kingdee.eas.basedata.assistant.DenominationInfo;
import com.kingdee.eas.basedata.assistant.IDenomination;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.CashCountCollection;
import com.kingdee.eas.fi.cas.CashCountEntryCollection;
import com.kingdee.eas.fi.cas.CashCountEntryInfo;
import com.kingdee.eas.fi.cas.CashCountException;
import com.kingdee.eas.fi.cas.CashCountFactory;
import com.kingdee.eas.fi.cas.CashCountInfo;
import com.kingdee.eas.fi.cas.ICashCount;
import com.kingdee.eas.fi.cas.app.AbstractCashCountBillWebFacadeControllerBean;
import com.kingdee.eas.fi.cas.basedata.CasUtilFacadeFactory;
import com.kingdee.eas.fi.cas.basedata.ICasUtilFacade;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class CashCountBillWebFacadeControllerBean
extends AbstractCashCountBillWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.CashCountBillWebFacadeControllerBean");

    @Override
    protected Map _initPageData(Context ctx, String companyId, String currencyId) throws BOSException, EASBizException {
        HashMap<String, Object> pageModel = new HashMap<String, Object>();
        try {
            if (this.isEmpty(companyId)) {
                ICasUtilFacade casUtil = CasUtilFacadeFactory.getLocalInstance(ctx);
                CompanyOrgUnitCollection orgUnitCollection = casUtil.getAuthrizedCompanyOrg(ctx.getCaller().toString(), "cas_cashcount_01view", false);
                if (orgUnitCollection.isEmpty()) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "NO_COMPANY_PERMISSION"));
                }
                companyId = orgUnitCollection.get(0).getId().toString();
            }
            String accountId = null;
            if (!this.isEmpty(companyId)) {
                CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                pageModel.put("company", companyInfo);
                AccountViewInfo accountViewInfo = this.getAccountViewByCompany(ctx, companyInfo);
                accountId = accountViewInfo.getId().toString();
                pageModel.put("accountViewInfo", accountViewInfo);
            }
            if (!this.isEmpty(currencyId)) {
                CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                pageModel.put("currency", currencyInfo);
                CashCountEntryCollection cashCountEntryCol = this.getDenominationByCurrency(ctx, currencyId);
                pageModel.put("cashCountEntry", (Object)cashCountEntryCol);
            }
            BigDecimal cashBookAmount = BigDecimal.ZERO;
            if (!(this.isEmpty(companyId) || this.isEmpty(currencyId) || this.isEmpty(accountId))) {
                cashBookAmount = CashCountFactory.getLocalInstance(ctx).getCashBookAmount((IObjectPK)new ObjectUuidPK(companyId), (IObjectPK)new ObjectUuidPK(accountId), (IObjectPK)new ObjectUuidPK(currencyId), new java.util.Date());
                pageModel.put("cashBookAmount", cashBookAmount);
            }
            pageModel.put("counter", ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
            pageModel.put("error", 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            pageModel.put("error", 1);
            pageModel.put("msg", e.getMessage());
        }
        return pageModel;
    }

    @Override
    protected Map _queryListPageData(Context ctx, String filter, String companyId, String currencyId) throws BOSException, EASBizException {
        HashMap<String, Object> pageModel = new HashMap<String, Object>();
        try {
            CashCountCollection cashCountCollection = CashCountFactory.getLocalInstance(ctx).getCashCountCollection(this.getQueryFilter(filter));
            ObjectUuidPK companyPK = null;
            ObjectUuidPK accountPK = null;
            ObjectUuidPK currencyPK = null;
            java.util.Date countedDate = null;
            Iterator iterator = cashCountCollection.iterator();
            while (iterator.hasNext()) {
                CashCountInfo cashCountInfo = (CashCountInfo)iterator.next();
                companyPK = new ObjectUuidPK(cashCountInfo.getCompany().getId());
                accountPK = new ObjectUuidPK(cashCountInfo.getAccount().getId());
                currencyPK = new ObjectUuidPK(cashCountInfo.getCurrency().getId());
                countedDate = cashCountInfo.getCountedDate();
                BigDecimal cashBookAmount = CashCountFactory.getLocalInstance(ctx).getCashBookAmount((IObjectPK)companyPK, (IObjectPK)accountPK, (IObjectPK)currencyPK, countedDate);
                cashCountInfo.put("cashBookAmount", cashBookAmount);
                cashCountInfo.put("gainorless", cashCountInfo.getSubTotal().subtract(cashBookAmount));
            }
            if (!this.isEmpty(companyId)) {
                CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(currencyId));
                pageModel.put("currencyId", companyOrgUnitInfo.getBaseCurrency().getId());
            }
            CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
            pageModel.put("pageListDatas", (Object)cashCountCollection);
            pageModel.put("precision", currencyInfo.getPrecision());
            pageModel.put("error", 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            pageModel.put("error", 1);
            pageModel.put("msg", e.getMessage());
        }
        return pageModel;
    }

    @Override
    protected Map _getDenomiAndCashBookAmount(Context ctx, String companyId, String accountId, String currencyId, String bizDate, String currentModelId) throws BOSException, EASBizException {
        HashMap<String, Object> pageModel = new HashMap<String, Object>();
        try {
            this.checkCashCount(ctx, companyId, accountId, currencyId, Date.valueOf(bizDate), currentModelId);
            CashCountEntryCollection countEntryCollection = this.getDenominationByCurrency(ctx, currencyId);
            pageModel.put("cashCountEntry", (Object)countEntryCollection);
            BigDecimal cashBookAmount = BigDecimal.ZERO;
            if (!(StringUtils.isEmpty((String)companyId) || StringUtils.isEmpty((String)accountId) || StringUtils.isEmpty((String)currencyId) || bizDate == null)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                java.util.Date date = null;
                date = sdf.parse(bizDate);
                cashBookAmount = CashCountFactory.getLocalInstance(ctx).getCashBookAmount((IObjectPK)new ObjectUuidPK(companyId), (IObjectPK)new ObjectUuidPK(accountId), (IObjectPK)new ObjectUuidPK(currencyId), date);
            }
            pageModel.put("cashBookAmount", cashBookAmount);
            CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
            pageModel.put("precision", currencyInfo.getPrecision());
            pageModel.put("error", 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            pageModel.put("error", 1);
            pageModel.put("msg", e.getMessage());
        }
        return pageModel;
    }

    @Override
    protected Map _getCashBookAmount(Context ctx, String companyId, String accountId, String currencyId, String countedDate) throws BOSException {
        HashMap<String, Object> pageModel = new HashMap<String, Object>();
        try {
            BigDecimal cashBookAmount = BigDecimal.ZERO;
            if (!(StringUtils.isEmpty((String)companyId) || StringUtils.isEmpty((String)accountId) || StringUtils.isEmpty((String)currencyId) || countedDate == null)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                java.util.Date date = null;
                try {
                    date = sdf.parse(countedDate);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                cashBookAmount = CashCountFactory.getLocalInstance(ctx).getCashBookAmount((IObjectPK)new ObjectUuidPK(companyId), (IObjectPK)new ObjectUuidPK(accountId), (IObjectPK)new ObjectUuidPK(currencyId), date);
            }
            pageModel.put("cashBookAmount", cashBookAmount);
            pageModel.put("error", 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            pageModel.put("error", 1);
            pageModel.put("msg", e.getMessage());
        }
        return pageModel;
    }

    private CashCountEntryCollection getDenominationByCurrency(Context ctx, String currencyId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("currency", (Object)currencyId));
        filter.getFilterItems().add(new FilterItemInfo("isForbidden", (Object)"0"));
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.setFilter(filter);
        SorterItemInfo sorterItemInfo = new SorterItemInfo("coefficient");
        sorterItemInfo.setSortType(SortType.DESCEND);
        entityView.getSorter().add(sorterItemInfo);
        IDenomination iDenomination = DenominationFactory.getLocalInstance((Context)ctx);
        DenominationCollection denominationColl = iDenomination.getDenominationCollection(entityView);
        CashCountEntryCollection cashCountEntryCol = new CashCountEntryCollection();
        for (DenominationInfo denomination : denominationColl) {
            CashCountEntryInfo cashCountEntryInfo = new CashCountEntryInfo();
            cashCountEntryInfo.setDenominator(denomination);
            cashCountEntryCol.add(cashCountEntryInfo);
        }
        return cashCountEntryCol;
    }

    private void checkCashCount(Context ctx, String companyId, String accountId, String currencyId, java.util.Date countedDate, String currentModelId) throws BOSException, EASBizException {
        long lCountTimeMillis = countedDate.getTime();
        long lDayMillis = 86400000L;
        Date countNxtDate = new Date(lCountTimeMillis + lDayMillis);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("company.id", (Object)companyId));
        items.add(new FilterItemInfo("account.id", (Object)accountId));
        items.add(new FilterItemInfo("currency.id", (Object)currencyId));
        items.add(new FilterItemInfo("counteddate", (Object)countedDate.toString(), CompareType.GREATER_EQUALS));
        items.add(new FilterItemInfo("counteddate", (Object)countNxtDate.toString(), CompareType.LESS));
        view.setFilter(filter);
        Object savedInfo = null;
        CashCountCollection cashCountCollection = CashCountFactory.getLocalInstance(ctx).getCashCountCollection(view);
        if (cashCountCollection.size() >= 1 && currentModelId != null && !cashCountCollection.get(0).getId().toString().equals(currentModelId)) {
            throw new CashCountException(CashCountException.CASHCOUNT_CURR_ACCT_PERDAY);
        }
        if (cashCountCollection.size() >= 1 && currentModelId == null) {
            throw new CashCountException(CashCountException.CASHCOUNT_CURR_ACCT_PERDAY);
        }
    }

    private AccountViewInfo getAccountViewByCompany(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        AccountViewInfo accountViewInfo = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("isCash", (Object)"1"));
        items.add(new FilterItemInfo("isLeaf", (Object)"1"));
        items.add(new FilterItemInfo("isCFreeze", (Object)"0"));
        items.add(new FilterItemInfo("isGFreeze", (Object)"0"));
        items.add(new FilterItemInfo("CompanyID.id", (Object)companyInfo.getId()));
        if (companyInfo.getId() == null) {
            return null;
        }
        AccountViewCollection accounts = null;
        IAccountView iAccountView = AccountViewFactory.getLocalInstance((Context)ctx);
        evi.setFilter(filter);
        String cuId = companyInfo.getCU().getId().toString();
        if (cuId == null) {
            cuId = ctx == null ? SysContext.getSysContext().getCurrentCtrlUnit().getId().toString() : ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        }
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)cuId));
        if (filter != null && filter.getFilterItems().size() > 0 && filter.getMaskString() != null && !filter.getMaskString().equals("")) {
            filter.mergeFilter(filter, "and");
        }
        evi.getSorter().add(new SorterItemInfo("number"));
        try {
            accounts = iAccountView.getAccountViewCollection(evi);
        }
        catch (Exception err) {
            throw new BOSException((Throwable)err);
        }
        if (accounts != null && !accounts.isEmpty()) {
            accountViewInfo = accounts.get(0);
        }
        return accountViewInfo;
    }

    private EntityViewInfo getQueryFilter(String filter) throws ParserException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("company.name"));
        selector.add(new SelectorItemInfo("countedDate"));
        selector.add(new SelectorItemInfo("account.name"));
        selector.add(new SelectorItemInfo("account.number"));
        selector.add(new SelectorItemInfo("counter.name"));
        selector.add(new SelectorItemInfo("subTotal"));
        selector.add(new SelectorItemInfo("currency.name"));
        selector.add(new SelectorItemInfo("comment"));
        viewInfo.setSelector(selector);
        return viewInfo;
    }

    private void getSelectors(SelectorItemCollection selectors) {
        selectors.add(new SelectorItemInfo("*"));
        selectors.add(new SelectorItemInfo("countedDate"));
        selectors.add(new SelectorItemInfo("company.id"));
        selectors.add(new SelectorItemInfo("company.name"));
        selectors.add(new SelectorItemInfo("company.number"));
        selectors.add(new SelectorItemInfo("account.id"));
        selectors.add(new SelectorItemInfo("account.number"));
        selectors.add(new SelectorItemInfo("account.name"));
        selectors.add(new SelectorItemInfo("account.currencyID"));
        selectors.add(new SelectorItemInfo("currency.id"));
        selectors.add(new SelectorItemInfo("currency.name"));
        selectors.add(new SelectorItemInfo("counter.name"));
        selectors.add(new SelectorItemInfo("counter.number"));
        selectors.add(new SelectorItemInfo("entries.hundreds"));
        selectors.add(new SelectorItemInfo("entries.twenties"));
        selectors.add(new SelectorItemInfo("entries.Mantissa"));
        selectors.add(new SelectorItemInfo("entries.subTotal"));
        selectors.add(new SelectorItemInfo("entries.denominator.id"));
        selectors.add(new SelectorItemInfo("entries.denominator.value"));
        selectors.add(new SelectorItemInfo("entries.denominator.coefficient"));
    }

    private boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    @Override
    protected Map _saveCashCount(Context ctx, CashCountInfo info) throws BOSException, EASBizException {
        HashMap<String, Object> pageModel = new HashMap<String, Object>();
        try {
            CashCountEntryCollection entryCollection = info.getEntries();
            if (!entryCollection.isEmpty()) {
                Iterator iterator = entryCollection.iterator();
                while (iterator.hasNext()) {
                    CashCountEntryInfo item = (CashCountEntryInfo)iterator.next();
                    if (item.getHundreds() == 0) {
                        item.setHundreds(0);
                    }
                    if (item.getMantissa() == 0) {
                        item.setMantissa(0);
                    }
                    if (item.getTwenties() != 0) continue;
                    item.setTwenties(0);
                }
            }
            ICashCount instance = CashCountFactory.getLocalInstance(ctx);
            boolean exists = instance.exists((IObjectPK)new ObjectUuidPK(info.getId().toString()));
            IObjectPK iObjectPK = null;
            if (!exists) {
                iObjectPK = CashCountFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)info);
            } else {
                CashCountFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId().toString()), (CoreBaseInfo)info);
                iObjectPK = new ObjectUuidPK(info.getId().toString());
            }
            pageModel.put("error", 0);
            pageModel.put("id", iObjectPK.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            pageModel.put("error", 1);
            pageModel.put("msg", e.getMessage());
        }
        return pageModel;
    }

    @Override
    protected Map _getPrevCashCountInfo(Context ctx, String companyId, String accountId, String currencyId, String countedDate) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("company", (Object)companyId));
        items.add(new FilterItemInfo("currency", (Object)currencyId));
        items.add(new FilterItemInfo("account", (Object)accountId));
        items.add(new FilterItemInfo("counteddate", (Object)countedDate, CompareType.LESS));
        view.setFilter(filter);
        view.setTopCount(1);
        SorterItemInfo sorter = new SorterItemInfo("counteddate");
        sorter.setSortType(SortType.DESCEND);
        view.getSorter().add(sorter);
        SelectorItemCollection selectors = view.getSelector();
        this.getSelectors(selectors);
        HashMap<String, Object> pageModel = new HashMap<String, Object>();
        CashCountInfo countInfo = null;
        try {
            ICashCount iCashCount = CashCountFactory.getLocalInstance(ctx);
            CashCountCollection coll = iCashCount.getCashCountCollection(view);
            if (!coll.isEmpty()) {
                countInfo = coll.get(0);
                countInfo.setId(BOSUuid.create((BOSObjectType)countInfo.getBOSType()));
                countInfo.setCountedDate(new java.util.Date());
                if (null != countInfo.getEntries() && countInfo.getEntries().size() > 0) {
                    for (int i = 0; i < countInfo.getEntries().size() - 1; ++i) {
                        BOSObjectType bosType = countInfo.getEntries().get(i).getBOSType();
                        countInfo.getEntries().get(i).setId(BOSUuid.create((BOSObjectType)bosType));
                    }
                }
            }
            pageModel.put("prevCashCount", countInfo);
            pageModel.put("error", 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            pageModel.put("error", 1);
            pageModel.put("msg", e.getMessage());
        }
        return pageModel;
    }

    @Override
    protected Map _batchDelete(Context ctx, String[] ids) throws BOSException, EASBizException {
        ICashCount cashCount = CashCountFactory.getLocalInstance(ctx);
        com.kingdee.eas.fi.cas.model.BatchExecuteResult execResult = new com.kingdee.eas.fi.cas.model.BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = 0;
        try {
            BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                BatchExecuteParamsEntry entry;
                if (ids[i] == null) continue;
                ObjectStringPK pk = new ObjectStringPK(ids[i].toString());
                paramEntries[i] = entry = new BatchExecuteParamsEntry(new Class[]{IObjectPK.class}, new Object[]{pk});
            }
            BatchExecuteResult result = cashCount.batchExecute("delete", new Class[]{IObjectPK.class}, paramEntries);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("countedDate"));
            sic.add(new SelectorItemInfo("company.name"));
            if (result.getExceptions() != null) {
                for (int i = 0; i < result.getExceptions().length; ++i) {
                    if (result.getExceptions()[i] != null) {
                        CashCountInfo info = cashCount.getCashCountInfo((IObjectPK)new ObjectUuidPK(ids[i]), sic);
                        execResult.getDetailMsgList().add(CASWebUtil.getResource(ctx, "CASHCOUNT_DELETE_FAIL", new String[]{info.getCompany().getName(), info.getCountedDate().toString(), result.getExceptions()[i].getMessage()}));
                        continue;
                    }
                    ++success;
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "ALL_DELETE_SUCCESS") : summary + CASWebUtil.getResource(ctx, "DELETE_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        execResult.setSummaryMsg(summary);
        return execResult;
    }

    @Override
    protected Map _copyCashCount(Context ctx, String modelId) throws BOSException, EASBizException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        this.getSelectors(selectors);
        HashMap<String, Object> pageModel = new HashMap<String, Object>();
        CashCountInfo cashCountInfo = null;
        try {
            cashCountInfo = CashCountFactory.getLocalInstance(ctx).getCashCountInfo((IObjectPK)new ObjectUuidPK(modelId), selectors);
            if (cashCountInfo != null) {
                cashCountInfo.setId(BOSUuid.create((BOSObjectType)cashCountInfo.getBOSType()));
                cashCountInfo.setCountedDate(new java.util.Date());
                if (null != cashCountInfo.getEntries() && cashCountInfo.getEntries().size() > 0) {
                    for (int i = 0; i < cashCountInfo.getEntries().size() - 1; ++i) {
                        BOSObjectType bosType = cashCountInfo.getEntries().get(i).getBOSType();
                        cashCountInfo.getEntries().get(i).setId(BOSUuid.create((BOSObjectType)bosType));
                    }
                }
            }
            ObjectUuidPK companyPK = new ObjectUuidPK(cashCountInfo.getCompany().getId());
            ObjectUuidPK accountPK = new ObjectUuidPK(cashCountInfo.getAccount().getId());
            ObjectUuidPK currencyPK = new ObjectUuidPK(cashCountInfo.getCurrency().getId());
            java.util.Date countedDate = cashCountInfo.getCountedDate();
            BigDecimal cashBookAmount = CashCountFactory.getLocalInstance(ctx).getCashBookAmount((IObjectPK)companyPK, (IObjectPK)accountPK, (IObjectPK)currencyPK, countedDate);
            cashCountInfo.put("cashBookAmount", cashBookAmount);
            cashCountInfo.put("gainorless", cashCountInfo.getSubTotal().subtract(cashBookAmount));
            pageModel.put("copyCashCount", cashCountInfo);
            pageModel.put("copy", true);
            pageModel.put("error", 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            pageModel.put("error", 1);
            pageModel.put("msg", e.getMessage());
        }
        return pageModel;
    }
}

