/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CashCountCollection;
import com.kingdee.eas.fi.cas.CashCountException;
import com.kingdee.eas.fi.cas.CashCountInfo;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fi.cas.app.AbstractCashCountControllerBean;
import com.kingdee.eas.framework.SystemEnum;
import java.math.BigDecimal;
import java.sql.Date;
import org.apache.log4j.Logger;

public class CashCountControllerBean
extends AbstractCashCountControllerBean {
    private static Logger logger = Logger.getLogger(CashCountControllerBean.class);

    private void canAdd(Context ctx, CashCountInfo countInfo) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = countInfo.getCompany();
        java.util.Date countedDate = countInfo.getCountedDate();
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (currPeriod != null && countedDate.before(currPeriod.getBeginDate())) {
            throw new CashCountException(CashCountException.CANNOT_ADD_PREPREIOD_COUNT);
        }
    }

    private void validate(CashCountInfo model) throws EASBizException {
        if (model.getCompany() == null || model.getAccount() == null || model.getCurrency() == null) {
            throw new CashCountException(CashCountException.KEYFIELDS_NULL);
        }
    }

    private void checkCashCount(Context ctx, CashCountInfo model) throws BOSException, EASBizException {
        long lCountTimeMillis = model.getCountedDate().getTime();
        long lDayMillis = 86400000L;
        Date countDate = new Date(model.getCountedDate().getTime());
        Date countNxtDate = new Date(lCountTimeMillis + lDayMillis);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("company.id", (Object)model.getCompany().getId().toString()));
        items.add(new FilterItemInfo("account.id", (Object)model.getAccount().getId().toString()));
        items.add(new FilterItemInfo("currency.id", (Object)model.getCurrency().getId().toString()));
        items.add(new FilterItemInfo("counteddate", (Object)countDate.toString(), CompareType.GREATER_EQUALS));
        items.add(new FilterItemInfo("counteddate", (Object)countNxtDate.toString(), CompareType.LESS));
        view.setFilter(filter);
        Object savedInfo = null;
        CashCountCollection cashCountCollection = this.getCashCountCollection(ctx, view);
        if (cashCountCollection.size() >= 1 && model.getId() != null && !cashCountCollection.get(0).getId().toString().equals(model.getId().toString())) {
            throw new CashCountException(CashCountException.CASHCOUNT_CURR_ACCT_PERDAY);
        }
        if (cashCountCollection.size() >= 1 && model.getId() == null) {
            throw new CashCountException(CashCountException.CASHCOUNT_CURR_ACCT_PERDAY);
        }
    }

    private void canUpdateDelete(Context ctx, CashCountInfo countInfo) throws BOSException, EASBizException {
        java.util.Date countedDate = countInfo.getCountedDate();
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)countInfo.getCompany());
        if (currPeriod != null && countedDate.before(currPeriod.getBeginDate())) {
            throw new CashCountException(CashCountException.PREV_PERIOD_COUNT_READONLY);
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CashCountInfo info = (CashCountInfo)model;
        this.validate(info);
        this.canAdd(ctx, info);
        this.checkCashCount(ctx, (CashCountInfo)model);
        return super._addnew(ctx, model);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CashCountInfo info = (CashCountInfo)model;
        this.validate(info);
        this.canAdd(ctx, info);
        this.checkCashCount(ctx, (CashCountInfo)model);
        super._addnew(ctx, pk, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CashCountInfo info = (CashCountInfo)model;
        this.validate(info);
        this.canUpdateDelete(ctx, info);
        this.checkCashCount(ctx, info);
        super._update(ctx, pk, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CashCountInfo countInfo = this.getCashCountInfo(ctx, pk);
        this.canUpdateDelete(ctx, countInfo);
        super._delete(ctx, pk);
    }

    @Override
    protected BigDecimal _getCashBookAmount(Context ctx, IObjectPK companyPK, IObjectPK accountPK, IObjectPK currencyPK, java.util.Date bizDate) throws BOSException, EASBizException {
        return CashManagementFactory.getLocalInstance(ctx).getCashData(companyPK.toString(), accountPK.toString(), currencyPK.toString(), bizDate, bizDate, CashDataTypeEnum.Y, false);
    }
}

