/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AbstractFMDataImport;
import com.kingdee.eas.fi.cas.AccountTypeEnum;
import com.kingdee.eas.fi.cas.IJournal;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Locale;

public class CashJournalDataImport
extends AbstractFMDataImport {
    private BigDecimal zero = FMConstants.ZERO;
    private int lineNumber = 0;

    @Override
    protected ICoreBase _getController(Context ctx) throws EASBizException, BOSException {
        return JournalFactory.getLocalInstance(ctx);
    }

    @Override
    protected void _submit(CoreBaseInfo info, Context ctx) throws BOSException, EASBizException {
        IJournal j = (IJournal)this._getController(ctx);
        j.importFromDS((JournalInfo)info);
    }

    @Override
    protected String getTemplateNumber() {
        return "CasJournal";
    }

    @Override
    protected CoreBaseInfo _transmit(Hashtable hsData, Context ctx) throws EASBizException, BOSException {
        JournalInfo journal = new JournalInfo();
        this.prepareImport(ctx, (IObjectValue)journal, hsData);
        journal.setLineNo(this.lineNumber++);
        if (journal.getCurrency() == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"77_CashJournalDataImport", (Locale)ctx.getLocale()));
        }
        CompanyOrgUnitInfo company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        String acctTableId = company.getAccountTable().getId().toString();
        AccountViewCollection accountCol = FMHelper.getAcctViewCollection((Context)ctx, (String)company.getId().toString(), (String)acctTableId, (String)journal.getCurrency().getId().toString(), (AccountTypeEnum)AccountTypeEnum.CASHACCOUNT);
        int size = accountCol.size();
        Object data = ((DataToken)hsData.get((Object)"accountView")).data;
        for (int i = 0; i < size; ++i) {
            if (!accountCol.get(i).getNumber().equals((String)data)) continue;
            journal.setAccountView(accountCol.get(i));
            break;
        }
        journal.setCashier(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        journal.setCompany(company);
        journal.setSource(JournalSourceEnum.BYIMPORT);
        if (journal.getDebitAmount() == null) {
            journal.setDebitAmount(FMConstants.ZERO);
        }
        if (journal.getCreditAmount() == null) {
            journal.setCreditAmount(FMConstants.ZERO);
        }
        if (this.zero.compareTo(journal.getDebitAmount()) != 0 && this.zero.compareTo(journal.getCreditAmount()) != 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"78_CashJournalDataImport", (Locale)ctx.getLocale()));
        }
        if (this.zero.compareTo(journal.getDebitAmount()) == 0 && this.zero.compareTo(journal.getCreditAmount()) == 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"79_CashJournalDataImport", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "description");
        if (data != null && data.toString().trim().length() > 0) {
            if (data.toString().length() > 255) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"54_BankJournalDataImport", (Locale)ctx.getLocale()) + 255);
            }
            journal.setDescription(data.toString());
        }
        return journal;
    }
}

