/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountRefContrastCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.IAccountRefContrast;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.app.AbstractCashJournalFetchParamFacadeControllerBean;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.util.FetchParamHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class CashJournalFetchParamFacadeControllerBean
extends AbstractCashJournalFetchParamFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.CashJournalFetchParamFacadeControllerBean");
    private CompanyOrgUnitInfo company;

    @Override
    protected Map _fetchParam(Context ctx, Map paramMap) throws BOSException, EASBizException {
        FetchParamHelper fph = new FetchParamHelper(ctx);
        this.company = fph.getCurrentComapny();
        if (this.company.getAccountTable() == null) {
            throw new FMException(FMException.HASNOACCTTABLE, new Object[]{this.company.getName()});
        }
        AccountTableInfo acctTable = AccountTableFactory.getLocalInstance((Context)ctx).getAccountTableInfo((IObjectPK)new ObjectUuidPK(this.company.getAccountTable().getId()));
        paramMap.put("acctTable", acctTable);
        paramMap.put("currentCompany", this.company);
        paramMap.put("currentPeriod", fph.getCurrentPeriod());
        paramMap.put("currencyCollection", fph.getCurrenyCol());
        paramMap.put("bookType", Integer.valueOf(fph.getParamValue_StringType("CS001")));
        paramMap.put("startPeriod", fph.getStartPeriod());
        paramMap.put("CS003", fph.getParamValue_StringType("CS003"));
        String STRING_ONE = "1";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("isLeaf", (Object)STRING_ONE));
        items.add(new FilterItemInfo("isCash", (Object)STRING_ONE));
        AccountViewCollection accountCol = FMHelper.getAccountViewCollection((Context)ctx, (String)this.company.getId().toString(), (String)acctTable.getId().toString(), null, (EntityViewInfo)view);
        for (int i = 0; i < accountCol.size(); ++i) {
            accountCol.get(i).setDisplayFormat("$number$ - $name$");
        }
        paramMap.put("accountViews", accountCol);
        paramMap.put("isStart", SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.company));
        boolean isShowLocalCurrency = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS003", (IObjectPK)new ObjectUuidPK(this.company.getId()));
        paramMap.put("isShowLocalCurrency", isShowLocalCurrency);
        String queryName = (String)paramMap.get("mainQueryPK");
        String uiClassName = (String)paramMap.get("uiClassName");
        paramMap.put("DefaultSolution", QuerySolutionFacadeFactory.getLocalInstance((Context)ctx).getDefaultSolution(uiClassName, queryName));
        return paramMap;
    }

    @Override
    protected Map _fetchParamForFilterUI(Context ctx, Map paramMap) throws BOSException, EASBizException {
        FetchParamHelper fph = new FetchParamHelper(ctx);
        this.company = fph.getCurrentComapny();
        paramMap.put("actualAcctTableId", this.getActualAcctTableId(ctx, paramMap));
        return paramMap;
    }

    private String getActualAcctTableId(Context ctx, Map verifyMap) throws BOSException, EASBizException {
        String actualAcctTableId = "";
        int beginYear = (Integer)verifyMap.get("beginYear");
        int beginPeriod = (Integer)verifyMap.get("beginPeriod");
        int endYear = (Integer)verifyMap.get("endYear");
        int endPeriod = (Integer)verifyMap.get("endPeriod");
        Date beginDate = (Date)verifyMap.get("dateFrom");
        Date endDate = (Date)verifyMap.get("dateTo");
        actualAcctTableId = (Boolean)verifyMap.get("btnByPeriod") != false ? this.getActualAcctTable(ctx, this.company, beginYear, beginPeriod, endYear, endPeriod) : this.getActualAcctTable(ctx, this.company, beginDate, endDate);
        PeriodCollection col = PeriodUtils.getPeriodc((Context)ctx, (int)beginYear, (int)beginPeriod, (CompanyOrgUnitInfo)this.company);
        if (col.size() > 0) {
            verifyMap.put("beginPeriodParam", col.get(0));
        }
        if ((col = PeriodUtils.getPeriodc((Context)ctx, (int)endYear, (int)endPeriod, (CompanyOrgUnitInfo)this.company)).size() > 0) {
            verifyMap.put("endPeriodParam", col.get(0));
        }
        return actualAcctTableId;
    }

    private String getActualAcctTable(Context ctx, CompanyOrgUnitInfo company, int beginYear, int beginPeriod, int endYear, int endPeriod) throws EASBizException, BOSException {
        PeriodInfo beginPeriodInfo = this.getPeriodInfo(ctx, beginYear, beginPeriod, company);
        PeriodInfo endPeriodInfo = this.getPeriodInfo(ctx, endYear, endPeriod, company);
        return this.getActualAcctTable(ctx, company, beginPeriodInfo.getBeginDate(), endPeriodInfo.getEndDate());
    }

    private PeriodInfo getPeriodInfo(Context ctx, int periodYear, int periodNumber, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        PeriodInfo info = null;
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(periodYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)new Integer(periodNumber), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            info = periodc.get(0);
        }
        return info;
    }

    private String getActualAcctTable(Context ctx, CompanyOrgUnitInfo companyInfo, Date beginDate, Date endDate) throws BOSException, EASBizException {
        String cuId = companyInfo.getCU().getId().toString();
        AccountRefContrastCollection coll = this.getStrideAcctRefContrastColl(ctx, cuId, beginDate, endDate);
        if (coll == null || coll.isEmpty()) {
            PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)endDate, (CompanyOrgUnitInfo)companyInfo);
            if (period == null) {
                throw new CasException(CasException.PERIODERROR, new Object[]{DateHelper.DateToString((Date)endDate)});
            }
            int yearNumber = period.getPeriodYear();
            int monthNumber = period.getPeriodNumber();
            try {
                AccountTableInfo tbl = companyInfo.getAccountTable();
                String currTableId = AccountTools.getCurrentAcctTable((Context)ctx, (String)cuId, (String)tbl.getId().toString(), (int)yearNumber, (int)monthNumber);
                return currTableId;
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                throw new FMException(FMException.HASCOMPANYADJUSTACCT);
            }
        }
        return null;
    }

    private AccountRefContrastCollection getStrideAcctRefContrastColl(Context ctx, String cuId, Date beginDate, Date endDate) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cuId));
        filter.getFilterItems().add(new FilterItemInfo("enabledPeriod.endDate", (Object)DateTimeUtils.truncateDate((Date)beginDate), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("enabledPeriod.endDate", (Object)DateTimeUtils.truncateDate((Date)endDate), CompareType.LESS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IAccountRefContrast acctContrast = AccountRefContrastFactory.getLocalInstance((Context)ctx);
        AccountRefContrastCollection coll = acctContrast.getAccountRefContrastCollection(evi);
        return coll;
    }

    @Override
    protected Map _fetchParamForFilterUIVerify(Context ctx, Map verifyMap) throws BOSException, EASBizException {
        FetchParamHelper fph = new FetchParamHelper(ctx);
        this.company = fph.getCurrentComapny();
        verifyMap.put("actualAcctTableId", this.getActualAcctTableId(ctx, verifyMap));
        return verifyMap;
    }
}

