/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CashDataSourceEnum;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fi.cas.app.AbstractCashJournalWebFacadeControllerBean;
import com.kingdee.eas.fi.cas.utils.BankJournalWebUtil;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.utils.CashJournalWebUtil;
import com.kingdee.eas.fi.cas.utils.JournalWebUtil;
import com.kingdee.eas.fi.cas.web.param.BsfBatchProcessResult;
import com.kingdee.eas.fi.cas.web.param.CashJournalWebFilterParam;
import com.kingdee.eas.fi.cas.web.param.DeleteCashJouranlParam;
import com.kingdee.eas.fi.cas.web.param.QueryTable;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CashJournalWebFacadeControllerBean
extends AbstractCashJournalWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.CashJournalWebFacadeControllerBean");

    @Override
    protected Object _saveFromJsonStr(Context ctx, String jsonStr) throws BOSException, EASBizException {
        JournalInfo info = null;
        info = (JournalInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonStr, JournalInfo.class);
        if (info.getId() == null) {
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        }
        JournalFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
        if (info.isIsDebit()) {
            info.setCreditAmount(null);
        } else {
            info.setDebitAmount(null);
        }
        return info;
    }

    @Override
    protected Object _saveFromJsonListStr(Context ctx, String jsonListStr) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected String _deleteFromIdStr(Context ctx, String idStr) throws BOSException, EASBizException {
        if (idStr != null) {
            ObjectUuidPK objPk = new ObjectUuidPK(idStr);
            JournalInfo info = null;
            try {
                info = JournalFactory.getLocalInstance(ctx).getJournalInfo((IObjectPK)objPk);
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
            if (info != null) {
                JournalFactory.getLocalInstance(ctx).delete((IObjectPK)objPk);
            }
        }
        return idStr;
    }

    @Override
    protected Object _updateFromJsonStr(Context ctx, String jsonStr) throws BOSException, EASBizException {
        JournalInfo info = null;
        JournalInfo existObj = null;
        info = (JournalInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonStr, JournalInfo.class);
        if (info != null && info.getId() != null) {
            JournalWebUtil.verifyRate(ctx, info);
            try {
                existObj = JournalFactory.getLocalInstance(ctx).getJournalInfo((IObjectPK)new ObjectUuidPK(info.getId()));
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
            if (existObj != null) {
                JournalFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
                if (info.isIsDebit()) {
                    info.setCreditAmount(null);
                } else {
                    info.setDebitAmount(null);
                }
            }
        }
        return info;
    }

    @Override
    protected JournalInfo _getJournalInfoById(Context ctx, String idStr) throws BOSException, EASBizException {
        JournalInfo info = null;
        if (idStr != null) {
            try {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("company.id"));
                sic.add(new SelectorItemInfo("company.name"));
                sic.add(new SelectorItemInfo("company.number"));
                sic.add(new SelectorItemInfo("company.baseCurrency.id"));
                sic.add(new SelectorItemInfo("company.baseCurrency.name"));
                sic.add(new SelectorItemInfo("company.baseCurrency.number"));
                sic.add(new SelectorItemInfo("company.baseExchangeTable.id"));
                sic.add(new SelectorItemInfo("company.CU.id"));
                sic.add(new SelectorItemInfo("company.CU.name"));
                sic.add(new SelectorItemInfo("company.CU.number"));
                sic.add(new SelectorItemInfo("company.accountTable.id"));
                sic.add(new SelectorItemInfo("company.accountTable.name"));
                sic.add(new SelectorItemInfo("company.accountTable.number"));
                sic.add(new SelectorItemInfo("accountBank.id"));
                sic.add(new SelectorItemInfo("accountBank.name"));
                sic.add(new SelectorItemInfo("accountBank.number"));
                sic.add(new SelectorItemInfo("currency.id"));
                sic.add(new SelectorItemInfo("currency.name"));
                sic.add(new SelectorItemInfo("currency.number"));
                sic.add(new SelectorItemInfo("currency.precision"));
                sic.add(new SelectorItemInfo("oppAccountView.id"));
                sic.add(new SelectorItemInfo("oppAccountView.name"));
                sic.add(new SelectorItemInfo("oppAccountView.number"));
                sic.add(new SelectorItemInfo("voucherType.id"));
                sic.add(new SelectorItemInfo("voucherType.name"));
                sic.add(new SelectorItemInfo("voucherType.number"));
                sic.add(new SelectorItemInfo("settlementType.id"));
                sic.add(new SelectorItemInfo("settlementType.name"));
                sic.add(new SelectorItemInfo("settlementType.number"));
                sic.add(new SelectorItemInfo("accountView.id"));
                sic.add(new SelectorItemInfo("accountView.name"));
                sic.add(new SelectorItemInfo("accountView.number"));
                sic.add(new SelectorItemInfo("accountView.isCFreeze"));
                sic.add(new SelectorItemInfo("accountView.isGFreeze"));
                sic.add(new SelectorItemInfo("period.*"));
                info = JournalFactory.getLocalInstance(ctx).getJournalInfo((IObjectPK)new ObjectUuidPK(idStr), sic);
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
        }
        return info;
    }

    @Override
    protected QueryTable _getCashJouranlList(Context ctx, CashJournalWebFilterParam filterParam) throws BOSException, EASBizException {
        filterParam.setDataSourceType(CashDataSourceEnum.C);
        QueryTable queryTable = new QueryTable();
        try {
            String toDateStr;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String fromDateStr = filterParam.getFromDateStr();
            if (fromDateStr != null) {
                filterParam.setFromDate(simpleDateFormat.parse(fromDateStr));
            }
            if ((toDateStr = filterParam.getToDateStr()) != null) {
                filterParam.setToDate(simpleDateFormat.parse(toDateStr));
            }
            CashJournalWebUtil.fetchJournalData(ctx, filterParam, queryTable);
        }
        catch (Exception e) {
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
            throw new BOSException((Throwable)e);
        }
        return queryTable;
    }

    @Override
    protected void _deleteJournalById(Context ctx, String idStr) throws BOSException, EASBizException {
    }

    @Override
    protected void _deleteJournalByParam(Context ctx, DeleteCashJouranlParam param) throws BOSException, EASBizException {
        if (param != null && param.getId() != null) {
            JournalSourceEnum source = JournalSourceEnum.getEnum((int)param.getSource());
            if (source == JournalSourceEnum.BYBILL || source == JournalSourceEnum.BYVOUCHER) {
                throw new BOSException(EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CheckoutResource", (String)"BillOrVoucherBook", (Locale)ctx.getLocale()));
            }
            PeriodInfo currPeriodInfo = CashJournalWebUtil.getCurrentPeriod(ctx, SystemEnum.CASHMANAGEMENT, param.getCompanyId());
            int currYear = currPeriodInfo.getPeriodYear();
            int currPeriodNumber = currPeriodInfo.getPeriodNumber();
            Integer year = param.getPeriodYear();
            Integer period = param.getPeriodNumber();
            if (year < currYear || year == currYear && period < currPeriodNumber) {
                throw new BOSException(EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CheckoutResource", (String)"CheckOut_No_Delete", (Locale)ctx.getLocale()));
            }
            JournalWebUtil.isReferenced(ctx, param.getId());
            JournalFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(param.getId()));
        }
    }

    @Override
    protected JournalInfo _createCashJournalInfo(Context ctx, String companyId, String accountViewId, String currencyId) throws BOSException, EASBizException {
        JournalInfo journal = new JournalInfo();
        journal.setId(BOSUuid.create((BOSObjectType)journal.getBOSType()));
        journal.setHasEffected(true);
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        PeriodInfo casPeriod = CashJournalWebUtil.getCurrentPeriod(ctx, SystemEnum.CASHMANAGEMENT, companyId);
        AccountViewInfo accountViewInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountViewId));
        CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
        Date date = new Date();
        if (date.before(casPeriod.getBeginDate())) {
            date = casPeriod.getBeginDate();
        }
        if (date.after(casPeriod.getEndDate())) {
            date = casPeriod.getEndDate();
        }
        journal.setBizDate(date);
        journal.setCreateDate(date);
        journal.setPeriod(casPeriod);
        UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserByID(ctx.getCaller());
        journal.setCashier(user);
        journal.setVerifyStatus(VerifyScopeEnum.NOVA);
        journal.setSource(JournalSourceEnum.BYHAND);
        journal.setCurrency(company.getBaseCurrency());
        journal.setType(JournalTypeEnum.CASH);
        journal.setCurrency(currencyInfo);
        journal.setAccountView(accountViewInfo);
        journal.setCompany(company);
        return journal;
    }

    @Override
    protected Map _getCashJournalUIDefaultValue(Context ctx) throws BOSException, EASBizException {
        HashMap<String, Object> defaultValueMap = new HashMap<String, Object>();
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        PeriodInfo startPeriod = null;
        AccountViewInfo accountViewInfo = null;
        CompanyOrgUnitCollection fiOrgColls = CASWebHelper.getAuthorizedOrgCollection(ctx, "cas_cashbook_01view", false);
        HashSet<String> idSet = new HashSet<String>();
        for (int idx = 0; idx < fiOrgColls.size(); ++idx) {
            CompanyOrgUnitInfo fiOrgUnit = fiOrgColls.get(idx);
            if (fiOrgUnit == null || fiOrgUnit.getId() == null) continue;
            idSet.add(fiOrgUnit.getId().toString());
        }
        ArrayList companyIdList = new ArrayList(idSet);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("baseCurrency.*"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("accountTable.name"));
        sic.add(new SelectorItemInfo("accountTable.number"));
        if (companyIdList != null && companyIdList.size() != 0 && companyIdList.contains(companyInfo.getId().toString())) {
            companyIdList.remove(companyInfo.getId().toString());
            companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId().toString()), sic);
            startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        }
        if (startPeriod == null && fiOrgColls != null && fiOrgColls.size() > 0) {
            for (int i = 0; i < fiOrgColls.size(); ++i) {
                companyInfo = fiOrgColls.get(i);
                startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)fiOrgColls.get(i));
                if (startPeriod != null) break;
            }
        }
        PeriodInfo curPeriod = JournalWebUtil.getCurrentPeriod(ctx, companyInfo.getId().toString());
        PeriodCollection periodCol = BankJournalWebUtil.getPeriodc(ctx, companyInfo);
        String acctTableId = null;
        if (curPeriod != null && companyInfo != null) {
            acctTableId = JournalWebUtil.getAccTableIdByPeriod(companyInfo.getId().toString(), null, curPeriod.getPeriodYear(), curPeriod.getPeriodNumber(), curPeriod.getPeriodYear(), curPeriod.getPeriodNumber());
            AccountViewCollection accountViewCol = JournalWebUtil.getAccountViewList(ctx, companyInfo.getId().toString(), acctTableId, false);
            if (accountViewCol != null && accountViewCol.size() > 0) {
                accountViewInfo = accountViewCol.get(0);
            }
        }
        if (curPeriod != null && periodCol != null) {
            defaultValueMap.put("DEFAULT_PERIOD", curPeriod);
            defaultValueMap.put("DEFAULT_PERIODS", periodCol);
        }
        if (companyIdList != null && companyIdList.size() > 0) {
            defaultValueMap.put("VALID_COMPANYIDS", CASWebHelper.getAuthorizedOrgFilter_F7Special(ctx, "cas_cashbook_01view", false, "unit.id", null));
        }
        if (companyInfo != null && startPeriod != null) {
            defaultValueMap.put("DEFAULT_COMPANY", companyInfo);
            defaultValueMap.put("DEFAULT_START_PERIOD", startPeriod);
        }
        if (acctTableId != null && accountViewInfo != null) {
            defaultValueMap.put("DEFAULT_ACCTABLEID", acctTableId);
            defaultValueMap.put("DEFAULT_ACCOUNTVIEW", accountViewInfo);
        }
        return defaultValueMap;
    }

    protected Map getCashJournalUIDefaultValueByShare(Context ctx) throws BOSException, EASBizException {
        HashMap<String, Object> defaultValueMap = new HashMap<String, Object>();
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        PeriodInfo startPeriod = null;
        AccountViewInfo accountViewInfo = null;
        CompanyOrgUnitCollection fiOrgColls = CASWebHelper.getAuthorizedOrgCollection(ctx, "cas_cashbook_01view", false);
        HashSet<String> idSet = new HashSet<String>();
        for (int idx = 0; idx < fiOrgColls.size(); ++idx) {
            CompanyOrgUnitInfo fiOrgUnit = fiOrgColls.get(idx);
            if (fiOrgUnit == null || fiOrgUnit.getId() == null) continue;
            idSet.add(fiOrgUnit.getId().toString());
        }
        ArrayList companyIdList = new ArrayList(idSet);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("baseCurrency.*"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("accountTable.name"));
        sic.add(new SelectorItemInfo("accountTable.number"));
        if (companyIdList != null && companyIdList.size() != 0 && companyIdList.contains(companyInfo.getId().toString())) {
            companyIdList.remove(companyInfo.getId().toString());
            companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId().toString()), sic);
            startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        }
        if (startPeriod == null && fiOrgColls != null && fiOrgColls.size() > 0) {
            for (int i = 0; i < fiOrgColls.size(); ++i) {
                companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(fiOrgColls.get(i).getId().toString()), sic);
                startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)fiOrgColls.get(i));
                if (startPeriod != null) break;
            }
        }
        PeriodInfo curPeriod = JournalWebUtil.getCurrentPeriod(ctx, companyInfo.getId().toString());
        PeriodCollection periodCol = BankJournalWebUtil.getPeriodc(ctx, companyInfo);
        String acctTableId = null;
        if (curPeriod != null && companyInfo != null) {
            acctTableId = JournalWebUtil.getAccTableIdByPeriod(companyInfo.getId().toString(), null, curPeriod.getPeriodYear(), curPeriod.getPeriodNumber(), curPeriod.getPeriodYear(), curPeriod.getPeriodNumber());
            AccountViewCollection accountViewCol = JournalWebUtil.getAccountViewList(ctx, companyInfo.getId().toString(), acctTableId, false);
            if (accountViewCol != null && accountViewCol.size() > 0) {
                accountViewInfo = accountViewCol.get(0);
            }
        }
        if (curPeriod != null && periodCol != null) {
            defaultValueMap.put("DEFAULT_PERIOD", curPeriod);
            defaultValueMap.put("DEFAULT_PERIODS", periodCol);
        }
        if (companyIdList != null && companyIdList.size() > 0) {
            defaultValueMap.put("VALID_COMPANYIDS", CASWebHelper.getAuthorizedOrgFilter_F7Special(ctx, "cas_cashbook_01view", false, "unit.id", null));
        }
        if (companyInfo != null && startPeriod != null) {
            defaultValueMap.put("DEFAULT_COMPANY", companyInfo);
            defaultValueMap.put("DEFAULT_START_PERIOD", startPeriod);
        }
        if (acctTableId != null && accountViewInfo != null) {
            defaultValueMap.put("DEFAULT_ACCTABLEID", acctTableId);
            defaultValueMap.put("DEFAULT_ACCOUNTVIEW", accountViewInfo);
        }
        return defaultValueMap;
    }

    @Override
    protected List _batchDeleteCashJournal(Context ctx, String[] journalIdList, String companyId) throws BOSException, EASBizException {
        ArrayList<BsfBatchProcessResult> resultList = null;
        if (journalIdList != null && journalIdList.length > 0) {
            resultList = new ArrayList<BsfBatchProcessResult>(journalIdList.length);
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
            for (String journalId : journalIdList) {
                BsfBatchProcessResult result = new BsfBatchProcessResult(journalId);
                resultList.add(result);
                HashMap detailMsg = new HashMap();
                try {
                    JournalInfo info = this.getJournalInfoById(ctx, journalId);
                    if (info.getSource() == JournalSourceEnum.BYBILL || info.getSource() == JournalSourceEnum.BYVOUCHER) {
                        result.setProcessResult(false);
                        result.setJournalInfo(info);
                        result.getErrorInfo().setMsgSummary(CASWebUtil.getResource(ctx, "409_JOURNAL_ERROR_INFO"));
                        continue;
                    }
                    int currYear = currPeriodInfo.getPeriodYear();
                    int currPeriodNumber = currPeriodInfo.getPeriodNumber();
                    Integer year = info.getPeriod().getPeriodYear();
                    Integer period = info.getPeriod().getPeriodNumber();
                    if (year < currYear || year == currYear && period < currPeriodNumber) {
                        result.setProcessResult(false);
                        result.setJournalInfo(info);
                        result.getErrorInfo().setMsgSummary(EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.JournalResource", (String)"checkoutNoDelete", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (info.getTicketNumber() != null) {
                        result.setProcessResult(false);
                        result.setJournalInfo(info);
                        result.getErrorInfo().setMsgSummary(EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.JournalResource", (String)"HASVC", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (!info.getVerifyStatus().equals((Object)VerifyScopeEnum.NOVA)) {
                        result.setProcessResult(false);
                        result.setJournalInfo(info);
                        result.getErrorInfo().setMsgSummary(EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.JournalResource", (String)"HASVERIFY", (Locale)ctx.getLocale()));
                        continue;
                    }
                    JournalWebUtil.isReferenced(ctx, journalId);
                    JournalFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(info.getId()));
                    result.setProcessResult(true);
                }
                catch (Exception e) {
                    result.setProcessResult(false);
                    result.setException(e);
                    result.getErrorInfo().setMsgSummary(e.getMessage());
                }
            }
        }
        return resultList;
    }

    @Override
    protected Map _getCashJournalUIDefaultValue(Context ctx, boolean share) throws BOSException, EASBizException {
        Map<String, PeriodCollection> defaultValueMap = new HashMap();
        CompanyOrgUnitInfo companyInfo = null;
        PeriodInfo startPeriod = null;
        AccountViewInfo accountViewInfo = null;
        if (share) {
            defaultValueMap = this.getCashJournalUIDefaultValueByShare(ctx);
        } else {
            CompanyOrgUnitInfo curFIUnit = ContextUtil.getCurrentFIUnit((Context)ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("baseCurrency.*"));
            sic.add(new SelectorItemInfo("accountTable.id"));
            sic.add(new SelectorItemInfo("accountTable.name"));
            sic.add(new SelectorItemInfo("accountTable.number"));
            companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(curFIUnit.getId().toString()), sic);
            startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            PeriodInfo curPeriod = JournalWebUtil.getCurrentPeriod(ctx, companyInfo.getId().toString());
            PeriodCollection periodCol = BankJournalWebUtil.getPeriodc(ctx, companyInfo);
            String acctTableId = null;
            if (curPeriod != null && companyInfo != null) {
                acctTableId = JournalWebUtil.getAccTableIdByPeriod(curFIUnit.getId().toString(), null, curPeriod.getPeriodYear(), curPeriod.getPeriodNumber(), curPeriod.getPeriodYear(), curPeriod.getPeriodNumber());
                AccountViewCollection accountViewCol = JournalWebUtil.getAccountViewList(ctx, curFIUnit.getId().toString(), acctTableId, false);
                if (accountViewCol != null && accountViewCol.size() > 0) {
                    accountViewInfo = accountViewCol.get(0);
                }
            }
            if (curPeriod != null && periodCol != null) {
                defaultValueMap.put("DEFAULT_PERIOD", (PeriodCollection)curPeriod);
                defaultValueMap.put("DEFAULT_PERIODS", periodCol);
            }
            if (companyInfo != null && startPeriod != null) {
                defaultValueMap.put("DEFAULT_COMPANY", (PeriodCollection)companyInfo);
                defaultValueMap.put("DEFAULT_START_PERIOD", (PeriodCollection)startPeriod);
            }
            if (acctTableId != null && accountViewInfo != null) {
                defaultValueMap.put("DEFAULT_ACCTABLEID", (PeriodCollection)acctTableId);
                defaultValueMap.put("DEFAULT_ACCOUNTVIEW", (PeriodCollection)accountViewInfo);
            }
        }
        return defaultValueMap;
    }
}

