/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.common.olap.EASEjbFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.AccountTypeEnum;
import com.kingdee.eas.fi.cas.BankStatementInfo;
import com.kingdee.eas.fi.cas.BookNotifyException;
import com.kingdee.eas.fi.cas.CasDataException;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.CasGLItemCheckRptInfo;
import com.kingdee.eas.fi.cas.CashDataSourceEnum;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.CashFetchDataParam;
import com.kingdee.eas.fi.cas.CashGLCheckRptInfo;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.CashManagementCashMethodParam;
import com.kingdee.eas.fi.cas.CashMgtInitFacadeFactory;
import com.kingdee.eas.fi.cas.CompanyPeriodCol;
import com.kingdee.eas.fi.cas.CompanyPeriodSingleInfo;
import com.kingdee.eas.fi.cas.ICashMgtInitFacade;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.app.AbstractCashManagementControllerBean;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMPeriodUtils;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.common.FmSysStatusCtrlUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.RptException;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.naming.OperationNotSupportedException;
import org.apache.log4j.Logger;

public class CashManagementControllerBean
extends AbstractCashManagementControllerBean {
    private Logger logger = Logger.getLogger(this.getClass());

    @Override
    protected BigDecimal _getDayBalance(Context ctx, IObjectPK companyPK, IObjectPK currencyPK, java.util.Date queryDate) throws BOSException, EASBizException {
        throw new BOSException((Throwable)new OperationNotSupportedException("please use getCashDate() or getBankDate()"));
    }

    @Override
    protected CashGLCheckRptInfo _checkGLData(Context ctx, IObjectPK companyPK) throws BOSException, EASBizException {
        boolean isCasStart = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (IObjectPK)companyPK);
        if (!isCasStart) {
            throw new CasException(CasException.CHECK_CASINIT);
        }
        CashGLCheckRptInfo rptInfo = null;
        String companyId = companyPK.toString();
        PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (IObjectPK)companyPK);
        if (currPeriodInfo == null) {
            return null;
        }
        String periodId = currPeriodInfo.getId().toString();
        ICashMgtInitFacade iCashMgtInit = CashMgtInitFacadeFactory.getLocalInstance(ctx);
        Vector vecRpt = iCashMgtInit.getContrastWithGL(companyId, periodId);
        String msg = null;
        boolean fBalance = true;
        if (vecRpt != null && vecRpt.size() > 0) {
            fBalance = false;
            CasGLItemCheckRptInfo checkRptInfo = (CasGLItemCheckRptInfo)vecRpt.get(0);
            AccountTypeEnum type = null;
            if (checkRptInfo.getAccountBankInfo() != null) {
                type = AccountTypeEnum.BANKACCOUNT;
                msg = FMHelper.formatMessage((Context)ctx, (String)"com.kingdee.eas.fi.cas.CasResources", (String)"CashGL_Data_NotEquals", (Object[])new String[]{type.toString(), checkRptInfo.getCurrencyInfo().getName(ctx.getLocale()), checkRptInfo.getBankInfo().getName(ctx.getLocale()) + "-" + checkRptInfo.getAccountBankInfo().getName(ctx.getLocale()), checkRptInfo.getAccountViewInfo().getName(ctx.getLocale()), checkRptInfo.getCasStartAmt().setScale(checkRptInfo.getCurrencyInfo().getPrecision(), 4).toString(), checkRptInfo.getGlStartAmt().setScale(checkRptInfo.getCurrencyInfo().getPrecision(), 4).toString()});
            } else {
                type = AccountTypeEnum.CASHACCOUNT;
                msg = FMHelper.formatMessage((Context)ctx, (String)"com.kingdee.eas.fi.cas.CasResources", (String)"CashGL_Data_NotEquals", (Object[])new String[]{type.toString(), checkRptInfo.getCurrencyInfo().getName(ctx.getLocale()), " ", checkRptInfo.getAccountViewInfo().getName(ctx.getLocale()), checkRptInfo.getCasStartAmt().setScale(checkRptInfo.getCurrencyInfo().getPrecision(), 4).toString(), checkRptInfo.getGlStartAmt().setScale(checkRptInfo.getCurrencyInfo().getPrecision(), 4).toString()});
            }
        }
        rptInfo = new CashGLCheckRptInfo(fBalance, msg);
        return rptInfo;
    }

    @Override
    protected void _checkBookedVerified(Context ctx, BOSUuid voucherId) throws BOSException, EASBizException {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "select fid from T_CAS_Journal where fvoucherid = ? and fisverified <> 0";
        try {
            con = this.getConnection(ctx);
            pstmt = con.prepareStatement(sql);
            pstmt.setString(1, voucherId.toString());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                throw new BookNotifyException(BookNotifyException.ALREADY_VERIFY);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
    }

    @Override
    protected void _updateRelatedDate(Context ctx, ArrayList matchedIDs) throws BOSException, EASBizException {
        if (matchedIDs == null || matchedIDs.size() == 0) {
            return;
        }
        String journalType = new JournalInfo().getBOSType().toString();
        String stmtType = new BankStatementInfo().getBOSType().toString();
        StringBuffer journalIds = new StringBuffer();
        StringBuffer stmtIds = new StringBuffer();
        String id = null;
        String type = null;
        int n = matchedIDs.size();
        for (int i = 0; i < n; ++i) {
            id = matchedIDs.get(i).toString();
            BOSUuid uuid = BOSUuid.read((String)id);
            type = uuid.getType().toString();
            if (type.equals(journalType)) {
                journalIds.append("'").append(id).append("',");
                continue;
            }
            if (!type.equals(stmtType)) continue;
            stmtIds.append("'").append(id).append("',");
        }
        StringBuffer sql = new StringBuffer();
        StringBuffer idSql = new StringBuffer();
        if (journalIds.length() > 0) {
            journalIds = journalIds.deleteCharAt(journalIds.length() - 1);
            idSql.append("select FCreateDate from T_CAS_Journal where fid in (").append(journalIds).append(") and FVerifyStatus <> 0");
        }
        if (stmtIds.length() > 0) {
            stmtIds = stmtIds.deleteCharAt(stmtIds.length() - 1);
            idSql.append(sql.length() > 0 ? " union all " : "").append("select FCreateDate from T_CAS_BankStatement where fid in(").append(stmtIds).append(")  and FVerifyStatus <> 0");
        }
        if (idSql.length() == 0) {
            return;
        }
        sql.append("select FCreateDate from (").append(idSql).append(") t_casVC_Date order by FCreateDate desc");
        Date latestDate = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                latestDate = rs.getDate(1);
            }
            if (latestDate != null) {
                StringBuffer updateSql = null;
                if (journalIds.length() > 0) {
                    updateSql = new StringBuffer(200);
                    updateSql.append("update T_CAS_Journal set FRelatedBizDate = {").append(latestDate).append("} where fid in (").append(journalIds.toString()).append(") and FVerifyStatus <> 0");
                    DbUtil.execute((Context)ctx, (String)updateSql.toString());
                }
                if (stmtIds.length() > 0) {
                    updateSql = new StringBuffer(200);
                    updateSql.append("update T_CAS_BankStatement set FRelatedBizDate = {").append(latestDate).append("} where fid in (").append(stmtIds.toString()).append(") and FVerifyStatus <> 0");
                    DbUtil.execute((Context)ctx, (String)updateSql.toString());
                }
            }
        }
        catch (SQLException ex) {
            this.logger.error((Object)ex);
            throw new BOSException((Throwable)ex);
        }
    }

    private boolean isValidPair(CashDataSourceEnum dataSource, CashDataTypeEnum dataType) {
        boolean flag = true;
        if (dataSource == null && dataType != null) {
            return true;
        }
        if (dataSource != null) {
            switch (dataSource.getValue()) {
                case 2: 
                case 6: 
                case 7: {
                    if (dataType.getValue() <= 2) break;
                    flag = false;
                    break;
                }
                case 3: {
                    break;
                }
                case 5: {
                    if (dataType.getValue() <= 2) break;
                    flag = false;
                }
            }
        }
        return flag;
    }

    @Override
    protected BigDecimal _cash(Context ctx, CashFetchDataParam param) throws BOSException, EASBizException {
        CashDataSourceEnum dataSource = param.getDataSource();
        CashDataTypeEnum dataType = param.getDataType();
        java.util.Date beginDate = param.getBeginDate();
        java.util.Date endDate = param.getEndDate();
        FMVerifyHelper.checkBlank((Object)((Object)dataType), (Object[])new Object[]{"dataType"});
        if (dataType.getValue() == 0 || dataType.getValue() == 1) {
            FMVerifyHelper.checkBlank((Object)endDate, (Object[])new Object[]{"endDate"});
            beginDate = null;
        } else {
            FMVerifyHelper.checkBlank((Object)beginDate, (Object[])new Object[]{"beginDate"});
            FMVerifyHelper.checkBlank((Object)endDate, (Object[])new Object[]{"endDate"});
        }
        Set companyIdSet = param.getCompanyIdSet();
        HashSet acctBankIdSet = param.getAcctBankIdSet();
        if (dataSource == CashDataSourceEnum.C) {
            acctBankIdSet = new HashSet();
        }
        if (dataSource == null) {
            dataSource = CashDataSourceEnum.CB;
        }
        if (!this.isValidPair(dataSource, dataType)) {
            throw new CasDataException(CasDataException.PAIR_ERROR);
        }
        if (beginDate != null) {
            beginDate = DateTimeUtils.truncateDate((java.util.Date)beginDate);
        }
        endDate = DateTimeUtils.truncateDate((java.util.Date)endDate);
        Map startPeriodMap = param.getStartPeriodMap();
        Map currentPeriodMap = param.getCurrentPeriodMap();
        PeriodInfo calculatePeriod = param.getCalculatePeriod();
        boolean isIncludeUnsettled = param.isIncludeUnsettled();
        CurrencyInfo currency = param.getCurrency();
        String currencyId = currency.getId().toString();
        String acctTableNum = param.getAcctTableNum();
        String acctViewNum = param.getAcctViewNum();
        String sql = this.getSql(ctx, dataSource, companyIdSet, acctTableNum, acctViewNum, acctBankIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnsettled, startPeriodMap, currentPeriodMap, calculatePeriod, false);
        BigDecimal result = SysConstant.BIGZERO;
        if (sql != null) {
            result = this.exeQuerySql(ctx, sql.toString());
            this.logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"80_CashManagementControllerBean", (Locale)ctx.getLocale()));
            this.logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"81_CashManagementControllerBean", (Locale)ctx.getLocale()) + (Object)((Object)dataType) + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"82_CashManagementControllerBean", (Locale)ctx.getLocale()) + result));
            this.logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"83_CashManagementControllerBean", (Locale)ctx.getLocale()) + sql.toString()));
            this.logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"84_CashManagementControllerBean", (Locale)ctx.getLocale()) + result));
            this.logger.info((Object)"****************************************************");
        }
        if (currency != null && result != null) {
            result = result.setScale(currency.getPrecision(), 4);
        }
        return result;
    }

    private String getSql(Context ctx, CashDataSourceEnum dataSource, Set companyIdSet, String acctTableNum, String accountNum, Set bankAcctIdSet, String currencyId, java.util.Date beginDate, java.util.Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnsettled, Map startPeriodMap, Map currentPeriodMap, PeriodInfo calculatePeriod, boolean isAdjustPeriod) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        ArrayList<StringBuffer> sqls = new ArrayList<StringBuffer>();
        Iterator it = companyIdSet.iterator();
        PeriodInfo startPeriod = null;
        PeriodInfo currentPeriod = null;
        while (it.hasNext()) {
            String companyId = (String)it.next();
            startPeriod = (PeriodInfo)startPeriodMap.get(companyId);
            currentPeriod = (PeriodInfo)currentPeriodMap.get(companyId);
            Set accountIdSet = this.getAccountIds(ctx, acctTableNum, companyId, dataSource, accountNum, calculatePeriod);
            StringBuffer subSql = new StringBuffer();
            String querySql = null;
            querySql = dataType.getValue() == 2 ? this.getAvgSql(ctx, dataSource, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnsettled, startPeriod, currentPeriod, calculatePeriod) : (dataType.getValue() == 0 || dataType.getValue() == 1 ? this.getBalanceSql(ctx, dataSource, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnsettled, startPeriod, currentPeriod, calculatePeriod, isAdjustPeriod, false) : this.getSummarySql(ctx, dataSource, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnsettled, calculatePeriod));
            if (querySql == null) continue;
            subSql.append(" select sum(SubResult) Result from ( ");
            subSql.append(querySql);
            subSql.append(") SubQuery");
            this.logger.debug((Object)("sql: " + subSql));
            sqls.add(subSql);
        }
        if (sqls.size() <= 0) {
            return null;
        }
        sql.append(sqls.get(0));
        for (int i = 1; i < sqls.size(); ++i) {
            sql.append(" union all ").append(sqls.get(i));
        }
        return sql.toString();
    }

    @Override
    protected BigDecimal _cash(Context ctx, String companyNum, CashDataSourceEnum dataSource, String acctTableNum, String accountNum, String bankAcctNum, String currencyNum, java.util.Date beginDate, java.util.Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnsettled) throws BOSException, EASBizException {
        return this._cash(ctx, companyNum, dataSource, acctTableNum, accountNum, bankAcctNum, currencyNum, beginDate, endDate, dataType, isIncludeUnsettled, false, false);
    }

    @Override
    protected BigDecimal _cash(Context ctx, String companyNum, CashDataSourceEnum dataSource, String acctTableNum, String accountNum, String bankAcctNum, String currencyNum, java.util.Date beginDate, java.util.Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnsettled, boolean isAdjustPeriod, boolean isMulUnionQuery) throws BOSException, EASBizException {
        FMVerifyHelper.checkBlank((Object)((Object)dataType), (Object[])new Object[]{"dataType"});
        if (dataType.getValue() == 0 || dataType.getValue() == 1) {
            FMVerifyHelper.checkBlank((Object)endDate, (Object[])new Object[]{"endDate"});
            beginDate = null;
        } else {
            FMVerifyHelper.checkBlank((Object)beginDate, (Object[])new Object[]{"beginDate"});
            FMVerifyHelper.checkBlank((Object)endDate, (Object[])new Object[]{"endDate"});
        }
        if (dataSource == CashDataSourceEnum.C) {
            bankAcctNum = null;
        }
        if (dataSource == null) {
            dataSource = CashDataSourceEnum.CB;
        }
        if (!this.isValidPair(dataSource, dataType)) {
            throw new CasDataException(CasDataException.PAIR_ERROR);
        }
        Set companyIdSet = CashHelper.getCompanyIds(ctx, companyNum);
        if (companyIdSet == null) {
            throw new CasDataException(CasDataException.NULL_COMPANY);
        }
        Set bankAcctIdSet = CashHelper.getBankAcctIds(ctx, companyNum, bankAcctNum, isMulUnionQuery);
        String currencyId = this.getCurrencyId(ctx, currencyNum);
        if (beginDate != null) {
            beginDate = DateTimeUtils.truncateDate((java.util.Date)beginDate);
        }
        endDate = DateTimeUtils.truncateDate((java.util.Date)endDate);
        String sql = null;
        sql = this.getSql(ctx, dataSource, companyIdSet, acctTableNum, accountNum, bankAcctIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnsettled, isAdjustPeriod, isMulUnionQuery);
        BigDecimal result = SysConstant.BIGZERO;
        if (sql != null) {
            result = this.exeQuerySql(ctx, sql.toString());
            this.logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"80_CashManagementControllerBean", (Locale)ctx.getLocale()));
            this.logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"81_CashManagementControllerBean", (Locale)ctx.getLocale()) + (Object)((Object)dataType) + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"82_CashManagementControllerBean", (Locale)ctx.getLocale()) + result));
            this.logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"83_CashManagementControllerBean", (Locale)ctx.getLocale()) + sql.toString()));
            this.logger.info((Object)"****************************************************");
        }
        if (currencyId != null && result != null) {
            ICurrency currency = CurrencyFactory.getLocalInstance((Context)ctx);
            CurrencyInfo curInfo = currency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
            result = result.setScale(curInfo.getPrecision(), 4);
        }
        return result;
    }

    private String getAvgSql(Context ctx, CashDataSourceEnum dataSource, String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, java.util.Date beginDate, java.util.Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnsettled) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        return this.getAvgSql(ctx, dataSource, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnsettled, startPeriod, currentPeriod, null);
    }

    private String getAvgSql(Context ctx, CashDataSourceEnum dataSource, String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, java.util.Date beginDate, java.util.Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnsettled, PeriodInfo startPeriod, PeriodInfo currentPeriod, PeriodInfo calculatePeriod) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        String cAvgSql = this.getJTypeAvgSql(ctx, CashDataSourceEnum.C, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnsettled, startPeriod, currentPeriod, calculatePeriod);
        String bAvgSql = this.getJTypeAvgSql(ctx, CashDataSourceEnum.B, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnsettled, startPeriod, currentPeriod, calculatePeriod);
        String rAvgSql = this.getRTypeAvgSql(ctx, CashDataSourceEnum.R, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, endDate, dataType, startPeriod, currentPeriod);
        String sAvgSql = this.getSTypeAvgSql(companyId, currencyId, accountIdSet, beginDate, endDate);
        if (cAvgSql == null || bAvgSql == null || rAvgSql == null || sAvgSql == null) {
            return null;
        }
        switch (dataSource.getValue()) {
            case 3: {
                sql.append(rAvgSql);
                break;
            }
            case 0: {
                sql.append(cAvgSql);
                break;
            }
            case 1: {
                sql.append(bAvgSql);
                break;
            }
            case 2: {
                sql.append(sAvgSql);
                break;
            }
            case 5: {
                sql.append(cAvgSql).append(" union all ").append(rAvgSql);
                break;
            }
            case 4: {
                sql.append(cAvgSql).append(" union all ").append(bAvgSql);
                break;
            }
            case 6: {
                sql.append(sAvgSql).append(" union all ").append(bAvgSql);
                break;
            }
            case 7: {
                sql.append(sAvgSql).append(" union all ").append(rAvgSql);
            }
        }
        return sql.toString();
    }

    private String getRTypeAvgSql(Context ctx, CashDataSourceEnum dataSource, String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, java.util.Date beginDate, java.util.Date endDate, CashDataTypeEnum dataType, PeriodInfo startPeriod, PeriodInfo currentPeriod) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(this.getRTypeBalanceSql(ctx, dataSource, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, beginDate, CashDataTypeEnum.C, startPeriod, currentPeriod, null, false));
        sql.append("union all");
        sql.append(" select sum(SubResult)/datediff(d,{").append(TypeConversionUtils.objToDate((Object)beginDate)).append("},{").append(TypeConversionUtils.objToDate((Object)DateHelper.getNextDay((java.util.Date)endDate))).append("}) SubResult from ( ");
        sql.append(this.getRangeSql(companyId, accountIdSet, bankAcctIdSet, currencyId, dataSource, beginDate, endDate, dataType, null, null, false));
        sql.append(") SubQuery ");
        return sql.toString();
    }

    private String getSTypeAvgSql(String companyId, String currencyId, Set accountIdSet, java.util.Date beginDate, java.util.Date endDate) {
        StringBuffer sql = new StringBuffer(200);
        StringBuffer field = new StringBuffer();
        StringBuffer from = new StringBuffer();
        StringBuffer where = new StringBuffer();
        String accountIds = this.composeParse(accountIdSet);
        field.append(" sum(FSubTotal)/datediff(d,{").append(TypeConversionUtils.objToDate((Object)beginDate)).append("},{").append(TypeConversionUtils.objToDate((Object)DateHelper.getNextDay((java.util.Date)endDate))).append("})");
        from.append("SubResult from t_cas_CashCount ");
        where.append("where FCompanyId = '").append(companyId).append("'");
        if (accountIds != null) {
            where.append(" and FAccountId in ( ").append(accountIds).append(")");
        }
        where.append(" and FCurrencyId = '").append(currencyId).append("' and FCountedDate >={ ").append(TypeConversionUtils.objToDate((Object)beginDate)).append("} and FCountedDate <= {").append(TypeConversionUtils.objToDate((Object)endDate)).append("}");
        sql.append("select ").append(field).append(from).append(where);
        return sql.toString();
    }

    private String getJTypeAvgSql(Context ctx, CashDataSourceEnum dataSource, String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, java.util.Date beginDate, java.util.Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnsettled) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        return this.getJTypeAvgSql(ctx, dataSource, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnsettled, startPeriod, currentPeriod, null);
    }

    private String getJTypeAvgSql(Context ctx, CashDataSourceEnum dataSource, String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, java.util.Date beginDate, java.util.Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnsettled, PeriodInfo startPeriod, PeriodInfo currentPeriod, PeriodInfo calculatePeriod) throws EASBizException, BOSException {
        if (startPeriod == null) {
            return null;
        }
        if (endDate.before(startPeriod.getBeginDate())) {
            return null;
        }
        if (beginDate.before(startPeriod.getBeginDate())) {
            beginDate = startPeriod.getBeginDate();
        }
        StringBuffer sql = new StringBuffer();
        String balanceSql = this.getJTypeBalanceSql(ctx, dataSource, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, beginDate, CashDataTypeEnum.C, isIncludeUnsettled, startPeriod, currentPeriod, calculatePeriod, false, false);
        if (balanceSql == null) {
            return null;
        }
        sql.append(balanceSql);
        sql.append("union all");
        sql.append(" select sum(SubResult)/datediff(d,{").append(TypeConversionUtils.objToDate((Object)beginDate)).append("},{").append(TypeConversionUtils.objToDate((Object)DateHelper.getNextDay((java.util.Date)endDate))).append("}) SubResult from ( ");
        sql.append(this.getRangeSql(companyId, accountIdSet, bankAcctIdSet, currencyId, dataSource, beginDate, endDate, dataType, new Boolean(isIncludeUnsettled), calculatePeriod, false));
        sql.append(") SubQuery ");
        return sql.toString();
    }

    private String getSql(Context ctx, CashDataSourceEnum dataSource, Set companyIdSet, String acctTableNum, String accountNum, Set bankAcctIdSet, String currencyId, java.util.Date beginDate, java.util.Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnsettled, boolean isAdjustPeriod, boolean isMulUnionQuery) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        ArrayList<StringBuffer> sqls = new ArrayList<StringBuffer>();
        Iterator it = companyIdSet.iterator();
        Map startPeriodMap = FmSysStatusCtrlUtils.getStartPeriod((Context)ctx, (int)7, (Set)companyIdSet);
        Map currentPeriodMap = FmSysStatusCtrlUtils.getCurrentPeriod((Context)ctx, (int)7, (Set)companyIdSet);
        PeriodInfo startPeriod = null;
        PeriodInfo currentPeriod = null;
        while (it.hasNext()) {
            String companyId = (String)it.next();
            startPeriod = (PeriodInfo)startPeriodMap.get(companyId);
            currentPeriod = (PeriodInfo)currentPeriodMap.get(companyId);
            Set accountIdSet = new HashSet();
            if (!isMulUnionQuery) {
                accountIdSet = this.getAccountIds(ctx, acctTableNum, companyId, dataSource, accountNum, null);
            }
            StringBuffer subSql = new StringBuffer();
            String querySql = null;
            querySql = dataType.getValue() == 2 ? this.getAvgSql(ctx, dataSource, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnsettled, startPeriod, currentPeriod, null) : (dataType.getValue() == 0 || dataType.getValue() == 1 ? this.getBalanceSql(ctx, dataSource, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnsettled, startPeriod, currentPeriod, null, isAdjustPeriod, isMulUnionQuery) : this.getSummarySql(ctx, dataSource, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnsettled, null));
            if (querySql == null) continue;
            subSql.append(" select sum(SubResult) Result from ( ");
            subSql.append(querySql);
            subSql.append(") SubQuery");
            this.logger.debug((Object)("sql: " + subSql));
            sqls.add(subSql);
        }
        if (sqls.size() <= 0) {
            return null;
        }
        sql.append(sqls.get(0));
        for (int i = 1; i < sqls.size(); ++i) {
            sql.append(" union all ").append(sqls.get(i));
        }
        return sql.toString();
    }

    private String getBalanceSql(Context ctx, CashDataSourceEnum dataSource, String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, java.util.Date beginDate, java.util.Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnsettled, boolean isAdjustPeriod) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        return this.getBalanceSql(ctx, dataSource, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnsettled, startPeriod, currentPeriod, null, isAdjustPeriod, false);
    }

    private String getBalanceSql(Context ctx, CashDataSourceEnum dataSource, String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, java.util.Date beginDate, java.util.Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnsettled, PeriodInfo startPeriod, PeriodInfo currentPeriod, PeriodInfo calculatePeriod, boolean isAdjustPeriod, boolean isMulUnionQuery) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String cBalanceSql = this.getJTypeBalanceSql(ctx, CashDataSourceEnum.C, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnsettled, startPeriod, currentPeriod, calculatePeriod, isAdjustPeriod, isMulUnionQuery);
        String bBalanceSql = this.getJTypeBalanceSql(ctx, CashDataSourceEnum.B, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnsettled, startPeriod, currentPeriod, calculatePeriod, isAdjustPeriod, isMulUnionQuery);
        String rBalanceSql = this.getRTypeBalanceSql(ctx, CashDataSourceEnum.R, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, endDate, dataType, startPeriod, currentPeriod, calculatePeriod, isAdjustPeriod);
        String sBalanceSql = this.getSTypeBalanceSql(companyId, currencyId, accountIdSet, beginDate, endDate, dataType);
        if (cBalanceSql == null || bBalanceSql == null || rBalanceSql == null || sBalanceSql == null) {
            return null;
        }
        switch (dataSource.getValue()) {
            case 3: {
                sql.append(rBalanceSql);
                break;
            }
            case 0: {
                sql.append(cBalanceSql);
                break;
            }
            case 1: {
                sql.append(bBalanceSql);
                break;
            }
            case 2: {
                sql.append(sBalanceSql);
                break;
            }
            case 5: {
                sql.append(cBalanceSql).append(" union all ").append(rBalanceSql);
                break;
            }
            case 4: {
                sql.append(cBalanceSql).append("union all  ").append(bBalanceSql);
                break;
            }
            case 6: {
                sql.append(sBalanceSql).append(" union all ").append(bBalanceSql);
                break;
            }
            case 7: {
                sql.append(sBalanceSql).append(" union all ").append(rBalanceSql);
            }
        }
        return sql.toString();
    }

    private String getRTypeBalanceSql(Context ctx, CashDataSourceEnum dataSource, String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, java.util.Date beginDate, java.util.Date endDate, CashDataTypeEnum dataType, PeriodInfo startPeriod, PeriodInfo currentPeriod, PeriodInfo calculatePeriod, boolean isAdjustPeriod) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        if (startPeriod == null) {
            return null;
        }
        java.util.Date calculateBeginDate = null;
        java.util.Date calculateEndDate = null;
        calculateEndDate = dataType.getValue() == 0 && !isAdjustPeriod ? DateHelper.getBeforeDay((java.util.Date)endDate) : endDate;
        calculateBeginDate = startPeriod.getBeginDate();
        sql.append(this.getPeriodStartSql(dataSource, companyId, accountIdSet, bankAcctIdSet, currencyId, startPeriod, false));
        if (calculatePeriod == null || !calculatePeriod.isIsAdjustPeriod()) {
            sql.append(" union all ");
            sql.append(this.getRangeSql(companyId, accountIdSet, bankAcctIdSet, currencyId, dataSource, calculateBeginDate, calculateEndDate, dataType, null, null, false));
        }
        return sql.toString();
    }

    private String getJTypeBalanceSql(Context ctx, CashDataSourceEnum dataSource, String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, java.util.Date beginDate, java.util.Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnsettled, PeriodInfo startPeriod, PeriodInfo currentPeriod) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        if (startPeriod == null || currentPeriod == null) {
            return null;
        }
        if (endDate.before(startPeriod.getBeginDate())) {
            return null;
        }
        PeriodInfo period = null;
        java.util.Date calculateBeginDate = null;
        java.util.Date calculateEndDate = null;
        calculateEndDate = dataType.getValue() == 0 ? DateHelper.getBeforeDay((java.util.Date)endDate) : endDate;
        period = calculateEndDate.before(startPeriod.getBeginDate()) ? startPeriod : (calculateEndDate.after(currentPeriod.getBeginDate()) ? currentPeriod : PeriodUtils.getPeriodInfo((Context)ctx, (java.util.Date)calculateEndDate, (CompanyOrgUnitInfo)company));
        calculateBeginDate = period.getBeginDate();
        sql.append(this.getPeriodStartSql(dataSource, companyId, accountIdSet, bankAcctIdSet, currencyId, period, false));
        sql.append(" union all ");
        sql.append(this.getRangeSql(companyId, accountIdSet, bankAcctIdSet, currencyId, dataSource, calculateBeginDate, calculateEndDate, dataType, new Boolean(isIncludeUnsettled), null, false));
        return sql.toString();
    }

    private String getJTypeBalanceSql(Context ctx, CashDataSourceEnum dataSource, String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, java.util.Date beginDate, java.util.Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnsettled, PeriodInfo startPeriod, PeriodInfo currentPeriod, PeriodInfo calculatePeriod, boolean isAdjustPeriod, boolean isMulUnionQuery) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        if (startPeriod == null || currentPeriod == null) {
            return null;
        }
        if (endDate.before(startPeriod.getBeginDate())) {
            return null;
        }
        PeriodInfo period = null;
        java.util.Date calculateBeginDate = null;
        java.util.Date calculateEndDate = null;
        if (isAdjustPeriod && accountIdSet != null && bankAcctIdSet != null && bankAcctIdSet.size() != 0) {
            accountIdSet.clear();
        }
        period = (calculateEndDate = dataType.getValue() == 0 && !isAdjustPeriod ? DateHelper.getBeforeDay((java.util.Date)endDate) : endDate).before(startPeriod.getBeginDate()) ? startPeriod : (calculateEndDate.after(currentPeriod.getBeginDate()) ? currentPeriod : (calculatePeriod == null ? PeriodUtils.getPeriodInfo((Context)ctx, (java.util.Date)calculateEndDate, (CompanyOrgUnitInfo)company) : calculatePeriod));
        calculateBeginDate = period.getBeginDate();
        sql.append(this.getPeriodStartSql(dataSource, companyId, accountIdSet, bankAcctIdSet, currencyId, period, isMulUnionQuery));
        if (calculatePeriod == null || !calculatePeriod.isIsAdjustPeriod()) {
            sql.append(" union all ");
            sql.append(this.getRangeSql(companyId, accountIdSet, bankAcctIdSet, currencyId, dataSource, calculateBeginDate, calculateEndDate, dataType, new Boolean(isIncludeUnsettled), calculatePeriod, isMulUnionQuery));
        }
        return sql.toString();
    }

    private String getSTypeBalanceSql(String companyId, String currencyId, Set accountIdSet, java.util.Date beginDate, java.util.Date endDate, CashDataTypeEnum dataType) {
        String accountIds = this.composeParse(accountIdSet);
        StringBuffer sql = new StringBuffer(200);
        sql.append("select SubResult  from (").append("select top 1 FSubTotal SubResult from t_cas_CashCount ").append("where FCompanyId = '").append(companyId).append("'");
        if (accountIds != null && !accountIds.equals("")) {
            sql.append(" and FAccountId in ( ").append(accountIds).append(")");
        }
        sql.append(" and FCurrencyId = '").append(currencyId);
        if (dataType.getValue() == 0) {
            sql.append("' and FCountedDate <={ ").append(TypeConversionUtils.objToDate((Object)DateHelper.getBeforeDay((java.util.Date)endDate))).append("}");
        } else if (dataType.getValue() == 1) {
            sql.append("' and FCountedDate <= {").append(TypeConversionUtils.objToDate((Object)endDate)).append("}");
        }
        sql.append(" order by FCountedDate desc ) SubQuery");
        return sql.toString();
    }

    private String getPeriodStartSql(CashDataSourceEnum dataSource, String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, PeriodInfo period, boolean isMulUnionQuery) {
        StringBuffer sql = new StringBuffer();
        String accountIds = this.composeParse(accountIdSet);
        String accountBankIds = this.composeParse(bankAcctIdSet);
        sql.append("select FMonthStartAmt SubResult from T_CAS_JournalBalance where ");
        sql.append("FIsInit =0");
        sql.append(" and FCurrencyId ='").append(currencyId);
        if (isMulUnionQuery) {
            sql.append("' and FPeriodId in (Select Fid From T_BD_Period Where FPERIODYEAR = ").append(period.getPeriodYear()).append(" and FPERIODNUMBER = ").append(period.getPeriodNumber()).append(")");
        } else {
            sql.append("' and FPeriodId='").append(period.getId().toString()).append("'");
        }
        if (dataSource.getValue() == 3) {
            sql.append(" and FType= 3");
        } else if (dataSource.getValue() == 1) {
            sql.append(" and FType= 2");
        } else {
            sql.append(" and FType= 1");
        }
        if (!dataSource.equals((Object)CashDataSourceEnum.C) && !dataSource.equals((Object)CashDataSourceEnum.S) && accountBankIds != null && accountBankIds.length() > 0) {
            sql.append(" and FAccountBankID in (").append(accountBankIds + ")");
        }
        if (!isMulUnionQuery) {
            sql.append(" and FCompanyId='").append(companyId).append("'");
        }
        if (accountIds != null && accountIds.length() > 0) {
            sql.append(" and FAccountViewId in (").append(accountIds).append(")");
        }
        return sql.toString();
    }

    private String getSummarySql(Context ctx, CashDataSourceEnum dataSource, String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, java.util.Date beginDate, java.util.Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnsettled, PeriodInfo calculatePeriod) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        String rTypeSql = this.getRangeSql(companyId, accountIdSet, bankAcctIdSet, currencyId, CashDataSourceEnum.R, beginDate, endDate, dataType, new Boolean(isIncludeUnsettled), calculatePeriod, false);
        String bTypeSql = this.getRangeSql(companyId, accountIdSet, bankAcctIdSet, currencyId, CashDataSourceEnum.B, beginDate, endDate, dataType, new Boolean(isIncludeUnsettled), calculatePeriod, false);
        String cTypeSql = this.getRangeSql(companyId, accountIdSet, bankAcctIdSet, currencyId, CashDataSourceEnum.C, beginDate, endDate, dataType, new Boolean(isIncludeUnsettled), calculatePeriod, false);
        switch (dataSource.getValue()) {
            case 3: {
                sql.append(rTypeSql);
                break;
            }
            case 0: {
                sql.append(cTypeSql);
                break;
            }
            case 1: {
                sql.append(bTypeSql);
                break;
            }
            case 2: {
                return null;
            }
            case 5: {
                sql.append(cTypeSql).append("union all  ").append(rTypeSql);
                break;
            }
            case 4: {
                sql.append(cTypeSql).append("union all  ").append(bTypeSql);
            }
        }
        return sql.toString();
    }

    private BigDecimal exeQuerySql(Context ctx, String sql) throws SQLDataException, BOSException {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        BigDecimal result = Constants.ZERO;
        try {
            con = this.getConnection(ctx);
            pstmt = con.prepareStatement(sql);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                BigDecimal value = rs.getBigDecimal("Result");
                if (value == null) continue;
                result = result.add(value);
            }
        }
        catch (SQLException e) {
            try {
                this.logger.error((Object)("sql: " + sql));
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return result;
    }

    private String composeParse(Set idSet) {
        if (idSet == null || idSet.size() == 0) {
            return null;
        }
        StringBuffer sIds = new StringBuffer();
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            sIds.append("'").append(it.next()).append("',");
        }
        if (sIds.length() > 0) {
            sIds = sIds.deleteCharAt(sIds.length() - 1);
        }
        return sIds.toString();
    }

    private Set getAccountIds(Context ctx, String acctTableNum, String companyId, CashDataSourceEnum dataSource, String accountNum, PeriodInfo calculatePeriod) throws BOSException, EASBizException {
        if (EmptyUtil.isEmpty((String)accountNum)) {
            return null;
        }
        StringBuffer sql = new StringBuffer(120);
        sql.append("select t1.FId from t_bd_accountview t1 inner join t_bd_accountTable t2").append(" on t1.FAccountTableID =t2.FID ").append("where  t1.FIsLeaf = 1 ");
        sql.append(" and t1.FCompanyID='").append(companyId).append("'");
        if (!StringUtils.isEmpty((String)accountNum)) {
            if (accountNum.indexOf(",") > 0) {
                sql.append(" and t1.FNumber in (");
                String[] nums = accountNum.split(",");
                for (int i = 0; i < nums.length; ++i) {
                    if (i > 0) {
                        sql.append(",");
                    }
                    sql.append(" t1.FNumber = '").append(nums[i].trim()).append("'");
                }
                sql.append(")");
            } else {
                sql.append(" and t1.FNumber = '").append(accountNum.trim()).append("'");
            }
        }
        if (dataSource.getValue() == 1 || dataSource.getValue() == 3) {
            sql.append(" and t1.FIsBank = 1");
        } else if (dataSource.getValue() == 0 || dataSource.getValue() == 2) {
            sql.append(" and t1.FIsCash = 1");
        }
        if (acctTableNum != null) {
            sql.append(" and t2.FNumber = '").append(acctTableNum).append("'");
        }
        HashSet<String> acctIdSet = new HashSet<String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                if (rs.getString("FID") == null) continue;
                acctIdSet.add(rs.getString("FID"));
            }
        }
        catch (SQLException ex) {
            this.logger.error((Object)ex);
            BOSException e = new BOSException();
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        if (acctIdSet.size() > 0) {
            return acctIdSet;
        }
        throw new CasDataException(CasDataException.NULL_ACCOUNT);
    }

    private String getCurrencyId(Context ctx, String currencyNum) throws BOSException, CasDataException {
        if (EmptyUtil.isEmpty((String)currencyNum)) {
            return null;
        }
        StringBuffer sql = new StringBuffer(100);
        sql.append("select fid from t_bd_currency where FNumber = '").append(currencyNum).append("'");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                return rs.getString(1);
            }
        }
        catch (SQLException ex) {
            this.logger.error((Object)ex);
            BOSException e = new BOSException();
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        throw new CasDataException(CasDataException.NULL_CURRENCY);
    }

    private String getJournalField(CashDataTypeEnum dataType) {
        String field = null;
        switch (dataType.getValue()) {
            case 3: {
                field = "sum(FDebitAmount)";
                break;
            }
            case 4: {
                field = "sum(FCreditAmount)";
                break;
            }
            case 5: {
                field = "sum(FDebitCount)";
                break;
            }
            case 6: {
                field = "sum(FCreditCount)";
                break;
            }
            case 0: {
                field = "sum(FDebitAmount - FCreditAmount) ";
                break;
            }
            case 1: {
                field = "sum(FDebitAmount - FCreditAmount) ";
                break;
            }
            case 2: {
                field = "(FDebitAmount - FCreditAmount)*datediff(d,FCreateDate,{";
            }
        }
        return field;
    }

    private String getStatementField(CashDataTypeEnum dataType) {
        String field = null;
        switch (dataType.getValue()) {
            case 3: {
                field = "sum(FDebitAmount)";
                break;
            }
            case 4: {
                field = "sum(FCreditAmount)";
                break;
            }
            case 6: {
                field = "count(FID)";
                break;
            }
            case 5: {
                field = "count(FID)";
                break;
            }
            case 0: 
            case 1: {
                field = "sum(FCreditAmount-FDebitAmount) ";
                break;
            }
            case 2: {
                field = "( FCreditAmount - FDebitAmount)*datediff(d,FCreateDate,{";
            }
        }
        return field;
    }

    private String getWhere(CashDataSourceEnum dataSource, String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, java.util.Date beginDate, java.util.Date endDate, Boolean isIncludeUnsettled, PeriodInfo calculatePeriod, boolean isMulUnionQuery) {
        String accountIds = this.composeParse(accountIdSet);
        String bankAcctIds = this.composeParse(bankAcctIdSet);
        StringBuffer where = new StringBuffer(100);
        where.append(" where FCreateDate >={").append(TypeConversionUtils.objToDate((Object)beginDate)).append("} and FCreateDate <= {").append(TypeConversionUtils.objToDate((Object)endDate)).append("}");
        if (currencyId != null) {
            where.append(" and FCurrencyId = '").append(currencyId).append("'");
        }
        if (accountIds != null) {
            where.append(" and FAccountViewId in (").append(accountIds).append(")");
        }
        if (!isMulUnionQuery) {
            where.append(" and FCompanyId in ('").append(companyId).append("') ");
        }
        if (!dataSource.equals((Object)CashDataSourceEnum.C) && !dataSource.equals((Object)CashDataSourceEnum.S) && bankAcctIds != null) {
            where.append(" and FAccountBankId in (").append(bankAcctIds).append(")");
        }
        if (calculatePeriod != null) {
            where.append(" and FPeriodId = '").append(calculatePeriod.getId().toString()).append("'");
        }
        if (dataSource.equals((Object)CashDataSourceEnum.B)) {
            where.append(" and FType = 2 ");
        } else if (dataSource.equals((Object)CashDataSourceEnum.C)) {
            where.append(" and FType = 1 ");
        }
        return where.toString();
    }

    private String getFrom(CashDataSourceEnum dataSource) {
        switch (dataSource.getValue()) {
            case 3: {
                return " SubResult from t_cas_Bankstatement ";
            }
            case 0: {
                return " SubResult from t_cas_JournalSummary ";
            }
            case 1: {
                return " SubResult from t_cas_JournalSummary ";
            }
            case 2: {
                return " SubResult from t_cas_CashCount ";
            }
        }
        return null;
    }

    private String getFiled(CashDataSourceEnum dataSource, CashDataTypeEnum dataType) {
        switch (dataSource.getValue()) {
            case 3: {
                return this.getStatementField(dataType);
            }
            case 0: {
                return this.getJournalField(dataType);
            }
            case 1: {
                return this.getJournalField(dataType);
            }
            case 2: {
                return null;
            }
        }
        return null;
    }

    private String getRangeSql(String companyId, Set accountIdSet, Set bankAcctIdSet, String currencyId, CashDataSourceEnum dataSource, java.util.Date beginDate, java.util.Date endDate, CashDataTypeEnum dataType, Boolean isIncludeUnsettled, PeriodInfo calculatePeriod, boolean isMulUnionQuery) {
        StringBuffer sql = new StringBuffer(200);
        String field = this.getFiled(dataSource, dataType);
        if (dataType.getValue() == 2) {
            field = field + TypeConversionUtils.objToDate((Object)DateHelper.getNextDay((java.util.Date)endDate)) + "}) ";
        }
        String from = this.getFrom(dataSource);
        String where = this.getWhere(dataSource, companyId, accountIdSet, bankAcctIdSet, currencyId, beginDate, endDate, isIncludeUnsettled, calculatePeriod, isMulUnionQuery);
        if (dataSource.equals((Object)CashDataSourceEnum.R)) {
            if (dataType.equals((Object)CashDataTypeEnum.QJF)) {
                where = where + " and FIsDebit =1";
            } else if (dataType.equals((Object)CashDataTypeEnum.QDF)) {
                where = where + " and FIsDebit =0";
            }
        }
        sql.append("select ").append(field).append(from).append(where);
        return sql.toString();
    }

    @Override
    protected BigDecimal _getCashData(Context ctx, String companyId, String accountViewId, String currencyId, java.util.Date beginDate, java.util.Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnSettled) throws BOSException, EASBizException {
        PeriodCollection periodCollection;
        boolean isAdjustPeriod = false;
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        if (beginDate != null && endDate != null && (periodCollection = PeriodUtils.getPeriodCollection((Context)ctx, (java.util.Date)beginDate, (java.util.Date)endDate, (CompanyOrgUnitInfo)company)) != null) {
            if (periodCollection.size() == 0) {
                isAdjustPeriod = false;
            } else if (periodCollection.size() == 1) {
                isAdjustPeriod = false;
            } else if (beginDate.getTime() == endDate.getTime()) {
                isAdjustPeriod = true;
            }
        }
        StringBuffer sql = new StringBuffer();
        String querySql = null;
        HashSet<String> accountIdSet = new HashSet<String>();
        if (accountViewId != null) {
            accountIdSet.add(accountViewId);
        }
        if ((querySql = dataType.getValue() == 2 ? this.getAvgSql(ctx, CashDataSourceEnum.C, companyId, accountIdSet, null, currencyId, beginDate, endDate, dataType, isIncludeUnSettled) : (dataType.getValue() == 0 || dataType.getValue() == 1 ? this.getBalanceSql(ctx, CashDataSourceEnum.C, companyId, accountIdSet, null, currencyId, beginDate, endDate, dataType, isIncludeUnSettled, isAdjustPeriod) : this.getSummarySql(ctx, CashDataSourceEnum.C, companyId, accountIdSet, null, currencyId, beginDate, endDate, dataType, isIncludeUnSettled, null))) == null || querySql.trim().length() == 0) {
            return Constants.ZERO;
        }
        sql.append(" select sum(SubResult) Result from ( ");
        sql.append(querySql);
        sql.append(") SubQuery");
        this.logger.debug((Object)("sql: " + sql));
        BigDecimal result = SysConstant.BIGZERO;
        if (sql != null) {
            result = this.exeQuerySql(ctx, sql.toString());
        }
        return result;
    }

    @Override
    protected BigDecimal _getBankData(Context ctx, String companyId, String accountBankId, String currencyId, java.util.Date beginDate, java.util.Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnSettled) throws BOSException, EASBizException {
        boolean isAdjustPeriod = false;
        if (beginDate != null && endDate != null) {
            isAdjustPeriod = beginDate.equals(endDate) && beginDate.getMonth() == 11;
        }
        FMVerifyHelper.checkBlank((Object)((Object)dataType), (Object[])new Object[]{"dataType"});
        if (dataType.getValue() == 0 || dataType.getValue() == 1) {
            FMVerifyHelper.checkBlank((Object)endDate, (Object[])new Object[]{"endDate"});
            beginDate = null;
        } else {
            FMVerifyHelper.checkBlank((Object)beginDate, (Object[])new Object[]{"beginDate"});
            FMVerifyHelper.checkBlank((Object)endDate, (Object[])new Object[]{"endDate"});
        }
        StringBuffer sql = new StringBuffer();
        String querySql = null;
        HashSet<String> accountBankIdSet = new HashSet<String>();
        if (accountBankId != null) {
            accountBankIdSet.add(accountBankId);
        }
        if ((querySql = dataType.getValue() == 2 ? this.getAvgSql(ctx, CashDataSourceEnum.B, companyId, null, accountBankIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnSettled) : (dataType.getValue() == 0 || dataType.getValue() == 1 ? this.getBalanceSql(ctx, CashDataSourceEnum.B, companyId, null, accountBankIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnSettled, isAdjustPeriod) : this.getSummarySql(ctx, CashDataSourceEnum.B, companyId, null, accountBankIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnSettled, null))) == null) {
            return SysConstant.BIGZERO;
        }
        sql.append(" select sum(SubResult) Result from ( ");
        sql.append(querySql);
        sql.append(") SubQuery");
        this.logger.debug((Object)("sql: " + sql));
        BigDecimal result = SysConstant.BIGZERO;
        if (sql != null) {
            result = this.exeQuerySql(ctx, sql.toString());
        }
        return result;
    }

    @Override
    protected Map _getBStateData2Map(Context ctx, AccountBankCollection accountBankCol, String currencyId, java.util.Date beginDate, java.util.Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnSettled, CompanyPeriodCol companyPeriodCol) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> hmReturn = new HashMap<String, BigDecimal>();
        boolean isInitPeriod = false;
        if (companyPeriodCol != null && !companyPeriodCol.isEmpty()) {
            isInitPeriod = true;
        }
        AccountBankInfo accountBank = null;
        HashSet<String> companyIdSet = new HashSet<String>();
        int size = accountBankCol.size();
        for (int i = 0; i < size; ++i) {
            accountBank = accountBankCol.get(i);
            companyIdSet.add(accountBank.getCompany().getId().toString());
        }
        Map startPeriodMap = new HashMap();
        Map currentPeriodMap = new HashMap();
        if (!isInitPeriod) {
            int system = 7;
            startPeriodMap = FmSysStatusCtrlUtils.getStartPeriod((Context)ctx, (int)system, companyIdSet);
            currentPeriodMap = FmSysStatusCtrlUtils.getCurrentPeriod((Context)ctx, (int)system, companyIdSet);
        }
        PeriodInfo calculatePeriod = null;
        java.util.Date calculateEndDate = null;
        calculateEndDate = dataType.getValue() == 0 ? DateHelper.getBeforeDay((java.util.Date)endDate) : endDate;
        Map calculatePeriodMap = FMPeriodUtils.getPeriodColl((Context)ctx, (java.util.Date)calculateEndDate, companyIdSet);
        PeriodInfo startPeriod = null;
        PeriodInfo currentPeriod = null;
        CompanyPeriodSingleInfo companyPeriodSingleInfo = null;
        boolean isAsjustPeriod = false;
        if (beginDate.equals(endDate) && beginDate.getMonth() == 11 && beginDate.getDate() == 31) {
            isAsjustPeriod = true;
        }
        for (int i = 0; i < accountBankCol.size(); ++i) {
            accountBank = accountBankCol.get(i);
            String companyId = accountBank.getCompany().getId().toString();
            String accountBankId = accountBank.getId().toString();
            String key = this.genKey(companyId, accountBankId, currencyId, beginDate, endDate);
            if (isInitPeriod) {
                companyPeriodSingleInfo = this.findInfo(companyPeriodCol, companyId);
                startPeriod = companyPeriodSingleInfo.getStartP();
                currentPeriod = companyPeriodSingleInfo.getCurrP();
            } else {
                startPeriod = (PeriodInfo)startPeriodMap.get(companyId);
                currentPeriod = (PeriodInfo)currentPeriodMap.get(companyId);
            }
            calculatePeriod = (PeriodInfo)calculatePeriodMap.get(companyId);
            BigDecimal value = this.getBStateData(ctx, companyId, accountBankId, currencyId, beginDate, endDate, dataType, false, startPeriod, currentPeriod, calculatePeriod, isAsjustPeriod);
            hmReturn.put(key, value);
        }
        return hmReturn;
    }

    private CompanyPeriodSingleInfo findInfo(CompanyPeriodCol companyPeriodCol, String companyId) {
        CompanyPeriodSingleInfo companyPeriodSingleInfo = null;
        int size = companyPeriodCol.size();
        for (int i = 0; i < size; ++i) {
            companyPeriodSingleInfo = companyPeriodCol.getIndex(i);
            if (!companyId.equals(companyPeriodSingleInfo.getCompanyID())) continue;
            return companyPeriodSingleInfo;
        }
        return null;
    }

    private String genKey(String companyId, String accountBankId, String currencyId, java.util.Date beginDate, java.util.Date endDate) {
        StringBuffer sb = new StringBuffer();
        sb.append(companyId).append(accountBankId).append(currencyId).append(beginDate.toString()).append(endDate.toString());
        return sb.toString();
    }

    @Override
    protected BigDecimal _getBStateData(Context ctx, String companyId, String accountBankId, String currencyId, java.util.Date beginDate, java.util.Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnSettled) throws BOSException, EASBizException {
        boolean isAdjustPeriod = false;
        if (beginDate != null && endDate != null) {
            isAdjustPeriod = beginDate.equals(endDate) && beginDate.getMonth() == 11;
        }
        FMVerifyHelper.checkBlank((Object)((Object)dataType), (Object[])new Object[]{"dataType"});
        if (dataType.getValue() == 0 || dataType.getValue() == 1) {
            FMVerifyHelper.checkBlank((Object)endDate, (Object[])new Object[]{"endDate"});
            beginDate = null;
        } else {
            FMVerifyHelper.checkBlank((Object)beginDate, (Object[])new Object[]{"beginDate"});
            FMVerifyHelper.checkBlank((Object)endDate, (Object[])new Object[]{"endDate"});
        }
        StringBuffer sql = new StringBuffer();
        String querySql = null;
        HashSet<String> accountBankIdSet = new HashSet<String>();
        if (accountBankId != null) {
            accountBankIdSet.add(accountBankId);
        }
        if ((querySql = dataType.getValue() == 2 ? this.getAvgSql(ctx, CashDataSourceEnum.R, companyId, null, accountBankIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnSettled) : (dataType.getValue() == 0 || dataType.getValue() == 1 ? this.getBalanceSql(ctx, CashDataSourceEnum.R, companyId, null, accountBankIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnSettled, isAdjustPeriod) : this.getSummarySql(ctx, CashDataSourceEnum.R, companyId, null, accountBankIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnSettled, null))) == null) {
            return SysConstant.BIGZERO;
        }
        sql.append(" select sum(SubResult) Result from ( ");
        sql.append(querySql);
        sql.append(") SubQuery");
        this.logger.debug((Object)("sql: " + sql));
        BigDecimal result = SysConstant.BIGZERO;
        if (sql != null) {
            result = this.exeQuerySql(ctx, sql.toString());
        }
        return result;
    }

    private BigDecimal getBStateData(Context ctx, String companyId, String accountBankId, String currencyId, java.util.Date beginDate, java.util.Date endDate, CashDataTypeEnum dataType, boolean isIncludeUnSettled, PeriodInfo startPeriod, PeriodInfo currentPeriod, PeriodInfo calculatePeriod, boolean isAsjustPeriod) throws BOSException, EASBizException {
        FMVerifyHelper.checkBlank((Object)((Object)dataType), (Object[])new Object[]{"dataType"});
        if (dataType.getValue() == 0 || dataType.getValue() == 1) {
            FMVerifyHelper.checkBlank((Object)endDate, (Object[])new Object[]{"endDate"});
            beginDate = null;
        } else {
            FMVerifyHelper.checkBlank((Object)beginDate, (Object[])new Object[]{"beginDate"});
            FMVerifyHelper.checkBlank((Object)endDate, (Object[])new Object[]{"endDate"});
        }
        StringBuffer sql = new StringBuffer();
        String querySql = null;
        HashSet<String> accountBankIdSet = new HashSet<String>();
        if (accountBankId != null) {
            accountBankIdSet.add(accountBankId);
        }
        if ((querySql = dataType.getValue() == 2 ? this.getAvgSql(ctx, CashDataSourceEnum.R, companyId, null, accountBankIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnSettled, startPeriod, currentPeriod, calculatePeriod) : (dataType.getValue() == 0 || dataType.getValue() == 1 ? this.getBalanceSql(ctx, CashDataSourceEnum.R, companyId, null, accountBankIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnSettled, startPeriod, currentPeriod, calculatePeriod, isAsjustPeriod, false) : this.getSummarySql(ctx, CashDataSourceEnum.R, companyId, null, accountBankIdSet, currencyId, beginDate, endDate, dataType, isIncludeUnSettled, calculatePeriod))) == null) {
            return SysConstant.BIGZERO;
        }
        sql.append(" select sum(SubResult) Result from ( ");
        sql.append(querySql);
        sql.append(") SubQuery");
        this.logger.debug((Object)("sql: " + sql));
        BigDecimal result = SysConstant.BIGZERO;
        if (sql != null) {
            result = this.exeQuerySql(ctx, sql.toString());
        }
        return result;
    }

    @Override
    protected BigDecimal _getTotalAmtByAccount(Context ctx, String companyId, String accountBankId, String currencyId) throws BOSException, EASBizException {
        return this._getTotalAmtByAccount(ctx, companyId, accountBankId, currencyId, null);
    }

    @Override
    protected BigDecimal _getTotalAmtByAccountView(Context ctx, String companyId, String accountViewId, String currencyId) throws BOSException, EASBizException {
        return this._getTotalAmtByAccountView(ctx, companyId, accountViewId, currencyId, null);
    }

    @Override
    protected BigDecimal _getTotalSettleBillAmtByAccount(Context ctx, String companyId, String accountBankId, String currencyId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        StringBuffer querySql = new StringBuffer();
        querySql.append(" select sum(FAmount) SubResult from T_FS_SettlementBill ");
        querySql.append(" where FPayeeBankAcctID = '");
        querySql.append(accountBankId);
        querySql.append("' and FCompanyID = '");
        querySql.append(companyId);
        querySql.append("' and FCurrencyId = '");
        querySql.append(currencyId);
        querySql.append("' and FType =");
        querySql.append(1);
        querySql.append(" and FHasEffected =1 ");
        querySql.append(" and FCashierID is  null ");
        querySql.append(" union ");
        querySql.append(" select 0-sum(FAmount) SubResult from T_FS_SettlementBill ");
        querySql.append(" where FPayerBankAcctID = '");
        querySql.append(accountBankId);
        querySql.append("' and FCompanyID = '");
        querySql.append(companyId);
        querySql.append("' and FCurrencyId = '");
        querySql.append(currencyId);
        querySql.append("' and FType in (").append(2).append(",").append(10);
        querySql.append(",").append(100).append(")");
        querySql.append(" and FHasEffected =1 ");
        querySql.append(" and FCashierID is  null ");
        querySql.append(" union all");
        querySql.append(" select sum(FActRecAmt) SubResult from t_cas_receivingbill ");
        querySql.append(" where FPayeeAccountBankID = '").append(accountBankId);
        querySql.append("' and FCompanyID = '").append(companyId);
        querySql.append("' and FCurrencyId = '").append(currencyId);
        querySql.append("' and fbillstatus in (").append(11).append(",").append(12);
        querySql.append(")");
        querySql.append(" union all");
        querySql.append(" select 0-sum(FActRecAmt) SubResult from t_cas_receivingbill ");
        querySql.append(" where FPayerAccountBankID = '").append(accountBankId);
        querySql.append("' and FCompanyID = '").append(companyId);
        querySql.append("' and FCurrencyId = '").append(currencyId);
        querySql.append("' and fbillstatus in (").append(11).append(",").append(12);
        querySql.append(")");
        querySql.append(" union all");
        querySql.append(" select 0-sum(FActualPayAmount) SubResult from t_cas_paymentbill ");
        querySql.append(" where FPayerAccountBankID = '").append(accountBankId);
        querySql.append("' and FCompanyID = '").append(companyId);
        querySql.append("' and FCurrencyId = '").append(currencyId);
        querySql.append("' and fbillstatus in (").append(11).append(",").append(8);
        querySql.append(",").append(12).append(")");
        querySql.append(" union all");
        querySql.append(" select sum(FActualPayAmount) SubResult from t_cas_paymentbill ");
        querySql.append(" where FPayeeAccountBankOID = '").append(accountBankId);
        querySql.append("' and FCompanyID = '").append(companyId);
        querySql.append("' and FCurrencyId = '").append(currencyId);
        querySql.append("' and fbillstatus in (").append(11).append(",").append(8);
        querySql.append(",").append(12).append(")");
        sql.append(" select sum(SubResult) Result from ( ");
        sql.append(querySql);
        sql.append(") SubQuery");
        BigDecimal result = SysConstant.BIGZERO;
        if (sql != null) {
            result = this.exeQuerySql(ctx, sql.toString());
        }
        return result;
    }

    @Override
    protected BigDecimal _getTotalSettleBillAmtByAccountView(Context ctx, String companyId, String accountViewId, String currencyId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        StringBuffer querySql = new StringBuffer();
        querySql.append(" select sum(FAmount) SubResult from T_FS_SettlementBill ");
        querySql.append(" where FPayeeAcctID = '");
        querySql.append(accountViewId);
        querySql.append("' and FCompanyID = '");
        querySql.append(companyId);
        querySql.append("' and FCurrencyId = '");
        querySql.append(currencyId);
        querySql.append("' and FType =");
        querySql.append(1);
        querySql.append(" and FHasEffected =1 ");
        querySql.append(" and FCashierID is  null ");
        querySql.append(" union ");
        querySql.append(" select 0-sum(FAmount) SubResult from T_FS_SettlementBill ");
        querySql.append(" where FPayerAcctID = '");
        querySql.append(accountViewId);
        querySql.append("' and FCompanyID = '");
        querySql.append(companyId);
        querySql.append("' and FCurrencyId = '");
        querySql.append(currencyId);
        querySql.append("' and FType =");
        querySql.append(2);
        querySql.append(" and FHasEffected =1 ");
        querySql.append(" and FCashierID is  null ");
        sql.append(" select sum(SubResult) Result from ( ");
        sql.append(querySql);
        sql.append(") SubQuery");
        BigDecimal result = SysConstant.BIGZERO;
        if (sql != null) {
            result = this.exeQuerySql(ctx, sql.toString());
        }
        return result;
    }

    @Override
    protected Map _cash(Context ctx, Map param) throws BOSException, EASBizException {
        for (CashManagementCashMethodParam element : param.values()) {
            if (element.getResult() != null) continue;
            BigDecimal value = this._cash(ctx, element.getCompanyNum(), element.getDataSource(), element.getAcctTableNum(), element.getAccountNum(), element.getBankAcctNum(), element.getCurrencyNum(), element.getBeginDate(), element.getEndDate(), element.getDataType(), element.isIncludeUnsettled(), false, element.isMulUnionQuery());
            element.setResult(value);
        }
        return param;
    }

    @Override
    protected BigDecimal _getTotalAmtByAccountView(Context ctx, String companyId, String accountViewId, String currencyId, java.util.Date endDate) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        StringBuffer querySql = new StringBuffer();
        querySql.append(" select sum(FActRecAmt) SubResult from t_cas_receivingbill ");
        querySql.append(" where FPayeeAccountID = '");
        querySql.append(accountViewId);
        querySql.append("' and FCompanyID = '");
        querySql.append(companyId);
        querySql.append("' and FCurrencyId = '");
        querySql.append(currencyId);
        querySql.append("' and fbillstatus in (");
        querySql.append(11);
        querySql.append(",");
        querySql.append(12);
        querySql.append(")");
        if (endDate != null) {
            querySql.append(" and FbizDate <= {");
            querySql.append(TypeConversionUtils.objToDate((Object)endDate));
            querySql.append("}");
        }
        querySql.append(" and FISINITIALIZEBILL=0 ");
        querySql.append(" union all ");
        querySql.append(" select 0-sum(FActualPayAmount) SubResult from t_cas_paymentbill ");
        querySql.append(" where FPayerAccountID = '");
        querySql.append(accountViewId);
        querySql.append("' and FCompanyID = '");
        querySql.append(companyId);
        querySql.append("' and FCurrencyId = '");
        querySql.append(currencyId);
        querySql.append("' and fbillstatus in (");
        querySql.append(11);
        querySql.append(",");
        querySql.append(8);
        querySql.append(",");
        querySql.append(12);
        querySql.append(")");
        if (endDate != null) {
            querySql.append(" and FbizDate <= {");
            querySql.append(TypeConversionUtils.objToDate((Object)endDate));
            querySql.append("}");
        }
        querySql.append(" and FISINITIALIZEBILL=0 ");
        querySql.append(" union all ");
        querySql.append(" select 0-sum(FActRecAmt) SubResult from t_cas_receivingbill ");
        querySql.append(" where FOppAccountID = '");
        querySql.append(accountViewId);
        querySql.append("' and FCompanyID = '");
        querySql.append(companyId);
        querySql.append("' and FCurrencyId = '");
        querySql.append(currencyId);
        querySql.append("' and fbillstatus in (");
        querySql.append(11);
        querySql.append(",");
        querySql.append(12);
        querySql.append(")");
        if (endDate != null) {
            querySql.append(" and FbizDate <= {");
            querySql.append(TypeConversionUtils.objToDate((Object)endDate));
            querySql.append("}");
        }
        querySql.append(" and FISINITIALIZEBILL=0 ");
        querySql.append(" union all ");
        querySql.append(" select sum(FActualPayAmount) SubResult from t_cas_paymentbill ");
        querySql.append(" where FOppAccountID = '");
        querySql.append(accountViewId);
        querySql.append("' and FCompanyID = '");
        querySql.append(companyId);
        querySql.append("' and FCurrencyId = '");
        querySql.append(currencyId);
        querySql.append("' and fbillstatus in (");
        querySql.append(11);
        querySql.append(",");
        querySql.append(8);
        querySql.append(",");
        querySql.append(12);
        querySql.append(")");
        if (endDate != null) {
            querySql.append(" and FbizDate <= {");
            querySql.append(TypeConversionUtils.objToDate((Object)endDate));
            querySql.append("}");
        }
        querySql.append(" and FISINITIALIZEBILL=0 ");
        querySql.append(" union all ");
        querySql.append(" select sum(FBuyAmount) SubResult from T_CAS_FundsMoveBill ");
        querySql.append(" where FBuyAccountView = '");
        querySql.append(accountViewId);
        querySql.append("' and FCompanyID = '");
        querySql.append(companyId);
        querySql.append("' and FBuyCurrency = '");
        querySql.append(currencyId);
        querySql.append("' and FBillState in (");
        querySql.append(3);
        querySql.append(",");
        querySql.append(2);
        querySql.append(")");
        if (endDate != null) {
            querySql.append(" and FbizDate <= {");
            querySql.append(TypeConversionUtils.objToDate((Object)endDate));
            querySql.append("}");
        }
        querySql.append(" union all ");
        querySql.append(" select sum(0-FSellAmount) SubResult from T_CAS_FundsMoveBill ");
        querySql.append(" where FSellAccountView = '");
        querySql.append(accountViewId);
        querySql.append("' and FCompanyID = '");
        querySql.append(companyId);
        querySql.append("' and FSellCurrencyID = '");
        querySql.append(currencyId);
        querySql.append("' and FBillState in (");
        querySql.append(3);
        querySql.append(",");
        querySql.append(2);
        querySql.append(")");
        if (endDate != null) {
            querySql.append(" and FbizDate <= {");
            querySql.append(TypeConversionUtils.objToDate((Object)endDate));
            querySql.append("}");
        }
        querySql.append(" union all ");
        querySql.append(" select sum(0-FFeeAmount) SubResult from T_CAS_FundsMoveBill ");
        querySql.append(" where FFeeAcctViewID = '");
        querySql.append(accountViewId);
        querySql.append("' and FCompanyID = '");
        querySql.append(companyId);
        querySql.append("' and FFeeCurrencyID = '");
        querySql.append(currencyId);
        querySql.append("' and FBillState in (");
        querySql.append(3);
        querySql.append(",");
        querySql.append(2);
        querySql.append(")");
        if (endDate != null) {
            querySql.append(" and FbizDate <= {");
            querySql.append(TypeConversionUtils.objToDate((Object)endDate));
            querySql.append("}");
        }
        sql.append(" select sum(SubResult) Result from ( ");
        sql.append(querySql);
        sql.append(") SubQuery");
        BigDecimal result = SysConstant.BIGZERO;
        if (sql != null) {
            result = this.exeQuerySql(ctx, sql.toString());
        }
        return result;
    }

    @Override
    protected BigDecimal _getTotalAmtByAccount(Context ctx, String companyId, String accountBankId, String currencyId, java.util.Date endDate) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        StringBuffer querySql = new StringBuffer();
        querySql.append(" select sum(FActRecAmt) SubResult from t_cas_receivingbill ");
        querySql.append(" where FPayeeAccountBankID = '");
        querySql.append(accountBankId);
        querySql.append("' and FCompanyID = '");
        querySql.append(companyId);
        querySql.append("' and FCurrencyId = '");
        querySql.append(currencyId);
        querySql.append("' and fbillstatus in (");
        querySql.append(11);
        querySql.append(",");
        querySql.append(12);
        querySql.append(")");
        if (endDate != null) {
            querySql.append(" and FbizDate <= {");
            querySql.append(TypeConversionUtils.objToDate((Object)endDate));
            querySql.append("}");
        }
        querySql.append(" and FISINITIALIZEBILL=0 ");
        querySql.append(" union all ");
        querySql.append(" select 0-sum(FActualPayAmount) SubResult from t_cas_paymentbill ");
        querySql.append(" where FPayerAccountBankID = '");
        querySql.append(accountBankId);
        querySql.append("' and FCompanyID = '");
        querySql.append(companyId);
        querySql.append("' and FCurrencyId = '");
        querySql.append(currencyId);
        querySql.append("' and fbillstatus in (");
        querySql.append(11);
        querySql.append(",");
        querySql.append(8);
        querySql.append(",");
        querySql.append(12);
        querySql.append(")");
        if (endDate != null) {
            querySql.append(" and FbizDate <= {");
            querySql.append(TypeConversionUtils.objToDate((Object)endDate));
            querySql.append("}");
        }
        querySql.append(" and FISINITIALIZEBILL=0 ");
        querySql.append(" union all ");
        querySql.append(" select 0-sum(FActRecAmt) SubResult from t_cas_receivingbill ");
        querySql.append(" where FPayerAccountBankID = '");
        querySql.append(accountBankId);
        querySql.append("' and FCompanyID = '");
        querySql.append(companyId);
        querySql.append("' and FCurrencyId = '");
        querySql.append(currencyId);
        querySql.append("' and fbillstatus in (");
        querySql.append(11);
        querySql.append(",");
        querySql.append(12);
        querySql.append(")");
        if (endDate != null) {
            querySql.append(" and FbizDate <= {");
            querySql.append(TypeConversionUtils.objToDate((Object)endDate));
            querySql.append("}");
        }
        querySql.append(" and FISINITIALIZEBILL=0 ");
        querySql.append(" union all ");
        querySql.append(" select sum(FActualPayAmount) SubResult from t_cas_paymentbill ");
        querySql.append(" where FPayeeAccountBankOID = '");
        querySql.append(accountBankId);
        querySql.append("' and FCompanyID = '");
        querySql.append(companyId);
        querySql.append("' and FCurrencyId = '");
        querySql.append(currencyId);
        querySql.append("' and fbillstatus in (");
        querySql.append(11);
        querySql.append(",");
        querySql.append(8);
        querySql.append(",");
        querySql.append(12);
        querySql.append(")");
        if (endDate != null) {
            querySql.append(" and FbizDate <= {");
            querySql.append(TypeConversionUtils.objToDate((Object)endDate));
            querySql.append("}");
        }
        querySql.append(" and FISINITIALIZEBILL=0 ");
        querySql.append(" union all ");
        querySql.append(" select sum(FBuyAmount) SubResult from T_CAS_FundsMoveBill ");
        querySql.append(" where FBuyBankAccount = '");
        querySql.append(accountBankId);
        querySql.append("' and FCompanyID = '");
        querySql.append(companyId);
        querySql.append("' and FBuyCurrency = '");
        querySql.append(currencyId);
        querySql.append("' and FBillState in (");
        querySql.append(3);
        querySql.append(",");
        querySql.append(2);
        querySql.append(")");
        if (endDate != null) {
            querySql.append(" and FbizDate <= {");
            querySql.append(TypeConversionUtils.objToDate((Object)endDate));
            querySql.append("}");
        }
        querySql.append(" union all ");
        querySql.append(" select sum(0-FSellAmount) SubResult from T_CAS_FundsMoveBill ");
        querySql.append(" where FSellBankAccount = '");
        querySql.append(accountBankId);
        querySql.append("' and FCompanyID = '");
        querySql.append(companyId);
        querySql.append("' and FSellCurrencyID = '");
        querySql.append(currencyId);
        querySql.append("' and FBillState in (");
        querySql.append(3);
        querySql.append(",");
        querySql.append(2);
        querySql.append(")");
        if (endDate != null) {
            querySql.append(" and FbizDate <= {");
            querySql.append(TypeConversionUtils.objToDate((Object)endDate));
            querySql.append("}");
        }
        querySql.append(" union all ");
        querySql.append(" select sum(0-FFeeAmount) SubResult from T_CAS_FundsMoveBill ");
        querySql.append(" where FFeeBankAccountID = '");
        querySql.append(accountBankId);
        querySql.append("' and FCompanyID = '");
        querySql.append(companyId);
        querySql.append("' and FFeeCurrencyID = '");
        querySql.append(currencyId);
        querySql.append("' and FBillState in (");
        querySql.append(3);
        querySql.append(",");
        querySql.append(2);
        querySql.append(")");
        if (endDate != null) {
            querySql.append(" and FbizDate <= {");
            querySql.append(TypeConversionUtils.objToDate((Object)endDate));
            querySql.append("}");
        }
        querySql.append(" union all ");
        querySql.append(" select sum(0-FAmount) SubResult from t_cas_agentpaybill ");
        querySql.append(" where FPayBankAccountID = '");
        querySql.append(accountBankId);
        querySql.append("' and FCompanyID = '");
        querySql.append(companyId);
        querySql.append("' and FCurrencyId = '");
        querySql.append(currencyId);
        querySql.append("' and fbillstatus in (");
        querySql.append(11);
        querySql.append(",");
        querySql.append(12);
        querySql.append(")");
        if (endDate != null) {
            querySql.append(" and FbizDate <= {");
            querySql.append(TypeConversionUtils.objToDate((Object)endDate));
            querySql.append("}");
        }
        querySql.append(" union all");
        querySql.append(" select sum(FAmount) SubResult from T_FS_SettlementBill ");
        querySql.append(" where FPayeeBankAcctID = '").append(accountBankId);
        querySql.append("' and FCompanyID = '").append(companyId);
        querySql.append("' and FCurrencyId = '").append(currencyId);
        querySql.append("' and FType =").append(1);
        querySql.append(" and FHasEffected =1 ");
        querySql.append(" and FCashierID is  null ");
        if (endDate != null) {
            querySql.append(" and FbizDate <= {");
            querySql.append(TypeConversionUtils.objToDate((Object)endDate));
            querySql.append("}");
        }
        querySql.append(" union all ");
        querySql.append(" select 0-sum(FAmount) SubResult from T_FS_SettlementBill ");
        querySql.append(" where FPayerBankAcctID = '").append(accountBankId);
        querySql.append("' and FCompanyID = '").append(companyId);
        querySql.append("' and FCurrencyId = '").append(currencyId);
        querySql.append("' and FType in (").append(2).append(",").append(10);
        querySql.append(",").append(100).append(")");
        querySql.append(" and FHasEffected =1 ");
        querySql.append(" and FCashierID is  null ");
        if (endDate != null) {
            querySql.append(" and FbizDate <= {");
            querySql.append(TypeConversionUtils.objToDate((Object)endDate));
            querySql.append("}");
        }
        sql.append(" select sum(SubResult) Result from ( ");
        sql.append(querySql);
        sql.append(") SubQuery");
        BigDecimal result = SysConstant.BIGZERO;
        if (sql != null) {
            result = this.exeQuerySql(ctx, sql.toString());
        }
        return result;
    }

    @Override
    protected Map _getPeriodRange(Context ctx, CompanyOrgUnitInfo company, SystemEnum system) throws BOSException, EASBizException {
        ctx = this.changeContext(ctx);
        HashMap<String, Object> allMap = new HashMap<String, Object>();
        Map map = null;
        map = !company.isIsBizUnit() ? this._getPeriodRangeUnion(ctx, company, system) : this._getPeriodRangeNormal(ctx, 3, this._getStartPeriod(ctx, company, system), this._getCurrentPeriod(ctx, company, system), company);
        int maxYear = 0;
        int maxPeriod = 0;
        for (Object key : map.keySet()) {
            if (!(key instanceof Integer)) continue;
            int buf = (Integer)key;
            maxYear = maxYear < buf ? buf : maxYear;
        }
        int[] value = (int[])map.get(new Integer(maxYear));
        int n = value.length;
        for (int i = 0; i < n; ++i) {
            maxPeriod = maxPeriod < value[i] ? value[i] : maxPeriod;
        }
        HashMap<Integer, int[]> map2 = new HashMap<Integer, int[]>();
        map2.putAll(map);
        allMap.put("usedPeriod", map);
        allMap.put("queryPeriod", map2);
        allMap.put("currentPeriod", new int[]{maxYear, maxPeriod});
        String periodType = company.getAccountPeriodType().getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("select A.c, A.FPeriodYear, B.FPeriodNumber from").append("\n (select count(1) c, FPeriodYear from t_bd_period where FTypeID=? and FPeriodYear*100+FPeriodNumber>? group by FPeriodYear) A").append("\n inner join t_bd_period B on B.FPeriodYear=A.FPeriodYear and B.FPeriodYear*100+B.FPeriodNumber>? and B.FTypeID=?").append("\n order by A.FPeriodYear, B.FPeriodNumber");
        RptRowSet rs = this.executeQuery(sb.toString(), new SqlParams().addString(periodType).addInt(maxYear * 100 + maxPeriod).addInt(maxYear * 100 + maxPeriod).addString(periodType), ctx);
        int i = 0;
        while (rs.next()) {
            int n2 = rs.getInt("c");
            if (n2 == 0) continue;
            int year = rs.getInt("FPeriodYear");
            int[] p = new int[n2];
            p[0] = rs.getInt("FPeriodNumber");
            i = 0;
            while (i++ < n2 - 1) {
                rs.next();
                p[i] = rs.getInt("FPeriodNumber");
            }
            Integer kk = new Integer(year);
            if (map2.containsKey(kk)) {
                int[] op = (int[])map2.get(kk);
                int[] np = new int[op.length + p.length];
                System.arraycopy(op, 0, np, 0, op.length);
                System.arraycopy(p, 0, np, op.length, p.length);
                p = np;
            }
            int max = 0;
            int min = Integer.MAX_VALUE;
            for (int m = 0; m < p.length; ++m) {
                max = max < p[m] ? p[m] : max;
                min = min > p[m] ? p[m] : min;
            }
            map2.put(kk, new int[]{min, max});
        }
        return allMap;
    }

    protected Map _getPeriodRangeUnion(Context ctx, CompanyOrgUnitInfo company, SystemEnum system) throws BOSException, EASBizException {
        HashMap<Integer, int[]> hashMap;
        String companyIds = company.getId().toString();
        HashMap<Integer, int[]> map = new HashMap<Integer, int[]>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT TP.FPeriodYear, \t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tMin(TP.FPeriodNumber) MinNumber, \t\t\t\t\t\t\t\r\n");
        sql.append("\tMax(TP.FPeriodNumber) MaxNumber \t\t\t\t\t\t\t\r\n");
        sql.append("FROM T_BD_Period TP ,\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("(SELECT Min(TPS.FBeginDate) FBeginDate, \t\t\t\t\t\t\r\n");
        sql.append("\t\tMax(TPC.FBeginDate) FEndDate\t\t\t\t\t \t\t\t\r\n");
        sql.append(" FROM T_BD_SystemStatusCtrol TSSC\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tinner join t_bd_systemstatus tsst \r\n");
        sql.append(" on TSSC.FSystemStatusID=tsst.fid and TSST.fname=?\t\r\n");
        sql.append("\tINNER JOIN T_BD_Period TPS\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tON TSSC.FStartPeriodID = TPS.FID \t\t\t\t\t\t\t\r\n");
        sql.append("\tINNER JOIN T_BD_Period TPC\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tON TSSC.FCurrentPeriodID = TPC.FID\t\t\t\t\t\t\t\r\n");
        sql.append("\tINNER JOIN T_Org_BaseUnit TC\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tON TSSC.FCompanyID = TC.FID\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tINNER JOIN T_Org_structure SC \t\t\t\t\t\t\t\t\r\n");
        sql.append("\tON TSSC.FCompanyID = SC.FUnitId\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tINNER JOIN T_Org_structure SP\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tON CHARINDEX(SP.FLongNumber||'!',SC.FLongNumber) = 1\t\t\r\n");
        sql.append("\tinner join t_org_company cc on cc.fid=sc.funitId and cc.fIsBizUnit=1 and cc.fIsCompanyOrgUnit=1  \r\n");
        sql.append(" WHERE SP.FUnitId = ?\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tAND TPS.FTypeID = ?\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("\tAND TPC.FTypeID = ?\t\t\t\t\t\t\t\t\t\t\t\r\n");
        if (companyIds != null && companyIds.length() > 0) {
            sql.append("    AND cc.fid in(");
            sql.append("'");
            sql.append(companyIds);
            sql.append("'");
            sql.append(")            \r\n");
        }
        sql.append("\t) TPRange\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("WHERE TP.FBeginDate >= TPRange.FBeginDate\t\t\t\t\t\t\r\n");
        sql.append("\tAND TP.FBeginDate <= TPRange.FEndDate\t\t\t\t\t\t\t\r\n");
        sql.append("\tAND TP.FTypeID = ?\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("GROUP BY TP.FPeriodYear\t\t\t\t\t\t\t\t\t\t\t\r\n");
        sql.append("ORDER BY TP.FPeriodYear \t\t\t\t\t\t\t\t\t\t\r\n");
        SqlParams parameter = new SqlParams();
        parameter.addInt(system.getValue());
        parameter.addString(company.getId().toString());
        parameter.addString(company.getAccountPeriodType().getId().toString());
        parameter.addString(company.getAccountPeriodType().getId().toString());
        parameter.addString(company.getAccountPeriodType().getId().toString());
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            stmt = con.prepareStatement(parameter.getSqlWithParams(sql.toString()));
            stmt.setFetchSize(100);
            rs = stmt.executeQuery();
            int[] yearRange = new int[]{-1, -1};
            while (rs.next()) {
                int year = rs.getInt("FPeriodYear");
                yearRange[0] = yearRange[0] == -1 ? year : yearRange[0];
                yearRange[1] = year;
                int[] periodRange = new int[]{rs.getInt("MinNumber"), rs.getInt("MaxNumber")};
                if (periodRange[0] <= 0 || periodRange[1] <= 0) {
                    throw new RptException(RptException.PERIOD_ERROR);
                }
                map.put(new Integer(year), periodRange);
            }
            if (yearRange[0] <= 0 || yearRange[1] <= 0 || map.size() <= 0) {
                throw new RptException(RptException.PERIOD_ERROR);
            }
            hashMap = map;
        }
        catch (SQLException sqle) {
            try {
                sqle.setNextException(new SQLException("The query sql is:" + sql.toString()));
                throw new SQLDataException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return hashMap;
    }

    protected Map _getPeriodRangeNormal(Context ctx, int type, PeriodInfo startPeriod, PeriodInfo currentPeriod, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        HashMap<Integer, int[]> map = new HashMap<Integer, int[]>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT TP.FPeriodYear, \r\n");
        sql.append("\tMin(TP.FPeriodNumber) MinNumber, \r\n");
        sql.append("\tMax(TP.FPeriodNumber) MaxNumber \r\n");
        sql.append("FROM T_BD_Period TP \r\n");
        sql.append("WHERE TP.FTypeID = ? \r\n");
        if ((type == 1 || type == 3) && startPeriod != null) {
            sql.append(" AND (TP.FPeriodYear>? or (TP.FPeriodYear=?  and TP.FPeriodNumber >= ?)) \r\n");
        }
        if ((type == 2 || type == 3) && currentPeriod != null) {
            sql.append(" AND (TP.FPeriodYear<? or(TP.FPeriodYear=? and TP.FPeriodNumber <= ?)) \r\n");
        }
        sql.append("GROUP BY TP.FPeriodYear \r\n");
        sql.append("ORDER BY TP.FPeriodYear \r\n");
        SqlParams parameter = new SqlParams();
        parameter.addString(company.getAccountPeriodType().getId().toString());
        if ((type == 1 || type == 3) && startPeriod != null) {
            parameter.addInt(startPeriod.getPeriodYear());
            parameter.addInt(startPeriod.getPeriodYear());
            parameter.addInt(startPeriod.getPeriodNumber());
        }
        if ((type == 2 || type == 3) && currentPeriod != null) {
            parameter.addInt(currentPeriod.getPeriodYear());
            parameter.addInt(currentPeriod.getPeriodYear());
            parameter.addInt(currentPeriod.getPeriodNumber());
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            stmt = con.prepareStatement(parameter.getSqlWithParams(sql.toString()));
            stmt.setFetchSize(100);
            rs = stmt.executeQuery();
            int[] yearRange = new int[]{-1, -1};
            while (rs.next()) {
                int year = rs.getInt("FPeriodYear");
                yearRange[0] = yearRange[0] == -1 ? year : yearRange[0];
                yearRange[1] = year;
                int[] periodRange = new int[]{rs.getInt("MinNumber"), rs.getInt("MaxNumber")};
                if (periodRange[0] <= 0 || periodRange[1] <= 0) {
                    throw new RptException(RptException.PERIOD_ERROR);
                }
                map.put(new Integer(year), periodRange);
            }
            if (yearRange[0] <= 0 || yearRange[1] <= 0 || yearRange[0] < startPeriod.getPeriodYear() || yearRange[1] > currentPeriod.getPeriodYear() || map.size() <= 0) {
                throw new RptException(RptException.PERIOD_ERROR);
            }
            HashMap<Integer, int[]> hashMap = map;
            this.close(con, stmt, rs);
            return hashMap;
        }
        catch (SQLException sqle) {
            try {
                sqle.setNextException(new SQLException("The query sql is:" + sql.toString()));
                throw new SQLDataException(sqle);
            }
            catch (Throwable throwable) {
                this.close(con, stmt, rs);
                throw throwable;
            }
        }
    }

    @Override
    protected PeriodInfo _getStartPeriod(Context ctx, CompanyOrgUnitInfo company, SystemEnum system) throws BOSException, EASBizException {
        PeriodInfo pi = SystemStatusCtrolUtils.getStartPeriod((Context)this.changeContext(ctx), (SystemEnum)system, (CompanyOrgUnitInfo)company);
        if (pi == null) {
            throw new RptException(RptException.PERIOD_ERROR);
        }
        return pi;
    }

    @Override
    protected PeriodInfo _getCurrentPeriod(Context ctx, CompanyOrgUnitInfo company, SystemEnum system) throws BOSException, EASBizException {
        PeriodInfo pi = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.changeContext(ctx), (SystemEnum)system, (CompanyOrgUnitInfo)company);
        if (pi == null) {
            throw new RptException(RptException.PERIOD_ERROR);
        }
        return pi;
    }

    protected String getRptUIName() {
        return null;
    }

    protected String getDefRptUIName() {
        return this.getClass().getName();
    }

    protected Context changeContext(Context old) {
        String uiName = this.getRptUIName();
        if (uiName == null) {
            return old;
        }
        Context newCtx = null;
        try {
            newCtx = EASEjbFactory.getCtx((String)uiName, (Context)old);
        }
        catch (Exception e) {
            this.logger.error((Object)"EASEjbFactory.getCtx fail!", (Throwable)e);
            newCtx = old;
        }
        return newCtx;
    }

    protected void close(Connection con) {
        this.close(con, null, null);
    }

    protected void close(Statement statement) {
        this.close(null, statement, null);
    }

    protected void close(ResultSet rs) {
        this.close(null, null, rs);
    }

    protected void close(Connection con, ResultSet rs) {
        this.close(con, null, rs);
    }

    protected void close(Connection con, Statement statement) {
        this.close(con, statement, null);
    }

    protected void close(Connection con, Statement statement, ResultSet rs) {
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)con);
    }

    protected String getLoc(Context ctx) throws BOSException {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    protected RptRowSet executeQuery(String sql, SqlParams parameters, Context ctx) throws BOSException {
        return this.executeQuery(sql, parameters, 0, -1, this.changeContext(ctx));
    }

    protected RptRowSet executeQuery(String sql, SqlParams parameters, int from, int length, Context ctx) throws BOSException {
        Connection con = this.getConnection(ctx);
        try {
            RptRowSet rptRowSet = DBUtil.executeQuery((String)sql, (SqlParams)parameters, (int)from, (int)length, (Connection)con);
            return rptRowSet;
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + sql));
            throw new SQLDataException(e);
        }
        finally {
            this.close(con);
        }
    }
}

