/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fi.cas.CasDataException;
import com.kingdee.eas.fi.cas.CashDataSourceEnum;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.app.AbstractCashManagementNewFacadeControllerBean;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMQuerySqlBuilder;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.fp.FPFormulaInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class CashManagementNewFacadeControllerBean
extends AbstractCashManagementNewFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ivt.app.RptCapitalSumFacadeControllerBean");
    private static final String resPath = "com.kingdee.eas.fm.common.FMResource";
    private List listIdNumberCompany = new ArrayList();
    private List listIdNumberCurrency = new ArrayList();
    private List listIdNumberBankAcct = new ArrayList();
    private List listIdNumberAcctView = new ArrayList();

    private Locale getLocale() {
        return ContextUtils.getLocaleFromEnv();
    }

    @Override
    protected Map _cash(Context ctx, Map paramMap) throws BOSException, EASBizException {
        Map newMap = this.prepare(paramMap);
        Set companyIdSet = this.getCompanyIds(ctx, ((StringBuffer)newMap.get("companyNumber")).toString());
        if (companyIdSet == null) {
            throw new CasDataException(CasDataException.NULL_COMPANY);
        }
        StringBuffer sbBankAcct = (StringBuffer)newMap.get("bankAcctNumber");
        if (sbBankAcct != null) {
            Set set = this.getBankAcctIds(ctx, sbBankAcct.toString());
        }
        String currencyId = this.getCurrencyId(ctx, newMap.get("currencyNumber").toString());
        String acctNum = "";
        if ((StringBuffer)newMap.get("accountNum") != null) {
            acctNum = ((StringBuffer)newMap.get("accountNum")).toString();
        }
        this.setAcctViewIDs(acctNum, ctx);
        Date fromDate = (Date)newMap.get("beginDate");
        Date toDate = (Date)newMap.get("endDate");
        Map resultMap = this.queryByDay(ctx, fromDate, toDate, null, 1, null, companyIdSet, currencyId, true, 4, 0);
        this.processResult(resultMap, (IObjectCollection)paramMap.get("col"));
        return null;
    }

    private void processResult(Map resultMap, IObjectCollection coll) {
        Object[] params = null;
        String companyNumber = null;
        CashDataSourceEnum dataSource = null;
        String accountNum = null;
        String bankAcctNum = null;
        String currencyNum = null;
        Date beginDate = null;
        Date endDate = null;
        CashDataTypeEnum dataType = null;
        String FCOMPANYID = "";
        String FACCOUNTVIEWID = "";
        String FCURRENCYID = "";
        String FACCOUNTBANKID = "";
        for (int i = 0; i < coll.size(); ++i) {
            String key2;
            String key1;
            FPFormulaInfo info = (FPFormulaInfo)coll.getObject(i);
            params = info.getParams();
            companyNumber = (String)params[0];
            FCOMPANYID = this.getIDByNumber_Company(companyNumber);
            dataSource = (CashDataSourceEnum)((Object)params[1]);
            accountNum = (String)params[3];
            FACCOUNTVIEWID = this.getIDByNumber_AcctView(accountNum);
            bankAcctNum = (String)params[4];
            FACCOUNTBANKID = this.getIDByNumber_BankAcct(bankAcctNum);
            currencyNum = (String)params[5];
            FCURRENCYID = this.getIDByNumber_Currency(currencyNum);
            beginDate = (Date)params[6];
            endDate = (Date)params[7];
            dataType = (CashDataTypeEnum)((Object)params[8]);
            BigDecimal result = FMConstants.ZERO;
            if (dataType == CashDataTypeEnum.Y) {
                key1 = this.genKey(FCOMPANYID, FACCOUNTVIEWID, FCURRENCYID, FACCOUNTBANKID);
                key2 = this.genKey(FCOMPANYID, "null", FCURRENCYID, FACCOUNTBANKID);
                result = (BigDecimal)resultMap.get(key1);
                if (result == null && (result = (BigDecimal)resultMap.get(key2)) == null) {
                    result = FMConstants.ZERO;
                }
            } else if (dataType == CashDataTypeEnum.C) {
                key1 = this.genKey(FCOMPANYID, FACCOUNTVIEWID, FCURRENCYID, FACCOUNTBANKID) + "fdaystartamt";
                key2 = this.genKey(FCOMPANYID, "null", FCURRENCYID, FACCOUNTBANKID) + "fdaystartamt";
                result = (BigDecimal)resultMap.get(key1);
                if (result == null && (result = (BigDecimal)resultMap.get(key2)) == null) {
                    result = FMConstants.ZERO;
                }
            } else if (dataType == CashDataTypeEnum.JF) {
                key1 = this.genKey(FCOMPANYID, FACCOUNTVIEWID, FCURRENCYID, FACCOUNTBANKID) + "fdebitamt";
                key2 = this.genKey(FCOMPANYID, "null", FCURRENCYID, FACCOUNTBANKID) + "fdebitamt";
                result = (BigDecimal)resultMap.get(key1);
                if (result == null && (result = (BigDecimal)resultMap.get(key2)) == null) {
                    result = FMConstants.ZERO;
                }
            } else if (dataType == CashDataTypeEnum.DF) {
                key1 = this.genKey(FCOMPANYID, FACCOUNTVIEWID, FCURRENCYID, FACCOUNTBANKID) + "fcreditamt";
                key2 = this.genKey(FCOMPANYID, "null", FCURRENCYID, FACCOUNTBANKID) + "fcreditamt";
                result = (BigDecimal)resultMap.get(key1);
                if (result == null && (result = (BigDecimal)resultMap.get(key2)) == null) {
                    result = FMConstants.ZERO;
                }
            }
            info.setResult(result);
        }
    }

    private String getIDByNumber_Company(String companyNumber) {
        for (int i = 0; i < this.listIdNumberCompany.size(); ++i) {
            IdToNumber_Company info = (IdToNumber_Company)this.listIdNumberCompany.get(i);
            if (!info.getNumber().equals(companyNumber)) continue;
            return info.getId();
        }
        return "";
    }

    private String getIDByNumber_Currency(String currencyNumber) {
        for (int i = 0; i < this.listIdNumberCurrency.size(); ++i) {
            IdToNumber_Currency info = (IdToNumber_Currency)this.listIdNumberCurrency.get(i);
            if (!info.getNumber().equals(currencyNumber)) continue;
            return info.getId();
        }
        return "";
    }

    private String getIDByNumber_BankAcct(String bankAcctNumber) {
        for (int i = 0; i < this.listIdNumberBankAcct.size(); ++i) {
            IdToNumber_AcctBank info = (IdToNumber_AcctBank)this.listIdNumberBankAcct.get(i);
            if (!info.getNumber().equals(bankAcctNumber)) continue;
            return info.getId();
        }
        return "0";
    }

    private String getIDByNumber_AcctView(String number) {
        for (int i = 0; i < this.listIdNumberAcctView.size(); ++i) {
            IdToNumber_AcctView info = (IdToNumber_AcctView)this.listIdNumberAcctView.get(i);
            if (!info.getNumber().equals(number)) continue;
            return info.getId();
        }
        return "";
    }

    public Map queryByDay(Context ctx, Date fromDate, Date toDate, Set accountPropertyIdSet, int amountUnit, Set bankIdSet, Set companyAllIdSet, String currencyId, boolean includeCash, int groupType, int level) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> returnMap = new HashMap<String, BigDecimal>();
        CompanyOrgUnitInfo curCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        PeriodInfo beginPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)fromDate, (IObjectPK)new ObjectUuidPK(curCompany.getId()));
        StringBuffer sbState = new StringBuffer();
        sbState.append("SELECT ss.fcompanyid , sp.fid spfid,sp.FPERIODYEAR*100 + sp.FPERIODNUMBER startperiod,cp.fid cpfid, cp.FPERIODYEAR*100 + cp.FPERIODNUMBER curPeriod ");
        sbState.append(" FROM t_bd_systemstatusctrol ss, t_bd_period sp, t_bd_period cp");
        sbState.append(" WHERE ss.fstartperiodid = sp.fid AND ss.fcurrentperiodid = cp.fid");
        sbState.append(" and ss.FSYSTEMSTATUSID in (select fid from t_bd_systemstatus  where fname =7)");
        sbState.append(" and ss.fisstart=1");
        sbState.append(" and ");
        sbState.append(FMHelper.buildIn((String)"ss.fcompanyid", (Object[])companyAllIdSet.toArray()));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbState.toString());
        HashMap<String, HashSet<String>> otherCompany = new HashMap<String, HashSet<String>>();
        HashSet<String> okCompany = new HashSet<String>();
        HashSet<String> allCompany = new HashSet<String>();
        try {
            while (rs.next()) {
                if (beginPeriodInfo == null) {
                    String pkey = rs.getString("spfid");
                    HashSet<String> csSet = (HashSet<String>)otherCompany.get(pkey);
                    if (csSet == null) {
                        csSet = new HashSet<String>();
                        otherCompany.put(pkey, csSet);
                    }
                    csSet.add(rs.getString("fcompanyid"));
                    allCompany.add(rs.getString("fcompanyid"));
                    continue;
                }
                int beginKey = beginPeriodInfo.getPeriodYear() * 100 + beginPeriodInfo.getPeriodNumber();
                if (beginKey >= rs.getInt("startperiod") && beginKey <= rs.getInt("curPeriod")) {
                    okCompany.add(rs.getString("fcompanyid"));
                    allCompany.add(rs.getString("fcompanyid"));
                }
                if (beginKey <= rs.getInt("curPeriod")) continue;
                String pkey = rs.getString("cpfid");
                HashSet<String> csSet = (HashSet<String>)otherCompany.get(pkey);
                if (csSet == null) {
                    csSet = new HashSet<String>();
                    otherCompany.put(pkey, csSet);
                }
                csSet.add(rs.getString("fcompanyid"));
                allCompany.add(rs.getString("fcompanyid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        BigDecimal limit = FMConstants.ZERO;
        String tbl = this.getTableTableNameByDate(ctx);
        this.genBalanceByDate(ctx, tbl, okCompany, bankIdSet, beginPeriodInfo, currencyId, fromDate, toDate);
        for (Map.Entry element : otherCompany.entrySet()) {
            String period = (String)element.getKey();
            Set otherCompanySet = (Set)element.getValue();
            PeriodInfo periodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(period));
            if (periodInfo == null) continue;
            this.genBalanceByDate(ctx, tbl, otherCompanySet, bankIdSet, periodInfo, currencyId, fromDate, toDate);
        }
        FMQuerySqlBuilder sb = this.genResultByDate(ctx, amountUnit, groupType, includeCash, level, curCompany, limit, tbl);
        ResultSet rs1 = sb.exeQuery(ctx);
        try {
            String FCOMPANYID = "";
            String FACCOUNTVIEWID = "";
            String FCURRENCYID = "";
            String FACCOUNTBANKID = "";
            BigDecimal endBalance = FMConstants.ZERO;
            BigDecimal startBalance = FMConstants.ZERO;
            BigDecimal debitBalance = FMConstants.ZERO;
            BigDecimal creditBalance = FMConstants.ZERO;
            while (rs1.next()) {
                FCOMPANYID = rs1.getString("FCOMPANYID");
                FACCOUNTVIEWID = rs1.getString("FACCOUNTVIEWID");
                FCURRENCYID = rs1.getString("FCURRENCYID");
                FACCOUNTBANKID = rs1.getString("FACCOUNTBANKID");
                endBalance = rs1.getBigDecimal("FDAYENDAMT");
                startBalance = rs1.getBigDecimal("fdaystartamt");
                debitBalance = rs1.getBigDecimal("fdebitamt");
                creditBalance = rs1.getBigDecimal("fcreditamt");
                String key1 = this.genKey(FCOMPANYID, FACCOUNTVIEWID, FCURRENCYID, FACCOUNTBANKID);
                String key2 = this.genKey(FCOMPANYID, "null", FCURRENCYID, FACCOUNTBANKID);
                returnMap.put(key1, endBalance);
                returnMap.put(key2, endBalance);
                returnMap.put(key1 + "fdaystartamt", startBalance);
                returnMap.put(key2 + "fdaystartamt", startBalance);
                returnMap.put(key1 + "fdebitamt", debitBalance);
                returnMap.put(key2 + "fdebitamt", debitBalance);
                returnMap.put(key1 + "fcreditamt", creditBalance);
                returnMap.put(key2 + "fcreditamt", creditBalance);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return returnMap;
    }

    private String genKey(String fcompanyid, String faccountviewid, String fcurrencyid, String faccountbankid) {
        StringBuffer sb = new StringBuffer();
        sb.append("fcompanyid--");
        if (fcompanyid == null) {
            sb.append("null");
        } else {
            sb.append(fcompanyid);
        }
        sb.append("faccountviewid--");
        if (faccountviewid == null) {
            sb.append("null");
        } else {
            sb.append(faccountviewid);
        }
        sb.append("fcurrencyid--");
        if (fcurrencyid == null) {
            sb.append("null");
        } else {
            sb.append(fcurrencyid);
        }
        sb.append("faccountbankid--");
        if (faccountbankid == null) {
            sb.append("null");
        } else {
            sb.append(faccountbankid);
        }
        return sb.toString();
    }

    private void prepareDate(Context ctx, int groupType, int level, String tbl) throws BOSException {
        String sql = "update " + tbl + " set (fbankid, FAccountPropertyID) = (select t_bd_accountbanks.fbank ,t_bd_accountbanks.FPropertyID from t_bd_accountbanks where t_bd_accountbanks.fid = " + tbl + ".faccountbankid)";
        DbUtil.execute((Context)ctx, (String)sql);
        String sqluplevel = null;
        if (level > 0) {
            switch (groupType) {
                case 1: {
                    sqluplevel = "update " + tbl + " set (fbankid,FKey) =(select p.fid,null from  t_bd_bank p, t_bd_bank c where charindex(p.flongnumber||'!',c.flongnumber)=1 and p.flevel =" + level + " and c.fid=" + tbl + ".fbankid)";
                    DbUtil.execute((Context)ctx, (String)sqluplevel);
                    break;
                }
                case 2: {
                    sqluplevel = "update " + tbl + " set (fcompanyid,FKey) =(select p.fid, null from  t_org_company p, t_org_company c where charindex(p.flongnumber||'!',c.flongnumber)=1 and p.flevel =" + level + " and c.fid=" + tbl + ".fCompanyid)";
                    DbUtil.execute((Context)ctx, (String)sqluplevel);
                    break;
                }
                case 3: {
                    sqluplevel = "update " + tbl + " set (fcompanyid,FKey) =(select p.fid, null from  t_org_company p, t_org_company c where charindex(p.flongnumber||'!',c.flongnumber)=1 and p.flevel =" + level + " and c.fid=" + tbl + ".fCompanyid)";
                    DbUtil.execute((Context)ctx, (String)sqluplevel);
                    break;
                }
                default: {
                    sqluplevel = "update " + tbl + " set (fbankid,FKey) =(select p.fid,null from  t_bd_bank p, t_bd_bank c where charindex(p.flongnumber||'!',c.flongnumber)=1 and p.flevel =" + level + " and c.fid=" + tbl + ".fbankid)";
                    DbUtil.execute((Context)ctx, (String)sqluplevel);
                    DbUtil.execute((Context)ctx, (String)sqluplevel);
                }
            }
        }
    }

    private FMQuerySqlBuilder genResultByDate(Context ctx, int amountUnit, int groupType, boolean includeCash, int level, CompanyOrgUnitInfo curCompany, BigDecimal limit, String tbl) throws BOSException {
        this.prepareDate(ctx, groupType, level, tbl);
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" SELECT isnull(jb.fcompanyid,'0') fcompanyid , jb.faccountviewid, jb.fcurrencyid, isnull(jb.faccountbankid,'0') faccountbankid,");
        sb.appendSql(CashManagementNewFacadeControllerBean.appUnit(" jb.fdaystartamt", " fdaystartamt", amountUnit));
        sb.appendSql(CashManagementNewFacadeControllerBean.appUnit(" jb.fdebitamt", " fdebitamt", amountUnit));
        sb.appendSql(CashManagementNewFacadeControllerBean.appUnit(" jb.fcreditamt", " fcreditamt", amountUnit));
        sb.appendSql(CashManagementNewFacadeControllerBean.appUnit(" jb.fdayendamt", "fdayendamt", amountUnit));
        sb.appendSql(" isnull(jb.FAccountPropertyID,'00') FAccountPropertyID,");
        sb.appendSql(" isnull(jb.fbankid,'00') fbankId");
        sb.appendSql(" FROM " + tbl + " jb ");
        sb.appendSql(" where 1=1");
        if (!includeCash) {
            sb.appendSql(" and jb.faccountbankid is not null");
        }
        return sb;
    }

    private String getTableTableNameByDate(Context ctx) throws BOSException {
        String tbl = this.getTempTableName("casbalance", ctx);
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append("CREATE TABLE ");
        createTableSql.append(tbl);
        createTableSql.append("\t(");
        createTableSql.append("FCOMPANYID        varchar(44),");
        createTableSql.append("FKey        varchar(44),");
        createTableSql.append("FBANKID           varchar(44),");
        createTableSql.append("FACCOUNTVIEWID    varchar(44),");
        createTableSql.append("FAccountPropertyID    varchar(44),");
        createTableSql.append("FCURRENCYID       varchar(44),");
        createTableSql.append("FACCOUNTBANKID    varchar(44),");
        createTableSql.append("FPERIODID         varchar(44),");
        createTableSql.append("FDAYSTARTAMT       NUMERIC(19,4) ,");
        createTableSql.append("FDEBITAMT          NUMERIC(19,4),");
        createTableSql.append("FCREDITAMT         NUMERIC(19,4),");
        createTableSql.append("FDAYENDAMT         NUMERIC(19,4) ");
        createTableSql.append(")");
        TableManagerFacadeFactory.getLocalInstance((Context)ctx).createTempTable(createTableSql.toString());
        return tbl;
    }

    public String getTempTableName(String desc, Context ctx) throws BOSException {
        return TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName(desc);
    }

    private void genBalanceByDate(Context ctx, String tbl, Set companyIdSet, Set bankids, PeriodInfo periodId, String currencyId, Date fromDate, Date toDate) throws BOSException {
        if (companyIdSet.size() == 0) {
            return;
        }
        if (periodId == null) {
            return;
        }
        FMQuerySqlBuilder sbfirst = this.getFirstPeriodByDate(companyIdSet, bankids, periodId, currencyId, tbl, fromDate, toDate);
        sbfirst.execute(ctx);
    }

    private FMQuerySqlBuilder getFirstPeriodByDate(Set companyIdSet, Set bankids, PeriodInfo beginPeriodId, String currencyId, String tbl, Date fromDate, Date toDate) {
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql("insert into ");
        sb.appendSql(tbl);
        sb.appendSql(" (");
        sb.appendSql(" fcompanyid, faccountviewid, fcurrencyid, faccountbankid,");
        sb.appendSql(" fdaystartamt,fdebitamt,");
        sb.appendSql(" fcreditamt, fdayendamt ");
        sb.appendSql(" )");
        sb.appendSql(" SELECT   s.fcompanyid, s.faccountviewid, s.fcurrencyid, s.faccountbankid, ");
        sb.appendSql(" SUM (s.fmonthstartamt),");
        sb.appendSql("  SUM (s.fmonthdebitamt), SUM (s.fmonthcreditamt), ");
        sb.appendSql("  SUM (s.fmonthstartamt) + SUM (s.fmonthdebitamt) - SUM (s.fmonthcreditamt) fmonthbalance ");
        sb.appendSql("  FROM (");
        sb.appendSql(" SELECT  jb.fcompanyid, jb.faccountviewid, jb.fcurrencyid, jb.faccountbankid,");
        sb.appendSql(" jb.fmonthstartamt,");
        sb.appendSql(" 0 fmonthdebitamt, 0 fmonthcreditamt,jb.fmonthstartamt fmonthbalance ");
        sb.appendSql("  FROM t_cas_journalbalance jb");
        sb.appendSql("  WHERE ftype in(1,2) and fisinit=0");
        sb.appendFilter("jb.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("jb.fperiodid", FMHelper.asSet((String)beginPeriodId.getId().toString()), CompareType.INCLUDE);
        sb.appendFilter("jb.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql("                  AND ( jb.faccountbankid IN (");
            sb.appendSql("        SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("            WHERE 1=1 ");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("  )");
            sb.appendSql("     OR jb.faccountbankid IS NULL");
            sb.appendSql("     )");
        }
        sb.appendSql("  UNION");
        sb.appendSql("           SELECT j.fcompanyid, j.faccountviewid, j.fcurrencyid,j.faccountbankid,");
        sb.appendSql("                  0 fmonthstartamt,");
        sb.appendSql("    SUM (fdebitamount) fmonthdebitamt, SUM (fcreditamount) fmonthcreditamt, 0 fmonthbalance ");
        sb.appendSql("             FROM t_cas_journal j");
        sb.appendSql("              WHERE 1=1 ");
        sb.appendSql(" and j.FCreateDate >={ ");
        sb.appendSql(TypeConversionUtils.objToDate((Object)fromDate).toString());
        sb.appendSql("} and j.FCreateDate <= {");
        sb.appendSql(TypeConversionUtils.objToDate((Object)toDate).toString());
        sb.appendSql("}");
        sb.appendFilter("j.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("j.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql("                  AND ( j.faccountbankid IN (");
            sb.appendSql("                                              SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("                                              WHERE 1=1 ");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("                                              )");
            sb.appendSql("                        OR j.faccountbankid IS NULL");
            sb.appendSql("                       )");
        }
        sb.appendSql(" GROUP BY j.fcompanyid, j.faccountviewid, j.fcurrencyid, j.faccountbankid ");
        sb.appendSql("  UNION");
        sb.appendSql("           SELECT j.fcompanyid, j.faccountviewid, j.fcurrencyid,j.faccountbankid,");
        sb.appendSql("                  SUM (fdebitamount-fcreditamount) fmonthstartamt,");
        sb.appendSql("    0 fmonthdebitamt, 0 fmonthcreditamt, 0 fmonthbalance ");
        sb.appendSql("             FROM t_cas_journal j");
        sb.appendSql("              WHERE 1=1 ");
        sb.appendSql(" and j.FCreateDate >={ ");
        sb.appendSql(TypeConversionUtils.objToDate((Object)beginPeriodId.getBeginDate()).toString());
        sb.appendSql("} and j.FCreateDate < {");
        sb.appendSql(TypeConversionUtils.objToDate((Object)fromDate).toString());
        sb.appendSql("}");
        sb.appendFilter("j.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("j.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql("                  AND ( j.faccountbankid IN (");
            sb.appendSql("                                              SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("                                              WHERE 1=1 ");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("                                              )");
            sb.appendSql("                        OR j.faccountbankid IS NULL");
            sb.appendSql("                       )");
        }
        sb.appendSql(" GROUP BY j.fcompanyid, j.faccountviewid, j.fcurrencyid, j.faccountbankid ");
        sb.appendSql("  UNION");
        sb.appendSql("           SELECT j.fcompanyid, j.faccountviewid, j.fcurrencyid,j.faccountbankid,");
        sb.appendSql("                  0 fmonthstartamt,");
        sb.appendSql("    0 fmonthdebitamt, 0 fmonthcreditamt, SUM (fdebitamount-fcreditamount) fmonthbalance ");
        sb.appendSql("             FROM t_cas_journal j");
        sb.appendSql("              WHERE 1=1 ");
        sb.appendSql(" and j.FCreateDate >={ ");
        sb.appendSql(TypeConversionUtils.objToDate((Object)beginPeriodId.getBeginDate()).toString());
        sb.appendSql("} and j.FCreateDate <= {");
        sb.appendSql(TypeConversionUtils.objToDate((Object)toDate).toString());
        sb.appendSql("}");
        sb.appendFilter("j.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("j.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql("                  AND ( j.faccountbankid IN (");
            sb.appendSql("                                              SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("                                              WHERE 1=1 ");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("                                              )");
            sb.appendSql("                        OR j.faccountbankid IS NULL");
            sb.appendSql("                       )");
        }
        sb.appendSql(" GROUP BY j.fcompanyid, j.faccountviewid, j.fcurrencyid, j.faccountbankid ");
        sb.appendSql(" \t\t  ) s");
        sb.appendSql(" GROUP BY s.fcompanyid, s.faccountviewid, s.fcurrencyid, s.faccountbankid ");
        return sb;
    }

    public static String appUnit(String colName, String alia, int unit) {
        return colName + "/" + unit + " " + alia + ", ";
    }

    public ResultSet getAccountBankRowSet(Context ctx, Set ids, boolean hasEmpty) throws BOSException {
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        String loc = this.getLoc(ctx);
        if (hasEmpty) {
            sb.appendSql(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"85_CashManagementNewFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        sb.appendSql(" select A.FID, A.FNAME_" + loc + "  FName from t_bd_accountbanks A where 1=1 ");
        if (!FMHelper.isEmpty((Collection)ids)) {
            sb.appendSql(" and ");
            sb.appendParam("A.fid", ids.toArray());
        }
        ResultSet rs = sb.exeQuery(ctx);
        return rs;
    }

    public String getLoc(Context ctx) throws BOSException {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    public FMQuerySqlBuilder getAccountBankSb(Context ctx, FMQuerySqlBuilder ids, Set accountPropertyIdSet, boolean hasEmpty) throws BOSException {
        FMQuerySqlBuilder rstSb = new FMQuerySqlBuilder();
        String loc = this.getLoc(ctx);
        if (hasEmpty) {
            rstSb.appendSql(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"85_CashManagementNewFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        rstSb.appendSql(" select A.FID,  A.FNUMBER||' '||A.FNAME_" + loc + "   FName from t_bd_accountbanks A where 1=1 ");
        rstSb.appendSql(" and ");
        rstSb.appendSql("A.fid in (" + ids.getSql());
        rstSb.appendSql(")");
        if (!FMHelper.isEmpty((Collection)accountPropertyIdSet)) {
            rstSb.appendSql(" and ");
            rstSb.appendParam("A.FPropertyId", accountPropertyIdSet.toArray());
        }
        rstSb.addParams(ids.getParamaters().toArray());
        return rstSb;
    }

    public static String getPeriodRowSet(Context ctx, Set ids) throws BOSException {
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" select A.FID, to_char(A.FPERIODYEAR)||'-'||to_char(A.FPERIODNUMBER) FName ,A.FPERIODYEAR*100 +A.FPERIODNUMBER FOrder from t_bd_period A where 1=1 ");
        if (!FMHelper.isEmpty((Collection)ids)) {
            sb.appendSql(" and ");
            sb.appendParam("A.fid", ids.toArray());
        }
        return sb.getTestSql();
    }

    public static RowSet createSelfDimension(ResultSet rsFact, String key) throws BOSException {
        DynamicRowSet drs;
        try {
            drs = new DynamicRowSet(4);
            drs.setColInfo(1, "fid", "id", 1, null);
            drs.setColInfo(2, "fname", "name", 12, null);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (rsFact == null) {
            return drs;
        }
        HashSet<String> set = new HashSet<String>();
        try {
            rsFact.beforeFirst();
            while (rsFact.next()) {
                set.add(rsFact.getString(key));
            }
            for (String val : set) {
                drs.insertRow();
                drs.updateString(1, val);
                drs.updateString(2, val);
            }
            rsFact.beforeFirst();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return drs;
    }

    public String getCompanyRowSet(Context ctx, Set ids, int level) throws BOSException {
        String loc = this.getLoc(ctx);
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" select A.FID, A.FNumber, A.FName_" + loc + " FName, A.FParentID from t_org_company  A where 1=1 ");
        if (!FMHelper.isEmpty((Collection)ids)) {
            sb.appendSql(" and ");
            sb.appendParam("A.fid", ids.toArray());
        }
        if (level > 0) {
            sb.appendSql(" and  A.FLevel<=");
            sb.appendParam((Object)new Integer(level));
        }
        return sb.getTestSql();
    }

    public String getPropertyRowSet(Context ctx, Set ids) throws BOSException {
        String loc = this.getLoc(ctx);
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"86_CashManagementNewFacadeControllerBean", (Locale)ctx.getLocale()));
        sb.appendSql(" select A.FID, A.FNumber, A.FName_" + loc + " FName  from T_BD_AccountProperty  A where 1=1 ");
        if (!FMHelper.isEmpty((Collection)ids)) {
            sb.appendSql(" and ");
            sb.appendParam("A.fid", ids.toArray());
        }
        return sb.getTestSql();
    }

    public FMQuerySqlBuilder getCompanySb(Context ctx, FMQuerySqlBuilder ids) throws BOSException {
        String loc = this.getLoc(ctx);
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" select A.FID, A.FNumber, A.FName_" + loc + " FName, A.FParentID from t_org_company  A where 1=1 ");
        sb.appendSql(" and ");
        sb.appendSql("A.fid in ( ").appendSql(ids.getSql());
        sb.appendSql(")");
        sb.addParams(ids.getParamaters().toArray());
        return sb;
    }

    public String getCurrencyRowSet(Context ctx, Set ids) throws BOSException {
        String loc = this.getLoc(ctx);
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" select A.FID, A.FNAME_" + loc + "  FName from t_bd_currency A where 1=1 ");
        if (!FMHelper.isEmpty((Collection)ids)) {
            sb.appendSql(" and ");
            sb.appendParam("A.fid", ids.toArray());
        }
        return sb.getTestSql();
    }

    public String getBankRowSet(Context ctx, String tbl, Set ids, boolean hasEmpty, boolean hasParent, int level) throws BOSException {
        String loc = this.getLoc(ctx);
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        if (hasEmpty) {
            sb.appendSql(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"87_CashManagementNewFacadeControllerBean", (Locale)ctx.getLocale()));
            sb.appendSql(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"88_CashManagementNewFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        if (hasParent) {
            sb.appendSql(" select P.FID, P.FNAME_" + loc + " FNAME , isnull(P.FParentID,'0')  FParentID ");
            sb.appendSql(" from t_bd_Bank A, t_bd_Bank P where charindex( P.flongnumber,A.flongnumber)=1");
        } else {
            sb.appendSql(" select A.FID, A.FNAME_" + loc + " FNAME , isnull( A.FParentID,'0')  FParentID from t_bd_Bank A where 1=1 ");
        }
        sb.appendSql(" and A.fid in ( select fbankid from " + tbl + " ) ");
        if (!FMHelper.isEmpty((Collection)ids)) {
            sb.appendSql(" and ");
            sb.appendParam("A.fid", ids.toArray());
        }
        if (level > 0) {
            sb.appendSql(" and P.flevel<=");
            sb.appendParam((Object)new Integer(level));
        }
        return sb.getTestSql();
    }

    private Map prepare(Map paramMap) throws EASBizException, CasDataException {
        FPFormulaInfo info;
        int i;
        StringBuffer sbCompanyNumber = new StringBuffer();
        StringBuffer sbBankAcctNum = new StringBuffer();
        StringBuffer sbCurrency = new StringBuffer();
        StringBuffer sbAcctNumber = new StringBuffer();
        IObjectCollection coll = (IObjectCollection)paramMap.get("col");
        this.doCheck(coll);
        Object[] params = null;
        String companyNumber = null;
        CashDataSourceEnum dataSource = null;
        String accountNum = null;
        String bankAcctNum = null;
        String currencyNum = null;
        Date beginDate = null;
        Date endDate = null;
        CashDataTypeEnum dataType = null;
        HashSet<String> hashSet = new HashSet<String>();
        HashMap<String, Object> hmTest = new HashMap<String, Object>();
        for (i = 0; i < coll.size(); ++i) {
            info = (FPFormulaInfo)coll.getObject(i);
            params = info.getParams();
            companyNumber = (String)params[0];
            dataSource = (CashDataSourceEnum)((Object)params[1]);
            accountNum = (String)params[3];
            bankAcctNum = (String)params[4];
            currencyNum = (String)params[5];
            beginDate = (Date)params[6];
            endDate = (Date)params[7];
            dataType = (CashDataTypeEnum)((Object)params[8]);
            FMVerifyHelper.checkBlank((Object)((Object)dataType), (Object[])new Object[]{"dataType"});
            if (dataType.getValue() == 0 || dataType.getValue() == 1) {
                FMVerifyHelper.checkBlank((Object)endDate, (Object[])new Object[]{"endDate"});
                params[6] = null;
            } else {
                FMVerifyHelper.checkBlank((Object)beginDate, (Object[])new Object[]{"beginDate"});
                FMVerifyHelper.checkBlank((Object)endDate, (Object[])new Object[]{"endDate"});
            }
            if (dataSource == CashDataSourceEnum.C) {
                params[4] = null;
            }
            if (dataSource == null) {
                params[1] = CashDataSourceEnum.CB;
            }
            if (companyNumber != null && !hashSet.contains(companyNumber)) {
                sbCompanyNumber.append(companyNumber).append(";");
                hashSet.add(companyNumber);
            }
            if (bankAcctNum != null) {
                sbBankAcctNum.append(bankAcctNum).append(";");
            }
            if (currencyNum != null) {
                sbCurrency.append(currencyNum).append(";");
            }
            if (accountNum != null) {
                sbAcctNumber.append(accountNum).append(";");
            }
            if (beginDate != null) {
                params[6] = DateTimeUtils.truncateDate((Date)beginDate);
            }
            endDate = DateTimeUtils.truncateDate((Date)endDate);
        }
        for (i = 0; i < coll.size(); ++i) {
            info = (FPFormulaInfo)coll.getObject(i);
            params = info.getParams();
            Date lstBeginDate = (Date)params[6];
            Date lstEndDate = (Date)params[7];
            if (lstBeginDate.before(beginDate)) {
                beginDate = lstBeginDate;
            }
            if (!lstEndDate.after(beginDate)) continue;
            endDate = lstEndDate;
        }
        hmTest.put("coll", coll);
        hmTest.put("companyNumber", sbCompanyNumber);
        hmTest.put("bankAcctNumber", sbBankAcctNum);
        hmTest.put("currencyNumber", sbCurrency);
        hmTest.put("accountNum", sbAcctNumber);
        hmTest.put("beginDate", beginDate);
        hmTest.put("endDate", endDate);
        return hmTest;
    }

    private void doCheck(IObjectCollection coll) throws EASBizException {
        Object[] params = null;
        for (int i = 0; i < coll.size(); ++i) {
            FPFormulaInfo info = (FPFormulaInfo)coll.getObject(i);
            params = info.getParams();
            if (this.isValidPair((CashDataSourceEnum)((Object)params[1]), (CashDataTypeEnum)((Object)params[8]))) continue;
            throw new CasDataException(CasDataException.PAIR_ERROR);
        }
    }

    private boolean isValidPair(CashDataSourceEnum dataSource, CashDataTypeEnum dataType) {
        boolean flag = true;
        if (dataSource == null && dataType != null) {
            return true;
        }
        if (dataSource != null) {
            switch (dataSource.getValue()) {
                case 2: 
                case 6: 
                case 7: {
                    if (dataType.getValue() <= 2) break;
                    flag = false;
                    break;
                }
                case 3: {
                    break;
                }
                case 5: {
                    if (dataType.getValue() <= 2) break;
                    flag = false;
                }
            }
        }
        return flag;
    }

    private Set getCompanyIds(Context ctx, String companyNum) throws BOSException {
        if (FMHelper.isEmpty((String)companyNum)) {
            return null;
        }
        StringBuffer sql = new StringBuffer(120);
        sql.append("select fid,FNumber from t_org_company where (");
        if (companyNum.indexOf(";") > 0) {
            String[] nums = companyNum.split(";");
            for (int i = 0; i < nums.length; ++i) {
                if (i > 0) {
                    sql.append(" or ");
                }
                sql.append(" (FNumber = '").append(nums[i].trim()).append("'").append(" or FLongNumber like '").append(companyNum).append("!%' ").append(" or FLongNumber like '%!").append(companyNum).append("!%') ");
            }
        } else {
            sql.append(" FNumber = '").append(companyNum.trim()).append("'").append(" or FLongNumber like '").append(companyNum).append("!%' ").append(" or FLongNumber like '%!").append(companyNum).append("!%'");
        }
        sql.append(" ) and FIsOnlyUnion =0 ");
        sql.append(" order by FLongNumber asc");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            HashSet<String> idSet = new HashSet<String>();
            while (rs.next()) {
                idSet.add(rs.getString("fid"));
                this.listIdNumberCompany.add(new IdToNumber_Company(rs.getString("fid"), rs.getString("fnumber")));
            }
            if (idSet.size() > 0) {
                return idSet;
            }
            return null;
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            BOSException e = new BOSException();
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
    }

    private void setAcctViewIDs(String acctViewNum, Context ctx) throws CasDataException, BOSException {
        if (FMHelper.isEmpty((String)acctViewNum)) {
            return;
        }
        StringBuffer sql = new StringBuffer(100);
        sql.append("select Fid,Fnumber from t_bd_accountbanks where 1=1");
        if (!StringUtils.isEmpty((String)acctViewNum)) {
            if (acctViewNum.indexOf(";") > 0) {
                sql.append(" and FNumber in (");
                String[] nums = acctViewNum.split(";");
                for (int i = 0; i < nums.length; ++i) {
                    if (i > 0) {
                        sql.append(",");
                    }
                    sql.append(" '").append(nums[i].trim()).append("'");
                }
                sql.append(")");
            } else {
                sql.append(" and FNumber = '").append(acctViewNum.trim()).append("'");
            }
        }
        HashSet<String> bankAcctIdSet = new HashSet<String>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                if (rs.getString("FID") == null) continue;
                bankAcctIdSet.add(rs.getString("FID"));
                this.listIdNumberAcctView.add(new IdToNumber_AcctView(rs.getString("FID"), rs.getString("Fnumber")));
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            BOSException e = new BOSException();
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        throw new CasDataException(CasDataException.NULL_ACCOUNTBANK);
    }

    private Set getBankAcctIds(Context ctx, String bankAcctNum) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)bankAcctNum) || bankAcctNum.equals("")) {
            return null;
        }
        StringBuffer sql = new StringBuffer(100);
        sql.append("select Fid,Fnumber from t_bd_accountbanks where 1=1");
        if (!StringUtils.isEmpty((String)bankAcctNum)) {
            if (bankAcctNum.indexOf(";") > 0) {
                sql.append(" and FNumber in (");
                String[] nums = bankAcctNum.split(";");
                for (int i = 0; i < nums.length; ++i) {
                    if (i > 0) {
                        sql.append(",");
                    }
                    sql.append(" '").append(nums[i].trim()).append("'");
                }
                sql.append(")");
            } else {
                sql.append(" and FNumber = '").append(bankAcctNum.trim()).append("'");
            }
        }
        HashSet<String> bankAcctIdSet = new HashSet<String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                if (rs.getString("FID") == null) continue;
                bankAcctIdSet.add(rs.getString("FID"));
                this.listIdNumberBankAcct.add(new IdToNumber_AcctBank(rs.getString("FID"), rs.getString("Fnumber")));
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            BOSException e = new BOSException();
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        if (bankAcctIdSet.size() > 0) {
            return bankAcctIdSet;
        }
        throw new CasDataException(CasDataException.NULL_ACCOUNTBANK);
    }

    private String getCurrencyId(Context ctx, String currencyNum) throws BOSException, CasDataException {
        if (FMHelper.isEmpty((String)currencyNum)) {
            return null;
        }
        StringBuffer sql = new StringBuffer(100);
        sql.append("select fid,fnumber from t_bd_currency where 1=1 ");
        if (!StringUtils.isEmpty((String)currencyNum)) {
            if (currencyNum.indexOf(";") > 0) {
                sql.append(" and FNumber in (");
                String[] nums = currencyNum.split(";");
                for (int i = 0; i < nums.length; ++i) {
                    if (i > 0) {
                        sql.append(",");
                    }
                    sql.append(" '").append(nums[i].trim()).append("'");
                }
                sql.append(")");
            } else {
                sql.append(" and FNumber = '").append(currencyNum.trim()).append("'");
            }
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                this.listIdNumberCurrency.add(new IdToNumber_Currency(rs.getString(1), rs.getString(2)));
                return rs.getString(1);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            BOSException e = new BOSException();
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        throw new CasDataException(CasDataException.NULL_CURRENCY);
    }

    static class IdToNumber_AcctBank {
        private String id;
        private String number;

        public IdToNumber_AcctBank(String id, String number) {
            this.id = id;
            this.number = number;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }
    }

    static class IdToNumber_Currency {
        private String id;
        private String number;

        public IdToNumber_Currency(String id, String number) {
            this.id = id;
            this.number = number;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }
    }

    static class IdToNumber_AcctView {
        private String id;
        private String number;

        public IdToNumber_AcctView(String id, String number) {
            this.id = id;
            this.number = number;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }
    }

    static class IdToNumber_Company {
        private String id;
        private String number;

        public IdToNumber_Company(String id, String number) {
            this.id = id;
            this.number = number;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }
    }
}

