/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountCurrencyCollection;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGCollection;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeSysEnum;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AccountTypeEnum;
import com.kingdee.eas.fi.cas.BankStatementFactory;
import com.kingdee.eas.fi.cas.BankStatementInfo;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.CasGLItemCheckRptInfo;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.IBankStatement;
import com.kingdee.eas.fi.cas.IJournal;
import com.kingdee.eas.fi.cas.IJournalBalance;
import com.kingdee.eas.fi.cas.JournalBalanceCollection;
import com.kingdee.eas.fi.cas.JournalBalanceFactory;
import com.kingdee.eas.fi.cas.JournalBalanceInfo;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.app.AbstractCashMgtInitFacadeControllerBean;
import com.kingdee.eas.fi.cas.subacct.ISubAcctMgtInitFacade;
import com.kingdee.eas.fi.cas.subacct.SubAcctMgtInitFacadeFactory;
import com.kingdee.eas.fi.gl.AccountBalanceCollection;
import com.kingdee.eas.fi.gl.AccountBalanceFactory;
import com.kingdee.eas.fi.gl.AccountBalanceInfo;
import com.kingdee.eas.fi.gl.AssistBalanceCollection;
import com.kingdee.eas.fi.gl.AssistBalanceFactory;
import com.kingdee.eas.fi.gl.AssistBalanceInfo;
import com.kingdee.eas.fi.gl.IAccountBalance;
import com.kingdee.eas.fi.gl.IAssistBalance;
import com.kingdee.eas.fi.gl.IInitAssistBalance;
import com.kingdee.eas.fi.gl.InitAssistBalanceCollection;
import com.kingdee.eas.fi.gl.InitAssistBalanceFactory;
import com.kingdee.eas.fi.gl.InitAssistBalanceInfo;
import com.kingdee.eas.fi.rpt.BalanceTypeEnum;
import com.kingdee.eas.fi.rpt.IReportCacl;
import com.kingdee.eas.fi.rpt.ReportCaclFactory;
import com.kingdee.eas.fi.rpt.VoucherGetTypeEnum;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.im.IMIntObjectCheckFacadeFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CashMgtInitFacadeControllerBean
extends AbstractCashMgtInitFacadeControllerBean {
    private static final String STRING_ZERO = "0";
    private static Logger logger = Logger.getLogger((String)CashMgtInitFacadeControllerBean.class.getName());
    private static final String STRING_ONE = "1";
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private static final String[] strKeys = new String[]{"company", "currency", "period", "accountBank"};

    @Override
    protected boolean _checkIsInit(Context ctx, String strCompanyId, String strPeriodId) throws BOSException, EASBizException {
        boolean isInit = false;
        IJournalBalance iJournalBal = JournalBalanceFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        viewInfo.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("company", (Object)strCompanyId));
        filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)strPeriodId));
        filterInfo.getFilterItems().add(new FilterItemInfo("isInit", (Object)STRING_ONE));
        if (iJournalBal.exists(filterInfo)) {
            isInit = true;
        }
        return isInit;
    }

    @Override
    protected Vector _getContrastWithGL(Context ctx, String strCompanyId, String strPeriodId) throws BOSException, EASBizException {
        Vector vectorReport = new Vector();
        String currAcctTableId = this.getCurrAcctTableId(ctx, strCompanyId, strPeriodId);
        this.createContrastReportByCashAcct(ctx, strCompanyId, currAcctTableId, strPeriodId, vectorReport);
        this.createContrastReportByBank(ctx, strCompanyId, currAcctTableId, strPeriodId, vectorReport);
        vectorReport.remove(null);
        return vectorReport;
    }

    public Map getAcctBankSumSearchMap(JournalBalanceCollection journalBalances, String[] keys) {
        HashMap<String, JournalBalanceInfo> map = new HashMap<String, JournalBalanceInfo>();
        for (int i = 0; i < journalBalances.size(); ++i) {
            JournalBalanceInfo journalBalance = journalBalances.get(i);
            String keyString = FMHelper.getKeyString((IObjectValue)journalBalance, (String[])keys);
            if (map.get(keyString) == null) {
                JournalBalanceInfo journalBalanceBak = (JournalBalanceInfo)journalBalance.clone();
                journalBalanceBak.setType(AccountTypeEnum.CASHACCOUNT);
                map.put(keyString, journalBalanceBak);
                continue;
            }
            JournalBalanceInfo journalBalanceOld = (JournalBalanceInfo)map.get(keyString);
            journalBalanceOld.setMonthStartAmt(journalBalance.getMonthStartAmt().add(journalBalanceOld.getMonthStartAmt()));
            journalBalanceOld.setMonthDebitAmt(journalBalance.getMonthDebitAmt().add(journalBalanceOld.getMonthDebitAmt()));
            journalBalanceOld.setMonthCreditAmt(journalBalance.getMonthCreditAmt().add(journalBalanceOld.getMonthCreditAmt()));
        }
        return map;
    }

    private void createContrastReportByBank(Context ctx, String strCompanyId, String acctTableId, String strPeriodId, Vector vectorReport) throws BOSException, EASBizException {
        boolean fGLStart = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.getCompanyById(ctx, strCompanyId));
        JournalBalanceCollection bankJournalBalColl = null;
        bankJournalBalColl = this.isInitPeriod(ctx, strCompanyId, strPeriodId) ? this.getJournalBalanceCollection(ctx, strCompanyId, null, strPeriodId, AccountTypeEnum.BANKACCOUNT, true) : this.getJournalBalanceCollection(ctx, strCompanyId, null, strPeriodId, AccountTypeEnum.BANKACCOUNT, false);
        AccountBankCollection acctBankCol = this.getAccountBankCollection(ctx, strCompanyId);
        acctBankCol = FMHelper.getJouranlBalanceAcctBank((Context)ctx, (AccountBankCollection)acctBankCol, (String)strPeriodId, null);
        Hashtable<String, JournalBalanceInfo> htExistCollection = new Hashtable<String, JournalBalanceInfo>();
        HashSet<String> currencySet = new HashSet<String>();
        if (bankJournalBalColl != null && bankJournalBalColl.size() != 0) {
            for (int i = 0; i < bankJournalBalColl.size(); ++i) {
                JournalBalanceInfo journalBalInfo = bankJournalBalColl.get(i);
                String accountBankId = journalBalInfo.getAccountBank().getId().toString();
                String acctViewId = journalBalInfo.getAccountView().getId().toString();
                String currencyId = journalBalInfo.getCurrency().getId().toString();
                currencySet.add(currencyId);
                htExistCollection.put(this.getIndexKey(accountBankId, acctViewId, currencyId), journalBalInfo);
            }
        }
        PeriodInfo period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(strPeriodId));
        this.filterCurrencyId(ctx, currencySet, strCompanyId, period.getNumber());
        int intAcctBankColSize = 0;
        if (acctBankCol != null) {
            intAcctBankColSize = acctBankCol.size();
        }
        JournalBalanceInfo journalBalInfo = null;
        AccountBankInfo acctBankInfo = null;
        CasGLItemCheckRptInfo rptInfo = null;
        String indexKey = null;
        String strCurrencyId2 = null;
        for (int i = 0; i < intAcctBankColSize; ++i) {
            acctBankInfo = acctBankCol.get(i);
            String acctBankId = acctBankInfo.getId().toString();
            String strAccountId = acctBankInfo.getAccount().getId().toString();
            if (!acctBankInfo.getAccount().isIsBank()) continue;
            for (String strCurrencyId2 : currencySet) {
                indexKey = this.getIndexKey(acctBankId, strAccountId, strCurrencyId2);
                if (htExistCollection.containsKey(indexKey)) {
                    journalBalInfo = (JournalBalanceInfo)htExistCollection.get(indexKey);
                    strCurrencyId2 = journalBalInfo.getCurrency().getId().toString();
                    rptInfo = null;
                    rptInfo = this.cashContrastGLForCAS(ctx, strCompanyId, acctBankInfo, strAccountId, strCurrencyId2, strPeriodId, journalBalInfo, fGLStart);
                    if (rptInfo == null) continue;
                    vectorReport.add(rptInfo);
                    continue;
                }
                journalBalInfo = new JournalBalanceInfo();
                journalBalInfo.setAccountBank(acctBankInfo);
                journalBalInfo.setType(AccountTypeEnum.BANKACCOUNT);
                journalBalInfo.setAccountView(acctBankInfo.getAccount());
                journalBalInfo.setCurrency(this.getCurrencyById(ctx, strCurrencyId2));
                rptInfo = null;
                rptInfo = this.cashContrastGLForCAS(ctx, strCompanyId, acctBankInfo, strAccountId, strCurrencyId2, strPeriodId, journalBalInfo, fGLStart);
                if (rptInfo == null) continue;
                vectorReport.add(rptInfo);
            }
        }
    }

    private BigDecimal getGLAssisData(Context ctx, CompanyOrgUnitInfo org, String accountNum, String acctBankNum, String currencyNum, PeriodInfo beginPeriod, PeriodInfo endPeriod, BalanceTypeEnum balanceType, AsstActTypeInfo asstAct) throws BOSException, EASBizException {
        IReportCacl reportCacl = ReportCaclFactory.getLocalInstance((Context)ctx);
        if (beginPeriod == null || endPeriod == null) {
            return null;
        }
        boolean includeVoucher = true;
        boolean checkDataRight = false;
        String companyNum = org.getNumber();
        int startYear = beginPeriod.getPeriodYear();
        int startNum = beginPeriod.getPeriodNumber();
        int endYear = endPeriod.getPeriodYear();
        int endNum = endPeriod.getPeriodNumber();
        BigDecimal balance = ZERO;
        balance = asstAct != null ? reportCacl.acct(companyNum, accountNum + "|" + asstAct.getNumber() + "|" + acctBankNum, balanceType, startYear, startNum, endYear, endNum, currencyNum, false, includeVoucher, checkDataRight) : reportCacl.acct(companyNum, accountNum, balanceType, startYear, startNum, endYear, endNum, currencyNum, false, includeVoucher, checkDataRight);
        return balance == null ? ZERO : balance;
    }

    private BigDecimal getGLData(Context ctx, CompanyOrgUnitInfo companyInfo, String accountNum, String currencyNum, PeriodInfo beginPeriod, PeriodInfo endPeriod, BalanceTypeEnum balanceType) throws BOSException, EASBizException {
        IReportCacl reportCacl = ReportCaclFactory.getLocalInstance((Context)ctx);
        if (beginPeriod == null || endPeriod == null) {
            return null;
        }
        boolean includeVoucher = true;
        boolean checkDataRight = false;
        String companyNum = companyInfo.getNumber();
        int startYear = beginPeriod.getPeriodYear();
        int startNum = beginPeriod.getPeriodNumber();
        int endYear = endPeriod.getPeriodYear();
        int endNum = endPeriod.getPeriodNumber();
        BigDecimal balance = ZERO;
        balance = reportCacl.acct(companyNum, accountNum, balanceType, startYear, startNum, endYear, endNum, currencyNum, false, includeVoucher, checkDataRight);
        return balance == null ? ZERO : balance;
    }

    private CompanyOrgUnitInfo getCompanyInfo(Context ctx, String fid) throws BOSException {
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("name");
        selector.add("number");
        selector.add("accountTable.id");
        selector.add("accountTable.number");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)fid));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        CompanyOrgUnitCollection companyColl = iCompany.getCompanyOrgUnitCollection(viewInfo);
        if (companyColl != null) {
            return companyColl.get(0);
        }
        return null;
    }

    private BigDecimal getGLExtBalance(Context ctx, String companyNum, String accountNum, String currencyNum, Date beginDate, Date endDate, VoucherGetTypeEnum type) throws BOSException, EASBizException {
        BigDecimal balance = ZERO;
        IReportCacl reportCacl = ReportCaclFactory.getLocalInstance((Context)ctx);
        boolean includeVoucher = true;
        boolean checkDataRight = false;
        String strBeginDate = beginDate.toString();
        String strEndDate = endDate.toString();
        try {
            balance = reportCacl.acctExt(companyNum, accountNum, "", null, type, currencyNum, strBeginDate, strEndDate, includeVoucher, checkDataRight);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return balance;
    }

    private CasGLItemCheckRptInfo cashContrastGLForCAS(Context ctx, String companyId, AccountBankInfo acctBankInfo, String accountId, String currencyId, String periodId, JournalBalanceInfo journalBalInfo, boolean isGLStart) throws EASBizException, BOSException {
        CasGLItemCheckRptInfo rpt = null;
        BigDecimal casStartAmt = ZERO;
        BigDecimal glStartAmt = ZERO;
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectStringPK(companyId));
        companyInfo = this.getCompanyInfo(ctx, companyInfo.getId().toString());
        AccountViewInfo acctViewInfo = acctBankInfo.getAccount();
        String accountNum = acctViewInfo.getNumber();
        String bankAcctNum = acctBankInfo.getNumber();
        PeriodInfo period = this.getPeriodById(ctx, periodId);
        Date beginDate = period.getBeginDate();
        Timestamp endDate = period.getEndDate();
        PeriodInfo beginPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)beginDate, (CompanyOrgUnitInfo)companyInfo);
        PeriodInfo endPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)endDate, (CompanyOrgUnitInfo)companyInfo);
        CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectStringPK(currencyId));
        String currencyNum = currencyInfo.getNumber();
        IAsstActType asstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
        AsstActTypeInfo asstAct = null;
        if (acctViewInfo.getCAA() != null && this.isAcctHasAcctBankAssis(ctx, acctViewInfo.getId().toString())) {
            asstAct = asstActType.getAsstActType(AsstActTypeSysEnum.BANKACCOUNT);
        }
        BalanceTypeEnum beginBalType = BalanceTypeEnum.C;
        if (journalBalInfo.getMonthBalance() != null) {
            casStartAmt = journalBalInfo.getMonthBalance();
        }
        if (isGLStart) {
            glStartAmt = this.getGLAssisData(ctx, companyInfo, accountNum, bankAcctNum, currencyNum, beginPeriod, endPeriod, beginBalType, asstAct);
        }
        casStartAmt = casStartAmt.setScale(journalBalInfo.getCurrency().getPrecision(), 4);
        if ((glStartAmt = glStartAmt.setScale(journalBalInfo.getCurrency().getPrecision(), 4)).compareTo(casStartAmt) != 0) {
            rpt = this.getContrastRptInfo(ctx, journalBalInfo, casStartAmt, glStartAmt);
        }
        return rpt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void filterCurrencyId(Context ctx, HashSet currencySet, String companyId, int period) {
        String currencyId;
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        String strSql;
        block16: {
            strSql = "SELECT distinct FCurrencyID FROM T_GL_AccountBalance_1f WHERE FOrgUnitID=? AND FPeriod=? ";
            con = null;
            stmt = null;
            rs = null;
            currencyId = null;
            try {
                con = this.getConnection(ctx);
                stmt = con.prepareStatement(strSql.toString());
                stmt.setString(1, companyId);
                stmt.setInt(2, period);
                rs = stmt.executeQuery();
                if (rs == null) break block16;
                while (rs.next()) {
                    currencyId = rs.getString("FCurrencyID");
                    currencySet.add(currencyId);
                }
            }
            catch (SQLDataException e) {
                logger.error((Object)e);
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)con);
            }
            catch (SQLException e2) {
                logger.error((Object)e2);
                {
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs, stmt, (Connection)con);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)con);
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        strSql = "SELECT distinct FCurrencyID FROM T_CAS_Journal WHERE Fcompanyid=? AND FPeriodID is null";
        con = null;
        stmt = null;
        rs = null;
        currencyId = null;
        try {
            con = this.getConnection(ctx);
            stmt = con.prepareStatement(strSql.toString());
            stmt.setString(1, companyId);
            rs = stmt.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    currencyId = rs.getString("FCurrencyID");
                    if (currencyId.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString()) || currencyId.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) continue;
                    currencySet.add(currencyId);
                }
            }
        }
        catch (SQLDataException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        }
    }

    private String getIndexKey(String accountBankId, String acctViewId, String currencyId) {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append(accountBankId);
        strBuff.append("_");
        strBuff.append(acctViewId);
        strBuff.append("_");
        strBuff.append(currencyId);
        return strBuff.toString();
    }

    private boolean isInitPeriod(Context ctx, String strCompanyId, String strPeriodId) throws EASBizException, BOSException {
        PeriodInfo startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (IObjectPK)new ObjectUuidPK(strCompanyId));
        return startPeriodInfo.getId().toString().equals(strPeriodId);
    }

    private void createContrastReportByCashAcct(Context ctx, String strCompanyId, String acctTableId, String strPeriodId, Vector vectorReport) throws BOSException, EASBizException {
        CasGLItemCheckRptInfo rptInfo = null;
        String[] glsKeys = new String[]{"orgUnit", "account", "currency", "period"};
        String[] casKeys = new String[]{"company", "accountView", "currency", "period"};
        String[] bankKeys = new String[]{"company", "accountBank", "accountView", "currency", "period"};
        AccountBalanceCollection glsColl = this.getGLBalanceCollection(ctx, strCompanyId, acctTableId, strPeriodId, true);
        Map glsMap = new HashMap();
        if (glsColl != null && glsColl.size() > 0) {
            glsMap = CashHelper.getVOHashSearchMap((IObjectCollection)glsColl, glsKeys);
        }
        JournalBalanceInfo journalBalInfo2 = null;
        boolean isInitPeriod = this.isInitPeriod(ctx, strCompanyId, strPeriodId);
        JournalBalanceCollection journalBalColl = this.getJournalBalanceCollection(ctx, strCompanyId, null, strPeriodId, AccountTypeEnum.CASHACCOUNT, isInitPeriod);
        Map casMap = new HashMap();
        if (journalBalColl != null && journalBalColl.size() > 0) {
            casMap = CashHelper.getVOHashSearchMap((IObjectCollection)journalBalColl, bankKeys);
        }
        int journalBalSize = 0;
        if (journalBalColl != null) {
            journalBalSize = journalBalColl.size();
        }
        Vector<String> glVec = new Vector<String>();
        Vector<String> casVec = new Vector<String>();
        if (glsMap != null && casMap != null && glsMap.size() > 0 && casMap.size() > 0) {
            for (int i = 0; i < journalBalSize; ++i) {
                AccountTypeEnum type;
                AccountBalanceInfo acctBalInfo;
                JournalBalanceInfo cashInfo = journalBalColl.get(i);
                String keyString = CashHelper.getKeyString((IObjectValue)cashInfo, casKeys);
                String bankKeyString = CashHelper.getKeyString((IObjectValue)cashInfo, bankKeys);
                if (!glsMap.containsKey(keyString) || this.isGeneralCurrency((acctBalInfo = (AccountBalanceInfo)glsMap.get(keyString)).getCurrency()) || (!(type = cashInfo.getType()).equals((Object)AccountTypeEnum.CASHACCOUNT) || !acctBalInfo.getAccount().isIsCash()) && (!type.equals((Object)AccountTypeEnum.BANKACCOUNT) || !acctBalInfo.getAccount().isIsBank())) continue;
                rptInfo = this.cashContrastGL(ctx, strCompanyId, null, acctTableId, acctBalInfo.getCurrency().getId().toString(), strPeriodId, acctBalInfo, cashInfo, true);
                if (rptInfo != null) {
                    vectorReport.add(rptInfo);
                }
                glVec.add(keyString);
                casVec.add(bankKeyString);
            }
        }
        String removeKey = null;
        if (casVec != null && casVec.size() > 0) {
            for (int i = 0; i < casVec.size(); ++i) {
                removeKey = (String)casVec.get(i);
                casMap.remove(removeKey);
            }
        }
        if (casMap != null && casMap.size() > 0) {
            for (JournalBalanceInfo journalBalInfo2 : casMap.values()) {
                if (journalBalInfo2 == null || (rptInfo = this.cashContrastGL(ctx, strCompanyId, null, acctTableId, journalBalInfo2.getCurrency().getId().toString(), strPeriodId, null, journalBalInfo2, true)) == null) continue;
                vectorReport.add(rptInfo);
            }
        }
        if (glVec != null && glVec.size() > 0) {
            int size = glVec.size();
            for (int i = 0; i < size; ++i) {
                removeKey = (String)glVec.get(i);
                glsMap.remove(removeKey);
            }
        }
        if (glsMap != null && glsMap.size() > 0) {
            for (AccountBalanceInfo glAcctBalInfo : glsMap.values()) {
                if (glAcctBalInfo == null || this.isGeneralCurrency(glAcctBalInfo.getCurrency()) || (rptInfo = this.cashContrastGL(ctx, strCompanyId, null, acctTableId, glAcctBalInfo.getCurrency().getId().toString(), strPeriodId, glAcctBalInfo, null, true)) == null) continue;
                vectorReport.add(rptInfo);
            }
        }
    }

    private boolean isGeneralCurrency(CurrencyInfo currency) {
        String currencyId = null;
        if (currency == null) {
            return false;
        }
        currencyId = currency.getId().toString();
        return currencyId.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString()) || currencyId.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString());
    }

    public BigDecimal getBigDecimal(BigDecimal big) {
        return big == null ? ZERO : big;
    }

    private CasGLItemCheckRptInfo cashContrastGL(Context ctx, String companyId, AccountBankInfo acctBankInfo, String accountId, String currencyId, String periodId, AccountBalanceInfo glInitInfo, JournalBalanceInfo journalBalInfo, boolean isGLStart) throws EASBizException, BOSException {
        CasGLItemCheckRptInfo rpt = null;
        if (glInitInfo == null && journalBalInfo == null) {
            return null;
        }
        BigDecimal casStartAmt = ZERO;
        BigDecimal glStartAmt = ZERO;
        AccountTypeEnum acctType = AccountTypeEnum.CASHACCOUNT;
        if (glInitInfo != null && journalBalInfo != null) {
            AccountViewInfo acctViewInfo;
            if (this.isGeneralCurrency(glInitInfo.getCurrency())) {
                return null;
            }
            acctType = journalBalInfo.getType();
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectStringPK(companyId));
            companyInfo = this.getCompanyInfo(ctx, companyInfo.getId().toString());
            String companyNum = companyInfo.getNumber();
            PeriodInfo period = this.getPeriodById(ctx, periodId);
            Date beginDate = period.getBeginDate();
            Timestamp endDate = period.getEndDate();
            PeriodInfo beginPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)beginDate, (CompanyOrgUnitInfo)companyInfo);
            PeriodInfo endPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)endDate, (CompanyOrgUnitInfo)companyInfo);
            CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectStringPK(currencyId));
            String currencyNum = currencyInfo.getNumber();
            BalanceTypeEnum beginBalType = BalanceTypeEnum.C;
            if (journalBalInfo.getMonthBalance() != null) {
                casStartAmt = journalBalInfo.getMonthBalance();
            }
            glStartAmt = beginDate.equals(endDate) ? this.getGLExtBalance(ctx, companyNum, glInitInfo.getAccount().getNumber(), currencyNum, beginDate, endDate, VoucherGetTypeEnum.C) : this.getGLData(ctx, companyInfo, glInitInfo.getAccount().getNumber(), currencyNum, beginPeriod, endPeriod, beginBalType);
            if ((acctType.equals((Object)AccountTypeEnum.BANKACCOUNT) || acctType.equals((Object)AccountTypeEnum.ACCTSTATEMENT)) && (acctViewInfo = glInitInfo.getAccount()).isIsBank() && (acctViewInfo.getGAA() != null || acctViewInfo.getCAA() != null)) {
                AssistantHGInfo asstHGInfo;
                AsstAccountInfo asstAcctInfo = new AsstAccountInfo();
                if (acctViewInfo.getGAA() != null) {
                    asstAcctInfo = acctViewInfo.getGAA();
                }
                if (acctViewInfo.getCAA() != null) {
                    asstAcctInfo = acctViewInfo.getCAA();
                }
                if ((asstHGInfo = this.getHasAssistant(ctx, journalBalInfo.getAccountBank().getId().toString(), asstAcctInfo.getId().toString())) != null) {
                    String asstHGId = asstHGInfo.getId().toString();
                    glStartAmt = this.getAssistantBeginAmt(ctx, journalBalInfo, journalBalInfo.getCompany().getId().toString(), journalBalInfo.getCurrency().getId().toString(), journalBalInfo.getPeriod().getId().toString(), acctViewInfo.getId().toString(), asstHGId, false);
                }
            }
            if (this.isGeneralCurrency(journalBalInfo.getCurrency())) {
                return null;
            }
            if (casStartAmt.compareTo(glStartAmt) != 0) {
                rpt = this.getContrastRptInfo(ctx, journalBalInfo, casStartAmt, glStartAmt);
            }
        } else if (glInitInfo != null && journalBalInfo == null) {
            if (this.isGeneralCurrency(glInitInfo.getCurrency())) {
                return null;
            }
            glStartAmt = this.getBigDecimal(glInitInfo.getBeginBalanceFor()).setScale(glInitInfo.getCurrency().getPrecision(), 4);
            if (glStartAmt.signum() != 0) {
                rpt = this.getGLContrastRptInfo(glInitInfo, casStartAmt, glStartAmt, null);
            }
        } else if (glInitInfo == null && journalBalInfo != null) {
            if (this.isGeneralCurrency(journalBalInfo.getCurrency())) {
                return null;
            }
            casStartAmt = this.getBigDecimal(journalBalInfo.getMonthStartAmt()).setScale(journalBalInfo.getCurrency().getPrecision(), 4);
            if (casStartAmt.signum() != 0) {
                rpt = this.getContrastRptInfo(ctx, journalBalInfo, casStartAmt, glStartAmt);
            }
        }
        return rpt;
    }

    private CasGLItemCheckRptInfo cashContrastGL(Context ctx, AccountBalanceInfo glInitInfo, JournalBalanceInfo journalBalInfo) throws EASBizException, BOSException {
        CasGLItemCheckRptInfo rpt = null;
        if (glInitInfo == null && journalBalInfo == null) {
            return null;
        }
        BigDecimal casStartAmt = ZERO;
        BigDecimal glStartAmt = ZERO;
        AccountTypeEnum acctType = AccountTypeEnum.CASHACCOUNT;
        if (glInitInfo != null && journalBalInfo != null) {
            AccountViewInfo acctViewInfo;
            if (this.isGeneralCurrency(glInitInfo.getCurrency())) {
                return null;
            }
            acctType = journalBalInfo.getType();
            casStartAmt = this.getBigDecimal(journalBalInfo.getMonthStartAmt()).setScale(journalBalInfo.getCurrency().getPrecision(), 1);
            glStartAmt = this.getBigDecimal(glInitInfo.getBeginBalanceFor().setScale(glInitInfo.getCurrency().getPrecision(), 1));
            if ((acctType.equals((Object)AccountTypeEnum.BANKACCOUNT) || acctType.equals((Object)AccountTypeEnum.ACCTSTATEMENT)) && (acctViewInfo = glInitInfo.getAccount()).isIsBank() && (acctViewInfo.getGAA() != null || acctViewInfo.getCAA() != null)) {
                AssistantHGInfo asstHGInfo;
                AsstAccountInfo asstAcctInfo = null;
                if (acctViewInfo.getGAA() != null) {
                    asstAcctInfo = acctViewInfo.getGAA();
                }
                if (acctViewInfo.getCAA() != null) {
                    asstAcctInfo = acctViewInfo.getCAA();
                }
                if ((asstHGInfo = this.getHasAssistant(ctx, journalBalInfo.getAccountBank().getId().toString(), asstAcctInfo.getId().toString())) != null) {
                    String asstHGId = asstHGInfo.getId().toString();
                    glStartAmt = this.getAssistantBeginAmt(ctx, journalBalInfo, journalBalInfo.getCompany().getId().toString(), journalBalInfo.getCurrency().getId().toString(), journalBalInfo.getPeriod().getId().toString(), acctViewInfo.getId().toString(), asstHGId, false);
                }
            }
            if (this.isGeneralCurrency(journalBalInfo.getCurrency())) {
                return null;
            }
            if (casStartAmt.compareTo(glStartAmt) != 0) {
                rpt = this.getContrastRptInfo(ctx, journalBalInfo, casStartAmt, glStartAmt);
            }
        } else if (glInitInfo != null && journalBalInfo == null) {
            if (this.isGeneralCurrency(glInitInfo.getCurrency())) {
                return null;
            }
            glStartAmt = this.getBigDecimal(glInitInfo.getBeginBalanceFor()).setScale(glInitInfo.getCurrency().getPrecision(), 4);
            if (glStartAmt.signum() != 0) {
                rpt = this.getGLContrastRptInfo(glInitInfo, casStartAmt, glStartAmt, null);
            }
        } else if (glInitInfo == null && journalBalInfo != null) {
            if (this.isGeneralCurrency(journalBalInfo.getCurrency())) {
                return null;
            }
            casStartAmt = this.getBigDecimal(journalBalInfo.getMonthStartAmt()).setScale(journalBalInfo.getCurrency().getPrecision(), 4);
            if (casStartAmt.signum() != 0) {
                rpt = this.getContrastRptInfo(ctx, journalBalInfo, casStartAmt, glStartAmt);
            }
        }
        return rpt;
    }

    private BigDecimal getAssistantBeginAmt(Context ctx, JournalBalanceInfo journalBalInfo, String companyId, String currencyId, String periodId, String accountId, String assistGrpId, boolean bln) throws EASBizException, BOSException {
        PeriodInfo glStartPeriodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.getCompanyById(ctx, companyId));
        boolean isGLInit = periodId.equals(glStartPeriodInfo.getId().toString());
        BigDecimal startAmt = this.getBigDecimal(journalBalInfo.getMonthStartAmt());
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (companyId != null) {
            fi.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)companyId));
        }
        if (!isGLInit && periodId != null) {
            fi.getFilterItems().add(new FilterItemInfo("period.id", (Object)periodId));
        }
        if (accountId != null) {
            fi.getFilterItems().add(new FilterItemInfo("account.id", (Object)accountId));
        }
        if (currencyId != null) {
            fi.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        }
        if (!isGLInit) {
            if (assistGrpId != null) {
                fi.getFilterItems().add(new FilterItemInfo("assistGrp.id", (Object)assistGrpId));
            }
            if (bln) {
                fi.getFilterItems().add(new FilterItemInfo("balType", (Object)new Integer(5)));
            } else {
                fi.getFilterItems().add(new FilterItemInfo("balType", (Object)new Integer(1)));
            }
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("yearDebitFor"));
        selector.add(new SelectorItemInfo("yearCreditFor"));
        selector.add(new SelectorItemInfo("beginBalanceFor"));
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.setFilter(fi);
        if (isGLInit) {
            IInitAssistBalance iInitAsstBal = InitAssistBalanceFactory.getLocalInstance((Context)ctx);
            InitAssistBalanceCollection initAssistBalColl = iInitAsstBal.getInitAssistBalanceCollection(evi);
            if (initAssistBalColl != null && initAssistBalColl.size() > 0) {
                InitAssistBalanceInfo initAssistBalInfo = initAssistBalColl.get(0);
                startAmt = this.getBigDecimal(initAssistBalInfo.getBeginBalanceFor());
            }
        } else {
            IAssistBalance iAssistBal = AssistBalanceFactory.getLocalInstance((Context)ctx);
            AssistBalanceCollection assistBalColl = iAssistBal.getAssistBalanceCollection(evi);
            if (assistBalColl != null && assistBalColl.size() > 0) {
                AssistBalanceInfo assistBalInfo = assistBalColl.get(0);
                startAmt = this.getBigDecimal(assistBalInfo.getBeginBalanceFor());
            }
        }
        return startAmt;
    }

    private CasGLItemCheckRptInfo getContrastRptInfo(Context ctx, JournalBalanceInfo journalBalInfo, BigDecimal casStartAmt, BigDecimal glStartAmt) throws EASBizException, BOSException {
        AccountBankInfo accountBank;
        boolean needCheck;
        CurrencyInfo currency = journalBalInfo.getCurrency();
        if (currency.getId().equals((Object)CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID) || currency.getId().equals((Object)CurrencyInfo.GENERAL_REPORT_CURRENCY_ID)) {
            return null;
        }
        if (journalBalInfo.getType() != null && journalBalInfo.getType().equals((Object)AccountTypeEnum.BANKACCOUNT) && !(needCheck = this.needCheck(ctx, (accountBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(journalBalInfo.getAccountBank().getId()))).getCompany().getId().toString(), accountBank, journalBalInfo.getAccountView().getId().toString()))) {
            return null;
        }
        CasGLItemCheckRptInfo rptInfo = new CasGLItemCheckRptInfo();
        if (journalBalInfo.getType() != null && journalBalInfo.getType().equals((Object)AccountTypeEnum.BANKACCOUNT)) {
            rptInfo.setAccountBankInfo(journalBalInfo.getAccountBank());
            rptInfo.setBankInfo(this.getBankInfo(journalBalInfo.getAccountBank()));
        }
        rptInfo.setAccountViewInfo(journalBalInfo.getAccountView());
        rptInfo.setCurrencyInfo(currency);
        rptInfo.setCasStartAmt(casStartAmt);
        rptInfo.setGlStartAmt(glStartAmt);
        return rptInfo;
    }

    private CasGLItemCheckRptInfo getGLContrastRptInfo(AccountBalanceInfo glInitInfo, BigDecimal casStartAmt, BigDecimal glStartAmt, AccountBankInfo acctBankInfo) {
        AccountViewInfo accountInfo;
        CurrencyInfo currency = glInitInfo.getCurrency();
        if (currency.getId().equals((Object)CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID) || currency.getId().equals((Object)CurrencyInfo.GENERAL_REPORT_CURRENCY_ID)) {
            return null;
        }
        CasGLItemCheckRptInfo rptInfo = new CasGLItemCheckRptInfo();
        if (acctBankInfo != null) {
            rptInfo.setAccountBankInfo(acctBankInfo);
            rptInfo.setBankInfo(this.getBankInfo(acctBankInfo));
        }
        if ((accountInfo = glInitInfo.getAccount()).isIsBank()) {
            // empty if block
        }
        rptInfo.setAccountViewInfo(accountInfo);
        rptInfo.setCurrencyInfo(currency);
        rptInfo.setCasStartAmt(casStartAmt);
        rptInfo.setGlStartAmt(glStartAmt);
        return rptInfo;
    }

    private BankInfo getBankInfo(AccountBankInfo acctBankInfo) {
        if (acctBankInfo == null || acctBankInfo.getBank() == null) {
            return null;
        }
        return acctBankInfo.getBank();
    }

    @Override
    protected boolean _checkBankBalance(Context ctx, String strCompanyId, String strPeriodId) throws BOSException, EASBizException {
        String currencyId;
        String acctViewId;
        String acctBankId;
        JournalBalanceInfo journalBalInfo;
        int i;
        boolean isBalanced = true;
        JournalBalanceCollection journalBalColl = this.getJournalBalanceCollection(ctx, strCompanyId, null, strPeriodId, AccountTypeEnum.BANKACCOUNT);
        JournalBalanceCollection searchJournalBalColl = this.getJournalBalanceCollection(ctx, strCompanyId, null, strPeriodId, AccountTypeEnum.ACCTSTATEMENT);
        Map searchMap = new HashMap();
        Map searchBankMap = new HashMap();
        if (searchJournalBalColl != null) {
            searchMap = CashHelper.getVOHashSearchMap((IObjectCollection)searchJournalBalColl, strKeys);
        }
        if (journalBalColl != null) {
            searchBankMap = CashHelper.getVOHashSearchMap((IObjectCollection)journalBalColl, strKeys);
        }
        AccountBankCollection acctBankCol = this.getAccountBankCollection(ctx, strCompanyId, null, false);
        Hashtable<String, JournalBalanceInfo> htExistCollection = new Hashtable<String, JournalBalanceInfo>();
        Hashtable<String, JournalBalanceInfo> bankExistCollection = new Hashtable<String, JournalBalanceInfo>();
        HashSet<String> bankCurrencySet = new HashSet<String>();
        HashSet<String> statCurrencySet = new HashSet<String>();
        if (journalBalColl != null && journalBalColl.size() != 0) {
            for (i = 0; i < journalBalColl.size(); ++i) {
                journalBalInfo = journalBalColl.get(i);
                acctBankId = journalBalInfo.getAccountBank().getId().toString();
                acctViewId = journalBalInfo.getAccountView().getId().toString();
                currencyId = journalBalInfo.getCurrency().getId().toString();
                bankCurrencySet.add(currencyId);
                htExistCollection.put(this.getIndexKey(acctBankId, acctViewId, currencyId), journalBalInfo);
            }
        }
        if (searchJournalBalColl != null && searchJournalBalColl.size() != 0) {
            for (i = 0; i < searchJournalBalColl.size(); ++i) {
                journalBalInfo = searchJournalBalColl.get(i);
                acctBankId = journalBalInfo.getAccountBank().getId().toString();
                acctViewId = journalBalInfo.getAccountView().getId().toString();
                currencyId = journalBalInfo.getCurrency().getId().toString();
                statCurrencySet.add(currencyId);
                bankExistCollection.put(this.getIndexKey(acctBankId, acctViewId, currencyId), journalBalInfo);
            }
        }
        int intAcctBankColSize = 0;
        PeriodInfo periodInfo = this.getPeriodById(ctx, strPeriodId);
        CompanyOrgUnitInfo companyInfo = this.getCompanyById(ctx, strCompanyId);
        if (acctBankCol != null) {
            intAcctBankColSize = acctBankCol.size();
        }
        CurrencyInfo currencyInfo = null;
        AccountBankInfo acctBank = null;
        String strAcctBankId = null;
        String indexKey = null;
        String acctViewId2 = null;
        String currencyId22 = null;
        this.filterCurrencyId(ctx, bankCurrencySet, strCompanyId, periodInfo.getNumber());
        this.filterCurrencyId(ctx, statCurrencySet, strCompanyId, periodInfo.getNumber());
        BigDecimal monthStartAmt = ZERO;
        String strIndex = null;
        JournalBalanceInfo info = null;
        for (int i2 = 0; i2 < intAcctBankColSize; ++i2) {
            acctBank = acctBankCol.get(i2);
            strAcctBankId = acctBank.getId().toString();
            acctViewId2 = acctBank.getAccount().getId().toString();
            JournalBalanceInfo journalBalInfo2 = null;
            for (String currencyId22 : bankCurrencySet) {
                currencyInfo = this.getCurrencyById(ctx, currencyId22);
                indexKey = this.getIndexKey(strAcctBankId, acctViewId2, currencyId22);
                if (htExistCollection.containsKey(indexKey)) {
                    journalBalInfo2 = (JournalBalanceInfo)htExistCollection.get(indexKey);
                    if (journalBalInfo2 == null) continue;
                    strIndex = CashHelper.getKeyString((IObjectValue)journalBalInfo2, strKeys);
                    info = (JournalBalanceInfo)searchMap.get(strIndex);
                    if (info != null) {
                        monthStartAmt = this.getBigDecimal(info.getMonthStartAmt());
                    }
                    journalBalInfo2.setAcctStatementMonthStartAmt(monthStartAmt);
                    isBalanced = this.isBalanced(ctx, journalBalInfo2, strCompanyId, journalBalInfo2.getCurrency().getId().toString(), periodInfo, strAcctBankId, monthStartAmt);
                    monthStartAmt = ZERO;
                    if (isBalanced) continue;
                    throw new CasException(CasException.BANKBALANCECHECK, new String[]{currencyInfo.getName(), journalBalInfo2.getAccountBank().getName(), journalBalInfo2.getAccountView().getName()});
                }
                journalBalInfo2 = new JournalBalanceInfo();
                journalBalInfo2.setAccountBank(acctBank);
                journalBalInfo2.setAccountView(acctBank.getAccount());
                journalBalInfo2.setCompany(companyInfo);
                journalBalInfo2.setCurrency(currencyInfo);
                journalBalInfo2.setPeriod(periodInfo);
                journalBalInfo2.setType(AccountTypeEnum.BANKACCOUNT);
                journalBalInfo2.setDebitStartAmt(ZERO);
                journalBalInfo2.setCreditStartAmt(ZERO);
                journalBalInfo2.setMonthStartAmt(ZERO);
                journalBalInfo2.setYearStartAmt(ZERO);
                strIndex = CashHelper.getKeyString((IObjectValue)journalBalInfo2, strKeys);
                info = (JournalBalanceInfo)searchMap.get(strIndex);
                if (info != null) {
                    monthStartAmt = this.getBigDecimal(info.getMonthStartAmt());
                }
                journalBalInfo2.setAcctStatementMonthStartAmt(monthStartAmt);
                isBalanced = this.isBalanced(ctx, journalBalInfo2, strCompanyId, currencyId22, periodInfo, strAcctBankId, monthStartAmt);
                monthStartAmt = ZERO;
                if (isBalanced) continue;
                throw new CasException(CasException.BANKBALANCECHECK, new String[]{currencyInfo.getName(), journalBalInfo2.getAccountBank().getName(), journalBalInfo2.getAccountView().getName()});
            }
            for (String currencyId22 : statCurrencySet) {
                indexKey = this.getIndexKey(strAcctBankId, acctViewId2, currencyId22);
                currencyInfo = this.getCurrencyById(ctx, currencyId22);
                if (bankExistCollection.containsKey(indexKey)) {
                    journalBalInfo2 = (JournalBalanceInfo)bankExistCollection.get(indexKey);
                    if (journalBalInfo2 == null) continue;
                    strIndex = CashHelper.getKeyString((IObjectValue)journalBalInfo2, strKeys);
                    info = (JournalBalanceInfo)searchBankMap.get(strIndex);
                    if (info != null) {
                        monthStartAmt = this.getBigDecimal(info.getMonthStartAmt());
                    }
                    journalBalInfo2.setJournalMonthStartAmt(monthStartAmt);
                    isBalanced = this.isBalanced(ctx, journalBalInfo2, strCompanyId, journalBalInfo2.getCurrency().getId().toString(), periodInfo, strAcctBankId, monthStartAmt);
                    monthStartAmt = ZERO;
                    if (isBalanced) continue;
                    throw new CasException(CasException.STATBALANCECHECK, new String[]{currencyInfo.getName(), journalBalInfo2.getAccountBank().getName(), journalBalInfo2.getAccountView().getName()});
                }
                journalBalInfo2 = new JournalBalanceInfo();
                journalBalInfo2.setAccountBank(acctBank);
                journalBalInfo2.setAccountView(acctBank.getAccount());
                journalBalInfo2.setCompany(companyInfo);
                journalBalInfo2.setCurrency(currencyInfo);
                journalBalInfo2.setPeriod(periodInfo);
                journalBalInfo2.setType(AccountTypeEnum.ACCTSTATEMENT);
                journalBalInfo2.setDebitStartAmt(ZERO);
                journalBalInfo2.setCreditStartAmt(ZERO);
                journalBalInfo2.setMonthStartAmt(ZERO);
                journalBalInfo2.setYearStartAmt(ZERO);
                strIndex = CashHelper.getKeyString((IObjectValue)journalBalInfo2, strKeys);
                info = (JournalBalanceInfo)searchBankMap.get(strIndex);
                if (info != null) {
                    monthStartAmt = this.getBigDecimal(info.getMonthStartAmt());
                }
                journalBalInfo2.setJournalMonthStartAmt(monthStartAmt);
                isBalanced = this.isBalanced(ctx, journalBalInfo2, strCompanyId, journalBalInfo2.getCurrency().getId().toString(), periodInfo, strAcctBankId, monthStartAmt);
                monthStartAmt = ZERO;
                if (isBalanced) continue;
                throw new CasException(CasException.STATBALANCECHECK, new String[]{currencyInfo.getName(), journalBalInfo2.getAccountBank().getName(), journalBalInfo2.getAccountView().getName()});
            }
        }
        return isBalanced;
    }

    protected boolean checkBankBalance_Bak(Context ctx, String strCompanyId, String strPeriodId) throws BOSException, EASBizException {
        String bankId;
        JournalBalanceInfo journalBalInfo;
        int i;
        boolean isBalanced = true;
        JournalBalanceCollection journalBalColl = this.getJournalBalanceCollection(ctx, strCompanyId, null, strPeriodId, AccountTypeEnum.BANKACCOUNT);
        JournalBalanceCollection searchJournalBalColl = this.getJournalBalanceCollection(ctx, strCompanyId, null, strPeriodId, AccountTypeEnum.ACCTSTATEMENT);
        Map searchMap = new HashMap();
        Map searchBankMap = new HashMap();
        if (searchJournalBalColl != null) {
            searchMap = CashHelper.getVOHashSearchMap((IObjectCollection)searchJournalBalColl, strKeys);
        }
        if (journalBalColl != null) {
            searchBankMap = CashHelper.getVOHashSearchMap((IObjectCollection)journalBalColl, strKeys);
        }
        AccountBankCollection acctBankCol = this.getAccountBankCollection(ctx, strCompanyId, null, false);
        Hashtable<String, JournalBalanceInfo> htExistCollection = new Hashtable<String, JournalBalanceInfo>();
        Hashtable<String, JournalBalanceInfo> bankExistCollection = new Hashtable<String, JournalBalanceInfo>();
        if (journalBalColl != null && journalBalColl.size() != 0) {
            for (i = 0; i < journalBalColl.size(); ++i) {
                journalBalInfo = journalBalColl.get(i);
                bankId = journalBalInfo.getAccountBank().getId().toString();
                htExistCollection.put(bankId, journalBalInfo);
            }
        }
        if (searchJournalBalColl != null && searchJournalBalColl.size() != 0) {
            for (i = 0; i < searchJournalBalColl.size(); ++i) {
                journalBalInfo = searchJournalBalColl.get(i);
                bankId = journalBalInfo.getAccountBank().getId().toString();
                bankExistCollection.put(bankId, journalBalInfo);
            }
        }
        int intAcctBankColSize = 0;
        PeriodInfo periodInfo = null;
        CompanyOrgUnitInfo companyInfo = null;
        CurrencyInfo currencyInfo = null;
        if (acctBankCol != null) {
            intAcctBankColSize = acctBankCol.size();
            periodInfo = this.getPeriodById(ctx, strPeriodId);
            companyInfo = this.getCompanyById(ctx, strCompanyId);
        }
        AccountBankInfo acctBank = null;
        String strAcctBankId = null;
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyCollection currencies = iCurrency.getCurrencyCollection(true);
        int currencySize = 0;
        if (currencies != null) {
            currencySize = currencies.size();
        }
        BigDecimal monthStartAmt = ZERO;
        String strIndex = null;
        JournalBalanceInfo info = null;
        for (int i2 = 0; i2 < intAcctBankColSize; ++i2) {
            int j;
            acctBank = acctBankCol.get(i2);
            strAcctBankId = acctBank.getId().toString();
            JournalBalanceInfo journalBalInfo2 = null;
            if (htExistCollection.containsKey(strAcctBankId)) {
                journalBalInfo2 = (JournalBalanceInfo)htExistCollection.get(strAcctBankId);
                if (journalBalInfo2 != null) {
                    strIndex = CashHelper.getKeyString((IObjectValue)journalBalInfo2, strKeys);
                    info = (JournalBalanceInfo)searchMap.get(strIndex);
                    if (info != null) {
                        monthStartAmt = this.getBigDecimal(info.getMonthStartAmt());
                    }
                    journalBalInfo2.setAcctStatementMonthStartAmt(monthStartAmt);
                    isBalanced = this.isBalanced(ctx, journalBalInfo2, strCompanyId, journalBalInfo2.getCurrency().getId().toString(), periodInfo, strAcctBankId, monthStartAmt);
                    monthStartAmt = ZERO;
                    if (!isBalanced) {
                        return false;
                    }
                }
            } else {
                for (j = 0; j < currencySize; ++j) {
                    currencyInfo = currencies.get(j);
                    journalBalInfo2 = new JournalBalanceInfo();
                    journalBalInfo2.setAccountBank(acctBank);
                    journalBalInfo2.setAccountView(acctBank.getAccount());
                    journalBalInfo2.setCompany(companyInfo);
                    journalBalInfo2.setCurrency(currencyInfo);
                    journalBalInfo2.setPeriod(periodInfo);
                    journalBalInfo2.setType(AccountTypeEnum.BANKACCOUNT);
                    journalBalInfo2.setDebitStartAmt(ZERO);
                    journalBalInfo2.setCreditStartAmt(ZERO);
                    journalBalInfo2.setMonthStartAmt(ZERO);
                    journalBalInfo2.setYearStartAmt(ZERO);
                    strIndex = CashHelper.getKeyString((IObjectValue)journalBalInfo2, strKeys);
                    info = (JournalBalanceInfo)searchMap.get(strIndex);
                    if (info != null) {
                        monthStartAmt = this.getBigDecimal(info.getMonthStartAmt());
                    }
                    journalBalInfo2.setAcctStatementMonthStartAmt(monthStartAmt);
                    isBalanced = this.isBalanced(ctx, journalBalInfo2, strCompanyId, currencyInfo.getId().toString(), periodInfo, strAcctBankId, monthStartAmt);
                    monthStartAmt = ZERO;
                    if (isBalanced) continue;
                    return false;
                }
            }
            if (bankExistCollection.containsKey(strAcctBankId)) {
                journalBalInfo2 = (JournalBalanceInfo)bankExistCollection.get(strAcctBankId);
                if (journalBalInfo2 == null) continue;
                strIndex = CashHelper.getKeyString((IObjectValue)journalBalInfo2, strKeys);
                info = (JournalBalanceInfo)searchBankMap.get(strIndex);
                if (info != null) {
                    monthStartAmt = this.getBigDecimal(info.getMonthStartAmt());
                }
                journalBalInfo2.setJournalMonthStartAmt(monthStartAmt);
                isBalanced = this.isBalanced(ctx, journalBalInfo2, strCompanyId, journalBalInfo2.getCurrency().getId().toString(), periodInfo, strAcctBankId, monthStartAmt);
                monthStartAmt = ZERO;
                if (isBalanced) continue;
                return false;
            }
            for (j = 0; j < currencySize; ++j) {
                journalBalInfo2 = new JournalBalanceInfo();
                journalBalInfo2.setAccountBank(acctBank);
                journalBalInfo2.setAccountView(acctBank.getAccount());
                journalBalInfo2.setCompany(companyInfo);
                journalBalInfo2.setCurrency(currencyInfo);
                journalBalInfo2.setPeriod(periodInfo);
                journalBalInfo2.setType(AccountTypeEnum.ACCTSTATEMENT);
                journalBalInfo2.setDebitStartAmt(ZERO);
                journalBalInfo2.setCreditStartAmt(ZERO);
                journalBalInfo2.setMonthStartAmt(ZERO);
                journalBalInfo2.setYearStartAmt(ZERO);
                strIndex = CashHelper.getKeyString((IObjectValue)journalBalInfo2, strKeys);
                info = (JournalBalanceInfo)searchBankMap.get(strIndex);
                if (info != null) {
                    monthStartAmt = this.getBigDecimal(info.getMonthStartAmt());
                }
                journalBalInfo2.setJournalMonthStartAmt(monthStartAmt);
                isBalanced = this.isBalanced(ctx, journalBalInfo2, strCompanyId, journalBalInfo2.getCurrency().getId().toString(), periodInfo, strAcctBankId, monthStartAmt);
                monthStartAmt = ZERO;
                if (isBalanced) continue;
                return false;
            }
        }
        return isBalanced;
    }

    private boolean isBalanced(Context ctx, JournalBalanceInfo journalBalInfo, String strCompanyId, String strCurrencyId, PeriodInfo periodInfo, String strAcctBankId, BigDecimal monthStartAmt) {
        BigDecimal journalDiffVal = this.getEnterpriseUnreachDiff(ctx, strCompanyId, strCurrencyId, strAcctBankId, periodInfo, VerifyScopeEnum.NOVA);
        BigDecimal journalBeginAmt = ZERO;
        BigDecimal statementBeginAmt = ZERO;
        AccountTypeEnum type = journalBalInfo.getType();
        if (type.equals((Object)AccountTypeEnum.BANKACCOUNT)) {
            journalBeginAmt = this.getBigDecimal(journalBalInfo.getMonthStartAmt());
            statementBeginAmt = monthStartAmt;
        } else if (type.equals((Object)AccountTypeEnum.ACCTSTATEMENT)) {
            journalBeginAmt = monthStartAmt;
            statementBeginAmt = this.getBigDecimal(journalBalInfo.getMonthStartAmt());
        }
        BigDecimal adjustJournalBeginAmt = journalBeginAmt.add(journalDiffVal);
        journalBalInfo.setAdjustedJournalMonthStartAmt(adjustJournalBeginAmt);
        BigDecimal statementDiffVal = this.getBankUnreachDiff(ctx, strCompanyId, strCurrencyId, strAcctBankId, periodInfo, VerifyScopeEnum.NOVA);
        BigDecimal adjustStatementBeginAmt = statementBeginAmt.add(this.getBigDecimal(statementDiffVal));
        journalBalInfo.setAdjustedASMonthStartAmt(adjustStatementBeginAmt);
        return adjustJournalBeginAmt.compareTo(adjustStatementBeginAmt) == 0;
    }

    private JournalBalanceCollection getJournalBalanceCollection(Context ctx, String strCompanyId, String strCurrencyId, String strPeriodId, Set typeSet) throws BOSException {
        IJournalBalance iJournalBalance = JournalBalanceFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        viewInfo.setFilter(filterInfo);
        if (strCurrencyId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("currency", (Object)strCurrencyId));
        }
        if (strCompanyId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("company", (Object)strCompanyId));
        }
        if (strPeriodId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)strPeriodId));
        }
        if (typeSet != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)typeSet, CompareType.INCLUDE));
        }
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("accountBank.id"));
        sic.add(new SelectorItemInfo("accountBank.number"));
        sic.add(new SelectorItemInfo("accountBank.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("monthStartAmt"));
        sic.add(new SelectorItemInfo("monthDebitAmt"));
        sic.add(new SelectorItemInfo("monthCreditAmt"));
        sic.add(new SelectorItemInfo("monthBalance"));
        sic.add(new SelectorItemInfo("yearStartAmt"));
        sic.add(new SelectorItemInfo("yearDebitAmt"));
        sic.add(new SelectorItemInfo("yearCreditAmt"));
        sic.add(new SelectorItemInfo("yearBalance"));
        sic.add(new SelectorItemInfo("debitStartAmt"));
        sic.add(new SelectorItemInfo("creditStartAmt"));
        sic.add(new SelectorItemInfo("isInit"));
        sic.add(new SelectorItemInfo("isBalanced"));
        sic.add(new SelectorItemInfo("type"));
        JournalBalanceCollection JournalBalanceCollection2 = iJournalBalance.getJournalBalanceCollection(viewInfo);
        return JournalBalanceCollection2;
    }

    @Override
    protected boolean _hasInitData(Context ctx, IObjectPK companyPK) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection con;
        block10: {
            boolean bl;
            StringBuffer sql;
            block9: {
                block8: {
                    block7: {
                        IMIntObjectCheckFacadeFactory.getLocalInstance((Context)ctx).checkExistBankAcctIntObject(companyPK.toString());
                        sql = new StringBuffer();
                        con = null;
                        pstmt = null;
                        rs = null;
                        con = this.getConnection(ctx);
                        sql.append("SELECT TOP 1 FID FROM T_CAS_Journal ").append("WHERE FCompanyID = ? ");
                        pstmt = con.prepareStatement(sql.toString());
                        pstmt.setString(1, companyPK.toString());
                        rs = pstmt.executeQuery();
                        if (!rs.next()) break block7;
                        boolean bl2 = true;
                        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
                        return bl2;
                    }
                    sql = new StringBuffer();
                    sql.append("SELECT TOP 1 FID FROM T_CAS_BankStatement ").append("WHERE FCompanyID = ?  ");
                    pstmt.setString(1, companyPK.toString());
                    rs = pstmt.executeQuery();
                    if (!rs.next()) break block8;
                    boolean bl3 = true;
                    SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
                    return bl3;
                }
                sql = new StringBuffer();
                sql.append("SELECT TOP 1 FID FROM T_CAS_JournalBalance ").append("WHERE FCompanyID = ?  ");
                pstmt.setString(1, companyPK.toString());
                rs = pstmt.executeQuery();
                if (!rs.next()) break block9;
                boolean bl4 = true;
                SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
                return bl4;
            }
            try {
                sql = new StringBuffer();
                sql.append("SELECT TOP 1 FID FROM T_CAS_CashCount ").append("WHERE FCompanyID = ? ");
                pstmt.setString(1, companyPK.toString());
                rs = pstmt.executeQuery();
                if (!rs.next()) break block10;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pstmt, (Connection)con);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return false;
    }

    @Override
    protected void _submit(Context ctx, IObjectCollection initInfoCol, AccountTypeEnum acctType) throws BOSException, EASBizException {
        if (initInfoCol == null || initInfoCol.size() == 0) {
            return;
        }
        JournalBalanceInfo tempInfo = (JournalBalanceInfo)initInfoCol.getObject(0);
        this.deleteOldInitData(ctx, tempInfo.getType().getValue(), tempInfo.getCompany().getId().toString(), tempInfo.getCurrency().getId().toString(), tempInfo.getPeriod().getId().toString());
        int size = initInfoCol.size();
        IJournalBalance iJournalBalance = JournalBalanceFactory.getLocalInstance(ctx);
        for (int i = 0; i < size; ++i) {
            JournalBalanceInfo journalBalInfo = (JournalBalanceInfo)initInfoCol.getObject(i);
            journalBalInfo.setIsInit(true);
            if (acctType.equals((Object)AccountTypeEnum.CASHACCOUNT)) {
                journalBalInfo.setIsBalanced(true);
            }
            if (acctType.equals((Object)AccountTypeEnum.ACCTSTATEMENT) || acctType.equals((Object)AccountTypeEnum.BANKACCOUNT)) {
                JournalBalanceInfo info;
                String strCompanyId = journalBalInfo.getCompany().getId().toString();
                String strCurrencyId = journalBalInfo.getCurrency().getId().toString();
                PeriodInfo periodInfo = journalBalInfo.getPeriod();
                String strPeriodId = periodInfo.getId().toString();
                String strAcctBankId = journalBalInfo.getAccountBank().getId().toString();
                BigDecimal monthStartAmt = ZERO;
                if (acctType.equals((Object)AccountTypeEnum.BANKACCOUNT)) {
                    info = this.getJournalBalanceInfo(ctx, strCompanyId, strCurrencyId, strPeriodId, strAcctBankId, AccountTypeEnum.ACCTSTATEMENT);
                    if (info != null) {
                        monthStartAmt = this.getBigDecimal(info.getMonthStartAmt());
                    }
                    journalBalInfo.setAcctStatementMonthStartAmt(monthStartAmt);
                } else if (acctType.equals((Object)AccountTypeEnum.ACCTSTATEMENT)) {
                    info = this.getJournalBalanceInfo(ctx, strCompanyId, strCurrencyId, strPeriodId, strAcctBankId, AccountTypeEnum.BANKACCOUNT);
                    if (info != null) {
                        monthStartAmt = this.getBigDecimal(info.getMonthStartAmt());
                    }
                    journalBalInfo.setAcctStatementMonthStartAmt(monthStartAmt);
                }
                this.setAdjustMonthStartAmt(ctx, journalBalInfo, strCompanyId, strCurrencyId, periodInfo, strAcctBankId, monthStartAmt);
            }
            journalBalInfo.setMonthBalance(this.getBigDecimal(journalBalInfo.getMonthStartAmt()));
            iJournalBalance.addnew(journalBalInfo);
        }
    }

    @Override
    protected void _save(Context ctx, IObjectCollection initInfoColl, IObjectValue paramInfo) throws BOSException, EASBizException {
        if (paramInfo == null) {
            return;
        }
        JournalBalanceInfo paramJournalBalInfo = (JournalBalanceInfo)paramInfo;
        AccountTypeEnum acctType = paramJournalBalInfo.getType();
        this.deleteOldInitData(ctx, acctType.getValue(), paramJournalBalInfo.getCompany().getId().toString(), paramJournalBalInfo.getCurrency().getId().toString(), paramJournalBalInfo.getPeriod().getId().toString());
        if (initInfoColl == null || initInfoColl.size() == 0) {
            return;
        }
        int size = initInfoColl.size();
        IJournalBalance iJournalBalance = JournalBalanceFactory.getLocalInstance(ctx);
        for (int i = 0; i < size; ++i) {
            JournalBalanceInfo journalBalInfo = (JournalBalanceInfo)initInfoColl.getObject(i);
            if (journalBalInfo.getMonthStartAmt().compareTo(Constants.ZERO) == 0 && journalBalInfo.getDebitStartAmt().compareTo(Constants.ZERO) == 0 && journalBalInfo.getCreditStartAmt().compareTo(Constants.ZERO) == 0) continue;
            journalBalInfo.setId(null);
            journalBalInfo.setIsInit(true);
            if (acctType.equals((Object)AccountTypeEnum.CASHACCOUNT)) {
                journalBalInfo.setIsBalanced(true);
            }
            if (acctType.equals((Object)AccountTypeEnum.ACCTSTATEMENT) || acctType.equals((Object)AccountTypeEnum.BANKACCOUNT)) {
                String strAcctBankId = journalBalInfo.getAccountBank().getId().toString();
                AccountBankInfo acctBankInfo = this.getAcctBankInfoById(ctx, strAcctBankId);
                journalBalInfo.setAccountView(acctBankInfo.getAccount());
            }
            journalBalInfo.setMonthBalance(this.getBigDecimal(journalBalInfo.getMonthStartAmt()));
            BigDecimal yearStartAmt = ZERO;
            yearStartAmt = acctType.equals((Object)AccountTypeEnum.ACCTSTATEMENT) ? this.getBigDecimal(journalBalInfo.getMonthStartAmt()).subtract(this.getBigDecimal(journalBalInfo.getCreditStartAmt())).add(this.getBigDecimal(journalBalInfo.getDebitStartAmt())) : this.getBigDecimal(journalBalInfo.getMonthStartAmt()).add(this.getBigDecimal(journalBalInfo.getCreditStartAmt())).subtract(this.getBigDecimal(journalBalInfo.getDebitStartAmt()));
            journalBalInfo.setYearStartAmt(yearStartAmt);
            journalBalInfo.setYearBalance(journalBalInfo.getMonthStartAmt());
            journalBalInfo.setYearCreditAmt(this.getBigDecimal(journalBalInfo.getCreditStartAmt()));
            journalBalInfo.setYearDebitAmt(this.getBigDecimal(journalBalInfo.getDebitStartAmt()));
            iJournalBalance.addnew(journalBalInfo);
        }
    }

    private void deleteOldInitData(Context ctx, int type, String companyId, String currencyId, String periodId) throws BOSException {
        String sqlStr = "DELETE T_CAS_JournalBalance WHERE FType=? AND FCompanyId=? AND FCurrencyId=? AND FPeriodId=?";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sqlStr);
            ps.setInt(1, type);
            ps.setString(2, companyId);
            ps.setString(3, currencyId);
            ps.setString(4, periodId);
            ps.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    @Override
    protected IObjectCollection _getInitCollection(Context ctx, AccountTypeEnum accountType, String strCompanyId, String strCurrencyId, String periodId) throws EASBizException, BOSException {
        IObjectCollection coll = null;
        if (accountType.equals((Object)AccountTypeEnum.CASHACCOUNT)) {
            coll = this.createJournalBalCollByAcctView(ctx, strCompanyId, strCurrencyId, periodId);
        } else if (accountType.equals((Object)AccountTypeEnum.BANKACCOUNT)) {
            coll = this.createJournalBalCollByAcctBank(ctx, strCompanyId, strCurrencyId, periodId);
        } else if (accountType.equals((Object)AccountTypeEnum.ACCTSTATEMENT)) {
            coll = this.createJournalBalCollByAcctStat(ctx, strCompanyId, strCurrencyId, periodId);
        }
        return coll;
    }

    private void deleteUnusedInitData(Context ctx, String companyId, String periodId) throws BOSException {
        String sqlStr = "DELETE T_CAS_JournalBalance WHERE FCompanyId=? AND FPeriodId !=? AND FIsInit=1";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sqlStr);
            ps.setString(1, companyId);
            ps.setString(2, periodId);
            ps.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    @Override
    protected void _finishInit(Context ctx, String strCompanyId, String strPeriodId) throws BOSException, EASBizException {
        boolean bln = this._checkBankBalance(ctx, strCompanyId, strPeriodId);
        if (bln) {
            String sql = "DELETE FROM T_CAS_JournalBalance WHERE FCompanyId = ? AND FPeriodId <> ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{strCompanyId, strPeriodId});
            HashSet<Integer> typeSet = new HashSet<Integer>();
            typeSet.add(new Integer(1));
            typeSet.add(new Integer(2));
            typeSet.add(new Integer(3));
            JournalBalanceCollection journalBalColl = this.getJournalBalanceCollection(ctx, strCompanyId, null, strPeriodId, typeSet);
            if (journalBalColl != null) {
                int size = journalBalColl.size();
                IJournalBalance iJournalBal = JournalBalanceFactory.getLocalInstance(ctx);
                for (int i = 0; i < size; ++i) {
                    JournalBalanceInfo journalBalInfo = journalBalColl.get(i);
                    journalBalInfo.setIsInit(false);
                    journalBalInfo.setId(null);
                    iJournalBal.addnew(journalBalInfo);
                }
            }
            ISystemStatusCtrol iSystemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
            iSystemStatusCtrol.start(SystemEnum.CASHMANAGEMENT, this.getCompanyById(ctx, strCompanyId), true);
        }
    }

    @Override
    protected void _antiInit(Context ctx, String strCompanyId, String strPeriodId) throws BOSException, EASBizException {
        PeriodInfo periodInfo;
        CompanyOrgUnitInfo company = this.getCompanyById(ctx, strCompanyId);
        boolean isInit = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        if (!isInit) {
            throw new CasException(CasException.CHECK_CASINIT);
        }
        PeriodInfo startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        if (!startPeriodInfo.equals((Object)(periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company)))) {
            throw new CasException(CasException.CHECK_PERIOD);
        }
        this.deleteOldJournalBalData(ctx, strCompanyId, strPeriodId);
        ISubAcctMgtInitFacade iSubAcctMgtInitFacade = SubAcctMgtInitFacadeFactory.getLocalInstance(ctx);
        iSubAcctMgtInitFacade.antiInit(strCompanyId, strPeriodId);
        ISystemStatusCtrol iSystemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        iSystemStatusCtrol.start(SystemEnum.CASHMANAGEMENT, company, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void deleteOldJournalBalData(Context ctx, String strCompanyId, String strPeriodId) throws BOSException, EASBizException {
        String sql = "DELETE T_CAS_JournalBalance WHERE FCompanyId=? AND FPeriodId=? AND FIsInit = 0 ";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sql);
            ps.setString(1, strCompanyId);
            ps.setString(2, strPeriodId);
            ps.executeUpdate();
        }
        catch (SQLException sQLException) {
            SQLUtils.cleanup(ps, (Connection)conn);
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    @Override
    protected IObjectCollection _getInitCollectionFromGL(Context ctx, AccountTypeEnum accountType, String strCompanyId, String strCurrencyId, String periodId) throws EASBizException, BOSException {
        IObjectCollection coll = null;
        if (accountType.equals((Object)AccountTypeEnum.CASHACCOUNT)) {
            coll = this.createCashAccInitCollFromGL(ctx, strCompanyId, strCurrencyId, periodId, accountType);
        } else if (accountType.equals((Object)AccountTypeEnum.ACCTSTATEMENT) || accountType.equals((Object)AccountTypeEnum.BANKACCOUNT)) {
            coll = this.createBankAccInitCollFromGL(ctx, strCompanyId, strCurrencyId, periodId, accountType);
        }
        return coll;
    }

    private AccountBankInfo getAcctBankInfoById(Context ctx, String acctBankId) throws EASBizException, BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("bank.id");
        selector.add("bank.name");
        selector.add("bank.number");
        selector.add("account.id");
        selector.add("account.name");
        selector.add("account.number");
        FilterInfo fi = new FilterInfo();
        FilterItemCollection items = fi.getFilterItems();
        items.add(new FilterItemInfo("id", (Object)acctBankId));
        evi.setFilter(fi);
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        AccountBankCollection acctBankCol = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(evi);
        return acctBankCol == null ? null : acctBankCol.get(0);
    }

    private CompanyOrgUnitInfo getCompanyById(Context ctx, String strId) throws EASBizException, BOSException {
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo company = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(strId));
        return company;
    }

    private CurrencyInfo getCurrencyById(Context ctx, String strId) throws EASBizException, BOSException {
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyInfo currency = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(strId));
        return currency;
    }

    private PeriodInfo getPeriodById(Context ctx, String strId) throws EASBizException, BOSException {
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        PeriodInfo period = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(strId));
        return period;
    }

    private IObjectCollection createJournalBalCollByAcctView(Context ctx, String strCompanyId, String strCurrencyId, String strPeriodId) throws BOSException, EASBizException {
        JournalBalanceCollection coll = new JournalBalanceCollection();
        JournalBalanceCollection journalBalColl = this.getJournalBalanceCollection(ctx, strCompanyId, strCurrencyId, strPeriodId, AccountTypeEnum.CASHACCOUNT);
        String currAcctTableId = this.getCurrAcctTableId(ctx, strCompanyId, strPeriodId);
        AccountViewCollection acctViewCol = this.getAccountViewCollection(ctx, strCompanyId, currAcctTableId, strCurrencyId, AccountTypeEnum.CASHACCOUNT);
        Hashtable<String, JournalBalanceInfo> htExistCollection = new Hashtable<String, JournalBalanceInfo>();
        if (journalBalColl != null && journalBalColl.size() != 0) {
            for (int i = 0; i < journalBalColl.size(); ++i) {
                JournalBalanceInfo journalBalInfo = journalBalColl.get(i);
                String accountId = journalBalInfo.getAccountView().getId().toString();
                htExistCollection.put(accountId, journalBalInfo);
            }
        }
        int intAcctViewColSize = 0;
        if (acctViewCol != null) {
            intAcctViewColSize = acctViewCol.size();
        }
        AccountViewInfo acctview = null;
        String strAccountId = null;
        for (int i = 0; i < intAcctViewColSize; ++i) {
            JournalBalanceInfo journalBalInfo;
            acctview = acctViewCol.get(i);
            strAccountId = acctview.getId().toString();
            if (htExistCollection.containsKey(strAccountId)) {
                journalBalInfo = (JournalBalanceInfo)htExistCollection.get(strAccountId);
                coll.add(journalBalInfo);
                continue;
            }
            journalBalInfo = new JournalBalanceInfo();
            journalBalInfo.setAccountView(acctview);
            journalBalInfo.setCompany(this.getCompanyById(ctx, strCompanyId));
            journalBalInfo.setCurrency(this.getCurrencyById(ctx, strCurrencyId));
            journalBalInfo.setPeriod(this.getPeriodById(ctx, strPeriodId));
            journalBalInfo.setType(AccountTypeEnum.CASHACCOUNT);
            journalBalInfo.setDebitStartAmt(ZERO);
            journalBalInfo.setCreditStartAmt(ZERO);
            journalBalInfo.setMonthStartAmt(ZERO);
            journalBalInfo.setYearStartAmt(ZERO);
            coll.add(journalBalInfo);
        }
        return coll;
    }

    private String getCurrAcctTableId(Context ctx, String companyId, String periodId) throws BOSException, EASBizException {
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo company = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        String cuId = company.getCU().getId().toString();
        String acctTableId = company.getAccountTable().getId().toString();
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        PeriodInfo period = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodId));
        String currAcctTableId = AccountTools.getCurrentAcctTable((Context)ctx, (String)cuId, (String)acctTableId, (int)period.getPeriodYear(), (int)period.getPeriodNumber());
        return currAcctTableId;
    }

    private IObjectCollection createJournalBalCollByAcctBank(Context ctx, String strCompanyId, String strCurrencyId, String strPeriodId) throws BOSException, EASBizException {
        JournalBalanceCollection coll = new JournalBalanceCollection();
        JournalBalanceCollection journalBalColl = this.getJournalBalanceCollection(ctx, strCompanyId, strCurrencyId, strPeriodId, AccountTypeEnum.BANKACCOUNT);
        JournalBalanceCollection searchJournalBalColl = this.getJournalBalanceCollection(ctx, strCompanyId, strCurrencyId, strPeriodId, AccountTypeEnum.ACCTSTATEMENT);
        Map searchMap = new HashMap();
        if (searchJournalBalColl != null) {
            searchMap = CashHelper.getVOHashSearchMap((IObjectCollection)searchJournalBalColl, strKeys);
        }
        AccountBankCollection acctBankCol = this.getAccountBankCollection(ctx, strCompanyId, strCurrencyId, true);
        Hashtable<String, JournalBalanceInfo> htExistCollection = new Hashtable<String, JournalBalanceInfo>();
        if (journalBalColl != null && journalBalColl.size() != 0) {
            for (int i = 0; i < journalBalColl.size(); ++i) {
                JournalBalanceInfo journalBalInfo = journalBalColl.get(i);
                String bankId = journalBalInfo.getAccountBank().getId().toString();
                htExistCollection.put(bankId, journalBalInfo);
            }
        }
        int intAcctBankColSize = 0;
        PeriodInfo periodInfo = null;
        CompanyOrgUnitInfo companyInfo = null;
        CurrencyInfo currencyInfo = null;
        if (acctBankCol != null) {
            intAcctBankColSize = acctBankCol.size();
            periodInfo = this.getPeriodById(ctx, strPeriodId);
            companyInfo = this.getCompanyById(ctx, strCompanyId);
            currencyInfo = this.getCurrencyById(ctx, strCurrencyId);
        }
        AccountBankInfo acctBank = null;
        String strAcctBankId = null;
        for (int i = 0; i < intAcctBankColSize; ++i) {
            acctBank = acctBankCol.get(i);
            strAcctBankId = acctBank.getId().toString();
            JournalBalanceInfo journalBalInfo = null;
            if (htExistCollection.containsKey(strAcctBankId)) {
                journalBalInfo = (JournalBalanceInfo)htExistCollection.get(strAcctBankId);
            } else {
                journalBalInfo = new JournalBalanceInfo();
                journalBalInfo.setAccountBank(acctBank);
                journalBalInfo.setAccountView(acctBank.getAccount());
                journalBalInfo.setCompany(companyInfo);
                journalBalInfo.setCurrency(currencyInfo);
                journalBalInfo.setPeriod(periodInfo);
                journalBalInfo.setType(AccountTypeEnum.BANKACCOUNT);
                journalBalInfo.setDebitStartAmt(ZERO);
                journalBalInfo.setCreditStartAmt(ZERO);
                journalBalInfo.setMonthStartAmt(ZERO);
                journalBalInfo.setYearStartAmt(ZERO);
            }
            if (journalBalInfo == null) continue;
            String strIndex = CashHelper.getKeyString((IObjectValue)journalBalInfo, strKeys);
            JournalBalanceInfo info = (JournalBalanceInfo)searchMap.get(strIndex);
            BigDecimal monthStartAmt = ZERO;
            if (info != null) {
                monthStartAmt = this.getBigDecimal(info.getMonthStartAmt());
                journalBalInfo.put("isExistOppData", Boolean.TRUE);
            } else {
                journalBalInfo.put("isExistOppData", Boolean.FALSE);
            }
            journalBalInfo.setAcctStatementMonthStartAmt(monthStartAmt);
            this.setAdjustMonthStartAmt(ctx, journalBalInfo, strCompanyId, strCurrencyId, periodInfo, strAcctBankId, monthStartAmt);
            coll.add(journalBalInfo);
        }
        return coll;
    }

    private void setAdjustMonthStartAmt(Context ctx, JournalBalanceInfo journalBalInfo, String strCompanyId, String strCurrencyId, PeriodInfo periodInfo, String strAcctBankId, BigDecimal monthStartAmt) {
        BigDecimal journalDiffVal = this.getEnterpriseUnreachDiff(ctx, strCompanyId, strCurrencyId, strAcctBankId, periodInfo, VerifyScopeEnum.NOVA);
        BigDecimal journalBeginAmt = ZERO;
        BigDecimal statementBeginAmt = ZERO;
        AccountTypeEnum type = journalBalInfo.getType();
        if (type.equals((Object)AccountTypeEnum.BANKACCOUNT)) {
            journalBeginAmt = this.getBigDecimal(journalBalInfo.getMonthStartAmt());
            statementBeginAmt = monthStartAmt;
        } else if (type.equals((Object)AccountTypeEnum.ACCTSTATEMENT)) {
            journalBeginAmt = monthStartAmt;
            statementBeginAmt = this.getBigDecimal(journalBalInfo.getMonthStartAmt());
        }
        BigDecimal adjustJournalBeginAmt = journalBeginAmt.add(journalDiffVal);
        journalBalInfo.setAdjustedJournalMonthStartAmt(adjustJournalBeginAmt);
        BigDecimal statementDiffVal = this.getBankUnreachDiff(ctx, strCompanyId, strCurrencyId, strAcctBankId, periodInfo, VerifyScopeEnum.NOVA);
        BigDecimal adjustStatementBeginAmt = statementBeginAmt.add(this.getBigDecimal(statementDiffVal));
        journalBalInfo.setAdjustedASMonthStartAmt(adjustStatementBeginAmt);
        if (adjustJournalBeginAmt.compareTo(adjustStatementBeginAmt) == 0) {
            journalBalInfo.setIsBalanced(true);
        } else {
            journalBalInfo.setIsBalanced(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private BigDecimal getEnterpriseUnreachDiff(Context ctx, String strCompanyId, String strCurrencyId, String strAcctBankId, PeriodInfo periodInfo, VerifyScopeEnum status) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        BigDecimal diffVal;
        block6: {
            diffVal = ZERO;
            StringBuffer strSql = new StringBuffer();
            strSql.append("select sum(ISNULL(tB.FDebitAmount,0.00)) debitAmtSum,  ").append("sum(ISNULL(tB.FCreditAmount,0.00)) creditAmtSum ").append(" from T_CAS_BankStatement tB").append(" where tB.FCompanyId = ? ").append(" and tB.FCurrencyId = ? ").append(" and tB.FAccountBankID = ? ").append(" and tB.FCreateDate < ? ");
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection(ctx);
                stmt = con.prepareStatement(strSql.toString());
                stmt.setString(1, strCompanyId);
                stmt.setString(2, strCurrencyId);
                stmt.setString(3, strAcctBankId);
                stmt.setDate(4, TypeConversionUtils.objToDate((Object)periodInfo.getBeginDate()));
                rs = stmt.executeQuery();
                if (rs == null || !rs.next()) break block6;
                BigDecimal debitAmtSum = this.getBigDecimal(rs.getBigDecimal("debitAmtSum"));
                BigDecimal creditAmtSum = this.getBigDecimal(rs.getBigDecimal("creditAmtSum"));
                diffVal = creditAmtSum.subtract(debitAmtSum);
            }
            catch (SQLException sql) {
                logger.error((Object)sql);
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)con);
            }
            catch (SQLDataException exp) {
                logger.error((Object)exp);
                {
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs, stmt, (Connection)con);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)con);
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return diffVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private BigDecimal getBankUnreachDiff(Context ctx, String strCompanyId, String strCurrencyId, String strAcctBankId, PeriodInfo periodInfo, VerifyScopeEnum status) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        BigDecimal diffVal;
        block6: {
            diffVal = ZERO;
            StringBuffer strSql = new StringBuffer();
            strSql.append("select sum(ISNULL(tJ.FDebitAmount,0.00)) debitAmtSum,  ").append("sum(ISNULL(tJ.FCreditAmount,0.00)) creditAmtSum ").append(" from T_CAS_Journal tJ").append(" where tJ.FCompanyId = ? ").append(" and tJ.FCurrencyId = ? ").append(" and tJ.FAccountBankID = ? ").append(" and tJ.FCreateDate < ? ");
            con = null;
            stmt = null;
            rs = null;
            try {
                con = this.getConnection(ctx);
                stmt = con.prepareStatement(strSql.toString());
                stmt.setString(1, strCompanyId);
                stmt.setString(2, strCurrencyId);
                stmt.setString(3, strAcctBankId);
                stmt.setDate(4, TypeConversionUtils.objToDate((Object)periodInfo.getBeginDate()));
                rs = stmt.executeQuery();
                if (rs == null || !rs.next()) break block6;
                BigDecimal debitAmtSum = this.getBigDecimal(rs.getBigDecimal("debitAmtSum"));
                BigDecimal creditAmtSum = this.getBigDecimal(rs.getBigDecimal("creditAmtSum"));
                diffVal = debitAmtSum.subtract(creditAmtSum);
            }
            catch (SQLException sql) {
                logger.error((Object)sql);
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)con);
            }
            catch (SQLDataException exp) {
                logger.error((Object)exp);
                {
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs, stmt, (Connection)con);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)con);
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return diffVal;
    }

    private IObjectCollection createJournalBalCollByAcctStat(Context ctx, String strCompanyId, String strCurrencyId, String strPeriodId) throws BOSException, EASBizException {
        JournalBalanceCollection coll = new JournalBalanceCollection();
        JournalBalanceCollection journalBalColl = this.getJournalBalanceCollection(ctx, strCompanyId, strCurrencyId, strPeriodId, AccountTypeEnum.ACCTSTATEMENT);
        JournalBalanceCollection searchJournalBalColl = this.getJournalBalanceCollection(ctx, strCompanyId, strCurrencyId, strPeriodId, AccountTypeEnum.BANKACCOUNT);
        Map searchMap = new HashMap();
        if (searchJournalBalColl != null) {
            searchMap = CashHelper.getVOHashSearchMap((IObjectCollection)searchJournalBalColl, strKeys);
        }
        AccountBankCollection acctBankCol = this.getAccountBankCollection(ctx, strCompanyId, strCurrencyId, true);
        Hashtable<String, JournalBalanceInfo> htExistCollection = new Hashtable<String, JournalBalanceInfo>();
        if (journalBalColl != null && journalBalColl.size() != 0) {
            for (int i = 0; i < journalBalColl.size(); ++i) {
                JournalBalanceInfo journalBalInfo = journalBalColl.get(i);
                String bankId = journalBalInfo.getAccountBank().getId().toString();
                htExistCollection.put(bankId, journalBalInfo);
            }
        }
        int intAcctBankColSize = 0;
        PeriodInfo periodInfo = null;
        CompanyOrgUnitInfo companyInfo = null;
        CurrencyInfo currencyInfo = null;
        if (acctBankCol != null) {
            intAcctBankColSize = acctBankCol.size();
            periodInfo = this.getPeriodById(ctx, strPeriodId);
            companyInfo = this.getCompanyById(ctx, strCompanyId);
            currencyInfo = this.getCurrencyById(ctx, strCurrencyId);
        }
        AccountBankInfo acctBank = null;
        String strAcctBankId = null;
        for (int i = 0; i < intAcctBankColSize; ++i) {
            acctBank = acctBankCol.get(i);
            strAcctBankId = acctBank.getId().toString();
            JournalBalanceInfo journalBalInfo = null;
            if (htExistCollection.containsKey(strAcctBankId)) {
                journalBalInfo = (JournalBalanceInfo)htExistCollection.get(strAcctBankId);
            } else {
                journalBalInfo = new JournalBalanceInfo();
                journalBalInfo.setAccountBank(acctBank);
                journalBalInfo.setAccountView(acctBank.getAccount());
                journalBalInfo.setCompany(companyInfo);
                journalBalInfo.setCurrency(currencyInfo);
                journalBalInfo.setPeriod(periodInfo);
                journalBalInfo.setType(AccountTypeEnum.ACCTSTATEMENT);
                journalBalInfo.setDebitStartAmt(ZERO);
                journalBalInfo.setCreditStartAmt(ZERO);
                journalBalInfo.setMonthStartAmt(ZERO);
                journalBalInfo.setYearStartAmt(ZERO);
            }
            if (journalBalInfo == null) continue;
            String strIndex = CashHelper.getKeyString((IObjectValue)journalBalInfo, strKeys);
            JournalBalanceInfo info = (JournalBalanceInfo)searchMap.get(strIndex);
            BigDecimal monthStartAmt = ZERO;
            if (info != null) {
                monthStartAmt = this.getBigDecimal(info.getMonthStartAmt());
                journalBalInfo.put("isExistOppData", Boolean.TRUE);
            } else {
                journalBalInfo.put("isExistOppData", Boolean.FALSE);
            }
            journalBalInfo.setJournalMonthStartAmt(monthStartAmt);
            this.setAdjustMonthStartAmt(ctx, journalBalInfo, strCompanyId, strCurrencyId, periodInfo, strAcctBankId, monthStartAmt);
            coll.add(journalBalInfo);
        }
        return coll;
    }

    private IObjectCollection createCashAccInitCollFromGL(Context ctx, String strCompanyId, String strCurrencyId, String periodId, AccountTypeEnum accountType) throws BOSException, EASBizException {
        JournalBalanceCollection coll = new JournalBalanceCollection();
        JournalBalanceCollection journalBalColl = this.getJournalBalanceCollection(ctx, strCompanyId, strCurrencyId, periodId, accountType);
        AccountViewCollection acctViewCol = this.getAccountViewCollection(ctx, strCompanyId, null, strCurrencyId, AccountTypeEnum.CASHACCOUNT);
        Hashtable<String, JournalBalanceInfo> htExistCollection = new Hashtable<String, JournalBalanceInfo>();
        if (journalBalColl != null && journalBalColl.size() != 0) {
            for (int i = 0; i < journalBalColl.size(); ++i) {
                JournalBalanceInfo journalBalInfo = journalBalColl.get(i);
                String accountId = journalBalInfo.getAccountView().getId().toString();
                htExistCollection.put(accountId, journalBalInfo);
            }
        }
        int intAcctViewColSize = 0;
        if (acctViewCol != null) {
            intAcctViewColSize = acctViewCol.size();
        }
        AccountBalanceInfo accountBalanceInfo = null;
        AccountViewInfo acctview = null;
        String strAccountId = null;
        for (int i = 0; i < intAcctViewColSize; ++i) {
            JournalBalanceInfo journalBalInfo;
            acctview = acctViewCol.get(i);
            strAccountId = acctview.getId().toString();
            if (htExistCollection.containsKey(strAccountId)) {
                journalBalInfo = (JournalBalanceInfo)htExistCollection.get(strAccountId);
                accountBalanceInfo = this.getAccountBalanceInfo(ctx, strCompanyId, strAccountId, strCurrencyId, periodId, false, true);
                this.setAccountBeginBalance(ctx, journalBalInfo, accountBalanceInfo, null);
                coll.add(journalBalInfo);
                continue;
            }
            journalBalInfo = new JournalBalanceInfo();
            journalBalInfo.setAccountView(acctview);
            journalBalInfo.setCompany(this.getCompanyById(ctx, strCompanyId));
            journalBalInfo.setCurrency(this.getCurrencyById(ctx, strCurrencyId));
            journalBalInfo.setPeriod(this.getPeriodById(ctx, periodId));
            journalBalInfo.setType(AccountTypeEnum.CASHACCOUNT);
            journalBalInfo.setDebitStartAmt(ZERO);
            journalBalInfo.setCreditStartAmt(ZERO);
            journalBalInfo.setMonthStartAmt(ZERO);
            journalBalInfo.setYearStartAmt(ZERO);
            accountBalanceInfo = this.getAccountBalanceInfo(ctx, strCompanyId, strAccountId, strCurrencyId, periodId, false, true);
            this.setAccountBeginBalance(ctx, journalBalInfo, accountBalanceInfo, null);
            coll.add(journalBalInfo);
        }
        return coll;
    }

    public boolean needCheck(Context ctx, String companyId, AccountBankInfo acctBank, String accountId) throws EASBizException, BOSException {
        AccountViewInfo acctViewInfo = this.getAcctViewInfoById(ctx, accountId);
        if (acctViewInfo.getGAA() != null || acctViewInfo.getCAA() != null) {
            return true;
        }
        return !FMHelper.isExistMultiBankAcct((Context)ctx, (String)companyId, (String)accountId);
    }

    private IObjectCollection createBankAccInitCollFromGL(Context ctx, String strCompanyId, String strCurrencyId, String strPeriodId, AccountTypeEnum accountType) throws BOSException, EASBizException {
        JournalBalanceCollection coll = new JournalBalanceCollection();
        JournalBalanceCollection journalBalColl = this.getJournalBalanceCollection(ctx, strCompanyId, strCurrencyId, strPeriodId, accountType);
        JournalBalanceCollection searchJournalBalColl = null;
        if (accountType.equals((Object)AccountTypeEnum.BANKACCOUNT)) {
            searchJournalBalColl = this.getJournalBalanceCollection(ctx, strCompanyId, strCurrencyId, strPeriodId, AccountTypeEnum.ACCTSTATEMENT);
        } else if (accountType.equals((Object)AccountTypeEnum.ACCTSTATEMENT)) {
            searchJournalBalColl = this.getJournalBalanceCollection(ctx, strCompanyId, strCurrencyId, strPeriodId, AccountTypeEnum.BANKACCOUNT);
        }
        Map searchMap = new HashMap();
        if (searchJournalBalColl != null) {
            searchMap = CashHelper.getVOHashSearchMap((IObjectCollection)searchJournalBalColl, strKeys);
        }
        AccountBankCollection acctBankCol = this.getAccountBankCollection(ctx, strCompanyId, strCurrencyId, true);
        Hashtable<String, JournalBalanceInfo> htExistCollection = new Hashtable<String, JournalBalanceInfo>();
        if (journalBalColl != null && journalBalColl.size() != 0) {
            for (int i = 0; i < journalBalColl.size(); ++i) {
                JournalBalanceInfo journalBalInfo = journalBalColl.get(i);
                String accountBankId = journalBalInfo.getAccountBank().getId().toString();
                htExistCollection.put(accountBankId, journalBalInfo);
            }
        }
        int intAcctBankColSize = 0;
        PeriodInfo periodInfo = this.getPeriodById(ctx, strPeriodId);
        if (acctBankCol != null) {
            intAcctBankColSize = acctBankCol.size();
        }
        JournalBalanceInfo journalBalInfo = null;
        AccountBankInfo acctBankInfo = null;
        String strAcctBankId = null;
        boolean fGLStart = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.getCompanyById(ctx, strCompanyId));
        for (int i = 0; i < intAcctBankColSize; ++i) {
            BigDecimal creditAmt;
            BigDecimal debitAmt;
            BigDecimal beginAmt;
            acctBankInfo = acctBankCol.get(i);
            strAcctBankId = acctBankInfo.getId().toString();
            String strAccountId = acctBankInfo.getAccount().getId().toString();
            if (htExistCollection.containsKey(strAcctBankId)) {
                journalBalInfo = (JournalBalanceInfo)htExistCollection.get(strAcctBankId);
                if (fGLStart && this.needCheck(ctx, strCompanyId, acctBankInfo, acctBankInfo.getAccount().getId().toString())) {
                    beginAmt = this.getGLData(ctx, strCompanyId, acctBankInfo, strAccountId, strCurrencyId, strPeriodId, BalanceTypeEnum.C);
                    debitAmt = this.getGLData(ctx, strCompanyId, acctBankInfo, strAccountId, strCurrencyId, strPeriodId, BalanceTypeEnum.JL).subtract(this.getGLData(ctx, strCompanyId, acctBankInfo, strAccountId, strCurrencyId, strPeriodId, BalanceTypeEnum.JF));
                    creditAmt = this.getGLData(ctx, strCompanyId, acctBankInfo, strAccountId, strCurrencyId, strPeriodId, BalanceTypeEnum.DL).subtract(this.getGLData(ctx, strCompanyId, acctBankInfo, strAccountId, strCurrencyId, strPeriodId, BalanceTypeEnum.DF));
                    journalBalInfo.setMonthStartAmt(beginAmt);
                    journalBalInfo.setDebitStartAmt(debitAmt);
                    journalBalInfo.setCreditStartAmt(creditAmt);
                }
            } else {
                journalBalInfo = new JournalBalanceInfo();
                journalBalInfo.setAccountBank(acctBankInfo);
                journalBalInfo.setAccountView(acctBankInfo.getAccount());
                journalBalInfo.setCompany(this.getCompanyById(ctx, strCompanyId));
                journalBalInfo.setCurrency(this.getCurrencyById(ctx, strCurrencyId));
                journalBalInfo.setPeriod(periodInfo);
                journalBalInfo.setType(accountType);
                journalBalInfo.setDebitStartAmt(ZERO);
                journalBalInfo.setCreditStartAmt(ZERO);
                journalBalInfo.setMonthStartAmt(ZERO);
                journalBalInfo.setYearStartAmt(ZERO);
                if (fGLStart) {
                    beginAmt = this.getGLData(ctx, strCompanyId, acctBankInfo, strAccountId, strCurrencyId, strPeriodId, BalanceTypeEnum.C);
                    debitAmt = this.getGLData(ctx, strCompanyId, acctBankInfo, strAccountId, strCurrencyId, strPeriodId, BalanceTypeEnum.JL).subtract(this.getGLData(ctx, strCompanyId, acctBankInfo, strAccountId, strCurrencyId, strPeriodId, BalanceTypeEnum.JF));
                    creditAmt = this.getGLData(ctx, strCompanyId, acctBankInfo, strAccountId, strCurrencyId, strPeriodId, BalanceTypeEnum.DL).subtract(this.getGLData(ctx, strCompanyId, acctBankInfo, strAccountId, strCurrencyId, strPeriodId, BalanceTypeEnum.DF));
                    journalBalInfo.setMonthStartAmt(beginAmt);
                    journalBalInfo.setDebitStartAmt(debitAmt);
                    journalBalInfo.setCreditStartAmt(creditAmt);
                }
            }
            if (journalBalInfo == null) continue;
            BigDecimal monthStartAmt = ZERO;
            String strIndex = CashHelper.getKeyString((IObjectValue)journalBalInfo, strKeys);
            JournalBalanceInfo info = (JournalBalanceInfo)searchMap.get(strIndex);
            if (info != null) {
                monthStartAmt = this.getBigDecimal(info.getMonthStartAmt());
                journalBalInfo.put("isExistOppData", Boolean.TRUE);
            } else {
                journalBalInfo.put("isExistOppData", Boolean.FALSE);
            }
            if (accountType.equals((Object)AccountTypeEnum.BANKACCOUNT)) {
                journalBalInfo.setAcctStatementMonthStartAmt(monthStartAmt);
            } else if (accountType.equals((Object)AccountTypeEnum.ACCTSTATEMENT)) {
                journalBalInfo.setJournalMonthStartAmt(monthStartAmt);
            }
            this.setAdjustMonthStartAmt(ctx, journalBalInfo, strCompanyId, strCurrencyId, periodInfo, strAcctBankId, monthStartAmt);
            coll.add(journalBalInfo);
        }
        return coll;
    }

    private AccountBankCollection getAccountBankCollection(Context ctx, String strCompanyId) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("*");
        selector.add("bank.id");
        selector.add("bank.name");
        selector.add("bank.number");
        selector.add("account.id");
        selector.add("account.*");
        FilterInfo fi = new FilterInfo();
        FilterItemCollection items = fi.getFilterItems();
        items.add(new FilterItemInfo("company.id", (Object)strCompanyId));
        items.add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        evi.setFilter(fi);
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.getSorter().add(new SorterItemInfo("number"));
        AccountBankCollection acctBankCol = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(evi);
        if (acctBankCol == null) {
            return null;
        }
        return acctBankCol;
    }

    private AccountBankCollection getAccountBankCollection(Context ctx, String strCompanyId, String strCurrencyId, boolean flag) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("*");
        selector.add("bank.id");
        selector.add("bank.name");
        selector.add("bank.number");
        selector.add("account.id");
        selector.add("account.*");
        FilterInfo fi = new FilterInfo();
        FilterItemCollection items = fi.getFilterItems();
        items.add(new FilterItemInfo("company.id", (Object)strCompanyId));
        items.add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        items.add(new FilterItemInfo("account.isBank", (Object)Constants.TRUE));
        if (flag) {
            FilterInfo accountBankFilter = new FilterInfo();
            accountBankFilter.getFilterItems().add(new FilterItemInfo("currency.id", null));
            if (null != strCurrencyId) {
                accountBankFilter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)strCurrencyId));
                accountBankFilter.setMaskString("#0  or #1");
            }
            fi.mergeFilter(accountBankFilter, "and");
        }
        evi.setFilter(fi);
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.getSorter().add(new SorterItemInfo("number"));
        AccountBankCollection acctBankCol = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(evi);
        ICompanyOrgUnit company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo comInfo = company.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(strCompanyId));
        CurrencyInfo localCurrency = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(comInfo);
        AccountBankCollection coll = new AccountBankCollection();
        if (acctBankCol == null) {
            return null;
        }
        if (strCurrencyId == null) {
            return acctBankCol;
        }
        AccountBankInfo info = null;
        boolean isLocalCurrency = false;
        if (localCurrency.getId().toString().equals(strCurrencyId)) {
            isLocalCurrency = true;
        }
        int size = acctBankCol.size();
        block5: for (int i = 0; i < size; ++i) {
            info = acctBankCol.get(i);
            switch (info.getAccount().getAccountingcurrency().getValue()) {
                case 2: {
                    coll.add(info);
                    continue block5;
                }
                case 0: {
                    if (!isLocalCurrency) continue block5;
                    coll.add(info);
                    continue block5;
                }
                case 1: {
                    AccountCurrencyCollection acctCurColl = this.getAccountCurrencyCollection(ctx, info.getAccount().getId().toString());
                    for (int j = 0; j < acctCurColl.size(); ++j) {
                        if (!acctCurColl.get(j).getCurrency().getId().toString().equals(strCurrencyId)) continue;
                        coll.add(info);
                        continue block5;
                    }
                    continue block5;
                }
            }
        }
        return coll;
    }

    private AccountCurrencyCollection getAccountCurrencyCollection(Context ctx, String accountId) throws EASBizException, BOSException, UuidException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("accountingcurrency"));
        sic.add(new SelectorItemInfo("accountCurrency.id"));
        sic.add(new SelectorItemInfo("accountCurrency.currency"));
        sic.add(new SelectorItemInfo("accountCurrency.currency.id"));
        AccountViewInfo account = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)accountId)), sic);
        return account.getAccountCurrency();
    }

    private AccountBalanceCollection getGLBalanceCollection(Context ctx, String companyId, String acctTableId, String periodId, boolean isCash) throws BOSException {
        IAccountBalance iGL = AccountBalanceFactory.getLocalInstance((Context)ctx);
        EntityViewInfo glView = new EntityViewInfo();
        FilterInfo glFilter = new FilterInfo();
        glView.setFilter(glFilter);
        glFilter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)companyId));
        glFilter.getFilterItems().add(new FilterItemInfo("period", (Object)periodId));
        if (isCash) {
            glFilter.getFilterItems().add(new FilterItemInfo("account.isBank", (Object)STRING_ZERO));
            glFilter.getFilterItems().add(new FilterItemInfo("account.isCash", (Object)STRING_ONE));
        } else {
            glFilter.getFilterItems().add(new FilterItemInfo("account.isBank", (Object)STRING_ONE));
            glFilter.getFilterItems().add(new FilterItemInfo("account.isCash", (Object)STRING_ZERO));
        }
        glFilter.getFilterItems().add(new FilterItemInfo("account.isLeaf", (Object)STRING_ONE));
        glFilter.getFilterItems().add(new FilterItemInfo("account.accountTableID.id", (Object)acctTableId));
        glView.getSelector().add(new SelectorItemInfo("id"));
        glView.getSelector().add(new SelectorItemInfo("period.id"));
        glView.getSelector().add(new SelectorItemInfo("beginBalanceFor"));
        glView.getSelector().add(new SelectorItemInfo("beginBalanceLocal"));
        glView.getSelector().add(new SelectorItemInfo("account.id"));
        glView.getSelector().add(new SelectorItemInfo("account.*"));
        glView.getSelector().add(new SelectorItemInfo("account.isBank"));
        glView.getSelector().add(new SelectorItemInfo("currency.id"));
        glView.getSelector().add(new SelectorItemInfo("currency.number"));
        glView.getSelector().add(new SelectorItemInfo("currency.name"));
        glView.getSelector().add(new SelectorItemInfo("currency.precision"));
        AccountBalanceCollection acctBalColl = iGL.getAccountBalanceCollection(glView);
        for (int index = 0; index < acctBalColl.size(); ++index) {
            AccountBalanceInfo info = acctBalColl.get(index);
            info.getPeriod().setId(BOSUuid.read((String)periodId));
        }
        return acctBalColl;
    }

    private AccountBalanceCollection getAccountBalanceCollection(Context ctx, String companyId, String periodId) throws BOSException {
        IAccountBalance iGL = AccountBalanceFactory.getLocalInstance((Context)ctx);
        EntityViewInfo glView = new EntityViewInfo();
        FilterInfo glFilter = new FilterInfo();
        glView.setFilter(glFilter);
        glFilter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)companyId));
        glFilter.getFilterItems().add(new FilterItemInfo("period", (Object)periodId));
        glFilter.getFilterItems().add(new FilterItemInfo("account.isBank", (Object)STRING_ONE));
        glFilter.getFilterItems().add(new FilterItemInfo("account.isCash", (Object)STRING_ONE));
        glFilter.getFilterItems().add(new FilterItemInfo("account.isLeaf", (Object)STRING_ONE));
        glFilter.getFilterItems().add(new FilterItemInfo("account.isCFreeze", (Object)STRING_ZERO));
        glFilter.getFilterItems().add(new FilterItemInfo("account.isGFreeze", (Object)STRING_ZERO));
        glFilter.setMaskString("#0 and #1 and (#2 or #3) and #4 and #5 and #6");
        glView.getSelector().add(new SelectorItemInfo("id"));
        glView.getSelector().add(new SelectorItemInfo("beginBalanceFor"));
        glView.getSelector().add(new SelectorItemInfo("beginBalanceLocal"));
        glView.getSelector().add(new SelectorItemInfo("account.id"));
        glView.getSelector().add(new SelectorItemInfo("account.*"));
        glView.getSelector().add(new SelectorItemInfo("account.isBank"));
        glView.getSelector().add(new SelectorItemInfo("currency.id"));
        glView.getSelector().add(new SelectorItemInfo("currency.number"));
        glView.getSelector().add(new SelectorItemInfo("currency.name"));
        glView.getSelector().add(new SelectorItemInfo("currency.precision"));
        AccountBalanceCollection acctBalColl = iGL.getAccountBalanceCollection(glView);
        return acctBalColl;
    }

    private AccountBalanceInfo getAccountBalanceInfo(Context ctx, String strCompanyId, String strAccountId, String strCurrencyId, String periodId) throws EASBizException, BOSException {
        return this.getAccountBalanceInfo(ctx, strCompanyId, strAccountId, strCurrencyId, periodId, true, true);
    }

    private AccountBalanceInfo getAccountBalanceInfo(Context ctx, String strCompanyId, String strAccountId, String strCurrencyId, String periodId, boolean isBank, boolean isBooked) throws EASBizException, BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo aFilterInfo = new FilterInfo();
        evi.setFilter(aFilterInfo);
        FilterItemCollection items = aFilterInfo.getFilterItems();
        items.add(new FilterItemInfo("orgUnit.id", (Object)strCompanyId));
        items.add(new FilterItemInfo("account.id", (Object)strAccountId));
        items.add(new FilterItemInfo("currency.id", (Object)strCurrencyId));
        items.add(new FilterItemInfo("period.id", (Object)periodId));
        if (isBank) {
            items.add(new FilterItemInfo("account.isBank", (Object)STRING_ONE));
            items.add(new FilterItemInfo("account.isCash", (Object)STRING_ZERO));
        } else {
            items.add(new FilterItemInfo("account.isBank", (Object)STRING_ZERO));
            items.add(new FilterItemInfo("account.isCash", (Object)STRING_ONE));
        }
        if (isBooked) {
            items.add(new FilterItemInfo("balType", (Object)new Integer(5)));
        } else {
            items.add(new FilterItemInfo("balType", (Object)new Integer(1)));
        }
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("beginBalanceFor"));
        evi.getSelector().add(new SelectorItemInfo("beginBalanceLocal"));
        evi.getSelector().add(new SelectorItemInfo("account.id"));
        evi.getSelector().add(new SelectorItemInfo("account.isBank"));
        evi.getSelector().add(new SelectorItemInfo("account.*"));
        evi.getSelector().add(new SelectorItemInfo("account.GAA"));
        evi.getSelector().add(new SelectorItemInfo("account.GAA.id"));
        evi.getSelector().add(new SelectorItemInfo("account.GAA.name"));
        evi.getSelector().add(new SelectorItemInfo("account.CAA"));
        evi.getSelector().add(new SelectorItemInfo("account.CAA.id"));
        evi.getSelector().add(new SelectorItemInfo("account.CAA.name"));
        evi.getSelector().add(new SelectorItemInfo("currency.id"));
        evi.getSelector().add(new SelectorItemInfo("currency.number"));
        evi.getSelector().add(new SelectorItemInfo("currency.name"));
        evi.getSelector().add(new SelectorItemInfo("currency.precision"));
        AccountBalanceInfo accountBalanceInfo = null;
        IAccountBalance iAccountBalance = AccountBalanceFactory.getLocalInstance((Context)ctx);
        AccountBalanceCollection accountBalanceColl = iAccountBalance.getAccountBalanceCollection(evi);
        if (accountBalanceColl != null && accountBalanceColl.size() > 0) {
            accountBalanceInfo = accountBalanceColl.get(0);
        }
        return accountBalanceInfo;
    }

    private void setAccountBeginBalance(Context ctx, JournalBalanceInfo journalBalInfo, AccountBalanceInfo accountBalanceInfo, AccountBankInfo acctBankInfo) throws BOSException, EASBizException {
        if (journalBalInfo == null) {
            return;
        }
        AccountTypeEnum acctType = journalBalInfo.getType();
        BigDecimal begin = ZERO;
        BigDecimal debit = ZERO;
        BigDecimal credit = ZERO;
        if (accountBalanceInfo != null) {
            begin = this.getBigDecimal(accountBalanceInfo.getBeginBalanceFor());
            debit = this.getBigDecimal(accountBalanceInfo.getYearDebitFor().subtract(accountBalanceInfo.getDebitFor()));
            credit = this.getBigDecimal(accountBalanceInfo.getYearCreditFor().subtract(accountBalanceInfo.getCreditFor()));
        }
        journalBalInfo.setMonthStartAmt(begin);
        journalBalInfo.setDebitStartAmt(debit);
        journalBalInfo.setCreditStartAmt(credit);
        boolean isSetAssisBeginVal = false;
        if (accountBalanceInfo == null) {
            return;
        }
        if (acctType.equals((Object)AccountTypeEnum.BANKACCOUNT) || acctType.equals((Object)AccountTypeEnum.ACCTSTATEMENT)) {
            AccountViewInfo acctViewInfo = accountBalanceInfo.getAccount();
            if (acctViewInfo == null) {
                return;
            }
            if (acctViewInfo.isIsBank() && (acctViewInfo.getGAA() != null || acctViewInfo.getCAA() != null)) {
                AssistantHGInfo asstHGInfo;
                AsstAccountInfo asstAcctInfo = new AsstAccountInfo();
                if (acctViewInfo.getGAA() != null) {
                    asstAcctInfo = acctViewInfo.getGAA();
                }
                if (acctViewInfo.getCAA() != null) {
                    asstAcctInfo = acctViewInfo.getCAA();
                }
                if ((asstHGInfo = this.getHasAssistant(ctx, journalBalInfo.getAccountBank().getId().toString(), asstAcctInfo.getId().toString())) != null) {
                    String asstHGId = asstHGInfo.getId().toString();
                    isSetAssisBeginVal = this.isSetAssistantBeginAmt(ctx, journalBalInfo, journalBalInfo.getCompany().getId().toString(), journalBalInfo.getCurrency().getId().toString(), journalBalInfo.getPeriod().getId().toString(), acctViewInfo.getId().toString(), asstHGId, false);
                }
            }
        }
        if (accountBalanceInfo != null && isSetAssisBeginVal) {
            String acctViewId = accountBalanceInfo.getAccount().getId().toString();
            if (FMHelper.isExistMultiBankAcct((Context)ctx, (String)journalBalInfo.getCompany().getId().toString(), (String)acctViewId)) {
                journalBalInfo.setMonthStartAmt(ZERO);
                journalBalInfo.setDebitStartAmt(ZERO);
                journalBalInfo.setCreditStartAmt(ZERO);
            }
        }
    }

    private boolean isSetAssistantBeginAmt(Context ctx, JournalBalanceInfo journalBalInfo, String companyId, String currencyId, String periodId, String accountId, String assistGrpId, boolean bln) throws EASBizException, BOSException {
        PeriodInfo glStartPeriodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.getCompanyById(ctx, companyId));
        boolean isGLInit = periodId.equals(glStartPeriodInfo.getId().toString());
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (companyId != null) {
            fi.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)companyId));
        }
        if (!isGLInit && periodId != null) {
            fi.getFilterItems().add(new FilterItemInfo("period.id", (Object)periodId));
        }
        if (accountId != null) {
            fi.getFilterItems().add(new FilterItemInfo("account.id", (Object)accountId));
        }
        if (currencyId != null) {
            fi.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        }
        if (!isGLInit) {
            if (assistGrpId != null) {
                fi.getFilterItems().add(new FilterItemInfo("assistGrp.id", (Object)assistGrpId));
            }
            if (bln) {
                fi.getFilterItems().add(new FilterItemInfo("balType", (Object)new Integer(5)));
            } else {
                fi.getFilterItems().add(new FilterItemInfo("balType", (Object)new Integer(1)));
            }
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("yearDebitFor"));
        selector.add(new SelectorItemInfo("yearCreditFor"));
        selector.add(new SelectorItemInfo("beginBalanceFor"));
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.setFilter(fi);
        if (isGLInit) {
            IInitAssistBalance iInitAsstBal = InitAssistBalanceFactory.getLocalInstance((Context)ctx);
            InitAssistBalanceCollection initAssistBalColl = iInitAsstBal.getInitAssistBalanceCollection(evi);
            if (initAssistBalColl != null && initAssistBalColl.size() > 0) {
                InitAssistBalanceInfo initAssistBalInfo = initAssistBalColl.get(0);
                journalBalInfo.setMonthStartAmt(this.getBigDecimal(initAssistBalInfo.getBeginBalanceFor()));
                journalBalInfo.setDebitStartAmt(this.getBigDecimal(initAssistBalInfo.getYearDebitFor()));
                journalBalInfo.setCreditStartAmt(this.getBigDecimal(initAssistBalInfo.getYearCreditFor()));
                return false;
            }
        } else {
            IAssistBalance iAssistBal = AssistBalanceFactory.getLocalInstance((Context)ctx);
            AssistBalanceCollection assistBalColl = iAssistBal.getAssistBalanceCollection(evi);
            if (assistBalColl != null && assistBalColl.size() > 0) {
                AssistBalanceInfo assistBalInfo = assistBalColl.get(0);
                journalBalInfo.setMonthStartAmt(this.getBigDecimal(assistBalInfo.getBeginBalanceFor()));
                journalBalInfo.setDebitStartAmt(this.getBigDecimal(assistBalInfo.getYearDebitFor()));
                journalBalInfo.setCreditStartAmt(this.getBigDecimal(assistBalInfo.getYearCreditFor()));
                return false;
            }
        }
        return true;
    }

    private AssistantHGInfo getHasAssistant(Context ctx, String bankAccountId, String asstAccountId) throws BOSException {
        IAssistantHG assistantHG = AssistantHGFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (bankAccountId != null) {
            fi.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)bankAccountId));
        }
        if (asstAccountId != null) {
            fi.getFilterItems().add(new FilterItemInfo("asstAccount.id", (Object)asstAccountId));
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("bankAccount.id"));
        selector.add(new SelectorItemInfo("asstAccount.id"));
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.setFilter(fi);
        AssistantHGCollection assistantHGColl = assistantHG.getAssistantHGCollection(evi);
        if (assistantHGColl == null || assistantHGColl.size() == 0) {
            return null;
        }
        return assistantHGColl.get(0);
    }

    private boolean isHasAssistant(Context ctx, String bankAccountId, String asstAcctViewId) throws BOSException {
        IAssistantHG assistantHG = AssistantHGFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)bankAccountId));
        fi.getFilterItems().add(new FilterItemInfo("asstAccount.id", (Object)asstAcctViewId));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.setFilter(fi);
        AssistantHGCollection assistantHGColl = assistantHG.getAssistantHGCollection(evi);
        return assistantHGColl != null && assistantHGColl.size() != 0;
    }

    private BigDecimal getGLData(Context ctx, String companyNum, String accountNum, String currencyNum, PeriodInfo periodInfoFrom, PeriodInfo periodInfoTo, BalanceTypeEnum balanceType) throws BOSException, EASBizException {
        int endNum;
        int endYear;
        int startNum;
        IReportCacl reportCacl = ReportCaclFactory.getLocalInstance((Context)ctx);
        if (periodInfoFrom == null || periodInfoTo == null) {
            return null;
        }
        boolean includeVoucher = false;
        boolean checkDataRight = false;
        int startYear = periodInfoFrom.getPeriodYear();
        BigDecimal balance = reportCacl.acct(companyNum, accountNum, balanceType, startYear, startNum = periodInfoFrom.getPeriodNumber(), endYear = periodInfoTo.getPeriodYear(), endNum = periodInfoTo.getPeriodNumber(), currencyNum, false, includeVoucher, checkDataRight);
        return balance == null ? ZERO : balance;
    }

    @Override
    protected IObjectCollection _getAcctViewCollection(Context ctx, String companyId, String currencyId, AccountTypeEnum acctType) throws BOSException, EASBizException {
        return this._getAcctViewCollection(ctx, companyId, null, currencyId, acctType);
    }

    @Override
    protected IObjectCollection _getAcctViewCollection(Context ctx, String companyId, String acctTableId, String currencyId, AccountTypeEnum acctType) throws BOSException, EASBizException {
        return this.getAccountViewCollection(ctx, companyId, acctTableId, currencyId, acctType);
    }

    public static String getAccountTableId(Context ctx, String strCompanyId) throws BOSException, EASBizException {
        ICompanyOrgUnit company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo comInfo = company.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(strCompanyId));
        String strAccountTableId = comInfo.getAccountTable().getId().toString();
        return strAccountTableId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String getLocalCurrencyId(Context ctx, String strCompanyId) {
        String currencyId;
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block6: {
            String string;
            String strSql = "SELECT FBaseCurrencyID FROM T_ORG_Company WHERE FID=?";
            con = null;
            stmt = null;
            rs = null;
            currencyId = null;
            try {
                con = this.getConnection(ctx);
                stmt = con.prepareStatement(strSql.toString());
                stmt.setString(1, strCompanyId);
                rs = stmt.executeQuery();
                if (rs == null || !rs.next()) break block6;
                string = currencyId = rs.getString("FBaseCurrencyID");
            }
            catch (SQLException sql) {
                logger.error((Object)sql);
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)con);
            }
            catch (SQLDataException exp) {
                logger.error((Object)exp);
                {
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs, stmt, (Connection)con);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)con);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
            return string;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return currencyId;
    }

    private AccountViewCollection getAccountViewCollection(Context ctx, String strComId, String acctTableId, String strCurrencyId) throws BOSException, EASBizException {
        return this.getAccountViewCollection(ctx, strComId, acctTableId, strCurrencyId, AccountTypeEnum.CASHACCOUNT);
    }

    private AccountViewCollection getAccountViewCollection(Context ctx, String companyId, String acctTableId, String currencyId, AccountTypeEnum acctType) throws BOSException, EASBizException {
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        if (acctTableId == null || acctTableId.length() <= 0) {
            acctTableId = companyInfo.getAccountTable().getId().toString();
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("companyID.id", (Object)companyInfo.getId().toString()));
        if (acctTableId != null) {
            items.add(new FilterItemInfo("accountTableID", (Object)acctTableId));
        }
        items.add(new FilterItemInfo("isLeaf", (Object)Constants.TRUE));
        items.add(new FilterItemInfo("isGFreeze", (Object)Constants.FALSE));
        items.add(new FilterItemInfo("isCFreeze", (Object)Constants.FALSE));
        if (acctType.equals((Object)AccountTypeEnum.CASHACCOUNT)) {
            items.add(new FilterItemInfo("isCash", (Object)Constants.TRUE));
        } else if (acctType.equals((Object)AccountTypeEnum.BANKACCOUNT) || acctType.equals((Object)AccountTypeEnum.ACCTSTATEMENT)) {
            items.add(new FilterItemInfo("isBank", (Object)Constants.TRUE));
        } else if (acctType.equals((Object)AccountTypeEnum.ALL)) {
            items.add(new FilterItemInfo("isCash", (Object)Constants.TRUE));
            items.add(new FilterItemInfo("isBank", (Object)Constants.TRUE));
            filter.setMaskString("#0 and #1 and #2 and #3 and (#4 or #5)");
        }
        SelectorItemCollection selector = evi.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("isCash"));
        selector.add(new SelectorItemInfo("isBank"));
        selector.add(new SelectorItemInfo("accountCurrency.id"));
        selector.add(new SelectorItemInfo("accountCurrency.currency"));
        selector.add(new SelectorItemInfo("accountCurrency.currency.id"));
        selector.add(new SelectorItemInfo("accountCurrency.currency.name"));
        selector.add(new SelectorItemInfo("accountingcurrency"));
        evi.getSorter().add(new SorterItemInfo("number"));
        IAccountView iAccountView = AccountViewFactory.getLocalInstance((Context)ctx);
        AccountViewCollection acctViewColl = iAccountView.getAccountViewCollection(evi);
        if (acctViewColl == null || acctViewColl.size() == 0) {
            return null;
        }
        return this.getValidAcctViewColl(ctx, companyId, currencyId, acctViewColl);
    }

    private JournalBalanceInfo getJournalBalanceInfo(Context ctx, String strCompanyId, String strCurrencyId, String strPeriodId, String strAcctBankId, AccountTypeEnum type) throws BOSException {
        IJournalBalance iJournalBalance = JournalBalanceFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        viewInfo.setFilter(filterInfo);
        if (strCurrencyId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("currency", (Object)strCurrencyId));
        }
        if (strCompanyId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("company", (Object)strCompanyId));
        }
        if (strPeriodId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)strPeriodId));
        }
        if (strAcctBankId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("accountBank", (Object)strAcctBankId));
        }
        if (type != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)type));
        }
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("accountView.id"));
        sic.add(new SelectorItemInfo("accountView.number"));
        sic.add(new SelectorItemInfo("accountView.name"));
        sic.add(new SelectorItemInfo("accountBank.id"));
        sic.add(new SelectorItemInfo("accountBank.number"));
        sic.add(new SelectorItemInfo("accountBank.name"));
        sic.add(new SelectorItemInfo("accountBank.bankAccountNumber"));
        sic.add(new SelectorItemInfo("accountBank.account.id"));
        sic.add(new SelectorItemInfo("accountBank.account.name"));
        sic.add(new SelectorItemInfo("accountBank.account.number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("period.id"));
        sic.add(new SelectorItemInfo("period.name"));
        sic.add(new SelectorItemInfo("period.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("accountBank.bank.id"));
        sic.add(new SelectorItemInfo("accountBank.bank.name"));
        sic.add(new SelectorItemInfo("accountBank.bank.number"));
        sic.add(new SelectorItemInfo("monthStartAmt"));
        sic.add(new SelectorItemInfo("monthDebitAmt"));
        sic.add(new SelectorItemInfo("monthCreditAmt"));
        sic.add(new SelectorItemInfo("monthBalance"));
        sic.add(new SelectorItemInfo("yearStartAmt"));
        sic.add(new SelectorItemInfo("yearDebitAmt"));
        sic.add(new SelectorItemInfo("yearCreditAmt"));
        sic.add(new SelectorItemInfo("yearBalance"));
        sic.add(new SelectorItemInfo("debitStartAmt"));
        sic.add(new SelectorItemInfo("creditStartAmt"));
        sic.add(new SelectorItemInfo("isInit"));
        sic.add(new SelectorItemInfo("isBalanced"));
        sic.add(new SelectorItemInfo("type"));
        JournalBalanceCollection journalBalCollection = iJournalBalance.getJournalBalanceCollection(viewInfo);
        JournalBalanceInfo journalBalInfo = null;
        if (journalBalCollection != null) {
            journalBalInfo = journalBalCollection.get(0);
        }
        return journalBalInfo;
    }

    private JournalBalanceCollection getJournalBalanceCollection(Context ctx, String strCompanyId, String strCurrencyId, String strPeriodId, AccountTypeEnum type) throws BOSException {
        return this.getJournalBalanceCollection(ctx, strCompanyId, strCurrencyId, strPeriodId, type, true);
    }

    private JournalBalanceCollection getJournalBalanceCollection(Context ctx, String strCompanyId, String strCurrencyId, String strPeriodId, AccountTypeEnum type, boolean isInit) throws BOSException {
        IJournalBalance iJournalBalance = JournalBalanceFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        viewInfo.setFilter(filterInfo);
        if (strCurrencyId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("currency", (Object)strCurrencyId));
        }
        if (strCompanyId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("company", (Object)strCompanyId));
        }
        if (strPeriodId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)strPeriodId));
        }
        if (isInit) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isInit", (Object)STRING_ONE));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("isInit", (Object)STRING_ZERO));
        }
        if (type != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(type.getValue())));
        }
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("accountView.id"));
        sic.add(new SelectorItemInfo("accountView.number"));
        sic.add(new SelectorItemInfo("accountView.name"));
        sic.add(new SelectorItemInfo("accountBank.id"));
        sic.add(new SelectorItemInfo("accountBank.number"));
        sic.add(new SelectorItemInfo("accountBank.name"));
        sic.add(new SelectorItemInfo("accountBank.bankAccountNumber"));
        sic.add(new SelectorItemInfo("accountBank.account.id"));
        sic.add(new SelectorItemInfo("accountBank.account.isBank"));
        sic.add(new SelectorItemInfo("accountBank.account.name"));
        sic.add(new SelectorItemInfo("accountBank.account.number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("period.id"));
        sic.add(new SelectorItemInfo("period.name"));
        sic.add(new SelectorItemInfo("period.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("accountBank.bank.id"));
        sic.add(new SelectorItemInfo("accountBank.bank.name"));
        sic.add(new SelectorItemInfo("accountBank.bank.number"));
        sic.add(new SelectorItemInfo("monthStartAmt"));
        sic.add(new SelectorItemInfo("monthDebitAmt"));
        sic.add(new SelectorItemInfo("monthCreditAmt"));
        sic.add(new SelectorItemInfo("monthBalance"));
        sic.add(new SelectorItemInfo("yearStartAmt"));
        sic.add(new SelectorItemInfo("yearDebitAmt"));
        sic.add(new SelectorItemInfo("yearCreditAmt"));
        sic.add(new SelectorItemInfo("yearBalance"));
        sic.add(new SelectorItemInfo("debitStartAmt"));
        sic.add(new SelectorItemInfo("creditStartAmt"));
        sic.add(new SelectorItemInfo("isInit"));
        sic.add(new SelectorItemInfo("isBalanced"));
        sic.add(new SelectorItemInfo("type"));
        JournalBalanceCollection JournalBalanceCollection2 = iJournalBalance.getJournalBalanceCollection(viewInfo);
        return JournalBalanceCollection2;
    }

    @Override
    protected void _saveBankUnreachInit(Context ctx, FilterInfo filter, IObjectCollection journalCollection) throws BOSException, EASBizException {
        IJournal journalMgr = JournalFactory.getLocalInstance(ctx);
        IObjectPK[] list = journalMgr.getPKList(filter, null);
        journalMgr.delete(list);
        journalMgr.addBatch(journalCollection);
    }

    @Override
    protected void _saveEntUnreachInit(Context ctx, FilterInfo filter, IObjectCollection bankStatementCollection) throws BOSException, EASBizException {
        IBankStatement bankStatementMgr = BankStatementFactory.getLocalInstance(ctx);
        IObjectPK[] list = bankStatementMgr.getPKList(filter, null);
        bankStatementMgr.delete(list);
        Iterator iter = bankStatementCollection.iterator();
        while (iter.hasNext()) {
            bankStatementMgr.addnew((CoreBaseInfo)((BankStatementInfo)iter.next()));
        }
    }

    private BigDecimal getGLData(Context ctx, String companyId, AccountBankInfo acctBank, String accountId, String currencyId, String periodId) throws BOSException, EASBizException {
        return this.getGLData(ctx, companyId, acctBank, accountId, currencyId, periodId, BalanceTypeEnum.C);
    }

    private BigDecimal getGLData(Context ctx, String companyId, AccountBankInfo acctBank, String accountId, String currencyId, String periodId, BalanceTypeEnum balanceType) throws BOSException, EASBizException {
        if (accountId == null) {
            return ZERO;
        }
        boolean includeVoucher = false;
        boolean checkDataRight = false;
        PeriodInfo period = this.getPeriodById(ctx, periodId);
        int startYear = period.getPeriodYear();
        int startNum = period.getPeriodNumber();
        int endYear = startYear;
        int endNum = startNum;
        BigDecimal balance = ZERO;
        AccountViewInfo acctViewInfo = this.getAcctViewInfoById(ctx, accountId);
        if (acctViewInfo.getGAA() != null || acctViewInfo.getCAA() != null) {
            AsstAccountInfo asstAcctInfo = null;
            if (acctViewInfo.getGAA() != null) {
                asstAcctInfo = acctViewInfo.getGAA();
            }
            if (acctViewInfo.getCAA() != null) {
                asstAcctInfo = acctViewInfo.getCAA();
            }
            if (this.isHasAssistant(ctx, acctBank.getId().toString(), asstAcctInfo.getId().toString())) {
                IReportCacl reportCacl = ReportCaclFactory.getLocalInstance((Context)ctx);
                IAsstActType asstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
                AsstActTypeInfo asstAct = asstActType.getAsstActType(AsstActTypeSysEnum.BANKACCOUNT);
                if (asstAct != null) {
                    balance = reportCacl.acct(this.getCompanyById(ctx, companyId).getNumber(), this.getAccountViewById(ctx, accountId).getNumber() + "|" + asstAct.getNumber() + "|" + acctBank.getNumber(), balanceType, startYear, startNum, endYear, endNum, this.getCurrencyById(ctx, currencyId).getNumber(), false, includeVoucher, checkDataRight);
                    return balance == null ? ZERO : balance;
                }
            }
        }
        if (!FMHelper.isExistMultiBankAcct((Context)ctx, (String)companyId, (String)accountId)) {
            IReportCacl reportCacl = ReportCaclFactory.getLocalInstance((Context)ctx);
            balance = reportCacl.acct(this.getCompanyById(ctx, companyId).getNumber(), this.getAccountViewById(ctx, accountId).getNumber(), balanceType, startYear, startNum, endYear, endNum, this.getCurrencyById(ctx, currencyId).getNumber(), false, includeVoucher, checkDataRight);
        }
        return balance == null ? ZERO : balance;
    }

    private AccountViewInfo getAcctViewInfoById(Context ctx, String acctViewId) throws EASBizException, BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("GAA.id"));
        selector.add(new SelectorItemInfo("GAA.name"));
        selector.add(new SelectorItemInfo("CAA.id"));
        selector.add(new SelectorItemInfo("CAA.name"));
        FilterInfo fi = new FilterInfo();
        FilterItemCollection items = fi.getFilterItems();
        items.add(new FilterItemInfo("id", (Object)acctViewId));
        evi.setFilter(fi);
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        AccountViewCollection acctViewCol = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(evi);
        return acctViewCol == null ? null : acctViewCol.get(0);
    }

    private AccountViewInfo getAccountViewById(Context ctx, String strId) throws EASBizException, BOSException {
        IAccountView iAcct = AccountViewFactory.getLocalInstance((Context)ctx);
        AccountViewInfo acctView = iAcct.getAccountViewInfo((IObjectPK)new ObjectUuidPK(strId));
        return acctView;
    }

    @Override
    protected IObjectCollection _getAccountViewCollection(Context ctx, String companyId, String currencyId, EntityViewInfo viewInfo) throws BOSException, EASBizException {
        return this._getAccountViewCollection(ctx, companyId, null, currencyId, viewInfo);
    }

    @Override
    protected IObjectCollection _getAccountViewCollection(Context ctx, String companyId, String acctTableId, String currencyId, EntityViewInfo evi) throws BOSException, EASBizException {
        EntityViewInfo customEvi = this.getCustomEvi(ctx, companyId, acctTableId, evi);
        this.checkPermission(ctx, companyId, customEvi);
        IAccountView iAccountView = AccountViewFactory.getLocalInstance((Context)ctx);
        AccountViewCollection acctViewCol = iAccountView.getAccountViewCollection(customEvi);
        if (acctViewCol == null || acctViewCol.size() == 0) {
            return new AccountViewCollection();
        }
        AccountViewCollection retColl = this.getValidAcctViewColl(ctx, companyId, currencyId, acctViewCol);
        return retColl;
    }

    private EntityViewInfo getCustomEvi(Context ctx, String companyId, String acctTableId, EntityViewInfo evi) throws BOSException, EASBizException {
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        if (acctTableId == null || acctTableId.length() <= 0) {
            acctTableId = companyInfo.getAccountTable().getId().toString();
        }
        if (evi == null) {
            evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            evi.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Constants.TRUE));
            filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)Constants.FALSE));
            filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)Constants.FALSE));
        }
        FilterInfo filterCUAndTable = new FilterInfo();
        filterCUAndTable.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyId));
        filterCUAndTable.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)acctTableId));
        evi.getFilter().mergeFilter(filterCUAndTable, "and");
        SelectorItemCollection selector = evi.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("accountCurrency.id"));
        selector.add(new SelectorItemInfo("accountCurrency.currency"));
        selector.add(new SelectorItemInfo("accountCurrency.currency.id"));
        selector.add(new SelectorItemInfo("accountCurrency.currency.name"));
        selector.add(new SelectorItemInfo("accountingcurrency"));
        evi.getSorter().add(new SorterItemInfo("number"));
        return evi;
    }

    private void checkPermission(Context ctx, String companyId, EntityViewInfo evi) throws BOSException, EASBizException, PermissionException {
        ServiceContext serviceContext = this.createServiceContext(new MetaDataPK("3c8e751c-00fb-1000-e000-0001c0a813e6"), new Object[]{ctx, evi});
        ServiceStateManager.ServiceState state = new ServiceStateManager.ServiceState();
        state.enableSpecialService("PERMISSION_SERVICE");
        IPermissionServiceProvider provider = PermissionServiceProviderFactory.getLocalInstance((Context)serviceContext.getContext());
        String rule = provider.getPermissionRule(ctx.getCaller(), (IObjectPK)new ObjectStringPK(companyId), "bd_account_accountView_view");
        if (!StringUtils.isEmpty((String)rule)) {
            try {
                EntityViewInfo ruleEvi = new EntityViewInfo(rule);
                serviceContext.setServiceResult("PERMISSION_SERVICE", (Object)ruleEvi.getFilter());
            }
            catch (ParserException e) {
                throw new PermissionException(PermissionException.CHECK_PERMISSION_FAIL, (Throwable)e);
            }
        }
    }

    private AccountViewCollection getValidAcctViewColl(Context ctx, String companyId, String currencyId, AccountViewCollection acctViewColl) {
        if (currencyId == null || currencyId.length() <= 0) {
            return acctViewColl;
        }
        String localCurrencyId = this.getLocalCurrencyId(ctx, companyId);
        AccountViewCollection retColl = new AccountViewCollection();
        AccountCurrencyCollection acctCurColl = null;
        int size = acctViewColl.size();
        block5: for (int i = 0; i < size; ++i) {
            AccountViewInfo acctInfo = acctViewColl.get(i);
            switch (acctInfo.getAccountingcurrency().getValue()) {
                case 2: {
                    retColl.add(acctInfo);
                }
                case 0: {
                    if (localCurrencyId.equals(currencyId)) {
                        retColl.add(acctInfo);
                    }
                }
                case 1: {
                    acctCurColl = acctInfo.getAccountCurrency();
                    for (int j = 0; j < acctCurColl.size(); ++j) {
                        if (!acctCurColl.get(j).getCurrency().getId().toString().equals(currencyId)) continue;
                        retColl.add(acctInfo);
                        continue block5;
                    }
                    continue block5;
                }
            }
        }
        return retColl;
    }

    public boolean isAcctHasAcctBankAssis(Context ctx, String acctViewId) throws EASBizException, BOSException, UuidException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT T_BD_AsstActType.FRealtionDataObject AS tName, A.FID FROM T_BD_AccountView A INNER JOIN T_BD_AsstAccount ON A.FCAA = T_BD_AsstAccount.FID INNER JOIN T_BD_AsstActGroupDetail ON T_BD_AsstAccount.FID = T_BD_AsstActGroupDetail.FAsstAccountID INNER JOIN T_BD_AsstActType ON T_BD_AsstActGroupDetail.FAsstActTypeID = T_BD_AsstActType.FID  WHERE (T_BD_AsstActType.FRealtionDataObject = 'T_BD_AccountBanks') and A.fid='" + acctViewId + "'");
        IRowSet rs = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sb.toString()).executeSQL();
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }
}

