/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGCollection;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeSysEnum;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AccountTypeEnum;
import com.kingdee.eas.fi.cas.CasGLItemCheckRptInfo;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.CashMgtInitFacadeFactory;
import com.kingdee.eas.fi.cas.ICashMgtInitFacade;
import com.kingdee.eas.fi.cas.IJournalBalance;
import com.kingdee.eas.fi.cas.JournalBalanceCollection;
import com.kingdee.eas.fi.cas.JournalBalanceFactory;
import com.kingdee.eas.fi.cas.JournalBalanceInfo;
import com.kingdee.eas.fi.cas.app.AbstractCashMgtInitWebFacadeControllerBean;
import com.kingdee.eas.fi.cas.app.SystemStatusCtrolUtils;
import com.kingdee.eas.fi.cas.app.model.CashMgtInitModel;
import com.kingdee.eas.fi.cas.basedata.CasUtilFacadeFactory;
import com.kingdee.eas.fi.cas.basedata.ICasUtilFacade;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.utils.CashMgtInitFetchParam;
import com.kingdee.eas.fi.gl.AccountBalanceCollection;
import com.kingdee.eas.fi.gl.AccountBalanceFactory;
import com.kingdee.eas.fi.gl.AccountBalanceInfo;
import com.kingdee.eas.fi.gl.AssistBalanceCollection;
import com.kingdee.eas.fi.gl.AssistBalanceFactory;
import com.kingdee.eas.fi.gl.AssistBalanceInfo;
import com.kingdee.eas.fi.gl.IAccountBalance;
import com.kingdee.eas.fi.gl.IAssistBalance;
import com.kingdee.eas.fi.gl.IInitAssistBalance;
import com.kingdee.eas.fi.gl.InitAssistBalanceCollection;
import com.kingdee.eas.fi.gl.InitAssistBalanceFactory;
import com.kingdee.eas.fi.gl.InitAssistBalanceInfo;
import com.kingdee.eas.fi.rpt.BalanceTypeEnum;
import com.kingdee.eas.fi.rpt.IReportCacl;
import com.kingdee.eas.fi.rpt.ReportCaclFactory;
import com.kingdee.eas.fi.rpt.VoucherGetTypeEnum;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CashMgtInitWebFacadeControllerBean
extends AbstractCashMgtInitWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.CashMgtInitWebFacadeControllerBean");
    private static final String PM_VIEW = "cas_init_01view";
    private static final String PM_FINISHINIT = "cas_init_02finishInit";
    private static final String PM_ANTIINIT = "cas_init_03antiInit";
    private static final String PM_PRINT = "cas_init_04print";
    private static final String STRING_ZERO = "0";
    private static final String STRING_ONE = "1";
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private static final String[] strKeys = new String[]{"company", "currency", "period", "accountBank"};

    @Override
    protected Map _getOnloadData(Context ctx, String companyId, String currencyId) throws BOSException, EASBizException {
        CashMgtInitModel model = new CashMgtInitModel(ctx);
        try {
            ICasUtilFacade casUtil = CasUtilFacadeFactory.getLocalInstance(ctx);
            CompanyOrgUnitCollection orgUnitCollection = casUtil.getAuthrizedCompanyOrg(ctx.getCaller().toString(), PM_VIEW, false);
            model.setOrgUnitCollection(orgUnitCollection);
            CompanyOrgUnitInfo company = this.getCompany(ctx, companyId, orgUnitCollection);
            if (company == null) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "NO_COMPANY_PERMISSION"));
            }
            model.setCompany(company);
            Map permissionMap = casUtil.batchCheckPermission(company.getId().toString(), ctx.getCaller().toString(), new String[]{PM_FINISHINIT, PM_ANTIINIT});
            model.setBtnFinishInitEnable((Boolean)permissionMap.get(PM_FINISHINIT));
            model.setBtnAntiInitEnable((Boolean)permissionMap.get(PM_ANTIINIT));
            Map param = CashMgtInitFetchParam.fetchParam(ctx, company);
            CurrencyCollection currencyCollection = (CurrencyCollection)param.get("currencyCollection");
            model.setCurrencyCollection(currencyCollection);
            CurrencyInfo baseCurrency = (CurrencyInfo)param.get("baseCurrency");
            if (currencyId == null) {
                currencyId = baseCurrency.getId().toString();
            }
            for (int i = 0; i < currencyCollection.size(); ++i) {
                if (!currencyCollection.get(i).getId().toString().equals(currencyId)) continue;
                baseCurrency = currencyCollection.get(i);
                break;
            }
            model.setCurrency(baseCurrency);
            PeriodInfo startPeriodInfo = (PeriodInfo)param.get("startPeriod");
            if (startPeriodInfo == null) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "STARTPERIOD_NOT_SET"));
            }
            boolean isFirstPeriod = false;
            isFirstPeriod = startPeriodInfo.getPeriodNumber() == 1;
            model.setFirstPeriod(isFirstPeriod);
            boolean isGLStart = (Boolean)param.get("isGLStart");
            model.setGLStart(isGLStart);
            if (startPeriodInfo.isIsAdjustPeriod()) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "ADJ_CANNOT_SET_STARTPERIOD"));
            }
            model.setStartPeriodInfo(startPeriodInfo);
            model.setFinishInit(this.getIsInit(ctx, company));
            Vector vec = this.getContrastWithGL(ctx, company.getId().toString(), startPeriodInfo.getId().toString());
            model.setCashCollection(this.getCashCollection(ctx, company.getId().toString(), baseCurrency.getId().toString(), startPeriodInfo.getId().toString(), vec));
            model.setBankCollection(this.getBankCollection(ctx, company.getId().toString(), baseCurrency.getId().toString(), startPeriodInfo.getId().toString(), vec));
            model.setStatementCollection(this.getStatementCollection(ctx, company.getId().toString(), baseCurrency.getId().toString(), startPeriodInfo.getId().toString(), vec));
            model.setError(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            model.setError(1);
            model.setMsg(e.getMessage());
        }
        return model.toJsonObject();
    }

    @Override
    protected Map _save(Context ctx, String modelStr) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int error = 0;
        String msg = null;
        try {
            CashMgtInitModel model = CashMgtInitModel.parseModel(ctx, modelStr);
            ICashMgtInitFacade iCashMgtInitFacade = CashMgtInitFacadeFactory.getLocalInstance(ctx);
            CompanyOrgUnitInfo company = model.getCompany();
            if (this.getIsInit(ctx, company)) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "309_FINISH_INITIED"));
            }
            JournalBalanceInfo tmpJournalBalInfo = new JournalBalanceInfo();
            tmpJournalBalInfo.setCompany(model.getCompany());
            tmpJournalBalInfo.setCurrency(model.getCurrency());
            tmpJournalBalInfo.setPeriod(model.getStartPeriodInfo());
            tmpJournalBalInfo.setType(AccountTypeEnum.CASHACCOUNT);
            iCashMgtInitFacade.save(model.getCashCollection(), tmpJournalBalInfo);
            tmpJournalBalInfo.setType(AccountTypeEnum.BANKACCOUNT);
            iCashMgtInitFacade.save(model.getBankCollection(), tmpJournalBalInfo);
            tmpJournalBalInfo.setType(AccountTypeEnum.ACCTSTATEMENT);
            iCashMgtInitFacade.save(model.getStatementCollection(), tmpJournalBalInfo);
            msg = CASWebUtil.getResource(ctx, "SAVE_SUCCESS");
        }
        catch (Exception e) {
            e.printStackTrace();
            error = 1;
            msg = e.getMessage();
        }
        result.put("error", error);
        result.put("msg", msg);
        return result;
    }

    @Override
    protected Map _finishInit(Context ctx, String modelStr) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int error = 0;
        String msg = null;
        try {
            Vector vecCashMgtFailureReport;
            CashMgtInitModel model = CashMgtInitModel.parseModel(ctx, modelStr);
            CompanyOrgUnitInfo company = model.getCompany();
            CurrencyInfo currency = model.getCurrency();
            PeriodInfo period = model.getStartPeriodInfo();
            if (this.getIsInit(ctx, company)) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "ALREADY_FINISHED_INIT"));
            }
            ICashMgtInitFacade iCashMgtInitFacade = CashMgtInitFacadeFactory.getLocalInstance(ctx);
            boolean isRelated = SystemStatusCtrolUtils.isRelAccount(ctx, SystemEnum.CASHMANAGEMENT, company);
            if (isRelated && (vecCashMgtFailureReport = iCashMgtInitFacade.getContrastWithGL(company.getId().toString(), period.getId().toString())) != null && vecCashMgtFailureReport.size() > 0) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "NOT_BALANCE_CANNOT_FINISH_INIT"));
            }
            boolean isBalanced = iCashMgtInitFacade.checkBankBalance(company.getId().toString(), period.getId().toString());
            if (!isBalanced) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "BBA_NOT_BALANE_CANNOT_FINISH_INIT"));
            }
            iCashMgtInitFacade.finishInit(company.getId().toString(), period.getId().toString());
            msg = CASWebUtil.getResource(ctx, "FINISHINIT_SUCCESS");
        }
        catch (Exception e) {
            error = 1;
            msg = e.getMessage();
            e.printStackTrace();
        }
        result.put("error", error);
        result.put("msg", msg);
        return result;
    }

    @Override
    protected Map _antiInit(Context ctx, String modelStr) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int error = 0;
        String msg = null;
        try {
            CashMgtInitModel model = CashMgtInitModel.parseModel(ctx, modelStr);
            CompanyOrgUnitInfo company = model.getCompany();
            PeriodInfo period = model.getStartPeriodInfo();
            if (!this.getIsInit(ctx, company)) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "305_NOT_FINISH_INIT"));
            }
            ICashMgtInitFacade iCashMgtInitFacade = CashMgtInitFacadeFactory.getLocalInstance(ctx);
            SystemStatusCtrolUtils sscUtils = new SystemStatusCtrolUtils();
            String companyID = company.getId().toString();
            if (sscUtils.isRelatedAccount4Client(ctx, companyID, SystemEnum.CASHMANAGEMENT) && sscUtils.isEqualsCurPeriodAndRelPeriod4Client(ctx, companyID, SystemEnum.CASHMANAGEMENT)) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "CANCEL_GL_UNION_FIRST"));
            }
            iCashMgtInitFacade.antiInit(companyID, period.getId().toString());
            msg = CASWebUtil.getResource(ctx, "ANTI_INIT_SUCCESS");
        }
        catch (Exception e) {
            error = 1;
            msg = e.getMessage();
            e.printStackTrace();
        }
        result.put("error", error);
        result.put("msg", msg);
        return result;
    }

    @Override
    protected Map _importGL(Context ctx, String companyId, String currencyId, String startPeriodId) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Vector vec = this.getContrastWithGL(ctx, companyId, startPeriodId);
            JournalBalanceCollection cashCollection = this.getCashCollectionFromGL(ctx, companyId, currencyId, startPeriodId, vec);
            map.put("cashGridData", this.getCashGridData(cashCollection));
            JournalBalanceCollection bankCollection = this.getBankCollectionFromGL(ctx, companyId, currencyId, startPeriodId, vec);
            map.put("bankGridData", this.getBankGridData(bankCollection));
            map.put("error", 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            map.put("error", 1);
            map.put("msg", e.getMessage());
        }
        return map;
    }

    private JournalBalanceCollection getCashCollection(Context ctx, String companyId, String currencyId, String periodId, Vector vec) throws BOSException, EASBizException {
        ICashMgtInitFacade iCashMgtInitFacade = CashMgtInitFacadeFactory.getLocalInstance(ctx);
        JournalBalanceCollection cashCollection = iCashMgtInitFacade.getInitCollection(AccountTypeEnum.CASHACCOUNT, companyId, currencyId, periodId);
        for (int i = 0; i < cashCollection.size(); ++i) {
            JournalBalanceInfo jbInfo = cashCollection.get(i);
            BigDecimal glStartAmt = new BigDecimal(STRING_ZERO);
            Object casGLCheckInfo = null;
            for (Object o : vec) {
                CasGLItemCheckRptInfo temp = (CasGLItemCheckRptInfo)o;
                if (temp.getAccountBankInfo() != null || temp.getBankInfo() != null || !temp.getAccountViewInfo().getId().equals((Object)jbInfo.getAccountView().getId()) || !temp.getCurrencyInfo().getId().equals((Object)jbInfo.getCurrency().getId())) continue;
                glStartAmt = temp.getGlStartAmt();
                break;
            }
            jbInfo.put("glStartAmt", glStartAmt);
        }
        return cashCollection;
    }

    private JournalBalanceCollection getBankCollection(Context ctx, String companyId, String currencyId, String periodId, Vector vec) throws BOSException, EASBizException {
        ICashMgtInitFacade iCashMgtInitFacade = CashMgtInitFacadeFactory.getLocalInstance(ctx);
        JournalBalanceCollection bankCollection = iCashMgtInitFacade.getInitCollection(AccountTypeEnum.BANKACCOUNT, companyId, currencyId, periodId);
        for (int i = 0; i < bankCollection.size(); ++i) {
            JournalBalanceInfo jbInfo = bankCollection.get(i);
            CasGLItemCheckRptInfo casGLCheckInfo = null;
            for (Object o : vec) {
                CasGLItemCheckRptInfo temp = (CasGLItemCheckRptInfo)o;
                if (temp.getAccountBankInfo() == null || temp.getBankInfo() == null || !temp.getAccountBankInfo().getId().equals((Object)jbInfo.getAccountBank().getId()) || !temp.getAccountViewInfo().getId().equals((Object)jbInfo.getAccountView().getId()) || !temp.getCurrencyInfo().getId().equals((Object)jbInfo.getCurrency().getId())) continue;
                casGLCheckInfo = temp;
                break;
            }
            if (casGLCheckInfo == null) {
                jbInfo.put("glStartBalance", jbInfo.getMonthStartAmt());
                continue;
            }
            jbInfo.put("glStartBalance", casGLCheckInfo.getGlStartAmt());
        }
        return bankCollection;
    }

    private JournalBalanceCollection getStatementCollection(Context ctx, String companyId, String currencyId, String periodId, Vector vec) throws BOSException, EASBizException {
        ICashMgtInitFacade iCashMgtInitFacade = CashMgtInitFacadeFactory.getLocalInstance(ctx);
        JournalBalanceCollection statementCollection = iCashMgtInitFacade.getInitCollection(AccountTypeEnum.ACCTSTATEMENT, companyId, currencyId, periodId);
        return statementCollection;
    }

    private JournalBalanceCollection getCashCollectionFromGL(Context ctx, String companyId, String currencyId, String periodId, Vector vec) throws BOSException, EASBizException {
        ICashMgtInitFacade iCashMgtInitFacade = CashMgtInitFacadeFactory.getLocalInstance(ctx);
        JournalBalanceCollection cashCollection = (JournalBalanceCollection)iCashMgtInitFacade.getInitCollectionFromGL(AccountTypeEnum.CASHACCOUNT, companyId, currencyId, periodId);
        for (int i = 0; i < cashCollection.size(); ++i) {
            JournalBalanceInfo jbInfo = cashCollection.get(i);
            BigDecimal glStartAmt = new BigDecimal(STRING_ZERO);
            Object casGLCheckInfo = null;
            for (Object o : vec) {
                CasGLItemCheckRptInfo temp = (CasGLItemCheckRptInfo)o;
                if (temp.getAccountBankInfo() != null || temp.getBankInfo() != null || !temp.getAccountViewInfo().getId().equals((Object)jbInfo.getAccountView().getId()) || !temp.getCurrencyInfo().getId().equals((Object)jbInfo.getCurrency().getId())) continue;
                glStartAmt = temp.getGlStartAmt();
                break;
            }
            jbInfo.put("glStartAmt", glStartAmt);
        }
        return cashCollection;
    }

    private JournalBalanceCollection getBankCollectionFromGL(Context ctx, String companyId, String currencyId, String periodId, Vector vec) throws BOSException, EASBizException {
        ICashMgtInitFacade iCashMgtInitFacade = CashMgtInitFacadeFactory.getLocalInstance(ctx);
        JournalBalanceCollection bankCollection = (JournalBalanceCollection)iCashMgtInitFacade.getInitCollectionFromGL(AccountTypeEnum.BANKACCOUNT, companyId, currencyId, periodId);
        for (int i = 0; i < bankCollection.size(); ++i) {
            JournalBalanceInfo jbInfo = bankCollection.get(i);
            CasGLItemCheckRptInfo casGLCheckInfo = null;
            for (Object o : vec) {
                CasGLItemCheckRptInfo temp = (CasGLItemCheckRptInfo)o;
                if (temp.getAccountBankInfo() == null || temp.getBankInfo() == null || !temp.getAccountBankInfo().getId().equals((Object)jbInfo.getAccountBank().getId()) || !temp.getAccountViewInfo().getId().equals((Object)jbInfo.getAccountView().getId()) || !temp.getCurrencyInfo().getId().equals((Object)jbInfo.getCurrency().getId())) continue;
                casGLCheckInfo = temp;
                break;
            }
            if (casGLCheckInfo == null) {
                jbInfo.put("glStartBalance", jbInfo.getMonthStartAmt());
                continue;
            }
            jbInfo.put("glStartBalance", casGLCheckInfo.getGlStartAmt());
        }
        return bankCollection;
    }

    private Object getBankGridData(JournalBalanceCollection bankCollection) {
        ArrayList bankGridData = new ArrayList();
        for (int i = 0; i < bankCollection.size(); ++i) {
            JournalBalanceInfo jbInfo = bankCollection.get(i);
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put("bankDepositAcct", CASWebUtil.parseInfo((CoreBaseInfo)jbInfo.getAccountView()));
            row.put("bankAcct", CASWebUtil.parseInfo((CoreBaseInfo)jbInfo.getAccountBank(), "id", "name", "number", "bankAccountNumber"));
            row.put("yearDebitAmt", jbInfo.getDebitStartAmt());
            row.put("yearCreditAmt", jbInfo.getCreditStartAmt());
            row.put("beginBalance", jbInfo.getMonthStartAmt());
            row.put("asBalance", jbInfo.getAcctStatementMonthStartAmt());
            row.put("adjJournalBalance", jbInfo.getAdjustedJournalMonthStartAmt());
            row.put("adjAsBalance", jbInfo.getAdjustedASMonthStartAmt());
            row.put("bankMatch", jbInfo.isIsBalanced());
            row.put("glStartBalance", jbInfo.get("glStartBalance"));
            row.put("glMatch", ((BigDecimal)jbInfo.get("glStartBalance")).doubleValue() == jbInfo.getMonthStartAmt().doubleValue());
            bankGridData.add(row);
        }
        return bankGridData;
    }

    private List<Map<String, Object>> getCashGridData(JournalBalanceCollection cashCollection) {
        ArrayList<Map<String, Object>> cashGridData = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < cashCollection.size(); ++i) {
            JournalBalanceInfo jbInfo = cashCollection.get(i);
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put("cashAcct", CASWebUtil.parseInfo((CoreBaseInfo)jbInfo.getAccountView()));
            row.put("yearDebitAmt", jbInfo.getDebitStartAmt());
            row.put("yearCreditAmt", jbInfo.getCreditStartAmt());
            row.put("beginBalance", jbInfo.getMonthStartAmt());
            row.put("glStartAmt", jbInfo.get("glStartAmt"));
            row.put("match", jbInfo.getMonthStartAmt().doubleValue() == ((BigDecimal)jbInfo.get("glStartAmt")).doubleValue());
            cashGridData.add(row);
        }
        return cashGridData;
    }

    private CompanyOrgUnitInfo getCompany(Context ctx, String campanyId, CompanyOrgUnitCollection orgUnitCollection) {
        CompanyOrgUnitInfo company;
        block4: {
            block5: {
                block6: {
                    block7: {
                        company = null;
                        if (campanyId != null) break block5;
                        CompanyOrgUnitInfo defaultOrgUnit = ContextUtil.getCurrentFIUnit((Context)ctx);
                        if (!defaultOrgUnit.isIsBizUnit()) break block6;
                        boolean havePower = false;
                        for (int i = 0; i < orgUnitCollection.size(); ++i) {
                            if (!orgUnitCollection.get(i).getId().toString().equals(defaultOrgUnit.getId().toString())) continue;
                            havePower = true;
                            break;
                        }
                        if (!havePower) break block7;
                        company = defaultOrgUnit;
                        break block4;
                    }
                    if (orgUnitCollection.size() <= 0) break block4;
                    company = orgUnitCollection.get(0);
                    break block4;
                }
                for (int i = 0; i < orgUnitCollection.size(); ++i) {
                    if (!orgUnitCollection.get(i).isIsBizUnit()) continue;
                    company = orgUnitCollection.get(i);
                    break block4;
                }
                break block4;
            }
            if (orgUnitCollection.size() > 0) {
                for (int i = 0; i < orgUnitCollection.size(); ++i) {
                    if (!orgUnitCollection.get(i).getId().toString().equals(campanyId) || !orgUnitCollection.get(i).isIsBizUnit()) continue;
                    company = orgUnitCollection.get(i);
                    break;
                }
            }
        }
        return company;
    }

    private boolean getIsInit(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        return SystemStatusCtrolUtils.isStart(ctx, SystemEnum.CASHMANAGEMENT, companyInfo);
    }

    private Vector getContrastWithGL(Context ctx, String strCompanyId, String strPeriodId) throws BOSException, EASBizException {
        Vector vectorReport = new Vector();
        String currAcctTableId = this.getCurrAcctTableId(ctx, strCompanyId, strPeriodId);
        if (currAcctTableId == null) {
            throw new BOSException(CASWebUtil.getResource(ctx, "NO_ENABLED_ACCOUNTTABLE"));
        }
        this.createContrastReportByCashAcct(ctx, strCompanyId, currAcctTableId, strPeriodId, vectorReport);
        this.createContrastReportByBank(ctx, strCompanyId, currAcctTableId, strPeriodId, vectorReport);
        vectorReport.remove(null);
        return vectorReport;
    }

    private String getCurrAcctTableId(Context ctx, String companyId, String periodId) throws BOSException, EASBizException {
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo company = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        String cuId = company.getCU().getId().toString();
        if (company.getAccountTable() == null) {
            return null;
        }
        String acctTableId = company.getAccountTable().getId().toString();
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        PeriodInfo period = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodId));
        String currAcctTableId = AccountTools.getCurrentAcctTable((Context)ctx, (String)cuId, (String)acctTableId, (int)period.getPeriodYear(), (int)period.getPeriodNumber());
        return currAcctTableId;
    }

    private void createContrastReportByCashAcct(Context ctx, String strCompanyId, String acctTableId, String strPeriodId, Vector vectorReport) throws BOSException, EASBizException {
        CasGLItemCheckRptInfo rptInfo = null;
        String[] glsKeys = new String[]{"orgUnit", "account", "currency", "period"};
        String[] casKeys = new String[]{"company", "accountView", "currency", "period"};
        String[] bankKeys = new String[]{"company", "accountBank", "accountView", "currency", "period"};
        AccountBalanceCollection glsColl = this.getGLBalanceCollection(ctx, strCompanyId, acctTableId, strPeriodId, true);
        Map glsMap = new HashMap();
        if (glsColl != null && glsColl.size() > 0) {
            glsMap = CashHelper.getVOHashSearchMap((IObjectCollection)glsColl, glsKeys);
        }
        JournalBalanceInfo journalBalInfo2 = null;
        boolean isInitPeriod = this.isInitPeriod(ctx, strCompanyId, strPeriodId);
        JournalBalanceCollection journalBalColl = this.getJournalBalanceCollection(ctx, strCompanyId, null, strPeriodId, AccountTypeEnum.CASHACCOUNT, isInitPeriod);
        Map casMap = new HashMap();
        if (journalBalColl != null && journalBalColl.size() > 0) {
            casMap = CashHelper.getVOHashSearchMap((IObjectCollection)journalBalColl, bankKeys);
        }
        int journalBalSize = 0;
        if (journalBalColl != null) {
            journalBalSize = journalBalColl.size();
        }
        Vector<String> glVec = new Vector<String>();
        Vector<String> casVec = new Vector<String>();
        if (glsMap != null && casMap != null && glsMap.size() > 0 && casMap.size() > 0) {
            for (int i = 0; i < journalBalSize; ++i) {
                AccountTypeEnum type;
                AccountBalanceInfo acctBalInfo;
                JournalBalanceInfo cashInfo = journalBalColl.get(i);
                String keyString = CashHelper.getKeyString((IObjectValue)cashInfo, casKeys);
                String bankKeyString = CashHelper.getKeyString((IObjectValue)cashInfo, bankKeys);
                if (!glsMap.containsKey(keyString) || this.isGeneralCurrency((acctBalInfo = (AccountBalanceInfo)glsMap.get(keyString)).getCurrency()) || (!(type = cashInfo.getType()).equals((Object)AccountTypeEnum.CASHACCOUNT) || !acctBalInfo.getAccount().isIsCash()) && (!type.equals((Object)AccountTypeEnum.BANKACCOUNT) || !acctBalInfo.getAccount().isIsBank())) continue;
                rptInfo = this.cashContrastGL(ctx, strCompanyId, null, acctTableId, acctBalInfo.getCurrency().getId().toString(), strPeriodId, acctBalInfo, cashInfo, true);
                if (rptInfo != null) {
                    vectorReport.add(rptInfo);
                }
                glVec.add(keyString);
                casVec.add(bankKeyString);
            }
        }
        String removeKey = null;
        if (casVec != null && casVec.size() > 0) {
            for (int i = 0; i < casVec.size(); ++i) {
                removeKey = (String)casVec.get(i);
                casMap.remove(removeKey);
            }
        }
        if (casMap != null && casMap.size() > 0) {
            for (JournalBalanceInfo journalBalInfo2 : casMap.values()) {
                if (journalBalInfo2 == null || (rptInfo = this.cashContrastGL(ctx, strCompanyId, null, acctTableId, journalBalInfo2.getCurrency().getId().toString(), strPeriodId, null, journalBalInfo2, true)) == null) continue;
                vectorReport.add(rptInfo);
            }
        }
        if (glVec != null && glVec.size() > 0) {
            int size = glVec.size();
            for (int i = 0; i < size; ++i) {
                removeKey = (String)glVec.get(i);
                glsMap.remove(removeKey);
            }
        }
        if (glsMap != null && glsMap.size() > 0) {
            for (AccountBalanceInfo glAcctBalInfo : glsMap.values()) {
                if (glAcctBalInfo == null || this.isGeneralCurrency(glAcctBalInfo.getCurrency()) || (rptInfo = this.cashContrastGL(ctx, strCompanyId, null, acctTableId, glAcctBalInfo.getCurrency().getId().toString(), strPeriodId, glAcctBalInfo, null, true)) == null) continue;
                vectorReport.add(rptInfo);
            }
        }
    }

    private AccountBalanceCollection getGLBalanceCollection(Context ctx, String companyId, String acctTableId, String periodId, boolean isCash) throws BOSException {
        IAccountBalance iGL = AccountBalanceFactory.getLocalInstance((Context)ctx);
        EntityViewInfo glView = new EntityViewInfo();
        FilterInfo glFilter = new FilterInfo();
        glView.setFilter(glFilter);
        glFilter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)companyId));
        glFilter.getFilterItems().add(new FilterItemInfo("period", (Object)periodId));
        if (isCash) {
            glFilter.getFilterItems().add(new FilterItemInfo("account.isBank", (Object)STRING_ZERO));
            glFilter.getFilterItems().add(new FilterItemInfo("account.isCash", (Object)STRING_ONE));
        } else {
            glFilter.getFilterItems().add(new FilterItemInfo("account.isBank", (Object)STRING_ONE));
            glFilter.getFilterItems().add(new FilterItemInfo("account.isCash", (Object)STRING_ZERO));
        }
        glFilter.getFilterItems().add(new FilterItemInfo("account.isLeaf", (Object)STRING_ONE));
        glFilter.getFilterItems().add(new FilterItemInfo("account.accountTableID.id", (Object)acctTableId));
        glView.getSelector().add(new SelectorItemInfo("id"));
        glView.getSelector().add(new SelectorItemInfo("period.id"));
        glView.getSelector().add(new SelectorItemInfo("beginBalanceFor"));
        glView.getSelector().add(new SelectorItemInfo("beginBalanceLocal"));
        glView.getSelector().add(new SelectorItemInfo("account.id"));
        glView.getSelector().add(new SelectorItemInfo("account.*"));
        glView.getSelector().add(new SelectorItemInfo("account.isBank"));
        glView.getSelector().add(new SelectorItemInfo("currency.id"));
        glView.getSelector().add(new SelectorItemInfo("currency.number"));
        glView.getSelector().add(new SelectorItemInfo("currency.name"));
        glView.getSelector().add(new SelectorItemInfo("currency.precision"));
        AccountBalanceCollection acctBalColl = iGL.getAccountBalanceCollection(glView);
        for (int i = 0; i < acctBalColl.size(); ++i) {
            acctBalColl.get(i).getPeriod().setId(BOSUuid.read((String)periodId));
        }
        return acctBalColl;
    }

    private boolean isGeneralCurrency(CurrencyInfo currency) {
        String currencyId = null;
        if (currency == null) {
            return false;
        }
        currencyId = currency.getId().toString();
        return currencyId.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString()) || currencyId.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString());
    }

    private boolean isInitPeriod(Context ctx, String strCompanyId, String strPeriodId) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)strCompanyId));
        PeriodInfo startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod(ctx, SystemEnum.CASHMANAGEMENT, company);
        return startPeriodInfo.getId().toString().equals(strPeriodId);
    }

    private CasGLItemCheckRptInfo cashContrastGL(Context ctx, String companyId, AccountBankInfo acctBankInfo, String accountId, String currencyId, String periodId, AccountBalanceInfo glInitInfo, JournalBalanceInfo journalBalInfo, boolean isGLStart) throws EASBizException, BOSException {
        CasGLItemCheckRptInfo rpt = null;
        if (glInitInfo == null && journalBalInfo == null) {
            return null;
        }
        BigDecimal casStartAmt = ZERO;
        BigDecimal glStartAmt = ZERO;
        AccountTypeEnum acctType = AccountTypeEnum.CASHACCOUNT;
        if (glInitInfo != null && journalBalInfo != null) {
            AccountViewInfo acctViewInfo;
            if (this.isGeneralCurrency(glInitInfo.getCurrency())) {
                return null;
            }
            acctType = journalBalInfo.getType();
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectStringPK(companyId));
            companyInfo = this.getCompanyInfo(ctx, companyInfo.getId().toString());
            String companyNum = companyInfo.getNumber();
            PeriodInfo period = this.getPeriodById(ctx, periodId);
            Date beginDate = period.getBeginDate();
            Timestamp endDate = period.getEndDate();
            PeriodInfo beginPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)beginDate, (CompanyOrgUnitInfo)companyInfo);
            PeriodInfo endPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)endDate, (CompanyOrgUnitInfo)companyInfo);
            CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectStringPK(currencyId));
            String currencyNum = currencyInfo.getNumber();
            BalanceTypeEnum beginBalType = BalanceTypeEnum.C;
            if (journalBalInfo.getMonthBalance() != null) {
                casStartAmt = journalBalInfo.getMonthBalance();
            }
            glStartAmt = beginDate.equals(endDate) ? this.getGLExtBalance(ctx, companyNum, glInitInfo.getAccount().getNumber(), currencyNum, beginDate, endDate, VoucherGetTypeEnum.C) : this.getGLData(ctx, companyInfo, glInitInfo.getAccount().getNumber(), currencyNum, beginPeriod, endPeriod, beginBalType);
            if ((acctType.equals((Object)AccountTypeEnum.BANKACCOUNT) || acctType.equals((Object)AccountTypeEnum.ACCTSTATEMENT)) && (acctViewInfo = glInitInfo.getAccount()).isIsBank() && (acctViewInfo.getGAA() != null || acctViewInfo.getCAA() != null)) {
                AssistantHGInfo asstHGInfo;
                AsstAccountInfo asstAcctInfo = null;
                if (acctViewInfo.getGAA() != null) {
                    asstAcctInfo = acctViewInfo.getGAA();
                }
                if (acctViewInfo.getCAA() != null) {
                    asstAcctInfo = acctViewInfo.getCAA();
                }
                if ((asstHGInfo = this.getHasAssistant(ctx, journalBalInfo.getAccountBank().getId().toString(), asstAcctInfo.getId().toString())) != null) {
                    String asstHGId = asstHGInfo.getId().toString();
                    glStartAmt = this.getAssistantBeginAmt(ctx, journalBalInfo, journalBalInfo.getCompany().getId().toString(), journalBalInfo.getCurrency().getId().toString(), journalBalInfo.getPeriod().getId().toString(), acctViewInfo.getId().toString(), asstHGId, false);
                }
            }
            if (this.isGeneralCurrency(journalBalInfo.getCurrency())) {
                return null;
            }
            rpt = this.getContrastRptInfo(ctx, journalBalInfo, casStartAmt, glStartAmt);
        } else if (glInitInfo != null && journalBalInfo == null) {
            if (this.isGeneralCurrency(glInitInfo.getCurrency())) {
                return null;
            }
            glStartAmt = this.getBigDecimal(glInitInfo.getBeginBalanceFor()).setScale(glInitInfo.getCurrency().getPrecision(), 4);
            if (glStartAmt.signum() != 0) {
                rpt = this.getGLContrastRptInfo(glInitInfo, casStartAmt, glStartAmt, null);
            }
        } else if (glInitInfo == null && journalBalInfo != null) {
            if (this.isGeneralCurrency(journalBalInfo.getCurrency())) {
                return null;
            }
            casStartAmt = this.getBigDecimal(journalBalInfo.getMonthStartAmt()).setScale(journalBalInfo.getCurrency().getPrecision(), 4);
            rpt = this.getContrastRptInfo(ctx, journalBalInfo, casStartAmt, glStartAmt);
        }
        return rpt;
    }

    private CompanyOrgUnitInfo getCompanyInfo(Context ctx, String fid) throws BOSException {
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("name");
        selector.add("number");
        selector.add("accountTable.id");
        selector.add("accountTable.number");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)fid));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        CompanyOrgUnitCollection companyColl = iCompany.getCompanyOrgUnitCollection(viewInfo);
        if (companyColl != null) {
            return companyColl.get(0);
        }
        return null;
    }

    private PeriodInfo getPeriodById(Context ctx, String strId) throws EASBizException, BOSException {
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        PeriodInfo period = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(strId));
        return period;
    }

    private BigDecimal getGLExtBalance(Context ctx, String companyNum, String accountNum, String currencyNum, Date beginDate, Date endDate, VoucherGetTypeEnum type) throws BOSException, EASBizException {
        BigDecimal balance = ZERO;
        IReportCacl reportCacl = ReportCaclFactory.getLocalInstance((Context)ctx);
        boolean includeVoucher = true;
        boolean checkDataRight = false;
        String strBeginDate = beginDate.toString();
        String strEndDate = endDate.toString();
        try {
            balance = reportCacl.acctExt(companyNum, accountNum, "", null, type, currencyNum, strBeginDate, strEndDate, includeVoucher, checkDataRight);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return balance;
    }

    private BigDecimal getGLData(Context ctx, CompanyOrgUnitInfo companyInfo, String accountNum, String currencyNum, PeriodInfo beginPeriod, PeriodInfo endPeriod, BalanceTypeEnum balanceType) throws BOSException, EASBizException {
        IReportCacl reportCacl = ReportCaclFactory.getLocalInstance((Context)ctx);
        if (beginPeriod == null || endPeriod == null) {
            return null;
        }
        boolean includeVoucher = true;
        boolean checkDataRight = false;
        String companyNum = companyInfo.getNumber();
        int startYear = beginPeriod.getPeriodYear();
        int startNum = beginPeriod.getPeriodNumber();
        int endYear = endPeriod.getPeriodYear();
        int endNum = endPeriod.getPeriodNumber();
        BigDecimal balance = ZERO;
        balance = reportCacl.acct(companyNum, accountNum, balanceType, startYear, startNum, endYear, endNum, currencyNum, false, includeVoucher, checkDataRight);
        return balance == null ? ZERO : balance;
    }

    private AssistantHGInfo getHasAssistant(Context ctx, String bankAccountId, String asstAccountId) throws BOSException {
        IAssistantHG assistantHG = AssistantHGFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (bankAccountId != null) {
            fi.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)bankAccountId));
        }
        if (asstAccountId != null) {
            fi.getFilterItems().add(new FilterItemInfo("asstAccount.id", (Object)asstAccountId));
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("bankAccount.id"));
        selector.add(new SelectorItemInfo("asstAccount.id"));
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.setFilter(fi);
        AssistantHGCollection assistantHGColl = assistantHG.getAssistantHGCollection(evi);
        if (assistantHGColl == null || assistantHGColl.size() == 0) {
            return null;
        }
        return assistantHGColl.get(0);
    }

    private BigDecimal getAssistantBeginAmt(Context ctx, JournalBalanceInfo journalBalInfo, String companyId, String currencyId, String periodId, String accountId, String assistGrpId, boolean bln) throws EASBizException, BOSException {
        PeriodInfo glStartPeriodInfo = SystemStatusCtrolUtils.getStartPeriod(ctx, SystemEnum.GENERALLEDGER, this.getCompanyById(ctx, companyId));
        boolean isGLInit = periodId.equals(glStartPeriodInfo.getId().toString());
        BigDecimal startAmt = this.getBigDecimal(journalBalInfo.getMonthStartAmt());
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (companyId != null) {
            fi.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)companyId));
        }
        if (!isGLInit && periodId != null) {
            fi.getFilterItems().add(new FilterItemInfo("period.id", (Object)periodId));
        }
        if (accountId != null) {
            fi.getFilterItems().add(new FilterItemInfo("account.id", (Object)accountId));
        }
        if (currencyId != null) {
            fi.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        }
        if (!isGLInit) {
            if (assistGrpId != null) {
                fi.getFilterItems().add(new FilterItemInfo("assistGrp.id", (Object)assistGrpId));
            }
            if (bln) {
                fi.getFilterItems().add(new FilterItemInfo("balType", (Object)new Integer(5)));
            } else {
                fi.getFilterItems().add(new FilterItemInfo("balType", (Object)new Integer(1)));
            }
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("yearDebitFor"));
        selector.add(new SelectorItemInfo("yearCreditFor"));
        selector.add(new SelectorItemInfo("beginBalanceFor"));
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.setFilter(fi);
        if (isGLInit) {
            IInitAssistBalance iInitAsstBal = InitAssistBalanceFactory.getLocalInstance((Context)ctx);
            InitAssistBalanceCollection initAssistBalColl = iInitAsstBal.getInitAssistBalanceCollection(evi);
            if (initAssistBalColl != null && initAssistBalColl.size() > 0) {
                InitAssistBalanceInfo initAssistBalInfo = initAssistBalColl.get(0);
                startAmt = this.getBigDecimal(initAssistBalInfo.getBeginBalanceFor());
            }
        } else {
            IAssistBalance iAssistBal = AssistBalanceFactory.getLocalInstance((Context)ctx);
            AssistBalanceCollection assistBalColl = iAssistBal.getAssistBalanceCollection(evi);
            if (assistBalColl != null && assistBalColl.size() > 0) {
                AssistBalanceInfo assistBalInfo = assistBalColl.get(0);
                startAmt = this.getBigDecimal(assistBalInfo.getBeginBalanceFor());
            }
        }
        return startAmt;
    }

    private BigDecimal getBigDecimal(BigDecimal big) {
        return big == null ? ZERO : big;
    }

    private CompanyOrgUnitInfo getCompanyById(Context ctx, String strId) throws EASBizException, BOSException {
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo company = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(strId));
        return company;
    }

    private CasGLItemCheckRptInfo getContrastRptInfo(Context ctx, JournalBalanceInfo journalBalInfo, BigDecimal casStartAmt, BigDecimal glStartAmt) throws EASBizException, BOSException {
        AccountBankInfo accountBank;
        boolean needCheck;
        CurrencyInfo currency = journalBalInfo.getCurrency();
        if (currency.getId().equals((Object)CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID) || currency.getId().equals((Object)CurrencyInfo.GENERAL_REPORT_CURRENCY_ID)) {
            return null;
        }
        if (journalBalInfo.getType() != null && journalBalInfo.getType().equals((Object)AccountTypeEnum.BANKACCOUNT) && !(needCheck = this.needCheck(ctx, (accountBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(journalBalInfo.getAccountBank().getId()))).getCompany().getId().toString(), accountBank, journalBalInfo.getAccountView().getId().toString()))) {
            return null;
        }
        CasGLItemCheckRptInfo rptInfo = new CasGLItemCheckRptInfo();
        if (journalBalInfo.getType() != null && journalBalInfo.getType().equals((Object)AccountTypeEnum.BANKACCOUNT)) {
            rptInfo.setAccountBankInfo(journalBalInfo.getAccountBank());
            rptInfo.setBankInfo(this.getBankInfo(journalBalInfo.getAccountBank()));
        }
        rptInfo.setAccountViewInfo(journalBalInfo.getAccountView());
        rptInfo.setCurrencyInfo(currency);
        rptInfo.setCasStartAmt(casStartAmt);
        rptInfo.setGlStartAmt(glStartAmt);
        return rptInfo;
    }

    private boolean needCheck(Context ctx, String companyId, AccountBankInfo acctBank, String accountId) throws EASBizException, BOSException {
        AccountViewInfo acctViewInfo = this.getAcctViewInfoById(ctx, accountId);
        if (acctViewInfo.getGAA() != null || acctViewInfo.getCAA() != null) {
            AsstAccountInfo asstAcctInfo = null;
            if (acctViewInfo.getGAA() != null) {
                asstAcctInfo = acctViewInfo.getGAA();
            }
            if (acctViewInfo.getCAA() != null) {
                asstAcctInfo = acctViewInfo.getCAA();
            }
            if (this.isHasAssistant(ctx, acctBank.getId().toString(), asstAcctInfo.getId().toString())) {
                return true;
            }
        }
        return !FMHelper.isExistMultiBankAcct((Context)ctx, (String)companyId, (String)accountId);
    }

    private AccountViewInfo getAcctViewInfoById(Context ctx, String acctViewId) throws EASBizException, BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("GAA.id"));
        selector.add(new SelectorItemInfo("GAA.name"));
        selector.add(new SelectorItemInfo("CAA.id"));
        selector.add(new SelectorItemInfo("CAA.name"));
        FilterInfo fi = new FilterInfo();
        FilterItemCollection items = fi.getFilterItems();
        items.add(new FilterItemInfo("id", (Object)acctViewId));
        evi.setFilter(fi);
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        AccountViewCollection acctViewCol = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(evi);
        return acctViewCol == null ? null : acctViewCol.get(0);
    }

    private BankInfo getBankInfo(AccountBankInfo acctBankInfo) {
        if (acctBankInfo == null || acctBankInfo.getBank() == null) {
            return null;
        }
        return acctBankInfo.getBank();
    }

    private boolean isHasAssistant(Context ctx, String bankAccountId, String asstAcctViewId) throws BOSException {
        IAssistantHG assistantHG = AssistantHGFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)bankAccountId));
        fi.getFilterItems().add(new FilterItemInfo("asstAccount.id", (Object)asstAcctViewId));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.setFilter(fi);
        AssistantHGCollection assistantHGColl = assistantHG.getAssistantHGCollection(evi);
        return assistantHGColl != null && assistantHGColl.size() != 0;
    }

    private CasGLItemCheckRptInfo getGLContrastRptInfo(AccountBalanceInfo glInitInfo, BigDecimal casStartAmt, BigDecimal glStartAmt, AccountBankInfo acctBankInfo) {
        AccountViewInfo accountInfo;
        CurrencyInfo currency = glInitInfo.getCurrency();
        if (currency.getId().equals((Object)CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID) || currency.getId().equals((Object)CurrencyInfo.GENERAL_REPORT_CURRENCY_ID)) {
            return null;
        }
        CasGLItemCheckRptInfo rptInfo = new CasGLItemCheckRptInfo();
        if (acctBankInfo != null) {
            rptInfo.setAccountBankInfo(acctBankInfo);
            rptInfo.setBankInfo(this.getBankInfo(acctBankInfo));
        }
        if ((accountInfo = glInitInfo.getAccount()).isIsBank()) {
            // empty if block
        }
        rptInfo.setAccountViewInfo(accountInfo);
        rptInfo.setCurrencyInfo(currency);
        rptInfo.setCasStartAmt(casStartAmt);
        rptInfo.setGlStartAmt(glStartAmt);
        return rptInfo;
    }

    private JournalBalanceCollection getJournalBalanceCollection(Context ctx, String strCompanyId, String strCurrencyId, String strPeriodId, AccountTypeEnum type, boolean isInit) throws BOSException {
        IJournalBalance iJournalBalance = JournalBalanceFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        viewInfo.setFilter(filterInfo);
        if (strCurrencyId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("currency", (Object)strCurrencyId));
        }
        if (strCompanyId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("company", (Object)strCompanyId));
        }
        if (strPeriodId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)strPeriodId));
        }
        if (isInit) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isInit", (Object)STRING_ONE));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("isInit", (Object)STRING_ZERO));
        }
        if (type != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)type));
        }
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("accountView.id"));
        sic.add(new SelectorItemInfo("accountView.number"));
        sic.add(new SelectorItemInfo("accountView.name"));
        sic.add(new SelectorItemInfo("accountBank.id"));
        sic.add(new SelectorItemInfo("accountBank.number"));
        sic.add(new SelectorItemInfo("accountBank.name"));
        sic.add(new SelectorItemInfo("accountBank.bankAccountNumber"));
        sic.add(new SelectorItemInfo("accountBank.account.id"));
        sic.add(new SelectorItemInfo("accountBank.account.isBank"));
        sic.add(new SelectorItemInfo("accountBank.account.name"));
        sic.add(new SelectorItemInfo("accountBank.account.number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("period.id"));
        sic.add(new SelectorItemInfo("period.name"));
        sic.add(new SelectorItemInfo("period.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("accountBank.bank.id"));
        sic.add(new SelectorItemInfo("accountBank.bank.name"));
        sic.add(new SelectorItemInfo("accountBank.bank.number"));
        sic.add(new SelectorItemInfo("monthStartAmt"));
        sic.add(new SelectorItemInfo("monthDebitAmt"));
        sic.add(new SelectorItemInfo("monthCreditAmt"));
        sic.add(new SelectorItemInfo("monthBalance"));
        sic.add(new SelectorItemInfo("yearStartAmt"));
        sic.add(new SelectorItemInfo("yearDebitAmt"));
        sic.add(new SelectorItemInfo("yearCreditAmt"));
        sic.add(new SelectorItemInfo("yearBalance"));
        sic.add(new SelectorItemInfo("debitStartAmt"));
        sic.add(new SelectorItemInfo("creditStartAmt"));
        sic.add(new SelectorItemInfo("isInit"));
        sic.add(new SelectorItemInfo("isBalanced"));
        sic.add(new SelectorItemInfo("type"));
        JournalBalanceCollection JournalBalanceCollection2 = iJournalBalance.getJournalBalanceCollection(viewInfo);
        return JournalBalanceCollection2;
    }

    private void createContrastReportByBank(Context ctx, String strCompanyId, String acctTableId, String strPeriodId, Vector vectorReport) throws BOSException, EASBizException {
        boolean fGLStart = SystemStatusCtrolUtils.isStart(ctx, SystemEnum.GENERALLEDGER, this.getCompanyById(ctx, strCompanyId));
        JournalBalanceCollection bankJournalBalColl = null;
        bankJournalBalColl = this.isInitPeriod(ctx, strCompanyId, strPeriodId) ? this.getJournalBalanceCollection(ctx, strCompanyId, null, strPeriodId, AccountTypeEnum.BANKACCOUNT, true) : this.getJournalBalanceCollection(ctx, strCompanyId, null, strPeriodId, AccountTypeEnum.BANKACCOUNT, false);
        AccountBankCollection acctBankCol = this.getAccountBankCollection(ctx, strCompanyId);
        acctBankCol = FMHelper.getJouranlBalanceAcctBank((Context)ctx, (AccountBankCollection)acctBankCol, (String)strPeriodId, null);
        Hashtable<String, JournalBalanceInfo> htExistCollection = new Hashtable<String, JournalBalanceInfo>();
        HashSet<String> currencySet = new HashSet<String>();
        if (bankJournalBalColl != null && bankJournalBalColl.size() != 0) {
            for (int i = 0; i < bankJournalBalColl.size(); ++i) {
                JournalBalanceInfo journalBalInfo = bankJournalBalColl.get(i);
                String accountBankId = journalBalInfo.getAccountBank().getId().toString();
                String acctViewId = journalBalInfo.getAccountView().getId().toString();
                String currencyId = journalBalInfo.getCurrency().getId().toString();
                currencySet.add(currencyId);
                htExistCollection.put(this.getIndexKey(accountBankId, acctViewId, currencyId), journalBalInfo);
            }
        }
        PeriodInfo period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(strPeriodId));
        this.filterCurrencyId(ctx, currencySet, strCompanyId, period.getNumber());
        int intAcctBankColSize = 0;
        if (acctBankCol != null) {
            intAcctBankColSize = acctBankCol.size();
        }
        JournalBalanceInfo journalBalInfo = null;
        AccountBankInfo acctBankInfo = null;
        CasGLItemCheckRptInfo rptInfo = null;
        String indexKey = null;
        String strCurrencyId2 = null;
        for (int i = 0; i < intAcctBankColSize; ++i) {
            acctBankInfo = acctBankCol.get(i);
            String acctBankId = acctBankInfo.getId().toString();
            String strAccountId = acctBankInfo.getAccount().getId().toString();
            if (!acctBankInfo.getAccount().isIsBank()) continue;
            for (String strCurrencyId2 : currencySet) {
                indexKey = this.getIndexKey(acctBankId, strAccountId, strCurrencyId2);
                if (htExistCollection.containsKey(indexKey)) {
                    journalBalInfo = (JournalBalanceInfo)htExistCollection.get(indexKey);
                    strCurrencyId2 = journalBalInfo.getCurrency().getId().toString();
                    rptInfo = null;
                    rptInfo = this.cashContrastGLForCAS(ctx, strCompanyId, acctBankInfo, strAccountId, strCurrencyId2, strPeriodId, journalBalInfo, fGLStart);
                    if (rptInfo == null) continue;
                    vectorReport.add(rptInfo);
                    continue;
                }
                journalBalInfo = new JournalBalanceInfo();
                journalBalInfo.setAccountBank(acctBankInfo);
                journalBalInfo.setType(AccountTypeEnum.BANKACCOUNT);
                journalBalInfo.setAccountView(acctBankInfo.getAccount());
                journalBalInfo.setCurrency(this.getCurrencyById(ctx, strCurrencyId2));
                rptInfo = null;
                rptInfo = this.cashContrastGLForCAS(ctx, strCompanyId, acctBankInfo, strAccountId, strCurrencyId2, strPeriodId, journalBalInfo, fGLStart);
                if (rptInfo == null) continue;
                vectorReport.add(rptInfo);
            }
        }
    }

    private AccountBankCollection getAccountBankCollection(Context ctx, String strCompanyId) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("*");
        selector.add("bank.id");
        selector.add("bank.name");
        selector.add("bank.number");
        selector.add("account.id");
        selector.add("account.*");
        FilterInfo fi = new FilterInfo();
        FilterItemCollection items = fi.getFilterItems();
        items.add(new FilterItemInfo("company.id", (Object)strCompanyId));
        items.add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        evi.setFilter(fi);
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.getSorter().add(new SorterItemInfo("number"));
        AccountBankCollection acctBankCol = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(evi);
        if (acctBankCol == null) {
            return null;
        }
        return acctBankCol;
    }

    private String getIndexKey(String accountBankId, String acctViewId, String currencyId) {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append(accountBankId);
        strBuff.append("_");
        strBuff.append(acctViewId);
        strBuff.append("_");
        strBuff.append(currencyId);
        return strBuff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void filterCurrencyId(Context ctx, HashSet currencySet, String companyId, int period) {
        String currencyId;
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        String strSql;
        block16: {
            strSql = "SELECT distinct FCurrencyID FROM T_GL_AccountBalance_1f WHERE FOrgUnitID=? AND FPeriod=? ";
            con = null;
            stmt = null;
            rs = null;
            currencyId = null;
            try {
                con = this.getConnection(ctx);
                stmt = con.prepareStatement(strSql.toString());
                stmt.setString(1, companyId);
                stmt.setInt(2, period);
                rs = stmt.executeQuery();
                if (rs == null) break block16;
                while (rs.next()) {
                    currencyId = rs.getString("FCurrencyID");
                    currencySet.add(currencyId);
                }
            }
            catch (SQLDataException e) {
                logger.error((Object)e);
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)con);
            }
            catch (SQLException e2) {
                logger.error((Object)e2);
                {
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs, stmt, (Connection)con);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)con);
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        strSql = "SELECT distinct FCurrencyID FROM T_CAS_Journal WHERE Fcompanyid=? AND FPeriodID is null";
        con = null;
        stmt = null;
        rs = null;
        currencyId = null;
        try {
            con = this.getConnection(ctx);
            stmt = con.prepareStatement(strSql.toString());
            stmt.setString(1, companyId);
            rs = stmt.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    currencyId = rs.getString("FCurrencyID");
                    if (currencyId.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString()) || currencyId.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) continue;
                    currencySet.add(currencyId);
                }
            }
        }
        catch (SQLDataException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        }
    }

    private CasGLItemCheckRptInfo cashContrastGLForCAS(Context ctx, String companyId, AccountBankInfo acctBankInfo, String accountId, String currencyId, String periodId, JournalBalanceInfo journalBalInfo, boolean isGLStart) throws EASBizException, BOSException {
        CasGLItemCheckRptInfo rpt = null;
        BigDecimal casStartAmt = ZERO;
        BigDecimal glStartAmt = ZERO;
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectStringPK(companyId));
        companyInfo = this.getCompanyInfo(ctx, companyInfo.getId().toString());
        AccountViewInfo acctViewInfo = acctBankInfo.getAccount();
        String accountNum = acctViewInfo.getNumber();
        String bankAcctNum = acctBankInfo.getNumber();
        PeriodInfo period = this.getPeriodById(ctx, periodId);
        Date beginDate = period.getBeginDate();
        Timestamp endDate = period.getEndDate();
        PeriodInfo beginPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)beginDate, (CompanyOrgUnitInfo)companyInfo);
        PeriodInfo endPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)endDate, (CompanyOrgUnitInfo)companyInfo);
        CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectStringPK(currencyId));
        String currencyNum = currencyInfo.getNumber();
        IAsstActType asstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
        AsstActTypeInfo asstAct = null;
        if (acctViewInfo.getCAA() != null && this.isAcctHasAcctBankAssis(ctx, acctViewInfo.getId().toString())) {
            asstAct = asstActType.getAsstActType(AsstActTypeSysEnum.BANKACCOUNT);
        }
        BalanceTypeEnum beginBalType = BalanceTypeEnum.C;
        if (journalBalInfo.getMonthBalance() != null) {
            casStartAmt = journalBalInfo.getMonthBalance();
        }
        if (isGLStart) {
            glStartAmt = this.getGLAssisData(ctx, companyInfo, accountNum, bankAcctNum, currencyNum, beginPeriod, endPeriod, beginBalType, asstAct);
        }
        casStartAmt = casStartAmt.setScale(journalBalInfo.getCurrency().getPrecision(), 4);
        glStartAmt = glStartAmt.setScale(journalBalInfo.getCurrency().getPrecision(), 4);
        rpt = this.getContrastRptInfo(ctx, journalBalInfo, casStartAmt, glStartAmt);
        return rpt;
    }

    public boolean isAcctHasAcctBankAssis(Context ctx, String acctViewId) throws EASBizException, BOSException, UuidException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT T_BD_AsstActType.FRealtionDataObject AS tName, A.FID FROM T_BD_AccountView A INNER JOIN T_BD_AsstAccount ON A.FCAA = T_BD_AsstAccount.FID INNER JOIN T_BD_AsstActGroupDetail ON T_BD_AsstAccount.FID = T_BD_AsstActGroupDetail.FAsstAccountID INNER JOIN T_BD_AsstActType ON T_BD_AsstActGroupDetail.FAsstActTypeID = T_BD_AsstActType.FID  WHERE (T_BD_AsstActType.FRealtionDataObject = 'T_BD_AccountBanks') and A.fid='" + acctViewId + "'");
        IRowSet rs = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sb.toString()).executeSQL();
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private BigDecimal getGLAssisData(Context ctx, CompanyOrgUnitInfo org, String accountNum, String acctBankNum, String currencyNum, PeriodInfo beginPeriod, PeriodInfo endPeriod, BalanceTypeEnum balanceType, AsstActTypeInfo asstAct) throws BOSException, EASBizException {
        IReportCacl reportCacl = ReportCaclFactory.getLocalInstance((Context)ctx);
        if (beginPeriod == null || endPeriod == null) {
            return null;
        }
        boolean includeVoucher = true;
        boolean checkDataRight = false;
        String companyNum = org.getNumber();
        int startYear = beginPeriod.getPeriodYear();
        int startNum = beginPeriod.getPeriodNumber();
        int endYear = endPeriod.getPeriodYear();
        int endNum = endPeriod.getPeriodNumber();
        BigDecimal balance = ZERO;
        balance = asstAct != null ? reportCacl.acct(companyNum, accountNum + "|" + asstAct.getNumber() + "|" + acctBankNum, balanceType, startYear, startNum, endYear, endNum, currencyNum, false, includeVoucher, checkDataRight) : reportCacl.acct(companyNum, accountNum, balanceType, startYear, startNum, endYear, endNum, currencyNum, false, includeVoucher, checkDataRight);
        return balance == null ? ZERO : balance;
    }

    private CurrencyInfo getCurrencyById(Context ctx, String strId) throws EASBizException, BOSException {
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyInfo currency = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(strId));
        return currency;
    }

    private BigDecimal getGLBalanceCash(Context ctx, CompanyOrgUnitInfo company, CurrencyInfo currency, PeriodInfo startPeriod, AccountViewInfo accountView) throws EASBizException, BOSException {
        BigDecimal glStartAmt = null;
        IReportCacl reportCacl = ReportCaclFactory.getLocalInstance((Context)ctx);
        boolean includeVoucher = true;
        boolean checkDataRight = false;
        glStartAmt = startPeriod.isIsAdjustPeriod() ? reportCacl.acctExt(company.getNumber(), accountView.getNumber(), "", null, VoucherGetTypeEnum.C, currency.getNumber(), startPeriod.getBeginDate().toString(), startPeriod.getEndDate().toString(), includeVoucher, checkDataRight) : reportCacl.acct(company.getNumber(), accountView.getNumber(), BalanceTypeEnum.C, startPeriod.getPeriodYear(), startPeriod.getPeriodNumber(), startPeriod.getPeriodYear(), startPeriod.getPeriodNumber(), currency.getNumber(), false, includeVoucher, checkDataRight);
        return glStartAmt;
    }
}

