/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BSSourceEnum;
import com.kingdee.eas.fi.cas.BankStatementCollection;
import com.kingdee.eas.fi.cas.BankStatementFactory;
import com.kingdee.eas.fi.cas.BankStatementInfo;
import com.kingdee.eas.fi.cas.IBankStatement;
import com.kingdee.eas.fi.cas.app.AbstractEnterpriseUnreachedWebFacadeControllerBean;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.utils.CashMgtInitFetchParam;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class EnterpriseUnreachedWebFacadeControllerBean
extends AbstractEnterpriseUnreachedWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.EnterpriseUnreachedWebFacadeControllerBean");

    @Override
    protected Map _initPageData(Context ctx, String companyId, String accountBankId, String currencyId, String accountViewId) throws BOSException, EASBizException {
        Date beginDate = null;
        PeriodInfo startPeriodInfo = null;
        Map initParam = this.initParam(ctx, companyId);
        startPeriodInfo = (PeriodInfo)initParam.get("startPeriod");
        beginDate = startPeriodInfo.getBeginDate();
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(this.getFilterInfo(beginDate, accountBankId, currencyId, accountViewId, companyId));
        viewInfo.getSelector().addObjectCollection((IObjectCollection)this.getSelectors());
        HashMap<String, Object> initData = new HashMap<String, Object>();
        try {
            BankStatementCollection bankStatements = BankStatementFactory.getLocalInstance(ctx).getBankStatementCollection(viewInfo);
            initData.put("bankStatementDatas", (Object)bankStatements);
            AccountBankInfo acctBank = this.getAccountBankInfo(ctx, accountBankId);
            acctBank.setName(acctBank.getName() + " " + acctBank.getBankAccountNumber());
            initData.put("shareType", acctBank.getShareType().getValue());
            initData.put("bankAccount", acctBank);
            initData.put("accountView", acctBank.getAccount());
            String[] args = new String[]{String.valueOf(startPeriodInfo.getPeriodYear()), String.valueOf(startPeriodInfo.getPeriodNumber())};
            MessageFormat mf = new MessageFormat(EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period", (Locale)ctx.getLocale()));
            String startPeriod = mf.format(args);
            initData.put("startPeriod", startPeriod);
            CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
            initData.put("precision", currencyInfo.getPrecision());
            initData.put("currency", currencyInfo);
            initData.put("companyId", companyId);
            initData.put("firstDayOfPeriod", beginDate);
            initData.put("beforefirstDayOfPeriod", new Date(beginDate.getTime() - 86400000L));
            CompanyOrgUnitInfo companyInfo = this.getCompanyById(ctx, companyId);
            StringBuffer summaryInfo = new StringBuffer();
            summaryInfo.append(CASWebUtil.getResource(ctx, "150_LBL_COMPANY")).append(companyInfo.getName()).append("&nbsp;&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;");
            summaryInfo.append(CASWebUtil.getResource(ctx, "151_LBL_PERIOD")).append(startPeriod).append("&nbsp;&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;");
            summaryInfo.append(CASWebUtil.getResource(ctx, "152_LBL_ACCOUNTBANK")).append(acctBank.getName()).append("&nbsp;&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;");
            summaryInfo.append(CASWebUtil.getResource(ctx, "153_LBL_ACCOUNTVIEW")).append(acctBank.getAccount().toString()).append("&nbsp;&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;");
            summaryInfo.append(CASWebUtil.getResource(ctx, "154_LBL_CURRENCY")).append(currencyInfo.getName());
            initData.put("summaryInfo", summaryInfo.toString());
        }
        catch (BOSException e) {
            throw new RuntimeException(e);
        }
        catch (EASBizException e) {
            throw new RuntimeException(e);
        }
        catch (UuidException e) {
            throw new RuntimeException(e);
        }
        return initData;
    }

    private AccountBankInfo getAccountBankInfo(Context ctx, String bankAccountId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("account.name"));
        sic.add(new SelectorItemInfo("account.number"));
        sic.add(new SelectorItemInfo("account.acctName"));
        sic.add(new SelectorItemInfo("account.bankAccountNumber"));
        AccountBankInfo acctBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)bankAccountId)), sic);
        return acctBank;
    }

    @Override
    protected Map _save(Context ctx, String changeData, String companyId, String accountBankId, String currencyId, String accountViewId) throws BOSException, EASBizException {
        HashMap modelMap = null;
        try {
            modelMap = JSONUtils.convertJsonToObject((Context)ctx, (String)changeData);
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        List modifiedRecord = (List)modelMap.get("modifiedRecord");
        List deleteRecord = (List)modelMap.get("deleteRecord");
        CoreBaseCollection updateCollection = new CoreBaseCollection();
        CoreBaseCollection addCollection = new CoreBaseCollection();
        for (int i = 0; i < modifiedRecord.size(); ++i) {
            Map rowData = (Map)modifiedRecord.get(i);
            BankStatementInfo bankStatementInfo = this.convertBankStatementInfo(rowData);
            if (bankStatementInfo.get("id") == null) {
                bankStatementInfo = this.initBankStatementDefaultInfo(bankStatementInfo, accountBankId, currencyId, accountViewId, companyId);
                addCollection.add((CoreBaseInfo)bankStatementInfo);
                continue;
            }
            updateCollection.add((CoreBaseInfo)bankStatementInfo);
        }
        ArrayList<ObjectUuidPK> arrayPK = new ArrayList<ObjectUuidPK>();
        for (int i = 0; i < deleteRecord.size(); ++i) {
            Map rowData = (Map)deleteRecord.get(i);
            String id = (String)rowData.get("id");
            if (id == null || id.equals("")) continue;
            arrayPK.add(new ObjectUuidPK(id));
        }
        IObjectPK[] deletedArrayPK = new IObjectPK[arrayPK.size()];
        for (int i = 0; i < deletedArrayPK.length; ++i) {
            deletedArrayPK[i] = (IObjectPK)arrayPK.get(i);
        }
        try {
            IBankStatement bankStatementMgr = BankStatementFactory.getLocalInstance(ctx);
            if (deletedArrayPK.length > 0) {
                bankStatementMgr.deleteBatchData(deletedArrayPK);
            }
            if (addCollection.size() > 0) {
                bankStatementMgr.addnew(addCollection);
            }
            if (updateCollection.size() > 0) {
                for (int i = 0; i < updateCollection.size(); ++i) {
                    bankStatementMgr.updatePartial(updateCollection.get(i), this.getSelectors());
                }
            }
        }
        catch (BOSException e) {
            throw new RuntimeException(e);
        }
        catch (EASBizException e) {
            throw new RuntimeException(e);
        }
        return new HashMap();
    }

    private BankStatementInfo convertBankStatementInfo(Map rowData) {
        BankStatementInfo bankStatement = new BankStatementInfo();
        if (((String)rowData.get("id")).length() > 10) {
            bankStatement.setId(BOSUuid.read((String)rowData.get("id").toString()));
        } else {
            bankStatement.setId(null);
        }
        if (rowData.get("createDate") != null && "" != rowData.get("createDate")) {
            bankStatement.setCreateDate(this.dateFormat(rowData.get("createDate").toString()));
        }
        if (rowData.get("settleType") != null && "" != rowData.get("settleType")) {
            SettlementTypeInfo settleType = new SettlementTypeInfo();
            settleType.setId(BOSUuid.read((String)((String)((Map)rowData.get("settleType")).get("id"))));
            bankStatement.setSettleType(settleType);
        }
        if (rowData.get("settleNumber") != null && "" != rowData.get("settleNumber")) {
            bankStatement.setSettleNumber((String)rowData.get("settleNumber"));
        }
        if (rowData.get("debitAmount") != null && "" != rowData.get("debitAmount")) {
            bankStatement.setDebitAmount(BigDecimal.valueOf(Double.valueOf(rowData.get("debitAmount").toString())));
        } else {
            bankStatement.setDebitAmount(BigDecimal.ZERO);
        }
        if (rowData.get("creditAmount") != null && "" != rowData.get("creditAmount")) {
            bankStatement.setCreditAmount(BigDecimal.valueOf(Double.valueOf(rowData.get("creditAmount").toString())));
        } else {
            bankStatement.setCreditAmount(BigDecimal.ZERO);
        }
        if (bankStatement.getDebitAmount() != null && bankStatement.getDebitAmount().signum() > 0) {
            bankStatement.setIsDebit(true);
        } else {
            bankStatement.setIsDebit(false);
        }
        if (rowData.get("description") != null && "" != rowData.get("description")) {
            bankStatement.setDescription((String)rowData.get("description"));
        }
        return bankStatement;
    }

    private BankStatementInfo initBankStatementDefaultInfo(BankStatementInfo bankStatement, String bankAccountId, String currencyId, String accountViewId, String companyId) {
        if (bankStatement.getDebitAmount().signum() > 0) {
            bankStatement.setIsDebit(true);
        } else {
            bankStatement.setIsDebit(false);
        }
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        bankStatement.setCompany(company);
        CurrencyInfo currency = new CurrencyInfo();
        currency.setId(BOSUuid.read((String)currencyId));
        bankStatement.setCurrency(currency);
        AccountBankInfo abInfo = new AccountBankInfo();
        abInfo.setId(BOSUuid.read((String)bankAccountId));
        bankStatement.setAccountBank(abInfo);
        AccountViewInfo viewInfo = new AccountViewInfo();
        viewInfo.setId(BOSUuid.read((String)accountViewId));
        bankStatement.setAccountView(viewInfo);
        bankStatement.setVerifyStatus(VerifyScopeEnum.NOVA);
        bankStatement.setSource(BSSourceEnum.MANUAL);
        return bankStatement;
    }

    protected FilterInfo getFilterInfo(Date beginDate, String bankAccount, String currencyId, String accountViewId, String companyId) {
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        FilterItemInfo createDateCond = new FilterItemInfo("createDate", (Object)beginDate, CompareType.LESS);
        FilterItemInfo accountViewCond = new FilterItemInfo("accountView.id", (Object)accountViewId);
        FilterItemInfo currencyCond = new FilterItemInfo("currency.id", (Object)currencyId);
        FilterItemInfo accountBankCond = new FilterItemInfo("accountBank.id", (Object)bankAccount);
        FilterItemInfo companyCond = new FilterItemInfo("company.id", (Object)companyId);
        fic.add(createDateCond);
        fic.add(accountViewCond);
        fic.add(currencyCond);
        fic.add(accountBankCond);
        fic.add(companyCond);
        return fi;
    }

    protected SelectorItemCollection getSelectors() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("createDate");
        selectors.add("description");
        selectors.add("settleType");
        selectors.add("settleType.name");
        selectors.add("settleNumber");
        selectors.add("debitAmount");
        selectors.add("creditAmount");
        selectors.add("creditAmount");
        selectors.add("verifyStatus");
        selectors.add("shareType");
        return selectors;
    }

    public CompanyOrgUnitInfo getCompanyById(Context ctx, String companyId) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = null;
        if (companyId != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("baseCurrency.*"));
            sic.add(new SelectorItemInfo("accountTable.id"));
            sic.add(new SelectorItemInfo("accountTable.name"));
            sic.add(new SelectorItemInfo("accountTable.number"));
            companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), sic);
        }
        return companyInfo;
    }

    private Map initParam(Context ctx, String companyId) {
        try {
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            company.setId(BOSUuid.read((String)companyId));
            Map param = CashMgtInitFetchParam.fetchParam(ctx, company);
            return param;
        }
        catch (EASBizException e1) {
            throw new RuntimeException(e1);
        }
        catch (BOSException e1) {
            throw new RuntimeException(e1);
        }
    }

    private Date dateFormat(String dateString) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return dateFormat.parse(dateString);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }
}

