/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.FeeTypeFactory;
import com.kingdee.eas.fi.cas.FeeTypeInfo;
import com.kingdee.eas.fi.cas.IFeeType;
import com.kingdee.eas.fi.cas.app.AbstractFeeTypeWebFacadeControllerBean;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.utils.FeetypeHelper;
import com.kingdee.eas.fi.cas.vo.FeeTypeVO;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.IDataBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class FeeTypeWebFacadeControllerBean
extends AbstractFeeTypeWebFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.FeeTypeWebFacadeControllerBean");
    private static String PERMITEM_FEETYPE_DELETE = "cas_feetype_delete";
    private static String PERMITEM_FEETYPE_EDIT = "cas_feetype_edit";
    private static String PERMITEM_FEETYPE_VIEW = "cas_feetype_view";

    @Override
    protected Map _saveFeeType(Context ctx, String jsonstr) throws BOSException, EASBizException {
        HashMap<String, String> rstData = new HashMap<String, String>();
        FeeTypeVO dataVO = (FeeTypeVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr, FeeTypeVO.class);
        if (dataVO == null) {
            rstData.put("MsgStr", CASWebUtil.getResource(ctx, "InputDataExption"));
            return rstData;
        }
        FeeTypeInfo feeTypeInfo = FeetypeHelper.getInstance().VOToInfo(ctx, dataVO);
        IFeeType iFeeType = FeeTypeFactory.getLocalInstance((Context)ctx);
        IObjectPK rstID = null;
        try {
            boolean isPermission;
            boolean bl = isPermission = CASWebHelper.getAuthorizedOrg(ctx, PERMITEM_FEETYPE_EDIT, false).size() > 0;
            if (!isPermission) {
                if (feeTypeInfo.getId() == null) {
                    throw new CasWebException(CasWebException.NO_ADDNEW_AUTHRIZED);
                }
                throw new CasWebException(CasWebException.NO_EDIT_AUTHRIZED);
            }
            rstID = iFeeType.submit((CoreBaseInfo)feeTypeInfo);
        }
        catch (EASBizException e1) {
            rstData.put("MsgStr", e1.getMessage(ctx.getLocale()));
            e1.printStackTrace();
            logger.debug((Object)e1);
            return rstData;
        }
        catch (BOSException e2) {
            rstData.put("MsgStr", e2.getMessage());
            e2.printStackTrace();
            logger.debug((Object)e2);
            return rstData;
        }
        if (rstID != null) {
            rstData.put("MsgStr", CASWebHelper.getCASMsg(ctx, "SAVE_Successfully"));
            rstData.put("OPStatus", "success");
            rstData.put("IdAfterSave", (String)rstID);
        }
        return rstData;
    }

    @Override
    protected Map _deleteFeeType(Context ctx, String jsonstr) throws BOSException, EASBizException {
        HashMap<String, Object> rstData = new HashMap<String, Object>();
        FeeTypeVO dataVO = (FeeTypeVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr, FeeTypeVO.class);
        if (dataVO == null) {
            rstData.put("MsgStr", CASWebUtil.getResource(ctx, "InputDataExption"));
            return rstData;
        }
        if (dataVO.getDeleteIDs() == null || dataVO.getDeleteIDs().length <= 0) {
            rstData.put("MsgStr", CASWebUtil.getResource(ctx, "PleSelectedDeleteRow"));
            return rstData;
        }
        IFeeType iFeeType = FeeTypeFactory.getLocalInstance((Context)ctx);
        try {
            boolean isPermission;
            boolean bl = isPermission = CASWebHelper.getAuthorizedOrg(ctx, PERMITEM_FEETYPE_DELETE, false).size() > 0;
            if (!isPermission) {
                throw new CasWebException(CasWebException.NO_DELETE_AUTHRIZED);
            }
            int lens = dataVO.getDeleteIDs().length;
            ArrayList<ObjectUuidPK> sucPKList = new ArrayList<ObjectUuidPK>();
            StringBuffer errorMsg = new StringBuffer();
            ArrayList<String> errorMsgList = new ArrayList<String>();
            ObjectUuidPK delPK = null;
            for (int idx = 0; idx < lens; ++idx) {
                delPK = new ObjectUuidPK(dataVO.getDeleteIDs()[idx]);
                IObjectPK[] pkArray = new IObjectPK[]{delPK};
                try {
                    FeetypeHelper.getInstance().isReferenced((IDataBase)iFeeType, pkArray, ctx);
                    iFeeType.delete((IObjectPK)delPK);
                    sucPKList.add(delPK);
                    continue;
                }
                catch (EASBizException ee) {
                    errorMsg.append(ee.getMessage(ctx.getLocale()));
                    errorMsgList.add(ee.getMessage(ctx.getLocale()));
                }
            }
            int sucDelCount = sucPKList.size();
            if (errorMsg.length() > 0) {
                String[] args = new String[]{String.valueOf(sucDelCount), String.valueOf(lens - sucDelCount)};
                String opHeadMsg = CASWebUtil.getResource(ctx, "DELETE_RESULT", args);
                rstData.put("MsgStr", opHeadMsg);
                rstData.put("MsgDetail", errorMsg.toString());
                rstData.put("OPStatus", "success");
                rstData.put("DeleteSuccessCount", sucDelCount);
                rstData.put("errorMsgList", errorMsgList);
                return rstData;
            }
        }
        catch (EASBizException e1) {
            rstData.put("MsgStr", e1.getMessage(ctx.getLocale()));
            e1.printStackTrace();
            logger.debug((Object)e1);
            return rstData;
        }
        catch (BOSException e2) {
            rstData.put("MsgStr", e2.getMessage());
            e2.printStackTrace();
            logger.debug((Object)e2);
            return rstData;
        }
        rstData.put("MsgStr", CASWebUtil.getResource(ctx, "DeletedOK"));
        rstData.put("OPStatus", "success");
        return rstData;
    }
}

