/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.CasRecPayFetchParamHelperBase;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FetchParamCasPaymentAddBatchEditUI
extends CasRecPayFetchParamHelperBase {
    @Override
    public Map fetchParam(Context ctx, Map paramMap) throws BOSException, EASBizException {
        if ((paramMap = super.fetchParam(ctx, paramMap)) == null || paramMap.isEmpty()) {
            throw new EASBizException(null, (Throwable)new NullPointerException());
        }
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        iPermission.checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(this.currentCompany.getId().toString()), (String)paramMap.get("permissionItem"));
        Set paramSet = paramMap.keySet();
        Iterator iterator = paramSet.iterator();
        HashMap map = new HashMap();
        while (iterator.hasNext()) {
            String name = iterator.next().toString();
            this.fillParamMapByParamName(map, name);
        }
        paramMap.putAll(map);
        return paramMap;
    }

    private void fillParamMapByParamName(Map paramMap, String name) throws BOSException, EASBizException {
        if ("defaultBillType".equals(name)) {
            paramMap.put("defaultBillType", this.getDefaultBillType_PaymentBill());
        } else if ("defaultAsstActType".equals(name)) {
            AsstActTypeInfo info = this.getDefaultAsstActType(this.currentCompany.getId().toString(), true, false);
            if (info == null) {
                paramMap.put("defaultAsstActType", "NULL");
            } else {
                paramMap.put("defaultAsstActType", info);
            }
        } else if ("asstActTypeCollection".equals(name)) {
            paramMap.put("asstActTypeCollection", this.getAsstActTypeColl(this.currentCompany.getId().toString(), false, false));
        } else if ("currentPeriond".equals(name)) {
            paramMap.put("currentPeriond", this.getCurrentPeriond(this.currentCompany));
        } else if ("currencyCollection".equals(name)) {
            paramMap.put("currencyCollection", this.getCurrencyCollection());
        } else if ("permissionItem".equals(name)) {
            paramMap.put("UserOrgRanges", FMHelper.getUserOrgRangesWithRange((Context)this.ctx, (String)((String)paramMap.get("permissionItem"))));
        } else if ("ID".equals(name)) {
            if (paramMap.get("ID") != null) {
                paramMap.put("srcAgentPayInfo", this.getSrcAgentPayBillInfo(paramMap.get("ID").toString()));
            }
        } else if ("CS053".equals(name)) {
            if (paramMap.get("CS053") == null) {
                return;
            }
            int val = Integer.parseInt((String)paramMap.get("CS053"));
            paramMap.put("isSubmitCtrlOverDraft", val == 1);
        } else if ("hasNumber".equals(name)) {
            PaymentBillInfo paymentBill = new PaymentBillInfo();
            paymentBill.setCompany(this.currentCompany);
            paymentBill.setBizDate(DateUtil.getDayBegin());
            paymentBill.setSourceType(SourceTypeEnum.CASH);
            boolean hasNumber = this.hasNumber(this.ctx, (CoreBaseInfo)paymentBill, this.currentCompany.getId().toString());
            paramMap.put("hasNumber", hasNumber);
            if (hasNumber) {
                paramMap.put("codingRuleNumber", this.getDispNumber(this.ctx, (CoreBaseInfo)paymentBill, this.currentCompany.getId().toString()));
                paramMap.put("isModifiable", new Boolean(this.isModifiable((CoreBaseInfo)paymentBill, this.currentCompany.getId().toString())));
            }
        }
    }

    private PaymentBillInfo getSrcAgentPayBillInfo(String id) throws BOSException, EASBizException {
        boolean isExist = PaymentBillFactory.getLocalInstance(this.ctx).exists((IObjectPK)new ObjectUuidPK(id));
        if (EmptyUtil.isEmpty((String)id) || !isExist) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        PaymentBillInfo agentPayBill = PaymentBillFactory.getLocalInstance(this.ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        String srcAgentPayBillID = agentPayBill.getSrcAgenPaymentBillID();
        if (EmptyUtil.isEmpty((String)srcAgentPayBillID)) {
            return null;
        }
        PaymentBillInfo srcAgentPayBill = PaymentBillFactory.getLocalInstance(this.ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(srcAgentPayBillID));
        return srcAgentPayBill;
    }
}

